(function() {
  "use strict";
  String.prototype.getQueryString = function(name2, split) {
    if (split == void 0)
      split = "&";
    var rule2 = "(^|" + split + "|\\?)" + name2 + "=([^" + split + "#]*)(" + split + "|#|$)";
    var reg = new RegExp(rule2), r2;
    if (r2 = this.match(reg))
      return decodeURI(r2[2]);
    return null;
  };
  String.prototype.sizeToNumber = function() {
    let _size_raw_match = this.match(
      /^(\d*\.?\d+)(.*[^ZEPTGMK])?([ZEPTGMK](B|iB))$/i
    );
    if (_size_raw_match) {
      let _size_num = parseFloat(_size_raw_match[1]);
      let _size_type = _size_raw_match[3];
      switch (true) {
        case /Zi?B/i.test(_size_type):
          return _size_num * Math.pow(2, 70);
        case /Ei?B/i.test(_size_type):
          return _size_num * Math.pow(2, 60);
        case /Pi?B/i.test(_size_type):
          return _size_num * Math.pow(2, 50);
        case /Ti?B/i.test(_size_type):
          return _size_num * Math.pow(2, 40);
        case /Gi?B/i.test(_size_type):
          return _size_num * Math.pow(2, 30);
        case /Mi?B/i.test(_size_type):
          return _size_num * Math.pow(2, 20);
        case /Ki?B/i.test(_size_type):
          return _size_num * Math.pow(2, 10);
        default:
          return _size_num;
      }
    }
    return 0;
  };
  String.prototype.timeToDays = function() {
    let t2 = this.replace(/weeks/ig, "W").replace(/days/ig, "D").replace(/months/ig, "M").replace(/years/ig, "Y").replace(/hours/ig, "H").replace(/\s+/g, "");
    const timeMatch = t2.match(/\d+[天日周月年时DWMYH]/g);
    let length = 0;
    if (timeMatch == null)
      return 0;
    timeMatch.forEach((time) => {
      const timeMatch2 = time.match(/(\d+)([天日周月年时DWMYH])/);
      if (timeMatch2 == null)
        return 0;
      const number = parseInt(timeMatch2[1]);
      const unit = timeMatch2[2];
      switch (true) {
        case unit === "D":
        case unit === "天":
        case unit === "日":
          length += number;
          break;
        case unit === "W":
        case unit === "周":
          length += number * 7;
          break;
        case unit === "M":
        case unit === "月":
          length += number * 30;
          break;
        case unit === "Y":
        case unit === "年":
          length += number * 365;
          break;
        case unit === "H":
        case unit === "时":
          length += Math.floor(number / 24);
          break;
        default:
      }
    });
    return length;
  };
  var ESizeUnit = /* @__PURE__ */ ((ESizeUnit2) => {
    ESizeUnit2["ZiB"] = "ZiB";
    ESizeUnit2["EiB"] = "EiB";
    ESizeUnit2["PiB"] = "PiB";
    ESizeUnit2["TiB"] = "TiB";
    ESizeUnit2["GiB"] = "GiB";
    ESizeUnit2["MiB"] = "MiB";
    ESizeUnit2["KiB"] = "KiB";
    return ESizeUnit2;
  })(ESizeUnit || {});
  var ERequestType = /* @__PURE__ */ ((ERequestType2) => {
    ERequestType2["JSON"] = "json";
    ERequestType2["TEXT"] = "urlencode";
    return ERequestType2;
  })(ERequestType || {});
  var ERequestResultType = /* @__PURE__ */ ((ERequestResultType2) => {
    ERequestResultType2["JSON"] = "json";
    ERequestResultType2["XML"] = "xml";
    ERequestResultType2["HTML"] = "html";
    ERequestResultType2["TEXT"] = "text";
    return ERequestResultType2;
  })(ERequestResultType || {});
  var EDownloadClientType = /* @__PURE__ */ ((EDownloadClientType2) => {
    EDownloadClientType2["transmission"] = "transmission";
    EDownloadClientType2["utorrent"] = "utorrent";
    EDownloadClientType2["deluge"] = "deluge";
    EDownloadClientType2["synologyDownloadStation"] = "synologyDownloadStation";
    EDownloadClientType2["rutorrent"] = "rutorrent";
    EDownloadClientType2["qbittorrent"] = "qbittorrent";
    return EDownloadClientType2;
  })(EDownloadClientType || {});
  var EButtonType = /* @__PURE__ */ ((EButtonType2) => {
    EButtonType2["normal"] = "normal";
    EButtonType2["label"] = "label";
    EButtonType2["spliter"] = "spliter";
    EButtonType2["popup"] = "popup";
    return EButtonType2;
  })(EButtonType || {});
  var ERequestMethod = /* @__PURE__ */ ((ERequestMethod2) => {
    ERequestMethod2["POST"] = "POST";
    ERequestMethod2["GET"] = "GET";
    return ERequestMethod2;
  })(ERequestMethod || {});
  var EAction = /* @__PURE__ */ ((EAction2) => {
    EAction2["readConfig"] = "readConfig";
    EAction2["saveConfig"] = "saveConfig";
    EAction2["reloadConfig"] = "reloadConfig";
    EAction2["sendTorrentToDefaultClient"] = "sendTorrentToDefaultClient";
    EAction2["sendTorrentToClient"] = "sendTorrentToClient";
    EAction2["searchTorrent"] = "searchTorrent";
    EAction2["copyTextToClipboard"] = "copyTextToClipboard";
    EAction2["addTorrentFromURL"] = "addTorrentFromURL";
    EAction2["getFreeSpace"] = "getFreeSpace";
    EAction2["downloadFromDroper"] = "downloadFromDroper";
    EAction2["openOptions"] = "openOptions";
    EAction2["updateOptionsTabId"] = "updateOptionsTabId";
    EAction2["getSearchResult"] = "getSearchResult";
    EAction2["getDownloadHistory"] = "getDownloadHistory";
    EAction2["removeDownloadHistory"] = "removeDownloadHistory";
    EAction2["clearDownloadHistory"] = "clearDownloadHistory";
    EAction2["testClientConnectivity"] = "testClientConnectivity";
    EAction2["getSystemLogs"] = "getSystemLogs";
    EAction2["removeSystemLogs"] = "removeSystemLogs";
    EAction2["clearSystemLogs"] = "clearSystemLogs";
    EAction2["readUIOptions"] = "readUIOptions";
    EAction2["saveUIOptions"] = "saveUIOptions";
    EAction2["showMessage"] = "showMessage";
    EAction2["writeLog"] = "writeLog";
    EAction2["serviceStoped"] = "serviceStoped";
    EAction2["addContentPage"] = "addContentPage";
    EAction2["abortSearch"] = "abortSearch";
    EAction2["backupToGoogle"] = "backupToGoogle";
    EAction2["restoreFromGoogle"] = "restoreFromGoogle";
    EAction2["clearFromGoogle"] = "clearFromGoogle";
    EAction2["getTorrentDataFromURL"] = "getTorrentDataFromURL";
    EAction2["getUserInfo"] = "getUserInfo";
    EAction2["abortGetUserInfo"] = "abortGetUserInfo";
    EAction2["refreshUserData"] = "refreshUserData";
    EAction2["getClearedOptions"] = "getClearedOptions";
    EAction2["resetRunTimeOptions"] = "resetRunTimeOptions";
    EAction2["getBase64FromImageUrl"] = "getBase64FromImageUrl";
    EAction2["getUserHistoryData"] = "getUserHistoryData";
    EAction2["getMovieInfos"] = "getMovieInfos";
    EAction2["getMovieRatings"] = "getMovieRatings";
    EAction2["getIMDbIdFromDouban"] = "getIMDbIdFromDouban";
    EAction2["queryMovieInfoFromDouban"] = "queryMovieInfoFromDouban";
    EAction2["addBrowserDownloads"] = "addBrowserDownloads";
    EAction2["checkPermissions"] = "checkPermissions";
    EAction2["requestPermissions"] = "requestPermissions";
    EAction2["changeLanguage"] = "changeLanguage";
    EAction2["getCurrentLanguageResource"] = "getCurrentLanguageResource";
    EAction2["addLanguage"] = "addLanguage";
    EAction2["replaceLanguage"] = "replaceLanguage";
    EAction2["hideMessage"] = "hideMessage";
    EAction2["resetUserDatas"] = "resetUserDatas";
    EAction2["backupToServer"] = "backupToServer";
    EAction2["restoreFromServer"] = "restoreFromServer";
    EAction2["getBackupListFromServer"] = "getBackupListFromServer";
    EAction2["deleteFileFromBackupServer"] = "deleteFileFromBackupServer";
    EAction2["sendTorrentsInBackground"] = "sendTorrentsInBackground";
    EAction2["createBackupFile"] = "createBackupFile";
    EAction2["checkBackupData"] = "checkBackupData";
    EAction2["addTorrentToCollection"] = "addTorrentToCollection";
    EAction2["getTorrentCollections"] = "getTorrentCollections";
    EAction2["deleteTorrentFromCollention"] = "deleteTorrentFromCollention";
    EAction2["clearTorrentCollention"] = "clearTorrentCollention";
    EAction2["getTorrentCollention"] = "getTorrentCollention";
    EAction2["getSiteSelectorConfig"] = "getSiteSelectorConfig";
    EAction2["resetTorrentCollections"] = "resetTorrentCollections";
    EAction2["getTorrentCollectionGroups"] = "getTorrentCollectionGroups";
    EAction2["addTorrentCollectionGroup"] = "addTorrentCollectionGroup";
    EAction2["addTorrentCollectionToGroup"] = "addTorrentCollectionToGroup";
    EAction2["updateTorrentCollectionGroup"] = "updateTorrentCollectionGroup";
    EAction2["removeTorrentCollectionFromGroup"] = "removeTorrentCollectionFromGroup";
    EAction2["removeTorrentCollectionGroup"] = "removeTorrentCollectionGroup";
    EAction2["updateTorrentCollention"] = "updateTorrentCollention";
    EAction2["getAllTorrentCollectionLinks"] = "getAllTorrentCollectionLinks";
    EAction2["restoreCookies"] = "restoreCookies";
    EAction2["resetFavicons"] = "resetFavicons";
    EAction2["resetFavicon"] = "resetFavicon";
    EAction2["getBackupRawData"] = "getBackupRawData";
    EAction2["testBackupServerConnectivity"] = "testBackupServerConnectivity";
    EAction2["createSearchResultSnapshot"] = "createSearchResultSnapshot";
    EAction2["loadSearchResultSnapshot"] = "loadSearchResultSnapshot";
    EAction2["getSearchResultSnapshot"] = "getSearchResultSnapshot";
    EAction2["removeSearchResultSnapshot"] = "removeSearchResultSnapshot";
    EAction2["clearSearchResultSnapshot"] = "clearSearchResultSnapshot";
    EAction2["resetSearchResultSnapshot"] = "resetSearchResultSnapshot";
    EAction2["createKeepUploadTask"] = "createKeepUploadTask";
    EAction2["loadKeepUploadTask"] = "loadKeepUploadTask";
    EAction2["getKeepUploadTask"] = "getKeepUploadTask";
    EAction2["removeKeepUploadTask"] = "removeKeepUploadTask";
    EAction2["clearKeepUploadTask"] = "clearKeepUploadTask";
    EAction2["resetKeepUploadTask"] = "resetKeepUploadTask";
    EAction2["updateKeepUploadTask"] = "updateKeepUploadTask";
    EAction2["resetDownloadHistory"] = "resetDownloadHistory";
    EAction2["pushDebugMsg"] = "pushDebugMsg";
    EAction2["updateDebuggerTabId"] = "updateDebuggerTabId";
    EAction2["getTopSearches"] = "getTopSearches";
    return EAction2;
  })(EAction || {});
  var EStorageType = /* @__PURE__ */ ((EStorageType2) => {
    EStorageType2["text"] = "TEXT";
    EStorageType2["json"] = "JSON";
    return EStorageType2;
  })(EStorageType || {});
  var EConfigKey = /* @__PURE__ */ ((EConfigKey2) => {
    EConfigKey2["default"] = "PT-Plugin-Plus-Config";
    EConfigKey2["downloadHistory"] = "PT-Plugin-Plus-downloadHistory";
    EConfigKey2["systemLogs"] = "PT-Plugin-Plus-systemLogs";
    EConfigKey2["uiOptions"] = "PT-Plugin-Plus-uiOptions";
    EConfigKey2["cache"] = "PT-Plugin-Plus-Cache-Contents";
    EConfigKey2["userDatas"] = "PT-Plugin-Plus-User-Datas";
    EConfigKey2["collection"] = "PT-Plugin-Plus-Collection";
    EConfigKey2["searchResultSnapshot"] = "PT-Plugin-Plus-SearchResultSnapshot";
    EConfigKey2["keepUploadTask"] = "PT-Plugin-Plus-KeepUploadTask";
    return EConfigKey2;
  })(EConfigKey || {});
  var EDataResultType = /* @__PURE__ */ ((EDataResultType2) => {
    EDataResultType2["success"] = "success";
    EDataResultType2["error"] = "error";
    EDataResultType2["info"] = "info";
    EDataResultType2["warning"] = "warning";
    EDataResultType2["unknown"] = "unknown";
    return EDataResultType2;
  })(EDataResultType || {});
  var EModule = /* @__PURE__ */ ((EModule2) => {
    EModule2["background"] = "background";
    EModule2["content"] = "content";
    EModule2["options"] = "options";
    EModule2["popup"] = "popup";
    EModule2["debugger"] = "debugger";
    return EModule2;
  })(EModule || {});
  var ELogEvent = /* @__PURE__ */ ((ELogEvent2) => {
    ELogEvent2["init"] = "init";
    ELogEvent2["requestMessage"] = "requestMessage";
    return ELogEvent2;
  })(ELogEvent || {});
  var EPaginationKey = /* @__PURE__ */ ((EPaginationKey2) => {
    EPaginationKey2["systemLogs"] = "systemLogs";
    EPaginationKey2["searchTorrent"] = "searchTorrent";
    return EPaginationKey2;
  })(EPaginationKey || {});
  var EViewKey = /* @__PURE__ */ ((EViewKey2) => {
    EViewKey2["home"] = "home";
    EViewKey2["downloadPaths"] = "downloadPaths";
    EViewKey2["searchTorrent"] = "searchTorrent";
    return EViewKey2;
  })(EViewKey || {});
  var EUserDataRange = /* @__PURE__ */ ((EUserDataRange2) => {
    EUserDataRange2["latest"] = "latest";
    EUserDataRange2["today"] = "today";
    EUserDataRange2["all"] = "all";
    return EUserDataRange2;
  })(EUserDataRange || {});
  var EUserDataRequestStatus = /* @__PURE__ */ ((EUserDataRequestStatus2) => {
    EUserDataRequestStatus2["needLogin"] = "needLogin";
    EUserDataRequestStatus2["notSupported"] = "notSupported";
    EUserDataRequestStatus2["unknown"] = "unknown";
    EUserDataRequestStatus2["success"] = "success";
    return EUserDataRequestStatus2;
  })(EUserDataRequestStatus || {});
  var ECommonKey = /* @__PURE__ */ ((ECommonKey2) => {
    ECommonKey2["allSite"] = "__allSite__";
    ECommonKey2["all"] = "__all__";
    ECommonKey2["noGroup"] = "__noGroup__";
    return ECommonKey2;
  })(ECommonKey || {});
  var EInstallType = /* @__PURE__ */ ((EInstallType2) => {
    EInstallType2["development"] = "development";
    EInstallType2["normal"] = "normal";
    EInstallType2["crx"] = "crx";
    return EInstallType2;
  })(EInstallType || {});
  var EBeforeSearchingItemSearchMode = /* @__PURE__ */ ((EBeforeSearchingItemSearchMode2) => {
    EBeforeSearchingItemSearchMode2["id"] = "id";
    EBeforeSearchingItemSearchMode2["name"] = "name";
    return EBeforeSearchingItemSearchMode2;
  })(EBeforeSearchingItemSearchMode || {});
  var ETorrentStatus = /* @__PURE__ */ ((ETorrentStatus2) => {
    ETorrentStatus2[ETorrentStatus2["downloading"] = 1] = "downloading";
    ETorrentStatus2[ETorrentStatus2["sending"] = 2] = "sending";
    ETorrentStatus2[ETorrentStatus2["completed"] = 255] = "completed";
    ETorrentStatus2[ETorrentStatus2["inactive"] = 3] = "inactive";
    return ETorrentStatus2;
  })(ETorrentStatus || {});
  var EBackupServerType = /* @__PURE__ */ ((EBackupServerType2) => {
    EBackupServerType2["OWSS"] = "OWSS";
    EBackupServerType2["WebDAV"] = "WebDAV";
    return EBackupServerType2;
  })(EBackupServerType || {});
  var EPluginPosition = /* @__PURE__ */ ((EPluginPosition2) => {
    EPluginPosition2["left"] = "left";
    EPluginPosition2["right"] = "right";
    return EPluginPosition2;
  })(EPluginPosition || {});
  var EWikiLink = /* @__PURE__ */ ((EWikiLink2) => {
    EWikiLink2["faq"] = "https://github.com/pt-plugins/PT-Plugin-Plus/wiki/frequently-asked-questions";
    return EWikiLink2;
  })(EWikiLink || {});
  var ERestoreContent = /* @__PURE__ */ ((ERestoreContent2) => {
    ERestoreContent2["all"] = "all";
    ERestoreContent2["options"] = "options";
    ERestoreContent2["userDatas"] = "userDatas";
    ERestoreContent2["collection"] = "collection";
    ERestoreContent2["cookies"] = "cookies";
    ERestoreContent2["searchResultSnapshot"] = "searchResultSnapshot";
    ERestoreContent2["keepUploadTask"] = "keepUploadTask";
    ERestoreContent2["downloadHistory"] = "downloadHistory";
    return ERestoreContent2;
  })(ERestoreContent || {});
  var EBrowserType = /* @__PURE__ */ ((EBrowserType2) => {
    EBrowserType2["Chrome"] = "Chrome";
    EBrowserType2["Firefox"] = "Firefox";
    EBrowserType2["Edge"] = "Edge";
    return EBrowserType2;
  })(EBrowserType || {});
  var EWorkingStatus = /* @__PURE__ */ ((EWorkingStatus2) => {
    EWorkingStatus2["success"] = "success";
    EWorkingStatus2["error"] = "error";
    EWorkingStatus2["loading"] = "loading";
    return EWorkingStatus2;
  })(EWorkingStatus || {});
  var EResourceOrderBy = /* @__PURE__ */ ((EResourceOrderBy2) => {
    EResourceOrderBy2["time"] = "time";
    EResourceOrderBy2["name"] = "name";
    EResourceOrderBy2["size"] = "size";
    return EResourceOrderBy2;
  })(EResourceOrderBy || {});
  var EResourceOrderMode = /* @__PURE__ */ ((EResourceOrderMode2) => {
    EResourceOrderMode2["desc"] = "desc";
    EResourceOrderMode2["asc"] = "asc";
    return EResourceOrderMode2;
  })(EResourceOrderMode || {});
  var EEncryptMode = /* @__PURE__ */ ((EEncryptMode2) => {
    EEncryptMode2["AES"] = "AES";
    return EEncryptMode2;
  })(EEncryptMode || {});
  var ERestoreError = /* @__PURE__ */ ((ERestoreError2) => {
    ERestoreError2["needSecretKey"] = "needSecretKey";
    ERestoreError2["errorSecretKey"] = "errorSecretKey";
    return ERestoreError2;
  })(ERestoreError || {});
  var ETagType = /* @__PURE__ */ ((ETagType2) => {
    ETagType2["all"] = "__all__";
    ETagType2["unTagged"] = "__unTagged__";
    ETagType2["unReadMsg"] = "__unReadMsg__";
    ETagType2["statusError"] = "__statusError__";
    return ETagType2;
  })(ETagType || {});
  var EOpenType = /* @__PURE__ */ ((EOpenType2) => {
    EOpenType2["openAllSites"] = "openAllSites";
    EOpenType2["openAllUnReadMsg"] = "openAllUnReadMsg";
    EOpenType2["openAllStatusErr"] = "openAllStatusErr";
    return EOpenType2;
  })(EOpenType || {});
  var EAlarm = /* @__PURE__ */ ((EAlarm2) => {
    EAlarm2["refreshJob"] = "PTPP_RefreshUserData_JOB";
    return EAlarm2;
  })(EAlarm || {});
  const BASE_COLORS = [
    "red",
    "pink",
    "purple",
    "deep-purple",
    "indigo",
    "blue",
    "light-blue",
    "cyan",
    "teal",
    "green",
    "light-green",
    "lime",
    "yellow",
    "amber",
    "orange",
    "deep-orange",
    "brown",
    "blue-grey",
    "grey",
    "black"
  ];
  const BASE_TAG_COLORS = {
    // 免费下载
    Free: "blue",
    // 免费下载 + 2x 上传
    "2xFree": "green",
    // 2x 上传
    "2xUp": "lime",
    // 2x 上传 + 50% 下载
    "2x50%": "light-green",
    // 25% 下载
    "25%": "purple",
    // 30% 下载
    "30%": "indigo",
    // 35% 下载
    "35%": "indigo darken-3",
    // 50% 下载
    "50%": "orange",
    // 70% 下载
    "70%": "blue-grey",
    // 75% 下载
    "75%": "lime darken-3",
    // 仅 VIP 可下载
    VIP: "orange darken-2",
    // 禁止转载
    "⛔️": "deep-orange darken-1"
  };
  class localStorage {
    constructor() {
      this.isExtensionMode = false;
      if (window.chrome && chrome.extension) {
        this.isExtensionMode = true;
      }
    }
    /**
     * 设置指定的值
     * @param key
     * @param value
     * @param type
     */
    set(key2, value, type = EStorageType.json) {
      return new Promise((resolve2, reject2) => {
        if (this.isExtensionMode) {
          let data2 = {};
          data2[key2] = value;
          chrome.storage.local.set(data2, () => {
            resolve2();
          });
        } else {
          if (typeof value !== "string" && type == EStorageType.json) {
            value = JSON.stringify(value);
          }
          window.localStorage.setItem(key2, value);
          resolve2();
        }
      });
    }
    get(key2, callback, type = EStorageType.json) {
      if (this.isExtensionMode) {
        chrome.storage.local.get(key2, (result2) => {
          if (result2 && result2[key2]) {
            callback(result2[key2]);
          } else {
            callback(null);
          }
        });
      } else {
        let result2 = window.localStorage.getItem(key2);
        if (result2 && type == EStorageType.json) {
          result2 = JSON.parse(result2);
        }
        callback && callback(result2);
      }
    }
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs$1(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
  }
  function getDefaultExportFromNamespaceIfPresent(n2) {
    return n2 && Object.prototype.hasOwnProperty.call(n2, "default") ? n2["default"] : n2;
  }
  function getDefaultExportFromNamespaceIfNotNamed(n2) {
    return n2 && Object.prototype.hasOwnProperty.call(n2, "default") && Object.keys(n2).length === 1 ? n2["default"] : n2;
  }
  function getAugmentedNamespace(n2) {
    if (n2.__esModule)
      return n2;
    var f2 = n2.default;
    if (typeof f2 == "function") {
      var a2 = function a3() {
        if (this instanceof a3) {
          return Reflect.construct(f2, arguments, this.constructor);
        }
        return f2.apply(this, arguments);
      };
      a2.prototype = f2.prototype;
    } else
      a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n2).forEach(function(k) {
      var d2 = Object.getOwnPropertyDescriptor(n2, k);
      Object.defineProperty(a2, k, d2.get ? d2 : {
        enumerable: true,
        get: function() {
          return n2[k];
        }
      });
    });
    return a2;
  }
  var cryptoJs$1 = { exports: {} };
  function commonjsRequire(path2) {
    throw new Error('Could not dynamically require "' + path2 + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
  }
  var core$1 = { exports: {} };
  const fs = {};
  const __viteBrowserExternal = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    default: fs
  }, Symbol.toStringTag, { value: "Module" }));
  const require$$0 = /* @__PURE__ */ getAugmentedNamespace(__viteBrowserExternal);
  var core = core$1.exports;
  var hasRequiredCore;
  function requireCore() {
    if (hasRequiredCore)
      return core$1.exports;
    hasRequiredCore = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory();
        } else if (false) {
          (void 0)([], factory);
        } else {
          root.CryptoJS = factory();
        }
      })(commonjsGlobal, function() {
        var CryptoJS = CryptoJS || function(Math2, undefined$1) {
          var crypto2;
          if (typeof window !== "undefined" && window.crypto) {
            crypto2 = window.crypto;
          }
          if (typeof self !== "undefined" && self.crypto) {
            crypto2 = self.crypto;
          }
          if (typeof globalThis !== "undefined" && globalThis.crypto) {
            crypto2 = globalThis.crypto;
          }
          if (!crypto2 && typeof window !== "undefined" && window.msCrypto) {
            crypto2 = window.msCrypto;
          }
          if (!crypto2 && typeof commonjsGlobal !== "undefined" && commonjsGlobal.crypto) {
            crypto2 = commonjsGlobal.crypto;
          }
          if (!crypto2 && typeof commonjsRequire === "function") {
            try {
              crypto2 = require$$0;
            } catch (err) {
            }
          }
          var cryptoSecureRandomInt = function() {
            if (crypto2) {
              if (typeof crypto2.getRandomValues === "function") {
                try {
                  return crypto2.getRandomValues(new Uint32Array(1))[0];
                } catch (err) {
                }
              }
              if (typeof crypto2.randomBytes === "function") {
                try {
                  return crypto2.randomBytes(4).readInt32LE();
                } catch (err) {
                }
              }
            }
            throw new Error("Native crypto module could not be used to get secure random number.");
          };
          var create = Object.create || /* @__PURE__ */ function() {
            function F() {
            }
            return function(obj) {
              var subtype;
              F.prototype = obj;
              subtype = new F();
              F.prototype = null;
              return subtype;
            };
          }();
          var C = {};
          var C_lib = C.lib = {};
          var Base = C_lib.Base = /* @__PURE__ */ function() {
            return {
              /**
               * Creates a new object that inherits from this object.
               *
               * @param {Object} overrides Properties to copy into the new object.
               *
               * @return {Object} The new object.
               *
               * @static
               *
               * @example
               *
               *     var MyType = CryptoJS.lib.Base.extend({
               *         field: 'value',
               *
               *         method: function () {
               *         }
               *     });
               */
              extend: function(overrides) {
                var subtype = create(this);
                if (overrides) {
                  subtype.mixIn(overrides);
                }
                if (!subtype.hasOwnProperty("init") || this.init === subtype.init) {
                  subtype.init = function() {
                    subtype.$super.init.apply(this, arguments);
                  };
                }
                subtype.init.prototype = subtype;
                subtype.$super = this;
                return subtype;
              },
              /**
               * Extends this object and runs the init method.
               * Arguments to create() will be passed to init().
               *
               * @return {Object} The new object.
               *
               * @static
               *
               * @example
               *
               *     var instance = MyType.create();
               */
              create: function() {
                var instance2 = this.extend();
                instance2.init.apply(instance2, arguments);
                return instance2;
              },
              /**
               * Initializes a newly created object.
               * Override this method to add some logic when your objects are created.
               *
               * @example
               *
               *     var MyType = CryptoJS.lib.Base.extend({
               *         init: function () {
               *             // ...
               *         }
               *     });
               */
              init: function() {
              },
              /**
               * Copies properties into this object.
               *
               * @param {Object} properties The properties to mix in.
               *
               * @example
               *
               *     MyType.mixIn({
               *         field: 'value'
               *     });
               */
              mixIn: function(properties) {
                for (var propertyName in properties) {
                  if (properties.hasOwnProperty(propertyName)) {
                    this[propertyName] = properties[propertyName];
                  }
                }
                if (properties.hasOwnProperty("toString")) {
                  this.toString = properties.toString;
                }
              },
              /**
               * Creates a copy of this object.
               *
               * @return {Object} The clone.
               *
               * @example
               *
               *     var clone = instance.clone();
               */
              clone: function() {
                return this.init.prototype.extend(this);
              }
            };
          }();
          var WordArray = C_lib.WordArray = Base.extend({
            /**
             * Initializes a newly created word array.
             *
             * @param {Array} words (Optional) An array of 32-bit words.
             * @param {number} sigBytes (Optional) The number of significant bytes in the words.
             *
             * @example
             *
             *     var wordArray = CryptoJS.lib.WordArray.create();
             *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607]);
             *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607], 6);
             */
            init: function(words, sigBytes) {
              words = this.words = words || [];
              if (sigBytes != undefined$1) {
                this.sigBytes = sigBytes;
              } else {
                this.sigBytes = words.length * 4;
              }
            },
            /**
             * Converts this word array to a string.
             *
             * @param {Encoder} encoder (Optional) The encoding strategy to use. Default: CryptoJS.enc.Hex
             *
             * @return {string} The stringified word array.
             *
             * @example
             *
             *     var string = wordArray + '';
             *     var string = wordArray.toString();
             *     var string = wordArray.toString(CryptoJS.enc.Utf8);
             */
            toString: function(encoder2) {
              return (encoder2 || Hex).stringify(this);
            },
            /**
             * Concatenates a word array to this word array.
             *
             * @param {WordArray} wordArray The word array to append.
             *
             * @return {WordArray} This word array.
             *
             * @example
             *
             *     wordArray1.concat(wordArray2);
             */
            concat: function(wordArray) {
              var thisWords = this.words;
              var thatWords = wordArray.words;
              var thisSigBytes = this.sigBytes;
              var thatSigBytes = wordArray.sigBytes;
              this.clamp();
              if (thisSigBytes % 4) {
                for (var i2 = 0; i2 < thatSigBytes; i2++) {
                  var thatByte = thatWords[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                  thisWords[thisSigBytes + i2 >>> 2] |= thatByte << 24 - (thisSigBytes + i2) % 4 * 8;
                }
              } else {
                for (var j = 0; j < thatSigBytes; j += 4) {
                  thisWords[thisSigBytes + j >>> 2] = thatWords[j >>> 2];
                }
              }
              this.sigBytes += thatSigBytes;
              return this;
            },
            /**
             * Removes insignificant bits.
             *
             * @example
             *
             *     wordArray.clamp();
             */
            clamp: function() {
              var words = this.words;
              var sigBytes = this.sigBytes;
              words[sigBytes >>> 2] &= 4294967295 << 32 - sigBytes % 4 * 8;
              words.length = Math2.ceil(sigBytes / 4);
            },
            /**
             * Creates a copy of this word array.
             *
             * @return {WordArray} The clone.
             *
             * @example
             *
             *     var clone = wordArray.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              clone.words = this.words.slice(0);
              return clone;
            },
            /**
             * Creates a word array filled with random bytes.
             *
             * @param {number} nBytes The number of random bytes to generate.
             *
             * @return {WordArray} The random word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.lib.WordArray.random(16);
             */
            random: function(nBytes) {
              var words = [];
              for (var i2 = 0; i2 < nBytes; i2 += 4) {
                words.push(cryptoSecureRandomInt());
              }
              return new WordArray.init(words, nBytes);
            }
          });
          var C_enc = C.enc = {};
          var Hex = C_enc.Hex = {
            /**
             * Converts a word array to a hex string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The hex string.
             *
             * @static
             *
             * @example
             *
             *     var hexString = CryptoJS.enc.Hex.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var hexChars = [];
              for (var i2 = 0; i2 < sigBytes; i2++) {
                var bite = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                hexChars.push((bite >>> 4).toString(16));
                hexChars.push((bite & 15).toString(16));
              }
              return hexChars.join("");
            },
            /**
             * Converts a hex string to a word array.
             *
             * @param {string} hexStr The hex string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Hex.parse(hexString);
             */
            parse: function(hexStr) {
              var hexStrLength = hexStr.length;
              var words = [];
              for (var i2 = 0; i2 < hexStrLength; i2 += 2) {
                words[i2 >>> 3] |= parseInt(hexStr.substr(i2, 2), 16) << 24 - i2 % 8 * 4;
              }
              return new WordArray.init(words, hexStrLength / 2);
            }
          };
          var Latin1 = C_enc.Latin1 = {
            /**
             * Converts a word array to a Latin1 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The Latin1 string.
             *
             * @static
             *
             * @example
             *
             *     var latin1String = CryptoJS.enc.Latin1.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var latin1Chars = [];
              for (var i2 = 0; i2 < sigBytes; i2++) {
                var bite = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                latin1Chars.push(String.fromCharCode(bite));
              }
              return latin1Chars.join("");
            },
            /**
             * Converts a Latin1 string to a word array.
             *
             * @param {string} latin1Str The Latin1 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Latin1.parse(latin1String);
             */
            parse: function(latin1Str) {
              var latin1StrLength = latin1Str.length;
              var words = [];
              for (var i2 = 0; i2 < latin1StrLength; i2++) {
                words[i2 >>> 2] |= (latin1Str.charCodeAt(i2) & 255) << 24 - i2 % 4 * 8;
              }
              return new WordArray.init(words, latin1StrLength);
            }
          };
          var Utf8 = C_enc.Utf8 = {
            /**
             * Converts a word array to a UTF-8 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-8 string.
             *
             * @static
             *
             * @example
             *
             *     var utf8String = CryptoJS.enc.Utf8.stringify(wordArray);
             */
            stringify: function(wordArray) {
              try {
                return decodeURIComponent(escape(Latin1.stringify(wordArray)));
              } catch (e2) {
                throw new Error("Malformed UTF-8 data");
              }
            },
            /**
             * Converts a UTF-8 string to a word array.
             *
             * @param {string} utf8Str The UTF-8 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf8.parse(utf8String);
             */
            parse: function(utf8Str) {
              return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
            }
          };
          var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm = Base.extend({
            /**
             * Resets this block algorithm's data buffer to its initial state.
             *
             * @example
             *
             *     bufferedBlockAlgorithm.reset();
             */
            reset: function() {
              this._data = new WordArray.init();
              this._nDataBytes = 0;
            },
            /**
             * Adds new data to this block algorithm's buffer.
             *
             * @param {WordArray|string} data The data to append. Strings are converted to a WordArray using UTF-8.
             *
             * @example
             *
             *     bufferedBlockAlgorithm._append('data');
             *     bufferedBlockAlgorithm._append(wordArray);
             */
            _append: function(data2) {
              if (typeof data2 == "string") {
                data2 = Utf8.parse(data2);
              }
              this._data.concat(data2);
              this._nDataBytes += data2.sigBytes;
            },
            /**
             * Processes available data blocks.
             *
             * This method invokes _doProcessBlock(offset), which must be implemented by a concrete subtype.
             *
             * @param {boolean} doFlush Whether all blocks and partial blocks should be processed.
             *
             * @return {WordArray} The processed data.
             *
             * @example
             *
             *     var processedData = bufferedBlockAlgorithm._process();
             *     var processedData = bufferedBlockAlgorithm._process(!!'flush');
             */
            _process: function(doFlush) {
              var processedWords;
              var data2 = this._data;
              var dataWords = data2.words;
              var dataSigBytes = data2.sigBytes;
              var blockSize = this.blockSize;
              var blockSizeBytes = blockSize * 4;
              var nBlocksReady = dataSigBytes / blockSizeBytes;
              if (doFlush) {
                nBlocksReady = Math2.ceil(nBlocksReady);
              } else {
                nBlocksReady = Math2.max((nBlocksReady | 0) - this._minBufferSize, 0);
              }
              var nWordsReady = nBlocksReady * blockSize;
              var nBytesReady = Math2.min(nWordsReady * 4, dataSigBytes);
              if (nWordsReady) {
                for (var offset = 0; offset < nWordsReady; offset += blockSize) {
                  this._doProcessBlock(dataWords, offset);
                }
                processedWords = dataWords.splice(0, nWordsReady);
                data2.sigBytes -= nBytesReady;
              }
              return new WordArray.init(processedWords, nBytesReady);
            },
            /**
             * Creates a copy of this object.
             *
             * @return {Object} The clone.
             *
             * @example
             *
             *     var clone = bufferedBlockAlgorithm.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              clone._data = this._data.clone();
              return clone;
            },
            _minBufferSize: 0
          });
          var Hasher = C_lib.Hasher = BufferedBlockAlgorithm.extend({
            /**
             * Configuration options.
             */
            cfg: Base.extend(),
            /**
             * Initializes a newly created hasher.
             *
             * @param {Object} cfg (Optional) The configuration options to use for this hash computation.
             *
             * @example
             *
             *     var hasher = CryptoJS.algo.SHA256.create();
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
              this.reset();
            },
            /**
             * Resets this hasher to its initial state.
             *
             * @example
             *
             *     hasher.reset();
             */
            reset: function() {
              BufferedBlockAlgorithm.reset.call(this);
              this._doReset();
            },
            /**
             * Updates this hasher with a message.
             *
             * @param {WordArray|string} messageUpdate The message to append.
             *
             * @return {Hasher} This hasher.
             *
             * @example
             *
             *     hasher.update('message');
             *     hasher.update(wordArray);
             */
            update: function(messageUpdate) {
              this._append(messageUpdate);
              this._process();
              return this;
            },
            /**
             * Finalizes the hash computation.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} messageUpdate (Optional) A final message update.
             *
             * @return {WordArray} The hash.
             *
             * @example
             *
             *     var hash = hasher.finalize();
             *     var hash = hasher.finalize('message');
             *     var hash = hasher.finalize(wordArray);
             */
            finalize: function(messageUpdate) {
              if (messageUpdate) {
                this._append(messageUpdate);
              }
              var hash2 = this._doFinalize();
              return hash2;
            },
            blockSize: 512 / 32,
            /**
             * Creates a shortcut function to a hasher's object interface.
             *
             * @param {Hasher} hasher The hasher to create a helper for.
             *
             * @return {Function} The shortcut function.
             *
             * @static
             *
             * @example
             *
             *     var SHA256 = CryptoJS.lib.Hasher._createHelper(CryptoJS.algo.SHA256);
             */
            _createHelper: function(hasher) {
              return function(message, cfg) {
                return new hasher.init(cfg).finalize(message);
              };
            },
            /**
             * Creates a shortcut function to the HMAC's object interface.
             *
             * @param {Hasher} hasher The hasher to use in this HMAC helper.
             *
             * @return {Function} The shortcut function.
             *
             * @static
             *
             * @example
             *
             *     var HmacSHA256 = CryptoJS.lib.Hasher._createHmacHelper(CryptoJS.algo.SHA256);
             */
            _createHmacHelper: function(hasher) {
              return function(message, key2) {
                return new C_algo.HMAC.init(hasher, key2).finalize(message);
              };
            }
          });
          var C_algo = C.algo = {};
          return C;
        }(Math);
        return CryptoJS;
      });
    })(core$1, core$1.exports);
    return core$1.exports;
  }
  var x64Core$1 = { exports: {} };
  var x64Core = x64Core$1.exports;
  var hasRequiredX64Core;
  function requireX64Core() {
    if (hasRequiredX64Core)
      return x64Core$1.exports;
    hasRequiredX64Core = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function(undefined$1) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var X32WordArray = C_lib.WordArray;
          var C_x64 = C.x64 = {};
          var X64Word = C_x64.Word = Base.extend({
            /**
             * Initializes a newly created 64-bit word.
             *
             * @param {number} high The high 32 bits.
             * @param {number} low The low 32 bits.
             *
             * @example
             *
             *     var x64Word = CryptoJS.x64.Word.create(0x00010203, 0x04050607);
             */
            init: function(high, low) {
              this.high = high;
              this.low = low;
            }
            /**
             * Bitwise NOTs this word.
             *
             * @return {X64Word} A new x64-Word object after negating.
             *
             * @example
             *
             *     var negated = x64Word.not();
             */
            // not: function () {
            // var high = ~this.high;
            // var low = ~this.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise ANDs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to AND with this word.
             *
             * @return {X64Word} A new x64-Word object after ANDing.
             *
             * @example
             *
             *     var anded = x64Word.and(anotherX64Word);
             */
            // and: function (word) {
            // var high = this.high & word.high;
            // var low = this.low & word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise ORs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to OR with this word.
             *
             * @return {X64Word} A new x64-Word object after ORing.
             *
             * @example
             *
             *     var ored = x64Word.or(anotherX64Word);
             */
            // or: function (word) {
            // var high = this.high | word.high;
            // var low = this.low | word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise XORs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to XOR with this word.
             *
             * @return {X64Word} A new x64-Word object after XORing.
             *
             * @example
             *
             *     var xored = x64Word.xor(anotherX64Word);
             */
            // xor: function (word) {
            // var high = this.high ^ word.high;
            // var low = this.low ^ word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Shifts this word n bits to the left.
             *
             * @param {number} n The number of bits to shift.
             *
             * @return {X64Word} A new x64-Word object after shifting.
             *
             * @example
             *
             *     var shifted = x64Word.shiftL(25);
             */
            // shiftL: function (n) {
            // if (n < 32) {
            // var high = (this.high << n) | (this.low >>> (32 - n));
            // var low = this.low << n;
            // } else {
            // var high = this.low << (n - 32);
            // var low = 0;
            // }
            // return X64Word.create(high, low);
            // },
            /**
             * Shifts this word n bits to the right.
             *
             * @param {number} n The number of bits to shift.
             *
             * @return {X64Word} A new x64-Word object after shifting.
             *
             * @example
             *
             *     var shifted = x64Word.shiftR(7);
             */
            // shiftR: function (n) {
            // if (n < 32) {
            // var low = (this.low >>> n) | (this.high << (32 - n));
            // var high = this.high >>> n;
            // } else {
            // var low = this.high >>> (n - 32);
            // var high = 0;
            // }
            // return X64Word.create(high, low);
            // },
            /**
             * Rotates this word n bits to the left.
             *
             * @param {number} n The number of bits to rotate.
             *
             * @return {X64Word} A new x64-Word object after rotating.
             *
             * @example
             *
             *     var rotated = x64Word.rotL(25);
             */
            // rotL: function (n) {
            // return this.shiftL(n).or(this.shiftR(64 - n));
            // },
            /**
             * Rotates this word n bits to the right.
             *
             * @param {number} n The number of bits to rotate.
             *
             * @return {X64Word} A new x64-Word object after rotating.
             *
             * @example
             *
             *     var rotated = x64Word.rotR(7);
             */
            // rotR: function (n) {
            // return this.shiftR(n).or(this.shiftL(64 - n));
            // },
            /**
             * Adds this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to add with this word.
             *
             * @return {X64Word} A new x64-Word object after adding.
             *
             * @example
             *
             *     var added = x64Word.add(anotherX64Word);
             */
            // add: function (word) {
            // var low = (this.low + word.low) | 0;
            // var carry = (low >>> 0) < (this.low >>> 0) ? 1 : 0;
            // var high = (this.high + word.high + carry) | 0;
            // return X64Word.create(high, low);
            // }
          });
          var X64WordArray = C_x64.WordArray = Base.extend({
            /**
             * Initializes a newly created word array.
             *
             * @param {Array} words (Optional) An array of CryptoJS.x64.Word objects.
             * @param {number} sigBytes (Optional) The number of significant bytes in the words.
             *
             * @example
             *
             *     var wordArray = CryptoJS.x64.WordArray.create();
             *
             *     var wordArray = CryptoJS.x64.WordArray.create([
             *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
             *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
             *     ]);
             *
             *     var wordArray = CryptoJS.x64.WordArray.create([
             *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
             *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
             *     ], 10);
             */
            init: function(words, sigBytes) {
              words = this.words = words || [];
              if (sigBytes != undefined$1) {
                this.sigBytes = sigBytes;
              } else {
                this.sigBytes = words.length * 8;
              }
            },
            /**
             * Converts this 64-bit word array to a 32-bit word array.
             *
             * @return {CryptoJS.lib.WordArray} This word array's data as a 32-bit word array.
             *
             * @example
             *
             *     var x32WordArray = x64WordArray.toX32();
             */
            toX32: function() {
              var x64Words = this.words;
              var x64WordsLength = x64Words.length;
              var x32Words = [];
              for (var i2 = 0; i2 < x64WordsLength; i2++) {
                var x64Word = x64Words[i2];
                x32Words.push(x64Word.high);
                x32Words.push(x64Word.low);
              }
              return X32WordArray.create(x32Words, this.sigBytes);
            },
            /**
             * Creates a copy of this word array.
             *
             * @return {X64WordArray} The clone.
             *
             * @example
             *
             *     var clone = x64WordArray.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              var words = clone.words = this.words.slice(0);
              var wordsLength = words.length;
              for (var i2 = 0; i2 < wordsLength; i2++) {
                words[i2] = words[i2].clone();
              }
              return clone;
            }
          });
        })();
        return CryptoJS;
      });
    })(x64Core$1, x64Core$1.exports);
    return x64Core$1.exports;
  }
  var libTypedarrays$1 = { exports: {} };
  var libTypedarrays = libTypedarrays$1.exports;
  var hasRequiredLibTypedarrays;
  function requireLibTypedarrays() {
    if (hasRequiredLibTypedarrays)
      return libTypedarrays$1.exports;
    hasRequiredLibTypedarrays = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          if (typeof ArrayBuffer != "function") {
            return;
          }
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var superInit = WordArray.init;
          var subInit = WordArray.init = function(typedArray) {
            if (typedArray instanceof ArrayBuffer) {
              typedArray = new Uint8Array(typedArray);
            }
            if (typedArray instanceof Int8Array || typeof Uint8ClampedArray !== "undefined" && typedArray instanceof Uint8ClampedArray || typedArray instanceof Int16Array || typedArray instanceof Uint16Array || typedArray instanceof Int32Array || typedArray instanceof Uint32Array || typedArray instanceof Float32Array || typedArray instanceof Float64Array) {
              typedArray = new Uint8Array(typedArray.buffer, typedArray.byteOffset, typedArray.byteLength);
            }
            if (typedArray instanceof Uint8Array) {
              var typedArrayByteLength = typedArray.byteLength;
              var words = [];
              for (var i2 = 0; i2 < typedArrayByteLength; i2++) {
                words[i2 >>> 2] |= typedArray[i2] << 24 - i2 % 4 * 8;
              }
              superInit.call(this, words, typedArrayByteLength);
            } else {
              superInit.apply(this, arguments);
            }
          };
          subInit.prototype = WordArray;
        })();
        return CryptoJS.lib.WordArray;
      });
    })(libTypedarrays$1, libTypedarrays$1.exports);
    return libTypedarrays$1.exports;
  }
  var encUtf16$1 = { exports: {} };
  var encUtf16 = encUtf16$1.exports;
  var hasRequiredEncUtf16;
  function requireEncUtf16() {
    if (hasRequiredEncUtf16)
      return encUtf16$1.exports;
    hasRequiredEncUtf16 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Utf16BE = C_enc.Utf16 = C_enc.Utf16BE = {
            /**
             * Converts a word array to a UTF-16 BE string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-16 BE string.
             *
             * @static
             *
             * @example
             *
             *     var utf16String = CryptoJS.enc.Utf16.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var utf16Chars = [];
              for (var i2 = 0; i2 < sigBytes; i2 += 2) {
                var codePoint = words[i2 >>> 2] >>> 16 - i2 % 4 * 8 & 65535;
                utf16Chars.push(String.fromCharCode(codePoint));
              }
              return utf16Chars.join("");
            },
            /**
             * Converts a UTF-16 BE string to a word array.
             *
             * @param {string} utf16Str The UTF-16 BE string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf16.parse(utf16String);
             */
            parse: function(utf16Str) {
              var utf16StrLength = utf16Str.length;
              var words = [];
              for (var i2 = 0; i2 < utf16StrLength; i2++) {
                words[i2 >>> 1] |= utf16Str.charCodeAt(i2) << 16 - i2 % 2 * 16;
              }
              return WordArray.create(words, utf16StrLength * 2);
            }
          };
          C_enc.Utf16LE = {
            /**
             * Converts a word array to a UTF-16 LE string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-16 LE string.
             *
             * @static
             *
             * @example
             *
             *     var utf16Str = CryptoJS.enc.Utf16LE.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var utf16Chars = [];
              for (var i2 = 0; i2 < sigBytes; i2 += 2) {
                var codePoint = swapEndian(words[i2 >>> 2] >>> 16 - i2 % 4 * 8 & 65535);
                utf16Chars.push(String.fromCharCode(codePoint));
              }
              return utf16Chars.join("");
            },
            /**
             * Converts a UTF-16 LE string to a word array.
             *
             * @param {string} utf16Str The UTF-16 LE string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf16LE.parse(utf16Str);
             */
            parse: function(utf16Str) {
              var utf16StrLength = utf16Str.length;
              var words = [];
              for (var i2 = 0; i2 < utf16StrLength; i2++) {
                words[i2 >>> 1] |= swapEndian(utf16Str.charCodeAt(i2) << 16 - i2 % 2 * 16);
              }
              return WordArray.create(words, utf16StrLength * 2);
            }
          };
          function swapEndian(word) {
            return word << 8 & 4278255360 | word >>> 8 & 16711935;
          }
        })();
        return CryptoJS.enc.Utf16;
      });
    })(encUtf16$1, encUtf16$1.exports);
    return encUtf16$1.exports;
  }
  var encBase64$1 = { exports: {} };
  var encBase64 = encBase64$1.exports;
  var hasRequiredEncBase64;
  function requireEncBase64() {
    if (hasRequiredEncBase64)
      return encBase64$1.exports;
    hasRequiredEncBase64 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Base64 = C_enc.Base64 = {
            /**
             * Converts a word array to a Base64 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The Base64 string.
             *
             * @static
             *
             * @example
             *
             *     var base64String = CryptoJS.enc.Base64.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var map = this._map;
              wordArray.clamp();
              var base64Chars = [];
              for (var i2 = 0; i2 < sigBytes; i2 += 3) {
                var byte1 = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                var byte2 = words[i2 + 1 >>> 2] >>> 24 - (i2 + 1) % 4 * 8 & 255;
                var byte3 = words[i2 + 2 >>> 2] >>> 24 - (i2 + 2) % 4 * 8 & 255;
                var triplet = byte1 << 16 | byte2 << 8 | byte3;
                for (var j = 0; j < 4 && i2 + j * 0.75 < sigBytes; j++) {
                  base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                while (base64Chars.length % 4) {
                  base64Chars.push(paddingChar);
                }
              }
              return base64Chars.join("");
            },
            /**
             * Converts a Base64 string to a word array.
             *
             * @param {string} base64Str The Base64 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Base64.parse(base64String);
             */
            parse: function(base64Str) {
              var base64StrLength = base64Str.length;
              var map = this._map;
              var reverseMap = this._reverseMap;
              if (!reverseMap) {
                reverseMap = this._reverseMap = [];
                for (var j = 0; j < map.length; j++) {
                  reverseMap[map.charCodeAt(j)] = j;
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                var paddingIndex = base64Str.indexOf(paddingChar);
                if (paddingIndex !== -1) {
                  base64StrLength = paddingIndex;
                }
              }
              return parseLoop(base64Str, base64StrLength, reverseMap);
            },
            _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
          };
          function parseLoop(base64Str, base64StrLength, reverseMap) {
            var words = [];
            var nBytes = 0;
            for (var i2 = 0; i2 < base64StrLength; i2++) {
              if (i2 % 4) {
                var bits1 = reverseMap[base64Str.charCodeAt(i2 - 1)] << i2 % 4 * 2;
                var bits2 = reverseMap[base64Str.charCodeAt(i2)] >>> 6 - i2 % 4 * 2;
                var bitsCombined = bits1 | bits2;
                words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
                nBytes++;
              }
            }
            return WordArray.create(words, nBytes);
          }
        })();
        return CryptoJS.enc.Base64;
      });
    })(encBase64$1, encBase64$1.exports);
    return encBase64$1.exports;
  }
  var encBase64url$1 = { exports: {} };
  var encBase64url = encBase64url$1.exports;
  var hasRequiredEncBase64url;
  function requireEncBase64url() {
    if (hasRequiredEncBase64url)
      return encBase64url$1.exports;
    hasRequiredEncBase64url = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Base64url = C_enc.Base64url = {
            /**
             * Converts a word array to a Base64url string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @param {boolean} urlSafe Whether to use url safe
             *
             * @return {string} The Base64url string.
             *
             * @static
             *
             * @example
             *
             *     var base64String = CryptoJS.enc.Base64url.stringify(wordArray);
             */
            stringify: function(wordArray, urlSafe) {
              if (urlSafe === void 0) {
                urlSafe = true;
              }
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var map = urlSafe ? this._safe_map : this._map;
              wordArray.clamp();
              var base64Chars = [];
              for (var i2 = 0; i2 < sigBytes; i2 += 3) {
                var byte1 = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                var byte2 = words[i2 + 1 >>> 2] >>> 24 - (i2 + 1) % 4 * 8 & 255;
                var byte3 = words[i2 + 2 >>> 2] >>> 24 - (i2 + 2) % 4 * 8 & 255;
                var triplet = byte1 << 16 | byte2 << 8 | byte3;
                for (var j = 0; j < 4 && i2 + j * 0.75 < sigBytes; j++) {
                  base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                while (base64Chars.length % 4) {
                  base64Chars.push(paddingChar);
                }
              }
              return base64Chars.join("");
            },
            /**
             * Converts a Base64url string to a word array.
             *
             * @param {string} base64Str The Base64url string.
             *
             * @param {boolean} urlSafe Whether to use url safe
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Base64url.parse(base64String);
             */
            parse: function(base64Str, urlSafe) {
              if (urlSafe === void 0) {
                urlSafe = true;
              }
              var base64StrLength = base64Str.length;
              var map = urlSafe ? this._safe_map : this._map;
              var reverseMap = this._reverseMap;
              if (!reverseMap) {
                reverseMap = this._reverseMap = [];
                for (var j = 0; j < map.length; j++) {
                  reverseMap[map.charCodeAt(j)] = j;
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                var paddingIndex = base64Str.indexOf(paddingChar);
                if (paddingIndex !== -1) {
                  base64StrLength = paddingIndex;
                }
              }
              return parseLoop(base64Str, base64StrLength, reverseMap);
            },
            _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
            _safe_map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"
          };
          function parseLoop(base64Str, base64StrLength, reverseMap) {
            var words = [];
            var nBytes = 0;
            for (var i2 = 0; i2 < base64StrLength; i2++) {
              if (i2 % 4) {
                var bits1 = reverseMap[base64Str.charCodeAt(i2 - 1)] << i2 % 4 * 2;
                var bits2 = reverseMap[base64Str.charCodeAt(i2)] >>> 6 - i2 % 4 * 2;
                var bitsCombined = bits1 | bits2;
                words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
                nBytes++;
              }
            }
            return WordArray.create(words, nBytes);
          }
        })();
        return CryptoJS.enc.Base64url;
      });
    })(encBase64url$1, encBase64url$1.exports);
    return encBase64url$1.exports;
  }
  var md5$1 = { exports: {} };
  var md5 = md5$1.exports;
  var hasRequiredMd5;
  function requireMd5() {
    if (hasRequiredMd5)
      return md5$1.exports;
    hasRequiredMd5 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var T = [];
          (function() {
            for (var i2 = 0; i2 < 64; i2++) {
              T[i2] = Math2.abs(Math2.sin(i2 + 1)) * 4294967296 | 0;
            }
          })();
          var MD5 = C_algo.MD5 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                1732584193,
                4023233417,
                2562383102,
                271733878
              ]);
            },
            _doProcessBlock: function(M, offset) {
              for (var i2 = 0; i2 < 16; i2++) {
                var offset_i = offset + i2;
                var M_offset_i = M[offset_i];
                M[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
              }
              var H = this._hash.words;
              var M_offset_0 = M[offset + 0];
              var M_offset_1 = M[offset + 1];
              var M_offset_2 = M[offset + 2];
              var M_offset_3 = M[offset + 3];
              var M_offset_4 = M[offset + 4];
              var M_offset_5 = M[offset + 5];
              var M_offset_6 = M[offset + 6];
              var M_offset_7 = M[offset + 7];
              var M_offset_8 = M[offset + 8];
              var M_offset_9 = M[offset + 9];
              var M_offset_10 = M[offset + 10];
              var M_offset_11 = M[offset + 11];
              var M_offset_12 = M[offset + 12];
              var M_offset_13 = M[offset + 13];
              var M_offset_14 = M[offset + 14];
              var M_offset_15 = M[offset + 15];
              var a2 = H[0];
              var b = H[1];
              var c2 = H[2];
              var d2 = H[3];
              a2 = FF(a2, b, c2, d2, M_offset_0, 7, T[0]);
              d2 = FF(d2, a2, b, c2, M_offset_1, 12, T[1]);
              c2 = FF(c2, d2, a2, b, M_offset_2, 17, T[2]);
              b = FF(b, c2, d2, a2, M_offset_3, 22, T[3]);
              a2 = FF(a2, b, c2, d2, M_offset_4, 7, T[4]);
              d2 = FF(d2, a2, b, c2, M_offset_5, 12, T[5]);
              c2 = FF(c2, d2, a2, b, M_offset_6, 17, T[6]);
              b = FF(b, c2, d2, a2, M_offset_7, 22, T[7]);
              a2 = FF(a2, b, c2, d2, M_offset_8, 7, T[8]);
              d2 = FF(d2, a2, b, c2, M_offset_9, 12, T[9]);
              c2 = FF(c2, d2, a2, b, M_offset_10, 17, T[10]);
              b = FF(b, c2, d2, a2, M_offset_11, 22, T[11]);
              a2 = FF(a2, b, c2, d2, M_offset_12, 7, T[12]);
              d2 = FF(d2, a2, b, c2, M_offset_13, 12, T[13]);
              c2 = FF(c2, d2, a2, b, M_offset_14, 17, T[14]);
              b = FF(b, c2, d2, a2, M_offset_15, 22, T[15]);
              a2 = GG(a2, b, c2, d2, M_offset_1, 5, T[16]);
              d2 = GG(d2, a2, b, c2, M_offset_6, 9, T[17]);
              c2 = GG(c2, d2, a2, b, M_offset_11, 14, T[18]);
              b = GG(b, c2, d2, a2, M_offset_0, 20, T[19]);
              a2 = GG(a2, b, c2, d2, M_offset_5, 5, T[20]);
              d2 = GG(d2, a2, b, c2, M_offset_10, 9, T[21]);
              c2 = GG(c2, d2, a2, b, M_offset_15, 14, T[22]);
              b = GG(b, c2, d2, a2, M_offset_4, 20, T[23]);
              a2 = GG(a2, b, c2, d2, M_offset_9, 5, T[24]);
              d2 = GG(d2, a2, b, c2, M_offset_14, 9, T[25]);
              c2 = GG(c2, d2, a2, b, M_offset_3, 14, T[26]);
              b = GG(b, c2, d2, a2, M_offset_8, 20, T[27]);
              a2 = GG(a2, b, c2, d2, M_offset_13, 5, T[28]);
              d2 = GG(d2, a2, b, c2, M_offset_2, 9, T[29]);
              c2 = GG(c2, d2, a2, b, M_offset_7, 14, T[30]);
              b = GG(b, c2, d2, a2, M_offset_12, 20, T[31]);
              a2 = HH(a2, b, c2, d2, M_offset_5, 4, T[32]);
              d2 = HH(d2, a2, b, c2, M_offset_8, 11, T[33]);
              c2 = HH(c2, d2, a2, b, M_offset_11, 16, T[34]);
              b = HH(b, c2, d2, a2, M_offset_14, 23, T[35]);
              a2 = HH(a2, b, c2, d2, M_offset_1, 4, T[36]);
              d2 = HH(d2, a2, b, c2, M_offset_4, 11, T[37]);
              c2 = HH(c2, d2, a2, b, M_offset_7, 16, T[38]);
              b = HH(b, c2, d2, a2, M_offset_10, 23, T[39]);
              a2 = HH(a2, b, c2, d2, M_offset_13, 4, T[40]);
              d2 = HH(d2, a2, b, c2, M_offset_0, 11, T[41]);
              c2 = HH(c2, d2, a2, b, M_offset_3, 16, T[42]);
              b = HH(b, c2, d2, a2, M_offset_6, 23, T[43]);
              a2 = HH(a2, b, c2, d2, M_offset_9, 4, T[44]);
              d2 = HH(d2, a2, b, c2, M_offset_12, 11, T[45]);
              c2 = HH(c2, d2, a2, b, M_offset_15, 16, T[46]);
              b = HH(b, c2, d2, a2, M_offset_2, 23, T[47]);
              a2 = II(a2, b, c2, d2, M_offset_0, 6, T[48]);
              d2 = II(d2, a2, b, c2, M_offset_7, 10, T[49]);
              c2 = II(c2, d2, a2, b, M_offset_14, 15, T[50]);
              b = II(b, c2, d2, a2, M_offset_5, 21, T[51]);
              a2 = II(a2, b, c2, d2, M_offset_12, 6, T[52]);
              d2 = II(d2, a2, b, c2, M_offset_3, 10, T[53]);
              c2 = II(c2, d2, a2, b, M_offset_10, 15, T[54]);
              b = II(b, c2, d2, a2, M_offset_1, 21, T[55]);
              a2 = II(a2, b, c2, d2, M_offset_8, 6, T[56]);
              d2 = II(d2, a2, b, c2, M_offset_15, 10, T[57]);
              c2 = II(c2, d2, a2, b, M_offset_6, 15, T[58]);
              b = II(b, c2, d2, a2, M_offset_13, 21, T[59]);
              a2 = II(a2, b, c2, d2, M_offset_4, 6, T[60]);
              d2 = II(d2, a2, b, c2, M_offset_11, 10, T[61]);
              c2 = II(c2, d2, a2, b, M_offset_2, 15, T[62]);
              b = II(b, c2, d2, a2, M_offset_9, 21, T[63]);
              H[0] = H[0] + a2 | 0;
              H[1] = H[1] + b | 0;
              H[2] = H[2] + c2 | 0;
              H[3] = H[3] + d2 | 0;
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              var nBitsTotalH = Math2.floor(nBitsTotal / 4294967296);
              var nBitsTotalL = nBitsTotal;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = (nBitsTotalH << 8 | nBitsTotalH >>> 24) & 16711935 | (nBitsTotalH << 24 | nBitsTotalH >>> 8) & 4278255360;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotalL << 8 | nBitsTotalL >>> 24) & 16711935 | (nBitsTotalL << 24 | nBitsTotalL >>> 8) & 4278255360;
              data2.sigBytes = (dataWords.length + 1) * 4;
              this._process();
              var hash2 = this._hash;
              var H = hash2.words;
              for (var i2 = 0; i2 < 4; i2++) {
                var H_i = H[i2];
                H[i2] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
              }
              return hash2;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          function FF(a2, b, c2, d2, x, s2, t2) {
            var n2 = a2 + (b & c2 | ~b & d2) + x + t2;
            return (n2 << s2 | n2 >>> 32 - s2) + b;
          }
          function GG(a2, b, c2, d2, x, s2, t2) {
            var n2 = a2 + (b & d2 | c2 & ~d2) + x + t2;
            return (n2 << s2 | n2 >>> 32 - s2) + b;
          }
          function HH(a2, b, c2, d2, x, s2, t2) {
            var n2 = a2 + (b ^ c2 ^ d2) + x + t2;
            return (n2 << s2 | n2 >>> 32 - s2) + b;
          }
          function II(a2, b, c2, d2, x, s2, t2) {
            var n2 = a2 + (c2 ^ (b | ~d2)) + x + t2;
            return (n2 << s2 | n2 >>> 32 - s2) + b;
          }
          C.MD5 = Hasher._createHelper(MD5);
          C.HmacMD5 = Hasher._createHmacHelper(MD5);
        })(Math);
        return CryptoJS.MD5;
      });
    })(md5$1, md5$1.exports);
    return md5$1.exports;
  }
  var sha1$1 = { exports: {} };
  var sha1 = sha1$1.exports;
  var hasRequiredSha1;
  function requireSha1() {
    if (hasRequiredSha1)
      return sha1$1.exports;
    hasRequiredSha1 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var W = [];
          var SHA1 = C_algo.SHA1 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                1732584193,
                4023233417,
                2562383102,
                271733878,
                3285377520
              ]);
            },
            _doProcessBlock: function(M, offset) {
              var H = this._hash.words;
              var a2 = H[0];
              var b = H[1];
              var c2 = H[2];
              var d2 = H[3];
              var e2 = H[4];
              for (var i2 = 0; i2 < 80; i2++) {
                if (i2 < 16) {
                  W[i2] = M[offset + i2] | 0;
                } else {
                  var n2 = W[i2 - 3] ^ W[i2 - 8] ^ W[i2 - 14] ^ W[i2 - 16];
                  W[i2] = n2 << 1 | n2 >>> 31;
                }
                var t2 = (a2 << 5 | a2 >>> 27) + e2 + W[i2];
                if (i2 < 20) {
                  t2 += (b & c2 | ~b & d2) + 1518500249;
                } else if (i2 < 40) {
                  t2 += (b ^ c2 ^ d2) + 1859775393;
                } else if (i2 < 60) {
                  t2 += (b & c2 | b & d2 | c2 & d2) - 1894007588;
                } else {
                  t2 += (b ^ c2 ^ d2) - 899497514;
                }
                e2 = d2;
                d2 = c2;
                c2 = b << 30 | b >>> 2;
                b = a2;
                a2 = t2;
              }
              H[0] = H[0] + a2 | 0;
              H[1] = H[1] + b | 0;
              H[2] = H[2] + c2 | 0;
              H[3] = H[3] + d2 | 0;
              H[4] = H[4] + e2 | 0;
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
              data2.sigBytes = dataWords.length * 4;
              this._process();
              return this._hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          C.SHA1 = Hasher._createHelper(SHA1);
          C.HmacSHA1 = Hasher._createHmacHelper(SHA1);
        })();
        return CryptoJS.SHA1;
      });
    })(sha1$1, sha1$1.exports);
    return sha1$1.exports;
  }
  var sha256$1 = { exports: {} };
  var sha256 = sha256$1.exports;
  var hasRequiredSha256;
  function requireSha256() {
    if (hasRequiredSha256)
      return sha256$1.exports;
    hasRequiredSha256 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var H = [];
          var K = [];
          (function() {
            function isPrime(n3) {
              var sqrtN = Math2.sqrt(n3);
              for (var factor = 2; factor <= sqrtN; factor++) {
                if (!(n3 % factor)) {
                  return false;
                }
              }
              return true;
            }
            function getFractionalBits(n3) {
              return (n3 - (n3 | 0)) * 4294967296 | 0;
            }
            var n2 = 2;
            var nPrime = 0;
            while (nPrime < 64) {
              if (isPrime(n2)) {
                if (nPrime < 8) {
                  H[nPrime] = getFractionalBits(Math2.pow(n2, 1 / 2));
                }
                K[nPrime] = getFractionalBits(Math2.pow(n2, 1 / 3));
                nPrime++;
              }
              n2++;
            }
          })();
          var W = [];
          var SHA256 = C_algo.SHA256 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init(H.slice(0));
            },
            _doProcessBlock: function(M, offset) {
              var H2 = this._hash.words;
              var a2 = H2[0];
              var b = H2[1];
              var c2 = H2[2];
              var d2 = H2[3];
              var e2 = H2[4];
              var f2 = H2[5];
              var g = H2[6];
              var h2 = H2[7];
              for (var i2 = 0; i2 < 64; i2++) {
                if (i2 < 16) {
                  W[i2] = M[offset + i2] | 0;
                } else {
                  var gamma0x = W[i2 - 15];
                  var gamma0 = (gamma0x << 25 | gamma0x >>> 7) ^ (gamma0x << 14 | gamma0x >>> 18) ^ gamma0x >>> 3;
                  var gamma1x = W[i2 - 2];
                  var gamma1 = (gamma1x << 15 | gamma1x >>> 17) ^ (gamma1x << 13 | gamma1x >>> 19) ^ gamma1x >>> 10;
                  W[i2] = gamma0 + W[i2 - 7] + gamma1 + W[i2 - 16];
                }
                var ch = e2 & f2 ^ ~e2 & g;
                var maj = a2 & b ^ a2 & c2 ^ b & c2;
                var sigma0 = (a2 << 30 | a2 >>> 2) ^ (a2 << 19 | a2 >>> 13) ^ (a2 << 10 | a2 >>> 22);
                var sigma1 = (e2 << 26 | e2 >>> 6) ^ (e2 << 21 | e2 >>> 11) ^ (e2 << 7 | e2 >>> 25);
                var t1 = h2 + sigma1 + ch + K[i2] + W[i2];
                var t2 = sigma0 + maj;
                h2 = g;
                g = f2;
                f2 = e2;
                e2 = d2 + t1 | 0;
                d2 = c2;
                c2 = b;
                b = a2;
                a2 = t1 + t2 | 0;
              }
              H2[0] = H2[0] + a2 | 0;
              H2[1] = H2[1] + b | 0;
              H2[2] = H2[2] + c2 | 0;
              H2[3] = H2[3] + d2 | 0;
              H2[4] = H2[4] + e2 | 0;
              H2[5] = H2[5] + f2 | 0;
              H2[6] = H2[6] + g | 0;
              H2[7] = H2[7] + h2 | 0;
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math2.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
              data2.sigBytes = dataWords.length * 4;
              this._process();
              return this._hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          C.SHA256 = Hasher._createHelper(SHA256);
          C.HmacSHA256 = Hasher._createHmacHelper(SHA256);
        })(Math);
        return CryptoJS.SHA256;
      });
    })(sha256$1, sha256$1.exports);
    return sha256$1.exports;
  }
  var sha224$1 = { exports: {} };
  var sha224 = sha224$1.exports;
  var hasRequiredSha224;
  function requireSha224() {
    if (hasRequiredSha224)
      return sha224$1.exports;
    hasRequiredSha224 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireSha256());
        } else if (false) {
          (void 0)(["./core", "./sha256"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var SHA256 = C_algo.SHA256;
          var SHA224 = C_algo.SHA224 = SHA256.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                3238371032,
                914150663,
                812702999,
                4144912697,
                4290775857,
                1750603025,
                1694076839,
                3204075428
              ]);
            },
            _doFinalize: function() {
              var hash2 = SHA256._doFinalize.call(this);
              hash2.sigBytes -= 4;
              return hash2;
            }
          });
          C.SHA224 = SHA256._createHelper(SHA224);
          C.HmacSHA224 = SHA256._createHmacHelper(SHA224);
        })();
        return CryptoJS.SHA224;
      });
    })(sha224$1, sha224$1.exports);
    return sha224$1.exports;
  }
  var sha512$1 = { exports: {} };
  var sha512 = sha512$1.exports;
  var hasRequiredSha512;
  function requireSha512() {
    if (hasRequiredSha512)
      return sha512$1.exports;
    hasRequiredSha512 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireX64Core());
        } else if (false) {
          (void 0)(["./core", "./x64-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Hasher = C_lib.Hasher;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var X64WordArray = C_x64.WordArray;
          var C_algo = C.algo;
          function X64Word_create() {
            return X64Word.create.apply(X64Word, arguments);
          }
          var K = [
            X64Word_create(1116352408, 3609767458),
            X64Word_create(1899447441, 602891725),
            X64Word_create(3049323471, 3964484399),
            X64Word_create(3921009573, 2173295548),
            X64Word_create(961987163, 4081628472),
            X64Word_create(1508970993, 3053834265),
            X64Word_create(2453635748, 2937671579),
            X64Word_create(2870763221, 3664609560),
            X64Word_create(3624381080, 2734883394),
            X64Word_create(310598401, 1164996542),
            X64Word_create(607225278, 1323610764),
            X64Word_create(1426881987, 3590304994),
            X64Word_create(1925078388, 4068182383),
            X64Word_create(2162078206, 991336113),
            X64Word_create(2614888103, 633803317),
            X64Word_create(3248222580, 3479774868),
            X64Word_create(3835390401, 2666613458),
            X64Word_create(4022224774, 944711139),
            X64Word_create(264347078, 2341262773),
            X64Word_create(604807628, 2007800933),
            X64Word_create(770255983, 1495990901),
            X64Word_create(1249150122, 1856431235),
            X64Word_create(1555081692, 3175218132),
            X64Word_create(1996064986, 2198950837),
            X64Word_create(2554220882, 3999719339),
            X64Word_create(2821834349, 766784016),
            X64Word_create(2952996808, 2566594879),
            X64Word_create(3210313671, 3203337956),
            X64Word_create(3336571891, 1034457026),
            X64Word_create(3584528711, 2466948901),
            X64Word_create(113926993, 3758326383),
            X64Word_create(338241895, 168717936),
            X64Word_create(666307205, 1188179964),
            X64Word_create(773529912, 1546045734),
            X64Word_create(1294757372, 1522805485),
            X64Word_create(1396182291, 2643833823),
            X64Word_create(1695183700, 2343527390),
            X64Word_create(1986661051, 1014477480),
            X64Word_create(2177026350, 1206759142),
            X64Word_create(2456956037, 344077627),
            X64Word_create(2730485921, 1290863460),
            X64Word_create(2820302411, 3158454273),
            X64Word_create(3259730800, 3505952657),
            X64Word_create(3345764771, 106217008),
            X64Word_create(3516065817, 3606008344),
            X64Word_create(3600352804, 1432725776),
            X64Word_create(4094571909, 1467031594),
            X64Word_create(275423344, 851169720),
            X64Word_create(430227734, 3100823752),
            X64Word_create(506948616, 1363258195),
            X64Word_create(659060556, 3750685593),
            X64Word_create(883997877, 3785050280),
            X64Word_create(958139571, 3318307427),
            X64Word_create(1322822218, 3812723403),
            X64Word_create(1537002063, 2003034995),
            X64Word_create(1747873779, 3602036899),
            X64Word_create(1955562222, 1575990012),
            X64Word_create(2024104815, 1125592928),
            X64Word_create(2227730452, 2716904306),
            X64Word_create(2361852424, 442776044),
            X64Word_create(2428436474, 593698344),
            X64Word_create(2756734187, 3733110249),
            X64Word_create(3204031479, 2999351573),
            X64Word_create(3329325298, 3815920427),
            X64Word_create(3391569614, 3928383900),
            X64Word_create(3515267271, 566280711),
            X64Word_create(3940187606, 3454069534),
            X64Word_create(4118630271, 4000239992),
            X64Word_create(116418474, 1914138554),
            X64Word_create(174292421, 2731055270),
            X64Word_create(289380356, 3203993006),
            X64Word_create(460393269, 320620315),
            X64Word_create(685471733, 587496836),
            X64Word_create(852142971, 1086792851),
            X64Word_create(1017036298, 365543100),
            X64Word_create(1126000580, 2618297676),
            X64Word_create(1288033470, 3409855158),
            X64Word_create(1501505948, 4234509866),
            X64Word_create(1607167915, 987167468),
            X64Word_create(1816402316, 1246189591)
          ];
          var W = [];
          (function() {
            for (var i2 = 0; i2 < 80; i2++) {
              W[i2] = X64Word_create();
            }
          })();
          var SHA512 = C_algo.SHA512 = Hasher.extend({
            _doReset: function() {
              this._hash = new X64WordArray.init([
                new X64Word.init(1779033703, 4089235720),
                new X64Word.init(3144134277, 2227873595),
                new X64Word.init(1013904242, 4271175723),
                new X64Word.init(2773480762, 1595750129),
                new X64Word.init(1359893119, 2917565137),
                new X64Word.init(2600822924, 725511199),
                new X64Word.init(528734635, 4215389547),
                new X64Word.init(1541459225, 327033209)
              ]);
            },
            _doProcessBlock: function(M, offset) {
              var H = this._hash.words;
              var H0 = H[0];
              var H1 = H[1];
              var H2 = H[2];
              var H3 = H[3];
              var H4 = H[4];
              var H5 = H[5];
              var H6 = H[6];
              var H7 = H[7];
              var H0h = H0.high;
              var H0l = H0.low;
              var H1h = H1.high;
              var H1l = H1.low;
              var H2h = H2.high;
              var H2l = H2.low;
              var H3h = H3.high;
              var H3l = H3.low;
              var H4h = H4.high;
              var H4l = H4.low;
              var H5h = H5.high;
              var H5l = H5.low;
              var H6h = H6.high;
              var H6l = H6.low;
              var H7h = H7.high;
              var H7l = H7.low;
              var ah = H0h;
              var al = H0l;
              var bh = H1h;
              var bl = H1l;
              var ch = H2h;
              var cl = H2l;
              var dh = H3h;
              var dl = H3l;
              var eh = H4h;
              var el = H4l;
              var fh = H5h;
              var fl = H5l;
              var gh = H6h;
              var gl = H6l;
              var hh = H7h;
              var hl = H7l;
              for (var i2 = 0; i2 < 80; i2++) {
                var Wil;
                var Wih;
                var Wi = W[i2];
                if (i2 < 16) {
                  Wih = Wi.high = M[offset + i2 * 2] | 0;
                  Wil = Wi.low = M[offset + i2 * 2 + 1] | 0;
                } else {
                  var gamma0x = W[i2 - 15];
                  var gamma0xh = gamma0x.high;
                  var gamma0xl = gamma0x.low;
                  var gamma0h = (gamma0xh >>> 1 | gamma0xl << 31) ^ (gamma0xh >>> 8 | gamma0xl << 24) ^ gamma0xh >>> 7;
                  var gamma0l = (gamma0xl >>> 1 | gamma0xh << 31) ^ (gamma0xl >>> 8 | gamma0xh << 24) ^ (gamma0xl >>> 7 | gamma0xh << 25);
                  var gamma1x = W[i2 - 2];
                  var gamma1xh = gamma1x.high;
                  var gamma1xl = gamma1x.low;
                  var gamma1h = (gamma1xh >>> 19 | gamma1xl << 13) ^ (gamma1xh << 3 | gamma1xl >>> 29) ^ gamma1xh >>> 6;
                  var gamma1l = (gamma1xl >>> 19 | gamma1xh << 13) ^ (gamma1xl << 3 | gamma1xh >>> 29) ^ (gamma1xl >>> 6 | gamma1xh << 26);
                  var Wi7 = W[i2 - 7];
                  var Wi7h = Wi7.high;
                  var Wi7l = Wi7.low;
                  var Wi16 = W[i2 - 16];
                  var Wi16h = Wi16.high;
                  var Wi16l = Wi16.low;
                  Wil = gamma0l + Wi7l;
                  Wih = gamma0h + Wi7h + (Wil >>> 0 < gamma0l >>> 0 ? 1 : 0);
                  Wil = Wil + gamma1l;
                  Wih = Wih + gamma1h + (Wil >>> 0 < gamma1l >>> 0 ? 1 : 0);
                  Wil = Wil + Wi16l;
                  Wih = Wih + Wi16h + (Wil >>> 0 < Wi16l >>> 0 ? 1 : 0);
                  Wi.high = Wih;
                  Wi.low = Wil;
                }
                var chh = eh & fh ^ ~eh & gh;
                var chl = el & fl ^ ~el & gl;
                var majh = ah & bh ^ ah & ch ^ bh & ch;
                var majl = al & bl ^ al & cl ^ bl & cl;
                var sigma0h = (ah >>> 28 | al << 4) ^ (ah << 30 | al >>> 2) ^ (ah << 25 | al >>> 7);
                var sigma0l = (al >>> 28 | ah << 4) ^ (al << 30 | ah >>> 2) ^ (al << 25 | ah >>> 7);
                var sigma1h = (eh >>> 14 | el << 18) ^ (eh >>> 18 | el << 14) ^ (eh << 23 | el >>> 9);
                var sigma1l = (el >>> 14 | eh << 18) ^ (el >>> 18 | eh << 14) ^ (el << 23 | eh >>> 9);
                var Ki = K[i2];
                var Kih = Ki.high;
                var Kil = Ki.low;
                var t1l = hl + sigma1l;
                var t1h = hh + sigma1h + (t1l >>> 0 < hl >>> 0 ? 1 : 0);
                var t1l = t1l + chl;
                var t1h = t1h + chh + (t1l >>> 0 < chl >>> 0 ? 1 : 0);
                var t1l = t1l + Kil;
                var t1h = t1h + Kih + (t1l >>> 0 < Kil >>> 0 ? 1 : 0);
                var t1l = t1l + Wil;
                var t1h = t1h + Wih + (t1l >>> 0 < Wil >>> 0 ? 1 : 0);
                var t2l = sigma0l + majl;
                var t2h = sigma0h + majh + (t2l >>> 0 < sigma0l >>> 0 ? 1 : 0);
                hh = gh;
                hl = gl;
                gh = fh;
                gl = fl;
                fh = eh;
                fl = el;
                el = dl + t1l | 0;
                eh = dh + t1h + (el >>> 0 < dl >>> 0 ? 1 : 0) | 0;
                dh = ch;
                dl = cl;
                ch = bh;
                cl = bl;
                bh = ah;
                bl = al;
                al = t1l + t2l | 0;
                ah = t1h + t2h + (al >>> 0 < t1l >>> 0 ? 1 : 0) | 0;
              }
              H0l = H0.low = H0l + al;
              H0.high = H0h + ah + (H0l >>> 0 < al >>> 0 ? 1 : 0);
              H1l = H1.low = H1l + bl;
              H1.high = H1h + bh + (H1l >>> 0 < bl >>> 0 ? 1 : 0);
              H2l = H2.low = H2l + cl;
              H2.high = H2h + ch + (H2l >>> 0 < cl >>> 0 ? 1 : 0);
              H3l = H3.low = H3l + dl;
              H3.high = H3h + dh + (H3l >>> 0 < dl >>> 0 ? 1 : 0);
              H4l = H4.low = H4l + el;
              H4.high = H4h + eh + (H4l >>> 0 < el >>> 0 ? 1 : 0);
              H5l = H5.low = H5l + fl;
              H5.high = H5h + fh + (H5l >>> 0 < fl >>> 0 ? 1 : 0);
              H6l = H6.low = H6l + gl;
              H6.high = H6h + gh + (H6l >>> 0 < gl >>> 0 ? 1 : 0);
              H7l = H7.low = H7l + hl;
              H7.high = H7h + hh + (H7l >>> 0 < hl >>> 0 ? 1 : 0);
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 128 >>> 10 << 5) + 30] = Math.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 128 >>> 10 << 5) + 31] = nBitsTotal;
              data2.sigBytes = dataWords.length * 4;
              this._process();
              var hash2 = this._hash.toX32();
              return hash2;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            },
            blockSize: 1024 / 32
          });
          C.SHA512 = Hasher._createHelper(SHA512);
          C.HmacSHA512 = Hasher._createHmacHelper(SHA512);
        })();
        return CryptoJS.SHA512;
      });
    })(sha512$1, sha512$1.exports);
    return sha512$1.exports;
  }
  var sha384$1 = { exports: {} };
  var sha384 = sha384$1.exports;
  var hasRequiredSha384;
  function requireSha384() {
    if (hasRequiredSha384)
      return sha384$1.exports;
    hasRequiredSha384 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireX64Core(), requireSha512());
        } else if (false) {
          (void 0)(["./core", "./x64-core", "./sha512"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var X64WordArray = C_x64.WordArray;
          var C_algo = C.algo;
          var SHA512 = C_algo.SHA512;
          var SHA384 = C_algo.SHA384 = SHA512.extend({
            _doReset: function() {
              this._hash = new X64WordArray.init([
                new X64Word.init(3418070365, 3238371032),
                new X64Word.init(1654270250, 914150663),
                new X64Word.init(2438529370, 812702999),
                new X64Word.init(355462360, 4144912697),
                new X64Word.init(1731405415, 4290775857),
                new X64Word.init(2394180231, 1750603025),
                new X64Word.init(3675008525, 1694076839),
                new X64Word.init(1203062813, 3204075428)
              ]);
            },
            _doFinalize: function() {
              var hash2 = SHA512._doFinalize.call(this);
              hash2.sigBytes -= 16;
              return hash2;
            }
          });
          C.SHA384 = SHA512._createHelper(SHA384);
          C.HmacSHA384 = SHA512._createHmacHelper(SHA384);
        })();
        return CryptoJS.SHA384;
      });
    })(sha384$1, sha384$1.exports);
    return sha384$1.exports;
  }
  var sha3$1 = { exports: {} };
  var sha3 = sha3$1.exports;
  var hasRequiredSha3;
  function requireSha3() {
    if (hasRequiredSha3)
      return sha3$1.exports;
    hasRequiredSha3 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireX64Core());
        } else if (false) {
          (void 0)(["./core", "./x64-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var C_algo = C.algo;
          var RHO_OFFSETS = [];
          var PI_INDEXES = [];
          var ROUND_CONSTANTS = [];
          (function() {
            var x = 1, y = 0;
            for (var t2 = 0; t2 < 24; t2++) {
              RHO_OFFSETS[x + 5 * y] = (t2 + 1) * (t2 + 2) / 2 % 64;
              var newX = y % 5;
              var newY = (2 * x + 3 * y) % 5;
              x = newX;
              y = newY;
            }
            for (var x = 0; x < 5; x++) {
              for (var y = 0; y < 5; y++) {
                PI_INDEXES[x + 5 * y] = y + (2 * x + 3 * y) % 5 * 5;
              }
            }
            var LFSR = 1;
            for (var i2 = 0; i2 < 24; i2++) {
              var roundConstantMsw = 0;
              var roundConstantLsw = 0;
              for (var j = 0; j < 7; j++) {
                if (LFSR & 1) {
                  var bitPosition = (1 << j) - 1;
                  if (bitPosition < 32) {
                    roundConstantLsw ^= 1 << bitPosition;
                  } else {
                    roundConstantMsw ^= 1 << bitPosition - 32;
                  }
                }
                if (LFSR & 128) {
                  LFSR = LFSR << 1 ^ 113;
                } else {
                  LFSR <<= 1;
                }
              }
              ROUND_CONSTANTS[i2] = X64Word.create(roundConstantMsw, roundConstantLsw);
            }
          })();
          var T = [];
          (function() {
            for (var i2 = 0; i2 < 25; i2++) {
              T[i2] = X64Word.create();
            }
          })();
          var SHA3 = C_algo.SHA3 = Hasher.extend({
            /**
             * Configuration options.
             *
             * @property {number} outputLength
             *   The desired number of bits in the output hash.
             *   Only values permitted are: 224, 256, 384, 512.
             *   Default: 512
             */
            cfg: Hasher.cfg.extend({
              outputLength: 512
            }),
            _doReset: function() {
              var state = this._state = [];
              for (var i2 = 0; i2 < 25; i2++) {
                state[i2] = new X64Word.init();
              }
              this.blockSize = (1600 - 2 * this.cfg.outputLength) / 32;
            },
            _doProcessBlock: function(M, offset) {
              var state = this._state;
              var nBlockSizeLanes = this.blockSize / 2;
              for (var i2 = 0; i2 < nBlockSizeLanes; i2++) {
                var M2i = M[offset + 2 * i2];
                var M2i1 = M[offset + 2 * i2 + 1];
                M2i = (M2i << 8 | M2i >>> 24) & 16711935 | (M2i << 24 | M2i >>> 8) & 4278255360;
                M2i1 = (M2i1 << 8 | M2i1 >>> 24) & 16711935 | (M2i1 << 24 | M2i1 >>> 8) & 4278255360;
                var lane = state[i2];
                lane.high ^= M2i1;
                lane.low ^= M2i;
              }
              for (var round = 0; round < 24; round++) {
                for (var x = 0; x < 5; x++) {
                  var tMsw = 0, tLsw = 0;
                  for (var y = 0; y < 5; y++) {
                    var lane = state[x + 5 * y];
                    tMsw ^= lane.high;
                    tLsw ^= lane.low;
                  }
                  var Tx = T[x];
                  Tx.high = tMsw;
                  Tx.low = tLsw;
                }
                for (var x = 0; x < 5; x++) {
                  var Tx4 = T[(x + 4) % 5];
                  var Tx1 = T[(x + 1) % 5];
                  var Tx1Msw = Tx1.high;
                  var Tx1Lsw = Tx1.low;
                  var tMsw = Tx4.high ^ (Tx1Msw << 1 | Tx1Lsw >>> 31);
                  var tLsw = Tx4.low ^ (Tx1Lsw << 1 | Tx1Msw >>> 31);
                  for (var y = 0; y < 5; y++) {
                    var lane = state[x + 5 * y];
                    lane.high ^= tMsw;
                    lane.low ^= tLsw;
                  }
                }
                for (var laneIndex = 1; laneIndex < 25; laneIndex++) {
                  var tMsw;
                  var tLsw;
                  var lane = state[laneIndex];
                  var laneMsw = lane.high;
                  var laneLsw = lane.low;
                  var rhoOffset = RHO_OFFSETS[laneIndex];
                  if (rhoOffset < 32) {
                    tMsw = laneMsw << rhoOffset | laneLsw >>> 32 - rhoOffset;
                    tLsw = laneLsw << rhoOffset | laneMsw >>> 32 - rhoOffset;
                  } else {
                    tMsw = laneLsw << rhoOffset - 32 | laneMsw >>> 64 - rhoOffset;
                    tLsw = laneMsw << rhoOffset - 32 | laneLsw >>> 64 - rhoOffset;
                  }
                  var TPiLane = T[PI_INDEXES[laneIndex]];
                  TPiLane.high = tMsw;
                  TPiLane.low = tLsw;
                }
                var T0 = T[0];
                var state0 = state[0];
                T0.high = state0.high;
                T0.low = state0.low;
                for (var x = 0; x < 5; x++) {
                  for (var y = 0; y < 5; y++) {
                    var laneIndex = x + 5 * y;
                    var lane = state[laneIndex];
                    var TLane = T[laneIndex];
                    var Tx1Lane = T[(x + 1) % 5 + 5 * y];
                    var Tx2Lane = T[(x + 2) % 5 + 5 * y];
                    lane.high = TLane.high ^ ~Tx1Lane.high & Tx2Lane.high;
                    lane.low = TLane.low ^ ~Tx1Lane.low & Tx2Lane.low;
                  }
                }
                var lane = state[0];
                var roundConstant = ROUND_CONSTANTS[round];
                lane.high ^= roundConstant.high;
                lane.low ^= roundConstant.low;
              }
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              var blockSizeBits = this.blockSize * 32;
              dataWords[nBitsLeft >>> 5] |= 1 << 24 - nBitsLeft % 32;
              dataWords[(Math2.ceil((nBitsLeft + 1) / blockSizeBits) * blockSizeBits >>> 5) - 1] |= 128;
              data2.sigBytes = dataWords.length * 4;
              this._process();
              var state = this._state;
              var outputLengthBytes = this.cfg.outputLength / 8;
              var outputLengthLanes = outputLengthBytes / 8;
              var hashWords = [];
              for (var i2 = 0; i2 < outputLengthLanes; i2++) {
                var lane = state[i2];
                var laneMsw = lane.high;
                var laneLsw = lane.low;
                laneMsw = (laneMsw << 8 | laneMsw >>> 24) & 16711935 | (laneMsw << 24 | laneMsw >>> 8) & 4278255360;
                laneLsw = (laneLsw << 8 | laneLsw >>> 24) & 16711935 | (laneLsw << 24 | laneLsw >>> 8) & 4278255360;
                hashWords.push(laneLsw);
                hashWords.push(laneMsw);
              }
              return new WordArray.init(hashWords, outputLengthBytes);
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              var state = clone._state = this._state.slice(0);
              for (var i2 = 0; i2 < 25; i2++) {
                state[i2] = state[i2].clone();
              }
              return clone;
            }
          });
          C.SHA3 = Hasher._createHelper(SHA3);
          C.HmacSHA3 = Hasher._createHmacHelper(SHA3);
        })(Math);
        return CryptoJS.SHA3;
      });
    })(sha3$1, sha3$1.exports);
    return sha3$1.exports;
  }
  var ripemd160$1 = { exports: {} };
  var ripemd160 = ripemd160$1.exports;
  var hasRequiredRipemd160;
  function requireRipemd160() {
    if (hasRequiredRipemd160)
      return ripemd160$1.exports;
    hasRequiredRipemd160 = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        /** @preserve
          			(c) 2012 by Cédric Mesnil. All rights reserved.
        
          			Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
        
          			    - Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
          			    - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
        
          			THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
          			*/
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var _zl = WordArray.create([
            0,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            9,
            10,
            11,
            12,
            13,
            14,
            15,
            7,
            4,
            13,
            1,
            10,
            6,
            15,
            3,
            12,
            0,
            9,
            5,
            2,
            14,
            11,
            8,
            3,
            10,
            14,
            4,
            9,
            15,
            8,
            1,
            2,
            7,
            0,
            6,
            13,
            11,
            5,
            12,
            1,
            9,
            11,
            10,
            0,
            8,
            12,
            4,
            13,
            3,
            7,
            15,
            14,
            5,
            6,
            2,
            4,
            0,
            5,
            9,
            7,
            12,
            2,
            10,
            14,
            1,
            3,
            8,
            11,
            6,
            15,
            13
          ]);
          var _zr = WordArray.create([
            5,
            14,
            7,
            0,
            9,
            2,
            11,
            4,
            13,
            6,
            15,
            8,
            1,
            10,
            3,
            12,
            6,
            11,
            3,
            7,
            0,
            13,
            5,
            10,
            14,
            15,
            8,
            12,
            4,
            9,
            1,
            2,
            15,
            5,
            1,
            3,
            7,
            14,
            6,
            9,
            11,
            8,
            12,
            2,
            10,
            0,
            4,
            13,
            8,
            6,
            4,
            1,
            3,
            11,
            15,
            0,
            5,
            12,
            2,
            13,
            9,
            7,
            10,
            14,
            12,
            15,
            10,
            4,
            1,
            5,
            8,
            7,
            6,
            2,
            13,
            14,
            0,
            3,
            9,
            11
          ]);
          var _sl = WordArray.create([
            11,
            14,
            15,
            12,
            5,
            8,
            7,
            9,
            11,
            13,
            14,
            15,
            6,
            7,
            9,
            8,
            7,
            6,
            8,
            13,
            11,
            9,
            7,
            15,
            7,
            12,
            15,
            9,
            11,
            7,
            13,
            12,
            11,
            13,
            6,
            7,
            14,
            9,
            13,
            15,
            14,
            8,
            13,
            6,
            5,
            12,
            7,
            5,
            11,
            12,
            14,
            15,
            14,
            15,
            9,
            8,
            9,
            14,
            5,
            6,
            8,
            6,
            5,
            12,
            9,
            15,
            5,
            11,
            6,
            8,
            13,
            12,
            5,
            12,
            13,
            14,
            11,
            8,
            5,
            6
          ]);
          var _sr = WordArray.create([
            8,
            9,
            9,
            11,
            13,
            15,
            15,
            5,
            7,
            7,
            8,
            11,
            14,
            14,
            12,
            6,
            9,
            13,
            15,
            7,
            12,
            8,
            9,
            11,
            7,
            7,
            12,
            7,
            6,
            15,
            13,
            11,
            9,
            7,
            15,
            11,
            8,
            6,
            6,
            14,
            12,
            13,
            5,
            14,
            13,
            13,
            7,
            5,
            15,
            5,
            8,
            11,
            14,
            14,
            6,
            14,
            6,
            9,
            12,
            9,
            12,
            5,
            15,
            8,
            8,
            5,
            12,
            9,
            12,
            5,
            14,
            6,
            8,
            13,
            6,
            5,
            15,
            13,
            11,
            11
          ]);
          var _hl = WordArray.create([0, 1518500249, 1859775393, 2400959708, 2840853838]);
          var _hr = WordArray.create([1352829926, 1548603684, 1836072691, 2053994217, 0]);
          var RIPEMD160 = C_algo.RIPEMD160 = Hasher.extend({
            _doReset: function() {
              this._hash = WordArray.create([1732584193, 4023233417, 2562383102, 271733878, 3285377520]);
            },
            _doProcessBlock: function(M, offset) {
              for (var i2 = 0; i2 < 16; i2++) {
                var offset_i = offset + i2;
                var M_offset_i = M[offset_i];
                M[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
              }
              var H = this._hash.words;
              var hl = _hl.words;
              var hr = _hr.words;
              var zl = _zl.words;
              var zr = _zr.words;
              var sl = _sl.words;
              var sr = _sr.words;
              var al, bl, cl, dl, el;
              var ar, br, cr, dr, er;
              ar = al = H[0];
              br = bl = H[1];
              cr = cl = H[2];
              dr = dl = H[3];
              er = el = H[4];
              var t2;
              for (var i2 = 0; i2 < 80; i2 += 1) {
                t2 = al + M[offset + zl[i2]] | 0;
                if (i2 < 16) {
                  t2 += f1(bl, cl, dl) + hl[0];
                } else if (i2 < 32) {
                  t2 += f2(bl, cl, dl) + hl[1];
                } else if (i2 < 48) {
                  t2 += f3(bl, cl, dl) + hl[2];
                } else if (i2 < 64) {
                  t2 += f4(bl, cl, dl) + hl[3];
                } else {
                  t2 += f5(bl, cl, dl) + hl[4];
                }
                t2 = t2 | 0;
                t2 = rotl(t2, sl[i2]);
                t2 = t2 + el | 0;
                al = el;
                el = dl;
                dl = rotl(cl, 10);
                cl = bl;
                bl = t2;
                t2 = ar + M[offset + zr[i2]] | 0;
                if (i2 < 16) {
                  t2 += f5(br, cr, dr) + hr[0];
                } else if (i2 < 32) {
                  t2 += f4(br, cr, dr) + hr[1];
                } else if (i2 < 48) {
                  t2 += f3(br, cr, dr) + hr[2];
                } else if (i2 < 64) {
                  t2 += f2(br, cr, dr) + hr[3];
                } else {
                  t2 += f1(br, cr, dr) + hr[4];
                }
                t2 = t2 | 0;
                t2 = rotl(t2, sr[i2]);
                t2 = t2 + er | 0;
                ar = er;
                er = dr;
                dr = rotl(cr, 10);
                cr = br;
                br = t2;
              }
              t2 = H[1] + cl + dr | 0;
              H[1] = H[2] + dl + er | 0;
              H[2] = H[3] + el + ar | 0;
              H[3] = H[4] + al + br | 0;
              H[4] = H[0] + bl + cr | 0;
              H[0] = t2;
            },
            _doFinalize: function() {
              var data2 = this._data;
              var dataWords = data2.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data2.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotal << 8 | nBitsTotal >>> 24) & 16711935 | (nBitsTotal << 24 | nBitsTotal >>> 8) & 4278255360;
              data2.sigBytes = (dataWords.length + 1) * 4;
              this._process();
              var hash2 = this._hash;
              var H = hash2.words;
              for (var i2 = 0; i2 < 5; i2++) {
                var H_i = H[i2];
                H[i2] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
              }
              return hash2;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          function f1(x, y, z) {
            return x ^ y ^ z;
          }
          function f2(x, y, z) {
            return x & y | ~x & z;
          }
          function f3(x, y, z) {
            return (x | ~y) ^ z;
          }
          function f4(x, y, z) {
            return x & z | y & ~z;
          }
          function f5(x, y, z) {
            return x ^ (y | ~z);
          }
          function rotl(x, n2) {
            return x << n2 | x >>> 32 - n2;
          }
          C.RIPEMD160 = Hasher._createHelper(RIPEMD160);
          C.HmacRIPEMD160 = Hasher._createHmacHelper(RIPEMD160);
        })(Math);
        return CryptoJS.RIPEMD160;
      });
    })(ripemd160$1, ripemd160$1.exports);
    return ripemd160$1.exports;
  }
  var hmac$1 = { exports: {} };
  var hmac = hmac$1.exports;
  var hasRequiredHmac;
  function requireHmac() {
    if (hasRequiredHmac)
      return hmac$1.exports;
    hasRequiredHmac = 1;
    (function(module, exports) {
      ;
      (function(root, factory) {
        if (true) {
          module.exports = exports = factory(requireCore());
        } else if (false) {
          (void 0)(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var C_enc = C.enc;
          var Utf8 = C_enc.Utf8;
          var C_algo = C.algo;
          var HMAC = C_algo.HMAC = Base.extend({
            /**
             * Initializes a newly created HMAC.
             *
             * @param {Hasher} hasher The hash algorithm to use.
             * @param {WordArray|string} key The secret key.
             *
             * @example
             *
             *     var hmacHasher = CryptoJS.algo.HMAC.create(CryptoJS.algo.SHA256, key);
             */
            init: function(hasher, key2) {
              hasher = this._hasher = new hasher.init();
              if (typeof key2 == "string") {
                key2 = Utf8.parse(key2);
              }
              var hasherBlockSize = hasher.blockSize;
              var hasherBlockSizeBytes = hasherBlockSize * 4;
              if (key2.sigBytes > hasherBlockSizeBytes) {
                key2 = hasher.finalize(key2);
              }
              key2.clamp();
              var oKey = this._oKey = key2.clone();
              var iKey = this._iKey = key2.clone();
              var oKeyWords = oKey.words;
              var iKeyWords = iKey.words;
              for (var i2 = 0; i2 < hasherBlockSize; i2++) {
                oKeyWords[i2] ^= 1549556828;
                iKeyWords[i2] ^= 909522486;
              }
              oKey.sigBytes = iKey.sigBytes = hasherBlockSizeBytes;
              this.reset();
            },
            /**
             * Resets this HMAC to its initial state.
             *
             * @example
             *
             *     hmacHasher.reset();
             */
            reset: function() {
              var hasher = this._hasher;
              hasher.reset();
              hasher.update(this._iKey);
            },
            /**
             * Updates this HMAC with a message.
             *
             * @param {WordArray|string} messageUpdate The message to append.
             *
             * @return {HMAC} This HMAC instance.
             *
             * @example
             *
             *     hmacHasher.update('message');
             *     hmacHasher.update(wordArray);
             */
            update: function(messageUpdate) {
              this._hasher.update(messageUpdate);
              return this;
            },
            /**
             * Finalizes the HMAC computation.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} messageUpdate (Optional) A final message update.
             *
             * @return {WordArray} The HMAC.
             *
             * @example
             *
             *     var hmac = hmacHasher.finalize();
             *     var hmac = hmacHasher.finalize('message');
             *     var hmac = hmacHasher.finalize(wordArray);
             */
            finalize: function(messageUpdate) {
              var hasher = this._hasher;
              var innerHash = hasher.finalize(messageUpdate);
              hasher.reset();
              var hmac2 = hasher.finalize(this._oKey.clone().concat(innerHash));
              return hmac2;
            }
          });
        })();
      });
    })(hmac$1, hmac$1.exports);
    return hmac$1.exports;
  }
  var pbkdf2$1 = { exports: {} };
  var pbkdf2 = pbkdf2$1.exports;
  var hasRequiredPbkdf2;
  function requirePbkdf2() {
    if (hasRequiredPbkdf2)
      return pbkdf2$1.exports;
    hasRequiredPbkdf2 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireSha256(), requireHmac());
        } else if (false) {
          (void 0)(["./core", "./sha256", "./hmac"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var SHA256 = C_algo.SHA256;
          var HMAC = C_algo.HMAC;
          var PBKDF2 = C_algo.PBKDF2 = Base.extend({
            /**
             * Configuration options.
             *
             * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
             * @property {Hasher} hasher The hasher to use. Default: SHA256
             * @property {number} iterations The number of iterations to perform. Default: 250000
             */
            cfg: Base.extend({
              keySize: 128 / 32,
              hasher: SHA256,
              iterations: 25e4
            }),
            /**
             * Initializes a newly created key derivation function.
             *
             * @param {Object} cfg (Optional) The configuration options to use for the derivation.
             *
             * @example
             *
             *     var kdf = CryptoJS.algo.PBKDF2.create();
             *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8 });
             *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8, iterations: 1000 });
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
            },
            /**
             * Computes the Password-Based Key Derivation Function 2.
             *
             * @param {WordArray|string} password The password.
             * @param {WordArray|string} salt A salt.
             *
             * @return {WordArray} The derived key.
             *
             * @example
             *
             *     var key = kdf.compute(password, salt);
             */
            compute: function(password, salt) {
              var cfg = this.cfg;
              var hmac2 = HMAC.create(cfg.hasher, password);
              var derivedKey = WordArray.create();
              var blockIndex = WordArray.create([1]);
              var derivedKeyWords = derivedKey.words;
              var blockIndexWords = blockIndex.words;
              var keySize = cfg.keySize;
              var iterations = cfg.iterations;
              while (derivedKeyWords.length < keySize) {
                var block = hmac2.update(salt).finalize(blockIndex);
                hmac2.reset();
                var blockWords = block.words;
                var blockWordsLength = blockWords.length;
                var intermediate = block;
                for (var i2 = 1; i2 < iterations; i2++) {
                  intermediate = hmac2.finalize(intermediate);
                  hmac2.reset();
                  var intermediateWords = intermediate.words;
                  for (var j = 0; j < blockWordsLength; j++) {
                    blockWords[j] ^= intermediateWords[j];
                  }
                }
                derivedKey.concat(block);
                blockIndexWords[0]++;
              }
              derivedKey.sigBytes = keySize * 4;
              return derivedKey;
            }
          });
          C.PBKDF2 = function(password, salt, cfg) {
            return PBKDF2.create(cfg).compute(password, salt);
          };
        })();
        return CryptoJS.PBKDF2;
      });
    })(pbkdf2$1, pbkdf2$1.exports);
    return pbkdf2$1.exports;
  }
  var evpkdf$1 = { exports: {} };
  var evpkdf = evpkdf$1.exports;
  var hasRequiredEvpkdf;
  function requireEvpkdf() {
    if (hasRequiredEvpkdf)
      return evpkdf$1.exports;
    hasRequiredEvpkdf = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireSha1(), requireHmac());
        } else if (false) {
          (void 0)(["./core", "./sha1", "./hmac"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var MD5 = C_algo.MD5;
          var EvpKDF = C_algo.EvpKDF = Base.extend({
            /**
             * Configuration options.
             *
             * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
             * @property {Hasher} hasher The hash algorithm to use. Default: MD5
             * @property {number} iterations The number of iterations to perform. Default: 1
             */
            cfg: Base.extend({
              keySize: 128 / 32,
              hasher: MD5,
              iterations: 1
            }),
            /**
             * Initializes a newly created key derivation function.
             *
             * @param {Object} cfg (Optional) The configuration options to use for the derivation.
             *
             * @example
             *
             *     var kdf = CryptoJS.algo.EvpKDF.create();
             *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8 });
             *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8, iterations: 1000 });
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
            },
            /**
             * Derives a key from a password.
             *
             * @param {WordArray|string} password The password.
             * @param {WordArray|string} salt A salt.
             *
             * @return {WordArray} The derived key.
             *
             * @example
             *
             *     var key = kdf.compute(password, salt);
             */
            compute: function(password, salt) {
              var block;
              var cfg = this.cfg;
              var hasher = cfg.hasher.create();
              var derivedKey = WordArray.create();
              var derivedKeyWords = derivedKey.words;
              var keySize = cfg.keySize;
              var iterations = cfg.iterations;
              while (derivedKeyWords.length < keySize) {
                if (block) {
                  hasher.update(block);
                }
                block = hasher.update(password).finalize(salt);
                hasher.reset();
                for (var i2 = 1; i2 < iterations; i2++) {
                  block = hasher.finalize(block);
                  hasher.reset();
                }
                derivedKey.concat(block);
              }
              derivedKey.sigBytes = keySize * 4;
              return derivedKey;
            }
          });
          C.EvpKDF = function(password, salt, cfg) {
            return EvpKDF.create(cfg).compute(password, salt);
          };
        })();
        return CryptoJS.EvpKDF;
      });
    })(evpkdf$1, evpkdf$1.exports);
    return evpkdf$1.exports;
  }
  var cipherCore$1 = { exports: {} };
  var cipherCore = cipherCore$1.exports;
  var hasRequiredCipherCore;
  function requireCipherCore() {
    if (hasRequiredCipherCore)
      return cipherCore$1.exports;
    hasRequiredCipherCore = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEvpkdf());
        } else if (false) {
          (void 0)(["./core", "./evpkdf"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.lib.Cipher || function(undefined$1) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm;
          var C_enc = C.enc;
          var Utf8 = C_enc.Utf8;
          var Base64 = C_enc.Base64;
          var C_algo = C.algo;
          var EvpKDF = C_algo.EvpKDF;
          var Cipher = C_lib.Cipher = BufferedBlockAlgorithm.extend({
            /**
             * Configuration options.
             *
             * @property {WordArray} iv The IV to use for this operation.
             */
            cfg: Base.extend(),
            /**
             * Creates this cipher in encryption mode.
             *
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {Cipher} A cipher instance.
             *
             * @static
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.createEncryptor(keyWordArray, { iv: ivWordArray });
             */
            createEncryptor: function(key2, cfg) {
              return this.create(this._ENC_XFORM_MODE, key2, cfg);
            },
            /**
             * Creates this cipher in decryption mode.
             *
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {Cipher} A cipher instance.
             *
             * @static
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.createDecryptor(keyWordArray, { iv: ivWordArray });
             */
            createDecryptor: function(key2, cfg) {
              return this.create(this._DEC_XFORM_MODE, key2, cfg);
            },
            /**
             * Initializes a newly created cipher.
             *
             * @param {number} xformMode Either the encryption or decryption transormation mode constant.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.create(CryptoJS.algo.AES._ENC_XFORM_MODE, keyWordArray, { iv: ivWordArray });
             */
            init: function(xformMode, key2, cfg) {
              this.cfg = this.cfg.extend(cfg);
              this._xformMode = xformMode;
              this._key = key2;
              this.reset();
            },
            /**
             * Resets this cipher to its initial state.
             *
             * @example
             *
             *     cipher.reset();
             */
            reset: function() {
              BufferedBlockAlgorithm.reset.call(this);
              this._doReset();
            },
            /**
             * Adds data to be encrypted or decrypted.
             *
             * @param {WordArray|string} dataUpdate The data to encrypt or decrypt.
             *
             * @return {WordArray} The data after processing.
             *
             * @example
             *
             *     var encrypted = cipher.process('data');
             *     var encrypted = cipher.process(wordArray);
             */
            process: function(dataUpdate) {
              this._append(dataUpdate);
              return this._process();
            },
            /**
             * Finalizes the encryption or decryption process.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} dataUpdate The final data to encrypt or decrypt.
             *
             * @return {WordArray} The data after final processing.
             *
             * @example
             *
             *     var encrypted = cipher.finalize();
             *     var encrypted = cipher.finalize('data');
             *     var encrypted = cipher.finalize(wordArray);
             */
            finalize: function(dataUpdate) {
              if (dataUpdate) {
                this._append(dataUpdate);
              }
              var finalProcessedData = this._doFinalize();
              return finalProcessedData;
            },
            keySize: 128 / 32,
            ivSize: 128 / 32,
            _ENC_XFORM_MODE: 1,
            _DEC_XFORM_MODE: 2,
            /**
             * Creates shortcut functions to a cipher's object interface.
             *
             * @param {Cipher} cipher The cipher to create a helper for.
             *
             * @return {Object} An object with encrypt and decrypt shortcut functions.
             *
             * @static
             *
             * @example
             *
             *     var AES = CryptoJS.lib.Cipher._createHelper(CryptoJS.algo.AES);
             */
            _createHelper: /* @__PURE__ */ function() {
              function selectCipherStrategy(key2) {
                if (typeof key2 == "string") {
                  return PasswordBasedCipher;
                } else {
                  return SerializableCipher;
                }
              }
              return function(cipher) {
                return {
                  encrypt: function(message, key2, cfg) {
                    return selectCipherStrategy(key2).encrypt(cipher, message, key2, cfg);
                  },
                  decrypt: function(ciphertext, key2, cfg) {
                    return selectCipherStrategy(key2).decrypt(cipher, ciphertext, key2, cfg);
                  }
                };
              };
            }()
          });
          var StreamCipher = C_lib.StreamCipher = Cipher.extend({
            _doFinalize: function() {
              var finalProcessedBlocks = this._process(true);
              return finalProcessedBlocks;
            },
            blockSize: 1
          });
          var C_mode = C.mode = {};
          var BlockCipherMode = C_lib.BlockCipherMode = Base.extend({
            /**
             * Creates this mode for encryption.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @static
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.createEncryptor(cipher, iv.words);
             */
            createEncryptor: function(cipher, iv) {
              return this.Encryptor.create(cipher, iv);
            },
            /**
             * Creates this mode for decryption.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @static
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.createDecryptor(cipher, iv.words);
             */
            createDecryptor: function(cipher, iv) {
              return this.Decryptor.create(cipher, iv);
            },
            /**
             * Initializes a newly created mode.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.Encryptor.create(cipher, iv.words);
             */
            init: function(cipher, iv) {
              this._cipher = cipher;
              this._iv = iv;
            }
          });
          var CBC = C_mode.CBC = function() {
            var CBC2 = BlockCipherMode.extend();
            CBC2.Encryptor = CBC2.extend({
              /**
               * Processes the data block at offset.
               *
               * @param {Array} words The data words to operate on.
               * @param {number} offset The offset where the block starts.
               *
               * @example
               *
               *     mode.processBlock(data.words, offset);
               */
              processBlock: function(words, offset) {
                var cipher = this._cipher;
                var blockSize = cipher.blockSize;
                xorBlock.call(this, words, offset, blockSize);
                cipher.encryptBlock(words, offset);
                this._prevBlock = words.slice(offset, offset + blockSize);
              }
            });
            CBC2.Decryptor = CBC2.extend({
              /**
               * Processes the data block at offset.
               *
               * @param {Array} words The data words to operate on.
               * @param {number} offset The offset where the block starts.
               *
               * @example
               *
               *     mode.processBlock(data.words, offset);
               */
              processBlock: function(words, offset) {
                var cipher = this._cipher;
                var blockSize = cipher.blockSize;
                var thisBlock = words.slice(offset, offset + blockSize);
                cipher.decryptBlock(words, offset);
                xorBlock.call(this, words, offset, blockSize);
                this._prevBlock = thisBlock;
              }
            });
            function xorBlock(words, offset, blockSize) {
              var block;
              var iv = this._iv;
              if (iv) {
                block = iv;
                this._iv = undefined$1;
              } else {
                block = this._prevBlock;
              }
              for (var i2 = 0; i2 < blockSize; i2++) {
                words[offset + i2] ^= block[i2];
              }
            }
            return CBC2;
          }();
          var C_pad = C.pad = {};
          var Pkcs7 = C_pad.Pkcs7 = {
            /**
             * Pads data using the algorithm defined in PKCS #5/7.
             *
             * @param {WordArray} data The data to pad.
             * @param {number} blockSize The multiple that the data should be padded to.
             *
             * @static
             *
             * @example
             *
             *     CryptoJS.pad.Pkcs7.pad(wordArray, 4);
             */
            pad: function(data2, blockSize) {
              var blockSizeBytes = blockSize * 4;
              var nPaddingBytes = blockSizeBytes - data2.sigBytes % blockSizeBytes;
              var paddingWord = nPaddingBytes << 24 | nPaddingBytes << 16 | nPaddingBytes << 8 | nPaddingBytes;
              var paddingWords = [];
              for (var i2 = 0; i2 < nPaddingBytes; i2 += 4) {
                paddingWords.push(paddingWord);
              }
              var padding = WordArray.create(paddingWords, nPaddingBytes);
              data2.concat(padding);
            },
            /**
             * Unpads data that had been padded using the algorithm defined in PKCS #5/7.
             *
             * @param {WordArray} data The data to unpad.
             *
             * @static
             *
             * @example
             *
             *     CryptoJS.pad.Pkcs7.unpad(wordArray);
             */
            unpad: function(data2) {
              var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
              data2.sigBytes -= nPaddingBytes;
            }
          };
          var BlockCipher = C_lib.BlockCipher = Cipher.extend({
            /**
             * Configuration options.
             *
             * @property {Mode} mode The block mode to use. Default: CBC
             * @property {Padding} padding The padding strategy to use. Default: Pkcs7
             */
            cfg: Cipher.cfg.extend({
              mode: CBC,
              padding: Pkcs7
            }),
            reset: function() {
              var modeCreator;
              Cipher.reset.call(this);
              var cfg = this.cfg;
              var iv = cfg.iv;
              var mode = cfg.mode;
              if (this._xformMode == this._ENC_XFORM_MODE) {
                modeCreator = mode.createEncryptor;
              } else {
                modeCreator = mode.createDecryptor;
                this._minBufferSize = 1;
              }
              if (this._mode && this._mode.__creator == modeCreator) {
                this._mode.init(this, iv && iv.words);
              } else {
                this._mode = modeCreator.call(mode, this, iv && iv.words);
                this._mode.__creator = modeCreator;
              }
            },
            _doProcessBlock: function(words, offset) {
              this._mode.processBlock(words, offset);
            },
            _doFinalize: function() {
              var finalProcessedBlocks;
              var padding = this.cfg.padding;
              if (this._xformMode == this._ENC_XFORM_MODE) {
                padding.pad(this._data, this.blockSize);
                finalProcessedBlocks = this._process(true);
              } else {
                finalProcessedBlocks = this._process(true);
                padding.unpad(finalProcessedBlocks);
              }
              return finalProcessedBlocks;
            },
            blockSize: 128 / 32
          });
          var CipherParams = C_lib.CipherParams = Base.extend({
            /**
             * Initializes a newly created cipher params object.
             *
             * @param {Object} cipherParams An object with any of the possible cipher parameters.
             *
             * @example
             *
             *     var cipherParams = CryptoJS.lib.CipherParams.create({
             *         ciphertext: ciphertextWordArray,
             *         key: keyWordArray,
             *         iv: ivWordArray,
             *         salt: saltWordArray,
             *         algorithm: CryptoJS.algo.AES,
             *         mode: CryptoJS.mode.CBC,
             *         padding: CryptoJS.pad.PKCS7,
             *         blockSize: 4,
             *         formatter: CryptoJS.format.OpenSSL
             *     });
             */
            init: function(cipherParams) {
              this.mixIn(cipherParams);
            },
            /**
             * Converts this cipher params object to a string.
             *
             * @param {Format} formatter (Optional) The formatting strategy to use.
             *
             * @return {string} The stringified cipher params.
             *
             * @throws Error If neither the formatter nor the default formatter is set.
             *
             * @example
             *
             *     var string = cipherParams + '';
             *     var string = cipherParams.toString();
             *     var string = cipherParams.toString(CryptoJS.format.OpenSSL);
             */
            toString: function(formatter) {
              return (formatter || this.formatter).stringify(this);
            }
          });
          var C_format = C.format = {};
          var OpenSSLFormatter = C_format.OpenSSL = {
            /**
             * Converts a cipher params object to an OpenSSL-compatible string.
             *
             * @param {CipherParams} cipherParams The cipher params object.
             *
             * @return {string} The OpenSSL-compatible string.
             *
             * @static
             *
             * @example
             *
             *     var openSSLString = CryptoJS.format.OpenSSL.stringify(cipherParams);
             */
            stringify: function(cipherParams) {
              var wordArray;
              var ciphertext = cipherParams.ciphertext;
              var salt = cipherParams.salt;
              if (salt) {
                wordArray = WordArray.create([1398893684, 1701076831]).concat(salt).concat(ciphertext);
              } else {
                wordArray = ciphertext;
              }
              return wordArray.toString(Base64);
            },
            /**
             * Converts an OpenSSL-compatible string to a cipher params object.
             *
             * @param {string} openSSLStr The OpenSSL-compatible string.
             *
             * @return {CipherParams} The cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var cipherParams = CryptoJS.format.OpenSSL.parse(openSSLString);
             */
            parse: function(openSSLStr) {
              var salt;
              var ciphertext = Base64.parse(openSSLStr);
              var ciphertextWords = ciphertext.words;
              if (ciphertextWords[0] == 1398893684 && ciphertextWords[1] == 1701076831) {
                salt = WordArray.create(ciphertextWords.slice(2, 4));
                ciphertextWords.splice(0, 4);
                ciphertext.sigBytes -= 16;
              }
              return CipherParams.create({ ciphertext, salt });
            }
          };
          var SerializableCipher = C_lib.SerializableCipher = Base.extend({
            /**
             * Configuration options.
             *
             * @property {Formatter} format The formatting strategy to convert cipher param objects to and from a string. Default: OpenSSL
             */
            cfg: Base.extend({
              format: OpenSSLFormatter
            }),
            /**
             * Encrypts a message.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {WordArray|string} message The message to encrypt.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {CipherParams} A cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key);
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv });
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             */
            encrypt: function(cipher, message, key2, cfg) {
              cfg = this.cfg.extend(cfg);
              var encryptor = cipher.createEncryptor(key2, cfg);
              var ciphertext = encryptor.finalize(message);
              var cipherCfg = encryptor.cfg;
              return CipherParams.create({
                ciphertext,
                key: key2,
                iv: cipherCfg.iv,
                algorithm: cipher,
                mode: cipherCfg.mode,
                padding: cipherCfg.padding,
                blockSize: cipher.blockSize,
                formatter: cfg.format
              });
            },
            /**
             * Decrypts serialized ciphertext.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {WordArray} The plaintext.
             *
             * @static
             *
             * @example
             *
             *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             */
            decrypt: function(cipher, ciphertext, key2, cfg) {
              cfg = this.cfg.extend(cfg);
              ciphertext = this._parse(ciphertext, cfg.format);
              var plaintext = cipher.createDecryptor(key2, cfg).finalize(ciphertext.ciphertext);
              return plaintext;
            },
            /**
             * Converts serialized ciphertext to CipherParams,
             * else assumed CipherParams already and returns ciphertext unchanged.
             *
             * @param {CipherParams|string} ciphertext The ciphertext.
             * @param {Formatter} format The formatting strategy to use to parse serialized ciphertext.
             *
             * @return {CipherParams} The unserialized ciphertext.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher._parse(ciphertextStringOrParams, format);
             */
            _parse: function(ciphertext, format) {
              if (typeof ciphertext == "string") {
                return format.parse(ciphertext, this);
              } else {
                return ciphertext;
              }
            }
          });
          var C_kdf = C.kdf = {};
          var OpenSSLKdf = C_kdf.OpenSSL = {
            /**
             * Derives a key and IV from a password.
             *
             * @param {string} password The password to derive from.
             * @param {number} keySize The size in words of the key to generate.
             * @param {number} ivSize The size in words of the IV to generate.
             * @param {WordArray|string} salt (Optional) A 64-bit salt to use. If omitted, a salt will be generated randomly.
             *
             * @return {CipherParams} A cipher params object with the key, IV, and salt.
             *
             * @static
             *
             * @example
             *
             *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32);
             *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32, 'saltsalt');
             */
            execute: function(password, keySize, ivSize, salt, hasher) {
              if (!salt) {
                salt = WordArray.random(64 / 8);
              }
              if (!hasher) {
                var key2 = EvpKDF.create({ keySize: keySize + ivSize }).compute(password, salt);
              } else {
                var key2 = EvpKDF.create({ keySize: keySize + ivSize, hasher }).compute(password, salt);
              }
              var iv = WordArray.create(key2.words.slice(keySize), ivSize * 4);
              key2.sigBytes = keySize * 4;
              return CipherParams.create({ key: key2, iv, salt });
            }
          };
          var PasswordBasedCipher = C_lib.PasswordBasedCipher = SerializableCipher.extend({
            /**
             * Configuration options.
             *
             * @property {KDF} kdf The key derivation function to use to generate a key and IV from a password. Default: OpenSSL
             */
            cfg: SerializableCipher.cfg.extend({
              kdf: OpenSSLKdf
            }),
            /**
             * Encrypts a message using a password.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {WordArray|string} message The message to encrypt.
             * @param {string} password The password.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {CipherParams} A cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password');
             *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password', { format: CryptoJS.format.OpenSSL });
             */
            encrypt: function(cipher, message, password, cfg) {
              cfg = this.cfg.extend(cfg);
              var derivedParams = cfg.kdf.execute(password, cipher.keySize, cipher.ivSize, cfg.salt, cfg.hasher);
              cfg.iv = derivedParams.iv;
              var ciphertext = SerializableCipher.encrypt.call(this, cipher, message, derivedParams.key, cfg);
              ciphertext.mixIn(derivedParams);
              return ciphertext;
            },
            /**
             * Decrypts serialized ciphertext using a password.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
             * @param {string} password The password.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {WordArray} The plaintext.
             *
             * @static
             *
             * @example
             *
             *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, 'password', { format: CryptoJS.format.OpenSSL });
             *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, 'password', { format: CryptoJS.format.OpenSSL });
             */
            decrypt: function(cipher, ciphertext, password, cfg) {
              cfg = this.cfg.extend(cfg);
              ciphertext = this._parse(ciphertext, cfg.format);
              var derivedParams = cfg.kdf.execute(password, cipher.keySize, cipher.ivSize, ciphertext.salt, cfg.hasher);
              cfg.iv = derivedParams.iv;
              var plaintext = SerializableCipher.decrypt.call(this, cipher, ciphertext, derivedParams.key, cfg);
              return plaintext;
            }
          });
        }();
      });
    })(cipherCore$1, cipherCore$1.exports);
    return cipherCore$1.exports;
  }
  var modeCfb$1 = { exports: {} };
  var modeCfb = modeCfb$1.exports;
  var hasRequiredModeCfb;
  function requireModeCfb() {
    if (hasRequiredModeCfb)
      return modeCfb$1.exports;
    hasRequiredModeCfb = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.mode.CFB = function() {
          var CFB = CryptoJS.lib.BlockCipherMode.extend();
          CFB.Encryptor = CFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher);
              this._prevBlock = words.slice(offset, offset + blockSize);
            }
          });
          CFB.Decryptor = CFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var thisBlock = words.slice(offset, offset + blockSize);
              generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher);
              this._prevBlock = thisBlock;
            }
          });
          function generateKeystreamAndEncrypt(words, offset, blockSize, cipher) {
            var keystream;
            var iv = this._iv;
            if (iv) {
              keystream = iv.slice(0);
              this._iv = void 0;
            } else {
              keystream = this._prevBlock;
            }
            cipher.encryptBlock(keystream, 0);
            for (var i2 = 0; i2 < blockSize; i2++) {
              words[offset + i2] ^= keystream[i2];
            }
          }
          return CFB;
        }();
        return CryptoJS.mode.CFB;
      });
    })(modeCfb$1, modeCfb$1.exports);
    return modeCfb$1.exports;
  }
  var modeCtr$1 = { exports: {} };
  var modeCtr = modeCtr$1.exports;
  var hasRequiredModeCtr;
  function requireModeCtr() {
    if (hasRequiredModeCtr)
      return modeCtr$1.exports;
    hasRequiredModeCtr = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.mode.CTR = function() {
          var CTR = CryptoJS.lib.BlockCipherMode.extend();
          var Encryptor = CTR.Encryptor = CTR.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var counter = this._counter;
              if (iv) {
                counter = this._counter = iv.slice(0);
                this._iv = void 0;
              }
              var keystream = counter.slice(0);
              cipher.encryptBlock(keystream, 0);
              counter[blockSize - 1] = counter[blockSize - 1] + 1 | 0;
              for (var i2 = 0; i2 < blockSize; i2++) {
                words[offset + i2] ^= keystream[i2];
              }
            }
          });
          CTR.Decryptor = Encryptor;
          return CTR;
        }();
        return CryptoJS.mode.CTR;
      });
    })(modeCtr$1, modeCtr$1.exports);
    return modeCtr$1.exports;
  }
  var modeCtrGladman$1 = { exports: {} };
  var modeCtrGladman = modeCtrGladman$1.exports;
  var hasRequiredModeCtrGladman;
  function requireModeCtrGladman() {
    if (hasRequiredModeCtrGladman)
      return modeCtrGladman$1.exports;
    hasRequiredModeCtrGladman = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        /** @preserve
         * Counter block mode compatible with  Dr Brian Gladman fileenc.c
         * derived from CryptoJS.mode.CTR
         * Jan Hruby jhruby.web@gmail.com
         */
        CryptoJS.mode.CTRGladman = function() {
          var CTRGladman = CryptoJS.lib.BlockCipherMode.extend();
          function incWord(word) {
            if ((word >> 24 & 255) === 255) {
              var b1 = word >> 16 & 255;
              var b2 = word >> 8 & 255;
              var b3 = word & 255;
              if (b1 === 255) {
                b1 = 0;
                if (b2 === 255) {
                  b2 = 0;
                  if (b3 === 255) {
                    b3 = 0;
                  } else {
                    ++b3;
                  }
                } else {
                  ++b2;
                }
              } else {
                ++b1;
              }
              word = 0;
              word += b1 << 16;
              word += b2 << 8;
              word += b3;
            } else {
              word += 1 << 24;
            }
            return word;
          }
          function incCounter(counter) {
            if ((counter[0] = incWord(counter[0])) === 0) {
              counter[1] = incWord(counter[1]);
            }
            return counter;
          }
          var Encryptor = CTRGladman.Encryptor = CTRGladman.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var counter = this._counter;
              if (iv) {
                counter = this._counter = iv.slice(0);
                this._iv = void 0;
              }
              incCounter(counter);
              var keystream = counter.slice(0);
              cipher.encryptBlock(keystream, 0);
              for (var i2 = 0; i2 < blockSize; i2++) {
                words[offset + i2] ^= keystream[i2];
              }
            }
          });
          CTRGladman.Decryptor = Encryptor;
          return CTRGladman;
        }();
        return CryptoJS.mode.CTRGladman;
      });
    })(modeCtrGladman$1, modeCtrGladman$1.exports);
    return modeCtrGladman$1.exports;
  }
  var modeOfb$1 = { exports: {} };
  var modeOfb = modeOfb$1.exports;
  var hasRequiredModeOfb;
  function requireModeOfb() {
    if (hasRequiredModeOfb)
      return modeOfb$1.exports;
    hasRequiredModeOfb = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.mode.OFB = function() {
          var OFB = CryptoJS.lib.BlockCipherMode.extend();
          var Encryptor = OFB.Encryptor = OFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var keystream = this._keystream;
              if (iv) {
                keystream = this._keystream = iv.slice(0);
                this._iv = void 0;
              }
              cipher.encryptBlock(keystream, 0);
              for (var i2 = 0; i2 < blockSize; i2++) {
                words[offset + i2] ^= keystream[i2];
              }
            }
          });
          OFB.Decryptor = Encryptor;
          return OFB;
        }();
        return CryptoJS.mode.OFB;
      });
    })(modeOfb$1, modeOfb$1.exports);
    return modeOfb$1.exports;
  }
  var modeEcb$1 = { exports: {} };
  var modeEcb = modeEcb$1.exports;
  var hasRequiredModeEcb;
  function requireModeEcb() {
    if (hasRequiredModeEcb)
      return modeEcb$1.exports;
    hasRequiredModeEcb = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.mode.ECB = function() {
          var ECB = CryptoJS.lib.BlockCipherMode.extend();
          ECB.Encryptor = ECB.extend({
            processBlock: function(words, offset) {
              this._cipher.encryptBlock(words, offset);
            }
          });
          ECB.Decryptor = ECB.extend({
            processBlock: function(words, offset) {
              this._cipher.decryptBlock(words, offset);
            }
          });
          return ECB;
        }();
        return CryptoJS.mode.ECB;
      });
    })(modeEcb$1, modeEcb$1.exports);
    return modeEcb$1.exports;
  }
  var padAnsix923$1 = { exports: {} };
  var padAnsix923 = padAnsix923$1.exports;
  var hasRequiredPadAnsix923;
  function requirePadAnsix923() {
    if (hasRequiredPadAnsix923)
      return padAnsix923$1.exports;
    hasRequiredPadAnsix923 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.pad.AnsiX923 = {
          pad: function(data2, blockSize) {
            var dataSigBytes = data2.sigBytes;
            var blockSizeBytes = blockSize * 4;
            var nPaddingBytes = blockSizeBytes - dataSigBytes % blockSizeBytes;
            var lastBytePos = dataSigBytes + nPaddingBytes - 1;
            data2.clamp();
            data2.words[lastBytePos >>> 2] |= nPaddingBytes << 24 - lastBytePos % 4 * 8;
            data2.sigBytes += nPaddingBytes;
          },
          unpad: function(data2) {
            var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
            data2.sigBytes -= nPaddingBytes;
          }
        };
        return CryptoJS.pad.Ansix923;
      });
    })(padAnsix923$1, padAnsix923$1.exports);
    return padAnsix923$1.exports;
  }
  var padIso10126$1 = { exports: {} };
  var padIso10126 = padIso10126$1.exports;
  var hasRequiredPadIso10126;
  function requirePadIso10126() {
    if (hasRequiredPadIso10126)
      return padIso10126$1.exports;
    hasRequiredPadIso10126 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.pad.Iso10126 = {
          pad: function(data2, blockSize) {
            var blockSizeBytes = blockSize * 4;
            var nPaddingBytes = blockSizeBytes - data2.sigBytes % blockSizeBytes;
            data2.concat(CryptoJS.lib.WordArray.random(nPaddingBytes - 1)).concat(CryptoJS.lib.WordArray.create([nPaddingBytes << 24], 1));
          },
          unpad: function(data2) {
            var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
            data2.sigBytes -= nPaddingBytes;
          }
        };
        return CryptoJS.pad.Iso10126;
      });
    })(padIso10126$1, padIso10126$1.exports);
    return padIso10126$1.exports;
  }
  var padIso97971$1 = { exports: {} };
  var padIso97971 = padIso97971$1.exports;
  var hasRequiredPadIso97971;
  function requirePadIso97971() {
    if (hasRequiredPadIso97971)
      return padIso97971$1.exports;
    hasRequiredPadIso97971 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.pad.Iso97971 = {
          pad: function(data2, blockSize) {
            data2.concat(CryptoJS.lib.WordArray.create([2147483648], 1));
            CryptoJS.pad.ZeroPadding.pad(data2, blockSize);
          },
          unpad: function(data2) {
            CryptoJS.pad.ZeroPadding.unpad(data2);
            data2.sigBytes--;
          }
        };
        return CryptoJS.pad.Iso97971;
      });
    })(padIso97971$1, padIso97971$1.exports);
    return padIso97971$1.exports;
  }
  var padZeropadding$1 = { exports: {} };
  var padZeropadding = padZeropadding$1.exports;
  var hasRequiredPadZeropadding;
  function requirePadZeropadding() {
    if (hasRequiredPadZeropadding)
      return padZeropadding$1.exports;
    hasRequiredPadZeropadding = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.pad.ZeroPadding = {
          pad: function(data2, blockSize) {
            var blockSizeBytes = blockSize * 4;
            data2.clamp();
            data2.sigBytes += blockSizeBytes - (data2.sigBytes % blockSizeBytes || blockSizeBytes);
          },
          unpad: function(data2) {
            var dataWords = data2.words;
            var i2 = data2.sigBytes - 1;
            for (var i2 = data2.sigBytes - 1; i2 >= 0; i2--) {
              if (dataWords[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255) {
                data2.sigBytes = i2 + 1;
                break;
              }
            }
          }
        };
        return CryptoJS.pad.ZeroPadding;
      });
    })(padZeropadding$1, padZeropadding$1.exports);
    return padZeropadding$1.exports;
  }
  var padNopadding$1 = { exports: {} };
  var padNopadding = padNopadding$1.exports;
  var hasRequiredPadNopadding;
  function requirePadNopadding() {
    if (hasRequiredPadNopadding)
      return padNopadding$1.exports;
    hasRequiredPadNopadding = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        CryptoJS.pad.NoPadding = {
          pad: function() {
          },
          unpad: function() {
          }
        };
        return CryptoJS.pad.NoPadding;
      });
    })(padNopadding$1, padNopadding$1.exports);
    return padNopadding$1.exports;
  }
  var formatHex$1 = { exports: {} };
  var formatHex = formatHex$1.exports;
  var hasRequiredFormatHex;
  function requireFormatHex() {
    if (hasRequiredFormatHex)
      return formatHex$1.exports;
    hasRequiredFormatHex = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function(undefined$1) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var CipherParams = C_lib.CipherParams;
          var C_enc = C.enc;
          var Hex = C_enc.Hex;
          var C_format = C.format;
          var HexFormatter = C_format.Hex = {
            /**
             * Converts the ciphertext of a cipher params object to a hexadecimally encoded string.
             *
             * @param {CipherParams} cipherParams The cipher params object.
             *
             * @return {string} The hexadecimally encoded string.
             *
             * @static
             *
             * @example
             *
             *     var hexString = CryptoJS.format.Hex.stringify(cipherParams);
             */
            stringify: function(cipherParams) {
              return cipherParams.ciphertext.toString(Hex);
            },
            /**
             * Converts a hexadecimally encoded ciphertext string to a cipher params object.
             *
             * @param {string} input The hexadecimally encoded string.
             *
             * @return {CipherParams} The cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var cipherParams = CryptoJS.format.Hex.parse(hexString);
             */
            parse: function(input) {
              var ciphertext = Hex.parse(input);
              return CipherParams.create({ ciphertext });
            }
          };
        })();
        return CryptoJS.format.Hex;
      });
    })(formatHex$1, formatHex$1.exports);
    return formatHex$1.exports;
  }
  var aes$1 = { exports: {} };
  var aes = aes$1.exports;
  var hasRequiredAes;
  function requireAes() {
    if (hasRequiredAes)
      return aes$1.exports;
    hasRequiredAes = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var BlockCipher = C_lib.BlockCipher;
          var C_algo = C.algo;
          var SBOX = [];
          var INV_SBOX = [];
          var SUB_MIX_0 = [];
          var SUB_MIX_1 = [];
          var SUB_MIX_2 = [];
          var SUB_MIX_3 = [];
          var INV_SUB_MIX_0 = [];
          var INV_SUB_MIX_1 = [];
          var INV_SUB_MIX_2 = [];
          var INV_SUB_MIX_3 = [];
          (function() {
            var d2 = [];
            for (var i2 = 0; i2 < 256; i2++) {
              if (i2 < 128) {
                d2[i2] = i2 << 1;
              } else {
                d2[i2] = i2 << 1 ^ 283;
              }
            }
            var x = 0;
            var xi = 0;
            for (var i2 = 0; i2 < 256; i2++) {
              var sx = xi ^ xi << 1 ^ xi << 2 ^ xi << 3 ^ xi << 4;
              sx = sx >>> 8 ^ sx & 255 ^ 99;
              SBOX[x] = sx;
              INV_SBOX[sx] = x;
              var x2 = d2[x];
              var x4 = d2[x2];
              var x8 = d2[x4];
              var t2 = d2[sx] * 257 ^ sx * 16843008;
              SUB_MIX_0[x] = t2 << 24 | t2 >>> 8;
              SUB_MIX_1[x] = t2 << 16 | t2 >>> 16;
              SUB_MIX_2[x] = t2 << 8 | t2 >>> 24;
              SUB_MIX_3[x] = t2;
              var t2 = x8 * 16843009 ^ x4 * 65537 ^ x2 * 257 ^ x * 16843008;
              INV_SUB_MIX_0[sx] = t2 << 24 | t2 >>> 8;
              INV_SUB_MIX_1[sx] = t2 << 16 | t2 >>> 16;
              INV_SUB_MIX_2[sx] = t2 << 8 | t2 >>> 24;
              INV_SUB_MIX_3[sx] = t2;
              if (!x) {
                x = xi = 1;
              } else {
                x = x2 ^ d2[d2[d2[x8 ^ x2]]];
                xi ^= d2[d2[xi]];
              }
            }
          })();
          var RCON = [0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54];
          var AES = C_algo.AES = BlockCipher.extend({
            _doReset: function() {
              var t2;
              if (this._nRounds && this._keyPriorReset === this._key) {
                return;
              }
              var key2 = this._keyPriorReset = this._key;
              var keyWords = key2.words;
              var keySize = key2.sigBytes / 4;
              var nRounds = this._nRounds = keySize + 6;
              var ksRows = (nRounds + 1) * 4;
              var keySchedule = this._keySchedule = [];
              for (var ksRow = 0; ksRow < ksRows; ksRow++) {
                if (ksRow < keySize) {
                  keySchedule[ksRow] = keyWords[ksRow];
                } else {
                  t2 = keySchedule[ksRow - 1];
                  if (!(ksRow % keySize)) {
                    t2 = t2 << 8 | t2 >>> 24;
                    t2 = SBOX[t2 >>> 24] << 24 | SBOX[t2 >>> 16 & 255] << 16 | SBOX[t2 >>> 8 & 255] << 8 | SBOX[t2 & 255];
                    t2 ^= RCON[ksRow / keySize | 0] << 24;
                  } else if (keySize > 6 && ksRow % keySize == 4) {
                    t2 = SBOX[t2 >>> 24] << 24 | SBOX[t2 >>> 16 & 255] << 16 | SBOX[t2 >>> 8 & 255] << 8 | SBOX[t2 & 255];
                  }
                  keySchedule[ksRow] = keySchedule[ksRow - keySize] ^ t2;
                }
              }
              var invKeySchedule = this._invKeySchedule = [];
              for (var invKsRow = 0; invKsRow < ksRows; invKsRow++) {
                var ksRow = ksRows - invKsRow;
                if (invKsRow % 4) {
                  var t2 = keySchedule[ksRow];
                } else {
                  var t2 = keySchedule[ksRow - 4];
                }
                if (invKsRow < 4 || ksRow <= 4) {
                  invKeySchedule[invKsRow] = t2;
                } else {
                  invKeySchedule[invKsRow] = INV_SUB_MIX_0[SBOX[t2 >>> 24]] ^ INV_SUB_MIX_1[SBOX[t2 >>> 16 & 255]] ^ INV_SUB_MIX_2[SBOX[t2 >>> 8 & 255]] ^ INV_SUB_MIX_3[SBOX[t2 & 255]];
                }
              }
            },
            encryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._keySchedule, SUB_MIX_0, SUB_MIX_1, SUB_MIX_2, SUB_MIX_3, SBOX);
            },
            decryptBlock: function(M, offset) {
              var t2 = M[offset + 1];
              M[offset + 1] = M[offset + 3];
              M[offset + 3] = t2;
              this._doCryptBlock(M, offset, this._invKeySchedule, INV_SUB_MIX_0, INV_SUB_MIX_1, INV_SUB_MIX_2, INV_SUB_MIX_3, INV_SBOX);
              var t2 = M[offset + 1];
              M[offset + 1] = M[offset + 3];
              M[offset + 3] = t2;
            },
            _doCryptBlock: function(M, offset, keySchedule, SUB_MIX_02, SUB_MIX_12, SUB_MIX_22, SUB_MIX_32, SBOX2) {
              var nRounds = this._nRounds;
              var s0 = M[offset] ^ keySchedule[0];
              var s1 = M[offset + 1] ^ keySchedule[1];
              var s2 = M[offset + 2] ^ keySchedule[2];
              var s3 = M[offset + 3] ^ keySchedule[3];
              var ksRow = 4;
              for (var round = 1; round < nRounds; round++) {
                var t0 = SUB_MIX_02[s0 >>> 24] ^ SUB_MIX_12[s1 >>> 16 & 255] ^ SUB_MIX_22[s2 >>> 8 & 255] ^ SUB_MIX_32[s3 & 255] ^ keySchedule[ksRow++];
                var t1 = SUB_MIX_02[s1 >>> 24] ^ SUB_MIX_12[s2 >>> 16 & 255] ^ SUB_MIX_22[s3 >>> 8 & 255] ^ SUB_MIX_32[s0 & 255] ^ keySchedule[ksRow++];
                var t2 = SUB_MIX_02[s2 >>> 24] ^ SUB_MIX_12[s3 >>> 16 & 255] ^ SUB_MIX_22[s0 >>> 8 & 255] ^ SUB_MIX_32[s1 & 255] ^ keySchedule[ksRow++];
                var t3 = SUB_MIX_02[s3 >>> 24] ^ SUB_MIX_12[s0 >>> 16 & 255] ^ SUB_MIX_22[s1 >>> 8 & 255] ^ SUB_MIX_32[s2 & 255] ^ keySchedule[ksRow++];
                s0 = t0;
                s1 = t1;
                s2 = t2;
                s3 = t3;
              }
              var t0 = (SBOX2[s0 >>> 24] << 24 | SBOX2[s1 >>> 16 & 255] << 16 | SBOX2[s2 >>> 8 & 255] << 8 | SBOX2[s3 & 255]) ^ keySchedule[ksRow++];
              var t1 = (SBOX2[s1 >>> 24] << 24 | SBOX2[s2 >>> 16 & 255] << 16 | SBOX2[s3 >>> 8 & 255] << 8 | SBOX2[s0 & 255]) ^ keySchedule[ksRow++];
              var t2 = (SBOX2[s2 >>> 24] << 24 | SBOX2[s3 >>> 16 & 255] << 16 | SBOX2[s0 >>> 8 & 255] << 8 | SBOX2[s1 & 255]) ^ keySchedule[ksRow++];
              var t3 = (SBOX2[s3 >>> 24] << 24 | SBOX2[s0 >>> 16 & 255] << 16 | SBOX2[s1 >>> 8 & 255] << 8 | SBOX2[s2 & 255]) ^ keySchedule[ksRow++];
              M[offset] = t0;
              M[offset + 1] = t1;
              M[offset + 2] = t2;
              M[offset + 3] = t3;
            },
            keySize: 256 / 32
          });
          C.AES = BlockCipher._createHelper(AES);
        })();
        return CryptoJS.AES;
      });
    })(aes$1, aes$1.exports);
    return aes$1.exports;
  }
  var tripledes$1 = { exports: {} };
  var tripledes = tripledes$1.exports;
  var hasRequiredTripledes;
  function requireTripledes() {
    if (hasRequiredTripledes)
      return tripledes$1.exports;
    hasRequiredTripledes = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var BlockCipher = C_lib.BlockCipher;
          var C_algo = C.algo;
          var PC1 = [
            57,
            49,
            41,
            33,
            25,
            17,
            9,
            1,
            58,
            50,
            42,
            34,
            26,
            18,
            10,
            2,
            59,
            51,
            43,
            35,
            27,
            19,
            11,
            3,
            60,
            52,
            44,
            36,
            63,
            55,
            47,
            39,
            31,
            23,
            15,
            7,
            62,
            54,
            46,
            38,
            30,
            22,
            14,
            6,
            61,
            53,
            45,
            37,
            29,
            21,
            13,
            5,
            28,
            20,
            12,
            4
          ];
          var PC2 = [
            14,
            17,
            11,
            24,
            1,
            5,
            3,
            28,
            15,
            6,
            21,
            10,
            23,
            19,
            12,
            4,
            26,
            8,
            16,
            7,
            27,
            20,
            13,
            2,
            41,
            52,
            31,
            37,
            47,
            55,
            30,
            40,
            51,
            45,
            33,
            48,
            44,
            49,
            39,
            56,
            34,
            53,
            46,
            42,
            50,
            36,
            29,
            32
          ];
          var BIT_SHIFTS = [1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28];
          var SBOX_P = [
            {
              0: 8421888,
              268435456: 32768,
              536870912: 8421378,
              805306368: 2,
              1073741824: 512,
              1342177280: 8421890,
              1610612736: 8389122,
              1879048192: 8388608,
              2147483648: 514,
              2415919104: 8389120,
              2684354560: 33280,
              2952790016: 8421376,
              3221225472: 32770,
              3489660928: 8388610,
              3758096384: 0,
              4026531840: 33282,
              134217728: 0,
              402653184: 8421890,
              671088640: 33282,
              939524096: 32768,
              1207959552: 8421888,
              1476395008: 512,
              1744830464: 8421378,
              2013265920: 2,
              2281701376: 8389120,
              2550136832: 33280,
              2818572288: 8421376,
              3087007744: 8389122,
              3355443200: 8388610,
              3623878656: 32770,
              3892314112: 514,
              4160749568: 8388608,
              1: 32768,
              268435457: 2,
              536870913: 8421888,
              805306369: 8388608,
              1073741825: 8421378,
              1342177281: 33280,
              1610612737: 512,
              1879048193: 8389122,
              2147483649: 8421890,
              2415919105: 8421376,
              2684354561: 8388610,
              2952790017: 33282,
              3221225473: 514,
              3489660929: 8389120,
              3758096385: 32770,
              4026531841: 0,
              134217729: 8421890,
              402653185: 8421376,
              671088641: 8388608,
              939524097: 512,
              1207959553: 32768,
              1476395009: 8388610,
              1744830465: 2,
              2013265921: 33282,
              2281701377: 32770,
              2550136833: 8389122,
              2818572289: 514,
              3087007745: 8421888,
              3355443201: 8389120,
              3623878657: 0,
              3892314113: 33280,
              4160749569: 8421378
            },
            {
              0: 1074282512,
              16777216: 16384,
              33554432: 524288,
              50331648: 1074266128,
              67108864: 1073741840,
              83886080: 1074282496,
              100663296: 1073758208,
              117440512: 16,
              134217728: 540672,
              150994944: 1073758224,
              167772160: 1073741824,
              184549376: 540688,
              201326592: 524304,
              218103808: 0,
              234881024: 16400,
              251658240: 1074266112,
              8388608: 1073758208,
              25165824: 540688,
              41943040: 16,
              58720256: 1073758224,
              75497472: 1074282512,
              92274688: 1073741824,
              109051904: 524288,
              125829120: 1074266128,
              142606336: 524304,
              159383552: 0,
              176160768: 16384,
              192937984: 1074266112,
              209715200: 1073741840,
              226492416: 540672,
              243269632: 1074282496,
              260046848: 16400,
              268435456: 0,
              285212672: 1074266128,
              301989888: 1073758224,
              318767104: 1074282496,
              335544320: 1074266112,
              352321536: 16,
              369098752: 540688,
              385875968: 16384,
              402653184: 16400,
              419430400: 524288,
              436207616: 524304,
              452984832: 1073741840,
              469762048: 540672,
              486539264: 1073758208,
              503316480: 1073741824,
              520093696: 1074282512,
              276824064: 540688,
              293601280: 524288,
              310378496: 1074266112,
              327155712: 16384,
              343932928: 1073758208,
              360710144: 1074282512,
              377487360: 16,
              394264576: 1073741824,
              411041792: 1074282496,
              427819008: 1073741840,
              444596224: 1073758224,
              461373440: 524304,
              478150656: 0,
              494927872: 16400,
              511705088: 1074266128,
              528482304: 540672
            },
            {
              0: 260,
              1048576: 0,
              2097152: 67109120,
              3145728: 65796,
              4194304: 65540,
              5242880: 67108868,
              6291456: 67174660,
              7340032: 67174400,
              8388608: 67108864,
              9437184: 67174656,
              10485760: 65792,
              11534336: 67174404,
              12582912: 67109124,
              13631488: 65536,
              14680064: 4,
              15728640: 256,
              524288: 67174656,
              1572864: 67174404,
              2621440: 0,
              3670016: 67109120,
              4718592: 67108868,
              5767168: 65536,
              6815744: 65540,
              7864320: 260,
              8912896: 4,
              9961472: 256,
              11010048: 67174400,
              12058624: 65796,
              13107200: 65792,
              14155776: 67109124,
              15204352: 67174660,
              16252928: 67108864,
              16777216: 67174656,
              17825792: 65540,
              18874368: 65536,
              19922944: 67109120,
              20971520: 256,
              22020096: 67174660,
              23068672: 67108868,
              24117248: 0,
              25165824: 67109124,
              26214400: 67108864,
              27262976: 4,
              28311552: 65792,
              29360128: 67174400,
              30408704: 260,
              31457280: 65796,
              32505856: 67174404,
              17301504: 67108864,
              18350080: 260,
              19398656: 67174656,
              20447232: 0,
              21495808: 65540,
              22544384: 67109120,
              23592960: 256,
              24641536: 67174404,
              25690112: 65536,
              26738688: 67174660,
              27787264: 65796,
              28835840: 67108868,
              29884416: 67109124,
              30932992: 67174400,
              31981568: 4,
              33030144: 65792
            },
            {
              0: 2151682048,
              65536: 2147487808,
              131072: 4198464,
              196608: 2151677952,
              262144: 0,
              327680: 4198400,
              393216: 2147483712,
              458752: 4194368,
              524288: 2147483648,
              589824: 4194304,
              655360: 64,
              720896: 2147487744,
              786432: 2151678016,
              851968: 4160,
              917504: 4096,
              983040: 2151682112,
              32768: 2147487808,
              98304: 64,
              163840: 2151678016,
              229376: 2147487744,
              294912: 4198400,
              360448: 2151682112,
              425984: 0,
              491520: 2151677952,
              557056: 4096,
              622592: 2151682048,
              688128: 4194304,
              753664: 4160,
              819200: 2147483648,
              884736: 4194368,
              950272: 4198464,
              1015808: 2147483712,
              1048576: 4194368,
              1114112: 4198400,
              1179648: 2147483712,
              1245184: 0,
              1310720: 4160,
              1376256: 2151678016,
              1441792: 2151682048,
              1507328: 2147487808,
              1572864: 2151682112,
              1638400: 2147483648,
              1703936: 2151677952,
              1769472: 4198464,
              1835008: 2147487744,
              1900544: 4194304,
              1966080: 64,
              2031616: 4096,
              1081344: 2151677952,
              1146880: 2151682112,
              1212416: 0,
              1277952: 4198400,
              1343488: 4194368,
              1409024: 2147483648,
              1474560: 2147487808,
              1540096: 64,
              1605632: 2147483712,
              1671168: 4096,
              1736704: 2147487744,
              1802240: 2151678016,
              1867776: 4160,
              1933312: 2151682048,
              1998848: 4194304,
              2064384: 4198464
            },
            {
              0: 128,
              4096: 17039360,
              8192: 262144,
              12288: 536870912,
              16384: 537133184,
              20480: 16777344,
              24576: 553648256,
              28672: 262272,
              32768: 16777216,
              36864: 537133056,
              40960: 536871040,
              45056: 553910400,
              49152: 553910272,
              53248: 0,
              57344: 17039488,
              61440: 553648128,
              2048: 17039488,
              6144: 553648256,
              10240: 128,
              14336: 17039360,
              18432: 262144,
              22528: 537133184,
              26624: 553910272,
              30720: 536870912,
              34816: 537133056,
              38912: 0,
              43008: 553910400,
              47104: 16777344,
              51200: 536871040,
              55296: 553648128,
              59392: 16777216,
              63488: 262272,
              65536: 262144,
              69632: 128,
              73728: 536870912,
              77824: 553648256,
              81920: 16777344,
              86016: 553910272,
              90112: 537133184,
              94208: 16777216,
              98304: 553910400,
              102400: 553648128,
              106496: 17039360,
              110592: 537133056,
              114688: 262272,
              118784: 536871040,
              122880: 0,
              126976: 17039488,
              67584: 553648256,
              71680: 16777216,
              75776: 17039360,
              79872: 537133184,
              83968: 536870912,
              88064: 17039488,
              92160: 128,
              96256: 553910272,
              100352: 262272,
              104448: 553910400,
              108544: 0,
              112640: 553648128,
              116736: 16777344,
              120832: 262144,
              124928: 537133056,
              129024: 536871040
            },
            {
              0: 268435464,
              256: 8192,
              512: 270532608,
              768: 270540808,
              1024: 268443648,
              1280: 2097152,
              1536: 2097160,
              1792: 268435456,
              2048: 0,
              2304: 268443656,
              2560: 2105344,
              2816: 8,
              3072: 270532616,
              3328: 2105352,
              3584: 8200,
              3840: 270540800,
              128: 270532608,
              384: 270540808,
              640: 8,
              896: 2097152,
              1152: 2105352,
              1408: 268435464,
              1664: 268443648,
              1920: 8200,
              2176: 2097160,
              2432: 8192,
              2688: 268443656,
              2944: 270532616,
              3200: 0,
              3456: 270540800,
              3712: 2105344,
              3968: 268435456,
              4096: 268443648,
              4352: 270532616,
              4608: 270540808,
              4864: 8200,
              5120: 2097152,
              5376: 268435456,
              5632: 268435464,
              5888: 2105344,
              6144: 2105352,
              6400: 0,
              6656: 8,
              6912: 270532608,
              7168: 8192,
              7424: 268443656,
              7680: 270540800,
              7936: 2097160,
              4224: 8,
              4480: 2105344,
              4736: 2097152,
              4992: 268435464,
              5248: 268443648,
              5504: 8200,
              5760: 270540808,
              6016: 270532608,
              6272: 270540800,
              6528: 270532616,
              6784: 8192,
              7040: 2105352,
              7296: 2097160,
              7552: 0,
              7808: 268435456,
              8064: 268443656
            },
            {
              0: 1048576,
              16: 33555457,
              32: 1024,
              48: 1049601,
              64: 34604033,
              80: 0,
              96: 1,
              112: 34603009,
              128: 33555456,
              144: 1048577,
              160: 33554433,
              176: 34604032,
              192: 34603008,
              208: 1025,
              224: 1049600,
              240: 33554432,
              8: 34603009,
              24: 0,
              40: 33555457,
              56: 34604032,
              72: 1048576,
              88: 33554433,
              104: 33554432,
              120: 1025,
              136: 1049601,
              152: 33555456,
              168: 34603008,
              184: 1048577,
              200: 1024,
              216: 34604033,
              232: 1,
              248: 1049600,
              256: 33554432,
              272: 1048576,
              288: 33555457,
              304: 34603009,
              320: 1048577,
              336: 33555456,
              352: 34604032,
              368: 1049601,
              384: 1025,
              400: 34604033,
              416: 1049600,
              432: 1,
              448: 0,
              464: 34603008,
              480: 33554433,
              496: 1024,
              264: 1049600,
              280: 33555457,
              296: 34603009,
              312: 1,
              328: 33554432,
              344: 1048576,
              360: 1025,
              376: 34604032,
              392: 33554433,
              408: 34603008,
              424: 0,
              440: 34604033,
              456: 1049601,
              472: 1024,
              488: 33555456,
              504: 1048577
            },
            {
              0: 134219808,
              1: 131072,
              2: 134217728,
              3: 32,
              4: 131104,
              5: 134350880,
              6: 134350848,
              7: 2048,
              8: 134348800,
              9: 134219776,
              10: 133120,
              11: 134348832,
              12: 2080,
              13: 0,
              14: 134217760,
              15: 133152,
              2147483648: 2048,
              2147483649: 134350880,
              2147483650: 134219808,
              2147483651: 134217728,
              2147483652: 134348800,
              2147483653: 133120,
              2147483654: 133152,
              2147483655: 32,
              2147483656: 134217760,
              2147483657: 2080,
              2147483658: 131104,
              2147483659: 134350848,
              2147483660: 0,
              2147483661: 134348832,
              2147483662: 134219776,
              2147483663: 131072,
              16: 133152,
              17: 134350848,
              18: 32,
              19: 2048,
              20: 134219776,
              21: 134217760,
              22: 134348832,
              23: 131072,
              24: 0,
              25: 131104,
              26: 134348800,
              27: 134219808,
              28: 134350880,
              29: 133120,
              30: 2080,
              31: 134217728,
              2147483664: 131072,
              2147483665: 2048,
              2147483666: 134348832,
              2147483667: 133152,
              2147483668: 32,
              2147483669: 134348800,
              2147483670: 134217728,
              2147483671: 134219808,
              2147483672: 134350880,
              2147483673: 134217760,
              2147483674: 134219776,
              2147483675: 0,
              2147483676: 133120,
              2147483677: 2080,
              2147483678: 131104,
              2147483679: 134350848
            }
          ];
          var SBOX_MASK = [
            4160749569,
            528482304,
            33030144,
            2064384,
            129024,
            8064,
            504,
            2147483679
          ];
          var DES = C_algo.DES = BlockCipher.extend({
            _doReset: function() {
              var key2 = this._key;
              var keyWords = key2.words;
              var keyBits = [];
              for (var i2 = 0; i2 < 56; i2++) {
                var keyBitPos = PC1[i2] - 1;
                keyBits[i2] = keyWords[keyBitPos >>> 5] >>> 31 - keyBitPos % 32 & 1;
              }
              var subKeys = this._subKeys = [];
              for (var nSubKey = 0; nSubKey < 16; nSubKey++) {
                var subKey = subKeys[nSubKey] = [];
                var bitShift = BIT_SHIFTS[nSubKey];
                for (var i2 = 0; i2 < 24; i2++) {
                  subKey[i2 / 6 | 0] |= keyBits[(PC2[i2] - 1 + bitShift) % 28] << 31 - i2 % 6;
                  subKey[4 + (i2 / 6 | 0)] |= keyBits[28 + (PC2[i2 + 24] - 1 + bitShift) % 28] << 31 - i2 % 6;
                }
                subKey[0] = subKey[0] << 1 | subKey[0] >>> 31;
                for (var i2 = 1; i2 < 7; i2++) {
                  subKey[i2] = subKey[i2] >>> (i2 - 1) * 4 + 3;
                }
                subKey[7] = subKey[7] << 5 | subKey[7] >>> 27;
              }
              var invSubKeys = this._invSubKeys = [];
              for (var i2 = 0; i2 < 16; i2++) {
                invSubKeys[i2] = subKeys[15 - i2];
              }
            },
            encryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._subKeys);
            },
            decryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._invSubKeys);
            },
            _doCryptBlock: function(M, offset, subKeys) {
              this._lBlock = M[offset];
              this._rBlock = M[offset + 1];
              exchangeLR.call(this, 4, 252645135);
              exchangeLR.call(this, 16, 65535);
              exchangeRL.call(this, 2, 858993459);
              exchangeRL.call(this, 8, 16711935);
              exchangeLR.call(this, 1, 1431655765);
              for (var round = 0; round < 16; round++) {
                var subKey = subKeys[round];
                var lBlock = this._lBlock;
                var rBlock = this._rBlock;
                var f2 = 0;
                for (var i2 = 0; i2 < 8; i2++) {
                  f2 |= SBOX_P[i2][((rBlock ^ subKey[i2]) & SBOX_MASK[i2]) >>> 0];
                }
                this._lBlock = rBlock;
                this._rBlock = lBlock ^ f2;
              }
              var t2 = this._lBlock;
              this._lBlock = this._rBlock;
              this._rBlock = t2;
              exchangeLR.call(this, 1, 1431655765);
              exchangeRL.call(this, 8, 16711935);
              exchangeRL.call(this, 2, 858993459);
              exchangeLR.call(this, 16, 65535);
              exchangeLR.call(this, 4, 252645135);
              M[offset] = this._lBlock;
              M[offset + 1] = this._rBlock;
            },
            keySize: 64 / 32,
            ivSize: 64 / 32,
            blockSize: 64 / 32
          });
          function exchangeLR(offset, mask) {
            var t2 = (this._lBlock >>> offset ^ this._rBlock) & mask;
            this._rBlock ^= t2;
            this._lBlock ^= t2 << offset;
          }
          function exchangeRL(offset, mask) {
            var t2 = (this._rBlock >>> offset ^ this._lBlock) & mask;
            this._lBlock ^= t2;
            this._rBlock ^= t2 << offset;
          }
          C.DES = BlockCipher._createHelper(DES);
          var TripleDES = C_algo.TripleDES = BlockCipher.extend({
            _doReset: function() {
              var key2 = this._key;
              var keyWords = key2.words;
              if (keyWords.length !== 2 && keyWords.length !== 4 && keyWords.length < 6) {
                throw new Error("Invalid key length - 3DES requires the key length to be 64, 128, 192 or >192.");
              }
              var key1 = keyWords.slice(0, 2);
              var key22 = keyWords.length < 4 ? keyWords.slice(0, 2) : keyWords.slice(2, 4);
              var key3 = keyWords.length < 6 ? keyWords.slice(0, 2) : keyWords.slice(4, 6);
              this._des1 = DES.createEncryptor(WordArray.create(key1));
              this._des2 = DES.createEncryptor(WordArray.create(key22));
              this._des3 = DES.createEncryptor(WordArray.create(key3));
            },
            encryptBlock: function(M, offset) {
              this._des1.encryptBlock(M, offset);
              this._des2.decryptBlock(M, offset);
              this._des3.encryptBlock(M, offset);
            },
            decryptBlock: function(M, offset) {
              this._des3.decryptBlock(M, offset);
              this._des2.encryptBlock(M, offset);
              this._des1.decryptBlock(M, offset);
            },
            keySize: 192 / 32,
            ivSize: 64 / 32,
            blockSize: 64 / 32
          });
          C.TripleDES = BlockCipher._createHelper(TripleDES);
        })();
        return CryptoJS.TripleDES;
      });
    })(tripledes$1, tripledes$1.exports);
    return tripledes$1.exports;
  }
  var rc4$1 = { exports: {} };
  var rc4 = rc4$1.exports;
  var hasRequiredRc4;
  function requireRc4() {
    if (hasRequiredRc4)
      return rc4$1.exports;
    hasRequiredRc4 = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var RC4 = C_algo.RC4 = StreamCipher.extend({
            _doReset: function() {
              var key2 = this._key;
              var keyWords = key2.words;
              var keySigBytes = key2.sigBytes;
              var S = this._S = [];
              for (var i2 = 0; i2 < 256; i2++) {
                S[i2] = i2;
              }
              for (var i2 = 0, j = 0; i2 < 256; i2++) {
                var keyByteIndex = i2 % keySigBytes;
                var keyByte = keyWords[keyByteIndex >>> 2] >>> 24 - keyByteIndex % 4 * 8 & 255;
                j = (j + S[i2] + keyByte) % 256;
                var t2 = S[i2];
                S[i2] = S[j];
                S[j] = t2;
              }
              this._i = this._j = 0;
            },
            _doProcessBlock: function(M, offset) {
              M[offset] ^= generateKeystreamWord.call(this);
            },
            keySize: 256 / 32,
            ivSize: 0
          });
          function generateKeystreamWord() {
            var S = this._S;
            var i2 = this._i;
            var j = this._j;
            var keystreamWord = 0;
            for (var n2 = 0; n2 < 4; n2++) {
              i2 = (i2 + 1) % 256;
              j = (j + S[i2]) % 256;
              var t2 = S[i2];
              S[i2] = S[j];
              S[j] = t2;
              keystreamWord |= S[(S[i2] + S[j]) % 256] << 24 - n2 * 8;
            }
            this._i = i2;
            this._j = j;
            return keystreamWord;
          }
          C.RC4 = StreamCipher._createHelper(RC4);
          var RC4Drop = C_algo.RC4Drop = RC4.extend({
            /**
             * Configuration options.
             *
             * @property {number} drop The number of keystream words to drop. Default 192
             */
            cfg: RC4.cfg.extend({
              drop: 192
            }),
            _doReset: function() {
              RC4._doReset.call(this);
              for (var i2 = this.cfg.drop; i2 > 0; i2--) {
                generateKeystreamWord.call(this);
              }
            }
          });
          C.RC4Drop = StreamCipher._createHelper(RC4Drop);
        })();
        return CryptoJS.RC4;
      });
    })(rc4$1, rc4$1.exports);
    return rc4$1.exports;
  }
  var rabbit$1 = { exports: {} };
  var rabbit = rabbit$1.exports;
  var hasRequiredRabbit;
  function requireRabbit() {
    if (hasRequiredRabbit)
      return rabbit$1.exports;
    hasRequiredRabbit = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var S = [];
          var C_ = [];
          var G = [];
          var Rabbit = C_algo.Rabbit = StreamCipher.extend({
            _doReset: function() {
              var K = this._key.words;
              var iv = this.cfg.iv;
              for (var i2 = 0; i2 < 4; i2++) {
                K[i2] = (K[i2] << 8 | K[i2] >>> 24) & 16711935 | (K[i2] << 24 | K[i2] >>> 8) & 4278255360;
              }
              var X = this._X = [
                K[0],
                K[3] << 16 | K[2] >>> 16,
                K[1],
                K[0] << 16 | K[3] >>> 16,
                K[2],
                K[1] << 16 | K[0] >>> 16,
                K[3],
                K[2] << 16 | K[1] >>> 16
              ];
              var C2 = this._C = [
                K[2] << 16 | K[2] >>> 16,
                K[0] & 4294901760 | K[1] & 65535,
                K[3] << 16 | K[3] >>> 16,
                K[1] & 4294901760 | K[2] & 65535,
                K[0] << 16 | K[0] >>> 16,
                K[2] & 4294901760 | K[3] & 65535,
                K[1] << 16 | K[1] >>> 16,
                K[3] & 4294901760 | K[0] & 65535
              ];
              this._b = 0;
              for (var i2 = 0; i2 < 4; i2++) {
                nextState.call(this);
              }
              for (var i2 = 0; i2 < 8; i2++) {
                C2[i2] ^= X[i2 + 4 & 7];
              }
              if (iv) {
                var IV = iv.words;
                var IV_0 = IV[0];
                var IV_1 = IV[1];
                var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
                var i22 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
                var i1 = i0 >>> 16 | i22 & 4294901760;
                var i3 = i22 << 16 | i0 & 65535;
                C2[0] ^= i0;
                C2[1] ^= i1;
                C2[2] ^= i22;
                C2[3] ^= i3;
                C2[4] ^= i0;
                C2[5] ^= i1;
                C2[6] ^= i22;
                C2[7] ^= i3;
                for (var i2 = 0; i2 < 4; i2++) {
                  nextState.call(this);
                }
              }
            },
            _doProcessBlock: function(M, offset) {
              var X = this._X;
              nextState.call(this);
              S[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
              S[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
              S[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
              S[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
              for (var i2 = 0; i2 < 4; i2++) {
                S[i2] = (S[i2] << 8 | S[i2] >>> 24) & 16711935 | (S[i2] << 24 | S[i2] >>> 8) & 4278255360;
                M[offset + i2] ^= S[i2];
              }
            },
            blockSize: 128 / 32,
            ivSize: 64 / 32
          });
          function nextState() {
            var X = this._X;
            var C2 = this._C;
            for (var i2 = 0; i2 < 8; i2++) {
              C_[i2] = C2[i2];
            }
            C2[0] = C2[0] + 1295307597 + this._b | 0;
            C2[1] = C2[1] + 3545052371 + (C2[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
            C2[2] = C2[2] + 886263092 + (C2[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
            C2[3] = C2[3] + 1295307597 + (C2[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
            C2[4] = C2[4] + 3545052371 + (C2[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
            C2[5] = C2[5] + 886263092 + (C2[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
            C2[6] = C2[6] + 1295307597 + (C2[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
            C2[7] = C2[7] + 3545052371 + (C2[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
            this._b = C2[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
            for (var i2 = 0; i2 < 8; i2++) {
              var gx = X[i2] + C2[i2];
              var ga = gx & 65535;
              var gb = gx >>> 16;
              var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
              var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
              G[i2] = gh ^ gl;
            }
            X[0] = G[0] + (G[7] << 16 | G[7] >>> 16) + (G[6] << 16 | G[6] >>> 16) | 0;
            X[1] = G[1] + (G[0] << 8 | G[0] >>> 24) + G[7] | 0;
            X[2] = G[2] + (G[1] << 16 | G[1] >>> 16) + (G[0] << 16 | G[0] >>> 16) | 0;
            X[3] = G[3] + (G[2] << 8 | G[2] >>> 24) + G[1] | 0;
            X[4] = G[4] + (G[3] << 16 | G[3] >>> 16) + (G[2] << 16 | G[2] >>> 16) | 0;
            X[5] = G[5] + (G[4] << 8 | G[4] >>> 24) + G[3] | 0;
            X[6] = G[6] + (G[5] << 16 | G[5] >>> 16) + (G[4] << 16 | G[4] >>> 16) | 0;
            X[7] = G[7] + (G[6] << 8 | G[6] >>> 24) + G[5] | 0;
          }
          C.Rabbit = StreamCipher._createHelper(Rabbit);
        })();
        return CryptoJS.Rabbit;
      });
    })(rabbit$1, rabbit$1.exports);
    return rabbit$1.exports;
  }
  var rabbitLegacy$1 = { exports: {} };
  var rabbitLegacy = rabbitLegacy$1.exports;
  var hasRequiredRabbitLegacy;
  function requireRabbitLegacy() {
    if (hasRequiredRabbitLegacy)
      return rabbitLegacy$1.exports;
    hasRequiredRabbitLegacy = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var S = [];
          var C_ = [];
          var G = [];
          var RabbitLegacy = C_algo.RabbitLegacy = StreamCipher.extend({
            _doReset: function() {
              var K = this._key.words;
              var iv = this.cfg.iv;
              var X = this._X = [
                K[0],
                K[3] << 16 | K[2] >>> 16,
                K[1],
                K[0] << 16 | K[3] >>> 16,
                K[2],
                K[1] << 16 | K[0] >>> 16,
                K[3],
                K[2] << 16 | K[1] >>> 16
              ];
              var C2 = this._C = [
                K[2] << 16 | K[2] >>> 16,
                K[0] & 4294901760 | K[1] & 65535,
                K[3] << 16 | K[3] >>> 16,
                K[1] & 4294901760 | K[2] & 65535,
                K[0] << 16 | K[0] >>> 16,
                K[2] & 4294901760 | K[3] & 65535,
                K[1] << 16 | K[1] >>> 16,
                K[3] & 4294901760 | K[0] & 65535
              ];
              this._b = 0;
              for (var i2 = 0; i2 < 4; i2++) {
                nextState.call(this);
              }
              for (var i2 = 0; i2 < 8; i2++) {
                C2[i2] ^= X[i2 + 4 & 7];
              }
              if (iv) {
                var IV = iv.words;
                var IV_0 = IV[0];
                var IV_1 = IV[1];
                var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
                var i22 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
                var i1 = i0 >>> 16 | i22 & 4294901760;
                var i3 = i22 << 16 | i0 & 65535;
                C2[0] ^= i0;
                C2[1] ^= i1;
                C2[2] ^= i22;
                C2[3] ^= i3;
                C2[4] ^= i0;
                C2[5] ^= i1;
                C2[6] ^= i22;
                C2[7] ^= i3;
                for (var i2 = 0; i2 < 4; i2++) {
                  nextState.call(this);
                }
              }
            },
            _doProcessBlock: function(M, offset) {
              var X = this._X;
              nextState.call(this);
              S[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
              S[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
              S[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
              S[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
              for (var i2 = 0; i2 < 4; i2++) {
                S[i2] = (S[i2] << 8 | S[i2] >>> 24) & 16711935 | (S[i2] << 24 | S[i2] >>> 8) & 4278255360;
                M[offset + i2] ^= S[i2];
              }
            },
            blockSize: 128 / 32,
            ivSize: 64 / 32
          });
          function nextState() {
            var X = this._X;
            var C2 = this._C;
            for (var i2 = 0; i2 < 8; i2++) {
              C_[i2] = C2[i2];
            }
            C2[0] = C2[0] + 1295307597 + this._b | 0;
            C2[1] = C2[1] + 3545052371 + (C2[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
            C2[2] = C2[2] + 886263092 + (C2[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
            C2[3] = C2[3] + 1295307597 + (C2[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
            C2[4] = C2[4] + 3545052371 + (C2[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
            C2[5] = C2[5] + 886263092 + (C2[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
            C2[6] = C2[6] + 1295307597 + (C2[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
            C2[7] = C2[7] + 3545052371 + (C2[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
            this._b = C2[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
            for (var i2 = 0; i2 < 8; i2++) {
              var gx = X[i2] + C2[i2];
              var ga = gx & 65535;
              var gb = gx >>> 16;
              var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
              var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
              G[i2] = gh ^ gl;
            }
            X[0] = G[0] + (G[7] << 16 | G[7] >>> 16) + (G[6] << 16 | G[6] >>> 16) | 0;
            X[1] = G[1] + (G[0] << 8 | G[0] >>> 24) + G[7] | 0;
            X[2] = G[2] + (G[1] << 16 | G[1] >>> 16) + (G[0] << 16 | G[0] >>> 16) | 0;
            X[3] = G[3] + (G[2] << 8 | G[2] >>> 24) + G[1] | 0;
            X[4] = G[4] + (G[3] << 16 | G[3] >>> 16) + (G[2] << 16 | G[2] >>> 16) | 0;
            X[5] = G[5] + (G[4] << 8 | G[4] >>> 24) + G[3] | 0;
            X[6] = G[6] + (G[5] << 16 | G[5] >>> 16) + (G[4] << 16 | G[4] >>> 16) | 0;
            X[7] = G[7] + (G[6] << 8 | G[6] >>> 24) + G[5] | 0;
          }
          C.RabbitLegacy = StreamCipher._createHelper(RabbitLegacy);
        })();
        return CryptoJS.RabbitLegacy;
      });
    })(rabbitLegacy$1, rabbitLegacy$1.exports);
    return rabbitLegacy$1.exports;
  }
  var blowfish$1 = { exports: {} };
  var blowfish = blowfish$1.exports;
  var hasRequiredBlowfish;
  function requireBlowfish() {
    if (hasRequiredBlowfish)
      return blowfish$1.exports;
    hasRequiredBlowfish = 1;
    (function(module, exports) {
      ;
      (function(root, factory, undef2) {
        if (true) {
          module.exports = exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
        } else if (false) {
          (void 0)(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(commonjsGlobal, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var BlockCipher = C_lib.BlockCipher;
          var C_algo = C.algo;
          const N = 16;
          const ORIG_P = [
            608135816,
            2242054355,
            320440878,
            57701188,
            2752067618,
            698298832,
            137296536,
            3964562569,
            1160258022,
            953160567,
            3193202383,
            887688300,
            3232508343,
            3380367581,
            1065670069,
            3041331479,
            2450970073,
            2306472731
          ];
          const ORIG_S = [
            [
              3509652390,
              2564797868,
              805139163,
              3491422135,
              3101798381,
              1780907670,
              3128725573,
              4046225305,
              614570311,
              3012652279,
              134345442,
              2240740374,
              1667834072,
              1901547113,
              2757295779,
              4103290238,
              227898511,
              1921955416,
              1904987480,
              2182433518,
              2069144605,
              3260701109,
              2620446009,
              720527379,
              3318853667,
              677414384,
              3393288472,
              3101374703,
              2390351024,
              1614419982,
              1822297739,
              2954791486,
              3608508353,
              3174124327,
              2024746970,
              1432378464,
              3864339955,
              2857741204,
              1464375394,
              1676153920,
              1439316330,
              715854006,
              3033291828,
              289532110,
              2706671279,
              2087905683,
              3018724369,
              1668267050,
              732546397,
              1947742710,
              3462151702,
              2609353502,
              2950085171,
              1814351708,
              2050118529,
              680887927,
              999245976,
              1800124847,
              3300911131,
              1713906067,
              1641548236,
              4213287313,
              1216130144,
              1575780402,
              4018429277,
              3917837745,
              3693486850,
              3949271944,
              596196993,
              3549867205,
              258830323,
              2213823033,
              772490370,
              2760122372,
              1774776394,
              2652871518,
              566650946,
              4142492826,
              1728879713,
              2882767088,
              1783734482,
              3629395816,
              2517608232,
              2874225571,
              1861159788,
              326777828,
              3124490320,
              2130389656,
              2716951837,
              967770486,
              1724537150,
              2185432712,
              2364442137,
              1164943284,
              2105845187,
              998989502,
              3765401048,
              2244026483,
              1075463327,
              1455516326,
              1322494562,
              910128902,
              469688178,
              1117454909,
              936433444,
              3490320968,
              3675253459,
              1240580251,
              122909385,
              2157517691,
              634681816,
              4142456567,
              3825094682,
              3061402683,
              2540495037,
              79693498,
              3249098678,
              1084186820,
              1583128258,
              426386531,
              1761308591,
              1047286709,
              322548459,
              995290223,
              1845252383,
              2603652396,
              3431023940,
              2942221577,
              3202600964,
              3727903485,
              1712269319,
              422464435,
              3234572375,
              1170764815,
              3523960633,
              3117677531,
              1434042557,
              442511882,
              3600875718,
              1076654713,
              1738483198,
              4213154764,
              2393238008,
              3677496056,
              1014306527,
              4251020053,
              793779912,
              2902807211,
              842905082,
              4246964064,
              1395751752,
              1040244610,
              2656851899,
              3396308128,
              445077038,
              3742853595,
              3577915638,
              679411651,
              2892444358,
              2354009459,
              1767581616,
              3150600392,
              3791627101,
              3102740896,
              284835224,
              4246832056,
              1258075500,
              768725851,
              2589189241,
              3069724005,
              3532540348,
              1274779536,
              3789419226,
              2764799539,
              1660621633,
              3471099624,
              4011903706,
              913787905,
              3497959166,
              737222580,
              2514213453,
              2928710040,
              3937242737,
              1804850592,
              3499020752,
              2949064160,
              2386320175,
              2390070455,
              2415321851,
              4061277028,
              2290661394,
              2416832540,
              1336762016,
              1754252060,
              3520065937,
              3014181293,
              791618072,
              3188594551,
              3933548030,
              2332172193,
              3852520463,
              3043980520,
              413987798,
              3465142937,
              3030929376,
              4245938359,
              2093235073,
              3534596313,
              375366246,
              2157278981,
              2479649556,
              555357303,
              3870105701,
              2008414854,
              3344188149,
              4221384143,
              3956125452,
              2067696032,
              3594591187,
              2921233993,
              2428461,
              544322398,
              577241275,
              1471733935,
              610547355,
              4027169054,
              1432588573,
              1507829418,
              2025931657,
              3646575487,
              545086370,
              48609733,
              2200306550,
              1653985193,
              298326376,
              1316178497,
              3007786442,
              2064951626,
              458293330,
              2589141269,
              3591329599,
              3164325604,
              727753846,
              2179363840,
              146436021,
              1461446943,
              4069977195,
              705550613,
              3059967265,
              3887724982,
              4281599278,
              3313849956,
              1404054877,
              2845806497,
              146425753,
              1854211946
            ],
            [
              1266315497,
              3048417604,
              3681880366,
              3289982499,
              290971e4,
              1235738493,
              2632868024,
              2414719590,
              3970600049,
              1771706367,
              1449415276,
              3266420449,
              422970021,
              1963543593,
              2690192192,
              3826793022,
              1062508698,
              1531092325,
              1804592342,
              2583117782,
              2714934279,
              4024971509,
              1294809318,
              4028980673,
              1289560198,
              2221992742,
              1669523910,
              35572830,
              157838143,
              1052438473,
              1016535060,
              1802137761,
              1753167236,
              1386275462,
              3080475397,
              2857371447,
              1040679964,
              2145300060,
              2390574316,
              1461121720,
              2956646967,
              4031777805,
              4028374788,
              33600511,
              2920084762,
              1018524850,
              629373528,
              3691585981,
              3515945977,
              2091462646,
              2486323059,
              586499841,
              988145025,
              935516892,
              3367335476,
              2599673255,
              2839830854,
              265290510,
              3972581182,
              2759138881,
              3795373465,
              1005194799,
              847297441,
              406762289,
              1314163512,
              1332590856,
              1866599683,
              4127851711,
              750260880,
              613907577,
              1450815602,
              3165620655,
              3734664991,
              3650291728,
              3012275730,
              3704569646,
              1427272223,
              778793252,
              1343938022,
              2676280711,
              2052605720,
              1946737175,
              3164576444,
              3914038668,
              3967478842,
              3682934266,
              1661551462,
              3294938066,
              4011595847,
              840292616,
              3712170807,
              616741398,
              312560963,
              711312465,
              1351876610,
              322626781,
              1910503582,
              271666773,
              2175563734,
              1594956187,
              70604529,
              3617834859,
              1007753275,
              1495573769,
              4069517037,
              2549218298,
              2663038764,
              504708206,
              2263041392,
              3941167025,
              2249088522,
              1514023603,
              1998579484,
              1312622330,
              694541497,
              2582060303,
              2151582166,
              1382467621,
              776784248,
              2618340202,
              3323268794,
              2497899128,
              2784771155,
              503983604,
              4076293799,
              907881277,
              423175695,
              432175456,
              1378068232,
              4145222326,
              3954048622,
              3938656102,
              3820766613,
              2793130115,
              2977904593,
              26017576,
              3274890735,
              3194772133,
              1700274565,
              1756076034,
              4006520079,
              3677328699,
              720338349,
              1533947780,
              354530856,
              688349552,
              3973924725,
              1637815568,
              332179504,
              3949051286,
              53804574,
              2852348879,
              3044236432,
              1282449977,
              3583942155,
              3416972820,
              4006381244,
              1617046695,
              2628476075,
              3002303598,
              1686838959,
              431878346,
              2686675385,
              1700445008,
              1080580658,
              1009431731,
              832498133,
              3223435511,
              2605976345,
              2271191193,
              2516031870,
              1648197032,
              4164389018,
              2548247927,
              300782431,
              375919233,
              238389289,
              3353747414,
              2531188641,
              2019080857,
              1475708069,
              455242339,
              2609103871,
              448939670,
              3451063019,
              1395535956,
              2413381860,
              1841049896,
              1491858159,
              885456874,
              4264095073,
              4001119347,
              1565136089,
              3898914787,
              1108368660,
              540939232,
              1173283510,
              2745871338,
              3681308437,
              4207628240,
              3343053890,
              4016749493,
              1699691293,
              1103962373,
              3625875870,
              2256883143,
              3830138730,
              1031889488,
              3479347698,
              1535977030,
              4236805024,
              3251091107,
              2132092099,
              1774941330,
              1199868427,
              1452454533,
              157007616,
              2904115357,
              342012276,
              595725824,
              1480756522,
              206960106,
              497939518,
              591360097,
              863170706,
              2375253569,
              3596610801,
              1814182875,
              2094937945,
              3421402208,
              1082520231,
              3463918190,
              2785509508,
              435703966,
              3908032597,
              1641649973,
              2842273706,
              3305899714,
              1510255612,
              2148256476,
              2655287854,
              3276092548,
              4258621189,
              236887753,
              3681803219,
              274041037,
              1734335097,
              3815195456,
              3317970021,
              1899903192,
              1026095262,
              4050517792,
              356393447,
              2410691914,
              3873677099,
              3682840055
            ],
            [
              3913112168,
              2491498743,
              4132185628,
              2489919796,
              1091903735,
              1979897079,
              3170134830,
              3567386728,
              3557303409,
              857797738,
              1136121015,
              1342202287,
              507115054,
              2535736646,
              337727348,
              3213592640,
              1301675037,
              2528481711,
              1895095763,
              1721773893,
              3216771564,
              62756741,
              2142006736,
              835421444,
              2531993523,
              1442658625,
              3659876326,
              2882144922,
              676362277,
              1392781812,
              170690266,
              3921047035,
              1759253602,
              3611846912,
              1745797284,
              664899054,
              1329594018,
              3901205900,
              3045908486,
              2062866102,
              2865634940,
              3543621612,
              3464012697,
              1080764994,
              553557557,
              3656615353,
              3996768171,
              991055499,
              499776247,
              1265440854,
              648242737,
              3940784050,
              980351604,
              3713745714,
              1749149687,
              3396870395,
              4211799374,
              3640570775,
              1161844396,
              3125318951,
              1431517754,
              545492359,
              4268468663,
              3499529547,
              1437099964,
              2702547544,
              3433638243,
              2581715763,
              2787789398,
              1060185593,
              1593081372,
              2418618748,
              4260947970,
              69676912,
              2159744348,
              86519011,
              2512459080,
              3838209314,
              1220612927,
              3339683548,
              133810670,
              1090789135,
              1078426020,
              1569222167,
              845107691,
              3583754449,
              4072456591,
              1091646820,
              628848692,
              1613405280,
              3757631651,
              526609435,
              236106946,
              48312990,
              2942717905,
              3402727701,
              1797494240,
              859738849,
              992217954,
              4005476642,
              2243076622,
              3870952857,
              3732016268,
              765654824,
              3490871365,
              2511836413,
              1685915746,
              3888969200,
              1414112111,
              2273134842,
              3281911079,
              4080962846,
              172450625,
              2569994100,
              980381355,
              4109958455,
              2819808352,
              2716589560,
              2568741196,
              3681446669,
              3329971472,
              1835478071,
              660984891,
              3704678404,
              4045999559,
              3422617507,
              3040415634,
              1762651403,
              1719377915,
              3470491036,
              2693910283,
              3642056355,
              3138596744,
              1364962596,
              2073328063,
              1983633131,
              926494387,
              3423689081,
              2150032023,
              4096667949,
              1749200295,
              3328846651,
              309677260,
              2016342300,
              1779581495,
              3079819751,
              111262694,
              1274766160,
              443224088,
              298511866,
              1025883608,
              3806446537,
              1145181785,
              168956806,
              3641502830,
              3584813610,
              1689216846,
              3666258015,
              3200248200,
              1692713982,
              2646376535,
              4042768518,
              1618508792,
              1610833997,
              3523052358,
              4130873264,
              2001055236,
              3610705100,
              2202168115,
              4028541809,
              2961195399,
              1006657119,
              2006996926,
              3186142756,
              1430667929,
              3210227297,
              1314452623,
              4074634658,
              4101304120,
              2273951170,
              1399257539,
              3367210612,
              3027628629,
              1190975929,
              2062231137,
              2333990788,
              2221543033,
              2438960610,
              1181637006,
              548689776,
              2362791313,
              3372408396,
              3104550113,
              3145860560,
              296247880,
              1970579870,
              3078560182,
              3769228297,
              1714227617,
              3291629107,
              3898220290,
              166772364,
              1251581989,
              493813264,
              448347421,
              195405023,
              2709975567,
              677966185,
              3703036547,
              1463355134,
              2715995803,
              1338867538,
              1343315457,
              2802222074,
              2684532164,
              233230375,
              2599980071,
              2000651841,
              3277868038,
              1638401717,
              4028070440,
              3237316320,
              6314154,
              819756386,
              300326615,
              590932579,
              1405279636,
              3267499572,
              3150704214,
              2428286686,
              3959192993,
              3461946742,
              1862657033,
              1266418056,
              963775037,
              2089974820,
              2263052895,
              1917689273,
              448879540,
              3550394620,
              3981727096,
              150775221,
              3627908307,
              1303187396,
              508620638,
              2975983352,
              2726630617,
              1817252668,
              1876281319,
              1457606340,
              908771278,
              3720792119,
              3617206836,
              2455994898,
              1729034894,
              1080033504
            ],
            [
              976866871,
              3556439503,
              2881648439,
              1522871579,
              1555064734,
              1336096578,
              3548522304,
              2579274686,
              3574697629,
              3205460757,
              3593280638,
              3338716283,
              3079412587,
              564236357,
              2993598910,
              1781952180,
              1464380207,
              3163844217,
              3332601554,
              1699332808,
              1393555694,
              1183702653,
              3581086237,
              1288719814,
              691649499,
              2847557200,
              2895455976,
              3193889540,
              2717570544,
              1781354906,
              1676643554,
              2592534050,
              3230253752,
              1126444790,
              2770207658,
              2633158820,
              2210423226,
              2615765581,
              2414155088,
              3127139286,
              673620729,
              2805611233,
              1269405062,
              4015350505,
              3341807571,
              4149409754,
              1057255273,
              2012875353,
              2162469141,
              2276492801,
              2601117357,
              993977747,
              3918593370,
              2654263191,
              753973209,
              36408145,
              2530585658,
              25011837,
              3520020182,
              2088578344,
              530523599,
              2918365339,
              1524020338,
              1518925132,
              3760827505,
              3759777254,
              1202760957,
              3985898139,
              3906192525,
              674977740,
              4174734889,
              2031300136,
              2019492241,
              3983892565,
              4153806404,
              3822280332,
              352677332,
              2297720250,
              60907813,
              90501309,
              3286998549,
              1016092578,
              2535922412,
              2839152426,
              457141659,
              509813237,
              4120667899,
              652014361,
              1966332200,
              2975202805,
              55981186,
              2327461051,
              676427537,
              3255491064,
              2882294119,
              3433927263,
              1307055953,
              942726286,
              933058658,
              2468411793,
              3933900994,
              4215176142,
              1361170020,
              2001714738,
              2830558078,
              3274259782,
              1222529897,
              1679025792,
              2729314320,
              3714953764,
              1770335741,
              151462246,
              3013232138,
              1682292957,
              1483529935,
              471910574,
              1539241949,
              458788160,
              3436315007,
              1807016891,
              3718408830,
              978976581,
              1043663428,
              3165965781,
              1927990952,
              4200891579,
              2372276910,
              3208408903,
              3533431907,
              1412390302,
              2931980059,
              4132332400,
              1947078029,
              3881505623,
              4168226417,
              2941484381,
              1077988104,
              1320477388,
              886195818,
              18198404,
              3786409e3,
              2509781533,
              112762804,
              3463356488,
              1866414978,
              891333506,
              18488651,
              661792760,
              1628790961,
              3885187036,
              3141171499,
              876946877,
              2693282273,
              1372485963,
              791857591,
              2686433993,
              3759982718,
              3167212022,
              3472953795,
              2716379847,
              445679433,
              3561995674,
              3504004811,
              3574258232,
              54117162,
              3331405415,
              2381918588,
              3769707343,
              4154350007,
              1140177722,
              4074052095,
              668550556,
              3214352940,
              367459370,
              261225585,
              2610173221,
              4209349473,
              3468074219,
              3265815641,
              314222801,
              3066103646,
              3808782860,
              282218597,
              3406013506,
              3773591054,
              379116347,
              1285071038,
              846784868,
              2669647154,
              3771962079,
              3550491691,
              2305946142,
              453669953,
              1268987020,
              3317592352,
              3279303384,
              3744833421,
              2610507566,
              3859509063,
              266596637,
              3847019092,
              517658769,
              3462560207,
              3443424879,
              370717030,
              4247526661,
              2224018117,
              4143653529,
              4112773975,
              2788324899,
              2477274417,
              1456262402,
              2901442914,
              1517677493,
              1846949527,
              2295493580,
              3734397586,
              2176403920,
              1280348187,
              1908823572,
              3871786941,
              846861322,
              1172426758,
              3287448474,
              3383383037,
              1655181056,
              3139813346,
              901632758,
              1897031941,
              2986607138,
              3066810236,
              3447102507,
              1393639104,
              373351379,
              950779232,
              625454576,
              3124240540,
              4148612726,
              2007998917,
              544563296,
              2244738638,
              2330496472,
              2058025392,
              1291430526,
              424198748,
              50039436,
              29584100,
              3605783033,
              2429876329,
              2791104160,
              1057563949,
              3255363231,
              3075367218,
              3463963227,
              1469046755,
              985887462
            ]
          ];
          var BLOWFISH_CTX = {
            pbox: [],
            sbox: []
          };
          function F(ctx, x) {
            let a2 = x >> 24 & 255;
            let b = x >> 16 & 255;
            let c2 = x >> 8 & 255;
            let d2 = x & 255;
            let y = ctx.sbox[0][a2] + ctx.sbox[1][b];
            y = y ^ ctx.sbox[2][c2];
            y = y + ctx.sbox[3][d2];
            return y;
          }
          function BlowFish_Encrypt(ctx, left, right) {
            let Xl = left;
            let Xr = right;
            let temp;
            for (let i2 = 0; i2 < N; ++i2) {
              Xl = Xl ^ ctx.pbox[i2];
              Xr = F(ctx, Xl) ^ Xr;
              temp = Xl;
              Xl = Xr;
              Xr = temp;
            }
            temp = Xl;
            Xl = Xr;
            Xr = temp;
            Xr = Xr ^ ctx.pbox[N];
            Xl = Xl ^ ctx.pbox[N + 1];
            return { left: Xl, right: Xr };
          }
          function BlowFish_Decrypt(ctx, left, right) {
            let Xl = left;
            let Xr = right;
            let temp;
            for (let i2 = N + 1; i2 > 1; --i2) {
              Xl = Xl ^ ctx.pbox[i2];
              Xr = F(ctx, Xl) ^ Xr;
              temp = Xl;
              Xl = Xr;
              Xr = temp;
            }
            temp = Xl;
            Xl = Xr;
            Xr = temp;
            Xr = Xr ^ ctx.pbox[1];
            Xl = Xl ^ ctx.pbox[0];
            return { left: Xl, right: Xr };
          }
          function BlowFishInit(ctx, key2, keysize) {
            for (let Row = 0; Row < 4; Row++) {
              ctx.sbox[Row] = [];
              for (let Col = 0; Col < 256; Col++) {
                ctx.sbox[Row][Col] = ORIG_S[Row][Col];
              }
            }
            let keyIndex = 0;
            for (let index2 = 0; index2 < N + 2; index2++) {
              ctx.pbox[index2] = ORIG_P[index2] ^ key2[keyIndex];
              keyIndex++;
              if (keyIndex >= keysize) {
                keyIndex = 0;
              }
            }
            let Data1 = 0;
            let Data2 = 0;
            let res = 0;
            for (let i2 = 0; i2 < N + 2; i2 += 2) {
              res = BlowFish_Encrypt(ctx, Data1, Data2);
              Data1 = res.left;
              Data2 = res.right;
              ctx.pbox[i2] = Data1;
              ctx.pbox[i2 + 1] = Data2;
            }
            for (let i2 = 0; i2 < 4; i2++) {
              for (let j = 0; j < 256; j += 2) {
                res = BlowFish_Encrypt(ctx, Data1, Data2);
                Data1 = res.left;
                Data2 = res.right;
                ctx.sbox[i2][j] = Data1;
                ctx.sbox[i2][j + 1] = Data2;
              }
            }
            return true;
          }
          var Blowfish = C_algo.Blowfish = BlockCipher.extend({
            _doReset: function() {
              if (this._keyPriorReset === this._key) {
                return;
              }
              var key2 = this._keyPriorReset = this._key;
              var keyWords = key2.words;
              var keySize = key2.sigBytes / 4;
              BlowFishInit(BLOWFISH_CTX, keyWords, keySize);
            },
            encryptBlock: function(M, offset) {
              var res = BlowFish_Encrypt(BLOWFISH_CTX, M[offset], M[offset + 1]);
              M[offset] = res.left;
              M[offset + 1] = res.right;
            },
            decryptBlock: function(M, offset) {
              var res = BlowFish_Decrypt(BLOWFISH_CTX, M[offset], M[offset + 1]);
              M[offset] = res.left;
              M[offset + 1] = res.right;
            },
            blockSize: 64 / 32,
            keySize: 128 / 32,
            ivSize: 64 / 32
          });
          C.Blowfish = BlockCipher._createHelper(Blowfish);
        })();
        return CryptoJS.Blowfish;
      });
    })(blowfish$1, blowfish$1.exports);
    return blowfish$1.exports;
  }
  var cryptoJs = cryptoJs$1.exports;
  (function(module, exports) {
    ;
    (function(root, factory, undef2) {
      if (true) {
        module.exports = exports = factory(requireCore(), requireX64Core(), requireLibTypedarrays(), requireEncUtf16(), requireEncBase64(), requireEncBase64url(), requireMd5(), requireSha1(), requireSha256(), requireSha224(), requireSha512(), requireSha384(), requireSha3(), requireRipemd160(), requireHmac(), requirePbkdf2(), requireEvpkdf(), requireCipherCore(), requireModeCfb(), requireModeCtr(), requireModeCtrGladman(), requireModeOfb(), requireModeEcb(), requirePadAnsix923(), requirePadIso10126(), requirePadIso97971(), requirePadZeropadding(), requirePadNopadding(), requireFormatHex(), requireAes(), requireTripledes(), requireRc4(), requireRabbit(), requireRabbitLegacy(), requireBlowfish());
      } else if (false) {
        (void 0)(["./core", "./x64-core", "./lib-typedarrays", "./enc-utf16", "./enc-base64", "./enc-base64url", "./md5", "./sha1", "./sha256", "./sha224", "./sha512", "./sha384", "./sha3", "./ripemd160", "./hmac", "./pbkdf2", "./evpkdf", "./cipher-core", "./mode-cfb", "./mode-ctr", "./mode-ctr-gladman", "./mode-ofb", "./mode-ecb", "./pad-ansix923", "./pad-iso10126", "./pad-iso97971", "./pad-zeropadding", "./pad-nopadding", "./format-hex", "./aes", "./tripledes", "./rc4", "./rabbit", "./rabbit-legacy", "./blowfish"], factory);
      } else {
        root.CryptoJS = factory(root.CryptoJS);
      }
    })(commonjsGlobal, function(CryptoJS) {
      return CryptoJS;
    });
  })(cryptoJs$1, cryptoJs$1.exports);
  var cryptoJsExports = cryptoJs$1.exports;
  const index$2 = /* @__PURE__ */ getDefaultExportFromCjs$1(cryptoJsExports);
  var basicContext_min$2 = { exports: {} };
  var basicContext_min = basicContext_min$2.exports;
  (function(module) {
    "use strict";
    !function(n2, t2) {
      module.exports ? module.exports = t2() : false ? (void 0)(t2) : window[n2] = t2();
    }("basicContext", function() {
      var n2 = null, t2 = "item", e2 = "separator", i2 = function() {
        var n3 = arguments.length <= 0 || void 0 === arguments[0] ? "" : arguments[0];
        return document.querySelector(".basicContext " + n3);
      }, l2 = function() {
        var n3 = arguments.length <= 0 || void 0 === arguments[0] ? {} : arguments[0], i3 = 0 === Object.keys(n3).length ? true : false;
        return i3 === true && (n3.type = e2), null == n3.type && (n3.type = t2), null == n3["class"] && (n3["class"] = ""), n3.visible !== false && (n3.visible = true), null == n3.icon && (n3.icon = null), null == n3.title && (n3.title = "Undefined"), n3.disabled !== true && (n3.disabled = false), n3.disabled === true && (n3["class"] += " basicContext__item--disabled"), null == n3.fn && n3.type !== e2 && n3.disabled === false ? (console.warn("Missing fn for item '" + n3.title + "'"), false) : true;
      }, o2 = function(n3, i3) {
        var o3 = "", r3 = "";
        return l2(n3) === false ? "" : n3.visible === false ? "" : (n3.num = i3, null !== n3.icon && (r3 = "<span class='basicContext__icon " + n3.icon + "'></span>"), n3.type === t2 ? o3 = "\n		       <tr class='basicContext__item " + n3["class"] + "'>\n		           <td class='basicContext__data' data-num='" + n3.num + "'>" + r3 + n3.title + "</td>\n		       </tr>\n		       " : n3.type === e2 && (o3 = "\n		       <tr class='basicContext__item basicContext__item--separator'></tr>\n		       "), o3);
      }, r2 = function(n3) {
        var t3 = "";
        return t3 += "\n	        <div class='basicContextContainer'>\n	            <div class='basicContext'>\n	                <table>\n	                    <tbody>\n	        ", n3.forEach(function(n4, e3) {
          return t3 += o2(n4, e3);
        }), t3 += "\n	                    </tbody>\n	                </table>\n	            </div>\n	        </div>\n	        ";
      }, a2 = function() {
        var n3 = arguments.length <= 0 || void 0 === arguments[0] ? {} : arguments[0], t3 = { x: n3.clientX, y: n3.clientY };
        if ("touchend" === n3.type && (null == t3.x || null == t3.y)) {
          var e3 = n3.changedTouches;
          null != e3 && e3.length > 0 && (t3.x = e3[0].clientX, t3.y = e3[0].clientY);
        }
        return (null == t3.x || t3.x < 0) && (t3.x = 0), (null == t3.y || t3.y < 0) && (t3.y = 0), t3;
      }, s2 = function(n3, t3) {
        var e3 = a2(n3), i3 = e3.x, l3 = e3.y, o3 = { width: window.innerWidth, height: window.innerHeight }, r3 = { width: t3.offsetWidth, height: t3.offsetHeight };
        i3 + r3.width > o3.width && (i3 -= i3 + r3.width - o3.width), l3 + r3.height > o3.height && (l3 -= l3 + r3.height - o3.height), r3.height > o3.height && (l3 = 0, t3.classList.add("basicContext--scrollable"));
        var s3 = e3.x - i3, u3 = e3.y - l3;
        return { x: i3, y: l3, rx: s3, ry: u3 };
      }, u2 = function() {
        var n3 = arguments.length <= 0 || void 0 === arguments[0] ? {} : arguments[0];
        return null == n3.fn ? false : n3.visible === false ? false : n3.disabled === true ? false : (i2("td[data-num='" + n3.num + "']").onclick = n3.fn, i2("td[data-num='" + n3.num + "']").oncontextmenu = n3.fn, true);
      }, c2 = function(t3, e3, l3, o3) {
        var a3 = r2(t3);
        document.body.insertAdjacentHTML("beforeend", a3), null == n2 && (n2 = document.body.style.overflow, document.body.style.overflow = "hidden");
        var c3 = i2(), d3 = s2(e3, c3);
        return c3.style.left = d3.x + "px", c3.style.top = d3.y + "px", c3.style.transformOrigin = d3.rx + "px " + d3.ry + "px", c3.style.opacity = 1, null == l3 && (l3 = f2), c3.parentElement.onclick = l3, c3.parentElement.oncontextmenu = l3, t3.forEach(u2), "function" == typeof e3.preventDefault && e3.preventDefault(), "function" == typeof e3.stopPropagation && e3.stopPropagation(), "function" == typeof o3 && o3(), true;
      }, d2 = function() {
        var n3 = i2();
        return null == n3 || 0 === n3.length ? false : true;
      }, f2 = function() {
        if (d2() === false)
          return false;
        var t3 = document.querySelector(".basicContextContainer");
        return t3.parentElement.removeChild(t3), null != n2 && (document.body.style.overflow = n2, n2 = null), true;
      };
      return { ITEM: t2, SEPARATOR: e2, show: c2, visible: d2, close: f2 };
    });
  })(basicContext_min$2);
  var basicContext_minExports = basicContext_min$2.exports;
  const basicContext_min$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(basicContext_minExports);
  var dayjs_min$1 = { exports: {} };
  var dayjs_min = dayjs_min$1.exports;
  (function(module, exports) {
    !function(t2, e2) {
      true ? module.exports = e2() : false ? (void 0)(e2) : (t2 = "undefined" != typeof globalThis ? globalThis : t2 || self).dayjs = e2();
    }(commonjsGlobal, function() {
      "use strict";
      var t2 = 1e3, e2 = 6e4, n2 = 36e5, r2 = "millisecond", i2 = "second", s2 = "minute", u2 = "hour", a2 = "day", o2 = "week", f2 = "month", h2 = "quarter", c2 = "year", d2 = "date", l2 = "Invalid Date", $2 = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ordinal: function(t3) {
        var e3 = ["th", "st", "nd", "rd"], n3 = t3 % 100;
        return "[" + t3 + (e3[(n3 - 20) % 10] || e3[n3] || e3[0]) + "]";
      } }, m = function(t3, e3, n3) {
        var r3 = String(t3);
        return !r3 || r3.length >= e3 ? t3 : "" + Array(e3 + 1 - r3.length).join(n3) + t3;
      }, v = { s: m, z: function(t3) {
        var e3 = -t3.utcOffset(), n3 = Math.abs(e3), r3 = Math.floor(n3 / 60), i3 = n3 % 60;
        return (e3 <= 0 ? "+" : "-") + m(r3, 2, "0") + ":" + m(i3, 2, "0");
      }, m: function t3(e3, n3) {
        if (e3.date() < n3.date())
          return -t3(n3, e3);
        var r3 = 12 * (n3.year() - e3.year()) + (n3.month() - e3.month()), i3 = e3.clone().add(r3, f2), s3 = n3 - i3 < 0, u3 = e3.clone().add(r3 + (s3 ? -1 : 1), f2);
        return +(-(r3 + (n3 - i3) / (s3 ? i3 - u3 : u3 - i3)) || 0);
      }, a: function(t3) {
        return t3 < 0 ? Math.ceil(t3) || 0 : Math.floor(t3);
      }, p: function(t3) {
        return { M: f2, y: c2, w: o2, d: a2, D: d2, h: u2, m: s2, s: i2, ms: r2, Q: h2 }[t3] || String(t3 || "").toLowerCase().replace(/s$/, "");
      }, u: function(t3) {
        return void 0 === t3;
      } }, g = "en", D = {};
      D[g] = M;
      var p2 = function(t3) {
        return t3 instanceof _;
      }, S = function t3(e3, n3, r3) {
        var i3;
        if (!e3)
          return g;
        if ("string" == typeof e3) {
          var s3 = e3.toLowerCase();
          D[s3] && (i3 = s3), n3 && (D[s3] = n3, i3 = s3);
          var u3 = e3.split("-");
          if (!i3 && u3.length > 1)
            return t3(u3[0]);
        } else {
          var a3 = e3.name;
          D[a3] = e3, i3 = a3;
        }
        return !r3 && i3 && (g = i3), i3 || !r3 && g;
      }, w = function(t3, e3) {
        if (p2(t3))
          return t3.clone();
        var n3 = "object" == typeof e3 ? e3 : {};
        return n3.date = t3, n3.args = arguments, new _(n3);
      }, O = v;
      O.l = S, O.i = p2, O.w = function(t3, e3) {
        return w(t3, { locale: e3.$L, utc: e3.$u, x: e3.$x, $offset: e3.$offset });
      };
      var _ = function() {
        function M2(t3) {
          this.$L = S(t3.locale, null, true), this.parse(t3);
        }
        var m2 = M2.prototype;
        return m2.parse = function(t3) {
          this.$d = function(t4) {
            var e3 = t4.date, n3 = t4.utc;
            if (null === e3)
              return /* @__PURE__ */ new Date(NaN);
            if (O.u(e3))
              return /* @__PURE__ */ new Date();
            if (e3 instanceof Date)
              return new Date(e3);
            if ("string" == typeof e3 && !/Z$/i.test(e3)) {
              var r3 = e3.match($2);
              if (r3) {
                var i3 = r3[2] - 1 || 0, s3 = (r3[7] || "0").substring(0, 3);
                return n3 ? new Date(Date.UTC(r3[1], i3, r3[3] || 1, r3[4] || 0, r3[5] || 0, r3[6] || 0, s3)) : new Date(r3[1], i3, r3[3] || 1, r3[4] || 0, r3[5] || 0, r3[6] || 0, s3);
              }
            }
            return new Date(e3);
          }(t3), this.$x = t3.x || {}, this.init();
        }, m2.init = function() {
          var t3 = this.$d;
          this.$y = t3.getFullYear(), this.$M = t3.getMonth(), this.$D = t3.getDate(), this.$W = t3.getDay(), this.$H = t3.getHours(), this.$m = t3.getMinutes(), this.$s = t3.getSeconds(), this.$ms = t3.getMilliseconds();
        }, m2.$utils = function() {
          return O;
        }, m2.isValid = function() {
          return !(this.$d.toString() === l2);
        }, m2.isSame = function(t3, e3) {
          var n3 = w(t3);
          return this.startOf(e3) <= n3 && n3 <= this.endOf(e3);
        }, m2.isAfter = function(t3, e3) {
          return w(t3) < this.startOf(e3);
        }, m2.isBefore = function(t3, e3) {
          return this.endOf(e3) < w(t3);
        }, m2.$g = function(t3, e3, n3) {
          return O.u(t3) ? this[e3] : this.set(n3, t3);
        }, m2.unix = function() {
          return Math.floor(this.valueOf() / 1e3);
        }, m2.valueOf = function() {
          return this.$d.getTime();
        }, m2.startOf = function(t3, e3) {
          var n3 = this, r3 = !!O.u(e3) || e3, h3 = O.p(t3), l3 = function(t4, e4) {
            var i3 = O.w(n3.$u ? Date.UTC(n3.$y, e4, t4) : new Date(n3.$y, e4, t4), n3);
            return r3 ? i3 : i3.endOf(a2);
          }, $3 = function(t4, e4) {
            return O.w(n3.toDate()[t4].apply(n3.toDate("s"), (r3 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e4)), n3);
          }, y2 = this.$W, M3 = this.$M, m3 = this.$D, v2 = "set" + (this.$u ? "UTC" : "");
          switch (h3) {
            case c2:
              return r3 ? l3(1, 0) : l3(31, 11);
            case f2:
              return r3 ? l3(1, M3) : l3(0, M3 + 1);
            case o2:
              var g2 = this.$locale().weekStart || 0, D2 = (y2 < g2 ? y2 + 7 : y2) - g2;
              return l3(r3 ? m3 - D2 : m3 + (6 - D2), M3);
            case a2:
            case d2:
              return $3(v2 + "Hours", 0);
            case u2:
              return $3(v2 + "Minutes", 1);
            case s2:
              return $3(v2 + "Seconds", 2);
            case i2:
              return $3(v2 + "Milliseconds", 3);
            default:
              return this.clone();
          }
        }, m2.endOf = function(t3) {
          return this.startOf(t3, false);
        }, m2.$set = function(t3, e3) {
          var n3, o3 = O.p(t3), h3 = "set" + (this.$u ? "UTC" : ""), l3 = (n3 = {}, n3[a2] = h3 + "Date", n3[d2] = h3 + "Date", n3[f2] = h3 + "Month", n3[c2] = h3 + "FullYear", n3[u2] = h3 + "Hours", n3[s2] = h3 + "Minutes", n3[i2] = h3 + "Seconds", n3[r2] = h3 + "Milliseconds", n3)[o3], $3 = o3 === a2 ? this.$D + (e3 - this.$W) : e3;
          if (o3 === f2 || o3 === c2) {
            var y2 = this.clone().set(d2, 1);
            y2.$d[l3]($3), y2.init(), this.$d = y2.set(d2, Math.min(this.$D, y2.daysInMonth())).$d;
          } else
            l3 && this.$d[l3]($3);
          return this.init(), this;
        }, m2.set = function(t3, e3) {
          return this.clone().$set(t3, e3);
        }, m2.get = function(t3) {
          return this[O.p(t3)]();
        }, m2.add = function(r3, h3) {
          var d3, l3 = this;
          r3 = Number(r3);
          var $3 = O.p(h3), y2 = function(t3) {
            var e3 = w(l3);
            return O.w(e3.date(e3.date() + Math.round(t3 * r3)), l3);
          };
          if ($3 === f2)
            return this.set(f2, this.$M + r3);
          if ($3 === c2)
            return this.set(c2, this.$y + r3);
          if ($3 === a2)
            return y2(1);
          if ($3 === o2)
            return y2(7);
          var M3 = (d3 = {}, d3[s2] = e2, d3[u2] = n2, d3[i2] = t2, d3)[$3] || 1, m3 = this.$d.getTime() + r3 * M3;
          return O.w(m3, this);
        }, m2.subtract = function(t3, e3) {
          return this.add(-1 * t3, e3);
        }, m2.format = function(t3) {
          var e3 = this, n3 = this.$locale();
          if (!this.isValid())
            return n3.invalidDate || l2;
          var r3 = t3 || "YYYY-MM-DDTHH:mm:ssZ", i3 = O.z(this), s3 = this.$H, u3 = this.$m, a3 = this.$M, o3 = n3.weekdays, f3 = n3.months, h3 = function(t4, n4, i4, s4) {
            return t4 && (t4[n4] || t4(e3, r3)) || i4[n4].slice(0, s4);
          }, c3 = function(t4) {
            return O.s(s3 % 12 || 12, t4, "0");
          }, d3 = n3.meridiem || function(t4, e4, n4) {
            var r4 = t4 < 12 ? "AM" : "PM";
            return n4 ? r4.toLowerCase() : r4;
          }, $3 = { YY: String(this.$y).slice(-2), YYYY: this.$y, M: a3 + 1, MM: O.s(a3 + 1, 2, "0"), MMM: h3(n3.monthsShort, a3, f3, 3), MMMM: h3(f3, a3), D: this.$D, DD: O.s(this.$D, 2, "0"), d: String(this.$W), dd: h3(n3.weekdaysMin, this.$W, o3, 2), ddd: h3(n3.weekdaysShort, this.$W, o3, 3), dddd: o3[this.$W], H: String(s3), HH: O.s(s3, 2, "0"), h: c3(1), hh: c3(2), a: d3(s3, u3, true), A: d3(s3, u3, false), m: String(u3), mm: O.s(u3, 2, "0"), s: String(this.$s), ss: O.s(this.$s, 2, "0"), SSS: O.s(this.$ms, 3, "0"), Z: i3 };
          return r3.replace(y, function(t4, e4) {
            return e4 || $3[t4] || i3.replace(":", "");
          });
        }, m2.utcOffset = function() {
          return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
        }, m2.diff = function(r3, d3, l3) {
          var $3, y2 = O.p(d3), M3 = w(r3), m3 = (M3.utcOffset() - this.utcOffset()) * e2, v2 = this - M3, g2 = O.m(this, M3);
          return g2 = ($3 = {}, $3[c2] = g2 / 12, $3[f2] = g2, $3[h2] = g2 / 3, $3[o2] = (v2 - m3) / 6048e5, $3[a2] = (v2 - m3) / 864e5, $3[u2] = v2 / n2, $3[s2] = v2 / e2, $3[i2] = v2 / t2, $3)[y2] || v2, l3 ? g2 : O.a(g2);
        }, m2.daysInMonth = function() {
          return this.endOf(f2).$D;
        }, m2.$locale = function() {
          return D[this.$L];
        }, m2.locale = function(t3, e3) {
          if (!t3)
            return this.$L;
          var n3 = this.clone(), r3 = S(t3, e3, true);
          return r3 && (n3.$L = r3), n3;
        }, m2.clone = function() {
          return O.w(this.$d, this);
        }, m2.toDate = function() {
          return new Date(this.valueOf());
        }, m2.toJSON = function() {
          return this.isValid() ? this.toISOString() : null;
        }, m2.toISOString = function() {
          return this.$d.toISOString();
        }, m2.toString = function() {
          return this.$d.toUTCString();
        }, M2;
      }(), T = _.prototype;
      return w.prototype = T, [["$ms", r2], ["$s", i2], ["$m", s2], ["$H", u2], ["$W", a2], ["$M", f2], ["$y", c2], ["$D", d2]].forEach(function(t3) {
        T[t3[1]] = function(e3) {
          return this.$g(e3, t3[0], t3[1]);
        };
      }), w.extend = function(t3, e3) {
        return t3.$i || (t3(e3, _, w), t3.$i = true), w;
      }, w.locale = S, w.isDayjs = p2, w.unix = function(t3) {
        return w(1e3 * t3);
      }, w.en = D[g], w.Ls = D, w.p = {}, w;
    });
  })(dayjs_min$1, dayjs_min$1.exports);
  var dayjs_minExports = dayjs_min$1.exports;
  const dayjs = /* @__PURE__ */ getDefaultExportFromCjs$1(dayjs_minExports);
  var uaParser$2 = { exports: {} };
  var uaParser = uaParser$2.exports;
  (function(module, exports) {
    (function(window2, undefined$1) {
      "use strict";
      var LIBVERSION = "1.0.33", EMPTY = "", UNKNOWN = "?", FUNC_TYPE = "function", UNDEF_TYPE = "undefined", OBJ_TYPE = "object", STR_TYPE = "string", MAJOR = "major", MODEL = "model", NAME = "name", TYPE = "type", VENDOR = "vendor", VERSION = "version", ARCHITECTURE = "architecture", CONSOLE = "console", MOBILE = "mobile", TABLET = "tablet", SMARTTV = "smarttv", WEARABLE = "wearable", EMBEDDED = "embedded", UA_MAX_LENGTH = 350;
      var AMAZON = "Amazon", APPLE = "Apple", ASUS = "ASUS", BLACKBERRY = "BlackBerry", BROWSER = "Browser", CHROME = "Chrome", EDGE = "Edge", FIREFOX = "Firefox", GOOGLE = "Google", HUAWEI = "Huawei", LG = "LG", MICROSOFT = "Microsoft", MOTOROLA = "Motorola", OPERA = "Opera", SAMSUNG = "Samsung", SHARP = "Sharp", SONY = "Sony", XIAOMI = "Xiaomi", ZEBRA = "Zebra", FACEBOOK = "Facebook";
      var extend2 = function(regexes2, extensions) {
        var mergedRegexes = {};
        for (var i2 in regexes2) {
          if (extensions[i2] && extensions[i2].length % 2 === 0) {
            mergedRegexes[i2] = extensions[i2].concat(regexes2[i2]);
          } else {
            mergedRegexes[i2] = regexes2[i2];
          }
        }
        return mergedRegexes;
      }, enumerize = function(arr) {
        var enums = {};
        for (var i2 = 0; i2 < arr.length; i2++) {
          enums[arr[i2].toUpperCase()] = arr[i2];
        }
        return enums;
      }, has2 = function(str1, str2) {
        return typeof str1 === STR_TYPE ? lowerize(str2).indexOf(lowerize(str1)) !== -1 : false;
      }, lowerize = function(str) {
        return str.toLowerCase();
      }, majorize = function(version) {
        return typeof version === STR_TYPE ? version.replace(/[^\d\.]/g, EMPTY).split(".")[0] : undefined$1;
      }, trim = function(str, len2) {
        if (typeof str === STR_TYPE) {
          str = str.replace(/^\s\s*/, EMPTY);
          return typeof len2 === UNDEF_TYPE ? str : str.substring(0, UA_MAX_LENGTH);
        }
      };
      var rgxMapper = function(ua, arrays) {
        var i2 = 0, j, k, p2, q, matches, match;
        while (i2 < arrays.length && !matches) {
          var regex = arrays[i2], props = arrays[i2 + 1];
          j = k = 0;
          while (j < regex.length && !matches) {
            matches = regex[j++].exec(ua);
            if (!!matches) {
              for (p2 = 0; p2 < props.length; p2++) {
                match = matches[++k];
                q = props[p2];
                if (typeof q === OBJ_TYPE && q.length > 0) {
                  if (q.length === 2) {
                    if (typeof q[1] == FUNC_TYPE) {
                      this[q[0]] = q[1].call(this, match);
                    } else {
                      this[q[0]] = q[1];
                    }
                  } else if (q.length === 3) {
                    if (typeof q[1] === FUNC_TYPE && !(q[1].exec && q[1].test)) {
                      this[q[0]] = match ? q[1].call(this, match, q[2]) : undefined$1;
                    } else {
                      this[q[0]] = match ? match.replace(q[1], q[2]) : undefined$1;
                    }
                  } else if (q.length === 4) {
                    this[q[0]] = match ? q[3].call(this, match.replace(q[1], q[2])) : undefined$1;
                  }
                } else {
                  this[q] = match ? match : undefined$1;
                }
              }
            }
          }
          i2 += 2;
        }
      }, strMapper = function(str, map) {
        for (var i2 in map) {
          if (typeof map[i2] === OBJ_TYPE && map[i2].length > 0) {
            for (var j = 0; j < map[i2].length; j++) {
              if (has2(map[i2][j], str)) {
                return i2 === UNKNOWN ? undefined$1 : i2;
              }
            }
          } else if (has2(map[i2], str)) {
            return i2 === UNKNOWN ? undefined$1 : i2;
          }
        }
        return str;
      };
      var oldSafariMap = {
        "1.0": "/8",
        "1.2": "/1",
        "1.3": "/3",
        "2.0": "/412",
        "2.0.2": "/416",
        "2.0.3": "/417",
        "2.0.4": "/419",
        "?": "/"
      }, windowsVersionMap = {
        "ME": "4.90",
        "NT 3.11": "NT3.51",
        "NT 4.0": "NT4.0",
        "2000": "NT 5.0",
        "XP": ["NT 5.1", "NT 5.2"],
        "Vista": "NT 6.0",
        "7": "NT 6.1",
        "8": "NT 6.2",
        "8.1": "NT 6.3",
        "10": ["NT 6.4", "NT 10.0"],
        "RT": "ARM"
      };
      var regexes = {
        browser: [
          [
            /\b(?:crmo|crios)\/([\w\.]+)/i
            // Chrome for Android/iOS
          ],
          [VERSION, [NAME, "Chrome"]],
          [
            /edg(?:e|ios|a)?\/([\w\.]+)/i
            // Microsoft Edge
          ],
          [VERSION, [NAME, "Edge"]],
          [
            // Presto based
            /(opera mini)\/([-\w\.]+)/i,
            // Opera Mini
            /(opera [mobiletab]{3,6})\b.+version\/([-\w\.]+)/i,
            // Opera Mobi/Tablet
            /(opera)(?:.+version\/|[\/ ]+)([\w\.]+)/i
            // Opera
          ],
          [NAME, VERSION],
          [
            /opios[\/ ]+([\w\.]+)/i
            // Opera mini on iphone >= 8.0
          ],
          [VERSION, [NAME, OPERA + " Mini"]],
          [
            /\bopr\/([\w\.]+)/i
            // Opera Webkit
          ],
          [VERSION, [NAME, OPERA]],
          [
            // Mixed
            /(kindle)\/([\w\.]+)/i,
            // Kindle
            /(lunascape|maxthon|netfront|jasmine|blazer)[\/ ]?([\w\.]*)/i,
            // Lunascape/Maxthon/Netfront/Jasmine/Blazer
            // Trident based
            /(avant |iemobile|slim)(?:browser)?[\/ ]?([\w\.]*)/i,
            // Avant/IEMobile/SlimBrowser
            /(ba?idubrowser)[\/ ]?([\w\.]+)/i,
            // Baidu Browser
            /(?:ms|\()(ie) ([\w\.]+)/i,
            // Internet Explorer
            // Webkit/KHTML based                                               // Flock/RockMelt/Midori/Epiphany/Silk/Skyfire/Bolt/Iron/Iridium/PhantomJS/Bowser/QupZilla/Falkon
            /(flock|rockmelt|midori|epiphany|silk|skyfire|ovibrowser|bolt|iron|vivaldi|iridium|phantomjs|bowser|quark|qupzilla|falkon|rekonq|puffin|brave|whale|qqbrowserlite|qq|duckduckgo)\/([-\w\.]+)/i,
            // Rekonq/Puffin/Brave/Whale/QQBrowserLite/QQ, aka ShouQ
            /(weibo)__([\d\.]+)/i
            // Weibo
          ],
          [NAME, VERSION],
          [
            /(?:\buc? ?browser|(?:juc.+)ucweb)[\/ ]?([\w\.]+)/i
            // UCBrowser
          ],
          [VERSION, [NAME, "UC" + BROWSER]],
          [
            /microm.+\bqbcore\/([\w\.]+)/i,
            // WeChat Desktop for Windows Built-in Browser
            /\bqbcore\/([\w\.]+).+microm/i
          ],
          [VERSION, [NAME, "WeChat(Win) Desktop"]],
          [
            /micromessenger\/([\w\.]+)/i
            // WeChat
          ],
          [VERSION, [NAME, "WeChat"]],
          [
            /konqueror\/([\w\.]+)/i
            // Konqueror
          ],
          [VERSION, [NAME, "Konqueror"]],
          [
            /trident.+rv[: ]([\w\.]{1,9})\b.+like gecko/i
            // IE11
          ],
          [VERSION, [NAME, "IE"]],
          [
            /yabrowser\/([\w\.]+)/i
            // Yandex
          ],
          [VERSION, [NAME, "Yandex"]],
          [
            /(avast|avg)\/([\w\.]+)/i
            // Avast/AVG Secure Browser
          ],
          [[NAME, /(.+)/, "$1 Secure " + BROWSER], VERSION],
          [
            /\bfocus\/([\w\.]+)/i
            // Firefox Focus
          ],
          [VERSION, [NAME, FIREFOX + " Focus"]],
          [
            /\bopt\/([\w\.]+)/i
            // Opera Touch
          ],
          [VERSION, [NAME, OPERA + " Touch"]],
          [
            /coc_coc\w+\/([\w\.]+)/i
            // Coc Coc Browser
          ],
          [VERSION, [NAME, "Coc Coc"]],
          [
            /dolfin\/([\w\.]+)/i
            // Dolphin
          ],
          [VERSION, [NAME, "Dolphin"]],
          [
            /coast\/([\w\.]+)/i
            // Opera Coast
          ],
          [VERSION, [NAME, OPERA + " Coast"]],
          [
            /miuibrowser\/([\w\.]+)/i
            // MIUI Browser
          ],
          [VERSION, [NAME, "MIUI " + BROWSER]],
          [
            /fxios\/([-\w\.]+)/i
            // Firefox for iOS
          ],
          [VERSION, [NAME, FIREFOX]],
          [
            /\bqihu|(qi?ho?o?|360)browser/i
            // 360
          ],
          [[NAME, "360 " + BROWSER]],
          [
            /(oculus|samsung|sailfish|huawei)browser\/([\w\.]+)/i
          ],
          [[NAME, /(.+)/, "$1 " + BROWSER], VERSION],
          [
            // Oculus/Samsung/Sailfish/Huawei Browser
            /(comodo_dragon)\/([\w\.]+)/i
            // Comodo Dragon
          ],
          [[NAME, /_/g, " "], VERSION],
          [
            /(electron)\/([\w\.]+) safari/i,
            // Electron-based App
            /(tesla)(?: qtcarbrowser|\/(20\d\d\.[-\w\.]+))/i,
            // Tesla
            /m?(qqbrowser|baiduboxapp|2345Explorer)[\/ ]?([\w\.]+)/i
            // QQBrowser/Baidu App/2345 Browser
          ],
          [NAME, VERSION],
          [
            /(metasr)[\/ ]?([\w\.]+)/i,
            // SouGouBrowser
            /(lbbrowser)/i,
            // LieBao Browser
            /\[(linkedin)app\]/i
            // LinkedIn App for iOS & Android
          ],
          [NAME],
          [
            // WebView
            /((?:fban\/fbios|fb_iab\/fb4a)(?!.+fbav)|;fbav\/([\w\.]+);)/i
            // Facebook App for iOS & Android
          ],
          [[NAME, FACEBOOK], VERSION],
          [
            /safari (line)\/([\w\.]+)/i,
            // Line App for iOS
            /\b(line)\/([\w\.]+)\/iab/i,
            // Line App for Android
            /(chromium|instagram)[\/ ]([-\w\.]+)/i
            // Chromium/Instagram
          ],
          [NAME, VERSION],
          [
            /\bgsa\/([\w\.]+) .*safari\//i
            // Google Search Appliance on iOS
          ],
          [VERSION, [NAME, "GSA"]],
          [
            /headlesschrome(?:\/([\w\.]+)| )/i
            // Chrome Headless
          ],
          [VERSION, [NAME, CHROME + " Headless"]],
          [
            / wv\).+(chrome)\/([\w\.]+)/i
            // Chrome WebView
          ],
          [[NAME, CHROME + " WebView"], VERSION],
          [
            /droid.+ version\/([\w\.]+)\b.+(?:mobile safari|safari)/i
            // Android Browser
          ],
          [VERSION, [NAME, "Android " + BROWSER]],
          [
            /(chrome|omniweb|arora|[tizenoka]{5} ?browser)\/v?([\w\.]+)/i
            // Chrome/OmniWeb/Arora/Tizen/Nokia
          ],
          [NAME, VERSION],
          [
            /version\/([\w\.\,]+) .*mobile\/\w+ (safari)/i
            // Mobile Safari
          ],
          [VERSION, [NAME, "Mobile Safari"]],
          [
            /version\/([\w(\.|\,)]+) .*(mobile ?safari|safari)/i
            // Safari & Safari Mobile
          ],
          [VERSION, NAME],
          [
            /webkit.+?(mobile ?safari|safari)(\/[\w\.]+)/i
            // Safari < 3.0
          ],
          [NAME, [VERSION, strMapper, oldSafariMap]],
          [
            /(webkit|khtml)\/([\w\.]+)/i
          ],
          [NAME, VERSION],
          [
            // Gecko based
            /(navigator|netscape\d?)\/([-\w\.]+)/i
            // Netscape
          ],
          [[NAME, "Netscape"], VERSION],
          [
            /mobile vr; rv:([\w\.]+)\).+firefox/i
            // Firefox Reality
          ],
          [VERSION, [NAME, FIREFOX + " Reality"]],
          [
            /ekiohf.+(flow)\/([\w\.]+)/i,
            // Flow
            /(swiftfox)/i,
            // Swiftfox
            /(icedragon|iceweasel|camino|chimera|fennec|maemo browser|minimo|conkeror|klar)[\/ ]?([\w\.\+]+)/i,
            // IceDragon/Iceweasel/Camino/Chimera/Fennec/Maemo/Minimo/Conkeror/Klar
            /(seamonkey|k-meleon|icecat|iceape|firebird|phoenix|palemoon|basilisk|waterfox)\/([-\w\.]+)$/i,
            // Firefox/SeaMonkey/K-Meleon/IceCat/IceApe/Firebird/Phoenix
            /(firefox)\/([\w\.]+)/i,
            // Other Firefox-based
            /(mozilla)\/([\w\.]+) .+rv\:.+gecko\/\d+/i,
            // Mozilla
            // Other
            /(polaris|lynx|dillo|icab|doris|amaya|w3m|netsurf|sleipnir|obigo|mosaic|(?:go|ice|up)[\. ]?browser)[-\/ ]?v?([\w\.]+)/i,
            // Polaris/Lynx/Dillo/iCab/Doris/Amaya/w3m/NetSurf/Sleipnir/Obigo/Mosaic/Go/ICE/UP.Browser
            /(links) \(([\w\.]+)/i
            // Links
          ],
          [NAME, VERSION],
          [
            /(cobalt)\/([\w\.]+)/i
            // Cobalt
          ],
          [NAME, [VERSION, /master.|lts./, ""]]
        ],
        cpu: [
          [
            /(?:(amd|x(?:(?:86|64)[-_])?|wow|win)64)[;\)]/i
            // AMD64 (x64)
          ],
          [[ARCHITECTURE, "amd64"]],
          [
            /(ia32(?=;))/i
            // IA32 (quicktime)
          ],
          [[ARCHITECTURE, lowerize]],
          [
            /((?:i[346]|x)86)[;\)]/i
            // IA32 (x86)
          ],
          [[ARCHITECTURE, "ia32"]],
          [
            /\b(aarch64|arm(v?8e?l?|_?64))\b/i
            // ARM64
          ],
          [[ARCHITECTURE, "arm64"]],
          [
            /\b(arm(?:v[67])?ht?n?[fl]p?)\b/i
            // ARMHF
          ],
          [[ARCHITECTURE, "armhf"]],
          [
            // PocketPC mistakenly identified as PowerPC
            /windows (ce|mobile); ppc;/i
          ],
          [[ARCHITECTURE, "arm"]],
          [
            /((?:ppc|powerpc)(?:64)?)(?: mac|;|\))/i
            // PowerPC
          ],
          [[ARCHITECTURE, /ower/, EMPTY, lowerize]],
          [
            /(sun4\w)[;\)]/i
            // SPARC
          ],
          [[ARCHITECTURE, "sparc"]],
          [
            /((?:avr32|ia64(?=;))|68k(?=\))|\barm(?=v(?:[1-7]|[5-7]1)l?|;|eabi)|(?=atmel )avr|(?:irix|mips|sparc)(?:64)?\b|pa-risc)/i
            // IA64, 68K, ARM/64, AVR/32, IRIX/64, MIPS/64, SPARC/64, PA-RISC
          ],
          [[ARCHITECTURE, lowerize]]
        ],
        device: [
          [
            //////////////////////////
            // MOBILES & TABLETS
            // Ordered by popularity
            /////////////////////////
            // Samsung
            /\b(sch-i[89]0\d|shw-m380s|sm-[ptx]\w{2,4}|gt-[pn]\d{2,4}|sgh-t8[56]9|nexus 10)/i
          ],
          [MODEL, [VENDOR, SAMSUNG], [TYPE, TABLET]],
          [
            /\b((?:s[cgp]h|gt|sm)-\w+|galaxy nexus)/i,
            /samsung[- ]([-\w]+)/i,
            /sec-(sgh\w+)/i
          ],
          [MODEL, [VENDOR, SAMSUNG], [TYPE, MOBILE]],
          [
            // Apple
            /\((ip(?:hone|od)[\w ]*);/i
            // iPod/iPhone
          ],
          [MODEL, [VENDOR, APPLE], [TYPE, MOBILE]],
          [
            /\((ipad);[-\w\),; ]+apple/i,
            // iPad
            /applecoremedia\/[\w\.]+ \((ipad)/i,
            /\b(ipad)\d\d?,\d\d?[;\]].+ios/i
          ],
          [MODEL, [VENDOR, APPLE], [TYPE, TABLET]],
          [
            /(macintosh);/i
          ],
          [MODEL, [VENDOR, APPLE]],
          [
            // Huawei
            /\b((?:ag[rs][23]?|bah2?|sht?|btv)-a?[lw]\d{2})\b(?!.+d\/s)/i
          ],
          [MODEL, [VENDOR, HUAWEI], [TYPE, TABLET]],
          [
            /(?:huawei|honor)([-\w ]+)[;\)]/i,
            /\b(nexus 6p|\w{2,4}e?-[atu]?[ln][\dx][012359c][adn]?)\b(?!.+d\/s)/i
          ],
          [MODEL, [VENDOR, HUAWEI], [TYPE, MOBILE]],
          [
            // Xiaomi
            /\b(poco[\w ]+)(?: bui|\))/i,
            // Xiaomi POCO
            /\b; (\w+) build\/hm\1/i,
            // Xiaomi Hongmi 'numeric' models
            /\b(hm[-_ ]?note?[_ ]?(?:\d\w)?) bui/i,
            // Xiaomi Hongmi
            /\b(redmi[\-_ ]?(?:note|k)?[\w_ ]+)(?: bui|\))/i,
            // Xiaomi Redmi
            /\b(mi[-_ ]?(?:a\d|one|one[_ ]plus|note lte|max|cc)?[_ ]?(?:\d?\w?)[_ ]?(?:plus|se|lite)?)(?: bui|\))/i
            // Xiaomi Mi
          ],
          [[MODEL, /_/g, " "], [VENDOR, XIAOMI], [TYPE, MOBILE]],
          [
            /\b(mi[-_ ]?(?:pad)(?:[\w_ ]+))(?: bui|\))/i
            // Mi Pad tablets
          ],
          [[MODEL, /_/g, " "], [VENDOR, XIAOMI], [TYPE, TABLET]],
          [
            // OPPO
            /; (\w+) bui.+ oppo/i,
            /\b(cph[12]\d{3}|p(?:af|c[al]|d\w|e[ar])[mt]\d0|x9007|a101op)\b/i
          ],
          [MODEL, [VENDOR, "OPPO"], [TYPE, MOBILE]],
          [
            // Vivo
            /vivo (\w+)(?: bui|\))/i,
            /\b(v[12]\d{3}\w?[at])(?: bui|;)/i
          ],
          [MODEL, [VENDOR, "Vivo"], [TYPE, MOBILE]],
          [
            // Realme
            /\b(rmx[12]\d{3})(?: bui|;|\))/i
          ],
          [MODEL, [VENDOR, "Realme"], [TYPE, MOBILE]],
          [
            // Motorola
            /\b(milestone|droid(?:[2-4x]| (?:bionic|x2|pro|razr))?:?( 4g)?)\b[\w ]+build\//i,
            /\bmot(?:orola)?[- ](\w*)/i,
            /((?:moto[\w\(\) ]+|xt\d{3,4}|nexus 6)(?= bui|\)))/i
          ],
          [MODEL, [VENDOR, MOTOROLA], [TYPE, MOBILE]],
          [
            /\b(mz60\d|xoom[2 ]{0,2}) build\//i
          ],
          [MODEL, [VENDOR, MOTOROLA], [TYPE, TABLET]],
          [
            // LG
            /((?=lg)?[vl]k\-?\d{3}) bui| 3\.[-\w; ]{10}lg?-([06cv9]{3,4})/i
          ],
          [MODEL, [VENDOR, LG], [TYPE, TABLET]],
          [
            /(lm(?:-?f100[nv]?|-[\w\.]+)(?= bui|\))|nexus [45])/i,
            /\blg[-e;\/ ]+((?!browser|netcast|android tv)\w+)/i,
            /\blg-?([\d\w]+) bui/i
          ],
          [MODEL, [VENDOR, LG], [TYPE, MOBILE]],
          [
            // Lenovo
            /(ideatab[-\w ]+)/i,
            /lenovo ?(s[56]000[-\w]+|tab(?:[\w ]+)|yt[-\d\w]{6}|tb[-\d\w]{6})/i
          ],
          [MODEL, [VENDOR, "Lenovo"], [TYPE, TABLET]],
          [
            // Nokia
            /(?:maemo|nokia).*(n900|lumia \d+)/i,
            /nokia[-_ ]?([-\w\.]*)/i
          ],
          [[MODEL, /_/g, " "], [VENDOR, "Nokia"], [TYPE, MOBILE]],
          [
            // Google
            /(pixel c)\b/i
            // Google Pixel C
          ],
          [MODEL, [VENDOR, GOOGLE], [TYPE, TABLET]],
          [
            /droid.+; (pixel[\daxl ]{0,6})(?: bui|\))/i
            // Google Pixel
          ],
          [MODEL, [VENDOR, GOOGLE], [TYPE, MOBILE]],
          [
            // Sony
            /droid.+ (a?\d[0-2]{2}so|[c-g]\d{4}|so[-gl]\w+|xq-a\w[4-7][12])(?= bui|\).+chrome\/(?![1-6]{0,1}\d\.))/i
          ],
          [MODEL, [VENDOR, SONY], [TYPE, MOBILE]],
          [
            /sony tablet [ps]/i,
            /\b(?:sony)?sgp\w+(?: bui|\))/i
          ],
          [[MODEL, "Xperia Tablet"], [VENDOR, SONY], [TYPE, TABLET]],
          [
            // OnePlus
            / (kb2005|in20[12]5|be20[12][59])\b/i,
            /(?:one)?(?:plus)? (a\d0\d\d)(?: b|\))/i
          ],
          [MODEL, [VENDOR, "OnePlus"], [TYPE, MOBILE]],
          [
            // Amazon
            /(alexa)webm/i,
            /(kf[a-z]{2}wi)( bui|\))/i,
            // Kindle Fire without Silk
            /(kf[a-z]+)( bui|\)).+silk\//i
            // Kindle Fire HD
          ],
          [MODEL, [VENDOR, AMAZON], [TYPE, TABLET]],
          [
            /((?:sd|kf)[0349hijorstuw]+)( bui|\)).+silk\//i
            // Fire Phone
          ],
          [[MODEL, /(.+)/g, "Fire Phone $1"], [VENDOR, AMAZON], [TYPE, MOBILE]],
          [
            // BlackBerry
            /(playbook);[-\w\),; ]+(rim)/i
            // BlackBerry PlayBook
          ],
          [MODEL, VENDOR, [TYPE, TABLET]],
          [
            /\b((?:bb[a-f]|st[hv])100-\d)/i,
            /\(bb10; (\w+)/i
            // BlackBerry 10
          ],
          [MODEL, [VENDOR, BLACKBERRY], [TYPE, MOBILE]],
          [
            // Asus
            /(?:\b|asus_)(transfo[prime ]{4,10} \w+|eeepc|slider \w+|nexus 7|padfone|p00[cj])/i
          ],
          [MODEL, [VENDOR, ASUS], [TYPE, TABLET]],
          [
            / (z[bes]6[027][012][km][ls]|zenfone \d\w?)\b/i
          ],
          [MODEL, [VENDOR, ASUS], [TYPE, MOBILE]],
          [
            // HTC
            /(nexus 9)/i
            // HTC Nexus 9
          ],
          [MODEL, [VENDOR, "HTC"], [TYPE, TABLET]],
          [
            /(htc)[-;_ ]{1,2}([\w ]+(?=\)| bui)|\w+)/i,
            // HTC
            // ZTE
            /(zte)[- ]([\w ]+?)(?: bui|\/|\))/i,
            /(alcatel|geeksphone|nexian|panasonic|sony(?!-bra))[-_ ]?([-\w]*)/i
            // Alcatel/GeeksPhone/Nexian/Panasonic/Sony
          ],
          [VENDOR, [MODEL, /_/g, " "], [TYPE, MOBILE]],
          [
            // Acer
            /droid.+; ([ab][1-7]-?[0178a]\d\d?)/i
          ],
          [MODEL, [VENDOR, "Acer"], [TYPE, TABLET]],
          [
            // Meizu
            /droid.+; (m[1-5] note) bui/i,
            /\bmz-([-\w]{2,})/i
          ],
          [MODEL, [VENDOR, "Meizu"], [TYPE, MOBILE]],
          [
            // Sharp
            /\b(sh-?[altvz]?\d\d[a-ekm]?)/i
          ],
          [MODEL, [VENDOR, SHARP], [TYPE, MOBILE]],
          [
            // MIXED
            /(blackberry|benq|palm(?=\-)|sonyericsson|acer|asus|dell|meizu|motorola|polytron)[-_ ]?([-\w]*)/i,
            // BlackBerry/BenQ/Palm/Sony-Ericsson/Acer/Asus/Dell/Meizu/Motorola/Polytron
            /(hp) ([\w ]+\w)/i,
            // HP iPAQ
            /(asus)-?(\w+)/i,
            // Asus
            /(microsoft); (lumia[\w ]+)/i,
            // Microsoft Lumia
            /(lenovo)[-_ ]?([-\w]+)/i,
            // Lenovo
            /(jolla)/i,
            // Jolla
            /(oppo) ?([\w ]+) bui/i
            // OPPO
          ],
          [VENDOR, MODEL, [TYPE, MOBILE]],
          [
            /(archos) (gamepad2?)/i,
            // Archos
            /(hp).+(touchpad(?!.+tablet)|tablet)/i,
            // HP TouchPad
            /(kindle)\/([\w\.]+)/i,
            // Kindle
            /(nook)[\w ]+build\/(\w+)/i,
            // Nook
            /(dell) (strea[kpr\d ]*[\dko])/i,
            // Dell Streak
            /(le[- ]+pan)[- ]+(\w{1,9}) bui/i,
            // Le Pan Tablets
            /(trinity)[- ]*(t\d{3}) bui/i,
            // Trinity Tablets
            /(gigaset)[- ]+(q\w{1,9}) bui/i,
            // Gigaset Tablets
            /(vodafone) ([\w ]+)(?:\)| bui)/i
            // Vodafone
          ],
          [VENDOR, MODEL, [TYPE, TABLET]],
          [
            /(surface duo)/i
            // Surface Duo
          ],
          [MODEL, [VENDOR, MICROSOFT], [TYPE, TABLET]],
          [
            /droid [\d\.]+; (fp\du?)(?: b|\))/i
            // Fairphone
          ],
          [MODEL, [VENDOR, "Fairphone"], [TYPE, MOBILE]],
          [
            /(u304aa)/i
            // AT&T
          ],
          [MODEL, [VENDOR, "AT&T"], [TYPE, MOBILE]],
          [
            /\bsie-(\w*)/i
            // Siemens
          ],
          [MODEL, [VENDOR, "Siemens"], [TYPE, MOBILE]],
          [
            /\b(rct\w+) b/i
            // RCA Tablets
          ],
          [MODEL, [VENDOR, "RCA"], [TYPE, TABLET]],
          [
            /\b(venue[\d ]{2,7}) b/i
            // Dell Venue Tablets
          ],
          [MODEL, [VENDOR, "Dell"], [TYPE, TABLET]],
          [
            /\b(q(?:mv|ta)\w+) b/i
            // Verizon Tablet
          ],
          [MODEL, [VENDOR, "Verizon"], [TYPE, TABLET]],
          [
            /\b(?:barnes[& ]+noble |bn[rt])([\w\+ ]*) b/i
            // Barnes & Noble Tablet
          ],
          [MODEL, [VENDOR, "Barnes & Noble"], [TYPE, TABLET]],
          [
            /\b(tm\d{3}\w+) b/i
          ],
          [MODEL, [VENDOR, "NuVision"], [TYPE, TABLET]],
          [
            /\b(k88) b/i
            // ZTE K Series Tablet
          ],
          [MODEL, [VENDOR, "ZTE"], [TYPE, TABLET]],
          [
            /\b(nx\d{3}j) b/i
            // ZTE Nubia
          ],
          [MODEL, [VENDOR, "ZTE"], [TYPE, MOBILE]],
          [
            /\b(gen\d{3}) b.+49h/i
            // Swiss GEN Mobile
          ],
          [MODEL, [VENDOR, "Swiss"], [TYPE, MOBILE]],
          [
            /\b(zur\d{3}) b/i
            // Swiss ZUR Tablet
          ],
          [MODEL, [VENDOR, "Swiss"], [TYPE, TABLET]],
          [
            /\b((zeki)?tb.*\b) b/i
            // Zeki Tablets
          ],
          [MODEL, [VENDOR, "Zeki"], [TYPE, TABLET]],
          [
            /\b([yr]\d{2}) b/i,
            /\b(dragon[- ]+touch |dt)(\w{5}) b/i
            // Dragon Touch Tablet
          ],
          [[VENDOR, "Dragon Touch"], MODEL, [TYPE, TABLET]],
          [
            /\b(ns-?\w{0,9}) b/i
            // Insignia Tablets
          ],
          [MODEL, [VENDOR, "Insignia"], [TYPE, TABLET]],
          [
            /\b((nxa|next)-?\w{0,9}) b/i
            // NextBook Tablets
          ],
          [MODEL, [VENDOR, "NextBook"], [TYPE, TABLET]],
          [
            /\b(xtreme\_)?(v(1[045]|2[015]|[3469]0|7[05])) b/i
            // Voice Xtreme Phones
          ],
          [[VENDOR, "Voice"], MODEL, [TYPE, MOBILE]],
          [
            /\b(lvtel\-)?(v1[12]) b/i
            // LvTel Phones
          ],
          [[VENDOR, "LvTel"], MODEL, [TYPE, MOBILE]],
          [
            /\b(ph-1) /i
            // Essential PH-1
          ],
          [MODEL, [VENDOR, "Essential"], [TYPE, MOBILE]],
          [
            /\b(v(100md|700na|7011|917g).*\b) b/i
            // Envizen Tablets
          ],
          [MODEL, [VENDOR, "Envizen"], [TYPE, TABLET]],
          [
            /\b(trio[-\w\. ]+) b/i
            // MachSpeed Tablets
          ],
          [MODEL, [VENDOR, "MachSpeed"], [TYPE, TABLET]],
          [
            /\btu_(1491) b/i
            // Rotor Tablets
          ],
          [MODEL, [VENDOR, "Rotor"], [TYPE, TABLET]],
          [
            /(shield[\w ]+) b/i
            // Nvidia Shield Tablets
          ],
          [MODEL, [VENDOR, "Nvidia"], [TYPE, TABLET]],
          [
            /(sprint) (\w+)/i
            // Sprint Phones
          ],
          [VENDOR, MODEL, [TYPE, MOBILE]],
          [
            /(kin\.[onetw]{3})/i
            // Microsoft Kin
          ],
          [[MODEL, /\./g, " "], [VENDOR, MICROSOFT], [TYPE, MOBILE]],
          [
            /droid.+; (cc6666?|et5[16]|mc[239][23]x?|vc8[03]x?)\)/i
            // Zebra
          ],
          [MODEL, [VENDOR, ZEBRA], [TYPE, TABLET]],
          [
            /droid.+; (ec30|ps20|tc[2-8]\d[kx])\)/i
          ],
          [MODEL, [VENDOR, ZEBRA], [TYPE, MOBILE]],
          [
            ///////////////////
            // CONSOLES
            ///////////////////
            /(ouya)/i,
            // Ouya
            /(nintendo) ([wids3utch]+)/i
            // Nintendo
          ],
          [VENDOR, MODEL, [TYPE, CONSOLE]],
          [
            /droid.+; (shield) bui/i
            // Nvidia
          ],
          [MODEL, [VENDOR, "Nvidia"], [TYPE, CONSOLE]],
          [
            /(playstation [345portablevi]+)/i
            // Playstation
          ],
          [MODEL, [VENDOR, SONY], [TYPE, CONSOLE]],
          [
            /\b(xbox(?: one)?(?!; xbox))[\); ]/i
            // Microsoft Xbox
          ],
          [MODEL, [VENDOR, MICROSOFT], [TYPE, CONSOLE]],
          [
            ///////////////////
            // SMARTTVS
            ///////////////////
            /smart-tv.+(samsung)/i
            // Samsung
          ],
          [VENDOR, [TYPE, SMARTTV]],
          [
            /hbbtv.+maple;(\d+)/i
          ],
          [[MODEL, /^/, "SmartTV"], [VENDOR, SAMSUNG], [TYPE, SMARTTV]],
          [
            /(nux; netcast.+smarttv|lg (netcast\.tv-201\d|android tv))/i
            // LG SmartTV
          ],
          [[VENDOR, LG], [TYPE, SMARTTV]],
          [
            /(apple) ?tv/i
            // Apple TV
          ],
          [VENDOR, [MODEL, APPLE + " TV"], [TYPE, SMARTTV]],
          [
            /crkey/i
            // Google Chromecast
          ],
          [[MODEL, CHROME + "cast"], [VENDOR, GOOGLE], [TYPE, SMARTTV]],
          [
            /droid.+aft(\w)( bui|\))/i
            // Fire TV
          ],
          [MODEL, [VENDOR, AMAZON], [TYPE, SMARTTV]],
          [
            /\(dtv[\);].+(aquos)/i,
            /(aquos-tv[\w ]+)\)/i
            // Sharp
          ],
          [MODEL, [VENDOR, SHARP], [TYPE, SMARTTV]],
          [
            /(bravia[\w ]+)( bui|\))/i
            // Sony
          ],
          [MODEL, [VENDOR, SONY], [TYPE, SMARTTV]],
          [
            /(mitv-\w{5}) bui/i
            // Xiaomi
          ],
          [MODEL, [VENDOR, XIAOMI], [TYPE, SMARTTV]],
          [
            /\b(roku)[\dx]*[\)\/]((?:dvp-)?[\d\.]*)/i,
            // Roku
            /hbbtv\/\d+\.\d+\.\d+ +\([\w ]*; *(\w[^;]*);([^;]*)/i
            // HbbTV devices
          ],
          [[VENDOR, trim], [MODEL, trim], [TYPE, SMARTTV]],
          [
            /\b(android tv|smart[- ]?tv|opera tv|tv; rv:)\b/i
            // SmartTV from Unidentified Vendors
          ],
          [[TYPE, SMARTTV]],
          [
            ///////////////////
            // WEARABLES
            ///////////////////
            /((pebble))app/i
            // Pebble
          ],
          [VENDOR, MODEL, [TYPE, WEARABLE]],
          [
            /droid.+; (glass) \d/i
            // Google Glass
          ],
          [MODEL, [VENDOR, GOOGLE], [TYPE, WEARABLE]],
          [
            /droid.+; (wt63?0{2,3})\)/i
          ],
          [MODEL, [VENDOR, ZEBRA], [TYPE, WEARABLE]],
          [
            /(quest( 2)?)/i
            // Oculus Quest
          ],
          [MODEL, [VENDOR, FACEBOOK], [TYPE, WEARABLE]],
          [
            ///////////////////
            // EMBEDDED
            ///////////////////
            /(tesla)(?: qtcarbrowser|\/[-\w\.]+)/i
            // Tesla
          ],
          [VENDOR, [TYPE, EMBEDDED]],
          [
            ////////////////////
            // MIXED (GENERIC)
            ///////////////////
            /droid .+?; ([^;]+?)(?: bui|\) applew).+? mobile safari/i
            // Android Phones from Unidentified Vendors
          ],
          [MODEL, [TYPE, MOBILE]],
          [
            /droid .+?; ([^;]+?)(?: bui|\) applew).+?(?! mobile) safari/i
            // Android Tablets from Unidentified Vendors
          ],
          [MODEL, [TYPE, TABLET]],
          [
            /\b((tablet|tab)[;\/]|focus\/\d(?!.+mobile))/i
            // Unidentifiable Tablet
          ],
          [[TYPE, TABLET]],
          [
            /(phone|mobile(?:[;\/]| [ \w\/\.]*safari)|pda(?=.+windows ce))/i
            // Unidentifiable Mobile
          ],
          [[TYPE, MOBILE]],
          [
            /(android[-\w\. ]{0,9});.+buil/i
            // Generic Android Device
          ],
          [MODEL, [VENDOR, "Generic"]]
        ],
        engine: [
          [
            /windows.+ edge\/([\w\.]+)/i
            // EdgeHTML
          ],
          [VERSION, [NAME, EDGE + "HTML"]],
          [
            /webkit\/537\.36.+chrome\/(?!27)([\w\.]+)/i
            // Blink
          ],
          [VERSION, [NAME, "Blink"]],
          [
            /(presto)\/([\w\.]+)/i,
            // Presto
            /(webkit|trident|netfront|netsurf|amaya|lynx|w3m|goanna)\/([\w\.]+)/i,
            // WebKit/Trident/NetFront/NetSurf/Amaya/Lynx/w3m/Goanna
            /ekioh(flow)\/([\w\.]+)/i,
            // Flow
            /(khtml|tasman|links)[\/ ]\(?([\w\.]+)/i,
            // KHTML/Tasman/Links
            /(icab)[\/ ]([23]\.[\d\.]+)/i
            // iCab
          ],
          [NAME, VERSION],
          [
            /rv\:([\w\.]{1,9})\b.+(gecko)/i
            // Gecko
          ],
          [VERSION, NAME]
        ],
        os: [
          [
            // Windows
            /microsoft (windows) (vista|xp)/i
            // Windows (iTunes)
          ],
          [NAME, VERSION],
          [
            /(windows) nt 6\.2; (arm)/i,
            // Windows RT
            /(windows (?:phone(?: os)?|mobile))[\/ ]?([\d\.\w ]*)/i,
            // Windows Phone
            /(windows)[\/ ]?([ntce\d\. ]+\w)(?!.+xbox)/i
          ],
          [NAME, [VERSION, strMapper, windowsVersionMap]],
          [
            /(win(?=3|9|n)|win 9x )([nt\d\.]+)/i
          ],
          [[NAME, "Windows"], [VERSION, strMapper, windowsVersionMap]],
          [
            // iOS/macOS
            /ip[honead]{2,4}\b(?:.*os ([\w]+) like mac|; opera)/i,
            // iOS
            /cfnetwork\/.+darwin/i
          ],
          [[VERSION, /_/g, "."], [NAME, "iOS"]],
          [
            /(mac os x) ?([\w\. ]*)/i,
            /(macintosh|mac_powerpc\b)(?!.+haiku)/i
            // Mac OS
          ],
          [[NAME, "Mac OS"], [VERSION, /_/g, "."]],
          [
            // Mobile OSes
            /droid ([\w\.]+)\b.+(android[- ]x86|harmonyos)/i
            // Android-x86/HarmonyOS
          ],
          [VERSION, NAME],
          [
            // Android/WebOS/QNX/Bada/RIM/Maemo/MeeGo/Sailfish OS
            /(android|webos|qnx|bada|rim tablet os|maemo|meego|sailfish)[-\/ ]?([\w\.]*)/i,
            /(blackberry)\w*\/([\w\.]*)/i,
            // Blackberry
            /(tizen|kaios)[\/ ]([\w\.]+)/i,
            // Tizen/KaiOS
            /\((series40);/i
            // Series 40
          ],
          [NAME, VERSION],
          [
            /\(bb(10);/i
            // BlackBerry 10
          ],
          [VERSION, [NAME, BLACKBERRY]],
          [
            /(?:symbian ?os|symbos|s60(?=;)|series60)[-\/ ]?([\w\.]*)/i
            // Symbian
          ],
          [VERSION, [NAME, "Symbian"]],
          [
            /mozilla\/[\d\.]+ \((?:mobile|tablet|tv|mobile; [\w ]+); rv:.+ gecko\/([\w\.]+)/i
            // Firefox OS
          ],
          [VERSION, [NAME, FIREFOX + " OS"]],
          [
            /web0s;.+rt(tv)/i,
            /\b(?:hp)?wos(?:browser)?\/([\w\.]+)/i
            // WebOS
          ],
          [VERSION, [NAME, "webOS"]],
          [
            // Google Chromecast
            /crkey\/([\d\.]+)/i
            // Google Chromecast
          ],
          [VERSION, [NAME, CHROME + "cast"]],
          [
            /(cros) [\w]+ ([\w\.]+\w)/i
            // Chromium OS
          ],
          [[NAME, "Chromium OS"], VERSION],
          [
            // Console
            /(nintendo|playstation) ([wids345portablevuch]+)/i,
            // Nintendo/Playstation
            /(xbox); +xbox ([^\);]+)/i,
            // Microsoft Xbox (360, One, X, S, Series X, Series S)
            // Other
            /\b(joli|palm)\b ?(?:os)?\/?([\w\.]*)/i,
            // Joli/Palm
            /(mint)[\/\(\) ]?(\w*)/i,
            // Mint
            /(mageia|vectorlinux)[; ]/i,
            // Mageia/VectorLinux
            /([kxln]?ubuntu|debian|suse|opensuse|gentoo|arch(?= linux)|slackware|fedora|mandriva|centos|pclinuxos|red ?hat|zenwalk|linpus|raspbian|plan 9|minix|risc os|contiki|deepin|manjaro|elementary os|sabayon|linspire)(?: gnu\/linux)?(?: enterprise)?(?:[- ]linux)?(?:-gnu)?[-\/ ]?(?!chrom|package)([-\w\.]*)/i,
            // Ubuntu/Debian/SUSE/Gentoo/Arch/Slackware/Fedora/Mandriva/CentOS/PCLinuxOS/RedHat/Zenwalk/Linpus/Raspbian/Plan9/Minix/RISCOS/Contiki/Deepin/Manjaro/elementary/Sabayon/Linspire
            /(hurd|linux) ?([\w\.]*)/i,
            // Hurd/Linux
            /(gnu) ?([\w\.]*)/i,
            // GNU
            /\b([-frentopcghs]{0,5}bsd|dragonfly)[\/ ]?(?!amd|[ix346]{1,2}86)([\w\.]*)/i,
            // FreeBSD/NetBSD/OpenBSD/PC-BSD/GhostBSD/DragonFly
            /(haiku) (\w+)/i
            // Haiku
          ],
          [NAME, VERSION],
          [
            /(sunos) ?([\w\.\d]*)/i
            // Solaris
          ],
          [[NAME, "Solaris"], VERSION],
          [
            /((?:open)?solaris)[-\/ ]?([\w\.]*)/i,
            // Solaris
            /(aix) ((\d)(?=\.|\)| )[\w\.])*/i,
            // AIX
            /\b(beos|os\/2|amigaos|morphos|openvms|fuchsia|hp-ux)/i,
            // BeOS/OS2/AmigaOS/MorphOS/OpenVMS/Fuchsia/HP-UX
            /(unix) ?([\w\.]*)/i
            // UNIX
          ],
          [NAME, VERSION]
        ]
      };
      var UAParser = function(ua, extensions) {
        if (typeof ua === OBJ_TYPE) {
          extensions = ua;
          ua = undefined$1;
        }
        if (!(this instanceof UAParser)) {
          return new UAParser(ua, extensions).getResult();
        }
        var _ua = ua || (typeof window2 !== UNDEF_TYPE && window2.navigator && window2.navigator.userAgent ? window2.navigator.userAgent : EMPTY);
        var _rgxmap = extensions ? extend2(regexes, extensions) : regexes;
        this.getBrowser = function() {
          var _browser = {};
          _browser[NAME] = undefined$1;
          _browser[VERSION] = undefined$1;
          rgxMapper.call(_browser, _ua, _rgxmap.browser);
          _browser.major = majorize(_browser.version);
          return _browser;
        };
        this.getCPU = function() {
          var _cpu = {};
          _cpu[ARCHITECTURE] = undefined$1;
          rgxMapper.call(_cpu, _ua, _rgxmap.cpu);
          return _cpu;
        };
        this.getDevice = function() {
          var _device = {};
          _device[VENDOR] = undefined$1;
          _device[MODEL] = undefined$1;
          _device[TYPE] = undefined$1;
          rgxMapper.call(_device, _ua, _rgxmap.device);
          return _device;
        };
        this.getEngine = function() {
          var _engine = {};
          _engine[NAME] = undefined$1;
          _engine[VERSION] = undefined$1;
          rgxMapper.call(_engine, _ua, _rgxmap.engine);
          return _engine;
        };
        this.getOS = function() {
          var _os = {};
          _os[NAME] = undefined$1;
          _os[VERSION] = undefined$1;
          rgxMapper.call(_os, _ua, _rgxmap.os);
          return _os;
        };
        this.getResult = function() {
          return {
            ua: this.getUA(),
            browser: this.getBrowser(),
            engine: this.getEngine(),
            os: this.getOS(),
            device: this.getDevice(),
            cpu: this.getCPU()
          };
        };
        this.getUA = function() {
          return _ua;
        };
        this.setUA = function(ua2) {
          _ua = typeof ua2 === STR_TYPE && ua2.length > UA_MAX_LENGTH ? trim(ua2, UA_MAX_LENGTH) : ua2;
          return this;
        };
        this.setUA(_ua);
        return this;
      };
      UAParser.VERSION = LIBVERSION;
      UAParser.BROWSER = enumerize([NAME, VERSION, MAJOR]);
      UAParser.CPU = enumerize([ARCHITECTURE]);
      UAParser.DEVICE = enumerize([MODEL, VENDOR, TYPE, CONSOLE, MOBILE, SMARTTV, TABLET, WEARABLE, EMBEDDED]);
      UAParser.ENGINE = UAParser.OS = enumerize([NAME, VERSION]);
      if ("object" !== UNDEF_TYPE) {
        if ("object" !== UNDEF_TYPE && module.exports) {
          exports = module.exports = UAParser;
        }
        exports.UAParser = UAParser;
      } else {
        if (typeof undefined$1 === FUNC_TYPE && undefined$1.amd) {
          undefined$1(function() {
            return UAParser;
          });
        } else if (typeof window2 !== UNDEF_TYPE) {
          window2.UAParser = UAParser;
        }
      }
      var $2 = typeof window2 !== UNDEF_TYPE && (window2.jQuery || window2.Zepto);
      if ($2 && !$2.ua) {
        var parser2 = new UAParser();
        $2.ua = parser2.getResult();
        $2.ua.get = function() {
          return parser2.getUA();
        };
        $2.ua.set = function(ua) {
          parser2.setUA(ua);
          var result2 = parser2.getResult();
          for (var prop in result2) {
            $2.ua[prop] = result2[prop];
          }
        };
      }
    })(typeof window === "object" ? window : commonjsGlobal);
  })(uaParser$2, uaParser$2.exports);
  var uaParserExports = uaParser$2.exports;
  const uaParser$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(uaParserExports);
  class HelpFunctions {
    constructor() {
      this.isExtensionMode = false;
      this.browserName = "";
      this.manifest = {
        manifest_version: 2,
        name: "",
        version: ""
      };
      try {
        this.isExtensionMode = !!(chrome.runtime && chrome.extension && chrome.runtime.getManifest);
        this.manifest = chrome.runtime.getManifest();
      } catch (error) {
        console.log("HelpFunctions: is not extension mode.", error);
      }
      this.browserName = new uaParserExports.UAParser().getBrowser().name || "";
    }
    /**
     * 获取当天日期的键值
     */
    getToDay(time) {
      let day = /* @__PURE__ */ new Date();
      if (time) {
        day = new Date(time);
      }
      let yyyy = day.getFullYear();
      let m = day.getMonth() + 1;
      let mm = m < 10 ? "0" + m : m;
      let d2 = day.getDate();
      let dd = d2 < 10 ? "0" + d2 : d2;
      return `${yyyy}-${mm}-${dd}`;
    }
    /**
     * 更新插件徽标提示
     * @param count
     */
    updateBadge(count) {
      if (!this.isExtensionMode)
        return;
      try {
        if (count == 0) {
          chrome.browserAction.setBadgeText({ text: "" });
          chrome.browserAction.enable();
        } else {
          chrome.browserAction.setBadgeText({ text: count.toString() });
          chrome.browserAction.setBadgeBackgroundColor({
            color: "#aabbcc"
          });
          chrome.browserAction.disable();
        }
      } catch (error) {
        console.log(error);
      }
    }
    /**
     * 获取当前版本
     */
    getVersion() {
      if (this.isExtensionMode) {
        return "v" + (this.manifest.version_name || this.manifest.version);
      } else {
        return "localVersion";
      }
    }
    /**
     * 获取随机字符串
     * @param  {number} length    长度，默认为32
     * @param  {boolean} noSimilar 是否包含容易混淆的字符，默认为包含
     * @return {string}           返回的内容
     */
    getRandomString(length = 32, noSimilar = false) {
      let chars2 = noSimilar ? "abcdefhijkmnprstwxyz2345678ABCDEFGHJKMNPQRSTWXYZ" : "abcdefghijkmnopqrstuvwxyz0123456789ABCDEFGHIJKMNOPQRSTUVWXYZ";
      let maxLength = chars2.length;
      let result2 = [];
      for (let i2 = 0; i2 < length; i2++) {
        result2.push(chars2.charAt(Math.floor(Math.random() * maxLength)));
      }
      return result2.join("");
    }
    /**
     * 获取一个编号
     */
    getNewId() {
      return cryptoJsExports.MD5(
        (/* @__PURE__ */ new Date()).getTime().toString() + this.getRandomString()
      ).toString();
    }
    /**
     * 显示系统提示信息
     * @param options
     */
    showNotifications(options2, timeout = 3e3) {
      options2 = Object.assign(
        {
          type: "basic",
          iconUrl: chrome.runtime.getURL("/assets/icon-128.png"),
          title: "PT 助手 Plus",
          priority: 0,
          message: ""
        },
        options2
      );
      let id = Math.floor(Math.random() * 99999) + "";
      chrome.notifications.create(id, options2, function(myId) {
        id = myId;
      });
      setTimeout(() => {
        chrome.notifications.clear(id, () => {
        });
      }, timeout);
    }
    /**
     * 去除重复的查询字符串
     * @param url
     */
    removeDuplicateQueryString(url2) {
      let querys = [], queryString = "", rule2 = /([^&=]+)=([^&]*)/g, m, head = "", index2 = url2.indexOf("?");
      if (index2 !== -1) {
        head = url2.substr(0, index2 + 1);
        queryString = url2.substr(index2 + 1);
        while (m = rule2.exec(queryString)) {
          const v = m[1] + "=" + m[2];
          if (!querys.includes(v)) {
            querys.push(v);
          }
        }
        return head + querys.join("&");
      }
      return url2;
    }
    /**
     * 删除链接中指定值的查询字符串
     * @param url
     * @param value
     */
    removeQueryStringFromValue(url2, value) {
      let querys = [], queryString = "", rule2 = /([^&=]+)=([^&]*)/g, m, head = "", index2 = url2.indexOf("?");
      if (index2 !== -1) {
        head = url2.substr(0, index2 + 1);
        queryString = url2.substr(index2 + 1);
        while (m = rule2.exec(queryString)) {
          const v = m[1] + "=" + m[2];
          if (m[2] !== value) {
            querys.push(v);
          }
        }
        return head + querys.join("&");
      }
      return url2;
    }
    /**
     * 删除链接中指定的字段
     * @param url
     * @param value
     */
    removeQueryStringFields(url2, fields) {
      let querys = [], queryString = "", rule2 = /([^&=]+)=([^&]*)/g, m, head = "", index2 = url2.indexOf("?");
      if (index2 !== -1) {
        head = url2.substr(0, index2 + 1);
        queryString = url2.substr(index2 + 1);
        while (m = rule2.exec(queryString)) {
          const v = m[1] + "=" + m[2];
          if (!fields.includes(m[1])) {
            querys.push(v);
          }
        }
        return head + querys.join("&");
      }
      return url2;
    }
    clone(source2) {
      return JSON.parse(JSON.stringify(source2));
    }
    /**
     * 输出调试信息
     * @param msg
     */
    debug(...msg) {
      console.log((/* @__PURE__ */ new Date()).toLocaleString(), ...msg);
    }
    /**
     * 显示上下文菜单
     * @param menus
     * @param event
     */
    showContextMenu(menus, event) {
      try {
        basicContext_minExports.show(menus, event);
        $(".basicContext").css({
          left: "-=20px",
          top: "+=10px"
        });
      } catch (error) {
      }
    }
    getCleaningURL(url2) {
      return this.removeQueryStringFields(url2, ["hit", "cmtpage", "page"]);
    }
    /**
     * 检查权限
     * @param permissions 需要检查的权限列表
     */
    checkPermissions(permissions) {
      return new Promise((resolve2, reject2) => {
        if (chrome == null ? void 0 : chrome.permissions) {
          chrome.permissions.contains(
            {
              permissions
            },
            (result2) => {
              if (result2 === true) {
                resolve2(true);
              } else {
                reject2({
                  success: false
                });
              }
            }
          );
        } else {
          reject2({
            success: false
          });
        }
      });
    }
    /**
     * 申请权限
     * @param permissions 需要申请的权限列表
     */
    requestPermissions(permissions) {
      return new Promise((resolve2, reject2) => {
        if (chrome == null ? void 0 : chrome.permissions) {
          chrome.permissions.request(
            {
              permissions
            },
            (granted) => {
              if (granted === true) {
                resolve2(true);
              } else {
                reject2({
                  success: false
                });
              }
            }
          );
        } else {
          reject2({
            success: false
          });
        }
      });
    }
    /**
     * 使用指定的使用
     * @param permissions 权限列表
     * @param needConfirm 是否需要确认，因为有些权限默认浏览器会弹出确认，有些不会弹出确认，增加此参数用于手工确认
     */
    usePermissions(permissions, needConfirm = false, confirmMsg = "") {
      return new Promise((resolve2, reject2) => {
        this.checkPermissions(permissions).then((result2) => {
          resolve2(result2);
        }).catch(() => {
          let confirmed = true;
          if (needConfirm) {
            confirmed = confirm(confirmMsg);
          }
          if (!confirmed) {
            reject2({
              success: false
            });
            return;
          }
          this.requestPermissions(permissions).then((result2) => {
            resolve2(result2);
          }).catch((error) => {
            reject2(error);
          });
        });
      });
    }
    /**
     * 根据指定的host获取已定义的站点信息
     * @param host
     */
    getSiteFromHost(host2, options2) {
      var _a;
      let sites = [];
      if (options2.sites) {
        sites.push(...options2.sites);
      }
      if ((_a = options2.system) == null ? void 0 : _a.publicSites) {
        sites.push(...options2.system.publicSites);
      }
      let site2 = sites.find((item) => {
        var _a2;
        let cdn = [item.url].concat(item.cdn, item.apiCdn, (_a2 = item.formerHosts) == null ? void 0 : _a2.map((x) => `//${x}`));
        return item.host == host2 || cdn.join("").indexOf(`//${host2}`) > -1;
      });
      if (site2) {
        return this.clone(site2);
      }
      return null;
    }
    getNewBackupFileName() {
      return "PT-Plugin-Plus-Backup-" + dayjs().format("YYYY-MM-DD_HH-mm-ss") + ".zip";
    }
    /**
     * 替换指定的字符串列表
     * @param source
     * @param maps
     */
    replaceKeys(source2, maps, prefix = "") {
      if (!source2 || typeof source2 !== "string") {
        return source2;
      }
      let result2 = source2;
      for (const key2 in maps) {
        if (maps.hasOwnProperty(key2)) {
          const value = maps[key2];
          let search = "$" + key2 + "$";
          if (prefix) {
            search = `$${prefix}.${key2}$`;
          }
          result2 = result2.replace(search, value);
        }
      }
      return result2;
    }
    /**
     * 检查指定的可选权限是否有被声明
     * @param key
     */
    checkOptionalPermission(key2) {
      if (this.isExtensionMode && this.manifest && this.manifest.optional_permissions) {
        return this.manifest.optional_permissions.includes(key2);
      }
      return false;
    }
    /**
     * 转换时间
     * @param time 待转换的时间
     * @param timezoneOffset 时区偏移量，用于解决时差问题，如：+08:00, -08:00, +0800, UTC+0800, UTC+08:00
     * @see https://zh.wikipedia.org/wiki/各國時區列表
     * @see https://zh.wikipedia.org/wiki/时区
     * @see https://zh.wikipedia.org/wiki/ISO_8601
     */
    transformTime(time, timezoneOffset) {
      if (!timezoneOffset || !time) {
        return time;
      }
      let result2 = time;
      if (/^(\d){10}$/.test(result2 + "")) {
        result2 = parseInt(result2 + "") * 1e3;
      }
      let datetime = dayjs(result2).format("YYYY-MM-DDTHH:mm:ss");
      result2 = (/* @__PURE__ */ new Date(`${datetime}${timezoneOffset}`)).getTime();
      return result2;
    }
    /**
     * @see https://nodejs.org/api/url.html#url_url_resolve_from_to
     */
    resolveURL(from, to) {
      const resolvedUrl = new URL(to, new URL(from, "resolve://"));
      if (resolvedUrl.protocol === "resolve:") {
        const { pathname, search, hash: hash2 } = resolvedUrl;
        return pathname + search + hash2;
      }
      return resolvedUrl.toString();
    }
    getIdFromMTURL(url2) {
      try {
        let id = new URL(url2).pathname.split("/").pop();
        if (id) {
          parseInt(id);
          return id;
        }
      } catch (error) {
        console.log("getIdFromMTURL error", error);
      }
      return void 0;
    }
    /**
     * activeURL 这个字段可能不存在,,,
     * 比如右键种子发送到 PTPP, 按正常逻辑筛选一遍
     */
    getSiteActiveUrl(site2) {
      if (site2.apiCdn && site2.apiCdn.length > 0)
        return site2.apiCdn[0];
      if (site2.activeURL)
        return site2.activeURL;
      if (site2.cdn && site2.cdn.length > 0)
        return site2.cdn[0];
      return site2.url;
    }
    /**
     * 解析 mt 下载链接
     * @param id 种子 id
     * @param showNotice 是否显示提示
     * @param site 站点信息
     */
    resolveMTDownloadURL(id, site2, showNotice = void 0) {
      let activeURL = this.getSiteActiveUrl(site2);
      let res = $.ajax(this.resolveURL(activeURL, "/api/torrent/genDlToken"), {
        method: "POST",
        data: { id },
        cache: true,
        headers: {
          "x-api-key": site2.authToken
        },
        success: function(data2) {
          if (data2.code === "0") {
            console.log(`种子 ${id} 下载链接获取成功`, data2);
          } else {
            let msg = `种子 ${id} 下载链接获取失败, code != 0`;
            console.log(msg, data2);
            if (showNotice) {
              showNotice({ msg });
            }
          }
        },
        error: function(data2) {
          let msg = `种子 ${id} 下载链接获取失败`;
          console.log(msg, data2);
          if (showNotice) {
            showNotice({ msg });
          }
        },
        async: false
      });
      return res.responseJSON.data || "";
    }
  }
  const PPF = new HelpFunctions();
  const filters = {
    /**
     * 格式化数字
     * @param source 数字来源
     * @param format 格式化格式
     */
    formatNumber(source2, format = "###,###,###,###.00") {
      if (source2 === void 0) {
        return "";
      }
      const fStr = (sNumber, fmt, p2) => {
        if (sNumber === "" || sNumber === void 0) {
          if (fmt === "" || fmt === void 0) {
            return "";
          } else {
            return fmt;
          }
        }
        let fc = "";
        let s2 = "";
        let r2 = "";
        let pos = 0;
        if (!p2) {
          sNumber = sNumber.split("").reverse().join("");
          fmt = fmt.split("").reverse().join("");
        }
        let j = 0;
        for (let i2 = 0; i2 < fmt.length; i2++, j++) {
          s2 = sNumber.charAt(j);
          if (s2 === void 0) {
            continue;
          }
          fc = fmt.charAt(i2);
          switch (fc) {
            case "#":
              r2 += s2;
              pos = i2;
              break;
            case "0":
              r2 = s2 || s2 === fc ? r2 + s2 : r2 + 0;
              pos = i2;
              break;
            case ".":
              r2 += s2 === fc ? s2 : (j--, fc);
              break;
            case ",":
              r2 += s2 === fc ? s2 : (j--, fc);
              break;
            default:
              r2 += fc;
              j--;
          }
        }
        if (j !== sNumber.length && fmt.charAt(fmt.length - 1) !== "0" && pos !== fmt.length && fmt.charAt(pos) !== "0") {
          r2 = r2.substr(0, pos + 1) + sNumber.substr(j) + r2.substr(pos + 1);
        }
        r2 = (p2 ? r2 : r2.split("").reverse().join("")).replace(/(^,)|(,$)|(,,+)/g, "");
        if (r2.substr(0, 1) === ",") {
          r2 = r2.substr(1);
        }
        if (r2.substr(0, 2) === "-,") {
          r2 = "-" + r2.substr(2);
        }
        return r2;
      };
      const sourceString = source2.toString();
      if (sourceString.length === 0) {
        return "";
      }
      let bytes = parseFloat(sourceString);
      if (isNaN(bytes)) {
        return sourceString;
      }
      if (!format) {
        return sourceString;
      }
      const arrFormat = format.split(".");
      const arrSource = sourceString.split(".");
      return arrFormat.length > 1 ? fStr(arrSource[0], arrFormat[0]) + "." + fStr(arrSource[1], arrFormat[1], 1) : fStr(arrSource[0], arrFormat[0]);
    },
    /**
     *
     * @param sourceBytes 需要格式的字节
     * @param zeroToEmpty 是否需要将0转为空输出，默认为 false
     * @param type 类型，可指定为 `speed` 为速度，会在后面加上 /s
     */
    formatSize(sourceBytes, zeroToEmpty = false, type = "") {
      let bytes = parseFloat(sourceBytes);
      if (isNaN(bytes)) {
        return "";
      }
      if (bytes < 0) {
        return "N/A";
      }
      if (bytes === 0) {
        if (zeroToEmpty) {
          return "";
        } else {
          if (type === "speed") {
            return "0.00 KiB/s";
          } else {
            return "0.00";
          }
        }
      }
      let r2;
      let u2 = "KiB";
      let format = "###,###,###,###.00 ";
      let format2 = "###,###,###,###.000 ";
      if (bytes < 1e3 * Math.pow(2, 10)) {
        r2 = bytes / Math.pow(2, 10);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "KiB";
      } else if (bytes < 1e3 * Math.pow(2, 20)) {
        r2 = bytes / Math.pow(2, 20);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "MiB";
      } else if (bytes < 1e3 * Math.pow(2, 30)) {
        r2 = bytes / Math.pow(2, 30);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "GiB";
      } else if (bytes < 1e3 * Math.pow(2, 40)) {
        r2 = bytes / Math.pow(2, 40);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "TiB";
      } else if (bytes < 1e3 * Math.pow(2, 50)) {
        r2 = bytes / Math.pow(2, 50);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "PiB";
      } else if (bytes < 1e3 * Math.pow(2, 60)) {
        r2 = bytes / Math.pow(2, 60);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "EiB";
      } else {
        r2 = bytes / Math.pow(2, 70);
        r2 = Math.round(r2 * 100) / 100;
        u2 = "ZiB";
      }
      if (type === "speed") {
        u2 += "/s";
      }
      return this.formatNumber(r2, format) + u2;
    },
    /**
     *
     * @param sourceBytes 需要格式的字节
     * @param zeroToEmpty 是否需要将0转为空输出，默认为 false
     * @param type 类型，可指定为 `speed` 为速度，会在后面加上 /s
     */
    formatSizetoPrecision(sourceBytes, zeroToEmpty = false, type = "") {
      let bytes = parseFloat(sourceBytes);
      if (isNaN(bytes)) {
        return "";
      }
      if (bytes < 0) {
        return "N/A";
      }
      if (bytes === 0) {
        if (zeroToEmpty) {
          return "";
        } else {
          if (type === "speed") {
            return "0.00 KiB/s";
          } else {
            return "0.00";
          }
        }
      }
      let r2;
      let u2 = "KiB";
      if (bytes < 1e3 * Math.pow(2, 10)) {
        r2 = bytes / Math.pow(2, 10);
        u2 = "KiB";
      } else if (bytes < 1e3 * Math.pow(2, 20)) {
        r2 = bytes / Math.pow(2, 20);
        u2 = "MiB";
      } else if (bytes < 1e3 * Math.pow(2, 30)) {
        r2 = bytes / Math.pow(2, 30);
        u2 = "GiB";
      } else if (bytes < 1e3 * Math.pow(2, 40)) {
        r2 = bytes / Math.pow(2, 40);
        u2 = "TiB";
      } else if (bytes < 1e3 * Math.pow(2, 50)) {
        r2 = bytes / Math.pow(2, 50);
        u2 = "PiB";
      } else if (bytes < 1e3 * Math.pow(2, 60)) {
        r2 = bytes / Math.pow(2, 60);
        u2 = "EiB";
      } else {
        r2 = bytes / Math.pow(2, 70);
        u2 = "ZiB";
      }
      if (type === "speed") {
        u2 += "/s";
      }
      return r2.toPrecision(4) + " " + u2;
    },
    /**
     * 支持负值
     */
    formatSizeWithNegative(sourceBytes, zeroToEmpty = false, type = "") {
      sourceBytes = parseFloat(sourceBytes);
      let bytes = sourceBytes;
      if (sourceBytes < 0) {
        bytes = -bytes;
      }
      let result2 = this.formatSize(bytes, zeroToEmpty, type);
      if (sourceBytes < 0) {
        result2 = `- ${result2}`;
      }
      return result2;
    },
    /**
     * 格式化速度
     * @param bytes 需要格式化的字节数
     * @param zeroToEmpty 是否需要将0转为空输出，默认为 false
     */
    formatSpeed(bytes, zeroToEmpty = false) {
      return this.formatSize(bytes, zeroToEmpty, "speed");
    },
    /** 
      * @param {string} url 完整的URL地址 
      * @returns {object} 自定义的对象 
      * @description 用法示例：var myURL = parseURL('http://abc.com:8080/dir/index.html?id=255&m=hello#top');
        myURL.file='index.html' 
    
        myURL.hash= 'top' 
    
        myURL.host= 'abc.com' 
    
        myURL.query= '?id=255&m=hello' 
    
        myURL.params= Object = { id: 255, m: hello } 
    
        myURL.path= '/dir/index.html' 
    
        myURL.segments= Array = ['dir', 'index.html'] 
    
        myURL.port= '8080' 
    
        myURL.protocol= 'http' 
    
        myURL.source= 'http://abc.com:8080/dir/index.html?id=255&m=hello#top' 
      */
    parseURL(url2) {
      var a2 = document.createElement("a");
      a2.href = url2;
      return {
        source: url2,
        protocol: a2.protocol.replace(":", ""),
        host: a2.hostname,
        port: a2.port,
        query: a2.search,
        params: function() {
          var ret = {}, seg = a2.search.replace(/^\?/, "").split("&"), len2 = seg.length, i2 = 0, s2;
          for (; i2 < len2; i2++) {
            if (!seg[i2]) {
              continue;
            }
            s2 = seg[i2].split("=");
            ret[s2[0]] = s2[1];
          }
          return ret;
        }(),
        hash: a2.hash.replace("#", ""),
        path: a2.pathname.replace(/^([^/])/, "/$1"),
        segments: a2.pathname.replace(/^\//, "").split("/"),
        origin: `${a2.protocol}//${a2.hostname}` + (a2.port ? `:${a2.port}` : "")
      };
    },
    /**
     * 将数字转为正确的IMDbId
     * @param source
     */
    formatIMDbId(imdbId) {
      if (Number(imdbId)) {
        if (imdbId.length < 7)
          imdbId = imdbId.padStart(7, "0");
        imdbId = "tt" + imdbId;
      }
      return imdbId;
    },
    /**
     * 将多少时间之前的格式转为时间数字（大概时间）
     * @param source
     */
    timeAgoToNumber(source2) {
      let rule2 = /^([\d.]+).+?((year|month|week|day|hour|min|minute)s?)( +ago)?(.+)?$/i;
      let matchs = source2.trim().match(rule2);
      if (!matchs) {
        return 0;
      }
      let now = /* @__PURE__ */ new Date();
      let interval = matchs[3];
      let number = Math.round(parseFloat(matchs[1]));
      let result2 = /* @__PURE__ */ new Date();
      switch (interval.toLowerCase()) {
        case "year":
          result2 = new Date(now.setFullYear(now.getFullYear() - number));
          break;
        case "month":
          result2 = new Date(now.setMonth(now.getMonth() - number));
          break;
        case "day":
          result2 = new Date(now.setDate(now.getDate() - number));
          break;
        case "week":
          result2 = new Date(now.setDate(now.getDate() - 7 * number));
          break;
        case "hour":
          result2 = new Date(now.setHours(now.getHours() - number));
          break;
        case "min":
        case "minute":
          result2 = new Date(now.setMinutes(now.getMinutes() - number));
          break;
      }
      return result2.getTime();
    },
    formatInteger(source2) {
      return this.formatNumber(source2, "###,###,###,###");
    }
  };
  var FileSaver_min$1 = { exports: {} };
  var FileSaver_min = FileSaver_min$1.exports;
  (function(module, exports) {
    (function(a2, b) {
      if (false)
        (void 0)([], b);
      else if (true)
        b();
      else {
        b(), a2.FileSaver = { exports: {} }.exports;
      }
    })(commonjsGlobal, function() {
      "use strict";
      function b(a3, b2) {
        return "undefined" == typeof b2 ? b2 = { autoBom: false } : "object" != typeof b2 && (console.warn("Deprecated: Expected third argument to be a object"), b2 = { autoBom: !b2 }), b2.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(a3.type) ? new Blob(["\uFEFF", a3], { type: a3.type }) : a3;
      }
      function c2(a3, b2, c3) {
        var d3 = new XMLHttpRequest();
        d3.open("GET", a3), d3.responseType = "blob", d3.onload = function() {
          g(d3.response, b2, c3);
        }, d3.onerror = function() {
          console.error("could not download file");
        }, d3.send();
      }
      function d2(a3) {
        var b2 = new XMLHttpRequest();
        b2.open("HEAD", a3, false);
        try {
          b2.send();
        } catch (a4) {
        }
        return 200 <= b2.status && 299 >= b2.status;
      }
      function e2(a3) {
        try {
          a3.dispatchEvent(new MouseEvent("click"));
        } catch (c3) {
          var b2 = document.createEvent("MouseEvents");
          b2.initMouseEvent("click", true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null), a3.dispatchEvent(b2);
        }
      }
      var f2 = "object" == typeof window && window.window === window ? window : "object" == typeof self && self.self === self ? self : "object" == typeof commonjsGlobal && commonjsGlobal.global === commonjsGlobal ? commonjsGlobal : void 0, a2 = f2.navigator && /Macintosh/.test(navigator.userAgent) && /AppleWebKit/.test(navigator.userAgent) && !/Safari/.test(navigator.userAgent), g = f2.saveAs || ("object" != typeof window || window !== f2 ? function() {
      } : "download" in HTMLAnchorElement.prototype && !a2 ? function(b2, g2, h2) {
        var i2 = f2.URL || f2.webkitURL, j = document.createElement("a");
        g2 = g2 || b2.name || "download", j.download = g2, j.rel = "noopener", "string" == typeof b2 ? (j.href = b2, j.origin === location.origin ? e2(j) : d2(j.href) ? c2(b2, g2, h2) : e2(j, j.target = "_blank")) : (j.href = i2.createObjectURL(b2), setTimeout(function() {
          i2.revokeObjectURL(j.href);
        }, 4e4), setTimeout(function() {
          e2(j);
        }, 0));
      } : "msSaveOrOpenBlob" in navigator ? function(f3, g2, h2) {
        if (g2 = g2 || f3.name || "download", "string" != typeof f3)
          navigator.msSaveOrOpenBlob(b(f3, h2), g2);
        else if (d2(f3))
          c2(f3, g2, h2);
        else {
          var i2 = document.createElement("a");
          i2.href = f3, i2.target = "_blank", setTimeout(function() {
            e2(i2);
          });
        }
      } : function(b2, d3, e3, g2) {
        if (g2 = g2 || open("", "_blank"), g2 && (g2.document.title = g2.document.body.innerText = "downloading..."), "string" == typeof b2)
          return c2(b2, d3, e3);
        var h2 = "application/octet-stream" === b2.type, i2 = /constructor/i.test(f2.HTMLElement) || f2.safari, j = /CriOS\/[\d]+/.test(navigator.userAgent);
        if ((j || h2 && i2 || a2) && "undefined" != typeof FileReader) {
          var k = new FileReader();
          k.onloadend = function() {
            var a3 = k.result;
            a3 = j ? a3 : a3.replace(/^data:[^;]*;/, "data:attachment/file;"), g2 ? g2.location.href = a3 : location = a3, g2 = null;
          }, k.readAsDataURL(b2);
        } else {
          var l2 = f2.URL || f2.webkitURL, m = l2.createObjectURL(b2);
          g2 ? g2.location = m : location.href = m, g2 = null, setTimeout(function() {
            l2.revokeObjectURL(m);
          }, 4e4);
        }
      });
      f2.saveAs = g.saveAs = g, module.exports = g;
    });
  })(FileSaver_min$1, FileSaver_min$1.exports);
  var FileSaver_minExports = FileSaver_min$1.exports;
  const FileSaver = /* @__PURE__ */ getDefaultExportFromCjs$1(FileSaver_minExports);
  class Downloader {
    constructor(options2) {
      this.options = options2;
      this.count = 0;
      this.completedCount = 0;
      this.downloadingCount = 0;
      this.files = {};
      this.queues = [];
      options2.files && options2.files.forEach((item) => {
        this.push(item);
      });
    }
    // 添加下载
    push(options2) {
      if (!options2.url || options2.url && this.files[options2.url]) {
        return;
      }
      var file = new FileDownloader(options2);
      file.onCompleted = () => {
        this.downloadingCount--;
        this.completedCount++;
        this.onCompleted(file);
        delete this.files[file.url];
      };
      file.onStart = () => {
        this.downloadingCount++;
      };
      file.onError = (e2) => {
        this.downloadingCount--;
        this.completedCount++;
        if (this.options.onError) {
          this.options.onError.call(this, file, e2);
        }
        delete this.files[file.url];
      };
      file.onProgress = (loaded, total, speed) => {
        if (this.options.onProgress) {
          this.options.onProgress.call(this, file, loaded, total, speed);
        }
      };
      this.files[file.url] = file;
      this.queues.push(file);
      this.count++;
      if (this.options.autoStart) {
        file.start();
      }
    }
    start() {
    }
    onCompleted(file) {
      if (this.options.onCompleted) {
        this.options.onCompleted.call(this, file);
      }
    }
  }
  class FileDownloader {
    constructor(options2) {
      this.lastTime = 0;
      this.startTime = 0;
      this.status = 0;
      this.statusText = "";
      this.url = "";
      this.requestMethod = ERequestMethod.GET;
      this.postData = null;
      this.fileName = "";
      this.loaded = 0;
      this.total = 0;
      this.percent = 0;
      this.speed = 0;
      this.showSpeed = "";
      this.onProgress = function() {
      };
      this.onCompleted = function() {
      };
      this.onError = function() {
      };
      this.onStart = function() {
      };
      this.getDataOnly = false;
      this.timeout = 0;
      this.xhr = new XMLHttpRequest();
      this.fileName = options2.fileName || "";
      this.url = options2.url;
      this.getDataOnly = options2.getDataOnly || false;
      this.timeout = options2.timeout || 0;
      this.requestMethod = options2.method || ERequestMethod.GET;
    }
    start() {
      this.lastTime = +/* @__PURE__ */ new Date();
      this.startTime = this.lastTime;
      this.statusText = "数据准备中……";
      if (this.timeout > 0) {
        this.xhr.timeout = this.timeout;
      }
      this.xhr.open(this.requestMethod, this.url, true);
      this.xhr.responseType = "blob";
      this.xhr.onreadystatechange = () => {
        switch (this.xhr.readyState) {
          case 4:
            switch (this.xhr.status) {
              case 200:
              case 302:
                this.content = this.xhr.response;
                this.downloadCompleted();
                break;
              default:
                if (this.xhr.status != 0) {
                  this.downloadError(
                    `[${this.url}] 下载失败，返回的状态码为：${this.xhr.status}`
                  );
                }
                break;
            }
            break;
          case 2:
            var contentDisposition = this.xhr.getResponseHeader(
              "Content-Disposition"
            );
            if (contentDisposition && !this.fileName && !this.getDataOnly) {
              this.fileName = this.getFileName(contentDisposition);
            }
            break;
        }
      };
      this.xhr.onprogress = (e2) => {
        this.loaded = e2.loaded;
        this.total = e2.total;
        this.percent = (100 * (e2.loaded / e2.total)).toFixed(2);
        this.lastTime = +/* @__PURE__ */ new Date();
        this.speed = this.loaded / (this.startTime - this.lastTime);
        this.updateProgress();
      };
      this.xhr.onerror = (e2) => {
        this.downloadError(e2);
      };
      this.xhr.ontimeout = () => {
        this.downloadError(`[${this.url}] 下载超时`);
      };
      var data2 = null;
      if (this.postData) {
        data2 = $.param(this.postData);
      }
      if (this.requestMethod == ERequestMethod.POST) {
        this.xhr.setRequestHeader(
          "Content-Type",
          "application/x-www-form-urlencoded"
        );
      }
      this.xhr.send(data2);
      this.onStart && this.onStart.call(this);
    }
    getFileName(contentDisposition = "") {
      let items = contentDisposition.split(";");
      let fields = {};
      let result2 = "";
      for (let index2 = 0; index2 < items.length; index2++) {
        let item = items[index2];
        let tmp = item.replace(" ", "").split("=");
        if (tmp.length == 2) {
          fields[tmp[0]] = tmp[1].trim();
        }
      }
      let fileName;
      if (fileName = fields["filename*"]) {
        let index2 = fileName.lastIndexOf("'");
        result2 = fileName.substr(index2 + 1);
      } else {
        result2 = fields["filename"];
      }
      result2 = result2.replace(/"/g, "");
      return decodeURI(result2);
    }
    downloadCompleted() {
      if (this.loaded > 0 && !this.getDataOnly) {
        FileSaver.saveAs(this.content, this.fileName);
      }
      if (this.onCompleted) {
        this.onCompleted.call(this);
      }
    }
    downloadError(error) {
      if (this.onError) {
        this.onError.call(this, error);
      }
    }
    updateProgress() {
      if (this.onProgress) {
        this.onProgress.call(this, this.loaded, this.total, this.speed);
      }
    }
  }
  const StorageKey = "Favicon-Cache";
  const NOIMAGE = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
  class Favicon {
    constructor(service) {
      this.service = service;
      this.cache = {};
      this.loadCache();
    }
    loadCache() {
      let result2 = window.localStorage.getItem(StorageKey);
      if (result2) {
        this.cache = JSON.parse(result2) || {};
      }
    }
    saveCache() {
      window.localStorage.setItem(StorageKey, JSON.stringify(this.cache));
    }
    clear() {
      this.cache = {};
      this.saveCache();
    }
    reset() {
      let _cache = JSON.parse(JSON.stringify(this.cache));
      this.cache = {};
      let urls = [];
      for (const host2 in _cache) {
        if (_cache.hasOwnProperty(host2)) {
          let item = _cache[host2];
          urls.push(item.origin);
        }
      }
      return this.gets(urls);
    }
    gets(urls) {
      return new Promise((resolve2, reject2) => {
        let requests2 = [];
        urls.forEach((url2) => {
          requests2.push(this.get(url2));
        });
        Promise.all(requests2).then((results2) => {
          resolve2(results2);
        }).catch((e2) => {
          reject2(e2);
        });
      });
    }
    /**
     * 获取指定站点的图标
     * @param url 站点地址
     * @param reset 是否重置
     */
    get(url2, reset = false) {
      return new Promise((resolve2, reject2) => {
        let URL2 = filters.parseURL(url2);
        let cache = this.cache[URL2.host];
        if (!cache || reset) {
          this.cacheFavicon(URL2.origin, URL2.host).then((result2) => {
            resolve2(result2);
          }).catch((e2) => {
            reject2(e2);
          });
          return;
        }
        return resolve2(cache);
      });
    }
    /**
     * 缓存图标
     * @param url 站点地址
     * @param host 域名
     */
    cacheFavicon(url2, host2) {
      return new Promise((resolve2, reject2) => {
        var _a;
        let iconUrl = ((_a = new URL(url2).pathname) == null ? void 0 : _a.length) > 1 ? url2 : `${url2}/favicon.ico`;
        this.download(iconUrl).then((result2) => {
          if (result2 && result2.size > 0) {
            this.transformBlob(result2, "base64").then((base64) => {
              resolve2(this.set(url2, base64));
            }).catch((e2) => {
              reject2(e2);
            });
          } else {
            this.cacheFromIndex(url2, host2).then((result22) => {
              resolve2(result22);
            }).catch((e2) => {
              reject2(e2);
            });
          }
        }).catch(() => {
          this.cacheFromIndex(url2, host2).then((result2) => {
            resolve2(result2);
          }).catch((e2) => {
            reject2(e2);
          });
        });
      });
    }
    set(url2, data2) {
      let URL2 = filters.parseURL(url2);
      let item = {
        origin: URL2.origin,
        host: URL2.host,
        data: data2
      };
      this.cache[URL2.host] = item;
      this.saveCache();
      return item;
    }
    /**
     * 从站点首页内容中获取图标地址并缓存
     * @param url
     * @param host
     */
    cacheFromIndex(url2, host2) {
      return new Promise((resolve2, reject2) => {
        this.download(url2).then((result2) => {
          if (result2 && result2.size > 0 && /text/gi.test(result2.type)) {
            this.transformBlob(result2, "text").then((text) => {
              try {
                const doc2 = new DOMParser().parseFromString(
                  text,
                  "text/html"
                );
                const head = $(doc2).find("head");
                let query2 = head.find("link[rel*=icon]:first");
                if (query2 && query2.length > 0) {
                  let URL2 = filters.parseURL(url2);
                  let link = query2.attr("href") + "";
                  if (link.substr(0, 2) === "//") {
                    link = `${URL2.protocol}:${link}`;
                  } else if (link.substr(0, 4) !== "http") {
                    link = link.startsWith("/") ? `${URL2.origin}${link}` : `${URL2.origin}/${link}`;
                  }
                  this.download(link).then((result22) => {
                    if (result22 && /image/gi.test(result22.type)) {
                      this.transformBlob(result22, "base64").then((base64) => {
                        resolve2(this.set(url2, base64));
                      }).catch((e2) => {
                        this.debug(e2);
                        reject2(e2);
                      });
                    } else {
                      resolve2(this.set(url2, NOIMAGE));
                    }
                  }).catch(() => {
                    resolve2(this.set(url2, NOIMAGE));
                  });
                } else {
                  resolve2(this.set(url2, NOIMAGE));
                }
              } catch (error) {
                console.log(error);
                this.debug(error);
                resolve2(this.set(url2, NOIMAGE));
              }
            }).catch((e2) => {
              this.debug(`cacheFromIndex.error, url: ${url2}, host: ${host2}, result.length: ${result2 == null ? void 0 : result2.length}`, e2);
              reject2(e2);
            });
          } else {
            reject2();
          }
        }).catch(() => {
          resolve2(this.set(url2, NOIMAGE));
        });
      });
    }
    transformBlob(blob, to) {
      return new Promise((resolve2, reject2) => {
        const reader = new FileReader();
        reader.addEventListener("loadend", () => {
          if (reader.result) {
            resolve2(reader.result);
          } else {
            this.debug("transformBlob.error", blob, to);
            reject2();
          }
        });
        switch (to) {
          case "text":
            reader.readAsText(blob);
            break;
          case "base64":
            reader.readAsDataURL(blob);
            break;
        }
      });
    }
    download(url2) {
      return new Promise((resolve2, reject2) => {
        let file = new FileDownloader({
          url: url2,
          getDataOnly: true,
          timeout: 5e3
        });
        file.onCompleted = () => {
          if (file.content) {
            resolve2(file.content);
          } else {
            reject2();
          }
        };
        file.onError = (e2) => {
          console.log("Favicon.download.error", e2);
          this.debug(e2);
          reject2(e2);
        };
        file.start();
      });
    }
    debug(...msg) {
      if (this.service) {
        this.service.debug(...msg);
      }
    }
  }
  let rootPath = "";
  let isExtensionMode = false;
  const isDebugMode = false;
  try {
    let runtime = chrome.runtime;
    isExtensionMode = true;
    rootPath = runtime.getManifest().options_ui.page.replace("index.html", "");
    if (rootPath && rootPath.substr(-1) == "/") {
      rootPath = rootPath.substr(0, rootPath.length - 1);
    }
    if (!rootPath) {
      rootPath = `chrome-extension://${chrome.runtime.id}`;
    }
    isDebugMode && console.log("is extension mode.");
  } catch (error) {
    isExtensionMode = false;
    isDebugMode && console.log("is not extension mode.");
  }
  const RESOURCE_URL = !isExtensionMode ? `http://${window.location.hostname}:8001` : (isExtensionMode ? rootPath : "") + "/resource";
  let RESOURCE_API = {
    host: RESOURCE_URL,
    schemas: `${RESOURCE_URL}/schemas.json`,
    schemaConfig: `${RESOURCE_URL}/schemas/{$schema}/config.json`,
    sites: `${RESOURCE_URL}/sites.json`,
    siteConfig: `${RESOURCE_URL}/sites/{$site}/config.json`,
    clients: `${RESOURCE_URL}/clients.json`,
    clientConfig: `${RESOURCE_URL}/clients/{$client}/config.json`,
    latestReleases: `https://api.github.com/repos/pt-plugins/PT-Plugin-Plus/releases/latest`,
    systemConfig: `${RESOURCE_URL}/systemConfig.json`
  };
  const APP = {
    debugMode: isDebugMode,
    scriptQueues: [],
    isExtensionMode,
    cache: {
      localStorage: new localStorage(),
      cacheKey: EConfigKey.cache,
      contents: {},
      // 1 天
      expires: 60 * 60 * 24 * 1,
      init(callback) {
        APP.debugMode && console.log("cache.init");
        this.localStorage.get(this.cacheKey, (result2) => {
          if (result2) {
            let expires = result2["expires"];
            if (expires && /* @__PURE__ */ new Date() > new Date(expires) || APP.debugMode) {
              this.contents = {};
            } else {
              this.contents = result2;
            }
          }
          callback && callback();
        });
      },
      /**
       * 获取缓存
       * @param key
       */
      get(key2) {
        if (this.contents) {
          return this.contents[cryptoJsExports.MD5(key2).toString()];
        }
        return null;
      },
      /**
       * 设置缓存
       * @param key
       * @param content
       */
      set(key2, content2) {
        this.contents[cryptoJsExports.MD5(key2).toString()] = content2;
        this.contents["update"] = (/* @__PURE__ */ new Date()).getTime();
        this.contents["expires"] = (/* @__PURE__ */ new Date()).getTime() + this.expires;
        this.localStorage.set(this.cacheKey, this.contents);
      },
      /**
       * 清除缓存
       */
      clear() {
        this.contents = {};
        this.localStorage.set(this.cacheKey, this.contents);
      },
      /**
       * 获取缓存最后更新时间
       */
      getLastUpdateTime() {
        return new Promise((resolve2, reject2) => {
          this.localStorage.get(this.cacheKey, (result2) => {
            if (result2) {
              let update = result2["update"];
              resolve2(update || 0);
            } else {
              reject2();
            }
          });
        });
      }
    },
    addScript(script2) {
      APP.debugMode && console.log("addScript", script2);
      this.scriptQueues.push(script2);
    },
    applyScripts() {
      let script2 = this.scriptQueues.shift();
      if (script2) {
        this.execScript(script2).then(() => {
          this.applyScripts();
        });
      }
    },
    /**
     * 执行脚本
     * @param script
     */
    execScript(script2) {
      return new Promise((resolve2, reject2) => {
        switch (script2.type) {
          case "code":
            this.runScript(script2.content);
            resolve2();
            break;
          default:
            {
              let url2 = script2.content || script2;
              if (url2.substr(0, 4) !== "http") {
                if (url2.substr(0, 1) !== "/") {
                  url2 = `/${url2}`;
                }
                url2 = `${API.host}${url2}`;
              }
              let content2 = this.cache.get(url2);
              try {
                if (content2) {
                  this.runScript(content2);
                  resolve2();
                } else {
                  console.log("execScript: %s", url2);
                  $.ajax({
                    url: url2,
                    dataType: "text"
                  }).done((result2) => {
                    this.runScript(result2);
                    this.cache.set(url2, result2);
                    resolve2();
                  }).fail((jqXHR, status, text) => {
                    if (jqXHR.responseJSON && jqXHR.responseJSON.code && jqXHR.responseJSON.msg) {
                      reject2(
                        jqXHR.responseJSON.msg + " (" + jqXHR.responseJSON.code + ")"
                      );
                    } else {
                      reject2(status + ", " + text);
                    }
                  });
                }
              } catch (error) {
                reject2(error);
              }
            }
            break;
        }
      });
    },
    /**
     * 执行指定的脚本
     * @param script 脚本内容
     * @param scope 作用域
     */
    runScript(script2, scope2 = window) {
      eval.call(scope2, script2);
    },
    /**
     * 追加样式信息
     * @param options
     */
    applyStyle(options2) {
      return new Promise((resolve2, reject2) => {
        let style = $("<style/>").appendTo(document.body);
        switch (options2.type) {
          case "file": {
            let url2 = options2.content;
            if (url2.substr(0, 4) !== "http") {
              if (url2.substr(0, 1) !== "/") {
                url2 = `/${url2}`;
              }
              url2 = `${API.host}${url2}`;
            }
            let content2 = this.cache.get(url2);
            if (content2) {
              style.html(content2);
              resolve2();
            } else {
              $.get(
                url2,
                (result2) => {
                  style.html(result2);
                  this.cache.set(url2, result2);
                  resolve2();
                },
                "text"
              );
            }
            break;
          }
          default:
            style.html(options2.content);
            resolve2();
            break;
        }
      });
    },
    /**
     * 异步获取脚本内容
     * @param path 路径
     */
    getScriptContent(path2) {
      let url2 = `${API.host}/${path2}`;
      if (path2.substr(0, 4) === "http") {
        url2 = path2;
      } else {
        url2 = url2.replace("resource//", "resource/");
      }
      APP.debugMode && console.log("getScriptContent", url2);
      return $.ajax({
        url: url2,
        dataType: "text"
      });
    },
    /**
     * 创建错误信息，用于函数返回
     * @param msg
     */
    createErrorMessage(msg) {
      return {
        type: EDataResultType.error,
        msg,
        success: false
      };
    },
    /**
     * 显示系统提示信息
     */
    showNotifications(options2, timeout = 3e3) {
      PPF.showNotifications(options2, timeout);
    },
    getInstallType() {
      return new Promise((resolve2, reject2) => {
        if (chrome == null ? void 0 : chrome.management) {
          chrome.management.getSelf((result2) => {
            if (result2.updateUrl && result2.updateUrl.indexOf("pt-plugins/PT-Plugin-Plus") > 0) {
              resolve2(EInstallType.crx);
            } else {
              resolve2(result2.installType);
            }
          });
        } else {
          reject2();
        }
      });
    }
  };
  APP.cache.init();
  const API = RESOURCE_API;
  class SyncStorage {
    constructor() {
      this.arrayValues = {};
    }
    isArray(o2) {
      return Object.prototype.toString.call(o2) == "[object Array]";
    }
    /**
     * 清除所有参数
     */
    clear() {
      return new Promise((resolve2, reject2) => {
        try {
          chrome.storage.sync.clear();
          if (chrome.runtime.lastError) {
            reject2(chrome.runtime.lastError);
          } else {
            resolve2();
          }
        } catch (error) {
          reject2(error);
        }
      });
    }
    /**
     * 保存一个键值
     * @param key 键名
     * @param value 键值
     * @param count 当参数为数组时，数组的长度
     * @param onSuccess 成功时回调
     * @param onError 失败时回调
     */
    _set(key2, value, count = 0, onSuccess, onError) {
      let _data = value;
      let _key = key2;
      let index2 = -1;
      if (this.isArray(value)) {
        if (count == 0) {
          count = value.length;
          this._set(
            `${key2}__count`,
            count,
            0,
            () => {
              this._set(key2, value, count, onSuccess, onError);
            },
            onError
          );
          return;
        }
        index2 = value.length - 1;
        _data = value.pop();
        _key = `${key2}_${index2}`;
      }
      chrome.storage.sync.set(
        {
          [_key]: _data
        },
        () => {
          if (chrome.runtime.lastError) {
            onError(chrome.runtime.lastError);
          } else {
            if (index2 > 0) {
              this._set(key2, value, count, onSuccess, onError);
            } else {
              onSuccess(value);
            }
          }
        }
      );
    }
    /**
     * 获取指定的键值
     * @param key 键名
     * @param checkArray 是否检查数组
     * @param index 当前索引
     * @param onSuccess 成功回调
     * @param onError 失败回调
     */
    _get(key2, checkArray = false, index2 = 0, onSuccess, onError) {
      if (checkArray) {
        this._get(
          `${key2}__count`,
          false,
          0,
          (result2) => {
            if (result2 > 0) {
              this.arrayValues[key2] = [];
              this._get(key2, false, result2, onSuccess, onError);
            } else {
              this._get(key2, false, 0, onSuccess, onError);
            }
          },
          (error) => {
            if (error == "参数不存在") {
              this._get(key2, false, 0, onSuccess, onError);
            } else {
              onError && onError(error);
            }
          }
        );
        return;
      }
      let _key = key2;
      if (index2 > 0) {
        _key = `${key2}_${index2 - 1}`;
      }
      try {
        chrome.storage.sync.get(_key, (result2) => {
          let value = null;
          try {
            if (result2[_key]) {
              value = result2[_key];
            } else {
              onError("参数不存在");
              return;
            }
          } catch (error) {
            onError(error);
            return;
          }
          index2--;
          if (index2 <= 0) {
            if (this.arrayValues[key2]) {
              this.arrayValues[key2].push(value);
              onSuccess(this.arrayValues[key2]);
              delete this.arrayValues[key2];
            } else {
              onSuccess(value);
            }
          } else {
            this.arrayValues[key2].push(value);
            this._get(key2, false, index2, onSuccess, onError);
          }
        });
      } catch (error) {
        onError(error);
      }
    }
    /**
     * 保存指定的键值到Google
     * @param key
     * @param value
     */
    set(key2, value) {
      return new Promise((resolve2, reject2) => {
        if (chrome.storage && chrome.storage.sync) {
          try {
            this._set(
              key2,
              value,
              0,
              () => {
                resolve2(value);
              },
              (error) => {
                reject2(error);
              }
            );
          } catch (error) {
            reject2(error);
          }
        } else {
          reject2("chrome.storage 不存在");
        }
      });
    }
    /**
     * 从Google中获取指定的键值
     * @param key
     */
    get(key2) {
      return new Promise((resolve2, reject2) => {
        if (chrome.storage && chrome.storage.sync) {
          try {
            this._get(
              key2,
              true,
              0,
              (result2) => {
                resolve2(result2);
              },
              (error) => {
                reject2(error);
              }
            );
          } catch (error) {
            reject2(error);
          }
        } else {
          reject2("chrome.storage 不存在");
        }
      });
    }
  }
  class OWSS {
    constructor(options2) {
      this.options = options2;
      this.serverURL = "";
      this.serverURL = this.options.address;
      if (this.serverURL.substr(-1) !== "/") {
        this.serverURL += "/";
      }
    }
    /**
     * 发送指定的请求
     * @param action 指令
     * @param method 请求方法（GET，POST）
     * @param data 请求数据
     */
    request(action, method = ERequestMethod.GET, data2) {
      return new Promise((resolve2, reject2) => {
        let options2 = {
          url: this.serverURL + `${action}`,
          method,
          dataType: "json",
          data: data2
        };
        if (method === ERequestMethod.POST) {
          options2.processData = false;
          options2.contentType = false;
        }
        $.ajax(options2).done((result2) => {
          resolve2(result2);
        }).fail((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 申请资源ID
     */
    create() {
      return new Promise((resolve2, reject2) => {
        this.request("create").then((result2) => {
          if (result2 == null ? void 0 : result2.data) {
            resolve2(result2.data);
          } else {
            reject2();
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 添加文件
     * @param formData
     */
    add(formData) {
      return new Promise((resolve2, reject2) => {
        this.request(
          `${this.options.authCode}/add`,
          ERequestMethod.POST,
          formData
        ).then((result2) => {
          if ((result2 == null ? void 0 : result2.data) === true) {
            resolve2(true);
          } else {
            reject2(false);
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取（下载）一个文件
     * @param path
     * @returns 返回一个 blob 对象
     */
    get(path2) {
      return new Promise((resolve2, reject2) => {
        let url2 = `${this.serverURL}${this.options.authCode}/get/${path2}`;
        let file = new FileDownloader({
          url: url2,
          getDataOnly: true
        });
        file.onCompleted = () => {
          resolve2(file.content);
        };
        file.onError = (e2) => {
          console.log(e2);
          reject2(e2);
        };
        file.start();
      });
    }
    /**
     * 删除一个文件
     * @param path
     */
    delete(path2) {
      return new Promise((resolve2, reject2) => {
        this.request(
          `${this.options.authCode}/delete/${path2}`,
          ERequestMethod.POST
        ).then((result2) => {
          if (result2 == null ? void 0 : result2.data) {
            resolve2(result2.data);
          } else {
            reject2(false);
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取资源列表
     * @param options
     */
    list(options2 = {}) {
      return new Promise((resolve2, reject2) => {
        this.request(`${this.options.authCode}/list`, ERequestMethod.GET, options2).then((result2) => {
          if (result2 == null ? void 0 : result2.data) {
            resolve2(result2.data);
          } else {
            reject2(false);
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 验证服务器可用性
     */
    ping() {
      return new Promise((resolve2, reject2) => {
        this.request(`${this.options.authCode}/list`, ERequestMethod.GET, {
          pageSize: 1
        }).then(() => {
          resolve2(true);
        }).catch((error) => {
          reject2(error);
        });
      });
    }
  }
  const global$1 = globalThis || void 0 || self;
  function getDefaultExportFromCjs(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
  }
  var browser = { exports: {} };
  var process = browser.exports = {};
  var cachedSetTimeout;
  var cachedClearTimeout;
  function defaultSetTimout() {
    throw new Error("setTimeout has not been defined");
  }
  function defaultClearTimeout() {
    throw new Error("clearTimeout has not been defined");
  }
  (function() {
    try {
      if (typeof setTimeout === "function") {
        cachedSetTimeout = setTimeout;
      } else {
        cachedSetTimeout = defaultSetTimout;
      }
    } catch (e2) {
      cachedSetTimeout = defaultSetTimout;
    }
    try {
      if (typeof clearTimeout === "function") {
        cachedClearTimeout = clearTimeout;
      } else {
        cachedClearTimeout = defaultClearTimeout;
      }
    } catch (e2) {
      cachedClearTimeout = defaultClearTimeout;
    }
  })();
  function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
      return setTimeout(fun, 0);
    }
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
      cachedSetTimeout = setTimeout;
      return setTimeout(fun, 0);
    }
    try {
      return cachedSetTimeout(fun, 0);
    } catch (e2) {
      try {
        return cachedSetTimeout.call(null, fun, 0);
      } catch (e3) {
        return cachedSetTimeout.call(this, fun, 0);
      }
    }
  }
  function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
      return clearTimeout(marker);
    }
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
      cachedClearTimeout = clearTimeout;
      return clearTimeout(marker);
    }
    try {
      return cachedClearTimeout(marker);
    } catch (e2) {
      try {
        return cachedClearTimeout.call(null, marker);
      } catch (e3) {
        return cachedClearTimeout.call(this, marker);
      }
    }
  }
  var queue = [];
  var draining = false;
  var currentQueue;
  var queueIndex = -1;
  function cleanUpNextTick() {
    if (!draining || !currentQueue) {
      return;
    }
    draining = false;
    if (currentQueue.length) {
      queue = currentQueue.concat(queue);
    } else {
      queueIndex = -1;
    }
    if (queue.length) {
      drainQueue();
    }
  }
  function drainQueue() {
    if (draining) {
      return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;
    var len2 = queue.length;
    while (len2) {
      currentQueue = queue;
      queue = [];
      while (++queueIndex < len2) {
        if (currentQueue) {
          currentQueue[queueIndex].run();
        }
      }
      queueIndex = -1;
      len2 = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
  }
  process.nextTick = function(fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        args[i2 - 1] = arguments[i2];
      }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
      runTimeout(drainQueue);
    }
  };
  function Item(fun, array) {
    this.fun = fun;
    this.array = array;
  }
  Item.prototype.run = function() {
    this.fun.apply(null, this.array);
  };
  process.title = "browser";
  process.browser = true;
  process.env = {};
  process.argv = [];
  process.version = "";
  process.versions = {};
  function noop$1() {
  }
  process.on = noop$1;
  process.addListener = noop$1;
  process.once = noop$1;
  process.off = noop$1;
  process.removeListener = noop$1;
  process.removeAllListeners = noop$1;
  process.emit = noop$1;
  process.prependListener = noop$1;
  process.prependOnceListener = noop$1;
  process.listeners = function(name2) {
    return [];
  };
  process.binding = function(name2) {
    throw new Error("process.binding is not supported");
  };
  process.cwd = function() {
    return "/";
  };
  process.chdir = function(dir) {
    throw new Error("process.chdir is not supported");
  };
  process.umask = function() {
    return 0;
  };
  var browserExports = browser.exports;
  const process$1 = /* @__PURE__ */ getDefaultExportFromCjs(browserExports);
  /*! For license information please see index.js.LICENSE.txt */
  var t$1 = { 2: (t2) => {
    function e2(t3, e3, o2) {
      t3 instanceof RegExp && (t3 = n2(t3, o2)), e3 instanceof RegExp && (e3 = n2(e3, o2));
      var i2 = r2(t3, e3, o2);
      return i2 && { start: i2[0], end: i2[1], pre: o2.slice(0, i2[0]), body: o2.slice(i2[0] + t3.length, i2[1]), post: o2.slice(i2[1] + e3.length) };
    }
    function n2(t3, e3) {
      var n3 = e3.match(t3);
      return n3 ? n3[0] : null;
    }
    function r2(t3, e3, n3) {
      var r3, o2, i2, s2, a2, c2 = n3.indexOf(t3), u2 = n3.indexOf(e3, c2 + 1), l2 = c2;
      if (c2 >= 0 && u2 > 0) {
        for (r3 = [], i2 = n3.length; l2 >= 0 && !a2; )
          l2 == c2 ? (r3.push(l2), c2 = n3.indexOf(t3, l2 + 1)) : 1 == r3.length ? a2 = [r3.pop(), u2] : ((o2 = r3.pop()) < i2 && (i2 = o2, s2 = u2), u2 = n3.indexOf(e3, l2 + 1)), l2 = c2 < u2 && c2 >= 0 ? c2 : u2;
        r3.length && (a2 = [i2, s2]);
      }
      return a2;
    }
    t2.exports = e2, e2.range = r2;
  }, 101: function(t2, e2, n2) {
    var r2;
    t2 = n2.nmd(t2), function(o2) {
      var i2 = (t2 && t2.exports, "object" == typeof global$1 && global$1);
      i2.global !== i2 && i2.window;
      var s2 = function(t3) {
        this.message = t3;
      };
      (s2.prototype = new Error()).name = "InvalidCharacterError";
      var a2 = function(t3) {
        throw new s2(t3);
      }, c2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", u2 = /[\t\n\f\r ]/g, l2 = { encode: function(t3) {
        t3 = String(t3), /[^\0-\xFF]/.test(t3) && a2("The string to be encoded contains characters outside of the Latin1 range.");
        for (var e3, n3, r3, o3, i3 = t3.length % 3, s3 = "", u3 = -1, l3 = t3.length - i3; ++u3 < l3; )
          e3 = t3.charCodeAt(u3) << 16, n3 = t3.charCodeAt(++u3) << 8, r3 = t3.charCodeAt(++u3), s3 += c2.charAt((o3 = e3 + n3 + r3) >> 18 & 63) + c2.charAt(o3 >> 12 & 63) + c2.charAt(o3 >> 6 & 63) + c2.charAt(63 & o3);
        return 2 == i3 ? (e3 = t3.charCodeAt(u3) << 8, n3 = t3.charCodeAt(++u3), s3 += c2.charAt((o3 = e3 + n3) >> 10) + c2.charAt(o3 >> 4 & 63) + c2.charAt(o3 << 2 & 63) + "=") : 1 == i3 && (o3 = t3.charCodeAt(u3), s3 += c2.charAt(o3 >> 2) + c2.charAt(o3 << 4 & 63) + "=="), s3;
      }, decode: function(t3) {
        var e3 = (t3 = String(t3).replace(u2, "")).length;
        e3 % 4 == 0 && (e3 = (t3 = t3.replace(/==?$/, "")).length), (e3 % 4 == 1 || /[^+a-zA-Z0-9/]/.test(t3)) && a2("Invalid character: the string to be decoded is not correctly encoded.");
        for (var n3, r3, o3 = 0, i3 = "", s3 = -1; ++s3 < e3; )
          r3 = c2.indexOf(t3.charAt(s3)), n3 = o3 % 4 ? 64 * n3 + r3 : r3, o3++ % 4 && (i3 += String.fromCharCode(255 & n3 >> (-2 * o3 & 6)));
        return i3;
      }, version: "1.0.0" };
      void 0 === (r2 = (function() {
        return l2;
      }).call(e2, n2, e2, t2)) || (t2.exports = r2);
    }();
  }, 172: (t2, e2) => {
    e2.d = function(t3) {
      if (!t3)
        return 0;
      for (var e3 = (t3 = t3.toString()).length, n2 = t3.length; n2--; ) {
        var r2 = t3.charCodeAt(n2);
        56320 <= r2 && r2 <= 57343 && n2--, 127 < r2 && r2 <= 2047 ? e3++ : 2047 < r2 && r2 <= 65535 && (e3 += 2);
      }
      return e3;
    };
  }, 526: (t2) => {
    var e2 = { utf8: { stringToBytes: function(t3) {
      return e2.bin.stringToBytes(unescape(encodeURIComponent(t3)));
    }, bytesToString: function(t3) {
      return decodeURIComponent(escape(e2.bin.bytesToString(t3)));
    } }, bin: { stringToBytes: function(t3) {
      for (var e3 = [], n2 = 0; n2 < t3.length; n2++)
        e3.push(255 & t3.charCodeAt(n2));
      return e3;
    }, bytesToString: function(t3) {
      for (var e3 = [], n2 = 0; n2 < t3.length; n2++)
        e3.push(String.fromCharCode(t3[n2]));
      return e3.join("");
    } } };
    t2.exports = e2;
  }, 298: (t2) => {
    var e2, n2;
    e2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", n2 = { rotl: function(t3, e3) {
      return t3 << e3 | t3 >>> 32 - e3;
    }, rotr: function(t3, e3) {
      return t3 << 32 - e3 | t3 >>> e3;
    }, endian: function(t3) {
      if (t3.constructor == Number)
        return 16711935 & n2.rotl(t3, 8) | 4278255360 & n2.rotl(t3, 24);
      for (var e3 = 0; e3 < t3.length; e3++)
        t3[e3] = n2.endian(t3[e3]);
      return t3;
    }, randomBytes: function(t3) {
      for (var e3 = []; t3 > 0; t3--)
        e3.push(Math.floor(256 * Math.random()));
      return e3;
    }, bytesToWords: function(t3) {
      for (var e3 = [], n3 = 0, r2 = 0; n3 < t3.length; n3++, r2 += 8)
        e3[r2 >>> 5] |= t3[n3] << 24 - r2 % 32;
      return e3;
    }, wordsToBytes: function(t3) {
      for (var e3 = [], n3 = 0; n3 < 32 * t3.length; n3 += 8)
        e3.push(t3[n3 >>> 5] >>> 24 - n3 % 32 & 255);
      return e3;
    }, bytesToHex: function(t3) {
      for (var e3 = [], n3 = 0; n3 < t3.length; n3++)
        e3.push((t3[n3] >>> 4).toString(16)), e3.push((15 & t3[n3]).toString(16));
      return e3.join("");
    }, hexToBytes: function(t3) {
      for (var e3 = [], n3 = 0; n3 < t3.length; n3 += 2)
        e3.push(parseInt(t3.substr(n3, 2), 16));
      return e3;
    }, bytesToBase64: function(t3) {
      for (var n3 = [], r2 = 0; r2 < t3.length; r2 += 3)
        for (var o2 = t3[r2] << 16 | t3[r2 + 1] << 8 | t3[r2 + 2], i2 = 0; i2 < 4; i2++)
          8 * r2 + 6 * i2 <= 8 * t3.length ? n3.push(e2.charAt(o2 >>> 6 * (3 - i2) & 63)) : n3.push("=");
      return n3.join("");
    }, base64ToBytes: function(t3) {
      t3 = t3.replace(/[^A-Z0-9+\/]/gi, "");
      for (var n3 = [], r2 = 0, o2 = 0; r2 < t3.length; o2 = ++r2 % 4)
        0 != o2 && n3.push((e2.indexOf(t3.charAt(r2 - 1)) & Math.pow(2, -2 * o2 + 8) - 1) << 2 * o2 | e2.indexOf(t3.charAt(r2)) >>> 6 - 2 * o2);
      return n3;
    } }, t2.exports = n2;
  }, 635: (t2, e2, n2) => {
    const r2 = n2(31), o2 = n2(338), i2 = n2(221);
    t2.exports = { XMLParser: o2, XMLValidator: r2, XMLBuilder: i2 };
  }, 705: (t2, e2) => {
    const n2 = ":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD", r2 = "[" + n2 + "][" + n2 + "\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040]*", o2 = new RegExp("^" + r2 + "$");
    e2.isExist = function(t3) {
      return void 0 !== t3;
    }, e2.isEmptyObject = function(t3) {
      return 0 === Object.keys(t3).length;
    }, e2.merge = function(t3, e3, n3) {
      if (e3) {
        const r3 = Object.keys(e3), o3 = r3.length;
        for (let i2 = 0; i2 < o3; i2++)
          t3[r3[i2]] = "strict" === n3 ? [e3[r3[i2]]] : e3[r3[i2]];
      }
    }, e2.getValue = function(t3) {
      return e2.isExist(t3) ? t3 : "";
    }, e2.isName = function(t3) {
      return !(null == o2.exec(t3));
    }, e2.getAllMatches = function(t3, e3) {
      const n3 = [];
      let r3 = e3.exec(t3);
      for (; r3; ) {
        const o3 = [];
        o3.startIndex = e3.lastIndex - r3[0].length;
        const i2 = r3.length;
        for (let t4 = 0; t4 < i2; t4++)
          o3.push(r3[t4]);
        n3.push(o3), r3 = e3.exec(t3);
      }
      return n3;
    }, e2.nameRegexp = r2;
  }, 31: (t2, e2, n2) => {
    const r2 = n2(705), o2 = { allowBooleanAttributes: false, unpairedTags: [] };
    function i2(t3) {
      return " " === t3 || "	" === t3 || "\n" === t3 || "\r" === t3;
    }
    function s2(t3, e3) {
      const n3 = e3;
      for (; e3 < t3.length; e3++)
        if ("?" != t3[e3] && " " != t3[e3])
          ;
        else {
          const r3 = t3.substr(n3, e3 - n3);
          if (e3 > 5 && "xml" === r3)
            return d2("InvalidXml", "XML declaration allowed only at the start of the document.", m(t3, e3));
          if ("?" == t3[e3] && ">" == t3[e3 + 1]) {
            e3++;
            break;
          }
        }
      return e3;
    }
    function a2(t3, e3) {
      if (t3.length > e3 + 5 && "-" === t3[e3 + 1] && "-" === t3[e3 + 2]) {
        for (e3 += 3; e3 < t3.length; e3++)
          if ("-" === t3[e3] && "-" === t3[e3 + 1] && ">" === t3[e3 + 2]) {
            e3 += 2;
            break;
          }
      } else if (t3.length > e3 + 8 && "D" === t3[e3 + 1] && "O" === t3[e3 + 2] && "C" === t3[e3 + 3] && "T" === t3[e3 + 4] && "Y" === t3[e3 + 5] && "P" === t3[e3 + 6] && "E" === t3[e3 + 7]) {
        let n3 = 1;
        for (e3 += 8; e3 < t3.length; e3++)
          if ("<" === t3[e3])
            n3++;
          else if (">" === t3[e3] && (n3--, 0 === n3))
            break;
      } else if (t3.length > e3 + 9 && "[" === t3[e3 + 1] && "C" === t3[e3 + 2] && "D" === t3[e3 + 3] && "A" === t3[e3 + 4] && "T" === t3[e3 + 5] && "A" === t3[e3 + 6] && "[" === t3[e3 + 7]) {
        for (e3 += 8; e3 < t3.length; e3++)
          if ("]" === t3[e3] && "]" === t3[e3 + 1] && ">" === t3[e3 + 2]) {
            e3 += 2;
            break;
          }
      }
      return e3;
    }
    e2.validate = function(t3, e3) {
      e3 = Object.assign({}, o2, e3);
      const n3 = [];
      let c3 = false, u3 = false;
      "\uFEFF" === t3[0] && (t3 = t3.substr(1));
      for (let o3 = 0; o3 < t3.length; o3++)
        if ("<" === t3[o3] && "?" === t3[o3 + 1]) {
          if (o3 += 2, o3 = s2(t3, o3), o3.err)
            return o3;
        } else {
          if ("<" !== t3[o3]) {
            if (i2(t3[o3]))
              continue;
            return d2("InvalidChar", "char '" + t3[o3] + "' is not expected.", m(t3, o3));
          }
          {
            let g2 = o3;
            if (o3++, "!" === t3[o3]) {
              o3 = a2(t3, o3);
              continue;
            }
            {
              let v2 = false;
              "/" === t3[o3] && (v2 = true, o3++);
              let y = "";
              for (; o3 < t3.length && ">" !== t3[o3] && " " !== t3[o3] && "	" !== t3[o3] && "\n" !== t3[o3] && "\r" !== t3[o3]; o3++)
                y += t3[o3];
              if (y = y.trim(), "/" === y[y.length - 1] && (y = y.substring(0, y.length - 1), o3--), h3 = y, !r2.isName(h3)) {
                let e4;
                return e4 = 0 === y.trim().length ? "Invalid space after '<'." : "Tag '" + y + "' is an invalid name.", d2("InvalidTag", e4, m(t3, o3));
              }
              const b = l2(t3, o3);
              if (false === b)
                return d2("InvalidAttr", "Attributes for '" + y + "' have open quote.", m(t3, o3));
              let w = b.value;
              if (o3 = b.index, "/" === w[w.length - 1]) {
                const n4 = o3 - w.length;
                w = w.substring(0, w.length - 1);
                const r3 = p2(w, e3);
                if (true !== r3)
                  return d2(r3.err.code, r3.err.msg, m(t3, n4 + r3.err.line));
                c3 = true;
              } else if (v2) {
                if (!b.tagClosed)
                  return d2("InvalidTag", "Closing tag '" + y + "' doesn't have proper closing.", m(t3, o3));
                if (w.trim().length > 0)
                  return d2("InvalidTag", "Closing tag '" + y + "' can't have attributes or invalid starting.", m(t3, g2));
                {
                  const e4 = n3.pop();
                  if (y !== e4.tagName) {
                    let n4 = m(t3, e4.tagStartPos);
                    return d2("InvalidTag", "Expected closing tag '" + e4.tagName + "' (opened in line " + n4.line + ", col " + n4.col + ") instead of closing tag '" + y + "'.", m(t3, g2));
                  }
                  0 == n3.length && (u3 = true);
                }
              } else {
                const r3 = p2(w, e3);
                if (true !== r3)
                  return d2(r3.err.code, r3.err.msg, m(t3, o3 - w.length + r3.err.line));
                if (true === u3)
                  return d2("InvalidXml", "Multiple possible root nodes found.", m(t3, o3));
                -1 !== e3.unpairedTags.indexOf(y) || n3.push({ tagName: y, tagStartPos: g2 }), c3 = true;
              }
              for (o3++; o3 < t3.length; o3++)
                if ("<" === t3[o3]) {
                  if ("!" === t3[o3 + 1]) {
                    o3++, o3 = a2(t3, o3);
                    continue;
                  }
                  if ("?" !== t3[o3 + 1])
                    break;
                  if (o3 = s2(t3, ++o3), o3.err)
                    return o3;
                } else if ("&" === t3[o3]) {
                  const e4 = f2(t3, o3);
                  if (-1 == e4)
                    return d2("InvalidChar", "char '&' is not expected.", m(t3, o3));
                  o3 = e4;
                } else if (true === u3 && !i2(t3[o3]))
                  return d2("InvalidXml", "Extra text at the end", m(t3, o3));
              "<" === t3[o3] && o3--;
            }
          }
        }
      var h3;
      return c3 ? 1 == n3.length ? d2("InvalidTag", "Unclosed tag '" + n3[0].tagName + "'.", m(t3, n3[0].tagStartPos)) : !(n3.length > 0) || d2("InvalidXml", "Invalid '" + JSON.stringify(n3.map((t4) => t4.tagName), null, 4).replace(/\r?\n/g, "") + "' found.", { line: 1, col: 1 }) : d2("InvalidXml", "Start tag expected.", 1);
    };
    const c2 = '"', u2 = "'";
    function l2(t3, e3) {
      let n3 = "", r3 = "", o3 = false;
      for (; e3 < t3.length; e3++) {
        if (t3[e3] === c2 || t3[e3] === u2)
          "" === r3 ? r3 = t3[e3] : r3 !== t3[e3] || (r3 = "");
        else if (">" === t3[e3] && "" === r3) {
          o3 = true;
          break;
        }
        n3 += t3[e3];
      }
      return "" === r3 && { value: n3, index: e3, tagClosed: o3 };
    }
    const h2 = new RegExp(`(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['"])(([\\s\\S])*?)\\5)?`, "g");
    function p2(t3, e3) {
      const n3 = r2.getAllMatches(t3, h2), o3 = {};
      for (let t4 = 0; t4 < n3.length; t4++) {
        if (0 === n3[t4][1].length)
          return d2("InvalidAttr", "Attribute '" + n3[t4][2] + "' has no space in starting.", v(n3[t4]));
        if (void 0 !== n3[t4][3] && void 0 === n3[t4][4])
          return d2("InvalidAttr", "Attribute '" + n3[t4][2] + "' is without value.", v(n3[t4]));
        if (void 0 === n3[t4][3] && !e3.allowBooleanAttributes)
          return d2("InvalidAttr", "boolean attribute '" + n3[t4][2] + "' is not allowed.", v(n3[t4]));
        const r3 = n3[t4][2];
        if (!g(r3))
          return d2("InvalidAttr", "Attribute '" + r3 + "' is an invalid name.", v(n3[t4]));
        if (o3.hasOwnProperty(r3))
          return d2("InvalidAttr", "Attribute '" + r3 + "' is repeated.", v(n3[t4]));
        o3[r3] = 1;
      }
      return true;
    }
    function f2(t3, e3) {
      if (";" === t3[++e3])
        return -1;
      if ("#" === t3[e3])
        return function(t4, e4) {
          let n4 = /\d/;
          for ("x" === t4[e4] && (e4++, n4 = /[\da-fA-F]/); e4 < t4.length; e4++) {
            if (";" === t4[e4])
              return e4;
            if (!t4[e4].match(n4))
              break;
          }
          return -1;
        }(t3, ++e3);
      let n3 = 0;
      for (; e3 < t3.length; e3++, n3++)
        if (!(t3[e3].match(/\w/) && n3 < 20)) {
          if (";" === t3[e3])
            break;
          return -1;
        }
      return e3;
    }
    function d2(t3, e3, n3) {
      return { err: { code: t3, msg: e3, line: n3.line || n3, col: n3.col } };
    }
    function g(t3) {
      return r2.isName(t3);
    }
    function m(t3, e3) {
      const n3 = t3.substring(0, e3).split(/\r?\n/);
      return { line: n3.length, col: n3[n3.length - 1].length + 1 };
    }
    function v(t3) {
      return t3.startIndex + t3[1].length;
    }
  }, 221: (t2, e2, n2) => {
    const r2 = n2(87), o2 = { attributeNamePrefix: "@_", attributesGroupName: false, textNodeName: "#text", ignoreAttributes: true, cdataPropName: false, format: false, indentBy: "  ", suppressEmptyNode: false, suppressUnpairedNode: true, suppressBooleanAttributes: true, tagValueProcessor: function(t3, e3) {
      return e3;
    }, attributeValueProcessor: function(t3, e3) {
      return e3;
    }, preserveOrder: false, commentPropName: false, unpairedTags: [], entities: [{ regex: new RegExp("&", "g"), val: "&amp;" }, { regex: new RegExp(">", "g"), val: "&gt;" }, { regex: new RegExp("<", "g"), val: "&lt;" }, { regex: new RegExp("'", "g"), val: "&apos;" }, { regex: new RegExp('"', "g"), val: "&quot;" }], processEntities: true, stopNodes: [], oneListGroup: false };
    function i2(t3) {
      this.options = Object.assign({}, o2, t3), this.options.ignoreAttributes || this.options.attributesGroupName ? this.isAttribute = function() {
        return false;
      } : (this.attrPrefixLen = this.options.attributeNamePrefix.length, this.isAttribute = c2), this.processTextOrObjNode = s2, this.options.format ? (this.indentate = a2, this.tagEndChar = ">\n", this.newLine = "\n") : (this.indentate = function() {
        return "";
      }, this.tagEndChar = ">", this.newLine = "");
    }
    function s2(t3, e3, n3) {
      const r3 = this.j2x(t3, n3 + 1);
      return void 0 !== t3[this.options.textNodeName] && 1 === Object.keys(t3).length ? this.buildTextValNode(t3[this.options.textNodeName], e3, r3.attrStr, n3) : this.buildObjectNode(r3.val, e3, r3.attrStr, n3);
    }
    function a2(t3) {
      return this.options.indentBy.repeat(t3);
    }
    function c2(t3) {
      return !(!t3.startsWith(this.options.attributeNamePrefix) || t3 === this.options.textNodeName) && t3.substr(this.attrPrefixLen);
    }
    i2.prototype.build = function(t3) {
      return this.options.preserveOrder ? r2(t3, this.options) : (Array.isArray(t3) && this.options.arrayNodeName && this.options.arrayNodeName.length > 1 && (t3 = { [this.options.arrayNodeName]: t3 }), this.j2x(t3, 0).val);
    }, i2.prototype.j2x = function(t3, e3) {
      let n3 = "", r3 = "";
      for (let o3 in t3)
        if (void 0 === t3[o3])
          this.isAttribute(o3) && (r3 += "");
        else if (null === t3[o3])
          this.isAttribute(o3) ? r3 += "" : "?" === o3[0] ? r3 += this.indentate(e3) + "<" + o3 + "?" + this.tagEndChar : r3 += this.indentate(e3) + "<" + o3 + "/" + this.tagEndChar;
        else if (t3[o3] instanceof Date)
          r3 += this.buildTextValNode(t3[o3], o3, "", e3);
        else if ("object" != typeof t3[o3]) {
          const i3 = this.isAttribute(o3);
          if (i3)
            n3 += this.buildAttrPairStr(i3, "" + t3[o3]);
          else if (o3 === this.options.textNodeName) {
            let e4 = this.options.tagValueProcessor(o3, "" + t3[o3]);
            r3 += this.replaceEntitiesValue(e4);
          } else
            r3 += this.buildTextValNode(t3[o3], o3, "", e3);
        } else if (Array.isArray(t3[o3])) {
          const n4 = t3[o3].length;
          let i3 = "";
          for (let s3 = 0; s3 < n4; s3++) {
            const n5 = t3[o3][s3];
            void 0 === n5 || (null === n5 ? "?" === o3[0] ? r3 += this.indentate(e3) + "<" + o3 + "?" + this.tagEndChar : r3 += this.indentate(e3) + "<" + o3 + "/" + this.tagEndChar : "object" == typeof n5 ? this.options.oneListGroup ? i3 += this.j2x(n5, e3 + 1).val : i3 += this.processTextOrObjNode(n5, o3, e3) : i3 += this.buildTextValNode(n5, o3, "", e3));
          }
          this.options.oneListGroup && (i3 = this.buildObjectNode(i3, o3, "", e3)), r3 += i3;
        } else if (this.options.attributesGroupName && o3 === this.options.attributesGroupName) {
          const e4 = Object.keys(t3[o3]), r4 = e4.length;
          for (let i3 = 0; i3 < r4; i3++)
            n3 += this.buildAttrPairStr(e4[i3], "" + t3[o3][e4[i3]]);
        } else
          r3 += this.processTextOrObjNode(t3[o3], o3, e3);
      return { attrStr: n3, val: r3 };
    }, i2.prototype.buildAttrPairStr = function(t3, e3) {
      return e3 = this.options.attributeValueProcessor(t3, "" + e3), e3 = this.replaceEntitiesValue(e3), this.options.suppressBooleanAttributes && "true" === e3 ? " " + t3 : " " + t3 + '="' + e3 + '"';
    }, i2.prototype.buildObjectNode = function(t3, e3, n3, r3) {
      if ("" === t3)
        return "?" === e3[0] ? this.indentate(r3) + "<" + e3 + n3 + "?" + this.tagEndChar : this.indentate(r3) + "<" + e3 + n3 + this.closeTag(e3) + this.tagEndChar;
      {
        let o3 = "</" + e3 + this.tagEndChar, i3 = "";
        return "?" === e3[0] && (i3 = "?", o3 = ""), !n3 && "" !== n3 || -1 !== t3.indexOf("<") ? false !== this.options.commentPropName && e3 === this.options.commentPropName && 0 === i3.length ? this.indentate(r3) + "<!--".concat(t3, "-->") + this.newLine : this.indentate(r3) + "<" + e3 + n3 + i3 + this.tagEndChar + t3 + this.indentate(r3) + o3 : this.indentate(r3) + "<" + e3 + n3 + i3 + ">" + t3 + o3;
      }
    }, i2.prototype.closeTag = function(t3) {
      let e3 = "";
      return -1 !== this.options.unpairedTags.indexOf(t3) ? this.options.suppressUnpairedNode || (e3 = "/") : e3 = this.options.suppressEmptyNode ? "/" : "></".concat(t3), e3;
    }, i2.prototype.buildTextValNode = function(t3, e3, n3, r3) {
      if (false !== this.options.cdataPropName && e3 === this.options.cdataPropName)
        return this.indentate(r3) + "<![CDATA[".concat(t3, "]]>") + this.newLine;
      if (false !== this.options.commentPropName && e3 === this.options.commentPropName)
        return this.indentate(r3) + "<!--".concat(t3, "-->") + this.newLine;
      if ("?" === e3[0])
        return this.indentate(r3) + "<" + e3 + n3 + "?" + this.tagEndChar;
      {
        let o3 = this.options.tagValueProcessor(e3, t3);
        return o3 = this.replaceEntitiesValue(o3), "" === o3 ? this.indentate(r3) + "<" + e3 + n3 + this.closeTag(e3) + this.tagEndChar : this.indentate(r3) + "<" + e3 + n3 + ">" + o3 + "</" + e3 + this.tagEndChar;
      }
    }, i2.prototype.replaceEntitiesValue = function(t3) {
      if (t3 && t3.length > 0 && this.options.processEntities)
        for (let e3 = 0; e3 < this.options.entities.length; e3++) {
          const n3 = this.options.entities[e3];
          t3 = t3.replace(n3.regex, n3.val);
        }
      return t3;
    }, t2.exports = i2;
  }, 87: (t2) => {
    function e2(t3, s2, a2, c2) {
      let u2 = "", l2 = false;
      for (let h2 = 0; h2 < t3.length; h2++) {
        const p2 = t3[h2], f2 = n2(p2);
        let d2 = "";
        if (d2 = 0 === a2.length ? f2 : "".concat(a2, ".").concat(f2), f2 === s2.textNodeName) {
          let t4 = p2[f2];
          o2(d2, s2) || (t4 = s2.tagValueProcessor(f2, t4), t4 = i2(t4, s2)), l2 && (u2 += c2), u2 += t4, l2 = false;
          continue;
        }
        if (f2 === s2.cdataPropName) {
          l2 && (u2 += c2), u2 += "<![CDATA[".concat(p2[f2][0][s2.textNodeName], "]]>"), l2 = false;
          continue;
        }
        if (f2 === s2.commentPropName) {
          u2 += c2 + "<!--".concat(p2[f2][0][s2.textNodeName], "-->"), l2 = true;
          continue;
        }
        if ("?" === f2[0]) {
          const t4 = r2(p2[":@"], s2), e3 = "?xml" === f2 ? "" : c2;
          let n3 = p2[f2][0][s2.textNodeName];
          n3 = 0 !== n3.length ? " " + n3 : "", u2 += e3 + "<".concat(f2).concat(n3).concat(t4, "?>"), l2 = true;
          continue;
        }
        let g = c2;
        "" !== g && (g += s2.indentBy);
        const m = r2(p2[":@"], s2), v = c2 + "<".concat(f2).concat(m), y = e2(p2[f2], s2, d2, g);
        -1 !== s2.unpairedTags.indexOf(f2) ? s2.suppressUnpairedNode ? u2 += v + ">" : u2 += v + "/>" : y && 0 !== y.length || !s2.suppressEmptyNode ? y && y.endsWith(">") ? u2 += v + ">".concat(y).concat(c2, "</").concat(f2, ">") : (u2 += v + ">", y && "" !== c2 && (y.includes("/>") || y.includes("</")) ? u2 += c2 + s2.indentBy + y + c2 : u2 += y, u2 += "</".concat(f2, ">")) : u2 += v + "/>", l2 = true;
      }
      return u2;
    }
    function n2(t3) {
      const e3 = Object.keys(t3);
      for (let t4 = 0; t4 < e3.length; t4++) {
        const n3 = e3[t4];
        if (":@" !== n3)
          return n3;
      }
    }
    function r2(t3, e3) {
      let n3 = "";
      if (t3 && !e3.ignoreAttributes)
        for (let r3 in t3) {
          let o3 = e3.attributeValueProcessor(r3, t3[r3]);
          o3 = i2(o3, e3), true === o3 && e3.suppressBooleanAttributes ? n3 += " ".concat(r3.substr(e3.attributeNamePrefix.length)) : n3 += " ".concat(r3.substr(e3.attributeNamePrefix.length), '="').concat(o3, '"');
        }
      return n3;
    }
    function o2(t3, e3) {
      let n3 = (t3 = t3.substr(0, t3.length - e3.textNodeName.length - 1)).substr(t3.lastIndexOf(".") + 1);
      for (let r3 in e3.stopNodes)
        if (e3.stopNodes[r3] === t3 || e3.stopNodes[r3] === "*." + n3)
          return true;
      return false;
    }
    function i2(t3, e3) {
      if (t3 && t3.length > 0 && e3.processEntities)
        for (let n3 = 0; n3 < e3.entities.length; n3++) {
          const r3 = e3.entities[n3];
          t3 = t3.replace(r3.regex, r3.val);
        }
      return t3;
    }
    t2.exports = function(t3, n3) {
      let r3 = "";
      return n3.format && n3.indentBy.length > 0 && (r3 = "\n"), e2(t3, n3, "", r3);
    };
  }, 193: (t2, e2, n2) => {
    const r2 = n2(705);
    function o2(t3, e3) {
      let n3 = "";
      for (; e3 < t3.length && "'" !== t3[e3] && '"' !== t3[e3]; e3++)
        n3 += t3[e3];
      if (n3 = n3.trim(), -1 !== n3.indexOf(" "))
        throw new Error("External entites are not supported");
      const r3 = t3[e3++];
      let o3 = "";
      for (; e3 < t3.length && t3[e3] !== r3; e3++)
        o3 += t3[e3];
      return [n3, o3, e3];
    }
    function i2(t3, e3) {
      return "!" === t3[e3 + 1] && "-" === t3[e3 + 2] && "-" === t3[e3 + 3];
    }
    function s2(t3, e3) {
      return "!" === t3[e3 + 1] && "E" === t3[e3 + 2] && "N" === t3[e3 + 3] && "T" === t3[e3 + 4] && "I" === t3[e3 + 5] && "T" === t3[e3 + 6] && "Y" === t3[e3 + 7];
    }
    function a2(t3, e3) {
      return "!" === t3[e3 + 1] && "E" === t3[e3 + 2] && "L" === t3[e3 + 3] && "E" === t3[e3 + 4] && "M" === t3[e3 + 5] && "E" === t3[e3 + 6] && "N" === t3[e3 + 7] && "T" === t3[e3 + 8];
    }
    function c2(t3, e3) {
      return "!" === t3[e3 + 1] && "A" === t3[e3 + 2] && "T" === t3[e3 + 3] && "T" === t3[e3 + 4] && "L" === t3[e3 + 5] && "I" === t3[e3 + 6] && "S" === t3[e3 + 7] && "T" === t3[e3 + 8];
    }
    function u2(t3, e3) {
      return "!" === t3[e3 + 1] && "N" === t3[e3 + 2] && "O" === t3[e3 + 3] && "T" === t3[e3 + 4] && "A" === t3[e3 + 5] && "T" === t3[e3 + 6] && "I" === t3[e3 + 7] && "O" === t3[e3 + 8] && "N" === t3[e3 + 9];
    }
    function l2(t3) {
      if (r2.isName(t3))
        return t3;
      throw new Error("Invalid entity name ".concat(t3));
    }
    t2.exports = function(t3, e3) {
      const n3 = {};
      if ("O" !== t3[e3 + 3] || "C" !== t3[e3 + 4] || "T" !== t3[e3 + 5] || "Y" !== t3[e3 + 6] || "P" !== t3[e3 + 7] || "E" !== t3[e3 + 8])
        throw new Error("Invalid Tag instead of DOCTYPE");
      {
        e3 += 9;
        let r3 = 1, h2 = false, p2 = false, f2 = "";
        for (; e3 < t3.length; e3++)
          if ("<" !== t3[e3] || p2)
            if (">" === t3[e3]) {
              if (p2 ? "-" === t3[e3 - 1] && "-" === t3[e3 - 2] && (p2 = false, r3--) : r3--, 0 === r3)
                break;
            } else
              "[" === t3[e3] ? h2 = true : f2 += t3[e3];
          else {
            if (h2 && s2(t3, e3))
              e3 += 7, [entityName, val, e3] = o2(t3, e3 + 1), -1 === val.indexOf("&") && (n3[l2(entityName)] = { regx: RegExp("&".concat(entityName, ";"), "g"), val });
            else if (h2 && a2(t3, e3))
              e3 += 8;
            else if (h2 && c2(t3, e3))
              e3 += 8;
            else if (h2 && u2(t3, e3))
              e3 += 9;
            else {
              if (!i2)
                throw new Error("Invalid DOCTYPE");
              p2 = true;
            }
            r3++, f2 = "";
          }
        if (0 !== r3)
          throw new Error("Unclosed DOCTYPE");
      }
      return { entities: n3, i: e3 };
    };
  }, 63: (t2, e2) => {
    const n2 = { preserveOrder: false, attributeNamePrefix: "@_", attributesGroupName: false, textNodeName: "#text", ignoreAttributes: true, removeNSPrefix: false, allowBooleanAttributes: false, parseTagValue: true, parseAttributeValue: false, trimValues: true, cdataPropName: false, numberParseOptions: { hex: true, leadingZeros: true, eNotation: true }, tagValueProcessor: function(t3, e3) {
      return e3;
    }, attributeValueProcessor: function(t3, e3) {
      return e3;
    }, stopNodes: [], alwaysCreateTextNode: false, isArray: () => false, commentPropName: false, unpairedTags: [], processEntities: true, htmlEntities: false, ignoreDeclaration: false, ignorePiTags: false, transformTagName: false, transformAttributeName: false, updateTag: function(t3, e3, n3) {
      return t3;
    } };
    e2.buildOptions = function(t3) {
      return Object.assign({}, n2, t3);
    }, e2.defaultOptions = n2;
  }, 299: (t2, e2, n2) => {
    const r2 = n2(705), o2 = n2(365), i2 = n2(193), s2 = n2(494);
    function a2(t3) {
      const e3 = Object.keys(t3);
      for (let n3 = 0; n3 < e3.length; n3++) {
        const r3 = e3[n3];
        this.lastEntities[r3] = { regex: new RegExp("&" + r3 + ";", "g"), val: t3[r3] };
      }
    }
    function c2(t3, e3, n3, r3, o3, i3, s3) {
      if (void 0 !== t3 && (this.options.trimValues && !r3 && (t3 = t3.trim()), t3.length > 0)) {
        s3 || (t3 = this.replaceEntitiesValue(t3));
        const r4 = this.options.tagValueProcessor(e3, t3, n3, o3, i3);
        return null == r4 ? t3 : typeof r4 != typeof t3 || r4 !== t3 ? r4 : this.options.trimValues || t3.trim() === t3 ? w(t3, this.options.parseTagValue, this.options.numberParseOptions) : t3;
      }
    }
    function u2(t3) {
      if (this.options.removeNSPrefix) {
        const e3 = t3.split(":"), n3 = "/" === t3.charAt(0) ? "/" : "";
        if ("xmlns" === e3[0])
          return "";
        2 === e3.length && (t3 = n3 + e3[1]);
      }
      return t3;
    }
    "<((!\\[CDATA\\[([\\s\\S]*?)(]]>))|((NAME:)?(NAME))([^>]*)>|((\\/)(NAME)\\s*>))([^<]*)".replace(/NAME/g, r2.nameRegexp);
    const l2 = new RegExp(`([^\\s=]+)\\s*(=\\s*(['"])([\\s\\S]*?)\\3)?`, "gm");
    function h2(t3, e3, n3) {
      if (!this.options.ignoreAttributes && "string" == typeof t3) {
        const n4 = r2.getAllMatches(t3, l2), o3 = n4.length, i3 = {};
        for (let t4 = 0; t4 < o3; t4++) {
          const r3 = this.resolveNameSpace(n4[t4][1]);
          let o4 = n4[t4][4], s3 = this.options.attributeNamePrefix + r3;
          if (r3.length)
            if (this.options.transformAttributeName && (s3 = this.options.transformAttributeName(s3)), "__proto__" === s3 && (s3 = "#__proto__"), void 0 !== o4) {
              this.options.trimValues && (o4 = o4.trim()), o4 = this.replaceEntitiesValue(o4);
              const t5 = this.options.attributeValueProcessor(r3, o4, e3);
              i3[s3] = null == t5 ? o4 : typeof t5 != typeof o4 || t5 !== o4 ? t5 : w(o4, this.options.parseAttributeValue, this.options.numberParseOptions);
            } else
              this.options.allowBooleanAttributes && (i3[s3] = true);
        }
        if (!Object.keys(i3).length)
          return;
        if (this.options.attributesGroupName) {
          const t4 = {};
          return t4[this.options.attributesGroupName] = i3, t4;
        }
        return i3;
      }
    }
    const p2 = function(t3) {
      t3 = t3.replace(/\r\n?/g, "\n");
      const e3 = new o2("!xml");
      let n3 = e3, r3 = "", s3 = "";
      for (let a3 = 0; a3 < t3.length; a3++)
        if ("<" === t3[a3])
          if ("/" === t3[a3 + 1]) {
            const e4 = v(t3, ">", a3, "Closing Tag is not closed.");
            let o3 = t3.substring(a3 + 2, e4).trim();
            if (this.options.removeNSPrefix) {
              const t4 = o3.indexOf(":");
              -1 !== t4 && (o3 = o3.substr(t4 + 1));
            }
            this.options.transformTagName && (o3 = this.options.transformTagName(o3)), n3 && (r3 = this.saveTextToParentTag(r3, n3, s3));
            const i3 = s3.substring(s3.lastIndexOf(".") + 1);
            if (o3 && -1 !== this.options.unpairedTags.indexOf(o3))
              throw new Error("Unpaired tag can not be used as closing tag: </".concat(o3, ">"));
            let c3 = 0;
            i3 && -1 !== this.options.unpairedTags.indexOf(i3) ? (c3 = s3.lastIndexOf(".", s3.lastIndexOf(".") - 1), this.tagsNodeStack.pop()) : c3 = s3.lastIndexOf("."), s3 = s3.substring(0, c3), n3 = this.tagsNodeStack.pop(), r3 = "", a3 = e4;
          } else if ("?" === t3[a3 + 1]) {
            let e4 = y(t3, a3, false, "?>");
            if (!e4)
              throw new Error("Pi Tag is not closed.");
            if (r3 = this.saveTextToParentTag(r3, n3, s3), this.options.ignoreDeclaration && "?xml" === e4.tagName || this.options.ignorePiTags)
              ;
            else {
              const t4 = new o2(e4.tagName);
              t4.add(this.options.textNodeName, ""), e4.tagName !== e4.tagExp && e4.attrExpPresent && (t4[":@"] = this.buildAttributesMap(e4.tagExp, s3, e4.tagName)), this.addChild(n3, t4, s3);
            }
            a3 = e4.closeIndex + 1;
          } else if ("!--" === t3.substr(a3 + 1, 3)) {
            const e4 = v(t3, "-->", a3 + 4, "Comment is not closed.");
            if (this.options.commentPropName) {
              const o3 = t3.substring(a3 + 4, e4 - 2);
              r3 = this.saveTextToParentTag(r3, n3, s3), n3.add(this.options.commentPropName, [{ [this.options.textNodeName]: o3 }]);
            }
            a3 = e4;
          } else if ("!D" === t3.substr(a3 + 1, 2)) {
            const e4 = i2(t3, a3);
            this.docTypeEntities = e4.entities, a3 = e4.i;
          } else if ("![" === t3.substr(a3 + 1, 2)) {
            const e4 = v(t3, "]]>", a3, "CDATA is not closed.") - 2, o3 = t3.substring(a3 + 9, e4);
            if (r3 = this.saveTextToParentTag(r3, n3, s3), this.options.cdataPropName)
              n3.add(this.options.cdataPropName, [{ [this.options.textNodeName]: o3 }]);
            else {
              let t4 = this.parseTextData(o3, n3.tagname, s3, true, false, true);
              null == t4 && (t4 = ""), n3.add(this.options.textNodeName, t4);
            }
            a3 = e4 + 2;
          } else {
            let i3 = y(t3, a3, this.options.removeNSPrefix), c3 = i3.tagName, u3 = i3.tagExp, l3 = i3.attrExpPresent, h3 = i3.closeIndex;
            this.options.transformTagName && (c3 = this.options.transformTagName(c3)), n3 && r3 && "!xml" !== n3.tagname && (r3 = this.saveTextToParentTag(r3, n3, s3, false));
            const p3 = n3;
            if (p3 && -1 !== this.options.unpairedTags.indexOf(p3.tagname) && (n3 = this.tagsNodeStack.pop(), s3 = s3.substring(0, s3.lastIndexOf("."))), c3 !== e3.tagname && (s3 += s3 ? "." + c3 : c3), this.isItStopNode(this.options.stopNodes, s3, c3)) {
              let e4 = "";
              if (u3.length > 0 && u3.lastIndexOf("/") === u3.length - 1)
                a3 = i3.closeIndex;
              else if (-1 !== this.options.unpairedTags.indexOf(c3))
                a3 = i3.closeIndex;
              else {
                const n4 = this.readStopNodeData(t3, c3, h3 + 1);
                if (!n4)
                  throw new Error("Unexpected end of ".concat(c3));
                a3 = n4.i, e4 = n4.tagContent;
              }
              const r4 = new o2(c3);
              c3 !== u3 && l3 && (r4[":@"] = this.buildAttributesMap(u3, s3, c3)), e4 && (e4 = this.parseTextData(e4, c3, s3, true, l3, true, true)), s3 = s3.substr(0, s3.lastIndexOf(".")), r4.add(this.options.textNodeName, e4), this.addChild(n3, r4, s3);
            } else {
              if (u3.length > 0 && u3.lastIndexOf("/") === u3.length - 1) {
                "/" === c3[c3.length - 1] ? (c3 = c3.substr(0, c3.length - 1), s3 = s3.substr(0, s3.length - 1), u3 = c3) : u3 = u3.substr(0, u3.length - 1), this.options.transformTagName && (c3 = this.options.transformTagName(c3));
                const t4 = new o2(c3);
                c3 !== u3 && l3 && (t4[":@"] = this.buildAttributesMap(u3, s3, c3)), this.addChild(n3, t4, s3), s3 = s3.substr(0, s3.lastIndexOf("."));
              } else {
                const t4 = new o2(c3);
                this.tagsNodeStack.push(n3), c3 !== u3 && l3 && (t4[":@"] = this.buildAttributesMap(u3, s3, c3)), this.addChild(n3, t4, s3), n3 = t4;
              }
              r3 = "", a3 = h3;
            }
          }
        else
          r3 += t3[a3];
      return e3.child;
    };
    function f2(t3, e3, n3) {
      const r3 = this.options.updateTag(e3.tagname, n3, e3[":@"]);
      false === r3 || ("string" == typeof r3 ? (e3.tagname = r3, t3.addChild(e3)) : t3.addChild(e3));
    }
    const d2 = function(t3) {
      if (this.options.processEntities) {
        for (let e3 in this.docTypeEntities) {
          const n3 = this.docTypeEntities[e3];
          t3 = t3.replace(n3.regx, n3.val);
        }
        for (let e3 in this.lastEntities) {
          const n3 = this.lastEntities[e3];
          t3 = t3.replace(n3.regex, n3.val);
        }
        if (this.options.htmlEntities)
          for (let e3 in this.htmlEntities) {
            const n3 = this.htmlEntities[e3];
            t3 = t3.replace(n3.regex, n3.val);
          }
        t3 = t3.replace(this.ampEntity.regex, this.ampEntity.val);
      }
      return t3;
    };
    function g(t3, e3, n3, r3) {
      return t3 && (void 0 === r3 && (r3 = 0 === Object.keys(e3.child).length), void 0 !== (t3 = this.parseTextData(t3, e3.tagname, n3, false, !!e3[":@"] && 0 !== Object.keys(e3[":@"]).length, r3)) && "" !== t3 && e3.add(this.options.textNodeName, t3), t3 = ""), t3;
    }
    function m(t3, e3, n3) {
      const r3 = "*." + n3;
      for (const n4 in t3) {
        const o3 = t3[n4];
        if (r3 === o3 || e3 === o3)
          return true;
      }
      return false;
    }
    function v(t3, e3, n3, r3) {
      const o3 = t3.indexOf(e3, n3);
      if (-1 === o3)
        throw new Error(r3);
      return o3 + e3.length - 1;
    }
    function y(t3, e3, n3) {
      const r3 = function(t4, e4) {
        let n4, r4 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : ">", o4 = "";
        for (let i4 = e4; i4 < t4.length; i4++) {
          let e5 = t4[i4];
          if (n4)
            e5 === n4 && (n4 = "");
          else if ('"' === e5 || "'" === e5)
            n4 = e5;
          else if (e5 === r4[0]) {
            if (!r4[1])
              return { data: o4, index: i4 };
            if (t4[i4 + 1] === r4[1])
              return { data: o4, index: i4 };
          } else
            "	" === e5 && (e5 = " ");
          o4 += e5;
        }
      }(t3, e3 + 1, arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : ">");
      if (!r3)
        return;
      let o3 = r3.data;
      const i3 = r3.index, s3 = o3.search(/\s/);
      let a3 = o3, c3 = true;
      if (-1 !== s3 && (a3 = o3.substr(0, s3).replace(/\s\s*$/, ""), o3 = o3.substr(s3 + 1)), n3) {
        const t4 = a3.indexOf(":");
        -1 !== t4 && (a3 = a3.substr(t4 + 1), c3 = a3 !== r3.data.substr(t4 + 1));
      }
      return { tagName: a3, tagExp: o3, closeIndex: i3, attrExpPresent: c3 };
    }
    function b(t3, e3, n3) {
      const r3 = n3;
      let o3 = 1;
      for (; n3 < t3.length; n3++)
        if ("<" === t3[n3])
          if ("/" === t3[n3 + 1]) {
            const i3 = v(t3, ">", n3, "".concat(e3, " is not closed"));
            if (t3.substring(n3 + 2, i3).trim() === e3 && (o3--, 0 === o3))
              return { tagContent: t3.substring(r3, n3), i: i3 };
            n3 = i3;
          } else if ("?" === t3[n3 + 1])
            n3 = v(t3, "?>", n3 + 1, "StopNode is not closed.");
          else if ("!--" === t3.substr(n3 + 1, 3))
            n3 = v(t3, "-->", n3 + 3, "StopNode is not closed.");
          else if ("![" === t3.substr(n3 + 1, 2))
            n3 = v(t3, "]]>", n3, "StopNode is not closed.") - 2;
          else {
            const r4 = y(t3, n3, ">");
            r4 && ((r4 && r4.tagName) === e3 && "/" !== r4.tagExp[r4.tagExp.length - 1] && o3++, n3 = r4.closeIndex);
          }
    }
    function w(t3, e3, n3) {
      if (e3 && "string" == typeof t3) {
        const e4 = t3.trim();
        return "true" === e4 || "false" !== e4 && s2(t3, n3);
      }
      return r2.isExist(t3) ? t3 : "";
    }
    t2.exports = class {
      constructor(t3) {
        this.options = t3, this.currentNode = null, this.tagsNodeStack = [], this.docTypeEntities = {}, this.lastEntities = { apos: { regex: /&(apos|#39|#x27);/g, val: "'" }, gt: { regex: /&(gt|#62|#x3E);/g, val: ">" }, lt: { regex: /&(lt|#60|#x3C);/g, val: "<" }, quot: { regex: /&(quot|#34|#x22);/g, val: '"' } }, this.ampEntity = { regex: /&(amp|#38|#x26);/g, val: "&" }, this.htmlEntities = { space: { regex: /&(nbsp|#160);/g, val: " " }, cent: { regex: /&(cent|#162);/g, val: "¢" }, pound: { regex: /&(pound|#163);/g, val: "£" }, yen: { regex: /&(yen|#165);/g, val: "¥" }, euro: { regex: /&(euro|#8364);/g, val: "€" }, copyright: { regex: /&(copy|#169);/g, val: "©" }, reg: { regex: /&(reg|#174);/g, val: "®" }, inr: { regex: /&(inr|#8377);/g, val: "₹" } }, this.addExternalEntities = a2, this.parseXml = p2, this.parseTextData = c2, this.resolveNameSpace = u2, this.buildAttributesMap = h2, this.isItStopNode = m, this.replaceEntitiesValue = d2, this.readStopNodeData = b, this.saveTextToParentTag = g, this.addChild = f2;
      }
    };
  }, 338: (t2, e2, n2) => {
    const { buildOptions: r2 } = n2(63), o2 = n2(299), { prettify: i2 } = n2(728), s2 = n2(31);
    t2.exports = class {
      constructor(t3) {
        this.externalEntities = {}, this.options = r2(t3);
      }
      parse(t3, e3) {
        if ("string" == typeof t3)
          ;
        else {
          if (!t3.toString)
            throw new Error("XML data is accepted in String or Bytes[] form.");
          t3 = t3.toString();
        }
        if (e3) {
          true === e3 && (e3 = {});
          const n4 = s2.validate(t3, e3);
          if (true !== n4)
            throw Error("".concat(n4.err.msg, ":").concat(n4.err.line, ":").concat(n4.err.col));
        }
        const n3 = new o2(this.options);
        n3.addExternalEntities(this.externalEntities);
        const r3 = n3.parseXml(t3);
        return this.options.preserveOrder || void 0 === r3 ? r3 : i2(r3, this.options);
      }
      addEntity(t3, e3) {
        if (-1 !== e3.indexOf("&"))
          throw new Error("Entity value can't have '&'");
        if (-1 !== t3.indexOf("&") || -1 !== t3.indexOf(";"))
          throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'");
        if ("&" === e3)
          throw new Error("An entity with value '&' is not permitted");
        this.externalEntities[t3] = e3;
      }
    };
  }, 728: (t2, e2) => {
    function n2(t3, e3, s2) {
      let a2;
      const c2 = {};
      for (let u2 = 0; u2 < t3.length; u2++) {
        const l2 = t3[u2], h2 = r2(l2);
        let p2 = "";
        if (p2 = void 0 === s2 ? h2 : s2 + "." + h2, h2 === e3.textNodeName)
          void 0 === a2 ? a2 = l2[h2] : a2 += "" + l2[h2];
        else {
          if (void 0 === h2)
            continue;
          if (l2[h2]) {
            let t4 = n2(l2[h2], e3, p2);
            const r3 = i2(t4, e3);
            l2[":@"] ? o2(t4, l2[":@"], p2, e3) : 1 !== Object.keys(t4).length || void 0 === t4[e3.textNodeName] || e3.alwaysCreateTextNode ? 0 === Object.keys(t4).length && (e3.alwaysCreateTextNode ? t4[e3.textNodeName] = "" : t4 = "") : t4 = t4[e3.textNodeName], void 0 !== c2[h2] && c2.hasOwnProperty(h2) ? (Array.isArray(c2[h2]) || (c2[h2] = [c2[h2]]), c2[h2].push(t4)) : e3.isArray(h2, p2, r3) ? c2[h2] = [t4] : c2[h2] = t4;
          }
        }
      }
      return "string" == typeof a2 ? a2.length > 0 && (c2[e3.textNodeName] = a2) : void 0 !== a2 && (c2[e3.textNodeName] = a2), c2;
    }
    function r2(t3) {
      const e3 = Object.keys(t3);
      for (let t4 = 0; t4 < e3.length; t4++) {
        const n3 = e3[t4];
        if (":@" !== n3)
          return n3;
      }
    }
    function o2(t3, e3, n3, r3) {
      if (e3) {
        const o3 = Object.keys(e3), i3 = o3.length;
        for (let s2 = 0; s2 < i3; s2++) {
          const i4 = o3[s2];
          r3.isArray(i4, n3 + "." + i4, true, true) ? t3[i4] = [e3[i4]] : t3[i4] = e3[i4];
        }
      }
    }
    function i2(t3, e3) {
      const { textNodeName: n3 } = e3, r3 = Object.keys(t3).length;
      return 0 === r3 || !(1 !== r3 || !t3[n3] && "boolean" != typeof t3[n3] && 0 !== t3[n3]);
    }
    e2.prettify = function(t3, e3) {
      return n2(t3, e3);
    };
  }, 365: (t2) => {
    t2.exports = class {
      constructor(t3) {
        this.tagname = t3, this.child = [], this[":@"] = {};
      }
      add(t3, e2) {
        "__proto__" === t3 && (t3 = "#__proto__"), this.child.push({ [t3]: e2 });
      }
      addChild(t3) {
        "__proto__" === t3.tagname && (t3.tagname = "#__proto__"), t3[":@"] && Object.keys(t3[":@"]).length > 0 ? this.child.push({ [t3.tagname]: t3.child, ":@": t3[":@"] }) : this.child.push({ [t3.tagname]: t3.child });
      }
    };
  }, 135: (t2) => {
    function e2(t3) {
      return !!t3.constructor && "function" == typeof t3.constructor.isBuffer && t3.constructor.isBuffer(t3);
    }
    t2.exports = function(t3) {
      return null != t3 && (e2(t3) || function(t4) {
        return "function" == typeof t4.readFloatLE && "function" == typeof t4.slice && e2(t4.slice(0, 0));
      }(t3) || !!t3._isBuffer);
    };
  }, 542: (t2, e2, n2) => {
    var r2, o2, i2, s2, a2;
    r2 = n2(298), o2 = n2(526).utf8, i2 = n2(135), s2 = n2(526).bin, (a2 = function(t3, e3) {
      t3.constructor == String ? t3 = e3 && "binary" === e3.encoding ? s2.stringToBytes(t3) : o2.stringToBytes(t3) : i2(t3) ? t3 = Array.prototype.slice.call(t3, 0) : Array.isArray(t3) || t3.constructor === Uint8Array || (t3 = t3.toString());
      for (var n3 = r2.bytesToWords(t3), c2 = 8 * t3.length, u2 = 1732584193, l2 = -271733879, h2 = -1732584194, p2 = 271733878, f2 = 0; f2 < n3.length; f2++)
        n3[f2] = 16711935 & (n3[f2] << 8 | n3[f2] >>> 24) | 4278255360 & (n3[f2] << 24 | n3[f2] >>> 8);
      n3[c2 >>> 5] |= 128 << c2 % 32, n3[14 + (c2 + 64 >>> 9 << 4)] = c2;
      var d2 = a2._ff, g = a2._gg, m = a2._hh, v = a2._ii;
      for (f2 = 0; f2 < n3.length; f2 += 16) {
        var y = u2, b = l2, w = h2, x = p2;
        u2 = d2(u2, l2, h2, p2, n3[f2 + 0], 7, -680876936), p2 = d2(p2, u2, l2, h2, n3[f2 + 1], 12, -389564586), h2 = d2(h2, p2, u2, l2, n3[f2 + 2], 17, 606105819), l2 = d2(l2, h2, p2, u2, n3[f2 + 3], 22, -1044525330), u2 = d2(u2, l2, h2, p2, n3[f2 + 4], 7, -176418897), p2 = d2(p2, u2, l2, h2, n3[f2 + 5], 12, 1200080426), h2 = d2(h2, p2, u2, l2, n3[f2 + 6], 17, -1473231341), l2 = d2(l2, h2, p2, u2, n3[f2 + 7], 22, -45705983), u2 = d2(u2, l2, h2, p2, n3[f2 + 8], 7, 1770035416), p2 = d2(p2, u2, l2, h2, n3[f2 + 9], 12, -1958414417), h2 = d2(h2, p2, u2, l2, n3[f2 + 10], 17, -42063), l2 = d2(l2, h2, p2, u2, n3[f2 + 11], 22, -1990404162), u2 = d2(u2, l2, h2, p2, n3[f2 + 12], 7, 1804603682), p2 = d2(p2, u2, l2, h2, n3[f2 + 13], 12, -40341101), h2 = d2(h2, p2, u2, l2, n3[f2 + 14], 17, -1502002290), u2 = g(u2, l2 = d2(l2, h2, p2, u2, n3[f2 + 15], 22, 1236535329), h2, p2, n3[f2 + 1], 5, -165796510), p2 = g(p2, u2, l2, h2, n3[f2 + 6], 9, -1069501632), h2 = g(h2, p2, u2, l2, n3[f2 + 11], 14, 643717713), l2 = g(l2, h2, p2, u2, n3[f2 + 0], 20, -373897302), u2 = g(u2, l2, h2, p2, n3[f2 + 5], 5, -701558691), p2 = g(p2, u2, l2, h2, n3[f2 + 10], 9, 38016083), h2 = g(h2, p2, u2, l2, n3[f2 + 15], 14, -660478335), l2 = g(l2, h2, p2, u2, n3[f2 + 4], 20, -405537848), u2 = g(u2, l2, h2, p2, n3[f2 + 9], 5, 568446438), p2 = g(p2, u2, l2, h2, n3[f2 + 14], 9, -1019803690), h2 = g(h2, p2, u2, l2, n3[f2 + 3], 14, -187363961), l2 = g(l2, h2, p2, u2, n3[f2 + 8], 20, 1163531501), u2 = g(u2, l2, h2, p2, n3[f2 + 13], 5, -1444681467), p2 = g(p2, u2, l2, h2, n3[f2 + 2], 9, -51403784), h2 = g(h2, p2, u2, l2, n3[f2 + 7], 14, 1735328473), u2 = m(u2, l2 = g(l2, h2, p2, u2, n3[f2 + 12], 20, -1926607734), h2, p2, n3[f2 + 5], 4, -378558), p2 = m(p2, u2, l2, h2, n3[f2 + 8], 11, -2022574463), h2 = m(h2, p2, u2, l2, n3[f2 + 11], 16, 1839030562), l2 = m(l2, h2, p2, u2, n3[f2 + 14], 23, -35309556), u2 = m(u2, l2, h2, p2, n3[f2 + 1], 4, -1530992060), p2 = m(p2, u2, l2, h2, n3[f2 + 4], 11, 1272893353), h2 = m(h2, p2, u2, l2, n3[f2 + 7], 16, -155497632), l2 = m(l2, h2, p2, u2, n3[f2 + 10], 23, -1094730640), u2 = m(u2, l2, h2, p2, n3[f2 + 13], 4, 681279174), p2 = m(p2, u2, l2, h2, n3[f2 + 0], 11, -358537222), h2 = m(h2, p2, u2, l2, n3[f2 + 3], 16, -722521979), l2 = m(l2, h2, p2, u2, n3[f2 + 6], 23, 76029189), u2 = m(u2, l2, h2, p2, n3[f2 + 9], 4, -640364487), p2 = m(p2, u2, l2, h2, n3[f2 + 12], 11, -421815835), h2 = m(h2, p2, u2, l2, n3[f2 + 15], 16, 530742520), u2 = v(u2, l2 = m(l2, h2, p2, u2, n3[f2 + 2], 23, -995338651), h2, p2, n3[f2 + 0], 6, -198630844), p2 = v(p2, u2, l2, h2, n3[f2 + 7], 10, 1126891415), h2 = v(h2, p2, u2, l2, n3[f2 + 14], 15, -1416354905), l2 = v(l2, h2, p2, u2, n3[f2 + 5], 21, -57434055), u2 = v(u2, l2, h2, p2, n3[f2 + 12], 6, 1700485571), p2 = v(p2, u2, l2, h2, n3[f2 + 3], 10, -1894986606), h2 = v(h2, p2, u2, l2, n3[f2 + 10], 15, -1051523), l2 = v(l2, h2, p2, u2, n3[f2 + 1], 21, -2054922799), u2 = v(u2, l2, h2, p2, n3[f2 + 8], 6, 1873313359), p2 = v(p2, u2, l2, h2, n3[f2 + 15], 10, -30611744), h2 = v(h2, p2, u2, l2, n3[f2 + 6], 15, -1560198380), l2 = v(l2, h2, p2, u2, n3[f2 + 13], 21, 1309151649), u2 = v(u2, l2, h2, p2, n3[f2 + 4], 6, -145523070), p2 = v(p2, u2, l2, h2, n3[f2 + 11], 10, -1120210379), h2 = v(h2, p2, u2, l2, n3[f2 + 2], 15, 718787259), l2 = v(l2, h2, p2, u2, n3[f2 + 9], 21, -343485551), u2 = u2 + y >>> 0, l2 = l2 + b >>> 0, h2 = h2 + w >>> 0, p2 = p2 + x >>> 0;
      }
      return r2.endian([u2, l2, h2, p2]);
    })._ff = function(t3, e3, n3, r3, o3, i3, s3) {
      var a3 = t3 + (e3 & n3 | ~e3 & r3) + (o3 >>> 0) + s3;
      return (a3 << i3 | a3 >>> 32 - i3) + e3;
    }, a2._gg = function(t3, e3, n3, r3, o3, i3, s3) {
      var a3 = t3 + (e3 & r3 | n3 & ~r3) + (o3 >>> 0) + s3;
      return (a3 << i3 | a3 >>> 32 - i3) + e3;
    }, a2._hh = function(t3, e3, n3, r3, o3, i3, s3) {
      var a3 = t3 + (e3 ^ n3 ^ r3) + (o3 >>> 0) + s3;
      return (a3 << i3 | a3 >>> 32 - i3) + e3;
    }, a2._ii = function(t3, e3, n3, r3, o3, i3, s3) {
      var a3 = t3 + (n3 ^ (e3 | ~r3)) + (o3 >>> 0) + s3;
      return (a3 << i3 | a3 >>> 32 - i3) + e3;
    }, a2._blocksize = 16, a2._digestsize = 16, t2.exports = function(t3, e3) {
      if (null == t3)
        throw new Error("Illegal argument " + t3);
      var n3 = r2.wordsToBytes(a2(t3, e3));
      return e3 && e3.asBytes ? n3 : e3 && e3.asString ? s2.bytesToString(n3) : r2.bytesToHex(n3);
    };
  }, 285: (t2, e2, n2) => {
    var r2 = n2(2);
    t2.exports = function(t3) {
      return t3 ? ("{}" === t3.substr(0, 2) && (t3 = "\\{\\}" + t3.substr(2)), m(function(t4) {
        return t4.split("\\\\").join(o2).split("\\{").join(i2).split("\\}").join(s2).split("\\,").join(a2).split("\\.").join(c2);
      }(t3), true).map(l2)) : [];
    };
    var o2 = "\0SLASH" + Math.random() + "\0", i2 = "\0OPEN" + Math.random() + "\0", s2 = "\0CLOSE" + Math.random() + "\0", a2 = "\0COMMA" + Math.random() + "\0", c2 = "\0PERIOD" + Math.random() + "\0";
    function u2(t3) {
      return parseInt(t3, 10) == t3 ? parseInt(t3, 10) : t3.charCodeAt(0);
    }
    function l2(t3) {
      return t3.split(o2).join("\\").split(i2).join("{").split(s2).join("}").split(a2).join(",").split(c2).join(".");
    }
    function h2(t3) {
      if (!t3)
        return [""];
      var e3 = [], n3 = r2("{", "}", t3);
      if (!n3)
        return t3.split(",");
      var o3 = n3.pre, i3 = n3.body, s3 = n3.post, a3 = o3.split(",");
      a3[a3.length - 1] += "{" + i3 + "}";
      var c3 = h2(s3);
      return s3.length && (a3[a3.length - 1] += c3.shift(), a3.push.apply(a3, c3)), e3.push.apply(e3, a3), e3;
    }
    function p2(t3) {
      return "{" + t3 + "}";
    }
    function f2(t3) {
      return /^-?0\d/.test(t3);
    }
    function d2(t3, e3) {
      return t3 <= e3;
    }
    function g(t3, e3) {
      return t3 >= e3;
    }
    function m(t3, e3) {
      var n3 = [], o3 = r2("{", "}", t3);
      if (!o3)
        return [t3];
      var i3 = o3.pre, a3 = o3.post.length ? m(o3.post, false) : [""];
      if (/\$$/.test(o3.pre))
        for (var c3 = 0; c3 < a3.length; c3++) {
          var l3 = i3 + "{" + o3.body + "}" + a3[c3];
          n3.push(l3);
        }
      else {
        var v, y, b = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(o3.body), w = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(o3.body), x = b || w, N = o3.body.indexOf(",") >= 0;
        if (!x && !N)
          return o3.post.match(/,.*\}/) ? m(t3 = o3.pre + "{" + o3.body + s2 + o3.post) : [t3];
        if (x)
          v = o3.body.split(/\.\./);
        else if (1 === (v = h2(o3.body)).length && 1 === (v = m(v[0], false).map(p2)).length)
          return a3.map(function(t4) {
            return o3.pre + v[0] + t4;
          });
        if (x) {
          var P = u2(v[0]), A = u2(v[1]), O = Math.max(v[0].length, v[1].length), E = 3 == v.length ? Math.abs(u2(v[2])) : 1, T = d2;
          A < P && (E *= -1, T = g);
          var j = v.some(f2);
          y = [];
          for (var C = P; T(C, A); C += E) {
            var S;
            if (w)
              "\\" === (S = String.fromCharCode(C)) && (S = "");
            else if (S = String(C), j) {
              var I = O - S.length;
              if (I > 0) {
                var k = new Array(I + 1).join("0");
                S = C < 0 ? "-" + k + S.slice(1) : k + S;
              }
            }
            y.push(S);
          }
        } else {
          y = [];
          for (var R = 0; R < v.length; R++)
            y.push.apply(y, m(v[R], false));
        }
        for (R = 0; R < y.length; R++)
          for (c3 = 0; c3 < a3.length; c3++)
            l3 = i3 + y[R] + a3[c3], (!e3 || x || l3) && n3.push(l3);
      }
      return n3;
    }
  }, 829: (t2) => {
    function e2(t3) {
      return e2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t4) {
        return typeof t4;
      } : function(t4) {
        return t4 && "function" == typeof Symbol && t4.constructor === Symbol && t4 !== Symbol.prototype ? "symbol" : typeof t4;
      }, e2(t3);
    }
    function n2(t3) {
      var e3 = "function" == typeof Map ? /* @__PURE__ */ new Map() : void 0;
      return n2 = function(t4) {
        if (null === t4 || (n3 = t4, -1 === Function.toString.call(n3).indexOf("[native code]")))
          return t4;
        var n3;
        if ("function" != typeof t4)
          throw new TypeError("Super expression must either be null or a function");
        if (void 0 !== e3) {
          if (e3.has(t4))
            return e3.get(t4);
          e3.set(t4, s3);
        }
        function s3() {
          return r2(t4, arguments, i2(this).constructor);
        }
        return s3.prototype = Object.create(t4.prototype, { constructor: { value: s3, enumerable: false, writable: true, configurable: true } }), o2(s3, t4);
      }, n2(t3);
    }
    function r2(t3, e3, n3) {
      return r2 = function() {
        if ("undefined" == typeof Reflect || !Reflect.construct)
          return false;
        if (Reflect.construct.sham)
          return false;
        if ("function" == typeof Proxy)
          return true;
        try {
          return Date.prototype.toString.call(Reflect.construct(Date, [], function() {
          })), true;
        } catch (t4) {
          return false;
        }
      }() ? Reflect.construct : function(t4, e4, n4) {
        var r3 = [null];
        r3.push.apply(r3, e4);
        var i3 = new (Function.bind.apply(t4, r3))();
        return n4 && o2(i3, n4.prototype), i3;
      }, r2.apply(null, arguments);
    }
    function o2(t3, e3) {
      return o2 = Object.setPrototypeOf || function(t4, e4) {
        return t4.__proto__ = e4, t4;
      }, o2(t3, e3);
    }
    function i2(t3) {
      return i2 = Object.setPrototypeOf ? Object.getPrototypeOf : function(t4) {
        return t4.__proto__ || Object.getPrototypeOf(t4);
      }, i2(t3);
    }
    var s2 = function(t3) {
      function n3(t4) {
        var r3;
        return function(t5, e3) {
          if (!(t5 instanceof e3))
            throw new TypeError("Cannot call a class as a function");
        }(this, n3), (r3 = function(t5, n4) {
          return !n4 || "object" !== e2(n4) && "function" != typeof n4 ? function(t6) {
            if (void 0 === t6)
              throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            return t6;
          }(t5) : n4;
        }(this, i2(n3).call(this, t4))).name = "ObjectPrototypeMutationError", r3;
      }
      return function(t4, e3) {
        if ("function" != typeof e3 && null !== e3)
          throw new TypeError("Super expression must either be null or a function");
        t4.prototype = Object.create(e3 && e3.prototype, { constructor: { value: t4, writable: true, configurable: true } }), e3 && o2(t4, e3);
      }(n3, t3), n3;
    }(n2(Error));
    function a2(t3, n3) {
      for (var r3 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : function() {
      }, o3 = n3.split("."), i3 = o3.length, s3 = function(e3) {
        var n4 = o3[e3];
        if (!t3)
          return { v: void 0 };
        if ("+" === n4) {
          if (Array.isArray(t3))
            return { v: t3.map(function(n5, i5) {
              var s4 = o3.slice(e3 + 1);
              return s4.length > 0 ? a2(n5, s4.join("."), r3) : r3(t3, i5, o3, e3);
            }) };
          var i4 = o3.slice(0, e3).join(".");
          throw new Error("Object at wildcard (".concat(i4, ") is not an array"));
        }
        t3 = r3(t3, n4, o3, e3);
      }, c3 = 0; c3 < i3; c3++) {
        var u2 = s3(c3);
        if ("object" === e2(u2))
          return u2.v;
      }
      return t3;
    }
    function c2(t3, e3) {
      return t3.length === e3 + 1;
    }
    t2.exports = { set: function(t3, n3, r3) {
      if ("object" != e2(t3) || null === t3)
        return t3;
      if (void 0 === n3)
        return t3;
      if ("number" == typeof n3)
        return t3[n3] = r3, t3[n3];
      try {
        return a2(t3, n3, function(t4, e3, n4, o3) {
          if (t4 === Reflect.getPrototypeOf({}))
            throw new s2("Attempting to mutate Object.prototype");
          if (!t4[e3]) {
            var i3 = Number.isInteger(Number(n4[o3 + 1])), a3 = "+" === n4[o3 + 1];
            t4[e3] = i3 || a3 ? [] : {};
          }
          return c2(n4, o3) && (t4[e3] = r3), t4[e3];
        });
      } catch (e3) {
        if (e3 instanceof s2)
          throw e3;
        return t3;
      }
    }, get: function(t3, n3) {
      if ("object" != e2(t3) || null === t3)
        return t3;
      if (void 0 === n3)
        return t3;
      if ("number" == typeof n3)
        return t3[n3];
      try {
        return a2(t3, n3, function(t4, e3) {
          return t4[e3];
        });
      } catch (e3) {
        return t3;
      }
    }, has: function(t3, n3) {
      var r3 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      if ("object" != e2(t3) || null === t3)
        return false;
      if (void 0 === n3)
        return false;
      if ("number" == typeof n3)
        return n3 in t3;
      try {
        var o3 = false;
        return a2(t3, n3, function(t4, e3, n4, i3) {
          if (!c2(n4, i3))
            return t4 && t4[e3];
          o3 = r3.own ? t4.hasOwnProperty(e3) : e3 in t4;
        }), o3;
      } catch (t4) {
        return false;
      }
    }, hasOwn: function(t3, e3, n3) {
      return this.has(t3, e3, n3 || { own: true });
    }, isIn: function(t3, n3, r3) {
      var o3 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      if ("object" != e2(t3) || null === t3)
        return false;
      if (void 0 === n3)
        return false;
      try {
        var i3 = false, s3 = false;
        return a2(t3, n3, function(t4, n4, o4, a3) {
          return i3 = i3 || t4 === r3 || !!t4 && t4[n4] === r3, s3 = c2(o4, a3) && "object" === e2(t4) && n4 in t4, t4 && t4[n4];
        }), o3.validPath ? i3 && s3 : i3;
      } catch (t4) {
        return false;
      }
    }, ObjectPrototypeMutationError: s2 };
  }, 47: (t2, e2, n2) => {
    var r2 = n2(410), o2 = function(t3) {
      return "string" == typeof t3;
    };
    function i2(t3, e3) {
      for (var n3 = [], r3 = 0; r3 < t3.length; r3++) {
        var o3 = t3[r3];
        o3 && "." !== o3 && (".." === o3 ? n3.length && ".." !== n3[n3.length - 1] ? n3.pop() : e3 && n3.push("..") : n3.push(o3));
      }
      return n3;
    }
    var s2 = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/, a2 = {};
    function c2(t3) {
      return s2.exec(t3).slice(1);
    }
    a2.resolve = function() {
      for (var t3 = "", e3 = false, n3 = arguments.length - 1; n3 >= -1 && !e3; n3--) {
        var r3 = n3 >= 0 ? arguments[n3] : process$1.cwd();
        if (!o2(r3))
          throw new TypeError("Arguments to path.resolve must be strings");
        r3 && (t3 = r3 + "/" + t3, e3 = "/" === r3.charAt(0));
      }
      return (e3 ? "/" : "") + (t3 = i2(t3.split("/"), !e3).join("/")) || ".";
    }, a2.normalize = function(t3) {
      var e3 = a2.isAbsolute(t3), n3 = "/" === t3.substr(-1);
      return (t3 = i2(t3.split("/"), !e3).join("/")) || e3 || (t3 = "."), t3 && n3 && (t3 += "/"), (e3 ? "/" : "") + t3;
    }, a2.isAbsolute = function(t3) {
      return "/" === t3.charAt(0);
    }, a2.join = function() {
      for (var t3 = "", e3 = 0; e3 < arguments.length; e3++) {
        var n3 = arguments[e3];
        if (!o2(n3))
          throw new TypeError("Arguments to path.join must be strings");
        n3 && (t3 += t3 ? "/" + n3 : n3);
      }
      return a2.normalize(t3);
    }, a2.relative = function(t3, e3) {
      function n3(t4) {
        for (var e4 = 0; e4 < t4.length && "" === t4[e4]; e4++)
          ;
        for (var n4 = t4.length - 1; n4 >= 0 && "" === t4[n4]; n4--)
          ;
        return e4 > n4 ? [] : t4.slice(e4, n4 + 1);
      }
      t3 = a2.resolve(t3).substr(1), e3 = a2.resolve(e3).substr(1);
      for (var r3 = n3(t3.split("/")), o3 = n3(e3.split("/")), i3 = Math.min(r3.length, o3.length), s3 = i3, c3 = 0; c3 < i3; c3++)
        if (r3[c3] !== o3[c3]) {
          s3 = c3;
          break;
        }
      var u2 = [];
      for (c3 = s3; c3 < r3.length; c3++)
        u2.push("..");
      return (u2 = u2.concat(o3.slice(s3))).join("/");
    }, a2._makeLong = function(t3) {
      return t3;
    }, a2.dirname = function(t3) {
      var e3 = c2(t3), n3 = e3[0], r3 = e3[1];
      return n3 || r3 ? (r3 && (r3 = r3.substr(0, r3.length - 1)), n3 + r3) : ".";
    }, a2.basename = function(t3, e3) {
      var n3 = c2(t3)[2];
      return e3 && n3.substr(-1 * e3.length) === e3 && (n3 = n3.substr(0, n3.length - e3.length)), n3;
    }, a2.extname = function(t3) {
      return c2(t3)[3];
    }, a2.format = function(t3) {
      if (!r2.isObject(t3))
        throw new TypeError("Parameter 'pathObject' must be an object, not " + typeof t3);
      var e3 = t3.root || "";
      if (!o2(e3))
        throw new TypeError("'pathObject.root' must be a string or undefined, not " + typeof t3.root);
      return (t3.dir ? t3.dir + a2.sep : "") + (t3.base || "");
    }, a2.parse = function(t3) {
      if (!o2(t3))
        throw new TypeError("Parameter 'pathString' must be a string, not " + typeof t3);
      var e3 = c2(t3);
      if (!e3 || 4 !== e3.length)
        throw new TypeError("Invalid path '" + t3 + "'");
      return e3[1] = e3[1] || "", e3[2] = e3[2] || "", e3[3] = e3[3] || "", { root: e3[0], dir: e3[0] + e3[1].slice(0, e3[1].length - 1), base: e3[2], ext: e3[3], name: e3[2].slice(0, e3[2].length - e3[3].length) };
    }, a2.sep = "/", a2.delimiter = ":", t2.exports = a2;
  }, 647: (t2, e2) => {
    var n2 = Object.prototype.hasOwnProperty;
    function r2(t3) {
      try {
        return decodeURIComponent(t3.replace(/\+/g, " "));
      } catch (t4) {
        return null;
      }
    }
    function o2(t3) {
      try {
        return encodeURIComponent(t3);
      } catch (t4) {
        return null;
      }
    }
    e2.stringify = function(t3, e3) {
      e3 = e3 || "";
      var r3, i2, s2 = [];
      for (i2 in "string" != typeof e3 && (e3 = "?"), t3)
        if (n2.call(t3, i2)) {
          if ((r3 = t3[i2]) || null != r3 && !isNaN(r3) || (r3 = ""), i2 = o2(i2), r3 = o2(r3), null === i2 || null === r3)
            continue;
          s2.push(i2 + "=" + r3);
        }
      return s2.length ? e3 + s2.join("&") : "";
    }, e2.parse = function(t3) {
      for (var e3, n3 = /([^=?#&]+)=?([^&]*)/g, o3 = {}; e3 = n3.exec(t3); ) {
        var i2 = r2(e3[1]), s2 = r2(e3[2]);
        null === i2 || null === s2 || i2 in o3 || (o3[i2] = s2);
      }
      return o3;
    };
  }, 670: (t2) => {
    t2.exports = function(t3, e2) {
      if (e2 = e2.split(":")[0], !(t3 = +t3))
        return false;
      switch (e2) {
        case "http":
        case "ws":
          return 80 !== t3;
        case "https":
        case "wss":
          return 443 !== t3;
        case "ftp":
          return 21 !== t3;
        case "gopher":
          return 70 !== t3;
        case "file":
          return false;
      }
      return 0 !== t3;
    };
  }, 494: (t2) => {
    const e2 = /^[-+]?0x[a-fA-F0-9]+$/, n2 = /^([\-\+])?(0*)(\.[0-9]+([eE]\-?[0-9]+)?|[0-9]+(\.[0-9]+([eE]\-?[0-9]+)?)?)$/;
    !Number.parseInt && window.parseInt && (Number.parseInt = window.parseInt), !Number.parseFloat && window.parseFloat && (Number.parseFloat = window.parseFloat);
    const r2 = { hex: true, leadingZeros: true, decimalPoint: ".", eNotation: true };
    t2.exports = function(t3) {
      let o2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      if (o2 = Object.assign({}, r2, o2), !t3 || "string" != typeof t3)
        return t3;
      let i2 = t3.trim();
      if (void 0 !== o2.skipLike && o2.skipLike.test(i2))
        return t3;
      if (o2.hex && e2.test(i2))
        return Number.parseInt(i2, 16);
      {
        const e3 = n2.exec(i2);
        if (e3) {
          const n3 = e3[1], r3 = e3[2];
          let a2 = (s2 = e3[3]) && -1 !== s2.indexOf(".") ? ("." === (s2 = s2.replace(/0+$/, "")) ? s2 = "0" : "." === s2[0] ? s2 = "0" + s2 : "." === s2[s2.length - 1] && (s2 = s2.substr(0, s2.length - 1)), s2) : s2;
          const c2 = e3[4] || e3[6];
          if (!o2.leadingZeros && r3.length > 0 && n3 && "." !== i2[2])
            return t3;
          if (!o2.leadingZeros && r3.length > 0 && !n3 && "." !== i2[1])
            return t3;
          {
            const e4 = Number(i2), s3 = "" + e4;
            return -1 !== s3.search(/[eE]/) || c2 ? o2.eNotation ? e4 : t3 : -1 !== i2.indexOf(".") ? "0" === s3 && "" === a2 || s3 === a2 || n3 && s3 === "-" + a2 ? e4 : t3 : r3 ? a2 === s3 || n3 + a2 === s3 ? e4 : t3 : i2 === s3 || i2 === n3 + s3 ? e4 : t3;
          }
        }
        return t3;
      }
      var s2;
    };
  }, 737: (t2, e2, n2) => {
    var r2 = n2(670), o2 = n2(647), i2 = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/, s2 = /[\n\r\t]/g, a2 = /^[A-Za-z][A-Za-z0-9+-.]*:\/\//, c2 = /:\d+$/, u2 = /^([a-z][a-z0-9.+-]*:)?(\/\/)?([\\/]+)?([\S\s]*)/i, l2 = /^[a-zA-Z]:/;
    function h2(t3) {
      return (t3 || "").toString().replace(i2, "");
    }
    var p2 = [["#", "hash"], ["?", "query"], function(t3, e3) {
      return g(e3.protocol) ? t3.replace(/\\/g, "/") : t3;
    }, ["/", "pathname"], ["@", "auth", 1], [NaN, "host", void 0, 1, 1], [/:(\d*)$/, "port", void 0, 1], [NaN, "hostname", void 0, 1, 1]], f2 = { hash: 1, query: 1 };
    function d2(t3) {
      var e3, n3 = ("undefined" != typeof window ? window : "undefined" != typeof global$1 ? global$1 : "undefined" != typeof self ? self : {}).location || {}, r3 = {}, o3 = typeof (t3 = t3 || n3);
      if ("blob:" === t3.protocol)
        r3 = new v(unescape(t3.pathname), {});
      else if ("string" === o3)
        for (e3 in r3 = new v(t3, {}), f2)
          delete r3[e3];
      else if ("object" === o3) {
        for (e3 in t3)
          e3 in f2 || (r3[e3] = t3[e3]);
        void 0 === r3.slashes && (r3.slashes = a2.test(t3.href));
      }
      return r3;
    }
    function g(t3) {
      return "file:" === t3 || "ftp:" === t3 || "http:" === t3 || "https:" === t3 || "ws:" === t3 || "wss:" === t3;
    }
    function m(t3, e3) {
      t3 = (t3 = h2(t3)).replace(s2, ""), e3 = e3 || {};
      var n3, r3 = u2.exec(t3), o3 = r3[1] ? r3[1].toLowerCase() : "", i3 = !!r3[2], a3 = !!r3[3], c3 = 0;
      return i3 ? a3 ? (n3 = r3[2] + r3[3] + r3[4], c3 = r3[2].length + r3[3].length) : (n3 = r3[2] + r3[4], c3 = r3[2].length) : a3 ? (n3 = r3[3] + r3[4], c3 = r3[3].length) : n3 = r3[4], "file:" === o3 ? c3 >= 2 && (n3 = n3.slice(2)) : g(o3) ? n3 = r3[4] : o3 ? i3 && (n3 = n3.slice(2)) : c3 >= 2 && g(e3.protocol) && (n3 = r3[4]), { protocol: o3, slashes: i3 || g(o3), slashesCount: c3, rest: n3 };
    }
    function v(t3, e3, n3) {
      if (t3 = (t3 = h2(t3)).replace(s2, ""), !(this instanceof v))
        return new v(t3, e3, n3);
      var i3, a3, c3, u3, f3, y, b = p2.slice(), w = typeof e3, x = this, N = 0;
      for ("object" !== w && "string" !== w && (n3 = e3, e3 = null), n3 && "function" != typeof n3 && (n3 = o2.parse), i3 = !(a3 = m(t3 || "", e3 = d2(e3))).protocol && !a3.slashes, x.slashes = a3.slashes || i3 && e3.slashes, x.protocol = a3.protocol || e3.protocol || "", t3 = a3.rest, ("file:" === a3.protocol && (2 !== a3.slashesCount || l2.test(t3)) || !a3.slashes && (a3.protocol || a3.slashesCount < 2 || !g(x.protocol))) && (b[3] = [/(.*)/, "pathname"]); N < b.length; N++)
        "function" != typeof (u3 = b[N]) ? (c3 = u3[0], y = u3[1], c3 != c3 ? x[y] = t3 : "string" == typeof c3 ? ~(f3 = "@" === c3 ? t3.lastIndexOf(c3) : t3.indexOf(c3)) && ("number" == typeof u3[2] ? (x[y] = t3.slice(0, f3), t3 = t3.slice(f3 + u3[2])) : (x[y] = t3.slice(f3), t3 = t3.slice(0, f3))) : (f3 = c3.exec(t3)) && (x[y] = f3[1], t3 = t3.slice(0, f3.index)), x[y] = x[y] || i3 && u3[3] && e3[y] || "", u3[4] && (x[y] = x[y].toLowerCase())) : t3 = u3(t3, x);
      n3 && (x.query = n3(x.query)), i3 && e3.slashes && "/" !== x.pathname.charAt(0) && ("" !== x.pathname || "" !== e3.pathname) && (x.pathname = function(t4, e4) {
        if ("" === t4)
          return e4;
        for (var n4 = (e4 || "/").split("/").slice(0, -1).concat(t4.split("/")), r3 = n4.length, o3 = n4[r3 - 1], i4 = false, s3 = 0; r3--; )
          "." === n4[r3] ? n4.splice(r3, 1) : ".." === n4[r3] ? (n4.splice(r3, 1), s3++) : s3 && (0 === r3 && (i4 = true), n4.splice(r3, 1), s3--);
        return i4 && n4.unshift(""), "." !== o3 && ".." !== o3 || n4.push(""), n4.join("/");
      }(x.pathname, e3.pathname)), "/" !== x.pathname.charAt(0) && g(x.protocol) && (x.pathname = "/" + x.pathname), r2(x.port, x.protocol) || (x.host = x.hostname, x.port = ""), x.username = x.password = "", x.auth && (~(f3 = x.auth.indexOf(":")) ? (x.username = x.auth.slice(0, f3), x.username = encodeURIComponent(decodeURIComponent(x.username)), x.password = x.auth.slice(f3 + 1), x.password = encodeURIComponent(decodeURIComponent(x.password))) : x.username = encodeURIComponent(decodeURIComponent(x.auth)), x.auth = x.password ? x.username + ":" + x.password : x.username), x.origin = "file:" !== x.protocol && g(x.protocol) && x.host ? x.protocol + "//" + x.host : "null", x.href = x.toString();
    }
    v.prototype = { set: function(t3, e3, n3) {
      var i3 = this;
      switch (t3) {
        case "query":
          "string" == typeof e3 && e3.length && (e3 = (n3 || o2.parse)(e3)), i3[t3] = e3;
          break;
        case "port":
          i3[t3] = e3, r2(e3, i3.protocol) ? e3 && (i3.host = i3.hostname + ":" + e3) : (i3.host = i3.hostname, i3[t3] = "");
          break;
        case "hostname":
          i3[t3] = e3, i3.port && (e3 += ":" + i3.port), i3.host = e3;
          break;
        case "host":
          i3[t3] = e3, c2.test(e3) ? (e3 = e3.split(":"), i3.port = e3.pop(), i3.hostname = e3.join(":")) : (i3.hostname = e3, i3.port = "");
          break;
        case "protocol":
          i3.protocol = e3.toLowerCase(), i3.slashes = !n3;
          break;
        case "pathname":
        case "hash":
          if (e3) {
            var s3 = "pathname" === t3 ? "/" : "#";
            i3[t3] = e3.charAt(0) !== s3 ? s3 + e3 : e3;
          } else
            i3[t3] = e3;
          break;
        case "username":
        case "password":
          i3[t3] = encodeURIComponent(e3);
          break;
        case "auth":
          var a3 = e3.indexOf(":");
          ~a3 ? (i3.username = e3.slice(0, a3), i3.username = encodeURIComponent(decodeURIComponent(i3.username)), i3.password = e3.slice(a3 + 1), i3.password = encodeURIComponent(decodeURIComponent(i3.password))) : i3.username = encodeURIComponent(decodeURIComponent(e3));
      }
      for (var u3 = 0; u3 < p2.length; u3++) {
        var l3 = p2[u3];
        l3[4] && (i3[l3[1]] = i3[l3[1]].toLowerCase());
      }
      return i3.auth = i3.password ? i3.username + ":" + i3.password : i3.username, i3.origin = "file:" !== i3.protocol && g(i3.protocol) && i3.host ? i3.protocol + "//" + i3.host : "null", i3.href = i3.toString(), i3;
    }, toString: function(t3) {
      t3 && "function" == typeof t3 || (t3 = o2.stringify);
      var e3, n3 = this, r3 = n3.host, i3 = n3.protocol;
      i3 && ":" !== i3.charAt(i3.length - 1) && (i3 += ":");
      var s3 = i3 + (n3.protocol && n3.slashes || g(n3.protocol) ? "//" : "");
      return n3.username ? (s3 += n3.username, n3.password && (s3 += ":" + n3.password), s3 += "@") : n3.password ? (s3 += ":" + n3.password, s3 += "@") : "file:" !== n3.protocol && g(n3.protocol) && !r3 && "/" !== n3.pathname && (s3 += "@"), (":" === r3[r3.length - 1] || c2.test(n3.hostname) && !n3.port) && (r3 += ":"), s3 += r3 + n3.pathname, (e3 = "object" == typeof n3.query ? t3(n3.query) : n3.query) && (s3 += "?" !== e3.charAt(0) ? "?" + e3 : e3), n3.hash && (s3 += n3.hash), s3;
    } }, v.extractProtocol = m, v.location = d2, v.trimLeft = h2, v.qs = o2, t2.exports = v;
  }, 410: () => {
  }, 388: () => {
  }, 805: () => {
  }, 345: () => {
  }, 800: () => {
  } }, e = {};
  function n(r2) {
    var o2 = e[r2];
    if (void 0 !== o2)
      return o2.exports;
    var i2 = e[r2] = { id: r2, loaded: false, exports: {} };
    return t$1[r2].call(i2.exports, i2, i2.exports, n), i2.loaded = true, i2.exports;
  }
  n.n = (t2) => {
    var e2 = t2 && t2.__esModule ? () => t2.default : () => t2;
    return n.d(e2, { a: e2 }), e2;
  }, n.d = (t2, e2) => {
    for (var r2 in e2)
      n.o(e2, r2) && !n.o(t2, r2) && Object.defineProperty(t2, r2, { enumerable: true, get: e2[r2] });
  }, n.o = (t2, e2) => Object.prototype.hasOwnProperty.call(t2, e2), n.nmd = (t2) => (t2.paths = [], t2.children || (t2.children = []), t2);
  var r = {};
  (() => {
    n.d(r, { hT: () => C, O4: () => S, Kd: () => T, YK: () => j, UU: () => Ke, Gu: () => M, ky: () => te, h4: () => Jt, ch: () => Qt, hq: () => zt, i5: () => ee });
    var t2 = n(737), e2 = n.n(t2);
    function o2(t3) {
      if (!i2(t3))
        throw new Error("Parameter was not an error");
    }
    function i2(t3) {
      return "[object Error]" === (e3 = t3, Object.prototype.toString.call(e3)) || t3 instanceof Error;
      var e3;
    }
    class s2 extends Error {
      constructor(t3, e3) {
        const n2 = [...arguments], { options: r2, shortMessage: o3 } = function(t4) {
          let e4, n3 = "";
          if (0 === t4.length)
            e4 = {};
          else if (i2(t4[0]))
            e4 = { cause: t4[0] }, n3 = t4.slice(1).join(" ") || "";
          else if (t4[0] && "object" == typeof t4[0])
            e4 = Object.assign({}, t4[0]), n3 = t4.slice(1).join(" ") || "";
          else {
            if ("string" != typeof t4[0])
              throw new Error("Invalid arguments passed to Layerr");
            e4 = {}, n3 = n3 = t4.join(" ") || "";
          }
          return { options: e4, shortMessage: n3 };
        }(n2);
        let s3 = o3;
        if (r2.cause && (s3 = "".concat(s3, ": ").concat(r2.cause.message)), super(s3), this.message = s3, r2.name && "string" == typeof r2.name ? this.name = r2.name : this.name = "Layerr", r2.cause && Object.defineProperty(this, "_cause", { value: r2.cause }), Object.defineProperty(this, "_info", { value: {} }), r2.info && "object" == typeof r2.info && Object.assign(this._info, r2.info), Error.captureStackTrace) {
          const t4 = r2.constructorOpt || this.constructor;
          Error.captureStackTrace(this, t4);
        }
      }
      static cause(t3) {
        return o2(t3), t3._cause && i2(t3._cause) ? t3._cause : null;
      }
      static fullStack(t3) {
        o2(t3);
        const e3 = s2.cause(t3);
        return e3 ? "".concat(t3.stack, "\ncaused by: ").concat(s2.fullStack(e3)) : t3.stack;
      }
      static info(t3) {
        o2(t3);
        const e3 = {}, n2 = s2.cause(t3);
        return n2 && Object.assign(e3, s2.info(n2)), t3._info && Object.assign(e3, t3._info), e3;
      }
      cause() {
        return s2.cause(this);
      }
      toString() {
        let t3 = this.name || this.constructor.name || this.constructor.prototype.name;
        return this.message && (t3 = "".concat(t3, ": ").concat(this.message)), t3;
      }
    }
    var a2 = n(47), c2 = n.n(a2);
    const u2 = "__PATH_SEPARATOR_POSIX__", l2 = "__PATH_SEPARATOR_WINDOWS__";
    function h2(t3) {
      try {
        const e3 = t3.replace(/\//g, u2).replace(/\\\\/g, l2);
        return encodeURIComponent(e3).split(l2).join("\\\\").split(u2).join("/");
      } catch (t4) {
        throw new s2(t4, "Failed encoding path");
      }
    }
    function p2(t3) {
      return t3.startsWith("/") ? t3 : "/" + t3;
    }
    function f2(t3) {
      let e3 = t3;
      return "/" !== e3[0] && (e3 = "/" + e3), /^.+\/$/.test(e3) && (e3 = e3.substr(0, e3.length - 1)), e3;
    }
    function d2(t3) {
      let n2 = new (e2())(t3).pathname;
      return n2.length <= 0 && (n2 = "/"), f2(n2);
    }
    function g() {
      for (var t3 = arguments.length, e3 = new Array(t3), n2 = 0; n2 < t3; n2++)
        e3[n2] = arguments[n2];
      return function() {
        return function(t4) {
          var e4 = [];
          if (0 === t4.length)
            return "";
          if ("string" != typeof t4[0])
            throw new TypeError("Url must be a string. Received " + t4[0]);
          if (t4[0].match(/^[^/:]+:\/*$/) && t4.length > 1) {
            var n3 = t4.shift();
            t4[0] = n3 + t4[0];
          }
          t4[0].match(/^file:\/\/\//) ? t4[0] = t4[0].replace(/^([^/:]+):\/*/, "$1:///") : t4[0] = t4[0].replace(/^([^/:]+):\/*/, "$1://");
          for (var r2 = 0; r2 < t4.length; r2++) {
            var o3 = t4[r2];
            if ("string" != typeof o3)
              throw new TypeError("Url must be a string. Received " + o3);
            "" !== o3 && (r2 > 0 && (o3 = o3.replace(/^[\/]+/, "")), o3 = r2 < t4.length - 1 ? o3.replace(/[\/]+$/, "") : o3.replace(/[\/]+$/, "/"), e4.push(o3));
          }
          var i3 = e4.join("/"), s3 = (i3 = i3.replace(/\/(\?|&|#[^!])/g, "$1")).split("?");
          return s3.shift() + (s3.length > 0 ? "?" : "") + s3.join("&");
        }("object" == typeof arguments[0] ? arguments[0] : [].slice.call(arguments));
      }(e3.reduce((t4, e4, n3) => ((0 === n3 || "/" !== e4 || "/" === e4 && "/" !== t4[t4.length - 1]) && t4.push(e4), t4), []));
    }
    var m = n(542), v = n.n(m);
    const y = "abcdef0123456789";
    function b(t3, e3) {
      const n2 = t3.url.replace("//", ""), r2 = -1 == n2.indexOf("/") ? "/" : n2.slice(n2.indexOf("/")), o3 = t3.method ? t3.method.toUpperCase() : "GET", i3 = !!/(^|,)\s*auth\s*($|,)/.test(e3.qop) && "auth", s3 = "00000000".concat(e3.nc).slice(-8), a3 = function(t4, e4, n3, r3, o4, i4, s4) {
        const a4 = s4 || v()("".concat(e4, ":").concat(n3, ":").concat(r3));
        return t4 && "md5-sess" === t4.toLowerCase() ? v()("".concat(a4, ":").concat(o4, ":").concat(i4)) : a4;
      }(e3.algorithm, e3.username, e3.realm, e3.password, e3.nonce, e3.cnonce, e3.ha1), c3 = v()("".concat(o3, ":").concat(r2)), u3 = i3 ? v()("".concat(a3, ":").concat(e3.nonce, ":").concat(s3, ":").concat(e3.cnonce, ":").concat(i3, ":").concat(c3)) : v()("".concat(a3, ":").concat(e3.nonce, ":").concat(c3)), l3 = { username: e3.username, realm: e3.realm, nonce: e3.nonce, uri: r2, qop: i3, response: u3, nc: s3, cnonce: e3.cnonce, algorithm: e3.algorithm, opaque: e3.opaque }, h3 = [];
      for (const t4 in l3)
        l3[t4] && ("qop" === t4 || "nc" === t4 || "algorithm" === t4 ? h3.push("".concat(t4, "=").concat(l3[t4])) : h3.push("".concat(t4, '="').concat(l3[t4], '"')));
      return "Digest ".concat(h3.join(", "));
    }
    function w(t3) {
      return "digest" === (t3.headers && t3.headers.get("www-authenticate") || "").split(/\s/)[0].toLowerCase();
    }
    var x = n(101), N = n.n(x);
    function P(t3) {
      return N().decode(t3);
    }
    function A(t3, e3) {
      const n2 = (r2 = "".concat(t3, ":").concat(e3), N().encode(r2));
      var r2;
      return "Basic ".concat(n2);
    }
    const O = "undefined" != typeof WorkerGlobalScope && self instanceof WorkerGlobalScope ? self : "undefined" != typeof window ? window : globalThis, E = O.fetch.bind(O), T = (O.Headers, O.Request), j = O.Response;
    let C = function(t3) {
      return t3.Auto = "auto", t3.Digest = "digest", t3.None = "none", t3.Password = "password", t3.Token = "token", t3;
    }({}), S = function(t3) {
      return t3.DataTypeNoLength = "data-type-no-length", t3.InvalidAuthType = "invalid-auth-type", t3.InvalidOutputFormat = "invalid-output-format", t3.LinkUnsupportedAuthType = "link-unsupported-auth", t3.InvalidUpdateRange = "invalid-update-range", t3.NotSupported = "not-supported", t3;
    }({});
    function I(t3, e3, n2, r2, o3) {
      switch (t3.authType) {
        case C.Auto:
          e3 && n2 && (t3.headers.Authorization = A(e3, n2));
          break;
        case C.Digest:
          t3.digest = /* @__PURE__ */ function(t4, e4, n3) {
            return { username: t4, password: e4, ha1: n3, nc: 0, algorithm: "md5", hasDigestAuth: false };
          }(e3, n2, o3);
          break;
        case C.None:
          break;
        case C.Password:
          t3.headers.Authorization = A(e3, n2);
          break;
        case C.Token:
          t3.headers.Authorization = "".concat((i3 = r2).token_type, " ").concat(i3.access_token);
          break;
        default:
          throw new s2({ info: { code: S.InvalidAuthType } }, "Invalid auth type: ".concat(t3.authType));
      }
      var i3;
    }
    n(345), n(800);
    const k = "@@HOTPATCHER", R = () => {
    };
    function L(t3) {
      return { original: t3, methods: [t3], final: false };
    }
    class _ {
      constructor() {
        this._configuration = { registry: {}, getEmptyAction: "null" }, this.__type__ = k;
      }
      get configuration() {
        return this._configuration;
      }
      get getEmptyAction() {
        return this.configuration.getEmptyAction;
      }
      set getEmptyAction(t3) {
        this.configuration.getEmptyAction = t3;
      }
      control(t3) {
        let e3 = arguments.length > 1 && void 0 !== arguments[1] && arguments[1];
        if (!t3 || t3.__type__ !== k)
          throw new Error("Failed taking control of target HotPatcher instance: Invalid type or object");
        return Object.keys(t3.configuration.registry).forEach((n2) => {
          this.configuration.registry.hasOwnProperty(n2) ? e3 && (this.configuration.registry[n2] = Object.assign({}, t3.configuration.registry[n2])) : this.configuration.registry[n2] = Object.assign({}, t3.configuration.registry[n2]);
        }), t3._configuration = this.configuration, this;
      }
      execute(t3) {
        const e3 = this.get(t3) || R;
        for (var n2 = arguments.length, r2 = new Array(n2 > 1 ? n2 - 1 : 0), o3 = 1; o3 < n2; o3++)
          r2[o3 - 1] = arguments[o3];
        return e3(...r2);
      }
      get(t3) {
        const e3 = this.configuration.registry[t3];
        if (!e3)
          switch (this.getEmptyAction) {
            case "null":
              return null;
            case "throw":
              throw new Error("Failed handling method request: No method provided for override: ".concat(t3));
            default:
              throw new Error("Failed handling request which resulted in an empty method: Invalid empty-action specified: ".concat(this.getEmptyAction));
          }
        return function() {
          for (var t4 = arguments.length, e4 = new Array(t4), n2 = 0; n2 < t4; n2++)
            e4[n2] = arguments[n2];
          if (0 === e4.length)
            throw new Error("Failed creating sequence: No functions provided");
          return function() {
            for (var t5 = arguments.length, n3 = new Array(t5), r2 = 0; r2 < t5; r2++)
              n3[r2] = arguments[r2];
            let o3 = n3;
            const i3 = this;
            for (; e4.length > 0; )
              o3 = [e4.shift().apply(i3, o3)];
            return o3[0];
          };
        }(...e3.methods);
      }
      isPatched(t3) {
        return !!this.configuration.registry[t3];
      }
      patch(t3, e3) {
        let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
        const { chain: r2 = false } = n2;
        if (this.configuration.registry[t3] && this.configuration.registry[t3].final)
          throw new Error("Failed patching '".concat(t3, "': Method marked as being final"));
        if ("function" != typeof e3)
          throw new Error("Failed patching '".concat(t3, "': Provided method is not a function"));
        if (r2)
          this.configuration.registry[t3] ? this.configuration.registry[t3].methods.push(e3) : this.configuration.registry[t3] = L(e3);
        else if (this.isPatched(t3)) {
          const { original: n3 } = this.configuration.registry[t3];
          this.configuration.registry[t3] = Object.assign(L(e3), { original: n3 });
        } else
          this.configuration.registry[t3] = L(e3);
        return this;
      }
      patchInline(t3, e3) {
        this.isPatched(t3) || this.patch(t3, e3);
        for (var n2 = arguments.length, r2 = new Array(n2 > 2 ? n2 - 2 : 0), o3 = 2; o3 < n2; o3++)
          r2[o3 - 2] = arguments[o3];
        return this.execute(t3, ...r2);
      }
      plugin(t3) {
        for (var e3 = arguments.length, n2 = new Array(e3 > 1 ? e3 - 1 : 0), r2 = 1; r2 < e3; r2++)
          n2[r2 - 1] = arguments[r2];
        return n2.forEach((e4) => {
          this.patch(t3, e4, { chain: true });
        }), this;
      }
      restore(t3) {
        if (!this.isPatched(t3))
          throw new Error("Failed restoring method: No method present for key: ".concat(t3));
        if ("function" != typeof this.configuration.registry[t3].original)
          throw new Error("Failed restoring method: Original method not found or of invalid type for key: ".concat(t3));
        return this.configuration.registry[t3].methods = [this.configuration.registry[t3].original], this;
      }
      setFinal(t3) {
        if (!this.configuration.registry.hasOwnProperty(t3))
          throw new Error("Failed marking '".concat(t3, "' as final: No method found for key"));
        return this.configuration.registry[t3].final = true, this;
      }
    }
    let U = null;
    function M() {
      return U || (U = new _()), U;
    }
    function F(t3) {
      return function(t4) {
        if ("object" != typeof t4 || null === t4 || "[object Object]" != Object.prototype.toString.call(t4))
          return false;
        if (null === Object.getPrototypeOf(t4))
          return true;
        let e3 = t4;
        for (; null !== Object.getPrototypeOf(e3); )
          e3 = Object.getPrototypeOf(e3);
        return Object.getPrototypeOf(t4) === e3;
      }(t3) ? Object.assign({}, t3) : Object.setPrototypeOf(Object.assign({}, t3), Object.getPrototypeOf(t3));
    }
    function D() {
      for (var t3 = arguments.length, e3 = new Array(t3), n2 = 0; n2 < t3; n2++)
        e3[n2] = arguments[n2];
      let r2 = null, o3 = [...e3];
      for (; o3.length > 0; ) {
        const t4 = o3.shift();
        r2 = r2 ? $2(r2, t4) : F(t4);
      }
      return r2;
    }
    function $2(t3, e3) {
      const n2 = F(t3);
      return Object.keys(e3).forEach((t4) => {
        n2.hasOwnProperty(t4) ? Array.isArray(e3[t4]) ? n2[t4] = Array.isArray(n2[t4]) ? [...n2[t4], ...e3[t4]] : [...e3[t4]] : "object" == typeof e3[t4] && e3[t4] ? n2[t4] = "object" == typeof n2[t4] && n2[t4] ? $2(n2[t4], e3[t4]) : F(e3[t4]) : n2[t4] = e3[t4] : n2[t4] = e3[t4];
      }), n2;
    }
    function B(t3) {
      const e3 = {};
      for (const n2 of t3.keys())
        e3[n2] = t3.get(n2);
      return e3;
    }
    function W() {
      for (var t3 = arguments.length, e3 = new Array(t3), n2 = 0; n2 < t3; n2++)
        e3[n2] = arguments[n2];
      if (0 === e3.length)
        return {};
      const r2 = {};
      return e3.reduce((t4, e4) => (Object.keys(e4).forEach((n3) => {
        const o3 = n3.toLowerCase();
        r2.hasOwnProperty(o3) ? t4[r2[o3]] = e4[n3] : (r2[o3] = n3, t4[n3] = e4[n3]);
      }), t4), {});
    }
    n(805);
    const V = "function" == typeof ArrayBuffer, { toString: z } = Object.prototype;
    function q(t3) {
      return V && (t3 instanceof ArrayBuffer || "[object ArrayBuffer]" === z.call(t3));
    }
    function G(t3) {
      return null != t3 && null != t3.constructor && "function" == typeof t3.constructor.isBuffer && t3.constructor.isBuffer(t3);
    }
    function H(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }
    function X(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const Z = H(function(t3) {
      const e3 = t3._digest;
      return delete t3._digest, e3.hasDigestAuth && (t3 = D(t3, { headers: { Authorization: b(t3, e3) } })), X(Q(t3), function(n2) {
        let r2 = false;
        return o3 = function(t4) {
          return r2 ? t4 : n2;
        }, (i3 = function() {
          if (401 == n2.status)
            return e3.hasDigestAuth = function(t4, e4) {
              if (!w(t4))
                return false;
              const n3 = /([a-z0-9_-]+)=(?:"([^"]+)"|([a-z0-9_-]+))/gi;
              for (; ; ) {
                const r3 = t4.headers && t4.headers.get("www-authenticate") || "", o4 = n3.exec(r3);
                if (!o4)
                  break;
                e4[o4[1]] = o4[2] || o4[3];
              }
              return e4.nc += 1, e4.cnonce = function() {
                let t5 = "";
                for (let e5 = 0; e5 < 32; ++e5)
                  t5 = "".concat(t5).concat(y[Math.floor(16 * Math.random())]);
                return t5;
              }(), true;
            }(n2, e3), function() {
              if (e3.hasDigestAuth)
                return X(Q(t3 = D(t3, { headers: { Authorization: b(t3, e3) } })), function(t4) {
                  return 401 == t4.status ? e3.hasDigestAuth = false : e3.nc++, r2 = true, t4;
                });
            }();
          e3.nc++;
        }()) && i3.then ? i3.then(o3) : o3(i3);
        var o3, i3;
      });
    }), Y = H(function(t3, e3) {
      return X(Q(t3), function(n2) {
        return n2.ok ? (e3.authType = C.Password, n2) : 401 == n2.status && w(n2) ? (e3.authType = C.Digest, I(e3, e3.username, e3.password, void 0, void 0), t3._digest = e3.digest, Z(t3)) : n2;
      });
    }), K = H(function(t3, e3) {
      return e3.authType === C.Auto ? Y(t3, e3) : t3._digest ? Z(t3) : Q(t3);
    });
    function J(t3, e3, n2) {
      const r2 = F(t3);
      return r2.headers = W(e3.headers, r2.headers || {}, n2.headers || {}), void 0 !== n2.data && (r2.data = n2.data), n2.signal && (r2.signal = n2.signal), e3.httpAgent && (r2.httpAgent = e3.httpAgent), e3.httpsAgent && (r2.httpsAgent = e3.httpsAgent), e3.digest && (r2._digest = e3.digest), "boolean" == typeof e3.withCredentials && (r2.withCredentials = e3.withCredentials), r2;
    }
    function Q(t3) {
      const e3 = M();
      return e3.patchInline("request", (t4) => e3.patchInline("fetch", E, t4.url, function(t5) {
        let e4 = {};
        const n2 = { method: t5.method };
        if (t5.headers && (e4 = W(e4, t5.headers)), void 0 !== t5.data) {
          const [r2, o3] = function(t6) {
            if ("string" == typeof t6)
              return [t6, {}];
            if (G(t6))
              return [t6, {}];
            if (q(t6))
              return [t6, {}];
            if (t6 && "object" == typeof t6)
              return [JSON.stringify(t6), { "content-type": "application/json" }];
            throw new Error("Unable to convert request body: Unexpected body type: ".concat(typeof t6));
          }(t5.data);
          n2.body = r2, e4 = W(e4, o3);
        }
        return t5.signal && (n2.signal = t5.signal), t5.withCredentials && (n2.credentials = "include"), n2.headers = e4, n2;
      }(t4)), t3);
    }
    var tt = n(285);
    const et = { "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true], "[:alpha:]": ["\\p{L}\\p{Nl}", true], "[:ascii:]": ["\\x00-\\x7f", false], "[:blank:]": ["\\p{Zs}\\t", true], "[:cntrl:]": ["\\p{Cc}", true], "[:digit:]": ["\\p{Nd}", true], "[:graph:]": ["\\p{Z}\\p{C}", true, true], "[:lower:]": ["\\p{Ll}", true], "[:print:]": ["\\p{C}", true], "[:punct:]": ["\\p{P}", true], "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true], "[:upper:]": ["\\p{Lu}", true], "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true], "[:xdigit:]": ["A-Fa-f0-9", false] }, nt = (t3) => t3.replace(/[[\]\\-]/g, "\\$&"), rt = (t3) => t3.join(""), ot = (t3, e3) => {
      const n2 = e3;
      if ("[" !== t3.charAt(n2))
        throw new Error("not in a brace expression");
      const r2 = [], o3 = [];
      let i3 = n2 + 1, s3 = false, a3 = false, c3 = false, u3 = false, l3 = n2, h3 = "";
      t:
        for (; i3 < t3.length; ) {
          const e4 = t3.charAt(i3);
          if ("!" !== e4 && "^" !== e4 || i3 !== n2 + 1) {
            if ("]" === e4 && s3 && !c3) {
              l3 = i3 + 1;
              break;
            }
            if (s3 = true, "\\" !== e4 || c3) {
              if ("[" === e4 && !c3) {
                for (const [e5, [s4, c4, u4]] of Object.entries(et))
                  if (t3.startsWith(e5, i3)) {
                    if (h3)
                      return ["$.", false, t3.length - n2, true];
                    i3 += e5.length, u4 ? o3.push(s4) : r2.push(s4), a3 = a3 || c4;
                    continue t;
                  }
              }
              c3 = false, h3 ? (e4 > h3 ? r2.push(nt(h3) + "-" + nt(e4)) : e4 === h3 && r2.push(nt(e4)), h3 = "", i3++) : t3.startsWith("-]", i3 + 1) ? (r2.push(nt(e4 + "-")), i3 += 2) : t3.startsWith("-", i3 + 1) ? (h3 = e4, i3 += 2) : (r2.push(nt(e4)), i3++);
            } else
              c3 = true, i3++;
          } else
            u3 = true, i3++;
        }
      if (l3 < i3)
        return ["", false, 0, false];
      if (!r2.length && !o3.length)
        return ["$.", false, t3.length - n2, true];
      if (0 === o3.length && 1 === r2.length && /^\\?.$/.test(r2[0]) && !u3) {
        return [(p3 = 2 === r2[0].length ? r2[0].slice(-1) : r2[0], p3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&")), false, l3 - n2, false];
      }
      var p3;
      const f3 = "[" + (u3 ? "^" : "") + rt(r2) + "]", d3 = "[" + (u3 ? "" : "^") + rt(o3) + "]";
      return [r2.length && o3.length ? "(" + f3 + "|" + d3 + ")" : r2.length ? f3 : d3, a3, l3 - n2, true];
    };
    function it(t3, e3, n2) {
      var r2;
      return (e3 = "symbol" == typeof (r2 = function(t4, e4) {
        if ("object" != typeof t4 || !t4)
          return t4;
        var n3 = t4[Symbol.toPrimitive];
        if (void 0 !== n3) {
          var r3 = n3.call(t4, "string");
          if ("object" != typeof r3)
            return r3;
          throw new TypeError("@@toPrimitive must return a primitive value.");
        }
        return String(t4);
      }(e3)) ? r2 : String(r2)) in t3 ? Object.defineProperty(t3, e3, { value: n2, enumerable: true, configurable: true, writable: true }) : t3[e3] = n2, t3;
    }
    const st = function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      return Ft(e3), !(!n2.nocomment && "#" === e3.charAt(0)) && new Bt(e3, n2).match(t3);
    }, at = st, ct = /^\*+([^+@!?\*\[\(]*)$/, ut = (t3) => (e3) => !e3.startsWith(".") && e3.endsWith(t3), lt = (t3) => (e3) => e3.endsWith(t3), ht = (t3) => (t3 = t3.toLowerCase(), (e3) => !e3.startsWith(".") && e3.toLowerCase().endsWith(t3)), pt = (t3) => (t3 = t3.toLowerCase(), (e3) => e3.toLowerCase().endsWith(t3)), ft = /^\*+\.\*+$/, dt = (t3) => !t3.startsWith(".") && t3.includes("."), gt = (t3) => "." !== t3 && ".." !== t3 && t3.includes("."), mt = /^\.\*+$/, vt = (t3) => "." !== t3 && ".." !== t3 && t3.startsWith("."), yt = /^\*+$/, bt = (t3) => 0 !== t3.length && !t3.startsWith("."), wt = (t3) => 0 !== t3.length && "." !== t3 && ".." !== t3, xt = /^\?+([^+@!?\*\[\(]*)?$/, Nt = (t3) => {
      let [e3, n2 = ""] = t3;
      const r2 = Et([e3]);
      return n2 ? (n2 = n2.toLowerCase(), (t4) => r2(t4) && t4.toLowerCase().endsWith(n2)) : r2;
    }, Pt = (t3) => {
      let [e3, n2 = ""] = t3;
      const r2 = Tt([e3]);
      return n2 ? (n2 = n2.toLowerCase(), (t4) => r2(t4) && t4.toLowerCase().endsWith(n2)) : r2;
    }, At = (t3) => {
      let [e3, n2 = ""] = t3;
      const r2 = Tt([e3]);
      return n2 ? (t4) => r2(t4) && t4.endsWith(n2) : r2;
    }, Ot = (t3) => {
      let [e3, n2 = ""] = t3;
      const r2 = Et([e3]);
      return n2 ? (t4) => r2(t4) && t4.endsWith(n2) : r2;
    }, Et = (t3) => {
      let [e3] = t3;
      const n2 = e3.length;
      return (t4) => t4.length === n2 && !t4.startsWith(".");
    }, Tt = (t3) => {
      let [e3] = t3;
      const n2 = e3.length;
      return (t4) => t4.length === n2 && "." !== t4 && ".." !== t4;
    }, jt = "object" == typeof process$1 && process$1 ? "object" == typeof process$1.env && process$1.env && process$1.env.__MINIMATCH_TESTING_PLATFORM__ || process$1.platform : "posix";
    st.sep = "win32" === jt ? "\\" : "/";
    const Ct = Symbol("globstar **");
    st.GLOBSTAR = Ct;
    const St = { "!": { open: "(?:(?!(?:", close: "))[^/]*?)" }, "?": { open: "(?:", close: ")?" }, "+": { open: "(?:", close: ")+" }, "*": { open: "(?:", close: ")*" }, "@": { open: "(?:", close: ")" } }, It = "[^/]", kt = It + "*?", Rt = (t3) => t3.split("").reduce((t4, e3) => (t4[e3] = true, t4), {}), Lt = Rt("().*{}+?[]^$\\!"), _t = Rt("[.(");
    st.filter = function(t3) {
      let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      return (n2) => st(n2, t3, e3);
    };
    const Ut = function(t3) {
      let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      return Object.assign({}, t3, e3);
    };
    st.defaults = (t3) => {
      if (!t3 || "object" != typeof t3 || !Object.keys(t3).length)
        return st;
      const e3 = st;
      return Object.assign(function(n2, r2) {
        return e3(n2, r2, Ut(t3, arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {}));
      }, { Minimatch: class extends e3.Minimatch {
        constructor(e4) {
          super(e4, Ut(t3, arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}));
        }
        static defaults(n2) {
          return e3.defaults(Ut(t3, n2)).Minimatch;
        }
      }, unescape: function(n2) {
        let r2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        return e3.unescape(n2, Ut(t3, r2));
      }, escape: function(n2) {
        let r2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        return e3.escape(n2, Ut(t3, r2));
      }, filter: function(n2) {
        let r2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        return e3.filter(n2, Ut(t3, r2));
      }, defaults: (n2) => e3.defaults(Ut(t3, n2)), makeRe: function(n2) {
        let r2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        return e3.makeRe(n2, Ut(t3, r2));
      }, braceExpand: function(n2) {
        let r2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        return e3.braceExpand(n2, Ut(t3, r2));
      }, match: function(n2, r2) {
        let o3 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
        return e3.match(n2, r2, Ut(t3, o3));
      }, sep: e3.sep, GLOBSTAR: Ct });
    };
    const Mt = function(t3) {
      let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      return Ft(t3), e3.nobrace || !/\{(?:(?!\{).)*\}/.test(t3) ? [t3] : tt(t3);
    };
    st.braceExpand = Mt;
    const Ft = (t3) => {
      if ("string" != typeof t3)
        throw new TypeError("invalid pattern");
      if (t3.length > 65536)
        throw new TypeError("pattern is too long");
    };
    st.makeRe = function(t3) {
      return new Bt(t3, arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}).makeRe();
    }, st.match = function(t3, e3) {
      const n2 = new Bt(e3, arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {});
      return t3 = t3.filter((t4) => n2.match(t4)), n2.options.nonull && !t3.length && t3.push(e3), t3;
    };
    const Dt = /[?*]|[+@!]\(.*?\)|\[|\]/, $t = (t3) => t3.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    class Bt {
      constructor(t3) {
        let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
        it(this, "options", void 0), it(this, "set", void 0), it(this, "pattern", void 0), it(this, "windowsPathsNoEscape", void 0), it(this, "nonegate", void 0), it(this, "negate", void 0), it(this, "comment", void 0), it(this, "empty", void 0), it(this, "preserveMultipleSlashes", void 0), it(this, "partial", void 0), it(this, "globSet", void 0), it(this, "globParts", void 0), it(this, "nocase", void 0), it(this, "isWindows", void 0), it(this, "platform", void 0), it(this, "windowsNoMagicRoot", void 0), it(this, "regexp", void 0), Ft(t3), e3 = e3 || {}, this.options = e3, this.pattern = t3, this.platform = e3.platform || jt, this.isWindows = "win32" === this.platform, this.windowsPathsNoEscape = !!e3.windowsPathsNoEscape || false === e3.allowWindowsEscape, this.windowsPathsNoEscape && (this.pattern = this.pattern.replace(/\\/g, "/")), this.preserveMultipleSlashes = !!e3.preserveMultipleSlashes, this.regexp = null, this.negate = false, this.nonegate = !!e3.nonegate, this.comment = false, this.empty = false, this.partial = !!e3.partial, this.nocase = !!this.options.nocase, this.windowsNoMagicRoot = void 0 !== e3.windowsNoMagicRoot ? e3.windowsNoMagicRoot : !(!this.isWindows || !this.nocase), this.globSet = [], this.globParts = [], this.set = [], this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1)
          return true;
        for (const t3 of this.set)
          for (const e3 of t3)
            if ("string" != typeof e3)
              return true;
        return false;
      }
      debug() {
      }
      make() {
        const t3 = this.pattern, e3 = this.options;
        if (!e3.nocomment && "#" === t3.charAt(0))
          return void (this.comment = true);
        if (!t3)
          return void (this.empty = true);
        this.parseNegate(), this.globSet = [...new Set(this.braceExpand())], e3.debug && (this.debug = function() {
          return console.error(...arguments);
        }), this.debug(this.pattern, this.globSet);
        const n2 = this.globSet.map((t4) => this.slashSplit(t4));
        this.globParts = this.preprocess(n2), this.debug(this.pattern, this.globParts);
        let r2 = this.globParts.map((t4, e4, n3) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const e5 = !("" !== t4[0] || "" !== t4[1] || "?" !== t4[2] && Dt.test(t4[2]) || Dt.test(t4[3])), n4 = /^[a-z]:/i.test(t4[0]);
            if (e5)
              return [...t4.slice(0, 4), ...t4.slice(4).map((t5) => this.parse(t5))];
            if (n4)
              return [t4[0], ...t4.slice(1).map((t5) => this.parse(t5))];
          }
          return t4.map((t5) => this.parse(t5));
        });
        if (this.debug(this.pattern, r2), this.set = r2.filter((t4) => -1 === t4.indexOf(false)), this.isWindows)
          for (let t4 = 0; t4 < this.set.length; t4++) {
            const e4 = this.set[t4];
            "" === e4[0] && "" === e4[1] && "?" === this.globParts[t4][2] && "string" == typeof e4[3] && /^[a-z]:$/i.test(e4[3]) && (e4[2] = "?");
          }
        this.debug(this.pattern, this.set);
      }
      preprocess(t3) {
        if (this.options.noglobstar)
          for (let e4 = 0; e4 < t3.length; e4++)
            for (let n2 = 0; n2 < t3[e4].length; n2++)
              "**" === t3[e4][n2] && (t3[e4][n2] = "*");
        const { optimizationLevel: e3 = 1 } = this.options;
        return e3 >= 2 ? (t3 = this.firstPhasePreProcess(t3), t3 = this.secondPhasePreProcess(t3)) : t3 = e3 >= 1 ? this.levelOneOptimize(t3) : this.adjascentGlobstarOptimize(t3), t3;
      }
      adjascentGlobstarOptimize(t3) {
        return t3.map((t4) => {
          let e3 = -1;
          for (; -1 !== (e3 = t4.indexOf("**", e3 + 1)); ) {
            let n2 = e3;
            for (; "**" === t4[n2 + 1]; )
              n2++;
            n2 !== e3 && t4.splice(e3, n2 - e3);
          }
          return t4;
        });
      }
      levelOneOptimize(t3) {
        return t3.map((t4) => 0 === (t4 = t4.reduce((t5, e3) => {
          const n2 = t5[t5.length - 1];
          return "**" === e3 && "**" === n2 ? t5 : ".." === e3 && n2 && ".." !== n2 && "." !== n2 && "**" !== n2 ? (t5.pop(), t5) : (t5.push(e3), t5);
        }, [])).length ? [""] : t4);
      }
      levelTwoFileOptimize(t3) {
        Array.isArray(t3) || (t3 = this.slashSplit(t3));
        let e3 = false;
        do {
          if (e3 = false, !this.preserveMultipleSlashes) {
            for (let n3 = 1; n3 < t3.length - 1; n3++) {
              const r2 = t3[n3];
              1 === n3 && "" === r2 && "" === t3[0] || "." !== r2 && "" !== r2 || (e3 = true, t3.splice(n3, 1), n3--);
            }
            "." !== t3[0] || 2 !== t3.length || "." !== t3[1] && "" !== t3[1] || (e3 = true, t3.pop());
          }
          let n2 = 0;
          for (; -1 !== (n2 = t3.indexOf("..", n2 + 1)); ) {
            const r2 = t3[n2 - 1];
            r2 && "." !== r2 && ".." !== r2 && "**" !== r2 && (e3 = true, t3.splice(n2 - 1, 2), n2 -= 2);
          }
        } while (e3);
        return 0 === t3.length ? [""] : t3;
      }
      firstPhasePreProcess(t3) {
        let e3 = false;
        do {
          e3 = false;
          for (let n2 of t3) {
            let r2 = -1;
            for (; -1 !== (r2 = n2.indexOf("**", r2 + 1)); ) {
              let o4 = r2;
              for (; "**" === n2[o4 + 1]; )
                o4++;
              o4 > r2 && n2.splice(r2 + 1, o4 - r2);
              let i3 = n2[r2 + 1];
              const s3 = n2[r2 + 2], a3 = n2[r2 + 3];
              if (".." !== i3)
                continue;
              if (!s3 || "." === s3 || ".." === s3 || !a3 || "." === a3 || ".." === a3)
                continue;
              e3 = true, n2.splice(r2, 1);
              const c3 = n2.slice(0);
              c3[r2] = "**", t3.push(c3), r2--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let t4 = 1; t4 < n2.length - 1; t4++) {
                const r3 = n2[t4];
                1 === t4 && "" === r3 && "" === n2[0] || "." !== r3 && "" !== r3 || (e3 = true, n2.splice(t4, 1), t4--);
              }
              "." !== n2[0] || 2 !== n2.length || "." !== n2[1] && "" !== n2[1] || (e3 = true, n2.pop());
            }
            let o3 = 0;
            for (; -1 !== (o3 = n2.indexOf("..", o3 + 1)); ) {
              const t4 = n2[o3 - 1];
              if (t4 && "." !== t4 && ".." !== t4 && "**" !== t4) {
                e3 = true;
                const t5 = 1 === o3 && "**" === n2[o3 + 1] ? ["."] : [];
                n2.splice(o3 - 1, 2, ...t5), 0 === n2.length && n2.push(""), o3 -= 2;
              }
            }
          }
        } while (e3);
        return t3;
      }
      secondPhasePreProcess(t3) {
        for (let e3 = 0; e3 < t3.length - 1; e3++)
          for (let n2 = e3 + 1; n2 < t3.length; n2++) {
            const r2 = this.partsMatch(t3[e3], t3[n2], !this.preserveMultipleSlashes);
            r2 && (t3[e3] = r2, t3[n2] = []);
          }
        return t3.filter((t4) => t4.length);
      }
      partsMatch(t3, e3) {
        let n2 = arguments.length > 2 && void 0 !== arguments[2] && arguments[2], r2 = 0, o3 = 0, i3 = [], s3 = "";
        for (; r2 < t3.length && o3 < e3.length; )
          if (t3[r2] === e3[o3])
            i3.push("b" === s3 ? e3[o3] : t3[r2]), r2++, o3++;
          else if (n2 && "**" === t3[r2] && e3[o3] === t3[r2 + 1])
            i3.push(t3[r2]), r2++;
          else if (n2 && "**" === e3[o3] && t3[r2] === e3[o3 + 1])
            i3.push(e3[o3]), o3++;
          else if ("*" !== t3[r2] || !e3[o3] || !this.options.dot && e3[o3].startsWith(".") || "**" === e3[o3]) {
            if ("*" !== e3[o3] || !t3[r2] || !this.options.dot && t3[r2].startsWith(".") || "**" === t3[r2])
              return false;
            if ("a" === s3)
              return false;
            s3 = "b", i3.push(e3[o3]), r2++, o3++;
          } else {
            if ("b" === s3)
              return false;
            s3 = "a", i3.push(t3[r2]), r2++, o3++;
          }
        return t3.length === e3.length && i3;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const t3 = this.pattern;
        let e3 = false, n2 = 0;
        for (let r2 = 0; r2 < t3.length && "!" === t3.charAt(r2); r2++)
          e3 = !e3, n2++;
        n2 && (this.pattern = t3.slice(n2)), this.negate = e3;
      }
      matchOne(t3, e3) {
        let n2 = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];
        const r2 = this.options;
        if (this.isWindows) {
          const n3 = "" === t3[0] && "" === t3[1] && "?" === t3[2] && "string" == typeof t3[3] && /^[a-z]:$/i.test(t3[3]), r3 = "" === e3[0] && "" === e3[1] && "?" === e3[2] && "string" == typeof e3[3] && /^[a-z]:$/i.test(e3[3]);
          if (n3 && r3) {
            const n4 = t3[3], r4 = e3[3];
            n4.toLowerCase() === r4.toLowerCase() && (t3[3] = r4);
          } else if (r3 && "string" == typeof t3[0]) {
            const n4 = e3[3], r4 = t3[0];
            n4.toLowerCase() === r4.toLowerCase() && (e3[3] = r4, e3 = e3.slice(3));
          } else if (n3 && "string" == typeof e3[0]) {
            const n4 = t3[3];
            n4.toLowerCase() === e3[0].toLowerCase() && (e3[0] = n4, t3 = t3.slice(3));
          }
        }
        const { optimizationLevel: o3 = 1 } = this.options;
        o3 >= 2 && (t3 = this.levelTwoFileOptimize(t3)), this.debug("matchOne", this, { file: t3, pattern: e3 }), this.debug("matchOne", t3.length, e3.length);
        for (var i3 = 0, s3 = 0, a3 = t3.length, c3 = e3.length; i3 < a3 && s3 < c3; i3++, s3++) {
          this.debug("matchOne loop");
          var u3 = e3[s3], l3 = t3[i3];
          if (this.debug(e3, u3, l3), false === u3)
            return false;
          if (u3 === Ct) {
            this.debug("GLOBSTAR", [e3, u3, l3]);
            var h3 = i3, p3 = s3 + 1;
            if (p3 === c3) {
              for (this.debug("** at the end"); i3 < a3; i3++)
                if ("." === t3[i3] || ".." === t3[i3] || !r2.dot && "." === t3[i3].charAt(0))
                  return false;
              return true;
            }
            for (; h3 < a3; ) {
              var f3 = t3[h3];
              if (this.debug("\nglobstar while", t3, h3, e3, p3, f3), this.matchOne(t3.slice(h3), e3.slice(p3), n2))
                return this.debug("globstar found match!", h3, a3, f3), true;
              if ("." === f3 || ".." === f3 || !r2.dot && "." === f3.charAt(0)) {
                this.debug("dot detected!", t3, h3, e3, p3);
                break;
              }
              this.debug("globstar swallow a segment, and continue"), h3++;
            }
            return !(!n2 || (this.debug("\n>>> no match, partial?", t3, h3, e3, p3), h3 !== a3));
          }
          let o4;
          if ("string" == typeof u3 ? (o4 = l3 === u3, this.debug("string match", u3, l3, o4)) : (o4 = u3.test(l3), this.debug("pattern match", u3, l3, o4)), !o4)
            return false;
        }
        if (i3 === a3 && s3 === c3)
          return true;
        if (i3 === a3)
          return n2;
        if (s3 === c3)
          return i3 === a3 - 1 && "" === t3[i3];
        throw new Error("wtf?");
      }
      braceExpand() {
        return Mt(this.pattern, this.options);
      }
      parse(t3) {
        Ft(t3);
        const e3 = this.options;
        if ("**" === t3)
          return Ct;
        if ("" === t3)
          return "";
        let n2, r2 = null;
        (n2 = t3.match(yt)) ? r2 = e3.dot ? wt : bt : (n2 = t3.match(ct)) ? r2 = (e3.nocase ? e3.dot ? pt : ht : e3.dot ? lt : ut)(n2[1]) : (n2 = t3.match(xt)) ? r2 = (e3.nocase ? e3.dot ? Pt : Nt : e3.dot ? At : Ot)(n2) : (n2 = t3.match(ft)) ? r2 = e3.dot ? gt : dt : (n2 = t3.match(mt)) && (r2 = vt);
        let o3 = "", i3 = false, s3 = false;
        const a3 = [], c3 = [];
        let u3, l3 = false, h3 = false, p3 = "." === t3.charAt(0), f3 = e3.dot || p3;
        const d3 = (t4) => "." === t4.charAt(0) ? "" : e3.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)", g2 = () => {
          if (l3) {
            switch (l3) {
              case "*":
                o3 += kt, i3 = true;
                break;
              case "?":
                o3 += It, i3 = true;
                break;
              default:
                o3 += "\\" + l3;
            }
            this.debug("clearStateChar %j %j", l3, o3), l3 = false;
          }
        };
        for (let n3, r3 = 0; r3 < t3.length && (n3 = t3.charAt(r3)); r3++)
          if (this.debug("%s	%s %s %j", t3, r3, o3, n3), s3) {
            if ("/" === n3)
              return false;
            Lt[n3] && (o3 += "\\"), o3 += n3, s3 = false;
          } else
            switch (n3) {
              case "/":
                return false;
              case "\\":
                g2(), s3 = true;
                continue;
              case "?":
              case "*":
              case "+":
              case "@":
              case "!":
                this.debug("%s	%s %s %j <-- stateChar", t3, r3, o3, n3), this.debug("call clearStateChar %j", l3), g2(), l3 = n3, e3.noext && g2();
                continue;
              case "(": {
                if (!l3) {
                  o3 += "\\(";
                  continue;
                }
                const e4 = { type: l3, start: r3 - 1, reStart: o3.length, open: St[l3].open, close: St[l3].close };
                this.debug(this.pattern, "	", e4), a3.push(e4), o3 += e4.open, 0 === e4.start && "!" !== e4.type && (p3 = true, o3 += d3(t3.slice(r3 + 1))), this.debug("plType %j %j", l3, o3), l3 = false;
                continue;
              }
              case ")": {
                const t4 = a3[a3.length - 1];
                if (!t4) {
                  o3 += "\\)";
                  continue;
                }
                a3.pop(), g2(), i3 = true, u3 = t4, o3 += u3.close, "!" === u3.type && c3.push(Object.assign(u3, { reEnd: o3.length }));
                continue;
              }
              case "|": {
                const e4 = a3[a3.length - 1];
                if (!e4) {
                  o3 += "\\|";
                  continue;
                }
                g2(), o3 += "|", 0 === e4.start && "!" !== e4.type && (p3 = true, o3 += d3(t3.slice(r3 + 1)));
                continue;
              }
              case "[":
                g2();
                const [f4, m3, v3, y2] = ot(t3, r3);
                v3 ? (o3 += f4, h3 = h3 || m3, r3 += v3 - 1, i3 = i3 || y2) : o3 += "\\[";
                continue;
              case "]":
                o3 += "\\" + n3;
                continue;
              default:
                g2(), o3 += $t(n3);
            }
        for (u3 = a3.pop(); u3; u3 = a3.pop()) {
          let t4;
          t4 = o3.slice(u3.reStart + u3.open.length), this.debug(this.pattern, "setting tail", o3, u3), t4 = t4.replace(/((?:\\{2}){0,64})(\\?)\|/g, (t5, e5, n3) => (n3 || (n3 = "\\"), e5 + e5 + n3 + "|")), this.debug("tail=%j\n   %s", t4, t4, u3, o3);
          const e4 = "*" === u3.type ? kt : "?" === u3.type ? It : "\\" + u3.type;
          i3 = true, o3 = o3.slice(0, u3.reStart) + e4 + "\\(" + t4;
        }
        g2(), s3 && (o3 += "\\\\");
        const m2 = _t[o3.charAt(0)];
        for (let t4 = c3.length - 1; t4 > -1; t4--) {
          const e4 = c3[t4], n3 = o3.slice(0, e4.reStart), r3 = o3.slice(e4.reStart, e4.reEnd - 8);
          let i4 = o3.slice(e4.reEnd);
          const s4 = o3.slice(e4.reEnd - 8, e4.reEnd) + i4, a4 = n3.split(")").length, u4 = n3.split("(").length - a4;
          let l4 = i4;
          for (let t5 = 0; t5 < u4; t5++)
            l4 = l4.replace(/\)[+*?]?/, "");
          i4 = l4, o3 = n3 + r3 + i4 + ("" === i4 ? "(?:$|\\/)" : "") + s4;
        }
        if ("" !== o3 && i3 && (o3 = "(?=.)" + o3), m2 && (o3 = (p3 ? "" : f3 ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)") + o3), !e3.nocase || i3 || e3.nocaseMagicOnly || (i3 = t3.toUpperCase() !== t3.toLowerCase()), !i3)
          return o3.replace(/\\(.)/g, "$1");
        const v2 = (e3.nocase ? "i" : "") + (h3 ? "u" : "");
        try {
          const e4 = r2 ? { _glob: t3, _src: o3, test: r2 } : { _glob: t3, _src: o3 };
          return Object.assign(new RegExp("^" + o3 + "$", v2), e4);
        } catch (t4) {
          return this.debug("invalid regexp", t4), new RegExp("$.");
        }
      }
      makeRe() {
        if (this.regexp || false === this.regexp)
          return this.regexp;
        const t3 = this.set;
        if (!t3.length)
          return this.regexp = false, this.regexp;
        const e3 = this.options, n2 = e3.noglobstar ? kt : e3.dot ? "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?" : "(?:(?!(?:\\/|^)\\.).)*?", r2 = e3.nocase ? "i" : "";
        let o3 = t3.map((t4) => {
          const e4 = t4.map((t5) => "string" == typeof t5 ? $t(t5) : t5 === Ct ? Ct : t5._src);
          return e4.forEach((t5, r3) => {
            const o4 = e4[r3 + 1], i3 = e4[r3 - 1];
            t5 === Ct && i3 !== Ct && (void 0 === i3 ? void 0 !== o4 && o4 !== Ct ? e4[r3 + 1] = "(?:\\/|" + n2 + "\\/)?" + o4 : e4[r3] = n2 : void 0 === o4 ? e4[r3 - 1] = i3 + "(?:\\/|" + n2 + ")?" : o4 !== Ct && (e4[r3 - 1] = i3 + "(?:\\/|\\/" + n2 + "\\/)" + o4, e4[r3 + 1] = Ct));
          }), e4.filter((t5) => t5 !== Ct).join("/");
        }).join("|");
        o3 = "^(?:" + o3 + ")$", this.negate && (o3 = "^(?!" + o3 + ").*$");
        try {
          this.regexp = new RegExp(o3, r2);
        } catch (t4) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(t3) {
        return this.preserveMultipleSlashes ? t3.split("/") : this.isWindows && /^\/\/[^\/]+/.test(t3) ? ["", ...t3.split(/\/+/)] : t3.split(/\/+/);
      }
      match(t3) {
        let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : this.partial;
        if (this.debug("match", t3, this.pattern), this.comment)
          return false;
        if (this.empty)
          return "" === t3;
        if ("/" === t3 && e3)
          return true;
        const n2 = this.options;
        this.isWindows && (t3 = t3.split("\\").join("/"));
        const r2 = this.slashSplit(t3);
        this.debug(this.pattern, "split", r2);
        const o3 = this.set;
        this.debug(this.pattern, "set", o3);
        let i3 = r2[r2.length - 1];
        if (!i3)
          for (let t4 = r2.length - 2; !i3 && t4 >= 0; t4--)
            i3 = r2[t4];
        for (let t4 = 0; t4 < o3.length; t4++) {
          const s3 = o3[t4];
          let a3 = r2;
          if (n2.matchBase && 1 === s3.length && (a3 = [i3]), this.matchOne(a3, s3, e3))
            return !!n2.flipNegate || !this.negate;
        }
        return !n2.flipNegate && this.negate;
      }
      static defaults(t3) {
        return st.defaults(t3).Minimatch;
      }
    }
    function Wt(t3) {
      const e3 = new Error("".concat(arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "", "Invalid response: ").concat(t3.status, " ").concat(t3.statusText));
      return e3.status = t3.status, e3.response = t3, e3;
    }
    function Vt(t3, e3) {
      const { status: n2 } = e3;
      if (401 === n2 && t3.digest)
        return e3;
      if (n2 >= 400)
        throw Wt(e3);
      return e3;
    }
    function zt(t3, e3) {
      return arguments.length > 2 && void 0 !== arguments[2] && arguments[2] ? { data: e3, headers: t3.headers ? B(t3.headers) : {}, status: t3.status, statusText: t3.statusText } : e3;
    }
    st.Minimatch = Bt, st.escape = function(t3) {
      let { windowsPathsNoEscape: e3 = false } = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      return e3 ? t3.replace(/[?*()[\]]/g, "[$&]") : t3.replace(/[?*()[\]\\]/g, "\\$&");
    }, st.unescape = function(t3) {
      let { windowsPathsNoEscape: e3 = false } = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      return e3 ? t3.replace(/\[([^\/\\])\]/g, "$1") : t3.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
    };
    const qt = (Gt = function(t3, e3, n2) {
      let r2 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      const o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "COPY", headers: { Destination: g(t3.remoteURL, h2(n2)), Overwrite: false === r2.overwrite ? "F" : "T", Depth: r2.shallow ? "0" : "infinity" } }, t3, r2);
      return s3 = function(e4) {
        Vt(t3, e4);
      }, (i3 = K(o3, t3)) && i3.then || (i3 = Promise.resolve(i3)), s3 ? i3.then(s3) : i3;
      var i3, s3;
    }, function() {
      for (var t3 = [], e3 = 0; e3 < arguments.length; e3++)
        t3[e3] = arguments[e3];
      try {
        return Promise.resolve(Gt.apply(this, t3));
      } catch (t4) {
        return Promise.reject(t4);
      }
    });
    var Gt, Ht = n(635), Xt = n(829), Zt = n.n(Xt), Yt = function(t3) {
      return t3.Array = "array", t3.Object = "object", t3.Original = "original", t3;
    }(Yt || {});
    function Kt(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : Yt.Original;
      const r2 = Zt().get(t3, e3);
      return "array" === n2 && false === Array.isArray(r2) ? [r2] : "object" === n2 && Array.isArray(r2) ? r2[0] : r2;
    }
    function Jt(t3) {
      return new Promise((e3) => {
        e3(function(t4) {
          const { multistatus: e4 } = t4;
          if ("" === e4)
            return { multistatus: { response: [] } };
          if (!e4)
            throw new Error("Invalid response: No root multistatus found");
          const n2 = { multistatus: Array.isArray(e4) ? e4[0] : e4 };
          return Zt().set(n2, "multistatus.response", Kt(n2, "multistatus.response", Yt.Array)), Zt().set(n2, "multistatus.response", Zt().get(n2, "multistatus.response").map((t5) => function(t6) {
            const e5 = Object.assign({}, t6);
            return e5.status ? Zt().set(e5, "status", Kt(e5, "status", Yt.Object)) : (Zt().set(e5, "propstat", Kt(e5, "propstat", Yt.Object)), Zt().set(e5, "propstat.prop", Kt(e5, "propstat.prop", Yt.Object))), e5;
          }(t5))), n2;
        }(new Ht.XMLParser({ removeNSPrefix: true, numberParseOptions: { hex: true, leadingZeros: false } }).parse(t3)));
      });
    }
    function Qt(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];
      const { getlastmodified: r2 = null, getcontentlength: o3 = "0", resourcetype: i3 = null, getcontenttype: s3 = null, getetag: a3 = null } = t3, u3 = i3 && "object" == typeof i3 && void 0 !== i3.collection ? "directory" : "file", l3 = { filename: e3, basename: c2().basename(e3), lastmod: r2, size: parseInt(o3, 10), type: u3, etag: "string" == typeof a3 ? a3.replace(/"/g, "") : null };
      return "file" === u3 && (l3.mime = s3 && "string" == typeof s3 ? s3.split(";")[0] : ""), n2 && (l3.props = t3), l3;
    }
    function te(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] && arguments[2], r2 = null;
      try {
        t3.multistatus.response[0].propstat && (r2 = t3.multistatus.response[0]);
      } catch (t4) {
      }
      if (!r2)
        throw new Error("Failed getting item stat: bad response");
      const { propstat: { prop: o3, status: i3 } } = r2, [s3, a3, c3] = i3.split(" ", 3), u3 = parseInt(a3, 10);
      if (u3 >= 400) {
        const t4 = new Error("Invalid response: ".concat(u3, " ").concat(c3));
        throw t4.status = u3, t4;
      }
      return Qt(o3, f2(e3), n2);
    }
    function ee(t3) {
      switch (t3.toString()) {
        case "-3":
          return "unlimited";
        case "-2":
        case "-1":
          return "unknown";
        default:
          return parseInt(t3, 10);
      }
    }
    function ne(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const re = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const { details: r2 = false } = n2, o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "PROPFIND", headers: { Accept: "text/plain,application/xml", Depth: "0" } }, t3, n2);
      return ne(K(o3, t3), function(n3) {
        return Vt(t3, n3), ne(n3.text(), function(t4) {
          return ne(Jt(t4), function(t5) {
            const o4 = te(t5, e3, r2);
            return zt(n3, o4, r2);
          });
        });
      });
    });
    function oe(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const ie = se(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = function(t4) {
        if (!t4 || "/" === t4)
          return [];
        let e4 = t4;
        const n3 = [];
        do {
          n3.push(e4), e4 = c2().dirname(e4);
        } while (e4 && "/" !== e4);
        return n3;
      }(f2(e3));
      r2.sort((t4, e4) => t4.length > e4.length ? 1 : e4.length > t4.length ? -1 : 0);
      let o3 = false;
      return function(t4, e4, n3) {
        if ("function" == typeof t4[ue]) {
          let l3 = function(t5) {
            try {
              for (; !(r3 = s3.next()).done; )
                if ((t5 = e4(r3.value)) && t5.then) {
                  if (!pe(t5))
                    return void t5.then(l3, i3 || (i3 = le.bind(null, o4 = new he(), 2)));
                  t5 = t5.v;
                }
              o4 ? le(o4, 1, t5) : o4 = t5;
            } catch (t6) {
              le(o4 || (o4 = new he()), 2, t6);
            }
          };
          var r3, o4, i3, s3 = t4[ue]();
          if (l3(), s3.return) {
            var a3 = function(t5) {
              try {
                r3.done || s3.return();
              } catch (t6) {
              }
              return t5;
            };
            if (o4 && o4.then)
              return o4.then(a3, function(t5) {
                throw a3(t5);
              });
            a3();
          }
          return o4;
        }
        if (!("length" in t4))
          throw new TypeError("Object is not iterable");
        for (var c3 = [], u3 = 0; u3 < t4.length; u3++)
          c3.push(t4[u3]);
        return function(t5, e5, n4) {
          var r4, o5, i4 = -1;
          return function s4(a4) {
            try {
              for (; ++i4 < t5.length && (!n4 || !n4()); )
                if ((a4 = e5(i4)) && a4.then) {
                  if (!pe(a4))
                    return void a4.then(s4, o5 || (o5 = le.bind(null, r4 = new he(), 2)));
                  a4 = a4.v;
                }
              r4 ? le(r4, 1, a4) : r4 = a4;
            } catch (t6) {
              le(r4 || (r4 = new he()), 2, t6);
            }
          }(), r4;
        }(c3, function(t5) {
          return e4(c3[t5]);
        }, n3);
      }(r2, function(r3) {
        return i3 = function() {
          return function(n3, o4) {
            try {
              var i4 = oe(re(t3, r3), function(t4) {
                if ("directory" !== t4.type)
                  throw new Error("Path includes a file: ".concat(e3));
              });
            } catch (t4) {
              return o4(t4);
            }
            return i4 && i4.then ? i4.then(void 0, o4) : i4;
          }(0, function(e4) {
            const i4 = e4;
            return function() {
              if (404 === i4.status)
                return o3 = true, ce(fe(t3, r3, { ...n2, recursive: false }));
              throw e4;
            }();
          });
        }, (s3 = function() {
          if (o3)
            return ce(fe(t3, r3, { ...n2, recursive: false }));
        }()) && s3.then ? s3.then(i3) : i3();
        var i3, s3;
      }, function() {
        return false;
      });
    });
    function se(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }
    function ae() {
    }
    function ce(t3, e3) {
      if (!e3)
        return t3 && t3.then ? t3.then(ae) : Promise.resolve();
    }
    const ue = "undefined" != typeof Symbol ? Symbol.iterator || (Symbol.iterator = Symbol("Symbol.iterator")) : "@@iterator";
    function le(t3, e3, n2) {
      if (!t3.s) {
        if (n2 instanceof he) {
          if (!n2.s)
            return void (n2.o = le.bind(null, t3, e3));
          1 & e3 && (e3 = n2.s), n2 = n2.v;
        }
        if (n2 && n2.then)
          return void n2.then(le.bind(null, t3, e3), le.bind(null, t3, 2));
        t3.s = e3, t3.v = n2;
        const r2 = t3.o;
        r2 && r2(t3);
      }
    }
    const he = function() {
      function t3() {
      }
      return t3.prototype.then = function(e3, n2) {
        const r2 = new t3(), o3 = this.s;
        if (o3) {
          const t4 = 1 & o3 ? e3 : n2;
          if (t4) {
            try {
              le(r2, 1, t4(this.v));
            } catch (t5) {
              le(r2, 2, t5);
            }
            return r2;
          }
          return this;
        }
        return this.o = function(t4) {
          try {
            const o4 = t4.v;
            1 & t4.s ? le(r2, 1, e3 ? e3(o4) : o4) : n2 ? le(r2, 1, n2(o4)) : le(r2, 2, o4);
          } catch (t5) {
            le(r2, 2, t5);
          }
        }, r2;
      }, t3;
    }();
    function pe(t3) {
      return t3 instanceof he && 1 & t3.s;
    }
    const fe = se(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      if (true === n2.recursive)
        return ie(t3, e3, n2);
      const r2 = J({ url: g(t3.remoteURL, (o3 = h2(e3), o3.endsWith("/") ? o3 : o3 + "/")), method: "MKCOL" }, t3, n2);
      var o3;
      return oe(K(r2, t3), function(e4) {
        Vt(t3, e4);
      });
    });
    var de = n(388), ge = n.n(de);
    const me = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = {};
      if ("object" == typeof n2.range && "number" == typeof n2.range.start) {
        let t4 = "bytes=".concat(n2.range.start, "-");
        "number" == typeof n2.range.end && (t4 = "".concat(t4).concat(n2.range.end)), r2.Range = t4;
      }
      const o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "GET", headers: r2 }, t3, n2);
      return s3 = function(e4) {
        if (Vt(t3, e4), r2.Range && 206 !== e4.status) {
          const t4 = new Error("Invalid response code for partial request: ".concat(e4.status));
          throw t4.status = e4.status, t4;
        }
        return n2.callback && setTimeout(() => {
          n2.callback(e4);
        }, 0), e4.body;
      }, (i3 = K(o3, t3)) && i3.then || (i3 = Promise.resolve(i3)), s3 ? i3.then(s3) : i3;
      var i3, s3;
    }), ve = () => {
    }, ye = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3, n2) {
      n2.url || (n2.url = g(t3.remoteURL, h2(e3)));
      const r2 = J(n2, t3, {});
      return i3 = function(e4) {
        return Vt(t3, e4), e4;
      }, (o3 = K(r2, t3)) && o3.then || (o3 = Promise.resolve(o3)), i3 ? o3.then(i3) : o3;
      var o3, i3;
    }), be = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = J({ url: g(t3.remoteURL, h2(e3)), method: "DELETE" }, t3, n2);
      return i3 = function(e4) {
        Vt(t3, e4);
      }, (o3 = K(r2, t3)) && o3.then || (o3 = Promise.resolve(o3)), i3 ? o3.then(i3) : o3;
      var o3, i3;
    }), we = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      return function(r2, o3) {
        try {
          var i3 = (s3 = re(t3, e3, n2), a3 = function() {
            return true;
          }, c3 ? a3 ? a3(s3) : s3 : (s3 && s3.then || (s3 = Promise.resolve(s3)), a3 ? s3.then(a3) : s3));
        } catch (t4) {
          return o3(t4);
        }
        var s3, a3, c3;
        return i3 && i3.then ? i3.then(void 0, o3) : i3;
      }(0, function(t4) {
        if (404 === t4.status)
          return false;
        throw t4;
      });
    });
    function xe(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const Ne = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = J({ url: g(t3.remoteURL, h2(e3), "/"), method: "PROPFIND", headers: { Accept: "text/plain,application/xml", Depth: n2.deep ? "infinity" : "1" } }, t3, n2);
      return xe(K(r2, t3), function(r3) {
        return Vt(t3, r3), xe(r3.text(), function(o3) {
          if (!o3)
            throw new Error("Failed parsing directory contents: Empty response");
          return xe(Jt(o3), function(o4) {
            const i3 = p2(e3);
            let a3 = function(t4, e4, n3) {
              let r4 = arguments.length > 3 && void 0 !== arguments[3] && arguments[3], o5 = arguments.length > 4 && void 0 !== arguments[4] && arguments[4];
              const i4 = c2().join(e4, "/"), { multistatus: { response: a4 } } = t4, u3 = a4.map((t5) => {
                const e5 = function(t6) {
                  try {
                    return t6.replace(/^https?:\/\/[^\/]+/, "");
                  } catch (t7) {
                    throw new s2(t7, "Failed normalising HREF");
                  }
                }(t5.href), { propstat: { prop: n4 } } = t5;
                return Qt(n4, "/" === i4 ? decodeURIComponent(f2(e5)) : f2(c2().relative(decodeURIComponent(i4), decodeURIComponent(e5))), r4);
              });
              return o5 ? u3 : u3.filter((t5) => t5.basename && ("file" === t5.type || t5.filename !== n3.replace(/\/$/, "")));
            }(o4, p2(t3.remoteBasePath || t3.remotePath), i3, n2.details, n2.includeSelf);
            return n2.glob && (a3 = function(t4, e4) {
              return t4.filter((t5) => at(t5.filename, e4, { matchBase: true }));
            }(a3, n2.glob)), zt(r3, a3, n2.details);
          });
        });
      });
    });
    function Pe(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }
    const Ae = Pe(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = J({ url: g(t3.remoteURL, h2(e3)), method: "GET", headers: { Accept: "text/plain" }, transformResponse: [je] }, t3, n2);
      return Oe(K(r2, t3), function(e4) {
        return Vt(t3, e4), Oe(e4.text(), function(t4) {
          return zt(e4, t4, n2.details);
        });
      });
    });
    function Oe(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const Ee = Pe(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = J({ url: g(t3.remoteURL, h2(e3)), method: "GET" }, t3, n2);
      return Oe(K(r2, t3), function(e4) {
        let r3;
        return Vt(t3, e4), function(t4, e5) {
          var n3 = t4();
          return n3 && n3.then ? n3.then(e5) : e5();
        }(function() {
          return Oe(e4.arrayBuffer(), function(t4) {
            r3 = t4;
          });
        }, function() {
          return zt(e4, r3, n2.details);
        });
      });
    }), Te = Pe(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const { format: r2 = "binary" } = n2;
      if ("binary" !== r2 && "text" !== r2)
        throw new s2({ info: { code: S.InvalidOutputFormat } }, "Invalid output format: ".concat(r2));
      return "text" === r2 ? Ae(t3, e3, n2) : Ee(t3, e3, n2);
    }), je = (t3) => t3;
    function Ce(t3) {
      return new Ht.XMLBuilder({ attributeNamePrefix: "@_", format: true, ignoreAttributes: false, suppressEmptyNode: true }).build(Se({ lockinfo: { "@_xmlns:d": "DAV:", lockscope: { exclusive: {} }, locktype: { write: {} }, owner: { href: t3 } } }, "d"));
    }
    function Se(t3, e3) {
      const n2 = { ...t3 };
      for (const t4 in n2)
        n2.hasOwnProperty(t4) && (n2[t4] && "object" == typeof n2[t4] && -1 === t4.indexOf(":") ? (n2["".concat(e3, ":").concat(t4)] = Se(n2[t4], e3), delete n2[t4]) : false === /^@_/.test(t4) && (n2["".concat(e3, ":").concat(t4)] = n2[t4], delete n2[t4]));
      return n2;
    }
    function Ie(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    function ke(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }
    const Re = ke(function(t3, e3, n2) {
      let r2 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      const o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "UNLOCK", headers: { "Lock-Token": n2 } }, t3, r2);
      return Ie(K(o3, t3), function(e4) {
        if (Vt(t3, e4), 204 !== e4.status && 200 !== e4.status)
          throw Wt(e4);
      });
    }), Le = ke(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const { refreshToken: r2, timeout: o3 = _e } = n2, i3 = { Accept: "text/plain,application/xml", Timeout: o3 };
      r2 && (i3.If = r2);
      const s3 = J({ url: g(t3.remoteURL, h2(e3)), method: "LOCK", headers: i3, data: Ce(t3.contactHref) }, t3, n2);
      return Ie(K(s3, t3), function(e4) {
        return Vt(t3, e4), Ie(e4.text(), function(t4) {
          const n3 = (i4 = t4, new Ht.XMLParser({ removeNSPrefix: true, parseAttributeValue: true, parseTagValue: true }).parse(i4)), r3 = Zt().get(n3, "prop.lockdiscovery.activelock.locktoken.href"), o4 = Zt().get(n3, "prop.lockdiscovery.activelock.timeout");
          var i4;
          if (!r3)
            throw Wt(e4, "No lock token received: ");
          return { token: r3, serverTimeout: o4 };
        });
      });
    }), _e = "Infinite, Second-4100000000";
    function Ue(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const Me = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3) {
      let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      const n2 = e3.path || "/", r2 = J({ url: g(t3.remoteURL, n2), method: "PROPFIND", headers: { Accept: "text/plain,application/xml", Depth: "0" } }, t3, e3);
      return Ue(K(r2, t3), function(n3) {
        return Vt(t3, n3), Ue(n3.text(), function(t4) {
          return Ue(Jt(t4), function(t5) {
            const r3 = function(t6) {
              try {
                const [e4] = t6.multistatus.response, { propstat: { prop: { "quota-used-bytes": n4, "quota-available-bytes": r4 } } } = e4;
                return void 0 !== n4 && void 0 !== r4 ? { used: parseInt(n4, 10), available: ee(r4) } : null;
              } catch (t7) {
              }
              return null;
            }(t5);
            return zt(n3, r3, e3.details);
          });
        });
      });
    });
    function Fe(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const De = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const { details: r2 = false } = n2, o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "SEARCH", headers: { Accept: "text/plain,application/xml", "Content-Type": t3.headers["Content-Type"] || "application/xml; charset=utf-8" } }, t3, n2);
      return Fe(K(o3, t3), function(n3) {
        return Vt(t3, n3), Fe(n3.text(), function(t4) {
          return Fe(Jt(t4), function(t5) {
            const o4 = function(t6, e4, n4) {
              const r3 = { truncated: false, results: [] };
              return r3.truncated = t6.multistatus.response.some((t7) => {
                var n5, r4;
                return "507" === (null === (n5 = (t7.status || (null === (r4 = t7.propstat) || void 0 === r4 ? void 0 : r4.status)).split(" ", 3)) || void 0 === n5 ? void 0 : n5[1]) && t7.href.replace(/\/$/, "").endsWith(h2(e4).replace(/\/$/, ""));
              }), t6.multistatus.response.forEach((t7) => {
                if (void 0 === t7.propstat)
                  return;
                const e5 = t7.href.split("/").map(decodeURIComponent).join("/");
                r3.results.push(Qt(t7.propstat.prop, e5, n4));
              }), r3;
            }(t5, e3, r2);
            return zt(n3, o4, r2);
          });
        });
      });
    }), $e = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3, n2) {
      let r2 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      const o3 = J({ url: g(t3.remoteURL, h2(e3)), method: "MOVE", headers: { Destination: g(t3.remoteURL, h2(n2)), Overwrite: false === r2.overwrite ? "F" : "T" } }, t3, r2);
      return s3 = function(e4) {
        Vt(t3, e4);
      }, (i3 = K(o3, t3)) && i3.then || (i3 = Promise.resolve(i3)), s3 ? i3.then(s3) : i3;
      var i3, s3;
    });
    var Be = n(172);
    const We = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3, n2) {
      let r2 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : {};
      const { contentLength: o3 = true, overwrite: i3 = true } = r2, a3 = { "Content-Type": "application/octet-stream" };
      false === o3 || (a3["Content-Length"] = "".concat("number" == typeof o3 ? o3 : function(t4) {
        if (q(t4))
          return t4.byteLength;
        if (G(t4))
          return t4.length;
        if ("string" == typeof t4)
          return (0, Be.d)(t4);
        throw new s2({ info: { code: S.DataTypeNoLength } }, "Cannot calculate data length: Invalid type");
      }(n2))), i3 || (a3["If-None-Match"] = "*");
      const c3 = J({ url: g(t3.remoteURL, h2(e3)), method: "PUT", headers: a3, data: n2 }, t3, r2);
      return l3 = function(e4) {
        try {
          Vt(t3, e4);
        } catch (t4) {
          const e5 = t4;
          if (412 !== e5.status || i3)
            throw e5;
          return false;
        }
        return true;
      }, (u3 = K(c3, t3)) && u3.then || (u3 = Promise.resolve(u3)), l3 ? u3.then(l3) : u3;
      var u3, l3;
    }), Ve = /* @__PURE__ */ function(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }(function(t3, e3) {
      let n2 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
      const r2 = J({ url: g(t3.remoteURL, h2(e3)), method: "OPTIONS" }, t3, n2);
      return i3 = function(e4) {
        var n3, r3;
        try {
          Vt(t3, e4);
        } catch (t4) {
          throw t4;
        }
        return { compliance: (null !== (n3 = e4.headers.get("DAV")) && void 0 !== n3 ? n3 : "").split(",").map((t4) => t4.trim()), server: null !== (r3 = e4.headers.get("Server")) && void 0 !== r3 ? r3 : "" };
      }, (o3 = K(r2, t3)) && o3.then || (o3 = Promise.resolve(o3)), i3 ? o3.then(i3) : o3;
      var o3, i3;
    });
    function ze(t3, e3, n2) {
      return n2 ? e3 ? e3(t3) : t3 : (t3 && t3.then || (t3 = Promise.resolve(t3)), e3 ? t3.then(e3) : t3);
    }
    const qe = Xe(function(t3, e3, n2, r2, o3) {
      let i3 = arguments.length > 5 && void 0 !== arguments[5] ? arguments[5] : {};
      if (n2 > r2 || n2 < 0)
        throw new s2({ info: { code: S.InvalidUpdateRange } }, "Invalid update range ".concat(n2, " for partial update"));
      const a3 = { "Content-Type": "application/octet-stream", "Content-Length": "".concat(r2 - n2 + 1), "Content-Range": "bytes ".concat(n2, "-").concat(r2, "/*") }, c3 = J({ url: g(t3.remoteURL, h2(e3)), method: "PUT", headers: a3, data: o3 }, t3, i3);
      return ze(K(c3, t3), function(e4) {
        Vt(t3, e4);
      });
    });
    function Ge(t3, e3) {
      var n2 = t3();
      return n2 && n2.then ? n2.then(e3) : e3(n2);
    }
    const He = Xe(function(t3, e3, n2, r2, o3) {
      let i3 = arguments.length > 5 && void 0 !== arguments[5] ? arguments[5] : {};
      if (n2 > r2 || n2 < 0)
        throw new s2({ info: { code: S.InvalidUpdateRange } }, "Invalid update range ".concat(n2, " for partial update"));
      const a3 = { "Content-Type": "application/x-sabredav-partialupdate", "Content-Length": "".concat(r2 - n2 + 1), "X-Update-Range": "bytes=".concat(n2, "-").concat(r2) }, c3 = J({ url: g(t3.remoteURL, h2(e3)), method: "PATCH", headers: a3, data: o3 }, t3, i3);
      return ze(K(c3, t3), function(e4) {
        Vt(t3, e4);
      });
    });
    function Xe(t3) {
      return function() {
        for (var e3 = [], n2 = 0; n2 < arguments.length; n2++)
          e3[n2] = arguments[n2];
        try {
          return Promise.resolve(t3.apply(this, e3));
        } catch (t4) {
          return Promise.reject(t4);
        }
      };
    }
    const Ze = Xe(function(t3, e3, n2, r2, o3) {
      let i3 = arguments.length > 5 && void 0 !== arguments[5] ? arguments[5] : {};
      return ze(Ve(t3, e3, i3), function(a3) {
        let c3 = false;
        return Ge(function() {
          if (a3.compliance.includes("sabredav-partialupdate"))
            return ze(He(t3, e3, n2, r2, o3, i3), function(t4) {
              return c3 = true, t4;
            });
        }, function(u3) {
          let l3 = false;
          return c3 ? u3 : Ge(function() {
            if (a3.server.includes("Apache") && a3.compliance.includes("<http://apache.org/dav/propset/fs/1>"))
              return ze(qe(t3, e3, n2, r2, o3, i3), function(t4) {
                return l3 = true, t4;
              });
          }, function(t4) {
            if (l3)
              return t4;
            throw new s2({ info: { code: S.NotSupported } }, "Not supported");
          });
        });
      });
    }), Ye = "https://github.com/perry-mitchell/webdav-client/blob/master/LOCK_CONTACT.md";
    function Ke(t3) {
      let e3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
      const { authType: n2 = null, remoteBasePath: r2, contactHref: o3 = Ye, ha1: i3, headers: a3 = {}, httpAgent: c3, httpsAgent: u3, password: l3, token: p3, username: f3, withCredentials: m2 } = e3;
      let v2 = n2;
      v2 || (v2 = f3 || l3 ? C.Password : C.None);
      const y2 = { authType: v2, remoteBasePath: r2, contactHref: o3, ha1: i3, headers: Object.assign({}, a3), httpAgent: c3, httpsAgent: u3, password: l3, remotePath: d2(t3), remoteURL: t3, token: p3, username: f3, withCredentials: m2 };
      return I(y2, f3, l3, p3, i3), { copyFile: (t4, e4, n3) => qt(y2, t4, e4, n3), createDirectory: (t4, e4) => fe(y2, t4, e4), createReadStream: (t4, e4) => function(t5, e5) {
        let n3 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
        const r3 = new (0, ge().PassThrough)();
        return me(t5, e5, n3).then((t6) => {
          t6.pipe(r3);
        }).catch((t6) => {
          r3.emit("error", t6);
        }), r3;
      }(y2, t4, e4), createWriteStream: (t4, e4, n3) => function(t5, e5) {
        let n4 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {}, r3 = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : ve;
        const o4 = new (0, ge().PassThrough)(), i4 = {};
        false === n4.overwrite && (i4["If-None-Match"] = "*");
        const s3 = J({ url: g(t5.remoteURL, h2(e5)), method: "PUT", headers: i4, data: o4, maxRedirects: 0 }, t5, n4);
        return K(s3, t5).then((e6) => Vt(t5, e6)).then((t6) => {
          setTimeout(() => {
            r3(t6);
          }, 0);
        }).catch((t6) => {
          o4.emit("error", t6);
        }), o4;
      }(y2, t4, e4, n3), customRequest: (t4, e4) => ye(y2, t4, e4), deleteFile: (t4, e4) => be(y2, t4, e4), exists: (t4, e4) => we(y2, t4, e4), getDirectoryContents: (t4, e4) => Ne(y2, t4, e4), getFileContents: (t4, e4) => Te(y2, t4, e4), getFileDownloadLink: (t4) => function(t5, e4) {
        let n3 = g(t5.remoteURL, h2(e4));
        const r3 = /^https:/i.test(n3) ? "https" : "http";
        switch (t5.authType) {
          case C.None:
            break;
          case C.Password: {
            const e5 = P(t5.headers.Authorization.replace(/^Basic /i, "").trim());
            n3 = n3.replace(/^https?:\/\//, "".concat(r3, "://").concat(e5, "@"));
            break;
          }
          default:
            throw new s2({ info: { code: S.LinkUnsupportedAuthType } }, "Unsupported auth type for file link: ".concat(t5.authType));
        }
        return n3;
      }(y2, t4), getFileUploadLink: (t4) => function(t5, e4) {
        let n3 = "".concat(g(t5.remoteURL, h2(e4)), "?Content-Type=application/octet-stream");
        const r3 = /^https:/i.test(n3) ? "https" : "http";
        switch (t5.authType) {
          case C.None:
            break;
          case C.Password: {
            const e5 = P(t5.headers.Authorization.replace(/^Basic /i, "").trim());
            n3 = n3.replace(/^https?:\/\//, "".concat(r3, "://").concat(e5, "@"));
            break;
          }
          default:
            throw new s2({ info: { code: S.LinkUnsupportedAuthType } }, "Unsupported auth type for file link: ".concat(t5.authType));
        }
        return n3;
      }(y2, t4), getHeaders: () => Object.assign({}, y2.headers), getQuota: (t4) => Me(y2, t4), lock: (t4, e4) => Le(y2, t4, e4), moveFile: (t4, e4, n3) => $e(y2, t4, e4, n3), putFileContents: (t4, e4, n3) => We(y2, t4, e4, n3), partialUpdateFileContents: (t4, e4, n3, r3, o4) => Ze(y2, t4, e4, n3, r3, o4), getDAVCompliance: (t4) => Ve(y2, t4), search: (t4, e4) => De(y2, t4, e4), setHeaders: (t4) => {
        y2.headers = Object.assign({}, t4);
      }, stat: (t4, e4) => re(y2, t4, e4), unlock: (t4, e4, n3) => Re(y2, t4, e4, n3) };
    }
  })();
  var o = r.hT, i$2 = r.O4, s = r.Kd, a = r.YK, c = r.UU, u = r.Gu, l = r.ky, h = r.h4, p = r.ch, f = r.hq, d = r.i5;
  class WebDAV {
    constructor(options2) {
      this.options = options2;
      this.initServer();
    }
    /**
     * 初始化服务器
     */
    initServer() {
      this.service = c(this.options.address, {
        authType: this.options.digest ? o.Digest : o.Password,
        username: this.options.loginName,
        password: this.options.loginPwd
      });
    }
    /**
     * 获取资源列表
     * @param options
     */
    list(options2 = {}) {
      return new Promise((resolve2, reject2) => {
        this.service.getDirectoryContents("/", { glob: "*.zip" }).then((data2) => {
          console.log(data2);
          let result2 = [];
          let orderMode = options2.orderMode || EResourceOrderMode.desc;
          if (data2 && data2.length > 0) {
            data2.forEach((item) => {
              result2.push({
                name: item.basename,
                size: item.size,
                type: item.type,
                time: new Date(item.lastmod).getTime()
              });
            });
          }
          resolve2(
            result2.sort((a2, b) => {
              let v1, v2;
              switch (options2.orderBy) {
                case EResourceOrderBy.name:
                  v1 = a2.name;
                  v2 = b.name;
                  break;
                case EResourceOrderBy.size:
                  v1 = a2.size;
                  v2 = b.size;
                  break;
                default:
                  v1 = a2.time;
                  v2 = b.time;
                  break;
              }
              if (orderMode === EResourceOrderMode.desc) {
                return v1.toString().localeCompare(v2) == 1 ? -1 : 1;
              } else {
                return v1.toString().localeCompare(v2);
              }
            })
          );
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取（下载）一个文件
     * @param path
     * @returns 返回一个 binary 数据
     */
    get(path2) {
      return new Promise((resolve2, reject2) => {
        this.service.getFileContents("/" + path2).then((result2) => {
          resolve2(result2);
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 添加文件
     * @param formData
     */
    add(formData) {
      return new Promise((resolve2, reject2) => {
        formData.get("data").arrayBuffer().then((data2) => {
          this.service.putFileContents(formData.get("name"), data2).then((result2) => {
            console.log(result2);
            if (result2) {
              resolve2(true);
            } else {
              reject2(false);
            }
          }).catch((error) => {
            console.log(error);
            reject2(error);
          });
        });
      });
    }
    /**
     * 删除一个文件
     * @param path
     */
    delete(path2) {
      return new Promise((resolve2, reject2) => {
        this.service.deleteFile("/" + path2).then((result2) => {
          if (result2) {
            resolve2(result2.data);
          } else {
            reject2(false);
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 验证服务器可用性
     */
    ping() {
      return new Promise((resolve2, reject2) => {
        this.service.getDirectoryContents("/").then(() => {
          resolve2(true);
        }).catch((error) => {
          reject2(error);
        });
      });
    }
  }
  var buffer = {};
  var base64Js = {};
  base64Js.byteLength = byteLength;
  base64Js.toByteArray = toByteArray;
  base64Js.fromByteArray = fromByteArray;
  var lookup$1 = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
  var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  for (var i$1 = 0, len = code.length; i$1 < len; ++i$1) {
    lookup$1[i$1] = code[i$1];
    revLookup[code.charCodeAt(i$1)] = i$1;
  }
  revLookup["-".charCodeAt(0)] = 62;
  revLookup["_".charCodeAt(0)] = 63;
  function getLens(b64) {
    var len2 = b64.length;
    if (len2 % 4 > 0) {
      throw new Error("Invalid string. Length must be a multiple of 4");
    }
    var validLen = b64.indexOf("=");
    if (validLen === -1)
      validLen = len2;
    var placeHoldersLen = validLen === len2 ? 0 : 4 - validLen % 4;
    return [validLen, placeHoldersLen];
  }
  function byteLength(b64) {
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function _byteLength(b64, validLen, placeHoldersLen) {
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function toByteArray(b64) {
    var tmp;
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
    var curByte = 0;
    var len2 = placeHoldersLen > 0 ? validLen - 4 : validLen;
    var i2;
    for (i2 = 0; i2 < len2; i2 += 4) {
      tmp = revLookup[b64.charCodeAt(i2)] << 18 | revLookup[b64.charCodeAt(i2 + 1)] << 12 | revLookup[b64.charCodeAt(i2 + 2)] << 6 | revLookup[b64.charCodeAt(i2 + 3)];
      arr[curByte++] = tmp >> 16 & 255;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 2) {
      tmp = revLookup[b64.charCodeAt(i2)] << 2 | revLookup[b64.charCodeAt(i2 + 1)] >> 4;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 1) {
      tmp = revLookup[b64.charCodeAt(i2)] << 10 | revLookup[b64.charCodeAt(i2 + 1)] << 4 | revLookup[b64.charCodeAt(i2 + 2)] >> 2;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    return arr;
  }
  function tripletToBase64(num) {
    return lookup$1[num >> 18 & 63] + lookup$1[num >> 12 & 63] + lookup$1[num >> 6 & 63] + lookup$1[num & 63];
  }
  function encodeChunk(uint8, start, end) {
    var tmp;
    var output = [];
    for (var i2 = start; i2 < end; i2 += 3) {
      tmp = (uint8[i2] << 16 & 16711680) + (uint8[i2 + 1] << 8 & 65280) + (uint8[i2 + 2] & 255);
      output.push(tripletToBase64(tmp));
    }
    return output.join("");
  }
  function fromByteArray(uint8) {
    var tmp;
    var len2 = uint8.length;
    var extraBytes = len2 % 3;
    var parts = [];
    var maxChunkLength = 16383;
    for (var i2 = 0, len22 = len2 - extraBytes; i2 < len22; i2 += maxChunkLength) {
      parts.push(encodeChunk(uint8, i2, i2 + maxChunkLength > len22 ? len22 : i2 + maxChunkLength));
    }
    if (extraBytes === 1) {
      tmp = uint8[len2 - 1];
      parts.push(
        lookup$1[tmp >> 2] + lookup$1[tmp << 4 & 63] + "=="
      );
    } else if (extraBytes === 2) {
      tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
      parts.push(
        lookup$1[tmp >> 10] + lookup$1[tmp >> 4 & 63] + lookup$1[tmp << 2 & 63] + "="
      );
    }
    return parts.join("");
  }
  var ieee754 = {};
  /*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
  ieee754.read = function(buffer2, offset, isLE, mLen, nBytes) {
    var e2, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i2 = isLE ? nBytes - 1 : 0;
    var d2 = isLE ? -1 : 1;
    var s2 = buffer2[offset + i2];
    i2 += d2;
    e2 = s2 & (1 << -nBits) - 1;
    s2 >>= -nBits;
    nBits += eLen;
    for (; nBits > 0; e2 = e2 * 256 + buffer2[offset + i2], i2 += d2, nBits -= 8) {
    }
    m = e2 & (1 << -nBits) - 1;
    e2 >>= -nBits;
    nBits += mLen;
    for (; nBits > 0; m = m * 256 + buffer2[offset + i2], i2 += d2, nBits -= 8) {
    }
    if (e2 === 0) {
      e2 = 1 - eBias;
    } else if (e2 === eMax) {
      return m ? NaN : (s2 ? -1 : 1) * Infinity;
    } else {
      m = m + Math.pow(2, mLen);
      e2 = e2 - eBias;
    }
    return (s2 ? -1 : 1) * m * Math.pow(2, e2 - mLen);
  };
  ieee754.write = function(buffer2, value, offset, isLE, mLen, nBytes) {
    var e2, m, c2;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
    var i2 = isLE ? 0 : nBytes - 1;
    var d2 = isLE ? 1 : -1;
    var s2 = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
    value = Math.abs(value);
    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e2 = eMax;
    } else {
      e2 = Math.floor(Math.log(value) / Math.LN2);
      if (value * (c2 = Math.pow(2, -e2)) < 1) {
        e2--;
        c2 *= 2;
      }
      if (e2 + eBias >= 1) {
        value += rt / c2;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }
      if (value * c2 >= 2) {
        e2++;
        c2 /= 2;
      }
      if (e2 + eBias >= eMax) {
        m = 0;
        e2 = eMax;
      } else if (e2 + eBias >= 1) {
        m = (value * c2 - 1) * Math.pow(2, mLen);
        e2 = e2 + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e2 = 0;
      }
    }
    for (; mLen >= 8; buffer2[offset + i2] = m & 255, i2 += d2, m /= 256, mLen -= 8) {
    }
    e2 = e2 << mLen | m;
    eLen += mLen;
    for (; eLen > 0; buffer2[offset + i2] = e2 & 255, i2 += d2, e2 /= 256, eLen -= 8) {
    }
    buffer2[offset + i2 - d2] |= s2 * 128;
  };
  /*!
   * The buffer module from node.js, for the browser.
   *
   * @author   Feross Aboukhadijeh <https://feross.org>
   * @license  MIT
   */
  (function(exports) {
    const base64 = base64Js;
    const ieee754$1 = ieee754;
    const customInspectSymbol = typeof Symbol === "function" && typeof Symbol["for"] === "function" ? Symbol["for"]("nodejs.util.inspect.custom") : null;
    exports.Buffer = Buffer2;
    exports.SlowBuffer = SlowBuffer2;
    exports.INSPECT_MAX_BYTES = 50;
    const K_MAX_LENGTH = 2147483647;
    exports.kMaxLength = K_MAX_LENGTH;
    const { Uint8Array: GlobalUint8Array, ArrayBuffer: GlobalArrayBuffer, SharedArrayBuffer: GlobalSharedArrayBuffer } = globalThis;
    Buffer2.TYPED_ARRAY_SUPPORT = typedArraySupport();
    if (!Buffer2.TYPED_ARRAY_SUPPORT && typeof console !== "undefined" && typeof console.error === "function") {
      console.error(
        "This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."
      );
    }
    function typedArraySupport() {
      try {
        const arr = new GlobalUint8Array(1);
        const proto = { foo: function() {
          return 42;
        } };
        Object.setPrototypeOf(proto, GlobalUint8Array.prototype);
        Object.setPrototypeOf(arr, proto);
        return arr.foo() === 42;
      } catch (e2) {
        return false;
      }
    }
    Object.defineProperty(Buffer2.prototype, "parent", {
      enumerable: true,
      get: function() {
        if (!Buffer2.isBuffer(this))
          return void 0;
        return this.buffer;
      }
    });
    Object.defineProperty(Buffer2.prototype, "offset", {
      enumerable: true,
      get: function() {
        if (!Buffer2.isBuffer(this))
          return void 0;
        return this.byteOffset;
      }
    });
    function createBuffer(length) {
      if (length > K_MAX_LENGTH) {
        throw new RangeError('The value "' + length + '" is invalid for option "size"');
      }
      const buf = new GlobalUint8Array(length);
      Object.setPrototypeOf(buf, Buffer2.prototype);
      return buf;
    }
    function Buffer2(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        if (typeof encodingOrOffset === "string") {
          throw new TypeError(
            'The "string" argument must be of type string. Received type number'
          );
        }
        return allocUnsafe(arg);
      }
      return from(arg, encodingOrOffset, length);
    }
    Buffer2.poolSize = 8192;
    function from(value, encodingOrOffset, length) {
      if (typeof value === "string") {
        return fromString(value, encodingOrOffset);
      }
      if (GlobalArrayBuffer.isView(value)) {
        return fromArrayView(value);
      }
      if (value == null) {
        throw new TypeError(
          "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
        );
      }
      if (isInstance(value, GlobalArrayBuffer) || value && isInstance(value.buffer, GlobalArrayBuffer)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }
      if (typeof GlobalSharedArrayBuffer !== "undefined" && (isInstance(value, GlobalSharedArrayBuffer) || value && isInstance(value.buffer, GlobalSharedArrayBuffer))) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }
      if (typeof value === "number") {
        throw new TypeError(
          'The "value" argument must not be of type number. Received type number'
        );
      }
      const valueOf = value.valueOf && value.valueOf();
      if (valueOf != null && valueOf !== value) {
        return Buffer2.from(valueOf, encodingOrOffset, length);
      }
      const b = fromObject(value);
      if (b)
        return b;
      if (typeof Symbol !== "undefined" && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === "function") {
        return Buffer2.from(value[Symbol.toPrimitive]("string"), encodingOrOffset, length);
      }
      throw new TypeError(
        "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
      );
    }
    Buffer2.from = function(value, encodingOrOffset, length) {
      return from(value, encodingOrOffset, length);
    };
    Object.setPrototypeOf(Buffer2.prototype, GlobalUint8Array.prototype);
    Object.setPrototypeOf(Buffer2, GlobalUint8Array);
    function assertSize(size) {
      if (typeof size !== "number") {
        throw new TypeError('"size" argument must be of type number');
      } else if (size < 0) {
        throw new RangeError('The value "' + size + '" is invalid for option "size"');
      }
    }
    function alloc(size, fill, encoding) {
      assertSize(size);
      if (size <= 0) {
        return createBuffer(size);
      }
      if (fill !== void 0) {
        return typeof encoding === "string" ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
      }
      return createBuffer(size);
    }
    Buffer2.alloc = function(size, fill, encoding) {
      return alloc(size, fill, encoding);
    };
    function allocUnsafe(size) {
      assertSize(size);
      return createBuffer(size < 0 ? 0 : checked(size) | 0);
    }
    Buffer2.allocUnsafe = function(size) {
      return allocUnsafe(size);
    };
    Buffer2.allocUnsafeSlow = function(size) {
      return allocUnsafe(size);
    };
    function fromString(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer2.isEncoding(encoding)) {
        throw new TypeError("Unknown encoding: " + encoding);
      }
      const length = byteLength2(string, encoding) | 0;
      let buf = createBuffer(length);
      const actual = buf.write(string, encoding);
      if (actual !== length) {
        buf = buf.slice(0, actual);
      }
      return buf;
    }
    function fromArrayLike(array) {
      const length = array.length < 0 ? 0 : checked(array.length) | 0;
      const buf = createBuffer(length);
      for (let i2 = 0; i2 < length; i2 += 1) {
        buf[i2] = array[i2] & 255;
      }
      return buf;
    }
    function fromArrayView(arrayView) {
      if (isInstance(arrayView, GlobalUint8Array)) {
        const copy2 = new GlobalUint8Array(arrayView);
        return fromArrayBuffer(copy2.buffer, copy2.byteOffset, copy2.byteLength);
      }
      return fromArrayLike(arrayView);
    }
    function fromArrayBuffer(array, byteOffset, length) {
      if (byteOffset < 0 || array.byteLength < byteOffset) {
        throw new RangeError('"offset" is outside of buffer bounds');
      }
      if (array.byteLength < byteOffset + (length || 0)) {
        throw new RangeError('"length" is outside of buffer bounds');
      }
      let buf;
      if (byteOffset === void 0 && length === void 0) {
        buf = new GlobalUint8Array(array);
      } else if (length === void 0) {
        buf = new GlobalUint8Array(array, byteOffset);
      } else {
        buf = new GlobalUint8Array(array, byteOffset, length);
      }
      Object.setPrototypeOf(buf, Buffer2.prototype);
      return buf;
    }
    function fromObject(obj) {
      if (Buffer2.isBuffer(obj)) {
        const len2 = checked(obj.length) | 0;
        const buf = createBuffer(len2);
        if (buf.length === 0) {
          return buf;
        }
        obj.copy(buf, 0, 0, len2);
        return buf;
      }
      if (obj.length !== void 0) {
        if (typeof obj.length !== "number" || numberIsNaN(obj.length)) {
          return createBuffer(0);
        }
        return fromArrayLike(obj);
      }
      if (obj.type === "Buffer" && Array.isArray(obj.data)) {
        return fromArrayLike(obj.data);
      }
    }
    function checked(length) {
      if (length >= K_MAX_LENGTH) {
        throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
      }
      return length | 0;
    }
    function SlowBuffer2(length) {
      if (+length != length) {
        length = 0;
      }
      return Buffer2.alloc(+length);
    }
    Buffer2.isBuffer = function isBuffer(b) {
      return b != null && b._isBuffer === true && b !== Buffer2.prototype;
    };
    Buffer2.compare = function compare(a2, b) {
      if (isInstance(a2, GlobalUint8Array))
        a2 = Buffer2.from(a2, a2.offset, a2.byteLength);
      if (isInstance(b, GlobalUint8Array))
        b = Buffer2.from(b, b.offset, b.byteLength);
      if (!Buffer2.isBuffer(a2) || !Buffer2.isBuffer(b)) {
        throw new TypeError(
          'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
        );
      }
      if (a2 === b)
        return 0;
      let x = a2.length;
      let y = b.length;
      for (let i2 = 0, len2 = Math.min(x, y); i2 < len2; ++i2) {
        if (a2[i2] !== b[i2]) {
          x = a2[i2];
          y = b[i2];
          break;
        }
      }
      if (x < y)
        return -1;
      if (y < x)
        return 1;
      return 0;
    };
    Buffer2.isEncoding = function isEncoding(encoding) {
      switch (String(encoding).toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "latin1":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return true;
        default:
          return false;
      }
    };
    Buffer2.concat = function concat2(list, length) {
      if (!Array.isArray(list)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
      }
      if (list.length === 0) {
        return Buffer2.alloc(0);
      }
      let i2;
      if (length === void 0) {
        length = 0;
        for (i2 = 0; i2 < list.length; ++i2) {
          length += list[i2].length;
        }
      }
      const buffer2 = Buffer2.allocUnsafe(length);
      let pos = 0;
      for (i2 = 0; i2 < list.length; ++i2) {
        let buf = list[i2];
        if (isInstance(buf, GlobalUint8Array)) {
          if (pos + buf.length > buffer2.length) {
            if (!Buffer2.isBuffer(buf))
              buf = Buffer2.from(buf);
            buf.copy(buffer2, pos);
          } else {
            GlobalUint8Array.prototype.set.call(
              buffer2,
              buf,
              pos
            );
          }
        } else if (!Buffer2.isBuffer(buf)) {
          throw new TypeError('"list" argument must be an Array of Buffers');
        } else {
          buf.copy(buffer2, pos);
        }
        pos += buf.length;
      }
      return buffer2;
    };
    function byteLength2(string, encoding) {
      if (Buffer2.isBuffer(string)) {
        return string.length;
      }
      if (GlobalArrayBuffer.isView(string) || isInstance(string, GlobalArrayBuffer)) {
        return string.byteLength;
      }
      if (typeof string !== "string") {
        throw new TypeError(
          'The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type ' + typeof string
        );
      }
      const len2 = string.length;
      const mustMatch = arguments.length > 2 && arguments[2] === true;
      if (!mustMatch && len2 === 0)
        return 0;
      let loweredCase = false;
      for (; ; ) {
        switch (encoding) {
          case "ascii":
          case "latin1":
          case "binary":
            return len2;
          case "utf8":
          case "utf-8":
            return utf8ToBytes(string).length;
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return len2 * 2;
          case "hex":
            return len2 >>> 1;
          case "base64":
            return base64ToBytes(string).length;
          default:
            if (loweredCase) {
              return mustMatch ? -1 : utf8ToBytes(string).length;
            }
            encoding = ("" + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    }
    Buffer2.byteLength = byteLength2;
    function slowToString(encoding, start, end) {
      let loweredCase = false;
      if (start === void 0 || start < 0) {
        start = 0;
      }
      if (start > this.length) {
        return "";
      }
      if (end === void 0 || end > this.length) {
        end = this.length;
      }
      if (end <= 0) {
        return "";
      }
      end >>>= 0;
      start >>>= 0;
      if (end <= start) {
        return "";
      }
      if (!encoding)
        encoding = "utf8";
      while (true) {
        switch (encoding) {
          case "hex":
            return hexSlice(this, start, end);
          case "utf8":
          case "utf-8":
            return utf8Slice(this, start, end);
          case "ascii":
            return asciiSlice(this, start, end);
          case "latin1":
          case "binary":
            return latin1Slice(this, start, end);
          case "base64":
            return base64Slice(this, start, end);
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return utf16leSlice(this, start, end);
          default:
            if (loweredCase)
              throw new TypeError("Unknown encoding: " + encoding);
            encoding = (encoding + "").toLowerCase();
            loweredCase = true;
        }
      }
    }
    Buffer2.prototype._isBuffer = true;
    function swap(b, n2, m) {
      const i2 = b[n2];
      b[n2] = b[m];
      b[m] = i2;
    }
    Buffer2.prototype.swap16 = function swap16() {
      const len2 = this.length;
      if (len2 % 2 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 16-bits");
      }
      for (let i2 = 0; i2 < len2; i2 += 2) {
        swap(this, i2, i2 + 1);
      }
      return this;
    };
    Buffer2.prototype.swap32 = function swap32() {
      const len2 = this.length;
      if (len2 % 4 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 32-bits");
      }
      for (let i2 = 0; i2 < len2; i2 += 4) {
        swap(this, i2, i2 + 3);
        swap(this, i2 + 1, i2 + 2);
      }
      return this;
    };
    Buffer2.prototype.swap64 = function swap64() {
      const len2 = this.length;
      if (len2 % 8 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 64-bits");
      }
      for (let i2 = 0; i2 < len2; i2 += 8) {
        swap(this, i2, i2 + 7);
        swap(this, i2 + 1, i2 + 6);
        swap(this, i2 + 2, i2 + 5);
        swap(this, i2 + 3, i2 + 4);
      }
      return this;
    };
    Buffer2.prototype.toString = function toString2() {
      const length = this.length;
      if (length === 0)
        return "";
      if (arguments.length === 0)
        return utf8Slice(this, 0, length);
      return slowToString.apply(this, arguments);
    };
    Buffer2.prototype.toLocaleString = Buffer2.prototype.toString;
    Buffer2.prototype.equals = function equals(b) {
      if (!Buffer2.isBuffer(b))
        throw new TypeError("Argument must be a Buffer");
      if (this === b)
        return true;
      return Buffer2.compare(this, b) === 0;
    };
    Buffer2.prototype.inspect = function inspect() {
      let str = "";
      const max = exports.INSPECT_MAX_BYTES;
      str = this.toString("hex", 0, max).replace(/(.{2})/g, "$1 ").trim();
      if (this.length > max)
        str += " ... ";
      return "<Buffer " + str + ">";
    };
    if (customInspectSymbol) {
      Buffer2.prototype[customInspectSymbol] = Buffer2.prototype.inspect;
    }
    Buffer2.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
      if (isInstance(target, GlobalUint8Array)) {
        target = Buffer2.from(target, target.offset, target.byteLength);
      }
      if (!Buffer2.isBuffer(target)) {
        throw new TypeError(
          'The "target" argument must be one of type Buffer or Uint8Array. Received type ' + typeof target
        );
      }
      if (start === void 0) {
        start = 0;
      }
      if (end === void 0) {
        end = target ? target.length : 0;
      }
      if (thisStart === void 0) {
        thisStart = 0;
      }
      if (thisEnd === void 0) {
        thisEnd = this.length;
      }
      if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
        throw new RangeError("out of range index");
      }
      if (thisStart >= thisEnd && start >= end) {
        return 0;
      }
      if (thisStart >= thisEnd) {
        return -1;
      }
      if (start >= end) {
        return 1;
      }
      start >>>= 0;
      end >>>= 0;
      thisStart >>>= 0;
      thisEnd >>>= 0;
      if (this === target)
        return 0;
      let x = thisEnd - thisStart;
      let y = end - start;
      const len2 = Math.min(x, y);
      const thisCopy = this.slice(thisStart, thisEnd);
      const targetCopy = target.slice(start, end);
      for (let i2 = 0; i2 < len2; ++i2) {
        if (thisCopy[i2] !== targetCopy[i2]) {
          x = thisCopy[i2];
          y = targetCopy[i2];
          break;
        }
      }
      if (x < y)
        return -1;
      if (y < x)
        return 1;
      return 0;
    };
    function bidirectionalIndexOf(buffer2, val2, byteOffset, encoding, dir) {
      if (buffer2.length === 0)
        return -1;
      if (typeof byteOffset === "string") {
        encoding = byteOffset;
        byteOffset = 0;
      } else if (byteOffset > 2147483647) {
        byteOffset = 2147483647;
      } else if (byteOffset < -2147483648) {
        byteOffset = -2147483648;
      }
      byteOffset = +byteOffset;
      if (numberIsNaN(byteOffset)) {
        byteOffset = dir ? 0 : buffer2.length - 1;
      }
      if (byteOffset < 0)
        byteOffset = buffer2.length + byteOffset;
      if (byteOffset >= buffer2.length) {
        if (dir)
          return -1;
        else
          byteOffset = buffer2.length - 1;
      } else if (byteOffset < 0) {
        if (dir)
          byteOffset = 0;
        else
          return -1;
      }
      if (typeof val2 === "string") {
        val2 = Buffer2.from(val2, encoding);
      }
      if (Buffer2.isBuffer(val2)) {
        if (val2.length === 0) {
          return -1;
        }
        return arrayIndexOf(buffer2, val2, byteOffset, encoding, dir);
      } else if (typeof val2 === "number") {
        val2 = val2 & 255;
        if (typeof GlobalUint8Array.prototype.indexOf === "function") {
          if (dir) {
            return GlobalUint8Array.prototype.indexOf.call(buffer2, val2, byteOffset);
          } else {
            return GlobalUint8Array.prototype.lastIndexOf.call(buffer2, val2, byteOffset);
          }
        }
        return arrayIndexOf(buffer2, [val2], byteOffset, encoding, dir);
      }
      throw new TypeError("val must be string, number or Buffer");
    }
    function arrayIndexOf(arr, val2, byteOffset, encoding, dir) {
      let indexSize = 1;
      let arrLength = arr.length;
      let valLength = val2.length;
      if (encoding !== void 0) {
        encoding = String(encoding).toLowerCase();
        if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
          if (arr.length < 2 || val2.length < 2) {
            return -1;
          }
          indexSize = 2;
          arrLength /= 2;
          valLength /= 2;
          byteOffset /= 2;
        }
      }
      function read(buf, i3) {
        if (indexSize === 1) {
          return buf[i3];
        } else {
          return buf.readUInt16BE(i3 * indexSize);
        }
      }
      let i2;
      if (dir) {
        let foundIndex = -1;
        for (i2 = byteOffset; i2 < arrLength; i2++) {
          if (read(arr, i2) === read(val2, foundIndex === -1 ? 0 : i2 - foundIndex)) {
            if (foundIndex === -1)
              foundIndex = i2;
            if (i2 - foundIndex + 1 === valLength)
              return foundIndex * indexSize;
          } else {
            if (foundIndex !== -1)
              i2 -= i2 - foundIndex;
            foundIndex = -1;
          }
        }
      } else {
        if (byteOffset + valLength > arrLength)
          byteOffset = arrLength - valLength;
        for (i2 = byteOffset; i2 >= 0; i2--) {
          let found = true;
          for (let j = 0; j < valLength; j++) {
            if (read(arr, i2 + j) !== read(val2, j)) {
              found = false;
              break;
            }
          }
          if (found)
            return i2;
        }
      }
      return -1;
    }
    Buffer2.prototype.includes = function includes(val2, byteOffset, encoding) {
      return this.indexOf(val2, byteOffset, encoding) !== -1;
    };
    Buffer2.prototype.indexOf = function indexOf(val2, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val2, byteOffset, encoding, true);
    };
    Buffer2.prototype.lastIndexOf = function lastIndexOf(val2, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val2, byteOffset, encoding, false);
    };
    function hexWrite(buf, string, offset, length) {
      offset = Number(offset) || 0;
      const remaining = buf.length - offset;
      if (!length) {
        length = remaining;
      } else {
        length = Number(length);
        if (length > remaining) {
          length = remaining;
        }
      }
      const strLen = string.length;
      if (length > strLen / 2) {
        length = strLen / 2;
      }
      let i2;
      for (i2 = 0; i2 < length; ++i2) {
        const parsed = parseInt(string.substr(i2 * 2, 2), 16);
        if (numberIsNaN(parsed))
          return i2;
        buf[offset + i2] = parsed;
      }
      return i2;
    }
    function utf8Write(buf, string, offset, length) {
      return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
    }
    function asciiWrite(buf, string, offset, length) {
      return blitBuffer(asciiToBytes(string), buf, offset, length);
    }
    function base64Write(buf, string, offset, length) {
      return blitBuffer(base64ToBytes(string), buf, offset, length);
    }
    function ucs2Write(buf, string, offset, length) {
      return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
    }
    Buffer2.prototype.write = function write(string, offset, length, encoding) {
      if (offset === void 0) {
        encoding = "utf8";
        length = this.length;
        offset = 0;
      } else if (length === void 0 && typeof offset === "string") {
        encoding = offset;
        length = this.length;
        offset = 0;
      } else if (isFinite(offset)) {
        offset = offset >>> 0;
        if (isFinite(length)) {
          length = length >>> 0;
          if (encoding === void 0)
            encoding = "utf8";
        } else {
          encoding = length;
          length = void 0;
        }
      } else {
        throw new Error(
          "Buffer.write(string, encoding, offset[, length]) is no longer supported"
        );
      }
      const remaining = this.length - offset;
      if (length === void 0 || length > remaining)
        length = remaining;
      if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
        throw new RangeError("Attempt to write outside buffer bounds");
      }
      if (!encoding)
        encoding = "utf8";
      let loweredCase = false;
      for (; ; ) {
        switch (encoding) {
          case "hex":
            return hexWrite(this, string, offset, length);
          case "utf8":
          case "utf-8":
            return utf8Write(this, string, offset, length);
          case "ascii":
          case "latin1":
          case "binary":
            return asciiWrite(this, string, offset, length);
          case "base64":
            return base64Write(this, string, offset, length);
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return ucs2Write(this, string, offset, length);
          default:
            if (loweredCase)
              throw new TypeError("Unknown encoding: " + encoding);
            encoding = ("" + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    };
    Buffer2.prototype.toJSON = function toJSON() {
      return {
        type: "Buffer",
        data: Array.prototype.slice.call(this._arr || this, 0)
      };
    };
    function base64Slice(buf, start, end) {
      if (start === 0 && end === buf.length) {
        return base64.fromByteArray(buf);
      } else {
        return base64.fromByteArray(buf.slice(start, end));
      }
    }
    function utf8Slice(buf, start, end) {
      end = Math.min(buf.length, end);
      const res = [];
      let i2 = start;
      while (i2 < end) {
        const firstByte = buf[i2];
        let codePoint = null;
        let bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
        if (i2 + bytesPerSequence <= end) {
          let secondByte, thirdByte, fourthByte, tempCodePoint;
          switch (bytesPerSequence) {
            case 1:
              if (firstByte < 128) {
                codePoint = firstByte;
              }
              break;
            case 2:
              secondByte = buf[i2 + 1];
              if ((secondByte & 192) === 128) {
                tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                if (tempCodePoint > 127) {
                  codePoint = tempCodePoint;
                }
              }
              break;
            case 3:
              secondByte = buf[i2 + 1];
              thirdByte = buf[i2 + 2];
              if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                  codePoint = tempCodePoint;
                }
              }
              break;
            case 4:
              secondByte = buf[i2 + 1];
              thirdByte = buf[i2 + 2];
              fourthByte = buf[i2 + 3];
              if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                  codePoint = tempCodePoint;
                }
              }
          }
        }
        if (codePoint === null) {
          codePoint = 65533;
          bytesPerSequence = 1;
        } else if (codePoint > 65535) {
          codePoint -= 65536;
          res.push(codePoint >>> 10 & 1023 | 55296);
          codePoint = 56320 | codePoint & 1023;
        }
        res.push(codePoint);
        i2 += bytesPerSequence;
      }
      return decodeCodePointsArray(res);
    }
    const MAX_ARGUMENTS_LENGTH2 = 4096;
    function decodeCodePointsArray(codePoints) {
      const len2 = codePoints.length;
      if (len2 <= MAX_ARGUMENTS_LENGTH2) {
        return String.fromCharCode.apply(String, codePoints);
      }
      let res = "";
      let i2 = 0;
      while (i2 < len2) {
        res += String.fromCharCode.apply(
          String,
          codePoints.slice(i2, i2 += MAX_ARGUMENTS_LENGTH2)
        );
      }
      return res;
    }
    function asciiSlice(buf, start, end) {
      let ret = "";
      end = Math.min(buf.length, end);
      for (let i2 = start; i2 < end; ++i2) {
        ret += String.fromCharCode(buf[i2] & 127);
      }
      return ret;
    }
    function latin1Slice(buf, start, end) {
      let ret = "";
      end = Math.min(buf.length, end);
      for (let i2 = start; i2 < end; ++i2) {
        ret += String.fromCharCode(buf[i2]);
      }
      return ret;
    }
    function hexSlice(buf, start, end) {
      const len2 = buf.length;
      if (!start || start < 0)
        start = 0;
      if (!end || end < 0 || end > len2)
        end = len2;
      let out = "";
      for (let i2 = start; i2 < end; ++i2) {
        out += hexSliceLookupTable[buf[i2]];
      }
      return out;
    }
    function utf16leSlice(buf, start, end) {
      const bytes = buf.slice(start, end);
      let res = "";
      for (let i2 = 0; i2 < bytes.length - 1; i2 += 2) {
        res += String.fromCharCode(bytes[i2] + bytes[i2 + 1] * 256);
      }
      return res;
    }
    Buffer2.prototype.slice = function slice(start, end) {
      const len2 = this.length;
      start = ~~start;
      end = end === void 0 ? len2 : ~~end;
      if (start < 0) {
        start += len2;
        if (start < 0)
          start = 0;
      } else if (start > len2) {
        start = len2;
      }
      if (end < 0) {
        end += len2;
        if (end < 0)
          end = 0;
      } else if (end > len2) {
        end = len2;
      }
      if (end < start)
        end = start;
      const newBuf = this.subarray(start, end);
      Object.setPrototypeOf(newBuf, Buffer2.prototype);
      return newBuf;
    };
    function checkOffset(offset, ext, length) {
      if (offset % 1 !== 0 || offset < 0)
        throw new RangeError("offset is not uint");
      if (offset + ext > length)
        throw new RangeError("Trying to access beyond buffer length");
    }
    Buffer2.prototype.readUintLE = Buffer2.prototype.readUIntLE = function readUIntLE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert)
        checkOffset(offset, byteLength3, this.length);
      let val2 = this[offset];
      let mul = 1;
      let i2 = 0;
      while (++i2 < byteLength3 && (mul *= 256)) {
        val2 += this[offset + i2] * mul;
      }
      return val2;
    };
    Buffer2.prototype.readUintBE = Buffer2.prototype.readUIntBE = function readUIntBE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        checkOffset(offset, byteLength3, this.length);
      }
      let val2 = this[offset + --byteLength3];
      let mul = 1;
      while (byteLength3 > 0 && (mul *= 256)) {
        val2 += this[offset + --byteLength3] * mul;
      }
      return val2;
    };
    Buffer2.prototype.readUint8 = Buffer2.prototype.readUInt8 = function readUInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 1, this.length);
      return this[offset];
    };
    Buffer2.prototype.readUint16LE = Buffer2.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 2, this.length);
      return this[offset] | this[offset + 1] << 8;
    };
    Buffer2.prototype.readUint16BE = Buffer2.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 2, this.length);
      return this[offset] << 8 | this[offset + 1];
    };
    Buffer2.prototype.readUint32LE = Buffer2.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
    };
    Buffer2.prototype.readUint32BE = Buffer2.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
    };
    Buffer2.prototype.readBigUInt64LE = defineBigIntMethod(function readBigUInt64LE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const lo = first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24;
      const hi = this[++offset] + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + last * 2 ** 24;
      return BigInt(lo) + (BigInt(hi) << BigInt(32));
    });
    Buffer2.prototype.readBigUInt64BE = defineBigIntMethod(function readBigUInt64BE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const hi = first * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
      const lo = this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last;
      return (BigInt(hi) << BigInt(32)) + BigInt(lo);
    });
    Buffer2.prototype.readIntLE = function readIntLE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert)
        checkOffset(offset, byteLength3, this.length);
      let val2 = this[offset];
      let mul = 1;
      let i2 = 0;
      while (++i2 < byteLength3 && (mul *= 256)) {
        val2 += this[offset + i2] * mul;
      }
      mul *= 128;
      if (val2 >= mul)
        val2 -= Math.pow(2, 8 * byteLength3);
      return val2;
    };
    Buffer2.prototype.readIntBE = function readIntBE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert)
        checkOffset(offset, byteLength3, this.length);
      let i2 = byteLength3;
      let mul = 1;
      let val2 = this[offset + --i2];
      while (i2 > 0 && (mul *= 256)) {
        val2 += this[offset + --i2] * mul;
      }
      mul *= 128;
      if (val2 >= mul)
        val2 -= Math.pow(2, 8 * byteLength3);
      return val2;
    };
    Buffer2.prototype.readInt8 = function readInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 1, this.length);
      if (!(this[offset] & 128))
        return this[offset];
      return (255 - this[offset] + 1) * -1;
    };
    Buffer2.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 2, this.length);
      const val2 = this[offset] | this[offset + 1] << 8;
      return val2 & 32768 ? val2 | 4294901760 : val2;
    };
    Buffer2.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 2, this.length);
      const val2 = this[offset + 1] | this[offset] << 8;
      return val2 & 32768 ? val2 | 4294901760 : val2;
    };
    Buffer2.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
    };
    Buffer2.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
    };
    Buffer2.prototype.readBigInt64LE = defineBigIntMethod(function readBigInt64LE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const val2 = this[offset + 4] + this[offset + 5] * 2 ** 8 + this[offset + 6] * 2 ** 16 + (last << 24);
      return (BigInt(val2) << BigInt(32)) + BigInt(first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24);
    });
    Buffer2.prototype.readBigInt64BE = defineBigIntMethod(function readBigInt64BE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const val2 = (first << 24) + // Overflow
      this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
      return (BigInt(val2) << BigInt(32)) + BigInt(this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last);
    });
    Buffer2.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return ieee754$1.read(this, offset, true, 23, 4);
    };
    Buffer2.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 4, this.length);
      return ieee754$1.read(this, offset, false, 23, 4);
    };
    Buffer2.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 8, this.length);
      return ieee754$1.read(this, offset, true, 52, 8);
    };
    Buffer2.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert)
        checkOffset(offset, 8, this.length);
      return ieee754$1.read(this, offset, false, 52, 8);
    };
    function checkInt(buf, value, offset, ext, max, min) {
      if (!Buffer2.isBuffer(buf))
        throw new TypeError('"buffer" argument must be a Buffer instance');
      if (value > max || value < min)
        throw new RangeError('"value" argument is out of bounds');
      if (offset + ext > buf.length)
        throw new RangeError("Index out of range");
    }
    Buffer2.prototype.writeUintLE = Buffer2.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
        checkInt(this, value, offset, byteLength3, maxBytes, 0);
      }
      let mul = 1;
      let i2 = 0;
      this[offset] = value & 255;
      while (++i2 < byteLength3 && (mul *= 256)) {
        this[offset + i2] = value / mul & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeUintBE = Buffer2.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
        checkInt(this, value, offset, byteLength3, maxBytes, 0);
      }
      let i2 = byteLength3 - 1;
      let mul = 1;
      this[offset + i2] = value & 255;
      while (--i2 >= 0 && (mul *= 256)) {
        this[offset + i2] = value / mul & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeUint8 = Buffer2.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 1, 255, 0);
      this[offset] = value & 255;
      return offset + 1;
    };
    Buffer2.prototype.writeUint16LE = Buffer2.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 2, 65535, 0);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };
    Buffer2.prototype.writeUint16BE = Buffer2.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 2, 65535, 0);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 255;
      return offset + 2;
    };
    Buffer2.prototype.writeUint32LE = Buffer2.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 4, 4294967295, 0);
      this[offset + 3] = value >>> 24;
      this[offset + 2] = value >>> 16;
      this[offset + 1] = value >>> 8;
      this[offset] = value & 255;
      return offset + 4;
    };
    Buffer2.prototype.writeUint32BE = Buffer2.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 4, 4294967295, 0);
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 255;
      return offset + 4;
    };
    function wrtBigUInt64LE(buf, value, offset, min, max) {
      checkIntBI(value, min, max, buf, offset, 7);
      let lo = Number(value & BigInt(4294967295));
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      let hi = Number(value >> BigInt(32) & BigInt(4294967295));
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      return offset;
    }
    function wrtBigUInt64BE(buf, value, offset, min, max) {
      checkIntBI(value, min, max, buf, offset, 7);
      let lo = Number(value & BigInt(4294967295));
      buf[offset + 7] = lo;
      lo = lo >> 8;
      buf[offset + 6] = lo;
      lo = lo >> 8;
      buf[offset + 5] = lo;
      lo = lo >> 8;
      buf[offset + 4] = lo;
      let hi = Number(value >> BigInt(32) & BigInt(4294967295));
      buf[offset + 3] = hi;
      hi = hi >> 8;
      buf[offset + 2] = hi;
      hi = hi >> 8;
      buf[offset + 1] = hi;
      hi = hi >> 8;
      buf[offset] = hi;
      return offset + 8;
    }
    Buffer2.prototype.writeBigUInt64LE = defineBigIntMethod(function writeBigUInt64LE(value, offset = 0) {
      return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
    });
    Buffer2.prototype.writeBigUInt64BE = defineBigIntMethod(function writeBigUInt64BE(value, offset = 0) {
      return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
    });
    Buffer2.prototype.writeIntLE = function writeIntLE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        const limit = Math.pow(2, 8 * byteLength3 - 1);
        checkInt(this, value, offset, byteLength3, limit - 1, -limit);
      }
      let i2 = 0;
      let mul = 1;
      let sub = 0;
      this[offset] = value & 255;
      while (++i2 < byteLength3 && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i2 - 1] !== 0) {
          sub = 1;
        }
        this[offset + i2] = (value / mul >> 0) - sub & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeIntBE = function writeIntBE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        const limit = Math.pow(2, 8 * byteLength3 - 1);
        checkInt(this, value, offset, byteLength3, limit - 1, -limit);
      }
      let i2 = byteLength3 - 1;
      let mul = 1;
      let sub = 0;
      this[offset + i2] = value & 255;
      while (--i2 >= 0 && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i2 + 1] !== 0) {
          sub = 1;
        }
        this[offset + i2] = (value / mul >> 0) - sub & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 1, 127, -128);
      if (value < 0)
        value = 255 + value + 1;
      this[offset] = value & 255;
      return offset + 1;
    };
    Buffer2.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 2, 32767, -32768);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };
    Buffer2.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 2, 32767, -32768);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 255;
      return offset + 2;
    };
    Buffer2.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 4, 2147483647, -2147483648);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      this[offset + 2] = value >>> 16;
      this[offset + 3] = value >>> 24;
      return offset + 4;
    };
    Buffer2.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert)
        checkInt(this, value, offset, 4, 2147483647, -2147483648);
      if (value < 0)
        value = 4294967295 + value + 1;
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 255;
      return offset + 4;
    };
    Buffer2.prototype.writeBigInt64LE = defineBigIntMethod(function writeBigInt64LE(value, offset = 0) {
      return wrtBigUInt64LE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
    });
    Buffer2.prototype.writeBigInt64BE = defineBigIntMethod(function writeBigInt64BE(value, offset = 0) {
      return wrtBigUInt64BE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
    });
    function checkIEEE754(buf, value, offset, ext, max, min) {
      if (offset + ext > buf.length)
        throw new RangeError("Index out of range");
      if (offset < 0)
        throw new RangeError("Index out of range");
    }
    function writeFloat(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        checkIEEE754(buf, value, offset, 4);
      }
      ieee754$1.write(buf, value, offset, littleEndian, 23, 4);
      return offset + 4;
    }
    Buffer2.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
      return writeFloat(this, value, offset, true, noAssert);
    };
    Buffer2.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
      return writeFloat(this, value, offset, false, noAssert);
    };
    function writeDouble(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        checkIEEE754(buf, value, offset, 8);
      }
      ieee754$1.write(buf, value, offset, littleEndian, 52, 8);
      return offset + 8;
    }
    Buffer2.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
      return writeDouble(this, value, offset, true, noAssert);
    };
    Buffer2.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
      return writeDouble(this, value, offset, false, noAssert);
    };
    Buffer2.prototype.copy = function copy2(target, targetStart, start, end) {
      if (!Buffer2.isBuffer(target))
        throw new TypeError("argument should be a Buffer");
      if (!start)
        start = 0;
      if (!end && end !== 0)
        end = this.length;
      if (targetStart >= target.length)
        targetStart = target.length;
      if (!targetStart)
        targetStart = 0;
      if (end > 0 && end < start)
        end = start;
      if (end === start)
        return 0;
      if (target.length === 0 || this.length === 0)
        return 0;
      if (targetStart < 0) {
        throw new RangeError("targetStart out of bounds");
      }
      if (start < 0 || start >= this.length)
        throw new RangeError("Index out of range");
      if (end < 0)
        throw new RangeError("sourceEnd out of bounds");
      if (end > this.length)
        end = this.length;
      if (target.length - targetStart < end - start) {
        end = target.length - targetStart + start;
      }
      const len2 = end - start;
      if (this === target && typeof GlobalUint8Array.prototype.copyWithin === "function") {
        this.copyWithin(targetStart, start, end);
      } else {
        GlobalUint8Array.prototype.set.call(
          target,
          this.subarray(start, end),
          targetStart
        );
      }
      return len2;
    };
    Buffer2.prototype.fill = function fill(val2, start, end, encoding) {
      if (typeof val2 === "string") {
        if (typeof start === "string") {
          encoding = start;
          start = 0;
          end = this.length;
        } else if (typeof end === "string") {
          encoding = end;
          end = this.length;
        }
        if (encoding !== void 0 && typeof encoding !== "string") {
          throw new TypeError("encoding must be a string");
        }
        if (typeof encoding === "string" && !Buffer2.isEncoding(encoding)) {
          throw new TypeError("Unknown encoding: " + encoding);
        }
        if (val2.length === 1) {
          const code2 = val2.charCodeAt(0);
          if (encoding === "utf8" && code2 < 128 || encoding === "latin1") {
            val2 = code2;
          }
        }
      } else if (typeof val2 === "number") {
        val2 = val2 & 255;
      } else if (typeof val2 === "boolean") {
        val2 = Number(val2);
      }
      if (start < 0 || this.length < start || this.length < end) {
        throw new RangeError("Out of range index");
      }
      if (end <= start) {
        return this;
      }
      start = start >>> 0;
      end = end === void 0 ? this.length : end >>> 0;
      if (!val2)
        val2 = 0;
      let i2;
      if (typeof val2 === "number") {
        for (i2 = start; i2 < end; ++i2) {
          this[i2] = val2;
        }
      } else {
        const bytes = Buffer2.isBuffer(val2) ? val2 : Buffer2.from(val2, encoding);
        const len2 = bytes.length;
        if (len2 === 0) {
          throw new TypeError('The value "' + val2 + '" is invalid for argument "value"');
        }
        for (i2 = 0; i2 < end - start; ++i2) {
          this[i2 + start] = bytes[i2 % len2];
        }
      }
      return this;
    };
    const errors = {};
    function E(sym, getMessage, Base) {
      errors[sym] = class NodeError extends Base {
        constructor() {
          super();
          Object.defineProperty(this, "message", {
            value: getMessage.apply(this, arguments),
            writable: true,
            configurable: true
          });
          this.name = `${this.name} [${sym}]`;
          this.stack;
          delete this.name;
        }
        get code() {
          return sym;
        }
        set code(value) {
          Object.defineProperty(this, "code", {
            configurable: true,
            enumerable: true,
            value,
            writable: true
          });
        }
        toString() {
          return `${this.name} [${sym}]: ${this.message}`;
        }
      };
    }
    E(
      "ERR_BUFFER_OUT_OF_BOUNDS",
      function(name2) {
        if (name2) {
          return `${name2} is outside of buffer bounds`;
        }
        return "Attempt to access memory outside buffer bounds";
      },
      RangeError
    );
    E(
      "ERR_INVALID_ARG_TYPE",
      function(name2, actual) {
        return `The "${name2}" argument must be of type number. Received type ${typeof actual}`;
      },
      TypeError
    );
    E(
      "ERR_OUT_OF_RANGE",
      function(str, range, input) {
        let msg = `The value of "${str}" is out of range.`;
        let received = input;
        if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
          received = addNumericalSeparator(String(input));
        } else if (typeof input === "bigint") {
          received = String(input);
          if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
            received = addNumericalSeparator(received);
          }
          received += "n";
        }
        msg += ` It must be ${range}. Received ${received}`;
        return msg;
      },
      RangeError
    );
    function addNumericalSeparator(val2) {
      let res = "";
      let i2 = val2.length;
      const start = val2[0] === "-" ? 1 : 0;
      for (; i2 >= start + 4; i2 -= 3) {
        res = `_${val2.slice(i2 - 3, i2)}${res}`;
      }
      return `${val2.slice(0, i2)}${res}`;
    }
    function checkBounds(buf, offset, byteLength3) {
      validateNumber(offset, "offset");
      if (buf[offset] === void 0 || buf[offset + byteLength3] === void 0) {
        boundsError(offset, buf.length - (byteLength3 + 1));
      }
    }
    function checkIntBI(value, min, max, buf, offset, byteLength3) {
      if (value > max || value < min) {
        const n2 = typeof min === "bigint" ? "n" : "";
        let range;
        if (byteLength3 > 3) {
          if (min === 0 || min === BigInt(0)) {
            range = `>= 0${n2} and < 2${n2} ** ${(byteLength3 + 1) * 8}${n2}`;
          } else {
            range = `>= -(2${n2} ** ${(byteLength3 + 1) * 8 - 1}${n2}) and < 2 ** ${(byteLength3 + 1) * 8 - 1}${n2}`;
          }
        } else {
          range = `>= ${min}${n2} and <= ${max}${n2}`;
        }
        throw new errors.ERR_OUT_OF_RANGE("value", range, value);
      }
      checkBounds(buf, offset, byteLength3);
    }
    function validateNumber(value, name2) {
      if (typeof value !== "number") {
        throw new errors.ERR_INVALID_ARG_TYPE(name2, "number", value);
      }
    }
    function boundsError(value, length, type) {
      if (Math.floor(value) !== value) {
        validateNumber(value, type);
        throw new errors.ERR_OUT_OF_RANGE(type || "offset", "an integer", value);
      }
      if (length < 0) {
        throw new errors.ERR_BUFFER_OUT_OF_BOUNDS();
      }
      throw new errors.ERR_OUT_OF_RANGE(
        type || "offset",
        `>= ${type ? 1 : 0} and <= ${length}`,
        value
      );
    }
    const INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
    function base64clean(str) {
      str = str.split("=")[0];
      str = str.trim().replace(INVALID_BASE64_RE, "");
      if (str.length < 2)
        return "";
      while (str.length % 4 !== 0) {
        str = str + "=";
      }
      return str;
    }
    function utf8ToBytes(string, units) {
      units = units || Infinity;
      let codePoint;
      const length = string.length;
      let leadSurrogate = null;
      const bytes = [];
      for (let i2 = 0; i2 < length; ++i2) {
        codePoint = string.charCodeAt(i2);
        if (codePoint > 55295 && codePoint < 57344) {
          if (!leadSurrogate) {
            if (codePoint > 56319) {
              if ((units -= 3) > -1)
                bytes.push(239, 191, 189);
              continue;
            } else if (i2 + 1 === length) {
              if ((units -= 3) > -1)
                bytes.push(239, 191, 189);
              continue;
            }
            leadSurrogate = codePoint;
            continue;
          }
          if (codePoint < 56320) {
            if ((units -= 3) > -1)
              bytes.push(239, 191, 189);
            leadSurrogate = codePoint;
            continue;
          }
          codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
        } else if (leadSurrogate) {
          if ((units -= 3) > -1)
            bytes.push(239, 191, 189);
        }
        leadSurrogate = null;
        if (codePoint < 128) {
          if ((units -= 1) < 0)
            break;
          bytes.push(codePoint);
        } else if (codePoint < 2048) {
          if ((units -= 2) < 0)
            break;
          bytes.push(
            codePoint >> 6 | 192,
            codePoint & 63 | 128
          );
        } else if (codePoint < 65536) {
          if ((units -= 3) < 0)
            break;
          bytes.push(
            codePoint >> 12 | 224,
            codePoint >> 6 & 63 | 128,
            codePoint & 63 | 128
          );
        } else if (codePoint < 1114112) {
          if ((units -= 4) < 0)
            break;
          bytes.push(
            codePoint >> 18 | 240,
            codePoint >> 12 & 63 | 128,
            codePoint >> 6 & 63 | 128,
            codePoint & 63 | 128
          );
        } else {
          throw new Error("Invalid code point");
        }
      }
      return bytes;
    }
    function asciiToBytes(str) {
      const byteArray = [];
      for (let i2 = 0; i2 < str.length; ++i2) {
        byteArray.push(str.charCodeAt(i2) & 255);
      }
      return byteArray;
    }
    function utf16leToBytes(str, units) {
      let c2, hi, lo;
      const byteArray = [];
      for (let i2 = 0; i2 < str.length; ++i2) {
        if ((units -= 2) < 0)
          break;
        c2 = str.charCodeAt(i2);
        hi = c2 >> 8;
        lo = c2 % 256;
        byteArray.push(lo);
        byteArray.push(hi);
      }
      return byteArray;
    }
    function base64ToBytes(str) {
      return base64.toByteArray(base64clean(str));
    }
    function blitBuffer(src, dst, offset, length) {
      let i2;
      for (i2 = 0; i2 < length; ++i2) {
        if (i2 + offset >= dst.length || i2 >= src.length)
          break;
        dst[i2 + offset] = src[i2];
      }
      return i2;
    }
    function isInstance(obj, type) {
      return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
    }
    function numberIsNaN(obj) {
      return obj !== obj;
    }
    const hexSliceLookupTable = function() {
      const alphabet2 = "0123456789abcdef";
      const table = new Array(256);
      for (let i2 = 0; i2 < 16; ++i2) {
        const i16 = i2 * 16;
        for (let j = 0; j < 16; ++j) {
          table[i16 + j] = alphabet2[i2] + alphabet2[j];
        }
      }
      return table;
    }();
    function defineBigIntMethod(fn) {
      return typeof BigInt === "undefined" ? BufferBigIntNotDefined : fn;
    }
    function BufferBigIntNotDefined() {
      throw new Error("BigInt not supported");
    }
  })(buffer);
  const Buffer = buffer.Buffer;
  const Blob$2 = buffer.Blob;
  const BlobOptions = buffer.BlobOptions;
  const Buffer$1 = buffer.Buffer;
  const File$1 = buffer.File;
  const FileOptions = buffer.FileOptions;
  const INSPECT_MAX_BYTES = buffer.INSPECT_MAX_BYTES;
  const SlowBuffer = buffer.SlowBuffer;
  const TranscodeEncoding = buffer.TranscodeEncoding;
  const atob = buffer.atob;
  const btoa = buffer.btoa;
  const constants = buffer.constants;
  const isAscii = buffer.isAscii;
  const isUtf8 = buffer.isUtf8;
  const kMaxLength = buffer.kMaxLength;
  const kStringMaxLength = buffer.kStringMaxLength;
  const resolveObjectURL = buffer.resolveObjectURL;
  const transcode = buffer.transcode;
  var jszip_min$1 = { exports: {} };
  var jszip_min = jszip_min$1.exports;
  (function(module, exports) {
    !function(e2) {
      if (true)
        module.exports = e2();
      else if (false)
        (void 0)([], e2);
      else {
        ("undefined" != typeof window ? window : "undefined" != typeof commonjsGlobal ? commonjsGlobal : "undefined" != typeof self ? self : this).JSZip = e2();
      }
    }(function() {
      return function s2(a2, o2, h2) {
        function u2(r2, e3) {
          if (!o2[r2]) {
            if (!a2[r2]) {
              var t2 = "function" == typeof commonjsRequire && commonjsRequire;
              if (!e3 && t2)
                return t2(r2, true);
              if (l2)
                return l2(r2, true);
              var n2 = new Error("Cannot find module '" + r2 + "'");
              throw n2.code = "MODULE_NOT_FOUND", n2;
            }
            var i2 = o2[r2] = { exports: {} };
            a2[r2][0].call(i2.exports, function(e4) {
              var t3 = a2[r2][1][e4];
              return u2(t3 || e4);
            }, i2, i2.exports, s2, a2, o2, h2);
          }
          return o2[r2].exports;
        }
        for (var l2 = "function" == typeof commonjsRequire && commonjsRequire, e2 = 0; e2 < h2.length; e2++)
          u2(h2[e2]);
        return u2;
      }({ 1: [function(e2, t2, r2) {
        "use strict";
        var d2 = e2("./utils"), c2 = e2("./support"), p2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        r2.encode = function(e3) {
          for (var t3, r3, n2, i2, s2, a2, o2, h2 = [], u2 = 0, l2 = e3.length, f2 = l2, c3 = "string" !== d2.getTypeOf(e3); u2 < e3.length; )
            f2 = l2 - u2, n2 = c3 ? (t3 = e3[u2++], r3 = u2 < l2 ? e3[u2++] : 0, u2 < l2 ? e3[u2++] : 0) : (t3 = e3.charCodeAt(u2++), r3 = u2 < l2 ? e3.charCodeAt(u2++) : 0, u2 < l2 ? e3.charCodeAt(u2++) : 0), i2 = t3 >> 2, s2 = (3 & t3) << 4 | r3 >> 4, a2 = 1 < f2 ? (15 & r3) << 2 | n2 >> 6 : 64, o2 = 2 < f2 ? 63 & n2 : 64, h2.push(p2.charAt(i2) + p2.charAt(s2) + p2.charAt(a2) + p2.charAt(o2));
          return h2.join("");
        }, r2.decode = function(e3) {
          var t3, r3, n2, i2, s2, a2, o2 = 0, h2 = 0, u2 = "data:";
          if (e3.substr(0, u2.length) === u2)
            throw new Error("Invalid base64 input, it looks like a data url.");
          var l2, f2 = 3 * (e3 = e3.replace(/[^A-Za-z0-9+/=]/g, "")).length / 4;
          if (e3.charAt(e3.length - 1) === p2.charAt(64) && f2--, e3.charAt(e3.length - 2) === p2.charAt(64) && f2--, f2 % 1 != 0)
            throw new Error("Invalid base64 input, bad content length.");
          for (l2 = c2.uint8array ? new Uint8Array(0 | f2) : new Array(0 | f2); o2 < e3.length; )
            t3 = p2.indexOf(e3.charAt(o2++)) << 2 | (i2 = p2.indexOf(e3.charAt(o2++))) >> 4, r3 = (15 & i2) << 4 | (s2 = p2.indexOf(e3.charAt(o2++))) >> 2, n2 = (3 & s2) << 6 | (a2 = p2.indexOf(e3.charAt(o2++))), l2[h2++] = t3, 64 !== s2 && (l2[h2++] = r3), 64 !== a2 && (l2[h2++] = n2);
          return l2;
        };
      }, { "./support": 30, "./utils": 32 }], 2: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./external"), i2 = e2("./stream/DataWorker"), s2 = e2("./stream/Crc32Probe"), a2 = e2("./stream/DataLengthProbe");
        function o2(e3, t3, r3, n3, i3) {
          this.compressedSize = e3, this.uncompressedSize = t3, this.crc32 = r3, this.compression = n3, this.compressedContent = i3;
        }
        o2.prototype = { getContentWorker: function() {
          var e3 = new i2(n2.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a2("data_length")), t3 = this;
          return e3.on("end", function() {
            if (this.streamInfo.data_length !== t3.uncompressedSize)
              throw new Error("Bug : uncompressed data size mismatch");
          }), e3;
        }, getCompressedWorker: function() {
          return new i2(n2.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize", this.compressedSize).withStreamInfo("uncompressedSize", this.uncompressedSize).withStreamInfo("crc32", this.crc32).withStreamInfo("compression", this.compression);
        } }, o2.createWorkerFrom = function(e3, t3, r3) {
          return e3.pipe(new s2()).pipe(new a2("uncompressedSize")).pipe(t3.compressWorker(r3)).pipe(new a2("compressedSize")).withStreamInfo("compression", t3);
        }, t2.exports = o2;
      }, { "./external": 6, "./stream/Crc32Probe": 25, "./stream/DataLengthProbe": 26, "./stream/DataWorker": 27 }], 3: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./stream/GenericWorker");
        r2.STORE = { magic: "\0\0", compressWorker: function() {
          return new n2("STORE compression");
        }, uncompressWorker: function() {
          return new n2("STORE decompression");
        } }, r2.DEFLATE = e2("./flate");
      }, { "./flate": 7, "./stream/GenericWorker": 28 }], 4: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./utils");
        var o2 = function() {
          for (var e3, t3 = [], r3 = 0; r3 < 256; r3++) {
            e3 = r3;
            for (var n3 = 0; n3 < 8; n3++)
              e3 = 1 & e3 ? 3988292384 ^ e3 >>> 1 : e3 >>> 1;
            t3[r3] = e3;
          }
          return t3;
        }();
        t2.exports = function(e3, t3) {
          return void 0 !== e3 && e3.length ? "string" !== n2.getTypeOf(e3) ? function(e4, t4, r3, n3) {
            var i2 = o2, s2 = n3 + r3;
            e4 ^= -1;
            for (var a2 = n3; a2 < s2; a2++)
              e4 = e4 >>> 8 ^ i2[255 & (e4 ^ t4[a2])];
            return -1 ^ e4;
          }(0 | t3, e3, e3.length, 0) : function(e4, t4, r3, n3) {
            var i2 = o2, s2 = n3 + r3;
            e4 ^= -1;
            for (var a2 = n3; a2 < s2; a2++)
              e4 = e4 >>> 8 ^ i2[255 & (e4 ^ t4.charCodeAt(a2))];
            return -1 ^ e4;
          }(0 | t3, e3, e3.length, 0) : 0;
        };
      }, { "./utils": 32 }], 5: [function(e2, t2, r2) {
        "use strict";
        r2.base64 = false, r2.binary = false, r2.dir = false, r2.createFolders = true, r2.date = null, r2.compression = null, r2.compressionOptions = null, r2.comment = null, r2.unixPermissions = null, r2.dosPermissions = null;
      }, {}], 6: [function(e2, t2, r2) {
        "use strict";
        var n2 = null;
        n2 = "undefined" != typeof Promise ? Promise : e2("lie"), t2.exports = { Promise: n2 };
      }, { lie: 37 }], 7: [function(e2, t2, r2) {
        "use strict";
        var n2 = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Uint32Array, i2 = e2("pako"), s2 = e2("./utils"), a2 = e2("./stream/GenericWorker"), o2 = n2 ? "uint8array" : "array";
        function h2(e3, t3) {
          a2.call(this, "FlateWorker/" + e3), this._pako = null, this._pakoAction = e3, this._pakoOptions = t3, this.meta = {};
        }
        r2.magic = "\b\0", s2.inherits(h2, a2), h2.prototype.processChunk = function(e3) {
          this.meta = e3.meta, null === this._pako && this._createPako(), this._pako.push(s2.transformTo(o2, e3.data), false);
        }, h2.prototype.flush = function() {
          a2.prototype.flush.call(this), null === this._pako && this._createPako(), this._pako.push([], true);
        }, h2.prototype.cleanUp = function() {
          a2.prototype.cleanUp.call(this), this._pako = null;
        }, h2.prototype._createPako = function() {
          this._pako = new i2[this._pakoAction]({ raw: true, level: this._pakoOptions.level || -1 });
          var t3 = this;
          this._pako.onData = function(e3) {
            t3.push({ data: e3, meta: t3.meta });
          };
        }, r2.compressWorker = function(e3) {
          return new h2("Deflate", e3);
        }, r2.uncompressWorker = function() {
          return new h2("Inflate", {});
        };
      }, { "./stream/GenericWorker": 28, "./utils": 32, pako: 38 }], 8: [function(e2, t2, r2) {
        "use strict";
        function A(e3, t3) {
          var r3, n3 = "";
          for (r3 = 0; r3 < t3; r3++)
            n3 += String.fromCharCode(255 & e3), e3 >>>= 8;
          return n3;
        }
        function n2(e3, t3, r3, n3, i3, s3) {
          var a2, o2, h2 = e3.file, u2 = e3.compression, l2 = s3 !== O.utf8encode, f2 = I.transformTo("string", s3(h2.name)), c2 = I.transformTo("string", O.utf8encode(h2.name)), d2 = h2.comment, p2 = I.transformTo("string", s3(d2)), m = I.transformTo("string", O.utf8encode(d2)), _ = c2.length !== h2.name.length, g = m.length !== d2.length, b = "", v = "", y = "", w = h2.dir, k = h2.date, x = { crc32: 0, compressedSize: 0, uncompressedSize: 0 };
          t3 && !r3 || (x.crc32 = e3.crc32, x.compressedSize = e3.compressedSize, x.uncompressedSize = e3.uncompressedSize);
          var S = 0;
          t3 && (S |= 8), l2 || !_ && !g || (S |= 2048);
          var z = 0, C = 0;
          w && (z |= 16), "UNIX" === i3 ? (C = 798, z |= function(e4, t4) {
            var r4 = e4;
            return e4 || (r4 = t4 ? 16893 : 33204), (65535 & r4) << 16;
          }(h2.unixPermissions, w)) : (C = 20, z |= function(e4) {
            return 63 & (e4 || 0);
          }(h2.dosPermissions)), a2 = k.getUTCHours(), a2 <<= 6, a2 |= k.getUTCMinutes(), a2 <<= 5, a2 |= k.getUTCSeconds() / 2, o2 = k.getUTCFullYear() - 1980, o2 <<= 4, o2 |= k.getUTCMonth() + 1, o2 <<= 5, o2 |= k.getUTCDate(), _ && (v = A(1, 1) + A(B(f2), 4) + c2, b += "up" + A(v.length, 2) + v), g && (y = A(1, 1) + A(B(p2), 4) + m, b += "uc" + A(y.length, 2) + y);
          var E = "";
          return E += "\n\0", E += A(S, 2), E += u2.magic, E += A(a2, 2), E += A(o2, 2), E += A(x.crc32, 4), E += A(x.compressedSize, 4), E += A(x.uncompressedSize, 4), E += A(f2.length, 2), E += A(b.length, 2), { fileRecord: R.LOCAL_FILE_HEADER + E + f2 + b, dirRecord: R.CENTRAL_FILE_HEADER + A(C, 2) + E + A(p2.length, 2) + "\0\0\0\0" + A(z, 4) + A(n3, 4) + f2 + b + p2 };
        }
        var I = e2("../utils"), i2 = e2("../stream/GenericWorker"), O = e2("../utf8"), B = e2("../crc32"), R = e2("../signature");
        function s2(e3, t3, r3, n3) {
          i2.call(this, "ZipFileWorker"), this.bytesWritten = 0, this.zipComment = t3, this.zipPlatform = r3, this.encodeFileName = n3, this.streamFiles = e3, this.accumulate = false, this.contentBuffer = [], this.dirRecords = [], this.currentSourceOffset = 0, this.entriesCount = 0, this.currentFile = null, this._sources = [];
        }
        I.inherits(s2, i2), s2.prototype.push = function(e3) {
          var t3 = e3.meta.percent || 0, r3 = this.entriesCount, n3 = this._sources.length;
          this.accumulate ? this.contentBuffer.push(e3) : (this.bytesWritten += e3.data.length, i2.prototype.push.call(this, { data: e3.data, meta: { currentFile: this.currentFile, percent: r3 ? (t3 + 100 * (r3 - n3 - 1)) / r3 : 100 } }));
        }, s2.prototype.openedSource = function(e3) {
          this.currentSourceOffset = this.bytesWritten, this.currentFile = e3.file.name;
          var t3 = this.streamFiles && !e3.file.dir;
          if (t3) {
            var r3 = n2(e3, t3, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
            this.push({ data: r3.fileRecord, meta: { percent: 0 } });
          } else
            this.accumulate = true;
        }, s2.prototype.closedSource = function(e3) {
          this.accumulate = false;
          var t3 = this.streamFiles && !e3.file.dir, r3 = n2(e3, t3, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
          if (this.dirRecords.push(r3.dirRecord), t3)
            this.push({ data: function(e4) {
              return R.DATA_DESCRIPTOR + A(e4.crc32, 4) + A(e4.compressedSize, 4) + A(e4.uncompressedSize, 4);
            }(e3), meta: { percent: 100 } });
          else
            for (this.push({ data: r3.fileRecord, meta: { percent: 0 } }); this.contentBuffer.length; )
              this.push(this.contentBuffer.shift());
          this.currentFile = null;
        }, s2.prototype.flush = function() {
          for (var e3 = this.bytesWritten, t3 = 0; t3 < this.dirRecords.length; t3++)
            this.push({ data: this.dirRecords[t3], meta: { percent: 100 } });
          var r3 = this.bytesWritten - e3, n3 = function(e4, t4, r4, n4, i3) {
            var s3 = I.transformTo("string", i3(n4));
            return R.CENTRAL_DIRECTORY_END + "\0\0\0\0" + A(e4, 2) + A(e4, 2) + A(t4, 4) + A(r4, 4) + A(s3.length, 2) + s3;
          }(this.dirRecords.length, r3, e3, this.zipComment, this.encodeFileName);
          this.push({ data: n3, meta: { percent: 100 } });
        }, s2.prototype.prepareNextSource = function() {
          this.previous = this._sources.shift(), this.openedSource(this.previous.streamInfo), this.isPaused ? this.previous.pause() : this.previous.resume();
        }, s2.prototype.registerPrevious = function(e3) {
          this._sources.push(e3);
          var t3 = this;
          return e3.on("data", function(e4) {
            t3.processChunk(e4);
          }), e3.on("end", function() {
            t3.closedSource(t3.previous.streamInfo), t3._sources.length ? t3.prepareNextSource() : t3.end();
          }), e3.on("error", function(e4) {
            t3.error(e4);
          }), this;
        }, s2.prototype.resume = function() {
          return !!i2.prototype.resume.call(this) && (!this.previous && this._sources.length ? (this.prepareNextSource(), true) : this.previous || this._sources.length || this.generatedError ? void 0 : (this.end(), true));
        }, s2.prototype.error = function(e3) {
          var t3 = this._sources;
          if (!i2.prototype.error.call(this, e3))
            return false;
          for (var r3 = 0; r3 < t3.length; r3++)
            try {
              t3[r3].error(e3);
            } catch (e4) {
            }
          return true;
        }, s2.prototype.lock = function() {
          i2.prototype.lock.call(this);
          for (var e3 = this._sources, t3 = 0; t3 < e3.length; t3++)
            e3[t3].lock();
        }, t2.exports = s2;
      }, { "../crc32": 4, "../signature": 23, "../stream/GenericWorker": 28, "../utf8": 31, "../utils": 32 }], 9: [function(e2, t2, r2) {
        "use strict";
        var u2 = e2("../compressions"), n2 = e2("./ZipFileWorker");
        r2.generateWorker = function(e3, a2, t3) {
          var o2 = new n2(a2.streamFiles, t3, a2.platform, a2.encodeFileName), h2 = 0;
          try {
            e3.forEach(function(e4, t4) {
              h2++;
              var r3 = function(e5, t5) {
                var r4 = e5 || t5, n4 = u2[r4];
                if (!n4)
                  throw new Error(r4 + " is not a valid compression method !");
                return n4;
              }(t4.options.compression, a2.compression), n3 = t4.options.compressionOptions || a2.compressionOptions || {}, i2 = t4.dir, s2 = t4.date;
              t4._compressWorker(r3, n3).withStreamInfo("file", { name: e4, dir: i2, date: s2, comment: t4.comment || "", unixPermissions: t4.unixPermissions, dosPermissions: t4.dosPermissions }).pipe(o2);
            }), o2.entriesCount = h2;
          } catch (e4) {
            o2.error(e4);
          }
          return o2;
        };
      }, { "../compressions": 3, "./ZipFileWorker": 8 }], 10: [function(e2, t2, r2) {
        "use strict";
        function n2() {
          if (!(this instanceof n2))
            return new n2();
          if (arguments.length)
            throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
          this.files = /* @__PURE__ */ Object.create(null), this.comment = null, this.root = "", this.clone = function() {
            var e3 = new n2();
            for (var t3 in this)
              "function" != typeof this[t3] && (e3[t3] = this[t3]);
            return e3;
          };
        }
        (n2.prototype = e2("./object")).loadAsync = e2("./load"), n2.support = e2("./support"), n2.defaults = e2("./defaults"), n2.version = "3.10.1", n2.loadAsync = function(e3, t3) {
          return new n2().loadAsync(e3, t3);
        }, n2.external = e2("./external"), t2.exports = n2;
      }, { "./defaults": 5, "./external": 6, "./load": 11, "./object": 15, "./support": 30 }], 11: [function(e2, t2, r2) {
        "use strict";
        var u2 = e2("./utils"), i2 = e2("./external"), n2 = e2("./utf8"), s2 = e2("./zipEntries"), a2 = e2("./stream/Crc32Probe"), l2 = e2("./nodejsUtils");
        function f2(n3) {
          return new i2.Promise(function(e3, t3) {
            var r3 = n3.decompressed.getContentWorker().pipe(new a2());
            r3.on("error", function(e4) {
              t3(e4);
            }).on("end", function() {
              r3.streamInfo.crc32 !== n3.decompressed.crc32 ? t3(new Error("Corrupted zip : CRC32 mismatch")) : e3();
            }).resume();
          });
        }
        t2.exports = function(e3, o2) {
          var h2 = this;
          return o2 = u2.extend(o2 || {}, { base64: false, checkCRC32: false, optimizedBinaryString: false, createFolders: false, decodeFileName: n2.utf8decode }), l2.isNode && l2.isStream(e3) ? i2.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")) : u2.prepareContent("the loaded zip file", e3, true, o2.optimizedBinaryString, o2.base64).then(function(e4) {
            var t3 = new s2(o2);
            return t3.load(e4), t3;
          }).then(function(e4) {
            var t3 = [i2.Promise.resolve(e4)], r3 = e4.files;
            if (o2.checkCRC32)
              for (var n3 = 0; n3 < r3.length; n3++)
                t3.push(f2(r3[n3]));
            return i2.Promise.all(t3);
          }).then(function(e4) {
            for (var t3 = e4.shift(), r3 = t3.files, n3 = 0; n3 < r3.length; n3++) {
              var i3 = r3[n3], s3 = i3.fileNameStr, a3 = u2.resolve(i3.fileNameStr);
              h2.file(a3, i3.decompressed, { binary: true, optimizedBinaryString: true, date: i3.date, dir: i3.dir, comment: i3.fileCommentStr.length ? i3.fileCommentStr : null, unixPermissions: i3.unixPermissions, dosPermissions: i3.dosPermissions, createFolders: o2.createFolders }), i3.dir || (h2.file(a3).unsafeOriginalName = s3);
            }
            return t3.zipComment.length && (h2.comment = t3.zipComment), h2;
          });
        };
      }, { "./external": 6, "./nodejsUtils": 14, "./stream/Crc32Probe": 25, "./utf8": 31, "./utils": 32, "./zipEntries": 33 }], 12: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("../utils"), i2 = e2("../stream/GenericWorker");
        function s2(e3, t3) {
          i2.call(this, "Nodejs stream input adapter for " + e3), this._upstreamEnded = false, this._bindStream(t3);
        }
        n2.inherits(s2, i2), s2.prototype._bindStream = function(e3) {
          var t3 = this;
          (this._stream = e3).pause(), e3.on("data", function(e4) {
            t3.push({ data: e4, meta: { percent: 0 } });
          }).on("error", function(e4) {
            t3.isPaused ? this.generatedError = e4 : t3.error(e4);
          }).on("end", function() {
            t3.isPaused ? t3._upstreamEnded = true : t3.end();
          });
        }, s2.prototype.pause = function() {
          return !!i2.prototype.pause.call(this) && (this._stream.pause(), true);
        }, s2.prototype.resume = function() {
          return !!i2.prototype.resume.call(this) && (this._upstreamEnded ? this.end() : this._stream.resume(), true);
        }, t2.exports = s2;
      }, { "../stream/GenericWorker": 28, "../utils": 32 }], 13: [function(e2, t2, r2) {
        "use strict";
        var i2 = e2("readable-stream").Readable;
        function n2(e3, t3, r3) {
          i2.call(this, t3), this._helper = e3;
          var n3 = this;
          e3.on("data", function(e4, t4) {
            n3.push(e4) || n3._helper.pause(), r3 && r3(t4);
          }).on("error", function(e4) {
            n3.emit("error", e4);
          }).on("end", function() {
            n3.push(null);
          });
        }
        e2("../utils").inherits(n2, i2), n2.prototype._read = function() {
          this._helper.resume();
        }, t2.exports = n2;
      }, { "../utils": 32, "readable-stream": 16 }], 14: [function(e2, t2, r2) {
        "use strict";
        t2.exports = { isNode: "undefined" != typeof Buffer, newBufferFrom: function(e3, t3) {
          if (Buffer.from && Buffer.from !== Uint8Array.from)
            return Buffer.from(e3, t3);
          if ("number" == typeof e3)
            throw new Error('The "data" argument must not be a number');
          return new Buffer(e3, t3);
        }, allocBuffer: function(e3) {
          if (Buffer.alloc)
            return Buffer.alloc(e3);
          var t3 = new Buffer(e3);
          return t3.fill(0), t3;
        }, isBuffer: function(e3) {
          return Buffer.isBuffer(e3);
        }, isStream: function(e3) {
          return e3 && "function" == typeof e3.on && "function" == typeof e3.pause && "function" == typeof e3.resume;
        } };
      }, {}], 15: [function(e2, t2, r2) {
        "use strict";
        function s2(e3, t3, r3) {
          var n3, i3 = u2.getTypeOf(t3), s3 = u2.extend(r3 || {}, f2);
          s3.date = s3.date || /* @__PURE__ */ new Date(), null !== s3.compression && (s3.compression = s3.compression.toUpperCase()), "string" == typeof s3.unixPermissions && (s3.unixPermissions = parseInt(s3.unixPermissions, 8)), s3.unixPermissions && 16384 & s3.unixPermissions && (s3.dir = true), s3.dosPermissions && 16 & s3.dosPermissions && (s3.dir = true), s3.dir && (e3 = g(e3)), s3.createFolders && (n3 = _(e3)) && b.call(this, n3, true);
          var a3 = "string" === i3 && false === s3.binary && false === s3.base64;
          r3 && void 0 !== r3.binary || (s3.binary = !a3), (t3 instanceof c2 && 0 === t3.uncompressedSize || s3.dir || !t3 || 0 === t3.length) && (s3.base64 = false, s3.binary = true, t3 = "", s3.compression = "STORE", i3 = "string");
          var o3 = null;
          o3 = t3 instanceof c2 || t3 instanceof l2 ? t3 : p2.isNode && p2.isStream(t3) ? new m(e3, t3) : u2.prepareContent(e3, t3, s3.binary, s3.optimizedBinaryString, s3.base64);
          var h3 = new d2(e3, o3, s3);
          this.files[e3] = h3;
        }
        var i2 = e2("./utf8"), u2 = e2("./utils"), l2 = e2("./stream/GenericWorker"), a2 = e2("./stream/StreamHelper"), f2 = e2("./defaults"), c2 = e2("./compressedObject"), d2 = e2("./zipObject"), o2 = e2("./generate"), p2 = e2("./nodejsUtils"), m = e2("./nodejs/NodejsStreamInputAdapter"), _ = function(e3) {
          "/" === e3.slice(-1) && (e3 = e3.substring(0, e3.length - 1));
          var t3 = e3.lastIndexOf("/");
          return 0 < t3 ? e3.substring(0, t3) : "";
        }, g = function(e3) {
          return "/" !== e3.slice(-1) && (e3 += "/"), e3;
        }, b = function(e3, t3) {
          return t3 = void 0 !== t3 ? t3 : f2.createFolders, e3 = g(e3), this.files[e3] || s2.call(this, e3, null, { dir: true, createFolders: t3 }), this.files[e3];
        };
        function h2(e3) {
          return "[object RegExp]" === Object.prototype.toString.call(e3);
        }
        var n2 = { load: function() {
          throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
        }, forEach: function(e3) {
          var t3, r3, n3;
          for (t3 in this.files)
            n3 = this.files[t3], (r3 = t3.slice(this.root.length, t3.length)) && t3.slice(0, this.root.length) === this.root && e3(r3, n3);
        }, filter: function(r3) {
          var n3 = [];
          return this.forEach(function(e3, t3) {
            r3(e3, t3) && n3.push(t3);
          }), n3;
        }, file: function(e3, t3, r3) {
          if (1 !== arguments.length)
            return e3 = this.root + e3, s2.call(this, e3, t3, r3), this;
          if (h2(e3)) {
            var n3 = e3;
            return this.filter(function(e4, t4) {
              return !t4.dir && n3.test(e4);
            });
          }
          var i3 = this.files[this.root + e3];
          return i3 && !i3.dir ? i3 : null;
        }, folder: function(r3) {
          if (!r3)
            return this;
          if (h2(r3))
            return this.filter(function(e4, t4) {
              return t4.dir && r3.test(e4);
            });
          var e3 = this.root + r3, t3 = b.call(this, e3), n3 = this.clone();
          return n3.root = t3.name, n3;
        }, remove: function(r3) {
          r3 = this.root + r3;
          var e3 = this.files[r3];
          if (e3 || ("/" !== r3.slice(-1) && (r3 += "/"), e3 = this.files[r3]), e3 && !e3.dir)
            delete this.files[r3];
          else
            for (var t3 = this.filter(function(e4, t4) {
              return t4.name.slice(0, r3.length) === r3;
            }), n3 = 0; n3 < t3.length; n3++)
              delete this.files[t3[n3].name];
          return this;
        }, generate: function() {
          throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
        }, generateInternalStream: function(e3) {
          var t3, r3 = {};
          try {
            if ((r3 = u2.extend(e3 || {}, { streamFiles: false, compression: "STORE", compressionOptions: null, type: "", platform: "DOS", comment: null, mimeType: "application/zip", encodeFileName: i2.utf8encode })).type = r3.type.toLowerCase(), r3.compression = r3.compression.toUpperCase(), "binarystring" === r3.type && (r3.type = "string"), !r3.type)
              throw new Error("No output type specified.");
            u2.checkSupport(r3.type), "darwin" !== r3.platform && "freebsd" !== r3.platform && "linux" !== r3.platform && "sunos" !== r3.platform || (r3.platform = "UNIX"), "win32" === r3.platform && (r3.platform = "DOS");
            var n3 = r3.comment || this.comment || "";
            t3 = o2.generateWorker(this, r3, n3);
          } catch (e4) {
            (t3 = new l2("error")).error(e4);
          }
          return new a2(t3, r3.type || "string", r3.mimeType);
        }, generateAsync: function(e3, t3) {
          return this.generateInternalStream(e3).accumulate(t3);
        }, generateNodeStream: function(e3, t3) {
          return (e3 = e3 || {}).type || (e3.type = "nodebuffer"), this.generateInternalStream(e3).toNodejsStream(t3);
        } };
        t2.exports = n2;
      }, { "./compressedObject": 2, "./defaults": 5, "./generate": 9, "./nodejs/NodejsStreamInputAdapter": 12, "./nodejsUtils": 14, "./stream/GenericWorker": 28, "./stream/StreamHelper": 29, "./utf8": 31, "./utils": 32, "./zipObject": 35 }], 16: [function(e2, t2, r2) {
        "use strict";
        t2.exports = e2("stream");
      }, { stream: void 0 }], 17: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./DataReader");
        function i2(e3) {
          n2.call(this, e3);
          for (var t3 = 0; t3 < this.data.length; t3++)
            e3[t3] = 255 & e3[t3];
        }
        e2("../utils").inherits(i2, n2), i2.prototype.byteAt = function(e3) {
          return this.data[this.zero + e3];
        }, i2.prototype.lastIndexOfSignature = function(e3) {
          for (var t3 = e3.charCodeAt(0), r3 = e3.charCodeAt(1), n3 = e3.charCodeAt(2), i3 = e3.charCodeAt(3), s2 = this.length - 4; 0 <= s2; --s2)
            if (this.data[s2] === t3 && this.data[s2 + 1] === r3 && this.data[s2 + 2] === n3 && this.data[s2 + 3] === i3)
              return s2 - this.zero;
          return -1;
        }, i2.prototype.readAndCheckSignature = function(e3) {
          var t3 = e3.charCodeAt(0), r3 = e3.charCodeAt(1), n3 = e3.charCodeAt(2), i3 = e3.charCodeAt(3), s2 = this.readData(4);
          return t3 === s2[0] && r3 === s2[1] && n3 === s2[2] && i3 === s2[3];
        }, i2.prototype.readData = function(e3) {
          if (this.checkOffset(e3), 0 === e3)
            return [];
          var t3 = this.data.slice(this.zero + this.index, this.zero + this.index + e3);
          return this.index += e3, t3;
        }, t2.exports = i2;
      }, { "../utils": 32, "./DataReader": 18 }], 18: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("../utils");
        function i2(e3) {
          this.data = e3, this.length = e3.length, this.index = 0, this.zero = 0;
        }
        i2.prototype = { checkOffset: function(e3) {
          this.checkIndex(this.index + e3);
        }, checkIndex: function(e3) {
          if (this.length < this.zero + e3 || e3 < 0)
            throw new Error("End of data reached (data length = " + this.length + ", asked index = " + e3 + "). Corrupted zip ?");
        }, setIndex: function(e3) {
          this.checkIndex(e3), this.index = e3;
        }, skip: function(e3) {
          this.setIndex(this.index + e3);
        }, byteAt: function() {
        }, readInt: function(e3) {
          var t3, r3 = 0;
          for (this.checkOffset(e3), t3 = this.index + e3 - 1; t3 >= this.index; t3--)
            r3 = (r3 << 8) + this.byteAt(t3);
          return this.index += e3, r3;
        }, readString: function(e3) {
          return n2.transformTo("string", this.readData(e3));
        }, readData: function() {
        }, lastIndexOfSignature: function() {
        }, readAndCheckSignature: function() {
        }, readDate: function() {
          var e3 = this.readInt(4);
          return new Date(Date.UTC(1980 + (e3 >> 25 & 127), (e3 >> 21 & 15) - 1, e3 >> 16 & 31, e3 >> 11 & 31, e3 >> 5 & 63, (31 & e3) << 1));
        } }, t2.exports = i2;
      }, { "../utils": 32 }], 19: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./Uint8ArrayReader");
        function i2(e3) {
          n2.call(this, e3);
        }
        e2("../utils").inherits(i2, n2), i2.prototype.readData = function(e3) {
          this.checkOffset(e3);
          var t3 = this.data.slice(this.zero + this.index, this.zero + this.index + e3);
          return this.index += e3, t3;
        }, t2.exports = i2;
      }, { "../utils": 32, "./Uint8ArrayReader": 21 }], 20: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./DataReader");
        function i2(e3) {
          n2.call(this, e3);
        }
        e2("../utils").inherits(i2, n2), i2.prototype.byteAt = function(e3) {
          return this.data.charCodeAt(this.zero + e3);
        }, i2.prototype.lastIndexOfSignature = function(e3) {
          return this.data.lastIndexOf(e3) - this.zero;
        }, i2.prototype.readAndCheckSignature = function(e3) {
          return e3 === this.readData(4);
        }, i2.prototype.readData = function(e3) {
          this.checkOffset(e3);
          var t3 = this.data.slice(this.zero + this.index, this.zero + this.index + e3);
          return this.index += e3, t3;
        }, t2.exports = i2;
      }, { "../utils": 32, "./DataReader": 18 }], 21: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./ArrayReader");
        function i2(e3) {
          n2.call(this, e3);
        }
        e2("../utils").inherits(i2, n2), i2.prototype.readData = function(e3) {
          if (this.checkOffset(e3), 0 === e3)
            return new Uint8Array(0);
          var t3 = this.data.subarray(this.zero + this.index, this.zero + this.index + e3);
          return this.index += e3, t3;
        }, t2.exports = i2;
      }, { "../utils": 32, "./ArrayReader": 17 }], 22: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("../utils"), i2 = e2("../support"), s2 = e2("./ArrayReader"), a2 = e2("./StringReader"), o2 = e2("./NodeBufferReader"), h2 = e2("./Uint8ArrayReader");
        t2.exports = function(e3) {
          var t3 = n2.getTypeOf(e3);
          return n2.checkSupport(t3), "string" !== t3 || i2.uint8array ? "nodebuffer" === t3 ? new o2(e3) : i2.uint8array ? new h2(n2.transformTo("uint8array", e3)) : new s2(n2.transformTo("array", e3)) : new a2(e3);
        };
      }, { "../support": 30, "../utils": 32, "./ArrayReader": 17, "./NodeBufferReader": 19, "./StringReader": 20, "./Uint8ArrayReader": 21 }], 23: [function(e2, t2, r2) {
        "use strict";
        r2.LOCAL_FILE_HEADER = "PK", r2.CENTRAL_FILE_HEADER = "PK", r2.CENTRAL_DIRECTORY_END = "PK", r2.ZIP64_CENTRAL_DIRECTORY_LOCATOR = "PK\x07", r2.ZIP64_CENTRAL_DIRECTORY_END = "PK", r2.DATA_DESCRIPTOR = "PK\x07\b";
      }, {}], 24: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./GenericWorker"), i2 = e2("../utils");
        function s2(e3) {
          n2.call(this, "ConvertWorker to " + e3), this.destType = e3;
        }
        i2.inherits(s2, n2), s2.prototype.processChunk = function(e3) {
          this.push({ data: i2.transformTo(this.destType, e3.data), meta: e3.meta });
        }, t2.exports = s2;
      }, { "../utils": 32, "./GenericWorker": 28 }], 25: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./GenericWorker"), i2 = e2("../crc32");
        function s2() {
          n2.call(this, "Crc32Probe"), this.withStreamInfo("crc32", 0);
        }
        e2("../utils").inherits(s2, n2), s2.prototype.processChunk = function(e3) {
          this.streamInfo.crc32 = i2(e3.data, this.streamInfo.crc32 || 0), this.push(e3);
        }, t2.exports = s2;
      }, { "../crc32": 4, "../utils": 32, "./GenericWorker": 28 }], 26: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("../utils"), i2 = e2("./GenericWorker");
        function s2(e3) {
          i2.call(this, "DataLengthProbe for " + e3), this.propName = e3, this.withStreamInfo(e3, 0);
        }
        n2.inherits(s2, i2), s2.prototype.processChunk = function(e3) {
          if (e3) {
            var t3 = this.streamInfo[this.propName] || 0;
            this.streamInfo[this.propName] = t3 + e3.data.length;
          }
          i2.prototype.processChunk.call(this, e3);
        }, t2.exports = s2;
      }, { "../utils": 32, "./GenericWorker": 28 }], 27: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("../utils"), i2 = e2("./GenericWorker");
        function s2(e3) {
          i2.call(this, "DataWorker");
          var t3 = this;
          this.dataIsReady = false, this.index = 0, this.max = 0, this.data = null, this.type = "", this._tickScheduled = false, e3.then(function(e4) {
            t3.dataIsReady = true, t3.data = e4, t3.max = e4 && e4.length || 0, t3.type = n2.getTypeOf(e4), t3.isPaused || t3._tickAndRepeat();
          }, function(e4) {
            t3.error(e4);
          });
        }
        n2.inherits(s2, i2), s2.prototype.cleanUp = function() {
          i2.prototype.cleanUp.call(this), this.data = null;
        }, s2.prototype.resume = function() {
          return !!i2.prototype.resume.call(this) && (!this._tickScheduled && this.dataIsReady && (this._tickScheduled = true, n2.delay(this._tickAndRepeat, [], this)), true);
        }, s2.prototype._tickAndRepeat = function() {
          this._tickScheduled = false, this.isPaused || this.isFinished || (this._tick(), this.isFinished || (n2.delay(this._tickAndRepeat, [], this), this._tickScheduled = true));
        }, s2.prototype._tick = function() {
          if (this.isPaused || this.isFinished)
            return false;
          var e3 = null, t3 = Math.min(this.max, this.index + 16384);
          if (this.index >= this.max)
            return this.end();
          switch (this.type) {
            case "string":
              e3 = this.data.substring(this.index, t3);
              break;
            case "uint8array":
              e3 = this.data.subarray(this.index, t3);
              break;
            case "array":
            case "nodebuffer":
              e3 = this.data.slice(this.index, t3);
          }
          return this.index = t3, this.push({ data: e3, meta: { percent: this.max ? this.index / this.max * 100 : 0 } });
        }, t2.exports = s2;
      }, { "../utils": 32, "./GenericWorker": 28 }], 28: [function(e2, t2, r2) {
        "use strict";
        function n2(e3) {
          this.name = e3 || "default", this.streamInfo = {}, this.generatedError = null, this.extraStreamInfo = {}, this.isPaused = true, this.isFinished = false, this.isLocked = false, this._listeners = { data: [], end: [], error: [] }, this.previous = null;
        }
        n2.prototype = { push: function(e3) {
          this.emit("data", e3);
        }, end: function() {
          if (this.isFinished)
            return false;
          this.flush();
          try {
            this.emit("end"), this.cleanUp(), this.isFinished = true;
          } catch (e3) {
            this.emit("error", e3);
          }
          return true;
        }, error: function(e3) {
          return !this.isFinished && (this.isPaused ? this.generatedError = e3 : (this.isFinished = true, this.emit("error", e3), this.previous && this.previous.error(e3), this.cleanUp()), true);
        }, on: function(e3, t3) {
          return this._listeners[e3].push(t3), this;
        }, cleanUp: function() {
          this.streamInfo = this.generatedError = this.extraStreamInfo = null, this._listeners = [];
        }, emit: function(e3, t3) {
          if (this._listeners[e3])
            for (var r3 = 0; r3 < this._listeners[e3].length; r3++)
              this._listeners[e3][r3].call(this, t3);
        }, pipe: function(e3) {
          return e3.registerPrevious(this);
        }, registerPrevious: function(e3) {
          if (this.isLocked)
            throw new Error("The stream '" + this + "' has already been used.");
          this.streamInfo = e3.streamInfo, this.mergeStreamInfo(), this.previous = e3;
          var t3 = this;
          return e3.on("data", function(e4) {
            t3.processChunk(e4);
          }), e3.on("end", function() {
            t3.end();
          }), e3.on("error", function(e4) {
            t3.error(e4);
          }), this;
        }, pause: function() {
          return !this.isPaused && !this.isFinished && (this.isPaused = true, this.previous && this.previous.pause(), true);
        }, resume: function() {
          if (!this.isPaused || this.isFinished)
            return false;
          var e3 = this.isPaused = false;
          return this.generatedError && (this.error(this.generatedError), e3 = true), this.previous && this.previous.resume(), !e3;
        }, flush: function() {
        }, processChunk: function(e3) {
          this.push(e3);
        }, withStreamInfo: function(e3, t3) {
          return this.extraStreamInfo[e3] = t3, this.mergeStreamInfo(), this;
        }, mergeStreamInfo: function() {
          for (var e3 in this.extraStreamInfo)
            Object.prototype.hasOwnProperty.call(this.extraStreamInfo, e3) && (this.streamInfo[e3] = this.extraStreamInfo[e3]);
        }, lock: function() {
          if (this.isLocked)
            throw new Error("The stream '" + this + "' has already been used.");
          this.isLocked = true, this.previous && this.previous.lock();
        }, toString: function() {
          var e3 = "Worker " + this.name;
          return this.previous ? this.previous + " -> " + e3 : e3;
        } }, t2.exports = n2;
      }, {}], 29: [function(e2, t2, r2) {
        "use strict";
        var h2 = e2("../utils"), i2 = e2("./ConvertWorker"), s2 = e2("./GenericWorker"), u2 = e2("../base64"), n2 = e2("../support"), a2 = e2("../external"), o2 = null;
        if (n2.nodestream)
          try {
            o2 = e2("../nodejs/NodejsStreamOutputAdapter");
          } catch (e3) {
          }
        function l2(e3, o3) {
          return new a2.Promise(function(t3, r3) {
            var n3 = [], i3 = e3._internalType, s3 = e3._outputType, a3 = e3._mimeType;
            e3.on("data", function(e4, t4) {
              n3.push(e4), o3 && o3(t4);
            }).on("error", function(e4) {
              n3 = [], r3(e4);
            }).on("end", function() {
              try {
                var e4 = function(e5, t4, r4) {
                  switch (e5) {
                    case "blob":
                      return h2.newBlob(h2.transformTo("arraybuffer", t4), r4);
                    case "base64":
                      return u2.encode(t4);
                    default:
                      return h2.transformTo(e5, t4);
                  }
                }(s3, function(e5, t4) {
                  var r4, n4 = 0, i4 = null, s4 = 0;
                  for (r4 = 0; r4 < t4.length; r4++)
                    s4 += t4[r4].length;
                  switch (e5) {
                    case "string":
                      return t4.join("");
                    case "array":
                      return Array.prototype.concat.apply([], t4);
                    case "uint8array":
                      for (i4 = new Uint8Array(s4), r4 = 0; r4 < t4.length; r4++)
                        i4.set(t4[r4], n4), n4 += t4[r4].length;
                      return i4;
                    case "nodebuffer":
                      return Buffer.concat(t4);
                    default:
                      throw new Error("concat : unsupported type '" + e5 + "'");
                  }
                }(i3, n3), a3);
                t3(e4);
              } catch (e5) {
                r3(e5);
              }
              n3 = [];
            }).resume();
          });
        }
        function f2(e3, t3, r3) {
          var n3 = t3;
          switch (t3) {
            case "blob":
            case "arraybuffer":
              n3 = "uint8array";
              break;
            case "base64":
              n3 = "string";
          }
          try {
            this._internalType = n3, this._outputType = t3, this._mimeType = r3, h2.checkSupport(n3), this._worker = e3.pipe(new i2(n3)), e3.lock();
          } catch (e4) {
            this._worker = new s2("error"), this._worker.error(e4);
          }
        }
        f2.prototype = { accumulate: function(e3) {
          return l2(this, e3);
        }, on: function(e3, t3) {
          var r3 = this;
          return "data" === e3 ? this._worker.on(e3, function(e4) {
            t3.call(r3, e4.data, e4.meta);
          }) : this._worker.on(e3, function() {
            h2.delay(t3, arguments, r3);
          }), this;
        }, resume: function() {
          return h2.delay(this._worker.resume, [], this._worker), this;
        }, pause: function() {
          return this._worker.pause(), this;
        }, toNodejsStream: function(e3) {
          if (h2.checkSupport("nodestream"), "nodebuffer" !== this._outputType)
            throw new Error(this._outputType + " is not supported by this method");
          return new o2(this, { objectMode: "nodebuffer" !== this._outputType }, e3);
        } }, t2.exports = f2;
      }, { "../base64": 1, "../external": 6, "../nodejs/NodejsStreamOutputAdapter": 13, "../support": 30, "../utils": 32, "./ConvertWorker": 24, "./GenericWorker": 28 }], 30: [function(e2, t2, r2) {
        "use strict";
        if (r2.base64 = true, r2.array = true, r2.string = true, r2.arraybuffer = "undefined" != typeof ArrayBuffer && "undefined" != typeof Uint8Array, r2.nodebuffer = "undefined" != typeof Buffer, r2.uint8array = "undefined" != typeof Uint8Array, "undefined" == typeof ArrayBuffer)
          r2.blob = false;
        else {
          var n2 = new ArrayBuffer(0);
          try {
            r2.blob = 0 === new Blob([n2], { type: "application/zip" }).size;
          } catch (e3) {
            try {
              var i2 = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
              i2.append(n2), r2.blob = 0 === i2.getBlob("application/zip").size;
            } catch (e4) {
              r2.blob = false;
            }
          }
        }
        try {
          r2.nodestream = !!e2("readable-stream").Readable;
        } catch (e3) {
          r2.nodestream = false;
        }
      }, { "readable-stream": 16 }], 31: [function(e2, t2, s2) {
        "use strict";
        for (var o2 = e2("./utils"), h2 = e2("./support"), r2 = e2("./nodejsUtils"), n2 = e2("./stream/GenericWorker"), u2 = new Array(256), i2 = 0; i2 < 256; i2++)
          u2[i2] = 252 <= i2 ? 6 : 248 <= i2 ? 5 : 240 <= i2 ? 4 : 224 <= i2 ? 3 : 192 <= i2 ? 2 : 1;
        u2[254] = u2[254] = 1;
        function a2() {
          n2.call(this, "utf-8 decode"), this.leftOver = null;
        }
        function l2() {
          n2.call(this, "utf-8 encode");
        }
        s2.utf8encode = function(e3) {
          return h2.nodebuffer ? r2.newBufferFrom(e3, "utf-8") : function(e4) {
            var t3, r3, n3, i3, s3, a3 = e4.length, o3 = 0;
            for (i3 = 0; i3 < a3; i3++)
              55296 == (64512 & (r3 = e4.charCodeAt(i3))) && i3 + 1 < a3 && 56320 == (64512 & (n3 = e4.charCodeAt(i3 + 1))) && (r3 = 65536 + (r3 - 55296 << 10) + (n3 - 56320), i3++), o3 += r3 < 128 ? 1 : r3 < 2048 ? 2 : r3 < 65536 ? 3 : 4;
            for (t3 = h2.uint8array ? new Uint8Array(o3) : new Array(o3), i3 = s3 = 0; s3 < o3; i3++)
              55296 == (64512 & (r3 = e4.charCodeAt(i3))) && i3 + 1 < a3 && 56320 == (64512 & (n3 = e4.charCodeAt(i3 + 1))) && (r3 = 65536 + (r3 - 55296 << 10) + (n3 - 56320), i3++), r3 < 128 ? t3[s3++] = r3 : (r3 < 2048 ? t3[s3++] = 192 | r3 >>> 6 : (r3 < 65536 ? t3[s3++] = 224 | r3 >>> 12 : (t3[s3++] = 240 | r3 >>> 18, t3[s3++] = 128 | r3 >>> 12 & 63), t3[s3++] = 128 | r3 >>> 6 & 63), t3[s3++] = 128 | 63 & r3);
            return t3;
          }(e3);
        }, s2.utf8decode = function(e3) {
          return h2.nodebuffer ? o2.transformTo("nodebuffer", e3).toString("utf-8") : function(e4) {
            var t3, r3, n3, i3, s3 = e4.length, a3 = new Array(2 * s3);
            for (t3 = r3 = 0; t3 < s3; )
              if ((n3 = e4[t3++]) < 128)
                a3[r3++] = n3;
              else if (4 < (i3 = u2[n3]))
                a3[r3++] = 65533, t3 += i3 - 1;
              else {
                for (n3 &= 2 === i3 ? 31 : 3 === i3 ? 15 : 7; 1 < i3 && t3 < s3; )
                  n3 = n3 << 6 | 63 & e4[t3++], i3--;
                1 < i3 ? a3[r3++] = 65533 : n3 < 65536 ? a3[r3++] = n3 : (n3 -= 65536, a3[r3++] = 55296 | n3 >> 10 & 1023, a3[r3++] = 56320 | 1023 & n3);
              }
            return a3.length !== r3 && (a3.subarray ? a3 = a3.subarray(0, r3) : a3.length = r3), o2.applyFromCharCode(a3);
          }(e3 = o2.transformTo(h2.uint8array ? "uint8array" : "array", e3));
        }, o2.inherits(a2, n2), a2.prototype.processChunk = function(e3) {
          var t3 = o2.transformTo(h2.uint8array ? "uint8array" : "array", e3.data);
          if (this.leftOver && this.leftOver.length) {
            if (h2.uint8array) {
              var r3 = t3;
              (t3 = new Uint8Array(r3.length + this.leftOver.length)).set(this.leftOver, 0), t3.set(r3, this.leftOver.length);
            } else
              t3 = this.leftOver.concat(t3);
            this.leftOver = null;
          }
          var n3 = function(e4, t4) {
            var r4;
            for ((t4 = t4 || e4.length) > e4.length && (t4 = e4.length), r4 = t4 - 1; 0 <= r4 && 128 == (192 & e4[r4]); )
              r4--;
            return r4 < 0 ? t4 : 0 === r4 ? t4 : r4 + u2[e4[r4]] > t4 ? r4 : t4;
          }(t3), i3 = t3;
          n3 !== t3.length && (h2.uint8array ? (i3 = t3.subarray(0, n3), this.leftOver = t3.subarray(n3, t3.length)) : (i3 = t3.slice(0, n3), this.leftOver = t3.slice(n3, t3.length))), this.push({ data: s2.utf8decode(i3), meta: e3.meta });
        }, a2.prototype.flush = function() {
          this.leftOver && this.leftOver.length && (this.push({ data: s2.utf8decode(this.leftOver), meta: {} }), this.leftOver = null);
        }, s2.Utf8DecodeWorker = a2, o2.inherits(l2, n2), l2.prototype.processChunk = function(e3) {
          this.push({ data: s2.utf8encode(e3.data), meta: e3.meta });
        }, s2.Utf8EncodeWorker = l2;
      }, { "./nodejsUtils": 14, "./stream/GenericWorker": 28, "./support": 30, "./utils": 32 }], 32: [function(e2, t2, a2) {
        "use strict";
        var o2 = e2("./support"), h2 = e2("./base64"), r2 = e2("./nodejsUtils"), u2 = e2("./external");
        function n2(e3) {
          return e3;
        }
        function l2(e3, t3) {
          for (var r3 = 0; r3 < e3.length; ++r3)
            t3[r3] = 255 & e3.charCodeAt(r3);
          return t3;
        }
        e2("setimmediate"), a2.newBlob = function(t3, r3) {
          a2.checkSupport("blob");
          try {
            return new Blob([t3], { type: r3 });
          } catch (e3) {
            try {
              var n3 = new (self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder)();
              return n3.append(t3), n3.getBlob(r3);
            } catch (e4) {
              throw new Error("Bug : can't construct the Blob.");
            }
          }
        };
        var i2 = { stringifyByChunk: function(e3, t3, r3) {
          var n3 = [], i3 = 0, s3 = e3.length;
          if (s3 <= r3)
            return String.fromCharCode.apply(null, e3);
          for (; i3 < s3; )
            "array" === t3 || "nodebuffer" === t3 ? n3.push(String.fromCharCode.apply(null, e3.slice(i3, Math.min(i3 + r3, s3)))) : n3.push(String.fromCharCode.apply(null, e3.subarray(i3, Math.min(i3 + r3, s3)))), i3 += r3;
          return n3.join("");
        }, stringifyByChar: function(e3) {
          for (var t3 = "", r3 = 0; r3 < e3.length; r3++)
            t3 += String.fromCharCode(e3[r3]);
          return t3;
        }, applyCanBeUsed: { uint8array: function() {
          try {
            return o2.uint8array && 1 === String.fromCharCode.apply(null, new Uint8Array(1)).length;
          } catch (e3) {
            return false;
          }
        }(), nodebuffer: function() {
          try {
            return o2.nodebuffer && 1 === String.fromCharCode.apply(null, r2.allocBuffer(1)).length;
          } catch (e3) {
            return false;
          }
        }() } };
        function s2(e3) {
          var t3 = 65536, r3 = a2.getTypeOf(e3), n3 = true;
          if ("uint8array" === r3 ? n3 = i2.applyCanBeUsed.uint8array : "nodebuffer" === r3 && (n3 = i2.applyCanBeUsed.nodebuffer), n3)
            for (; 1 < t3; )
              try {
                return i2.stringifyByChunk(e3, r3, t3);
              } catch (e4) {
                t3 = Math.floor(t3 / 2);
              }
          return i2.stringifyByChar(e3);
        }
        function f2(e3, t3) {
          for (var r3 = 0; r3 < e3.length; r3++)
            t3[r3] = e3[r3];
          return t3;
        }
        a2.applyFromCharCode = s2;
        var c2 = {};
        c2.string = { string: n2, array: function(e3) {
          return l2(e3, new Array(e3.length));
        }, arraybuffer: function(e3) {
          return c2.string.uint8array(e3).buffer;
        }, uint8array: function(e3) {
          return l2(e3, new Uint8Array(e3.length));
        }, nodebuffer: function(e3) {
          return l2(e3, r2.allocBuffer(e3.length));
        } }, c2.array = { string: s2, array: n2, arraybuffer: function(e3) {
          return new Uint8Array(e3).buffer;
        }, uint8array: function(e3) {
          return new Uint8Array(e3);
        }, nodebuffer: function(e3) {
          return r2.newBufferFrom(e3);
        } }, c2.arraybuffer = { string: function(e3) {
          return s2(new Uint8Array(e3));
        }, array: function(e3) {
          return f2(new Uint8Array(e3), new Array(e3.byteLength));
        }, arraybuffer: n2, uint8array: function(e3) {
          return new Uint8Array(e3);
        }, nodebuffer: function(e3) {
          return r2.newBufferFrom(new Uint8Array(e3));
        } }, c2.uint8array = { string: s2, array: function(e3) {
          return f2(e3, new Array(e3.length));
        }, arraybuffer: function(e3) {
          return e3.buffer;
        }, uint8array: n2, nodebuffer: function(e3) {
          return r2.newBufferFrom(e3);
        } }, c2.nodebuffer = { string: s2, array: function(e3) {
          return f2(e3, new Array(e3.length));
        }, arraybuffer: function(e3) {
          return c2.nodebuffer.uint8array(e3).buffer;
        }, uint8array: function(e3) {
          return f2(e3, new Uint8Array(e3.length));
        }, nodebuffer: n2 }, a2.transformTo = function(e3, t3) {
          if (t3 = t3 || "", !e3)
            return t3;
          a2.checkSupport(e3);
          var r3 = a2.getTypeOf(t3);
          return c2[r3][e3](t3);
        }, a2.resolve = function(e3) {
          for (var t3 = e3.split("/"), r3 = [], n3 = 0; n3 < t3.length; n3++) {
            var i3 = t3[n3];
            "." === i3 || "" === i3 && 0 !== n3 && n3 !== t3.length - 1 || (".." === i3 ? r3.pop() : r3.push(i3));
          }
          return r3.join("/");
        }, a2.getTypeOf = function(e3) {
          return "string" == typeof e3 ? "string" : "[object Array]" === Object.prototype.toString.call(e3) ? "array" : o2.nodebuffer && r2.isBuffer(e3) ? "nodebuffer" : o2.uint8array && e3 instanceof Uint8Array ? "uint8array" : o2.arraybuffer && e3 instanceof ArrayBuffer ? "arraybuffer" : void 0;
        }, a2.checkSupport = function(e3) {
          if (!o2[e3.toLowerCase()])
            throw new Error(e3 + " is not supported by this platform");
        }, a2.MAX_VALUE_16BITS = 65535, a2.MAX_VALUE_32BITS = -1, a2.pretty = function(e3) {
          var t3, r3, n3 = "";
          for (r3 = 0; r3 < (e3 || "").length; r3++)
            n3 += "\\x" + ((t3 = e3.charCodeAt(r3)) < 16 ? "0" : "") + t3.toString(16).toUpperCase();
          return n3;
        }, a2.delay = function(e3, t3, r3) {
          setImmediate(function() {
            e3.apply(r3 || null, t3 || []);
          });
        }, a2.inherits = function(e3, t3) {
          function r3() {
          }
          r3.prototype = t3.prototype, e3.prototype = new r3();
        }, a2.extend = function() {
          var e3, t3, r3 = {};
          for (e3 = 0; e3 < arguments.length; e3++)
            for (t3 in arguments[e3])
              Object.prototype.hasOwnProperty.call(arguments[e3], t3) && void 0 === r3[t3] && (r3[t3] = arguments[e3][t3]);
          return r3;
        }, a2.prepareContent = function(r3, e3, n3, i3, s3) {
          return u2.Promise.resolve(e3).then(function(n4) {
            return o2.blob && (n4 instanceof Blob || -1 !== ["[object File]", "[object Blob]"].indexOf(Object.prototype.toString.call(n4))) && "undefined" != typeof FileReader ? new u2.Promise(function(t3, r4) {
              var e4 = new FileReader();
              e4.onload = function(e5) {
                t3(e5.target.result);
              }, e4.onerror = function(e5) {
                r4(e5.target.error);
              }, e4.readAsArrayBuffer(n4);
            }) : n4;
          }).then(function(e4) {
            var t3 = a2.getTypeOf(e4);
            return t3 ? ("arraybuffer" === t3 ? e4 = a2.transformTo("uint8array", e4) : "string" === t3 && (s3 ? e4 = h2.decode(e4) : n3 && true !== i3 && (e4 = function(e5) {
              return l2(e5, o2.uint8array ? new Uint8Array(e5.length) : new Array(e5.length));
            }(e4))), e4) : u2.Promise.reject(new Error("Can't read the data of '" + r3 + "'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"));
          });
        };
      }, { "./base64": 1, "./external": 6, "./nodejsUtils": 14, "./support": 30, setimmediate: 54 }], 33: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./reader/readerFor"), i2 = e2("./utils"), s2 = e2("./signature"), a2 = e2("./zipEntry"), o2 = e2("./support");
        function h2(e3) {
          this.files = [], this.loadOptions = e3;
        }
        h2.prototype = { checkSignature: function(e3) {
          if (!this.reader.readAndCheckSignature(e3)) {
            this.reader.index -= 4;
            var t3 = this.reader.readString(4);
            throw new Error("Corrupted zip or bug: unexpected signature (" + i2.pretty(t3) + ", expected " + i2.pretty(e3) + ")");
          }
        }, isSignature: function(e3, t3) {
          var r3 = this.reader.index;
          this.reader.setIndex(e3);
          var n3 = this.reader.readString(4) === t3;
          return this.reader.setIndex(r3), n3;
        }, readBlockEndOfCentral: function() {
          this.diskNumber = this.reader.readInt(2), this.diskWithCentralDirStart = this.reader.readInt(2), this.centralDirRecordsOnThisDisk = this.reader.readInt(2), this.centralDirRecords = this.reader.readInt(2), this.centralDirSize = this.reader.readInt(4), this.centralDirOffset = this.reader.readInt(4), this.zipCommentLength = this.reader.readInt(2);
          var e3 = this.reader.readData(this.zipCommentLength), t3 = o2.uint8array ? "uint8array" : "array", r3 = i2.transformTo(t3, e3);
          this.zipComment = this.loadOptions.decodeFileName(r3);
        }, readBlockZip64EndOfCentral: function() {
          this.zip64EndOfCentralSize = this.reader.readInt(8), this.reader.skip(4), this.diskNumber = this.reader.readInt(4), this.diskWithCentralDirStart = this.reader.readInt(4), this.centralDirRecordsOnThisDisk = this.reader.readInt(8), this.centralDirRecords = this.reader.readInt(8), this.centralDirSize = this.reader.readInt(8), this.centralDirOffset = this.reader.readInt(8), this.zip64ExtensibleData = {};
          for (var e3, t3, r3, n3 = this.zip64EndOfCentralSize - 44; 0 < n3; )
            e3 = this.reader.readInt(2), t3 = this.reader.readInt(4), r3 = this.reader.readData(t3), this.zip64ExtensibleData[e3] = { id: e3, length: t3, value: r3 };
        }, readBlockZip64EndOfCentralLocator: function() {
          if (this.diskWithZip64CentralDirStart = this.reader.readInt(4), this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8), this.disksCount = this.reader.readInt(4), 1 < this.disksCount)
            throw new Error("Multi-volumes zip are not supported");
        }, readLocalFiles: function() {
          var e3, t3;
          for (e3 = 0; e3 < this.files.length; e3++)
            t3 = this.files[e3], this.reader.setIndex(t3.localHeaderOffset), this.checkSignature(s2.LOCAL_FILE_HEADER), t3.readLocalPart(this.reader), t3.handleUTF8(), t3.processAttributes();
        }, readCentralDir: function() {
          var e3;
          for (this.reader.setIndex(this.centralDirOffset); this.reader.readAndCheckSignature(s2.CENTRAL_FILE_HEADER); )
            (e3 = new a2({ zip64: this.zip64 }, this.loadOptions)).readCentralPart(this.reader), this.files.push(e3);
          if (this.centralDirRecords !== this.files.length && 0 !== this.centralDirRecords && 0 === this.files.length)
            throw new Error("Corrupted zip or bug: expected " + this.centralDirRecords + " records in central dir, got " + this.files.length);
        }, readEndOfCentral: function() {
          var e3 = this.reader.lastIndexOfSignature(s2.CENTRAL_DIRECTORY_END);
          if (e3 < 0)
            throw !this.isSignature(0, s2.LOCAL_FILE_HEADER) ? new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html") : new Error("Corrupted zip: can't find end of central directory");
          this.reader.setIndex(e3);
          var t3 = e3;
          if (this.checkSignature(s2.CENTRAL_DIRECTORY_END), this.readBlockEndOfCentral(), this.diskNumber === i2.MAX_VALUE_16BITS || this.diskWithCentralDirStart === i2.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === i2.MAX_VALUE_16BITS || this.centralDirRecords === i2.MAX_VALUE_16BITS || this.centralDirSize === i2.MAX_VALUE_32BITS || this.centralDirOffset === i2.MAX_VALUE_32BITS) {
            if (this.zip64 = true, (e3 = this.reader.lastIndexOfSignature(s2.ZIP64_CENTRAL_DIRECTORY_LOCATOR)) < 0)
              throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");
            if (this.reader.setIndex(e3), this.checkSignature(s2.ZIP64_CENTRAL_DIRECTORY_LOCATOR), this.readBlockZip64EndOfCentralLocator(), !this.isSignature(this.relativeOffsetEndOfZip64CentralDir, s2.ZIP64_CENTRAL_DIRECTORY_END) && (this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(s2.ZIP64_CENTRAL_DIRECTORY_END), this.relativeOffsetEndOfZip64CentralDir < 0))
              throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");
            this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir), this.checkSignature(s2.ZIP64_CENTRAL_DIRECTORY_END), this.readBlockZip64EndOfCentral();
          }
          var r3 = this.centralDirOffset + this.centralDirSize;
          this.zip64 && (r3 += 20, r3 += 12 + this.zip64EndOfCentralSize);
          var n3 = t3 - r3;
          if (0 < n3)
            this.isSignature(t3, s2.CENTRAL_FILE_HEADER) || (this.reader.zero = n3);
          else if (n3 < 0)
            throw new Error("Corrupted zip: missing " + Math.abs(n3) + " bytes.");
        }, prepareReader: function(e3) {
          this.reader = n2(e3);
        }, load: function(e3) {
          this.prepareReader(e3), this.readEndOfCentral(), this.readCentralDir(), this.readLocalFiles();
        } }, t2.exports = h2;
      }, { "./reader/readerFor": 22, "./signature": 23, "./support": 30, "./utils": 32, "./zipEntry": 34 }], 34: [function(e2, t2, r2) {
        "use strict";
        var n2 = e2("./reader/readerFor"), s2 = e2("./utils"), i2 = e2("./compressedObject"), a2 = e2("./crc32"), o2 = e2("./utf8"), h2 = e2("./compressions"), u2 = e2("./support");
        function l2(e3, t3) {
          this.options = e3, this.loadOptions = t3;
        }
        l2.prototype = { isEncrypted: function() {
          return 1 == (1 & this.bitFlag);
        }, useUTF8: function() {
          return 2048 == (2048 & this.bitFlag);
        }, readLocalPart: function(e3) {
          var t3, r3;
          if (e3.skip(22), this.fileNameLength = e3.readInt(2), r3 = e3.readInt(2), this.fileName = e3.readData(this.fileNameLength), e3.skip(r3), -1 === this.compressedSize || -1 === this.uncompressedSize)
            throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");
          if (null === (t3 = function(e4) {
            for (var t4 in h2)
              if (Object.prototype.hasOwnProperty.call(h2, t4) && h2[t4].magic === e4)
                return h2[t4];
            return null;
          }(this.compressionMethod)))
            throw new Error("Corrupted zip : compression " + s2.pretty(this.compressionMethod) + " unknown (inner file : " + s2.transformTo("string", this.fileName) + ")");
          this.decompressed = new i2(this.compressedSize, this.uncompressedSize, this.crc32, t3, e3.readData(this.compressedSize));
        }, readCentralPart: function(e3) {
          this.versionMadeBy = e3.readInt(2), e3.skip(2), this.bitFlag = e3.readInt(2), this.compressionMethod = e3.readString(2), this.date = e3.readDate(), this.crc32 = e3.readInt(4), this.compressedSize = e3.readInt(4), this.uncompressedSize = e3.readInt(4);
          var t3 = e3.readInt(2);
          if (this.extraFieldsLength = e3.readInt(2), this.fileCommentLength = e3.readInt(2), this.diskNumberStart = e3.readInt(2), this.internalFileAttributes = e3.readInt(2), this.externalFileAttributes = e3.readInt(4), this.localHeaderOffset = e3.readInt(4), this.isEncrypted())
            throw new Error("Encrypted zip are not supported");
          e3.skip(t3), this.readExtraFields(e3), this.parseZIP64ExtraField(e3), this.fileComment = e3.readData(this.fileCommentLength);
        }, processAttributes: function() {
          this.unixPermissions = null, this.dosPermissions = null;
          var e3 = this.versionMadeBy >> 8;
          this.dir = !!(16 & this.externalFileAttributes), 0 == e3 && (this.dosPermissions = 63 & this.externalFileAttributes), 3 == e3 && (this.unixPermissions = this.externalFileAttributes >> 16 & 65535), this.dir || "/" !== this.fileNameStr.slice(-1) || (this.dir = true);
        }, parseZIP64ExtraField: function() {
          if (this.extraFields[1]) {
            var e3 = n2(this.extraFields[1].value);
            this.uncompressedSize === s2.MAX_VALUE_32BITS && (this.uncompressedSize = e3.readInt(8)), this.compressedSize === s2.MAX_VALUE_32BITS && (this.compressedSize = e3.readInt(8)), this.localHeaderOffset === s2.MAX_VALUE_32BITS && (this.localHeaderOffset = e3.readInt(8)), this.diskNumberStart === s2.MAX_VALUE_32BITS && (this.diskNumberStart = e3.readInt(4));
          }
        }, readExtraFields: function(e3) {
          var t3, r3, n3, i3 = e3.index + this.extraFieldsLength;
          for (this.extraFields || (this.extraFields = {}); e3.index + 4 < i3; )
            t3 = e3.readInt(2), r3 = e3.readInt(2), n3 = e3.readData(r3), this.extraFields[t3] = { id: t3, length: r3, value: n3 };
          e3.setIndex(i3);
        }, handleUTF8: function() {
          var e3 = u2.uint8array ? "uint8array" : "array";
          if (this.useUTF8())
            this.fileNameStr = o2.utf8decode(this.fileName), this.fileCommentStr = o2.utf8decode(this.fileComment);
          else {
            var t3 = this.findExtraFieldUnicodePath();
            if (null !== t3)
              this.fileNameStr = t3;
            else {
              var r3 = s2.transformTo(e3, this.fileName);
              this.fileNameStr = this.loadOptions.decodeFileName(r3);
            }
            var n3 = this.findExtraFieldUnicodeComment();
            if (null !== n3)
              this.fileCommentStr = n3;
            else {
              var i3 = s2.transformTo(e3, this.fileComment);
              this.fileCommentStr = this.loadOptions.decodeFileName(i3);
            }
          }
        }, findExtraFieldUnicodePath: function() {
          var e3 = this.extraFields[28789];
          if (e3) {
            var t3 = n2(e3.value);
            return 1 !== t3.readInt(1) ? null : a2(this.fileName) !== t3.readInt(4) ? null : o2.utf8decode(t3.readData(e3.length - 5));
          }
          return null;
        }, findExtraFieldUnicodeComment: function() {
          var e3 = this.extraFields[25461];
          if (e3) {
            var t3 = n2(e3.value);
            return 1 !== t3.readInt(1) ? null : a2(this.fileComment) !== t3.readInt(4) ? null : o2.utf8decode(t3.readData(e3.length - 5));
          }
          return null;
        } }, t2.exports = l2;
      }, { "./compressedObject": 2, "./compressions": 3, "./crc32": 4, "./reader/readerFor": 22, "./support": 30, "./utf8": 31, "./utils": 32 }], 35: [function(e2, t2, r2) {
        "use strict";
        function n2(e3, t3, r3) {
          this.name = e3, this.dir = r3.dir, this.date = r3.date, this.comment = r3.comment, this.unixPermissions = r3.unixPermissions, this.dosPermissions = r3.dosPermissions, this._data = t3, this._dataBinary = r3.binary, this.options = { compression: r3.compression, compressionOptions: r3.compressionOptions };
        }
        var s2 = e2("./stream/StreamHelper"), i2 = e2("./stream/DataWorker"), a2 = e2("./utf8"), o2 = e2("./compressedObject"), h2 = e2("./stream/GenericWorker");
        n2.prototype = { internalStream: function(e3) {
          var t3 = null, r3 = "string";
          try {
            if (!e3)
              throw new Error("No output type specified.");
            var n3 = "string" === (r3 = e3.toLowerCase()) || "text" === r3;
            "binarystring" !== r3 && "text" !== r3 || (r3 = "string"), t3 = this._decompressWorker();
            var i3 = !this._dataBinary;
            i3 && !n3 && (t3 = t3.pipe(new a2.Utf8EncodeWorker())), !i3 && n3 && (t3 = t3.pipe(new a2.Utf8DecodeWorker()));
          } catch (e4) {
            (t3 = new h2("error")).error(e4);
          }
          return new s2(t3, r3, "");
        }, async: function(e3, t3) {
          return this.internalStream(e3).accumulate(t3);
        }, nodeStream: function(e3, t3) {
          return this.internalStream(e3 || "nodebuffer").toNodejsStream(t3);
        }, _compressWorker: function(e3, t3) {
          if (this._data instanceof o2 && this._data.compression.magic === e3.magic)
            return this._data.getCompressedWorker();
          var r3 = this._decompressWorker();
          return this._dataBinary || (r3 = r3.pipe(new a2.Utf8EncodeWorker())), o2.createWorkerFrom(r3, e3, t3);
        }, _decompressWorker: function() {
          return this._data instanceof o2 ? this._data.getContentWorker() : this._data instanceof h2 ? this._data : new i2(this._data);
        } };
        for (var u2 = ["asText", "asBinary", "asNodeBuffer", "asUint8Array", "asArrayBuffer"], l2 = function() {
          throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");
        }, f2 = 0; f2 < u2.length; f2++)
          n2.prototype[u2[f2]] = l2;
        t2.exports = n2;
      }, { "./compressedObject": 2, "./stream/DataWorker": 27, "./stream/GenericWorker": 28, "./stream/StreamHelper": 29, "./utf8": 31 }], 36: [function(e2, l2, t2) {
        (function(t3) {
          "use strict";
          var r2, n2, e3 = t3.MutationObserver || t3.WebKitMutationObserver;
          if (e3) {
            var i2 = 0, s2 = new e3(u2), a2 = t3.document.createTextNode("");
            s2.observe(a2, { characterData: true }), r2 = function() {
              a2.data = i2 = ++i2 % 2;
            };
          } else if (t3.setImmediate || void 0 === t3.MessageChannel)
            r2 = "document" in t3 && "onreadystatechange" in t3.document.createElement("script") ? function() {
              var e4 = t3.document.createElement("script");
              e4.onreadystatechange = function() {
                u2(), e4.onreadystatechange = null, e4.parentNode.removeChild(e4), e4 = null;
              }, t3.document.documentElement.appendChild(e4);
            } : function() {
              setTimeout(u2, 0);
            };
          else {
            var o2 = new t3.MessageChannel();
            o2.port1.onmessage = u2, r2 = function() {
              o2.port2.postMessage(0);
            };
          }
          var h2 = [];
          function u2() {
            var e4, t4;
            n2 = true;
            for (var r3 = h2.length; r3; ) {
              for (t4 = h2, h2 = [], e4 = -1; ++e4 < r3; )
                t4[e4]();
              r3 = h2.length;
            }
            n2 = false;
          }
          l2.exports = function(e4) {
            1 !== h2.push(e4) || n2 || r2();
          };
        }).call(this, "undefined" != typeof commonjsGlobal ? commonjsGlobal : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
      }, {}], 37: [function(e2, t2, r2) {
        "use strict";
        var i2 = e2("immediate");
        function u2() {
        }
        var l2 = {}, s2 = ["REJECTED"], a2 = ["FULFILLED"], n2 = ["PENDING"];
        function o2(e3) {
          if ("function" != typeof e3)
            throw new TypeError("resolver must be a function");
          this.state = n2, this.queue = [], this.outcome = void 0, e3 !== u2 && d2(this, e3);
        }
        function h2(e3, t3, r3) {
          this.promise = e3, "function" == typeof t3 && (this.onFulfilled = t3, this.callFulfilled = this.otherCallFulfilled), "function" == typeof r3 && (this.onRejected = r3, this.callRejected = this.otherCallRejected);
        }
        function f2(t3, r3, n3) {
          i2(function() {
            var e3;
            try {
              e3 = r3(n3);
            } catch (e4) {
              return l2.reject(t3, e4);
            }
            e3 === t3 ? l2.reject(t3, new TypeError("Cannot resolve promise with itself")) : l2.resolve(t3, e3);
          });
        }
        function c2(e3) {
          var t3 = e3 && e3.then;
          if (e3 && ("object" == typeof e3 || "function" == typeof e3) && "function" == typeof t3)
            return function() {
              t3.apply(e3, arguments);
            };
        }
        function d2(t3, e3) {
          var r3 = false;
          function n3(e4) {
            r3 || (r3 = true, l2.reject(t3, e4));
          }
          function i3(e4) {
            r3 || (r3 = true, l2.resolve(t3, e4));
          }
          var s3 = p2(function() {
            e3(i3, n3);
          });
          "error" === s3.status && n3(s3.value);
        }
        function p2(e3, t3) {
          var r3 = {};
          try {
            r3.value = e3(t3), r3.status = "success";
          } catch (e4) {
            r3.status = "error", r3.value = e4;
          }
          return r3;
        }
        (t2.exports = o2).prototype.finally = function(t3) {
          if ("function" != typeof t3)
            return this;
          var r3 = this.constructor;
          return this.then(function(e3) {
            return r3.resolve(t3()).then(function() {
              return e3;
            });
          }, function(e3) {
            return r3.resolve(t3()).then(function() {
              throw e3;
            });
          });
        }, o2.prototype.catch = function(e3) {
          return this.then(null, e3);
        }, o2.prototype.then = function(e3, t3) {
          if ("function" != typeof e3 && this.state === a2 || "function" != typeof t3 && this.state === s2)
            return this;
          var r3 = new this.constructor(u2);
          this.state !== n2 ? f2(r3, this.state === a2 ? e3 : t3, this.outcome) : this.queue.push(new h2(r3, e3, t3));
          return r3;
        }, h2.prototype.callFulfilled = function(e3) {
          l2.resolve(this.promise, e3);
        }, h2.prototype.otherCallFulfilled = function(e3) {
          f2(this.promise, this.onFulfilled, e3);
        }, h2.prototype.callRejected = function(e3) {
          l2.reject(this.promise, e3);
        }, h2.prototype.otherCallRejected = function(e3) {
          f2(this.promise, this.onRejected, e3);
        }, l2.resolve = function(e3, t3) {
          var r3 = p2(c2, t3);
          if ("error" === r3.status)
            return l2.reject(e3, r3.value);
          var n3 = r3.value;
          if (n3)
            d2(e3, n3);
          else {
            e3.state = a2, e3.outcome = t3;
            for (var i3 = -1, s3 = e3.queue.length; ++i3 < s3; )
              e3.queue[i3].callFulfilled(t3);
          }
          return e3;
        }, l2.reject = function(e3, t3) {
          e3.state = s2, e3.outcome = t3;
          for (var r3 = -1, n3 = e3.queue.length; ++r3 < n3; )
            e3.queue[r3].callRejected(t3);
          return e3;
        }, o2.resolve = function(e3) {
          if (e3 instanceof this)
            return e3;
          return l2.resolve(new this(u2), e3);
        }, o2.reject = function(e3) {
          var t3 = new this(u2);
          return l2.reject(t3, e3);
        }, o2.all = function(e3) {
          var r3 = this;
          if ("[object Array]" !== Object.prototype.toString.call(e3))
            return this.reject(new TypeError("must be an array"));
          var n3 = e3.length, i3 = false;
          if (!n3)
            return this.resolve([]);
          var s3 = new Array(n3), a3 = 0, t3 = -1, o3 = new this(u2);
          for (; ++t3 < n3; )
            h3(e3[t3], t3);
          return o3;
          function h3(e4, t4) {
            r3.resolve(e4).then(function(e5) {
              s3[t4] = e5, ++a3 !== n3 || i3 || (i3 = true, l2.resolve(o3, s3));
            }, function(e5) {
              i3 || (i3 = true, l2.reject(o3, e5));
            });
          }
        }, o2.race = function(e3) {
          var t3 = this;
          if ("[object Array]" !== Object.prototype.toString.call(e3))
            return this.reject(new TypeError("must be an array"));
          var r3 = e3.length, n3 = false;
          if (!r3)
            return this.resolve([]);
          var i3 = -1, s3 = new this(u2);
          for (; ++i3 < r3; )
            a3 = e3[i3], t3.resolve(a3).then(function(e4) {
              n3 || (n3 = true, l2.resolve(s3, e4));
            }, function(e4) {
              n3 || (n3 = true, l2.reject(s3, e4));
            });
          var a3;
          return s3;
        };
      }, { immediate: 36 }], 38: [function(e2, t2, r2) {
        "use strict";
        var n2 = {};
        (0, e2("./lib/utils/common").assign)(n2, e2("./lib/deflate"), e2("./lib/inflate"), e2("./lib/zlib/constants")), t2.exports = n2;
      }, { "./lib/deflate": 39, "./lib/inflate": 40, "./lib/utils/common": 41, "./lib/zlib/constants": 44 }], 39: [function(e2, t2, r2) {
        "use strict";
        var a2 = e2("./zlib/deflate"), o2 = e2("./utils/common"), h2 = e2("./utils/strings"), i2 = e2("./zlib/messages"), s2 = e2("./zlib/zstream"), u2 = Object.prototype.toString, l2 = 0, f2 = -1, c2 = 0, d2 = 8;
        function p2(e3) {
          if (!(this instanceof p2))
            return new p2(e3);
          this.options = o2.assign({ level: f2, method: d2, chunkSize: 16384, windowBits: 15, memLevel: 8, strategy: c2, to: "" }, e3 || {});
          var t3 = this.options;
          t3.raw && 0 < t3.windowBits ? t3.windowBits = -t3.windowBits : t3.gzip && 0 < t3.windowBits && t3.windowBits < 16 && (t3.windowBits += 16), this.err = 0, this.msg = "", this.ended = false, this.chunks = [], this.strm = new s2(), this.strm.avail_out = 0;
          var r3 = a2.deflateInit2(this.strm, t3.level, t3.method, t3.windowBits, t3.memLevel, t3.strategy);
          if (r3 !== l2)
            throw new Error(i2[r3]);
          if (t3.header && a2.deflateSetHeader(this.strm, t3.header), t3.dictionary) {
            var n3;
            if (n3 = "string" == typeof t3.dictionary ? h2.string2buf(t3.dictionary) : "[object ArrayBuffer]" === u2.call(t3.dictionary) ? new Uint8Array(t3.dictionary) : t3.dictionary, (r3 = a2.deflateSetDictionary(this.strm, n3)) !== l2)
              throw new Error(i2[r3]);
            this._dict_set = true;
          }
        }
        function n2(e3, t3) {
          var r3 = new p2(t3);
          if (r3.push(e3, true), r3.err)
            throw r3.msg || i2[r3.err];
          return r3.result;
        }
        p2.prototype.push = function(e3, t3) {
          var r3, n3, i3 = this.strm, s3 = this.options.chunkSize;
          if (this.ended)
            return false;
          n3 = t3 === ~~t3 ? t3 : true === t3 ? 4 : 0, "string" == typeof e3 ? i3.input = h2.string2buf(e3) : "[object ArrayBuffer]" === u2.call(e3) ? i3.input = new Uint8Array(e3) : i3.input = e3, i3.next_in = 0, i3.avail_in = i3.input.length;
          do {
            if (0 === i3.avail_out && (i3.output = new o2.Buf8(s3), i3.next_out = 0, i3.avail_out = s3), 1 !== (r3 = a2.deflate(i3, n3)) && r3 !== l2)
              return this.onEnd(r3), !(this.ended = true);
            0 !== i3.avail_out && (0 !== i3.avail_in || 4 !== n3 && 2 !== n3) || ("string" === this.options.to ? this.onData(h2.buf2binstring(o2.shrinkBuf(i3.output, i3.next_out))) : this.onData(o2.shrinkBuf(i3.output, i3.next_out)));
          } while ((0 < i3.avail_in || 0 === i3.avail_out) && 1 !== r3);
          return 4 === n3 ? (r3 = a2.deflateEnd(this.strm), this.onEnd(r3), this.ended = true, r3 === l2) : 2 !== n3 || (this.onEnd(l2), !(i3.avail_out = 0));
        }, p2.prototype.onData = function(e3) {
          this.chunks.push(e3);
        }, p2.prototype.onEnd = function(e3) {
          e3 === l2 && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = o2.flattenChunks(this.chunks)), this.chunks = [], this.err = e3, this.msg = this.strm.msg;
        }, r2.Deflate = p2, r2.deflate = n2, r2.deflateRaw = function(e3, t3) {
          return (t3 = t3 || {}).raw = true, n2(e3, t3);
        }, r2.gzip = function(e3, t3) {
          return (t3 = t3 || {}).gzip = true, n2(e3, t3);
        };
      }, { "./utils/common": 41, "./utils/strings": 42, "./zlib/deflate": 46, "./zlib/messages": 51, "./zlib/zstream": 53 }], 40: [function(e2, t2, r2) {
        "use strict";
        var c2 = e2("./zlib/inflate"), d2 = e2("./utils/common"), p2 = e2("./utils/strings"), m = e2("./zlib/constants"), n2 = e2("./zlib/messages"), i2 = e2("./zlib/zstream"), s2 = e2("./zlib/gzheader"), _ = Object.prototype.toString;
        function a2(e3) {
          if (!(this instanceof a2))
            return new a2(e3);
          this.options = d2.assign({ chunkSize: 16384, windowBits: 0, to: "" }, e3 || {});
          var t3 = this.options;
          t3.raw && 0 <= t3.windowBits && t3.windowBits < 16 && (t3.windowBits = -t3.windowBits, 0 === t3.windowBits && (t3.windowBits = -15)), !(0 <= t3.windowBits && t3.windowBits < 16) || e3 && e3.windowBits || (t3.windowBits += 32), 15 < t3.windowBits && t3.windowBits < 48 && 0 == (15 & t3.windowBits) && (t3.windowBits |= 15), this.err = 0, this.msg = "", this.ended = false, this.chunks = [], this.strm = new i2(), this.strm.avail_out = 0;
          var r3 = c2.inflateInit2(this.strm, t3.windowBits);
          if (r3 !== m.Z_OK)
            throw new Error(n2[r3]);
          this.header = new s2(), c2.inflateGetHeader(this.strm, this.header);
        }
        function o2(e3, t3) {
          var r3 = new a2(t3);
          if (r3.push(e3, true), r3.err)
            throw r3.msg || n2[r3.err];
          return r3.result;
        }
        a2.prototype.push = function(e3, t3) {
          var r3, n3, i3, s3, a3, o3, h2 = this.strm, u2 = this.options.chunkSize, l2 = this.options.dictionary, f2 = false;
          if (this.ended)
            return false;
          n3 = t3 === ~~t3 ? t3 : true === t3 ? m.Z_FINISH : m.Z_NO_FLUSH, "string" == typeof e3 ? h2.input = p2.binstring2buf(e3) : "[object ArrayBuffer]" === _.call(e3) ? h2.input = new Uint8Array(e3) : h2.input = e3, h2.next_in = 0, h2.avail_in = h2.input.length;
          do {
            if (0 === h2.avail_out && (h2.output = new d2.Buf8(u2), h2.next_out = 0, h2.avail_out = u2), (r3 = c2.inflate(h2, m.Z_NO_FLUSH)) === m.Z_NEED_DICT && l2 && (o3 = "string" == typeof l2 ? p2.string2buf(l2) : "[object ArrayBuffer]" === _.call(l2) ? new Uint8Array(l2) : l2, r3 = c2.inflateSetDictionary(this.strm, o3)), r3 === m.Z_BUF_ERROR && true === f2 && (r3 = m.Z_OK, f2 = false), r3 !== m.Z_STREAM_END && r3 !== m.Z_OK)
              return this.onEnd(r3), !(this.ended = true);
            h2.next_out && (0 !== h2.avail_out && r3 !== m.Z_STREAM_END && (0 !== h2.avail_in || n3 !== m.Z_FINISH && n3 !== m.Z_SYNC_FLUSH) || ("string" === this.options.to ? (i3 = p2.utf8border(h2.output, h2.next_out), s3 = h2.next_out - i3, a3 = p2.buf2string(h2.output, i3), h2.next_out = s3, h2.avail_out = u2 - s3, s3 && d2.arraySet(h2.output, h2.output, i3, s3, 0), this.onData(a3)) : this.onData(d2.shrinkBuf(h2.output, h2.next_out)))), 0 === h2.avail_in && 0 === h2.avail_out && (f2 = true);
          } while ((0 < h2.avail_in || 0 === h2.avail_out) && r3 !== m.Z_STREAM_END);
          return r3 === m.Z_STREAM_END && (n3 = m.Z_FINISH), n3 === m.Z_FINISH ? (r3 = c2.inflateEnd(this.strm), this.onEnd(r3), this.ended = true, r3 === m.Z_OK) : n3 !== m.Z_SYNC_FLUSH || (this.onEnd(m.Z_OK), !(h2.avail_out = 0));
        }, a2.prototype.onData = function(e3) {
          this.chunks.push(e3);
        }, a2.prototype.onEnd = function(e3) {
          e3 === m.Z_OK && ("string" === this.options.to ? this.result = this.chunks.join("") : this.result = d2.flattenChunks(this.chunks)), this.chunks = [], this.err = e3, this.msg = this.strm.msg;
        }, r2.Inflate = a2, r2.inflate = o2, r2.inflateRaw = function(e3, t3) {
          return (t3 = t3 || {}).raw = true, o2(e3, t3);
        }, r2.ungzip = o2;
      }, { "./utils/common": 41, "./utils/strings": 42, "./zlib/constants": 44, "./zlib/gzheader": 47, "./zlib/inflate": 49, "./zlib/messages": 51, "./zlib/zstream": 53 }], 41: [function(e2, t2, r2) {
        "use strict";
        var n2 = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Int32Array;
        r2.assign = function(e3) {
          for (var t3 = Array.prototype.slice.call(arguments, 1); t3.length; ) {
            var r3 = t3.shift();
            if (r3) {
              if ("object" != typeof r3)
                throw new TypeError(r3 + "must be non-object");
              for (var n3 in r3)
                r3.hasOwnProperty(n3) && (e3[n3] = r3[n3]);
            }
          }
          return e3;
        }, r2.shrinkBuf = function(e3, t3) {
          return e3.length === t3 ? e3 : e3.subarray ? e3.subarray(0, t3) : (e3.length = t3, e3);
        };
        var i2 = { arraySet: function(e3, t3, r3, n3, i3) {
          if (t3.subarray && e3.subarray)
            e3.set(t3.subarray(r3, r3 + n3), i3);
          else
            for (var s3 = 0; s3 < n3; s3++)
              e3[i3 + s3] = t3[r3 + s3];
        }, flattenChunks: function(e3) {
          var t3, r3, n3, i3, s3, a2;
          for (t3 = n3 = 0, r3 = e3.length; t3 < r3; t3++)
            n3 += e3[t3].length;
          for (a2 = new Uint8Array(n3), t3 = i3 = 0, r3 = e3.length; t3 < r3; t3++)
            s3 = e3[t3], a2.set(s3, i3), i3 += s3.length;
          return a2;
        } }, s2 = { arraySet: function(e3, t3, r3, n3, i3) {
          for (var s3 = 0; s3 < n3; s3++)
            e3[i3 + s3] = t3[r3 + s3];
        }, flattenChunks: function(e3) {
          return [].concat.apply([], e3);
        } };
        r2.setTyped = function(e3) {
          e3 ? (r2.Buf8 = Uint8Array, r2.Buf16 = Uint16Array, r2.Buf32 = Int32Array, r2.assign(r2, i2)) : (r2.Buf8 = Array, r2.Buf16 = Array, r2.Buf32 = Array, r2.assign(r2, s2));
        }, r2.setTyped(n2);
      }, {}], 42: [function(e2, t2, r2) {
        "use strict";
        var h2 = e2("./common"), i2 = true, s2 = true;
        try {
          String.fromCharCode.apply(null, [0]);
        } catch (e3) {
          i2 = false;
        }
        try {
          String.fromCharCode.apply(null, new Uint8Array(1));
        } catch (e3) {
          s2 = false;
        }
        for (var u2 = new h2.Buf8(256), n2 = 0; n2 < 256; n2++)
          u2[n2] = 252 <= n2 ? 6 : 248 <= n2 ? 5 : 240 <= n2 ? 4 : 224 <= n2 ? 3 : 192 <= n2 ? 2 : 1;
        function l2(e3, t3) {
          if (t3 < 65537 && (e3.subarray && s2 || !e3.subarray && i2))
            return String.fromCharCode.apply(null, h2.shrinkBuf(e3, t3));
          for (var r3 = "", n3 = 0; n3 < t3; n3++)
            r3 += String.fromCharCode(e3[n3]);
          return r3;
        }
        u2[254] = u2[254] = 1, r2.string2buf = function(e3) {
          var t3, r3, n3, i3, s3, a2 = e3.length, o2 = 0;
          for (i3 = 0; i3 < a2; i3++)
            55296 == (64512 & (r3 = e3.charCodeAt(i3))) && i3 + 1 < a2 && 56320 == (64512 & (n3 = e3.charCodeAt(i3 + 1))) && (r3 = 65536 + (r3 - 55296 << 10) + (n3 - 56320), i3++), o2 += r3 < 128 ? 1 : r3 < 2048 ? 2 : r3 < 65536 ? 3 : 4;
          for (t3 = new h2.Buf8(o2), i3 = s3 = 0; s3 < o2; i3++)
            55296 == (64512 & (r3 = e3.charCodeAt(i3))) && i3 + 1 < a2 && 56320 == (64512 & (n3 = e3.charCodeAt(i3 + 1))) && (r3 = 65536 + (r3 - 55296 << 10) + (n3 - 56320), i3++), r3 < 128 ? t3[s3++] = r3 : (r3 < 2048 ? t3[s3++] = 192 | r3 >>> 6 : (r3 < 65536 ? t3[s3++] = 224 | r3 >>> 12 : (t3[s3++] = 240 | r3 >>> 18, t3[s3++] = 128 | r3 >>> 12 & 63), t3[s3++] = 128 | r3 >>> 6 & 63), t3[s3++] = 128 | 63 & r3);
          return t3;
        }, r2.buf2binstring = function(e3) {
          return l2(e3, e3.length);
        }, r2.binstring2buf = function(e3) {
          for (var t3 = new h2.Buf8(e3.length), r3 = 0, n3 = t3.length; r3 < n3; r3++)
            t3[r3] = e3.charCodeAt(r3);
          return t3;
        }, r2.buf2string = function(e3, t3) {
          var r3, n3, i3, s3, a2 = t3 || e3.length, o2 = new Array(2 * a2);
          for (r3 = n3 = 0; r3 < a2; )
            if ((i3 = e3[r3++]) < 128)
              o2[n3++] = i3;
            else if (4 < (s3 = u2[i3]))
              o2[n3++] = 65533, r3 += s3 - 1;
            else {
              for (i3 &= 2 === s3 ? 31 : 3 === s3 ? 15 : 7; 1 < s3 && r3 < a2; )
                i3 = i3 << 6 | 63 & e3[r3++], s3--;
              1 < s3 ? o2[n3++] = 65533 : i3 < 65536 ? o2[n3++] = i3 : (i3 -= 65536, o2[n3++] = 55296 | i3 >> 10 & 1023, o2[n3++] = 56320 | 1023 & i3);
            }
          return l2(o2, n3);
        }, r2.utf8border = function(e3, t3) {
          var r3;
          for ((t3 = t3 || e3.length) > e3.length && (t3 = e3.length), r3 = t3 - 1; 0 <= r3 && 128 == (192 & e3[r3]); )
            r3--;
          return r3 < 0 ? t3 : 0 === r3 ? t3 : r3 + u2[e3[r3]] > t3 ? r3 : t3;
        };
      }, { "./common": 41 }], 43: [function(e2, t2, r2) {
        "use strict";
        t2.exports = function(e3, t3, r3, n2) {
          for (var i2 = 65535 & e3 | 0, s2 = e3 >>> 16 & 65535 | 0, a2 = 0; 0 !== r3; ) {
            for (r3 -= a2 = 2e3 < r3 ? 2e3 : r3; s2 = s2 + (i2 = i2 + t3[n2++] | 0) | 0, --a2; )
              ;
            i2 %= 65521, s2 %= 65521;
          }
          return i2 | s2 << 16 | 0;
        };
      }, {}], 44: [function(e2, t2, r2) {
        "use strict";
        t2.exports = { Z_NO_FLUSH: 0, Z_PARTIAL_FLUSH: 1, Z_SYNC_FLUSH: 2, Z_FULL_FLUSH: 3, Z_FINISH: 4, Z_BLOCK: 5, Z_TREES: 6, Z_OK: 0, Z_STREAM_END: 1, Z_NEED_DICT: 2, Z_ERRNO: -1, Z_STREAM_ERROR: -2, Z_DATA_ERROR: -3, Z_BUF_ERROR: -5, Z_NO_COMPRESSION: 0, Z_BEST_SPEED: 1, Z_BEST_COMPRESSION: 9, Z_DEFAULT_COMPRESSION: -1, Z_FILTERED: 1, Z_HUFFMAN_ONLY: 2, Z_RLE: 3, Z_FIXED: 4, Z_DEFAULT_STRATEGY: 0, Z_BINARY: 0, Z_TEXT: 1, Z_UNKNOWN: 2, Z_DEFLATED: 8 };
      }, {}], 45: [function(e2, t2, r2) {
        "use strict";
        var o2 = function() {
          for (var e3, t3 = [], r3 = 0; r3 < 256; r3++) {
            e3 = r3;
            for (var n2 = 0; n2 < 8; n2++)
              e3 = 1 & e3 ? 3988292384 ^ e3 >>> 1 : e3 >>> 1;
            t3[r3] = e3;
          }
          return t3;
        }();
        t2.exports = function(e3, t3, r3, n2) {
          var i2 = o2, s2 = n2 + r3;
          e3 ^= -1;
          for (var a2 = n2; a2 < s2; a2++)
            e3 = e3 >>> 8 ^ i2[255 & (e3 ^ t3[a2])];
          return -1 ^ e3;
        };
      }, {}], 46: [function(e2, t2, r2) {
        "use strict";
        var h2, c2 = e2("../utils/common"), u2 = e2("./trees"), d2 = e2("./adler32"), p2 = e2("./crc32"), n2 = e2("./messages"), l2 = 0, f2 = 4, m = 0, _ = -2, g = -1, b = 4, i2 = 2, v = 8, y = 9, s2 = 286, a2 = 30, o2 = 19, w = 2 * s2 + 1, k = 15, x = 3, S = 258, z = S + x + 1, C = 42, E = 113, A = 1, I = 2, O = 3, B = 4;
        function R(e3, t3) {
          return e3.msg = n2[t3], t3;
        }
        function T(e3) {
          return (e3 << 1) - (4 < e3 ? 9 : 0);
        }
        function D(e3) {
          for (var t3 = e3.length; 0 <= --t3; )
            e3[t3] = 0;
        }
        function F(e3) {
          var t3 = e3.state, r3 = t3.pending;
          r3 > e3.avail_out && (r3 = e3.avail_out), 0 !== r3 && (c2.arraySet(e3.output, t3.pending_buf, t3.pending_out, r3, e3.next_out), e3.next_out += r3, t3.pending_out += r3, e3.total_out += r3, e3.avail_out -= r3, t3.pending -= r3, 0 === t3.pending && (t3.pending_out = 0));
        }
        function N(e3, t3) {
          u2._tr_flush_block(e3, 0 <= e3.block_start ? e3.block_start : -1, e3.strstart - e3.block_start, t3), e3.block_start = e3.strstart, F(e3.strm);
        }
        function U(e3, t3) {
          e3.pending_buf[e3.pending++] = t3;
        }
        function P(e3, t3) {
          e3.pending_buf[e3.pending++] = t3 >>> 8 & 255, e3.pending_buf[e3.pending++] = 255 & t3;
        }
        function L(e3, t3) {
          var r3, n3, i3 = e3.max_chain_length, s3 = e3.strstart, a3 = e3.prev_length, o3 = e3.nice_match, h3 = e3.strstart > e3.w_size - z ? e3.strstart - (e3.w_size - z) : 0, u3 = e3.window, l3 = e3.w_mask, f3 = e3.prev, c3 = e3.strstart + S, d3 = u3[s3 + a3 - 1], p3 = u3[s3 + a3];
          e3.prev_length >= e3.good_match && (i3 >>= 2), o3 > e3.lookahead && (o3 = e3.lookahead);
          do {
            if (u3[(r3 = t3) + a3] === p3 && u3[r3 + a3 - 1] === d3 && u3[r3] === u3[s3] && u3[++r3] === u3[s3 + 1]) {
              s3 += 2, r3++;
              do {
              } while (u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && u3[++s3] === u3[++r3] && s3 < c3);
              if (n3 = S - (c3 - s3), s3 = c3 - S, a3 < n3) {
                if (e3.match_start = t3, o3 <= (a3 = n3))
                  break;
                d3 = u3[s3 + a3 - 1], p3 = u3[s3 + a3];
              }
            }
          } while ((t3 = f3[t3 & l3]) > h3 && 0 != --i3);
          return a3 <= e3.lookahead ? a3 : e3.lookahead;
        }
        function j(e3) {
          var t3, r3, n3, i3, s3, a3, o3, h3, u3, l3, f3 = e3.w_size;
          do {
            if (i3 = e3.window_size - e3.lookahead - e3.strstart, e3.strstart >= f3 + (f3 - z)) {
              for (c2.arraySet(e3.window, e3.window, f3, f3, 0), e3.match_start -= f3, e3.strstart -= f3, e3.block_start -= f3, t3 = r3 = e3.hash_size; n3 = e3.head[--t3], e3.head[t3] = f3 <= n3 ? n3 - f3 : 0, --r3; )
                ;
              for (t3 = r3 = f3; n3 = e3.prev[--t3], e3.prev[t3] = f3 <= n3 ? n3 - f3 : 0, --r3; )
                ;
              i3 += f3;
            }
            if (0 === e3.strm.avail_in)
              break;
            if (a3 = e3.strm, o3 = e3.window, h3 = e3.strstart + e3.lookahead, u3 = i3, l3 = void 0, l3 = a3.avail_in, u3 < l3 && (l3 = u3), r3 = 0 === l3 ? 0 : (a3.avail_in -= l3, c2.arraySet(o3, a3.input, a3.next_in, l3, h3), 1 === a3.state.wrap ? a3.adler = d2(a3.adler, o3, l3, h3) : 2 === a3.state.wrap && (a3.adler = p2(a3.adler, o3, l3, h3)), a3.next_in += l3, a3.total_in += l3, l3), e3.lookahead += r3, e3.lookahead + e3.insert >= x)
              for (s3 = e3.strstart - e3.insert, e3.ins_h = e3.window[s3], e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[s3 + 1]) & e3.hash_mask; e3.insert && (e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[s3 + x - 1]) & e3.hash_mask, e3.prev[s3 & e3.w_mask] = e3.head[e3.ins_h], e3.head[e3.ins_h] = s3, s3++, e3.insert--, !(e3.lookahead + e3.insert < x)); )
                ;
          } while (e3.lookahead < z && 0 !== e3.strm.avail_in);
        }
        function Z(e3, t3) {
          for (var r3, n3; ; ) {
            if (e3.lookahead < z) {
              if (j(e3), e3.lookahead < z && t3 === l2)
                return A;
              if (0 === e3.lookahead)
                break;
            }
            if (r3 = 0, e3.lookahead >= x && (e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[e3.strstart + x - 1]) & e3.hash_mask, r3 = e3.prev[e3.strstart & e3.w_mask] = e3.head[e3.ins_h], e3.head[e3.ins_h] = e3.strstart), 0 !== r3 && e3.strstart - r3 <= e3.w_size - z && (e3.match_length = L(e3, r3)), e3.match_length >= x)
              if (n3 = u2._tr_tally(e3, e3.strstart - e3.match_start, e3.match_length - x), e3.lookahead -= e3.match_length, e3.match_length <= e3.max_lazy_match && e3.lookahead >= x) {
                for (e3.match_length--; e3.strstart++, e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[e3.strstart + x - 1]) & e3.hash_mask, r3 = e3.prev[e3.strstart & e3.w_mask] = e3.head[e3.ins_h], e3.head[e3.ins_h] = e3.strstart, 0 != --e3.match_length; )
                  ;
                e3.strstart++;
              } else
                e3.strstart += e3.match_length, e3.match_length = 0, e3.ins_h = e3.window[e3.strstart], e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[e3.strstart + 1]) & e3.hash_mask;
            else
              n3 = u2._tr_tally(e3, 0, e3.window[e3.strstart]), e3.lookahead--, e3.strstart++;
            if (n3 && (N(e3, false), 0 === e3.strm.avail_out))
              return A;
          }
          return e3.insert = e3.strstart < x - 1 ? e3.strstart : x - 1, t3 === f2 ? (N(e3, true), 0 === e3.strm.avail_out ? O : B) : e3.last_lit && (N(e3, false), 0 === e3.strm.avail_out) ? A : I;
        }
        function W(e3, t3) {
          for (var r3, n3, i3; ; ) {
            if (e3.lookahead < z) {
              if (j(e3), e3.lookahead < z && t3 === l2)
                return A;
              if (0 === e3.lookahead)
                break;
            }
            if (r3 = 0, e3.lookahead >= x && (e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[e3.strstart + x - 1]) & e3.hash_mask, r3 = e3.prev[e3.strstart & e3.w_mask] = e3.head[e3.ins_h], e3.head[e3.ins_h] = e3.strstart), e3.prev_length = e3.match_length, e3.prev_match = e3.match_start, e3.match_length = x - 1, 0 !== r3 && e3.prev_length < e3.max_lazy_match && e3.strstart - r3 <= e3.w_size - z && (e3.match_length = L(e3, r3), e3.match_length <= 5 && (1 === e3.strategy || e3.match_length === x && 4096 < e3.strstart - e3.match_start) && (e3.match_length = x - 1)), e3.prev_length >= x && e3.match_length <= e3.prev_length) {
              for (i3 = e3.strstart + e3.lookahead - x, n3 = u2._tr_tally(e3, e3.strstart - 1 - e3.prev_match, e3.prev_length - x), e3.lookahead -= e3.prev_length - 1, e3.prev_length -= 2; ++e3.strstart <= i3 && (e3.ins_h = (e3.ins_h << e3.hash_shift ^ e3.window[e3.strstart + x - 1]) & e3.hash_mask, r3 = e3.prev[e3.strstart & e3.w_mask] = e3.head[e3.ins_h], e3.head[e3.ins_h] = e3.strstart), 0 != --e3.prev_length; )
                ;
              if (e3.match_available = 0, e3.match_length = x - 1, e3.strstart++, n3 && (N(e3, false), 0 === e3.strm.avail_out))
                return A;
            } else if (e3.match_available) {
              if ((n3 = u2._tr_tally(e3, 0, e3.window[e3.strstart - 1])) && N(e3, false), e3.strstart++, e3.lookahead--, 0 === e3.strm.avail_out)
                return A;
            } else
              e3.match_available = 1, e3.strstart++, e3.lookahead--;
          }
          return e3.match_available && (n3 = u2._tr_tally(e3, 0, e3.window[e3.strstart - 1]), e3.match_available = 0), e3.insert = e3.strstart < x - 1 ? e3.strstart : x - 1, t3 === f2 ? (N(e3, true), 0 === e3.strm.avail_out ? O : B) : e3.last_lit && (N(e3, false), 0 === e3.strm.avail_out) ? A : I;
        }
        function M(e3, t3, r3, n3, i3) {
          this.good_length = e3, this.max_lazy = t3, this.nice_length = r3, this.max_chain = n3, this.func = i3;
        }
        function H() {
          this.strm = null, this.status = 0, this.pending_buf = null, this.pending_buf_size = 0, this.pending_out = 0, this.pending = 0, this.wrap = 0, this.gzhead = null, this.gzindex = 0, this.method = v, this.last_flush = -1, this.w_size = 0, this.w_bits = 0, this.w_mask = 0, this.window = null, this.window_size = 0, this.prev = null, this.head = null, this.ins_h = 0, this.hash_size = 0, this.hash_bits = 0, this.hash_mask = 0, this.hash_shift = 0, this.block_start = 0, this.match_length = 0, this.prev_match = 0, this.match_available = 0, this.strstart = 0, this.match_start = 0, this.lookahead = 0, this.prev_length = 0, this.max_chain_length = 0, this.max_lazy_match = 0, this.level = 0, this.strategy = 0, this.good_match = 0, this.nice_match = 0, this.dyn_ltree = new c2.Buf16(2 * w), this.dyn_dtree = new c2.Buf16(2 * (2 * a2 + 1)), this.bl_tree = new c2.Buf16(2 * (2 * o2 + 1)), D(this.dyn_ltree), D(this.dyn_dtree), D(this.bl_tree), this.l_desc = null, this.d_desc = null, this.bl_desc = null, this.bl_count = new c2.Buf16(k + 1), this.heap = new c2.Buf16(2 * s2 + 1), D(this.heap), this.heap_len = 0, this.heap_max = 0, this.depth = new c2.Buf16(2 * s2 + 1), D(this.depth), this.l_buf = 0, this.lit_bufsize = 0, this.last_lit = 0, this.d_buf = 0, this.opt_len = 0, this.static_len = 0, this.matches = 0, this.insert = 0, this.bi_buf = 0, this.bi_valid = 0;
        }
        function G(e3) {
          var t3;
          return e3 && e3.state ? (e3.total_in = e3.total_out = 0, e3.data_type = i2, (t3 = e3.state).pending = 0, t3.pending_out = 0, t3.wrap < 0 && (t3.wrap = -t3.wrap), t3.status = t3.wrap ? C : E, e3.adler = 2 === t3.wrap ? 0 : 1, t3.last_flush = l2, u2._tr_init(t3), m) : R(e3, _);
        }
        function K(e3) {
          var t3 = G(e3);
          return t3 === m && function(e4) {
            e4.window_size = 2 * e4.w_size, D(e4.head), e4.max_lazy_match = h2[e4.level].max_lazy, e4.good_match = h2[e4.level].good_length, e4.nice_match = h2[e4.level].nice_length, e4.max_chain_length = h2[e4.level].max_chain, e4.strstart = 0, e4.block_start = 0, e4.lookahead = 0, e4.insert = 0, e4.match_length = e4.prev_length = x - 1, e4.match_available = 0, e4.ins_h = 0;
          }(e3.state), t3;
        }
        function Y(e3, t3, r3, n3, i3, s3) {
          if (!e3)
            return _;
          var a3 = 1;
          if (t3 === g && (t3 = 6), n3 < 0 ? (a3 = 0, n3 = -n3) : 15 < n3 && (a3 = 2, n3 -= 16), i3 < 1 || y < i3 || r3 !== v || n3 < 8 || 15 < n3 || t3 < 0 || 9 < t3 || s3 < 0 || b < s3)
            return R(e3, _);
          8 === n3 && (n3 = 9);
          var o3 = new H();
          return (e3.state = o3).strm = e3, o3.wrap = a3, o3.gzhead = null, o3.w_bits = n3, o3.w_size = 1 << o3.w_bits, o3.w_mask = o3.w_size - 1, o3.hash_bits = i3 + 7, o3.hash_size = 1 << o3.hash_bits, o3.hash_mask = o3.hash_size - 1, o3.hash_shift = ~~((o3.hash_bits + x - 1) / x), o3.window = new c2.Buf8(2 * o3.w_size), o3.head = new c2.Buf16(o3.hash_size), o3.prev = new c2.Buf16(o3.w_size), o3.lit_bufsize = 1 << i3 + 6, o3.pending_buf_size = 4 * o3.lit_bufsize, o3.pending_buf = new c2.Buf8(o3.pending_buf_size), o3.d_buf = 1 * o3.lit_bufsize, o3.l_buf = 3 * o3.lit_bufsize, o3.level = t3, o3.strategy = s3, o3.method = r3, K(e3);
        }
        h2 = [new M(0, 0, 0, 0, function(e3, t3) {
          var r3 = 65535;
          for (r3 > e3.pending_buf_size - 5 && (r3 = e3.pending_buf_size - 5); ; ) {
            if (e3.lookahead <= 1) {
              if (j(e3), 0 === e3.lookahead && t3 === l2)
                return A;
              if (0 === e3.lookahead)
                break;
            }
            e3.strstart += e3.lookahead, e3.lookahead = 0;
            var n3 = e3.block_start + r3;
            if ((0 === e3.strstart || e3.strstart >= n3) && (e3.lookahead = e3.strstart - n3, e3.strstart = n3, N(e3, false), 0 === e3.strm.avail_out))
              return A;
            if (e3.strstart - e3.block_start >= e3.w_size - z && (N(e3, false), 0 === e3.strm.avail_out))
              return A;
          }
          return e3.insert = 0, t3 === f2 ? (N(e3, true), 0 === e3.strm.avail_out ? O : B) : (e3.strstart > e3.block_start && (N(e3, false), e3.strm.avail_out), A);
        }), new M(4, 4, 8, 4, Z), new M(4, 5, 16, 8, Z), new M(4, 6, 32, 32, Z), new M(4, 4, 16, 16, W), new M(8, 16, 32, 32, W), new M(8, 16, 128, 128, W), new M(8, 32, 128, 256, W), new M(32, 128, 258, 1024, W), new M(32, 258, 258, 4096, W)], r2.deflateInit = function(e3, t3) {
          return Y(e3, t3, v, 15, 8, 0);
        }, r2.deflateInit2 = Y, r2.deflateReset = K, r2.deflateResetKeep = G, r2.deflateSetHeader = function(e3, t3) {
          return e3 && e3.state ? 2 !== e3.state.wrap ? _ : (e3.state.gzhead = t3, m) : _;
        }, r2.deflate = function(e3, t3) {
          var r3, n3, i3, s3;
          if (!e3 || !e3.state || 5 < t3 || t3 < 0)
            return e3 ? R(e3, _) : _;
          if (n3 = e3.state, !e3.output || !e3.input && 0 !== e3.avail_in || 666 === n3.status && t3 !== f2)
            return R(e3, 0 === e3.avail_out ? -5 : _);
          if (n3.strm = e3, r3 = n3.last_flush, n3.last_flush = t3, n3.status === C)
            if (2 === n3.wrap)
              e3.adler = 0, U(n3, 31), U(n3, 139), U(n3, 8), n3.gzhead ? (U(n3, (n3.gzhead.text ? 1 : 0) + (n3.gzhead.hcrc ? 2 : 0) + (n3.gzhead.extra ? 4 : 0) + (n3.gzhead.name ? 8 : 0) + (n3.gzhead.comment ? 16 : 0)), U(n3, 255 & n3.gzhead.time), U(n3, n3.gzhead.time >> 8 & 255), U(n3, n3.gzhead.time >> 16 & 255), U(n3, n3.gzhead.time >> 24 & 255), U(n3, 9 === n3.level ? 2 : 2 <= n3.strategy || n3.level < 2 ? 4 : 0), U(n3, 255 & n3.gzhead.os), n3.gzhead.extra && n3.gzhead.extra.length && (U(n3, 255 & n3.gzhead.extra.length), U(n3, n3.gzhead.extra.length >> 8 & 255)), n3.gzhead.hcrc && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending, 0)), n3.gzindex = 0, n3.status = 69) : (U(n3, 0), U(n3, 0), U(n3, 0), U(n3, 0), U(n3, 0), U(n3, 9 === n3.level ? 2 : 2 <= n3.strategy || n3.level < 2 ? 4 : 0), U(n3, 3), n3.status = E);
            else {
              var a3 = v + (n3.w_bits - 8 << 4) << 8;
              a3 |= (2 <= n3.strategy || n3.level < 2 ? 0 : n3.level < 6 ? 1 : 6 === n3.level ? 2 : 3) << 6, 0 !== n3.strstart && (a3 |= 32), a3 += 31 - a3 % 31, n3.status = E, P(n3, a3), 0 !== n3.strstart && (P(n3, e3.adler >>> 16), P(n3, 65535 & e3.adler)), e3.adler = 1;
            }
          if (69 === n3.status)
            if (n3.gzhead.extra) {
              for (i3 = n3.pending; n3.gzindex < (65535 & n3.gzhead.extra.length) && (n3.pending !== n3.pending_buf_size || (n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), F(e3), i3 = n3.pending, n3.pending !== n3.pending_buf_size)); )
                U(n3, 255 & n3.gzhead.extra[n3.gzindex]), n3.gzindex++;
              n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), n3.gzindex === n3.gzhead.extra.length && (n3.gzindex = 0, n3.status = 73);
            } else
              n3.status = 73;
          if (73 === n3.status)
            if (n3.gzhead.name) {
              i3 = n3.pending;
              do {
                if (n3.pending === n3.pending_buf_size && (n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), F(e3), i3 = n3.pending, n3.pending === n3.pending_buf_size)) {
                  s3 = 1;
                  break;
                }
                s3 = n3.gzindex < n3.gzhead.name.length ? 255 & n3.gzhead.name.charCodeAt(n3.gzindex++) : 0, U(n3, s3);
              } while (0 !== s3);
              n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), 0 === s3 && (n3.gzindex = 0, n3.status = 91);
            } else
              n3.status = 91;
          if (91 === n3.status)
            if (n3.gzhead.comment) {
              i3 = n3.pending;
              do {
                if (n3.pending === n3.pending_buf_size && (n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), F(e3), i3 = n3.pending, n3.pending === n3.pending_buf_size)) {
                  s3 = 1;
                  break;
                }
                s3 = n3.gzindex < n3.gzhead.comment.length ? 255 & n3.gzhead.comment.charCodeAt(n3.gzindex++) : 0, U(n3, s3);
              } while (0 !== s3);
              n3.gzhead.hcrc && n3.pending > i3 && (e3.adler = p2(e3.adler, n3.pending_buf, n3.pending - i3, i3)), 0 === s3 && (n3.status = 103);
            } else
              n3.status = 103;
          if (103 === n3.status && (n3.gzhead.hcrc ? (n3.pending + 2 > n3.pending_buf_size && F(e3), n3.pending + 2 <= n3.pending_buf_size && (U(n3, 255 & e3.adler), U(n3, e3.adler >> 8 & 255), e3.adler = 0, n3.status = E)) : n3.status = E), 0 !== n3.pending) {
            if (F(e3), 0 === e3.avail_out)
              return n3.last_flush = -1, m;
          } else if (0 === e3.avail_in && T(t3) <= T(r3) && t3 !== f2)
            return R(e3, -5);
          if (666 === n3.status && 0 !== e3.avail_in)
            return R(e3, -5);
          if (0 !== e3.avail_in || 0 !== n3.lookahead || t3 !== l2 && 666 !== n3.status) {
            var o3 = 2 === n3.strategy ? function(e4, t4) {
              for (var r4; ; ) {
                if (0 === e4.lookahead && (j(e4), 0 === e4.lookahead)) {
                  if (t4 === l2)
                    return A;
                  break;
                }
                if (e4.match_length = 0, r4 = u2._tr_tally(e4, 0, e4.window[e4.strstart]), e4.lookahead--, e4.strstart++, r4 && (N(e4, false), 0 === e4.strm.avail_out))
                  return A;
              }
              return e4.insert = 0, t4 === f2 ? (N(e4, true), 0 === e4.strm.avail_out ? O : B) : e4.last_lit && (N(e4, false), 0 === e4.strm.avail_out) ? A : I;
            }(n3, t3) : 3 === n3.strategy ? function(e4, t4) {
              for (var r4, n4, i4, s4, a4 = e4.window; ; ) {
                if (e4.lookahead <= S) {
                  if (j(e4), e4.lookahead <= S && t4 === l2)
                    return A;
                  if (0 === e4.lookahead)
                    break;
                }
                if (e4.match_length = 0, e4.lookahead >= x && 0 < e4.strstart && (n4 = a4[i4 = e4.strstart - 1]) === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4]) {
                  s4 = e4.strstart + S;
                  do {
                  } while (n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && n4 === a4[++i4] && i4 < s4);
                  e4.match_length = S - (s4 - i4), e4.match_length > e4.lookahead && (e4.match_length = e4.lookahead);
                }
                if (e4.match_length >= x ? (r4 = u2._tr_tally(e4, 1, e4.match_length - x), e4.lookahead -= e4.match_length, e4.strstart += e4.match_length, e4.match_length = 0) : (r4 = u2._tr_tally(e4, 0, e4.window[e4.strstart]), e4.lookahead--, e4.strstart++), r4 && (N(e4, false), 0 === e4.strm.avail_out))
                  return A;
              }
              return e4.insert = 0, t4 === f2 ? (N(e4, true), 0 === e4.strm.avail_out ? O : B) : e4.last_lit && (N(e4, false), 0 === e4.strm.avail_out) ? A : I;
            }(n3, t3) : h2[n3.level].func(n3, t3);
            if (o3 !== O && o3 !== B || (n3.status = 666), o3 === A || o3 === O)
              return 0 === e3.avail_out && (n3.last_flush = -1), m;
            if (o3 === I && (1 === t3 ? u2._tr_align(n3) : 5 !== t3 && (u2._tr_stored_block(n3, 0, 0, false), 3 === t3 && (D(n3.head), 0 === n3.lookahead && (n3.strstart = 0, n3.block_start = 0, n3.insert = 0))), F(e3), 0 === e3.avail_out))
              return n3.last_flush = -1, m;
          }
          return t3 !== f2 ? m : n3.wrap <= 0 ? 1 : (2 === n3.wrap ? (U(n3, 255 & e3.adler), U(n3, e3.adler >> 8 & 255), U(n3, e3.adler >> 16 & 255), U(n3, e3.adler >> 24 & 255), U(n3, 255 & e3.total_in), U(n3, e3.total_in >> 8 & 255), U(n3, e3.total_in >> 16 & 255), U(n3, e3.total_in >> 24 & 255)) : (P(n3, e3.adler >>> 16), P(n3, 65535 & e3.adler)), F(e3), 0 < n3.wrap && (n3.wrap = -n3.wrap), 0 !== n3.pending ? m : 1);
        }, r2.deflateEnd = function(e3) {
          var t3;
          return e3 && e3.state ? (t3 = e3.state.status) !== C && 69 !== t3 && 73 !== t3 && 91 !== t3 && 103 !== t3 && t3 !== E && 666 !== t3 ? R(e3, _) : (e3.state = null, t3 === E ? R(e3, -3) : m) : _;
        }, r2.deflateSetDictionary = function(e3, t3) {
          var r3, n3, i3, s3, a3, o3, h3, u3, l3 = t3.length;
          if (!e3 || !e3.state)
            return _;
          if (2 === (s3 = (r3 = e3.state).wrap) || 1 === s3 && r3.status !== C || r3.lookahead)
            return _;
          for (1 === s3 && (e3.adler = d2(e3.adler, t3, l3, 0)), r3.wrap = 0, l3 >= r3.w_size && (0 === s3 && (D(r3.head), r3.strstart = 0, r3.block_start = 0, r3.insert = 0), u3 = new c2.Buf8(r3.w_size), c2.arraySet(u3, t3, l3 - r3.w_size, r3.w_size, 0), t3 = u3, l3 = r3.w_size), a3 = e3.avail_in, o3 = e3.next_in, h3 = e3.input, e3.avail_in = l3, e3.next_in = 0, e3.input = t3, j(r3); r3.lookahead >= x; ) {
            for (n3 = r3.strstart, i3 = r3.lookahead - (x - 1); r3.ins_h = (r3.ins_h << r3.hash_shift ^ r3.window[n3 + x - 1]) & r3.hash_mask, r3.prev[n3 & r3.w_mask] = r3.head[r3.ins_h], r3.head[r3.ins_h] = n3, n3++, --i3; )
              ;
            r3.strstart = n3, r3.lookahead = x - 1, j(r3);
          }
          return r3.strstart += r3.lookahead, r3.block_start = r3.strstart, r3.insert = r3.lookahead, r3.lookahead = 0, r3.match_length = r3.prev_length = x - 1, r3.match_available = 0, e3.next_in = o3, e3.input = h3, e3.avail_in = a3, r3.wrap = s3, m;
        }, r2.deflateInfo = "pako deflate (from Nodeca project)";
      }, { "../utils/common": 41, "./adler32": 43, "./crc32": 45, "./messages": 51, "./trees": 52 }], 47: [function(e2, t2, r2) {
        "use strict";
        t2.exports = function() {
          this.text = 0, this.time = 0, this.xflags = 0, this.os = 0, this.extra = null, this.extra_len = 0, this.name = "", this.comment = "", this.hcrc = 0, this.done = false;
        };
      }, {}], 48: [function(e2, t2, r2) {
        "use strict";
        t2.exports = function(e3, t3) {
          var r3, n2, i2, s2, a2, o2, h2, u2, l2, f2, c2, d2, p2, m, _, g, b, v, y, w, k, x, S, z, C;
          r3 = e3.state, n2 = e3.next_in, z = e3.input, i2 = n2 + (e3.avail_in - 5), s2 = e3.next_out, C = e3.output, a2 = s2 - (t3 - e3.avail_out), o2 = s2 + (e3.avail_out - 257), h2 = r3.dmax, u2 = r3.wsize, l2 = r3.whave, f2 = r3.wnext, c2 = r3.window, d2 = r3.hold, p2 = r3.bits, m = r3.lencode, _ = r3.distcode, g = (1 << r3.lenbits) - 1, b = (1 << r3.distbits) - 1;
          e:
            do {
              p2 < 15 && (d2 += z[n2++] << p2, p2 += 8, d2 += z[n2++] << p2, p2 += 8), v = m[d2 & g];
              t:
                for (; ; ) {
                  if (d2 >>>= y = v >>> 24, p2 -= y, 0 === (y = v >>> 16 & 255))
                    C[s2++] = 65535 & v;
                  else {
                    if (!(16 & y)) {
                      if (0 == (64 & y)) {
                        v = m[(65535 & v) + (d2 & (1 << y) - 1)];
                        continue t;
                      }
                      if (32 & y) {
                        r3.mode = 12;
                        break e;
                      }
                      e3.msg = "invalid literal/length code", r3.mode = 30;
                      break e;
                    }
                    w = 65535 & v, (y &= 15) && (p2 < y && (d2 += z[n2++] << p2, p2 += 8), w += d2 & (1 << y) - 1, d2 >>>= y, p2 -= y), p2 < 15 && (d2 += z[n2++] << p2, p2 += 8, d2 += z[n2++] << p2, p2 += 8), v = _[d2 & b];
                    r:
                      for (; ; ) {
                        if (d2 >>>= y = v >>> 24, p2 -= y, !(16 & (y = v >>> 16 & 255))) {
                          if (0 == (64 & y)) {
                            v = _[(65535 & v) + (d2 & (1 << y) - 1)];
                            continue r;
                          }
                          e3.msg = "invalid distance code", r3.mode = 30;
                          break e;
                        }
                        if (k = 65535 & v, p2 < (y &= 15) && (d2 += z[n2++] << p2, (p2 += 8) < y && (d2 += z[n2++] << p2, p2 += 8)), h2 < (k += d2 & (1 << y) - 1)) {
                          e3.msg = "invalid distance too far back", r3.mode = 30;
                          break e;
                        }
                        if (d2 >>>= y, p2 -= y, (y = s2 - a2) < k) {
                          if (l2 < (y = k - y) && r3.sane) {
                            e3.msg = "invalid distance too far back", r3.mode = 30;
                            break e;
                          }
                          if (S = c2, (x = 0) === f2) {
                            if (x += u2 - y, y < w) {
                              for (w -= y; C[s2++] = c2[x++], --y; )
                                ;
                              x = s2 - k, S = C;
                            }
                          } else if (f2 < y) {
                            if (x += u2 + f2 - y, (y -= f2) < w) {
                              for (w -= y; C[s2++] = c2[x++], --y; )
                                ;
                              if (x = 0, f2 < w) {
                                for (w -= y = f2; C[s2++] = c2[x++], --y; )
                                  ;
                                x = s2 - k, S = C;
                              }
                            }
                          } else if (x += f2 - y, y < w) {
                            for (w -= y; C[s2++] = c2[x++], --y; )
                              ;
                            x = s2 - k, S = C;
                          }
                          for (; 2 < w; )
                            C[s2++] = S[x++], C[s2++] = S[x++], C[s2++] = S[x++], w -= 3;
                          w && (C[s2++] = S[x++], 1 < w && (C[s2++] = S[x++]));
                        } else {
                          for (x = s2 - k; C[s2++] = C[x++], C[s2++] = C[x++], C[s2++] = C[x++], 2 < (w -= 3); )
                            ;
                          w && (C[s2++] = C[x++], 1 < w && (C[s2++] = C[x++]));
                        }
                        break;
                      }
                  }
                  break;
                }
            } while (n2 < i2 && s2 < o2);
          n2 -= w = p2 >> 3, d2 &= (1 << (p2 -= w << 3)) - 1, e3.next_in = n2, e3.next_out = s2, e3.avail_in = n2 < i2 ? i2 - n2 + 5 : 5 - (n2 - i2), e3.avail_out = s2 < o2 ? o2 - s2 + 257 : 257 - (s2 - o2), r3.hold = d2, r3.bits = p2;
        };
      }, {}], 49: [function(e2, t2, r2) {
        "use strict";
        var I = e2("../utils/common"), O = e2("./adler32"), B = e2("./crc32"), R = e2("./inffast"), T = e2("./inftrees"), D = 1, F = 2, N = 0, U = -2, P = 1, n2 = 852, i2 = 592;
        function L(e3) {
          return (e3 >>> 24 & 255) + (e3 >>> 8 & 65280) + ((65280 & e3) << 8) + ((255 & e3) << 24);
        }
        function s2() {
          this.mode = 0, this.last = false, this.wrap = 0, this.havedict = false, this.flags = 0, this.dmax = 0, this.check = 0, this.total = 0, this.head = null, this.wbits = 0, this.wsize = 0, this.whave = 0, this.wnext = 0, this.window = null, this.hold = 0, this.bits = 0, this.length = 0, this.offset = 0, this.extra = 0, this.lencode = null, this.distcode = null, this.lenbits = 0, this.distbits = 0, this.ncode = 0, this.nlen = 0, this.ndist = 0, this.have = 0, this.next = null, this.lens = new I.Buf16(320), this.work = new I.Buf16(288), this.lendyn = null, this.distdyn = null, this.sane = 0, this.back = 0, this.was = 0;
        }
        function a2(e3) {
          var t3;
          return e3 && e3.state ? (t3 = e3.state, e3.total_in = e3.total_out = t3.total = 0, e3.msg = "", t3.wrap && (e3.adler = 1 & t3.wrap), t3.mode = P, t3.last = 0, t3.havedict = 0, t3.dmax = 32768, t3.head = null, t3.hold = 0, t3.bits = 0, t3.lencode = t3.lendyn = new I.Buf32(n2), t3.distcode = t3.distdyn = new I.Buf32(i2), t3.sane = 1, t3.back = -1, N) : U;
        }
        function o2(e3) {
          var t3;
          return e3 && e3.state ? ((t3 = e3.state).wsize = 0, t3.whave = 0, t3.wnext = 0, a2(e3)) : U;
        }
        function h2(e3, t3) {
          var r3, n3;
          return e3 && e3.state ? (n3 = e3.state, t3 < 0 ? (r3 = 0, t3 = -t3) : (r3 = 1 + (t3 >> 4), t3 < 48 && (t3 &= 15)), t3 && (t3 < 8 || 15 < t3) ? U : (null !== n3.window && n3.wbits !== t3 && (n3.window = null), n3.wrap = r3, n3.wbits = t3, o2(e3))) : U;
        }
        function u2(e3, t3) {
          var r3, n3;
          return e3 ? (n3 = new s2(), (e3.state = n3).window = null, (r3 = h2(e3, t3)) !== N && (e3.state = null), r3) : U;
        }
        var l2, f2, c2 = true;
        function j(e3) {
          if (c2) {
            var t3;
            for (l2 = new I.Buf32(512), f2 = new I.Buf32(32), t3 = 0; t3 < 144; )
              e3.lens[t3++] = 8;
            for (; t3 < 256; )
              e3.lens[t3++] = 9;
            for (; t3 < 280; )
              e3.lens[t3++] = 7;
            for (; t3 < 288; )
              e3.lens[t3++] = 8;
            for (T(D, e3.lens, 0, 288, l2, 0, e3.work, { bits: 9 }), t3 = 0; t3 < 32; )
              e3.lens[t3++] = 5;
            T(F, e3.lens, 0, 32, f2, 0, e3.work, { bits: 5 }), c2 = false;
          }
          e3.lencode = l2, e3.lenbits = 9, e3.distcode = f2, e3.distbits = 5;
        }
        function Z(e3, t3, r3, n3) {
          var i3, s3 = e3.state;
          return null === s3.window && (s3.wsize = 1 << s3.wbits, s3.wnext = 0, s3.whave = 0, s3.window = new I.Buf8(s3.wsize)), n3 >= s3.wsize ? (I.arraySet(s3.window, t3, r3 - s3.wsize, s3.wsize, 0), s3.wnext = 0, s3.whave = s3.wsize) : (n3 < (i3 = s3.wsize - s3.wnext) && (i3 = n3), I.arraySet(s3.window, t3, r3 - n3, i3, s3.wnext), (n3 -= i3) ? (I.arraySet(s3.window, t3, r3 - n3, n3, 0), s3.wnext = n3, s3.whave = s3.wsize) : (s3.wnext += i3, s3.wnext === s3.wsize && (s3.wnext = 0), s3.whave < s3.wsize && (s3.whave += i3))), 0;
        }
        r2.inflateReset = o2, r2.inflateReset2 = h2, r2.inflateResetKeep = a2, r2.inflateInit = function(e3) {
          return u2(e3, 15);
        }, r2.inflateInit2 = u2, r2.inflate = function(e3, t3) {
          var r3, n3, i3, s3, a3, o3, h3, u3, l3, f3, c3, d2, p2, m, _, g, b, v, y, w, k, x, S, z, C = 0, E = new I.Buf8(4), A = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
          if (!e3 || !e3.state || !e3.output || !e3.input && 0 !== e3.avail_in)
            return U;
          12 === (r3 = e3.state).mode && (r3.mode = 13), a3 = e3.next_out, i3 = e3.output, h3 = e3.avail_out, s3 = e3.next_in, n3 = e3.input, o3 = e3.avail_in, u3 = r3.hold, l3 = r3.bits, f3 = o3, c3 = h3, x = N;
          e:
            for (; ; )
              switch (r3.mode) {
                case P:
                  if (0 === r3.wrap) {
                    r3.mode = 13;
                    break;
                  }
                  for (; l3 < 16; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if (2 & r3.wrap && 35615 === u3) {
                    E[r3.check = 0] = 255 & u3, E[1] = u3 >>> 8 & 255, r3.check = B(r3.check, E, 2, 0), l3 = u3 = 0, r3.mode = 2;
                    break;
                  }
                  if (r3.flags = 0, r3.head && (r3.head.done = false), !(1 & r3.wrap) || (((255 & u3) << 8) + (u3 >> 8)) % 31) {
                    e3.msg = "incorrect header check", r3.mode = 30;
                    break;
                  }
                  if (8 != (15 & u3)) {
                    e3.msg = "unknown compression method", r3.mode = 30;
                    break;
                  }
                  if (l3 -= 4, k = 8 + (15 & (u3 >>>= 4)), 0 === r3.wbits)
                    r3.wbits = k;
                  else if (k > r3.wbits) {
                    e3.msg = "invalid window size", r3.mode = 30;
                    break;
                  }
                  r3.dmax = 1 << k, e3.adler = r3.check = 1, r3.mode = 512 & u3 ? 10 : 12, l3 = u3 = 0;
                  break;
                case 2:
                  for (; l3 < 16; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if (r3.flags = u3, 8 != (255 & r3.flags)) {
                    e3.msg = "unknown compression method", r3.mode = 30;
                    break;
                  }
                  if (57344 & r3.flags) {
                    e3.msg = "unknown header flags set", r3.mode = 30;
                    break;
                  }
                  r3.head && (r3.head.text = u3 >> 8 & 1), 512 & r3.flags && (E[0] = 255 & u3, E[1] = u3 >>> 8 & 255, r3.check = B(r3.check, E, 2, 0)), l3 = u3 = 0, r3.mode = 3;
                case 3:
                  for (; l3 < 32; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  r3.head && (r3.head.time = u3), 512 & r3.flags && (E[0] = 255 & u3, E[1] = u3 >>> 8 & 255, E[2] = u3 >>> 16 & 255, E[3] = u3 >>> 24 & 255, r3.check = B(r3.check, E, 4, 0)), l3 = u3 = 0, r3.mode = 4;
                case 4:
                  for (; l3 < 16; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  r3.head && (r3.head.xflags = 255 & u3, r3.head.os = u3 >> 8), 512 & r3.flags && (E[0] = 255 & u3, E[1] = u3 >>> 8 & 255, r3.check = B(r3.check, E, 2, 0)), l3 = u3 = 0, r3.mode = 5;
                case 5:
                  if (1024 & r3.flags) {
                    for (; l3 < 16; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    r3.length = u3, r3.head && (r3.head.extra_len = u3), 512 & r3.flags && (E[0] = 255 & u3, E[1] = u3 >>> 8 & 255, r3.check = B(r3.check, E, 2, 0)), l3 = u3 = 0;
                  } else
                    r3.head && (r3.head.extra = null);
                  r3.mode = 6;
                case 6:
                  if (1024 & r3.flags && (o3 < (d2 = r3.length) && (d2 = o3), d2 && (r3.head && (k = r3.head.extra_len - r3.length, r3.head.extra || (r3.head.extra = new Array(r3.head.extra_len)), I.arraySet(r3.head.extra, n3, s3, d2, k)), 512 & r3.flags && (r3.check = B(r3.check, n3, d2, s3)), o3 -= d2, s3 += d2, r3.length -= d2), r3.length))
                    break e;
                  r3.length = 0, r3.mode = 7;
                case 7:
                  if (2048 & r3.flags) {
                    if (0 === o3)
                      break e;
                    for (d2 = 0; k = n3[s3 + d2++], r3.head && k && r3.length < 65536 && (r3.head.name += String.fromCharCode(k)), k && d2 < o3; )
                      ;
                    if (512 & r3.flags && (r3.check = B(r3.check, n3, d2, s3)), o3 -= d2, s3 += d2, k)
                      break e;
                  } else
                    r3.head && (r3.head.name = null);
                  r3.length = 0, r3.mode = 8;
                case 8:
                  if (4096 & r3.flags) {
                    if (0 === o3)
                      break e;
                    for (d2 = 0; k = n3[s3 + d2++], r3.head && k && r3.length < 65536 && (r3.head.comment += String.fromCharCode(k)), k && d2 < o3; )
                      ;
                    if (512 & r3.flags && (r3.check = B(r3.check, n3, d2, s3)), o3 -= d2, s3 += d2, k)
                      break e;
                  } else
                    r3.head && (r3.head.comment = null);
                  r3.mode = 9;
                case 9:
                  if (512 & r3.flags) {
                    for (; l3 < 16; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    if (u3 !== (65535 & r3.check)) {
                      e3.msg = "header crc mismatch", r3.mode = 30;
                      break;
                    }
                    l3 = u3 = 0;
                  }
                  r3.head && (r3.head.hcrc = r3.flags >> 9 & 1, r3.head.done = true), e3.adler = r3.check = 0, r3.mode = 12;
                  break;
                case 10:
                  for (; l3 < 32; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  e3.adler = r3.check = L(u3), l3 = u3 = 0, r3.mode = 11;
                case 11:
                  if (0 === r3.havedict)
                    return e3.next_out = a3, e3.avail_out = h3, e3.next_in = s3, e3.avail_in = o3, r3.hold = u3, r3.bits = l3, 2;
                  e3.adler = r3.check = 1, r3.mode = 12;
                case 12:
                  if (5 === t3 || 6 === t3)
                    break e;
                case 13:
                  if (r3.last) {
                    u3 >>>= 7 & l3, l3 -= 7 & l3, r3.mode = 27;
                    break;
                  }
                  for (; l3 < 3; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  switch (r3.last = 1 & u3, l3 -= 1, 3 & (u3 >>>= 1)) {
                    case 0:
                      r3.mode = 14;
                      break;
                    case 1:
                      if (j(r3), r3.mode = 20, 6 !== t3)
                        break;
                      u3 >>>= 2, l3 -= 2;
                      break e;
                    case 2:
                      r3.mode = 17;
                      break;
                    case 3:
                      e3.msg = "invalid block type", r3.mode = 30;
                  }
                  u3 >>>= 2, l3 -= 2;
                  break;
                case 14:
                  for (u3 >>>= 7 & l3, l3 -= 7 & l3; l3 < 32; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if ((65535 & u3) != (u3 >>> 16 ^ 65535)) {
                    e3.msg = "invalid stored block lengths", r3.mode = 30;
                    break;
                  }
                  if (r3.length = 65535 & u3, l3 = u3 = 0, r3.mode = 15, 6 === t3)
                    break e;
                case 15:
                  r3.mode = 16;
                case 16:
                  if (d2 = r3.length) {
                    if (o3 < d2 && (d2 = o3), h3 < d2 && (d2 = h3), 0 === d2)
                      break e;
                    I.arraySet(i3, n3, s3, d2, a3), o3 -= d2, s3 += d2, h3 -= d2, a3 += d2, r3.length -= d2;
                    break;
                  }
                  r3.mode = 12;
                  break;
                case 17:
                  for (; l3 < 14; ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if (r3.nlen = 257 + (31 & u3), u3 >>>= 5, l3 -= 5, r3.ndist = 1 + (31 & u3), u3 >>>= 5, l3 -= 5, r3.ncode = 4 + (15 & u3), u3 >>>= 4, l3 -= 4, 286 < r3.nlen || 30 < r3.ndist) {
                    e3.msg = "too many length or distance symbols", r3.mode = 30;
                    break;
                  }
                  r3.have = 0, r3.mode = 18;
                case 18:
                  for (; r3.have < r3.ncode; ) {
                    for (; l3 < 3; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    r3.lens[A[r3.have++]] = 7 & u3, u3 >>>= 3, l3 -= 3;
                  }
                  for (; r3.have < 19; )
                    r3.lens[A[r3.have++]] = 0;
                  if (r3.lencode = r3.lendyn, r3.lenbits = 7, S = { bits: r3.lenbits }, x = T(0, r3.lens, 0, 19, r3.lencode, 0, r3.work, S), r3.lenbits = S.bits, x) {
                    e3.msg = "invalid code lengths set", r3.mode = 30;
                    break;
                  }
                  r3.have = 0, r3.mode = 19;
                case 19:
                  for (; r3.have < r3.nlen + r3.ndist; ) {
                    for (; g = (C = r3.lencode[u3 & (1 << r3.lenbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l3); ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    if (b < 16)
                      u3 >>>= _, l3 -= _, r3.lens[r3.have++] = b;
                    else {
                      if (16 === b) {
                        for (z = _ + 2; l3 < z; ) {
                          if (0 === o3)
                            break e;
                          o3--, u3 += n3[s3++] << l3, l3 += 8;
                        }
                        if (u3 >>>= _, l3 -= _, 0 === r3.have) {
                          e3.msg = "invalid bit length repeat", r3.mode = 30;
                          break;
                        }
                        k = r3.lens[r3.have - 1], d2 = 3 + (3 & u3), u3 >>>= 2, l3 -= 2;
                      } else if (17 === b) {
                        for (z = _ + 3; l3 < z; ) {
                          if (0 === o3)
                            break e;
                          o3--, u3 += n3[s3++] << l3, l3 += 8;
                        }
                        l3 -= _, k = 0, d2 = 3 + (7 & (u3 >>>= _)), u3 >>>= 3, l3 -= 3;
                      } else {
                        for (z = _ + 7; l3 < z; ) {
                          if (0 === o3)
                            break e;
                          o3--, u3 += n3[s3++] << l3, l3 += 8;
                        }
                        l3 -= _, k = 0, d2 = 11 + (127 & (u3 >>>= _)), u3 >>>= 7, l3 -= 7;
                      }
                      if (r3.have + d2 > r3.nlen + r3.ndist) {
                        e3.msg = "invalid bit length repeat", r3.mode = 30;
                        break;
                      }
                      for (; d2--; )
                        r3.lens[r3.have++] = k;
                    }
                  }
                  if (30 === r3.mode)
                    break;
                  if (0 === r3.lens[256]) {
                    e3.msg = "invalid code -- missing end-of-block", r3.mode = 30;
                    break;
                  }
                  if (r3.lenbits = 9, S = { bits: r3.lenbits }, x = T(D, r3.lens, 0, r3.nlen, r3.lencode, 0, r3.work, S), r3.lenbits = S.bits, x) {
                    e3.msg = "invalid literal/lengths set", r3.mode = 30;
                    break;
                  }
                  if (r3.distbits = 6, r3.distcode = r3.distdyn, S = { bits: r3.distbits }, x = T(F, r3.lens, r3.nlen, r3.ndist, r3.distcode, 0, r3.work, S), r3.distbits = S.bits, x) {
                    e3.msg = "invalid distances set", r3.mode = 30;
                    break;
                  }
                  if (r3.mode = 20, 6 === t3)
                    break e;
                case 20:
                  r3.mode = 21;
                case 21:
                  if (6 <= o3 && 258 <= h3) {
                    e3.next_out = a3, e3.avail_out = h3, e3.next_in = s3, e3.avail_in = o3, r3.hold = u3, r3.bits = l3, R(e3, c3), a3 = e3.next_out, i3 = e3.output, h3 = e3.avail_out, s3 = e3.next_in, n3 = e3.input, o3 = e3.avail_in, u3 = r3.hold, l3 = r3.bits, 12 === r3.mode && (r3.back = -1);
                    break;
                  }
                  for (r3.back = 0; g = (C = r3.lencode[u3 & (1 << r3.lenbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l3); ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if (g && 0 == (240 & g)) {
                    for (v = _, y = g, w = b; g = (C = r3.lencode[w + ((u3 & (1 << v + y) - 1) >> v)]) >>> 16 & 255, b = 65535 & C, !(v + (_ = C >>> 24) <= l3); ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    u3 >>>= v, l3 -= v, r3.back += v;
                  }
                  if (u3 >>>= _, l3 -= _, r3.back += _, r3.length = b, 0 === g) {
                    r3.mode = 26;
                    break;
                  }
                  if (32 & g) {
                    r3.back = -1, r3.mode = 12;
                    break;
                  }
                  if (64 & g) {
                    e3.msg = "invalid literal/length code", r3.mode = 30;
                    break;
                  }
                  r3.extra = 15 & g, r3.mode = 22;
                case 22:
                  if (r3.extra) {
                    for (z = r3.extra; l3 < z; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    r3.length += u3 & (1 << r3.extra) - 1, u3 >>>= r3.extra, l3 -= r3.extra, r3.back += r3.extra;
                  }
                  r3.was = r3.length, r3.mode = 23;
                case 23:
                  for (; g = (C = r3.distcode[u3 & (1 << r3.distbits) - 1]) >>> 16 & 255, b = 65535 & C, !((_ = C >>> 24) <= l3); ) {
                    if (0 === o3)
                      break e;
                    o3--, u3 += n3[s3++] << l3, l3 += 8;
                  }
                  if (0 == (240 & g)) {
                    for (v = _, y = g, w = b; g = (C = r3.distcode[w + ((u3 & (1 << v + y) - 1) >> v)]) >>> 16 & 255, b = 65535 & C, !(v + (_ = C >>> 24) <= l3); ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    u3 >>>= v, l3 -= v, r3.back += v;
                  }
                  if (u3 >>>= _, l3 -= _, r3.back += _, 64 & g) {
                    e3.msg = "invalid distance code", r3.mode = 30;
                    break;
                  }
                  r3.offset = b, r3.extra = 15 & g, r3.mode = 24;
                case 24:
                  if (r3.extra) {
                    for (z = r3.extra; l3 < z; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    r3.offset += u3 & (1 << r3.extra) - 1, u3 >>>= r3.extra, l3 -= r3.extra, r3.back += r3.extra;
                  }
                  if (r3.offset > r3.dmax) {
                    e3.msg = "invalid distance too far back", r3.mode = 30;
                    break;
                  }
                  r3.mode = 25;
                case 25:
                  if (0 === h3)
                    break e;
                  if (d2 = c3 - h3, r3.offset > d2) {
                    if ((d2 = r3.offset - d2) > r3.whave && r3.sane) {
                      e3.msg = "invalid distance too far back", r3.mode = 30;
                      break;
                    }
                    p2 = d2 > r3.wnext ? (d2 -= r3.wnext, r3.wsize - d2) : r3.wnext - d2, d2 > r3.length && (d2 = r3.length), m = r3.window;
                  } else
                    m = i3, p2 = a3 - r3.offset, d2 = r3.length;
                  for (h3 < d2 && (d2 = h3), h3 -= d2, r3.length -= d2; i3[a3++] = m[p2++], --d2; )
                    ;
                  0 === r3.length && (r3.mode = 21);
                  break;
                case 26:
                  if (0 === h3)
                    break e;
                  i3[a3++] = r3.length, h3--, r3.mode = 21;
                  break;
                case 27:
                  if (r3.wrap) {
                    for (; l3 < 32; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 |= n3[s3++] << l3, l3 += 8;
                    }
                    if (c3 -= h3, e3.total_out += c3, r3.total += c3, c3 && (e3.adler = r3.check = r3.flags ? B(r3.check, i3, c3, a3 - c3) : O(r3.check, i3, c3, a3 - c3)), c3 = h3, (r3.flags ? u3 : L(u3)) !== r3.check) {
                      e3.msg = "incorrect data check", r3.mode = 30;
                      break;
                    }
                    l3 = u3 = 0;
                  }
                  r3.mode = 28;
                case 28:
                  if (r3.wrap && r3.flags) {
                    for (; l3 < 32; ) {
                      if (0 === o3)
                        break e;
                      o3--, u3 += n3[s3++] << l3, l3 += 8;
                    }
                    if (u3 !== (4294967295 & r3.total)) {
                      e3.msg = "incorrect length check", r3.mode = 30;
                      break;
                    }
                    l3 = u3 = 0;
                  }
                  r3.mode = 29;
                case 29:
                  x = 1;
                  break e;
                case 30:
                  x = -3;
                  break e;
                case 31:
                  return -4;
                case 32:
                default:
                  return U;
              }
          return e3.next_out = a3, e3.avail_out = h3, e3.next_in = s3, e3.avail_in = o3, r3.hold = u3, r3.bits = l3, (r3.wsize || c3 !== e3.avail_out && r3.mode < 30 && (r3.mode < 27 || 4 !== t3)) && Z(e3, e3.output, e3.next_out, c3 - e3.avail_out) ? (r3.mode = 31, -4) : (f3 -= e3.avail_in, c3 -= e3.avail_out, e3.total_in += f3, e3.total_out += c3, r3.total += c3, r3.wrap && c3 && (e3.adler = r3.check = r3.flags ? B(r3.check, i3, c3, e3.next_out - c3) : O(r3.check, i3, c3, e3.next_out - c3)), e3.data_type = r3.bits + (r3.last ? 64 : 0) + (12 === r3.mode ? 128 : 0) + (20 === r3.mode || 15 === r3.mode ? 256 : 0), (0 == f3 && 0 === c3 || 4 === t3) && x === N && (x = -5), x);
        }, r2.inflateEnd = function(e3) {
          if (!e3 || !e3.state)
            return U;
          var t3 = e3.state;
          return t3.window && (t3.window = null), e3.state = null, N;
        }, r2.inflateGetHeader = function(e3, t3) {
          var r3;
          return e3 && e3.state ? 0 == (2 & (r3 = e3.state).wrap) ? U : ((r3.head = t3).done = false, N) : U;
        }, r2.inflateSetDictionary = function(e3, t3) {
          var r3, n3 = t3.length;
          return e3 && e3.state ? 0 !== (r3 = e3.state).wrap && 11 !== r3.mode ? U : 11 === r3.mode && O(1, t3, n3, 0) !== r3.check ? -3 : Z(e3, t3, n3, n3) ? (r3.mode = 31, -4) : (r3.havedict = 1, N) : U;
        }, r2.inflateInfo = "pako inflate (from Nodeca project)";
      }, { "../utils/common": 41, "./adler32": 43, "./crc32": 45, "./inffast": 48, "./inftrees": 50 }], 50: [function(e2, t2, r2) {
        "use strict";
        var D = e2("../utils/common"), F = [3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0], N = [16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78], U = [1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0], P = [16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64];
        t2.exports = function(e3, t3, r3, n2, i2, s2, a2, o2) {
          var h2, u2, l2, f2, c2, d2, p2, m, _, g = o2.bits, b = 0, v = 0, y = 0, w = 0, k = 0, x = 0, S = 0, z = 0, C = 0, E = 0, A = null, I = 0, O = new D.Buf16(16), B = new D.Buf16(16), R = null, T = 0;
          for (b = 0; b <= 15; b++)
            O[b] = 0;
          for (v = 0; v < n2; v++)
            O[t3[r3 + v]]++;
          for (k = g, w = 15; 1 <= w && 0 === O[w]; w--)
            ;
          if (w < k && (k = w), 0 === w)
            return i2[s2++] = 20971520, i2[s2++] = 20971520, o2.bits = 1, 0;
          for (y = 1; y < w && 0 === O[y]; y++)
            ;
          for (k < y && (k = y), b = z = 1; b <= 15; b++)
            if (z <<= 1, (z -= O[b]) < 0)
              return -1;
          if (0 < z && (0 === e3 || 1 !== w))
            return -1;
          for (B[1] = 0, b = 1; b < 15; b++)
            B[b + 1] = B[b] + O[b];
          for (v = 0; v < n2; v++)
            0 !== t3[r3 + v] && (a2[B[t3[r3 + v]]++] = v);
          if (d2 = 0 === e3 ? (A = R = a2, 19) : 1 === e3 ? (A = F, I -= 257, R = N, T -= 257, 256) : (A = U, R = P, -1), b = y, c2 = s2, S = v = E = 0, l2 = -1, f2 = (C = 1 << (x = k)) - 1, 1 === e3 && 852 < C || 2 === e3 && 592 < C)
            return 1;
          for (; ; ) {
            for (p2 = b - S, _ = a2[v] < d2 ? (m = 0, a2[v]) : a2[v] > d2 ? (m = R[T + a2[v]], A[I + a2[v]]) : (m = 96, 0), h2 = 1 << b - S, y = u2 = 1 << x; i2[c2 + (E >> S) + (u2 -= h2)] = p2 << 24 | m << 16 | _ | 0, 0 !== u2; )
              ;
            for (h2 = 1 << b - 1; E & h2; )
              h2 >>= 1;
            if (0 !== h2 ? (E &= h2 - 1, E += h2) : E = 0, v++, 0 == --O[b]) {
              if (b === w)
                break;
              b = t3[r3 + a2[v]];
            }
            if (k < b && (E & f2) !== l2) {
              for (0 === S && (S = k), c2 += y, z = 1 << (x = b - S); x + S < w && !((z -= O[x + S]) <= 0); )
                x++, z <<= 1;
              if (C += 1 << x, 1 === e3 && 852 < C || 2 === e3 && 592 < C)
                return 1;
              i2[l2 = E & f2] = k << 24 | x << 16 | c2 - s2 | 0;
            }
          }
          return 0 !== E && (i2[c2 + E] = b - S << 24 | 64 << 16 | 0), o2.bits = k, 0;
        };
      }, { "../utils/common": 41 }], 51: [function(e2, t2, r2) {
        "use strict";
        t2.exports = { 2: "need dictionary", 1: "stream end", 0: "", "-1": "file error", "-2": "stream error", "-3": "data error", "-4": "insufficient memory", "-5": "buffer error", "-6": "incompatible version" };
      }, {}], 52: [function(e2, t2, r2) {
        "use strict";
        var i2 = e2("../utils/common"), o2 = 0, h2 = 1;
        function n2(e3) {
          for (var t3 = e3.length; 0 <= --t3; )
            e3[t3] = 0;
        }
        var s2 = 0, a2 = 29, u2 = 256, l2 = u2 + 1 + a2, f2 = 30, c2 = 19, _ = 2 * l2 + 1, g = 15, d2 = 16, p2 = 7, m = 256, b = 16, v = 17, y = 18, w = [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0], k = [0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13], x = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7], S = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15], z = new Array(2 * (l2 + 2));
        n2(z);
        var C = new Array(2 * f2);
        n2(C);
        var E = new Array(512);
        n2(E);
        var A = new Array(256);
        n2(A);
        var I = new Array(a2);
        n2(I);
        var O, B, R, T = new Array(f2);
        function D(e3, t3, r3, n3, i3) {
          this.static_tree = e3, this.extra_bits = t3, this.extra_base = r3, this.elems = n3, this.max_length = i3, this.has_stree = e3 && e3.length;
        }
        function F(e3, t3) {
          this.dyn_tree = e3, this.max_code = 0, this.stat_desc = t3;
        }
        function N(e3) {
          return e3 < 256 ? E[e3] : E[256 + (e3 >>> 7)];
        }
        function U(e3, t3) {
          e3.pending_buf[e3.pending++] = 255 & t3, e3.pending_buf[e3.pending++] = t3 >>> 8 & 255;
        }
        function P(e3, t3, r3) {
          e3.bi_valid > d2 - r3 ? (e3.bi_buf |= t3 << e3.bi_valid & 65535, U(e3, e3.bi_buf), e3.bi_buf = t3 >> d2 - e3.bi_valid, e3.bi_valid += r3 - d2) : (e3.bi_buf |= t3 << e3.bi_valid & 65535, e3.bi_valid += r3);
        }
        function L(e3, t3, r3) {
          P(e3, r3[2 * t3], r3[2 * t3 + 1]);
        }
        function j(e3, t3) {
          for (var r3 = 0; r3 |= 1 & e3, e3 >>>= 1, r3 <<= 1, 0 < --t3; )
            ;
          return r3 >>> 1;
        }
        function Z(e3, t3, r3) {
          var n3, i3, s3 = new Array(g + 1), a3 = 0;
          for (n3 = 1; n3 <= g; n3++)
            s3[n3] = a3 = a3 + r3[n3 - 1] << 1;
          for (i3 = 0; i3 <= t3; i3++) {
            var o3 = e3[2 * i3 + 1];
            0 !== o3 && (e3[2 * i3] = j(s3[o3]++, o3));
          }
        }
        function W(e3) {
          var t3;
          for (t3 = 0; t3 < l2; t3++)
            e3.dyn_ltree[2 * t3] = 0;
          for (t3 = 0; t3 < f2; t3++)
            e3.dyn_dtree[2 * t3] = 0;
          for (t3 = 0; t3 < c2; t3++)
            e3.bl_tree[2 * t3] = 0;
          e3.dyn_ltree[2 * m] = 1, e3.opt_len = e3.static_len = 0, e3.last_lit = e3.matches = 0;
        }
        function M(e3) {
          8 < e3.bi_valid ? U(e3, e3.bi_buf) : 0 < e3.bi_valid && (e3.pending_buf[e3.pending++] = e3.bi_buf), e3.bi_buf = 0, e3.bi_valid = 0;
        }
        function H(e3, t3, r3, n3) {
          var i3 = 2 * t3, s3 = 2 * r3;
          return e3[i3] < e3[s3] || e3[i3] === e3[s3] && n3[t3] <= n3[r3];
        }
        function G(e3, t3, r3) {
          for (var n3 = e3.heap[r3], i3 = r3 << 1; i3 <= e3.heap_len && (i3 < e3.heap_len && H(t3, e3.heap[i3 + 1], e3.heap[i3], e3.depth) && i3++, !H(t3, n3, e3.heap[i3], e3.depth)); )
            e3.heap[r3] = e3.heap[i3], r3 = i3, i3 <<= 1;
          e3.heap[r3] = n3;
        }
        function K(e3, t3, r3) {
          var n3, i3, s3, a3, o3 = 0;
          if (0 !== e3.last_lit)
            for (; n3 = e3.pending_buf[e3.d_buf + 2 * o3] << 8 | e3.pending_buf[e3.d_buf + 2 * o3 + 1], i3 = e3.pending_buf[e3.l_buf + o3], o3++, 0 === n3 ? L(e3, i3, t3) : (L(e3, (s3 = A[i3]) + u2 + 1, t3), 0 !== (a3 = w[s3]) && P(e3, i3 -= I[s3], a3), L(e3, s3 = N(--n3), r3), 0 !== (a3 = k[s3]) && P(e3, n3 -= T[s3], a3)), o3 < e3.last_lit; )
              ;
          L(e3, m, t3);
        }
        function Y(e3, t3) {
          var r3, n3, i3, s3 = t3.dyn_tree, a3 = t3.stat_desc.static_tree, o3 = t3.stat_desc.has_stree, h3 = t3.stat_desc.elems, u3 = -1;
          for (e3.heap_len = 0, e3.heap_max = _, r3 = 0; r3 < h3; r3++)
            0 !== s3[2 * r3] ? (e3.heap[++e3.heap_len] = u3 = r3, e3.depth[r3] = 0) : s3[2 * r3 + 1] = 0;
          for (; e3.heap_len < 2; )
            s3[2 * (i3 = e3.heap[++e3.heap_len] = u3 < 2 ? ++u3 : 0)] = 1, e3.depth[i3] = 0, e3.opt_len--, o3 && (e3.static_len -= a3[2 * i3 + 1]);
          for (t3.max_code = u3, r3 = e3.heap_len >> 1; 1 <= r3; r3--)
            G(e3, s3, r3);
          for (i3 = h3; r3 = e3.heap[1], e3.heap[1] = e3.heap[e3.heap_len--], G(e3, s3, 1), n3 = e3.heap[1], e3.heap[--e3.heap_max] = r3, e3.heap[--e3.heap_max] = n3, s3[2 * i3] = s3[2 * r3] + s3[2 * n3], e3.depth[i3] = (e3.depth[r3] >= e3.depth[n3] ? e3.depth[r3] : e3.depth[n3]) + 1, s3[2 * r3 + 1] = s3[2 * n3 + 1] = i3, e3.heap[1] = i3++, G(e3, s3, 1), 2 <= e3.heap_len; )
            ;
          e3.heap[--e3.heap_max] = e3.heap[1], function(e4, t4) {
            var r4, n4, i4, s4, a4, o4, h4 = t4.dyn_tree, u4 = t4.max_code, l3 = t4.stat_desc.static_tree, f3 = t4.stat_desc.has_stree, c3 = t4.stat_desc.extra_bits, d3 = t4.stat_desc.extra_base, p3 = t4.stat_desc.max_length, m2 = 0;
            for (s4 = 0; s4 <= g; s4++)
              e4.bl_count[s4] = 0;
            for (h4[2 * e4.heap[e4.heap_max] + 1] = 0, r4 = e4.heap_max + 1; r4 < _; r4++)
              p3 < (s4 = h4[2 * h4[2 * (n4 = e4.heap[r4]) + 1] + 1] + 1) && (s4 = p3, m2++), h4[2 * n4 + 1] = s4, u4 < n4 || (e4.bl_count[s4]++, a4 = 0, d3 <= n4 && (a4 = c3[n4 - d3]), o4 = h4[2 * n4], e4.opt_len += o4 * (s4 + a4), f3 && (e4.static_len += o4 * (l3[2 * n4 + 1] + a4)));
            if (0 !== m2) {
              do {
                for (s4 = p3 - 1; 0 === e4.bl_count[s4]; )
                  s4--;
                e4.bl_count[s4]--, e4.bl_count[s4 + 1] += 2, e4.bl_count[p3]--, m2 -= 2;
              } while (0 < m2);
              for (s4 = p3; 0 !== s4; s4--)
                for (n4 = e4.bl_count[s4]; 0 !== n4; )
                  u4 < (i4 = e4.heap[--r4]) || (h4[2 * i4 + 1] !== s4 && (e4.opt_len += (s4 - h4[2 * i4 + 1]) * h4[2 * i4], h4[2 * i4 + 1] = s4), n4--);
            }
          }(e3, t3), Z(s3, u3, e3.bl_count);
        }
        function X(e3, t3, r3) {
          var n3, i3, s3 = -1, a3 = t3[1], o3 = 0, h3 = 7, u3 = 4;
          for (0 === a3 && (h3 = 138, u3 = 3), t3[2 * (r3 + 1) + 1] = 65535, n3 = 0; n3 <= r3; n3++)
            i3 = a3, a3 = t3[2 * (n3 + 1) + 1], ++o3 < h3 && i3 === a3 || (o3 < u3 ? e3.bl_tree[2 * i3] += o3 : 0 !== i3 ? (i3 !== s3 && e3.bl_tree[2 * i3]++, e3.bl_tree[2 * b]++) : o3 <= 10 ? e3.bl_tree[2 * v]++ : e3.bl_tree[2 * y]++, s3 = i3, u3 = (o3 = 0) === a3 ? (h3 = 138, 3) : i3 === a3 ? (h3 = 6, 3) : (h3 = 7, 4));
        }
        function V(e3, t3, r3) {
          var n3, i3, s3 = -1, a3 = t3[1], o3 = 0, h3 = 7, u3 = 4;
          for (0 === a3 && (h3 = 138, u3 = 3), n3 = 0; n3 <= r3; n3++)
            if (i3 = a3, a3 = t3[2 * (n3 + 1) + 1], !(++o3 < h3 && i3 === a3)) {
              if (o3 < u3)
                for (; L(e3, i3, e3.bl_tree), 0 != --o3; )
                  ;
              else
                0 !== i3 ? (i3 !== s3 && (L(e3, i3, e3.bl_tree), o3--), L(e3, b, e3.bl_tree), P(e3, o3 - 3, 2)) : o3 <= 10 ? (L(e3, v, e3.bl_tree), P(e3, o3 - 3, 3)) : (L(e3, y, e3.bl_tree), P(e3, o3 - 11, 7));
              s3 = i3, u3 = (o3 = 0) === a3 ? (h3 = 138, 3) : i3 === a3 ? (h3 = 6, 3) : (h3 = 7, 4);
            }
        }
        n2(T);
        var q = false;
        function J(e3, t3, r3, n3) {
          P(e3, (s2 << 1) + (n3 ? 1 : 0), 3), function(e4, t4, r4, n4) {
            M(e4), n4 && (U(e4, r4), U(e4, ~r4)), i2.arraySet(e4.pending_buf, e4.window, t4, r4, e4.pending), e4.pending += r4;
          }(e3, t3, r3, true);
        }
        r2._tr_init = function(e3) {
          q || (function() {
            var e4, t3, r3, n3, i3, s3 = new Array(g + 1);
            for (n3 = r3 = 0; n3 < a2 - 1; n3++)
              for (I[n3] = r3, e4 = 0; e4 < 1 << w[n3]; e4++)
                A[r3++] = n3;
            for (A[r3 - 1] = n3, n3 = i3 = 0; n3 < 16; n3++)
              for (T[n3] = i3, e4 = 0; e4 < 1 << k[n3]; e4++)
                E[i3++] = n3;
            for (i3 >>= 7; n3 < f2; n3++)
              for (T[n3] = i3 << 7, e4 = 0; e4 < 1 << k[n3] - 7; e4++)
                E[256 + i3++] = n3;
            for (t3 = 0; t3 <= g; t3++)
              s3[t3] = 0;
            for (e4 = 0; e4 <= 143; )
              z[2 * e4 + 1] = 8, e4++, s3[8]++;
            for (; e4 <= 255; )
              z[2 * e4 + 1] = 9, e4++, s3[9]++;
            for (; e4 <= 279; )
              z[2 * e4 + 1] = 7, e4++, s3[7]++;
            for (; e4 <= 287; )
              z[2 * e4 + 1] = 8, e4++, s3[8]++;
            for (Z(z, l2 + 1, s3), e4 = 0; e4 < f2; e4++)
              C[2 * e4 + 1] = 5, C[2 * e4] = j(e4, 5);
            O = new D(z, w, u2 + 1, l2, g), B = new D(C, k, 0, f2, g), R = new D(new Array(0), x, 0, c2, p2);
          }(), q = true), e3.l_desc = new F(e3.dyn_ltree, O), e3.d_desc = new F(e3.dyn_dtree, B), e3.bl_desc = new F(e3.bl_tree, R), e3.bi_buf = 0, e3.bi_valid = 0, W(e3);
        }, r2._tr_stored_block = J, r2._tr_flush_block = function(e3, t3, r3, n3) {
          var i3, s3, a3 = 0;
          0 < e3.level ? (2 === e3.strm.data_type && (e3.strm.data_type = function(e4) {
            var t4, r4 = 4093624447;
            for (t4 = 0; t4 <= 31; t4++, r4 >>>= 1)
              if (1 & r4 && 0 !== e4.dyn_ltree[2 * t4])
                return o2;
            if (0 !== e4.dyn_ltree[18] || 0 !== e4.dyn_ltree[20] || 0 !== e4.dyn_ltree[26])
              return h2;
            for (t4 = 32; t4 < u2; t4++)
              if (0 !== e4.dyn_ltree[2 * t4])
                return h2;
            return o2;
          }(e3)), Y(e3, e3.l_desc), Y(e3, e3.d_desc), a3 = function(e4) {
            var t4;
            for (X(e4, e4.dyn_ltree, e4.l_desc.max_code), X(e4, e4.dyn_dtree, e4.d_desc.max_code), Y(e4, e4.bl_desc), t4 = c2 - 1; 3 <= t4 && 0 === e4.bl_tree[2 * S[t4] + 1]; t4--)
              ;
            return e4.opt_len += 3 * (t4 + 1) + 5 + 5 + 4, t4;
          }(e3), i3 = e3.opt_len + 3 + 7 >>> 3, (s3 = e3.static_len + 3 + 7 >>> 3) <= i3 && (i3 = s3)) : i3 = s3 = r3 + 5, r3 + 4 <= i3 && -1 !== t3 ? J(e3, t3, r3, n3) : 4 === e3.strategy || s3 === i3 ? (P(e3, 2 + (n3 ? 1 : 0), 3), K(e3, z, C)) : (P(e3, 4 + (n3 ? 1 : 0), 3), function(e4, t4, r4, n4) {
            var i4;
            for (P(e4, t4 - 257, 5), P(e4, r4 - 1, 5), P(e4, n4 - 4, 4), i4 = 0; i4 < n4; i4++)
              P(e4, e4.bl_tree[2 * S[i4] + 1], 3);
            V(e4, e4.dyn_ltree, t4 - 1), V(e4, e4.dyn_dtree, r4 - 1);
          }(e3, e3.l_desc.max_code + 1, e3.d_desc.max_code + 1, a3 + 1), K(e3, e3.dyn_ltree, e3.dyn_dtree)), W(e3), n3 && M(e3);
        }, r2._tr_tally = function(e3, t3, r3) {
          return e3.pending_buf[e3.d_buf + 2 * e3.last_lit] = t3 >>> 8 & 255, e3.pending_buf[e3.d_buf + 2 * e3.last_lit + 1] = 255 & t3, e3.pending_buf[e3.l_buf + e3.last_lit] = 255 & r3, e3.last_lit++, 0 === t3 ? e3.dyn_ltree[2 * r3]++ : (e3.matches++, t3--, e3.dyn_ltree[2 * (A[r3] + u2 + 1)]++, e3.dyn_dtree[2 * N(t3)]++), e3.last_lit === e3.lit_bufsize - 1;
        }, r2._tr_align = function(e3) {
          P(e3, 2, 3), L(e3, m, z), function(e4) {
            16 === e4.bi_valid ? (U(e4, e4.bi_buf), e4.bi_buf = 0, e4.bi_valid = 0) : 8 <= e4.bi_valid && (e4.pending_buf[e4.pending++] = 255 & e4.bi_buf, e4.bi_buf >>= 8, e4.bi_valid -= 8);
          }(e3);
        };
      }, { "../utils/common": 41 }], 53: [function(e2, t2, r2) {
        "use strict";
        t2.exports = function() {
          this.input = null, this.next_in = 0, this.avail_in = 0, this.total_in = 0, this.output = null, this.next_out = 0, this.avail_out = 0, this.total_out = 0, this.msg = "", this.state = null, this.data_type = 2, this.adler = 0;
        };
      }, {}], 54: [function(e2, t2, r2) {
        (function(e3) {
          !function(r3, n2) {
            "use strict";
            if (!r3.setImmediate) {
              var i2, s2, t3, a2, o2 = 1, h2 = {}, u2 = false, l2 = r3.document, e4 = Object.getPrototypeOf && Object.getPrototypeOf(r3);
              e4 = e4 && e4.setTimeout ? e4 : r3, i2 = "[object process]" === {}.toString.call(r3.process) ? function(e5) {
                process$1.nextTick(function() {
                  c2(e5);
                });
              } : function() {
                if (r3.postMessage && !r3.importScripts) {
                  var e5 = true, t4 = r3.onmessage;
                  return r3.onmessage = function() {
                    e5 = false;
                  }, r3.postMessage("", "*"), r3.onmessage = t4, e5;
                }
              }() ? (a2 = "setImmediate$" + Math.random() + "$", r3.addEventListener ? r3.addEventListener("message", d2, false) : r3.attachEvent("onmessage", d2), function(e5) {
                r3.postMessage(a2 + e5, "*");
              }) : r3.MessageChannel ? ((t3 = new MessageChannel()).port1.onmessage = function(e5) {
                c2(e5.data);
              }, function(e5) {
                t3.port2.postMessage(e5);
              }) : l2 && "onreadystatechange" in l2.createElement("script") ? (s2 = l2.documentElement, function(e5) {
                var t4 = l2.createElement("script");
                t4.onreadystatechange = function() {
                  c2(e5), t4.onreadystatechange = null, s2.removeChild(t4), t4 = null;
                }, s2.appendChild(t4);
              }) : function(e5) {
                setTimeout(c2, 0, e5);
              }, e4.setImmediate = function(e5) {
                "function" != typeof e5 && (e5 = new Function("" + e5));
                for (var t4 = new Array(arguments.length - 1), r4 = 0; r4 < t4.length; r4++)
                  t4[r4] = arguments[r4 + 1];
                var n3 = { callback: e5, args: t4 };
                return h2[o2] = n3, i2(o2), o2++;
              }, e4.clearImmediate = f2;
            }
            function f2(e5) {
              delete h2[e5];
            }
            function c2(e5) {
              if (u2)
                setTimeout(c2, 0, e5);
              else {
                var t4 = h2[e5];
                if (t4) {
                  u2 = true;
                  try {
                    !function(e6) {
                      var t5 = e6.callback, r4 = e6.args;
                      switch (r4.length) {
                        case 0:
                          t5();
                          break;
                        case 1:
                          t5(r4[0]);
                          break;
                        case 2:
                          t5(r4[0], r4[1]);
                          break;
                        case 3:
                          t5(r4[0], r4[1], r4[2]);
                          break;
                        default:
                          t5.apply(n2, r4);
                      }
                    }(t4);
                  } finally {
                    f2(e5), u2 = false;
                  }
                }
              }
            }
            function d2(e5) {
              e5.source === r3 && "string" == typeof e5.data && 0 === e5.data.indexOf(a2) && c2(+e5.data.slice(a2.length));
            }
          }("undefined" == typeof self ? void 0 === e3 ? this : e3 : self);
        }).call(this, "undefined" != typeof commonjsGlobal ? commonjsGlobal : "undefined" != typeof self ? self : "undefined" != typeof window ? window : {});
      }, {}] }, {}, [10])(10);
    });
  })(jszip_min$1, jszip_min$1.exports);
  var jszip_minExports = jszip_min$1.exports;
  const JSZip = /* @__PURE__ */ getDefaultExportFromCjs$1(jszip_minExports);
  class BackupFileParser {
    /**
     * 创建用于验证数据对象
     */
    createHash(data2) {
      const length = data2.length;
      const keys = [];
      let result2 = {
        hash: "",
        keyMap: [],
        length
      };
      for (let n2 = 0; n2 < 32; n2++) {
        let index2 = Math.round(length * Math.random());
        keys.push(data2.substr(index2, 1));
        result2.keyMap.push(index2);
      }
      result2.hash = cryptoJsExports.MD5(keys.join("")).toString();
      return result2;
    }
    /**
     * 获取备份数据
     */
    createBackupFileBlob(rawData) {
      return new Promise((resolve2, reject2) => {
        try {
          const zip = new JSZip();
          if (rawData.options.system) {
            delete rawData.options.system;
          }
          const _options2 = rawData.options;
          const secretKey = _options2.encryptBackupData ? _options2.encryptSecretKey : "";
          if (_options2.encryptSecretKey) {
            delete rawData.options.encryptSecretKey;
          }
          const options2 = this.encryptData(rawData.options, secretKey);
          const userData = this.encryptData(rawData.userData, secretKey);
          zip.file("options.json", options2);
          zip.file("userdatas.json", userData);
          const manifest = {
            checkInfo: this.createHash(options2 + userData),
            version: PPF.getVersion(),
            time: (/* @__PURE__ */ new Date()).getTime(),
            encryptMode: secretKey ? EEncryptMode.AES : ""
          };
          zip.file("manifest.json", JSON.stringify(manifest));
          if (rawData.collection) {
            zip.file(
              "collection.json",
              this.encryptData(rawData.collection, secretKey)
            );
          }
          if (rawData.cookies) {
            zip.file(
              "cookies.json",
              this.encryptData(rawData.cookies, secretKey)
            );
          }
          if (rawData.searchResultSnapshot) {
            zip.file(
              "searchResultSnapshot.json",
              this.encryptData(rawData.searchResultSnapshot, secretKey)
            );
          }
          if (rawData.keepUploadTask) {
            zip.file(
              "keepUploadTask.json",
              this.encryptData(rawData.keepUploadTask, secretKey)
            );
          }
          if (rawData.downloadHistory) {
            zip.file(
              "downloadHistory.json",
              this.encryptData(rawData.downloadHistory, secretKey)
            );
          }
          zip.generateAsync({
            type: "blob",
            compression: "DEFLATE",
            // level 范围： 1-9 ，9为最高压缩比
            compressionOptions: {
              level: 9
            }
          }).then((blob) => {
            resolve2(blob);
          });
        } catch (error) {
          reject2(error);
        }
      });
    }
    /**
     * 加载备份数据
     * @param data
     * @param secretKeyTitle
     * @param secretKey
     */
    loadZipData(data2, secretKeyTitle = "请输入密钥：", secretKey = "") {
      return new Promise((resolve2, reject2) => {
        JSZip.loadAsync(data2).then((zip) => {
          let requests2 = [];
          requests2.push(zip.file("manifest.json").async("text"));
          requests2.push(zip.file("options.json").async("text"));
          requests2.push(zip.file("userdatas.json").async("text"));
          if (zip.file("collection.json")) {
            requests2.push(zip.file("collection.json").async("text"));
          }
          if (zip.file("cookies.json")) {
            requests2.push(zip.file("cookies.json").async("text"));
          }
          if (zip.file("searchResultSnapshot.json")) {
            requests2.push(zip.file("searchResultSnapshot.json").async("text"));
          }
          if (zip.file("keepUploadTask.json")) {
            requests2.push(zip.file("keepUploadTask.json").async("text"));
          }
          if (zip.file("downloadHistory.json")) {
            requests2.push(zip.file("downloadHistory.json").async("text"));
          }
          return Promise.all(requests2);
        }).then((results2) => {
          const manifest = JSON.parse(results2[0]);
          console.log(manifest);
          if (manifest.encryptMode) {
            if (secretKey) {
              if (this.decryptData(results2[1], secretKey) === null) {
                secretKey = "";
              }
            }
            if (!secretKey) {
              let tmpSecretKey = window.prompt(secretKeyTitle);
              if (!tmpSecretKey) {
                reject2(ERestoreError.needSecretKey);
                return;
              }
              secretKey = tmpSecretKey;
              let test = this.decryptData(results2[1], secretKey);
              if (test === null) {
                reject2(ERestoreError.errorSecretKey);
                return;
              }
            }
          } else {
            secretKey = "";
          }
          const result2 = {
            manifest,
            options: this.decryptData(results2[1], secretKey),
            datas: this.decryptData(results2[2], secretKey)
          };
          if (results2.length > 3) {
            result2["collection"] = this.decryptData(results2[3], secretKey);
          }
          if (results2.length > 4 && PPF.checkOptionalPermission("cookies")) {
            result2["cookies"] = this.decryptData(results2[4], secretKey);
          }
          if (results2.length > 5) {
            result2["searchResultSnapshot"] = this.decryptData(
              results2[5],
              secretKey
            );
          }
          if (results2.length > 6) {
            result2["keepUploadTask"] = this.decryptData(results2[6], secretKey);
          }
          if (results2.length > 7) {
            result2["downloadHistory"] = this.decryptData(results2[7], secretKey);
          }
          if (this.checkData(result2.manifest, results2[1] + results2[2])) {
            resolve2(result2);
          } else {
            reject2("error");
          }
        }).catch((error) => {
          console.log(error);
          reject2(error);
        });
      });
    }
    /**
     * 简单验证数据，仅防止格式错误的数据
     */
    checkData(manifest, data2) {
      if (!manifest) {
        return false;
      }
      if (!manifest.checkInfo) {
        return false;
      }
      const checkInfo = manifest.checkInfo;
      const length = data2.length;
      if (length !== checkInfo.length) {
        return false;
      }
      const keys = [];
      try {
        if (checkInfo.keyMap.length !== 32) {
          return false;
        }
        for (let n2 = 0; n2 < 32; n2++) {
          let index2 = checkInfo.keyMap[n2];
          keys.push(data2.substr(index2, 1));
        }
        if (cryptoJsExports.MD5(keys.join("")).toString() === checkInfo.hash) {
          return true;
        }
      } catch (error) {
      }
      return false;
    }
    /**
     * 加密数据
     * @param data 原始数据，JS对象
     * @param secretKey 密钥，如果不指定，则不加密
     */
    encryptData(data2, secretKey = "") {
      if (!secretKey) {
        return JSON.stringify(data2);
      }
      return this.encrypt(JSON.stringify(data2), secretKey);
    }
    /**
     * 解密数据
     * @param data 已加密的数据
     * @param secretKey 密钥，如果不指定，则直接使用 JSON.parse 返回
     */
    decryptData(data2, secretKey = "") {
      if (!secretKey) {
        return JSON.parse(data2);
      }
      try {
        return JSON.parse(this.decrypt(data2, secretKey));
      } catch (error) {
        return null;
      }
    }
    /**
     * 以 AES 方式加密数据
     * @param data 原数据
     * @param secretKey 密钥
     */
    encrypt(data2, secretKey = "") {
      return cryptoJsExports.AES.encrypt(data2, secretKey).toString();
    }
    /**
     * 以 AES 方式解密数据
     * @param data 已加密的数据
     * @param secretKey 密钥
     */
    decrypt(data2, secretKey = "") {
      return cryptoJsExports.AES.decrypt(data2, secretKey).toString(cryptoJsExports.enc.Utf8);
    }
  }
  class Config {
    constructor(service) {
      this.service = service;
      this.name = EConfigKey.default;
      this.localStorage = new localStorage();
      this.syncStorage = new SyncStorage();
      this.favicon = new Favicon(this.service);
      this.schemas = [];
      this.sites = [];
      this.clients = [];
      this.publicSites = [];
      this.requestCount = 0;
      this.backupFileParser = new BackupFileParser();
      this.options = {
        exceedSizeUnit: ESizeUnit.GiB,
        sites: [],
        clients: [],
        backupServers: [],
        system: {},
        allowDropToSend: true,
        allowSelectionTextSearch: true,
        needConfirmWhenExceedSize: true,
        exceedSize: 10,
        search: {
          rows: 50,
          // 搜索超时
          timeout: 3e4,
          saveKey: true
        },
        // 连接下载服务器超时时间（毫秒）
        connectClientTimeout: 3e4,
        rowsPerPageItems: [
          10,
          20,
          50,
          100,
          200,
          { text: "$vuetify.dataIterator.rowsPerPageAll", value: -1 }
        ],
        searchSolutions: [],
        navBarIsOpen: true,
        showMovieInfoCardOnSearch: true,
        beforeSearchingOptions: {
          getMovieInformation: true,
          maxMovieInformationCount: 5,
          searchModeForItem: EBeforeSearchingItemSearchMode.id
        },
        showToolbarOnContentPage: true,
        // 下载失败后是否进行重试
        downloadFailedRetry: false,
        // 下载失败重试次数
        downloadFailedFailedRetryCount: 3,
        // 下载失败间隔时间（秒）
        downloadFailedFailedRetryInterval: 5,
        // 批量下载时间间隔（秒）
        batchDownloadInterval: 0,
        // 启用后台下载任务
        enableBackgroundDownload: false,
        // 助手工具栏显示位置
        position: EPluginPosition.right,
        // 是否加密存储备份数据
        encryptBackupData: false,
        allowSaveSnapshot: true
      };
      this.uiOptions = {};
      this.reload();
    }
    reload() {
      APP.cache.clear();
      this.getSystemConfig();
    }
    /**
     * 保存配置
     * @param options 配置信息
     */
    save(options2) {
      if (options2) {
        this.options = options2;
      }
      this.localStorage.set(this.name, this.cleaningOptions(this.options));
    }
    /**
     * 获取站点图标并缓存
     */
    getFavicons() {
      return new Promise((resolve2, reject2) => {
        let urls = [];
        this.sites.forEach((site2) => {
          urls.push(site2.activeURL || site2.url || "");
        });
        if (this.options.sites) {
          this.options.sites.forEach((site2) => {
            urls.push(site2.activeURL || site2.url || "");
          });
        }
        urls = [...new Set(urls)];
        this.favicon.gets(urls).then((results2) => {
          results2.forEach((result2) => {
            let site2 = this.options.sites.find((item) => {
              var _a;
              let cdn = [item.url].concat(item.cdn);
              cdn = cdn.concat((_a = item.formerHosts) == null ? void 0 : _a.map((x) => `//${x}`)).filter((_) => !!_);
              return item.host == result2.host || cdn.join("").indexOf(`//${result2.host}`) > -1;
            });
            if (site2) {
              site2.icon = result2.data;
            }
          });
          this.save();
          this.service.options = this.options;
          resolve2(this.options);
        }).catch((error) => {
          this.service.debug(error);
          reject2(error);
        });
      });
    }
    /**
     * 获取单个站点图标
     * @param url
     */
    getFavicon(url2, reset = false) {
      return new Promise((resolve2, reject2) => {
        this.favicon.get(url2, reset).then((result2) => {
          let site2 = this.options.sites.find((item) => {
            var _a;
            let cdn = [item.url].concat(item.cdn, (_a = item.formerHosts) == null ? void 0 : _a.map((x) => `//${x}`));
            return item.host == result2.host || cdn.join("").indexOf(`//${result2.host}`) > -1;
          });
          if (site2) {
            site2.icon = result2.data;
            this.save();
            this.service.options = this.options;
          }
          resolve2(result2);
        }).catch((error) => {
          this.service.debug(error);
          reject2(error);
        });
      });
    }
    /**
     * 清理参数配置，一些参数只需要运行时可用即可
     * @param options
     */
    cleaningOptions(options2) {
      let _options2 = JSON.parse(JSON.stringify(options2));
      if (_options2.sites) {
        _options2.sites.forEach((item) => {
          let systemSite = this.sites.find((site2) => {
            return site2.host == item.host;
          });
          if (systemSite) {
            [
              "categories",
              "selectors",
              "patterns",
              "torrentTagSelectors",
              "icon",
              "activeURL",
              "searchEntryConfig",
              "schema",
              "supportedFeatures",
              "mergeSchemaTagSelectors"
            ].forEach((key2) => {
              let _item = item;
              if (_item[key2]) {
                delete _item[key2];
              }
            });
            if (item.searchEntry) {
              item.searchEntry.forEach((entry2, index2) => {
                if (!entry2.isCustom) {
                  item.searchEntry[index2] = {
                    name: entry2.name,
                    enabled: entry2.enabled
                  };
                }
              });
            }
          }
          if (PPF.isExtensionMode && item.icon && item.icon.substr(0, 10) === "data:image") {
            delete item.icon;
          }
        });
      }
      if (_options2.clients) {
        _options2.clients.forEach((item) => {
          [
            "pathDescription",
            "description",
            "warning",
            "scripts",
            "ver",
            "icon"
          ].forEach((key2) => {
            if (item[key2]) {
              delete item[key2];
            }
          });
        });
      }
      return _options2;
    }
    /**
     * 读取配置信息
     * @return Promise 配置信息
     */
    read() {
      return new Promise((resolve2, reject2) => {
        this.localStorage.get(EConfigKey.uiOptions, (result2) => {
          if (result2) {
            let defaultOptions = Object.assign({}, this.uiOptions);
            this.uiOptions = Object.assign(defaultOptions, result2);
          }
        });
        this.loadConfig(resolve2);
      });
    }
    /**
     * 加载配置
     * @param success
     */
    loadConfig(success) {
      if (this.requestCount > 0) {
        setTimeout(() => {
          this.loadConfig(success);
        }, 100);
        return;
      }
      this.localStorage.get(this.name, (result2) => {
        this.resetRunTimeOptions(result2);
        success && success(this.options);
      });
    }
    /**
     * 重置运行时配置
     * @param options
     */
    resetRunTimeOptions(options2) {
      if (options2) {
        if (options2.system) {
          delete options2.system;
        }
        let defaultOptions = Object.assign({}, this.options);
        this.options = Object.assign(defaultOptions, options2);
      }
      if (!this.options.locale) {
        this.options.locale = navigator.language || "zh-CN";
      }
      this.options.system = {
        schemas: this.schemas,
        sites: this.sites,
        clients: this.clients,
        publicSites: this.publicSites
      };
      this.upgradeSites();
      this.options.sites && this.options.sites.length && this.sites.forEach((systemSite) => {
        let index2 = this.options.sites.findIndex((site2) => {
          return site2.host === systemSite.host;
        });
        if (index2 > -1) {
          let _site = Object.assign(
            Object.assign({}, systemSite),
            this.options.sites[index2]
          );
          if (systemSite.categories) {
            _site.categories = systemSite.categories;
          }
          if (systemSite.schema) {
            _site.schema = systemSite.schema;
          }
          if (!systemSite.torrentTagSelectors && _site.torrentTagSelectors) {
            delete _site.torrentTagSelectors;
          } else {
            _site.torrentTagSelectors = systemSite.torrentTagSelectors;
          }
          if (!systemSite.patterns && _site.patterns) {
            delete _site.patterns;
          } else {
            _site.patterns = systemSite.patterns;
          }
          if (!systemSite.levelRequirements && _site.levelRequirements) {
            delete _site.levelRequirements;
          } else {
            _site.levelRequirements = systemSite.levelRequirements;
          }
          if (_site.searchEntry && systemSite.searchEntry) {
            systemSite.searchEntry.forEach((sysEntry) => {
              if (_site.searchEntry) {
                let _index = _site.searchEntry && _site.searchEntry.findIndex((entry2) => {
                  return entry2.name == sysEntry.name && !entry2.isCustom;
                });
                if (_index != void 0 && _index > -1) {
                  _site.searchEntry[_index] = Object.assign(
                    Object.assign({}, sysEntry),
                    {
                      enabled: _site.searchEntry[_index].enabled
                    }
                  );
                } else {
                  _site.searchEntry.push(Object.assign({}, sysEntry));
                }
              }
            });
          } else if (systemSite.searchEntry) {
            _site.searchEntry = systemSite.searchEntry;
          }
          if (!systemSite.icon && !_site.icon) {
            _site.icon = _site.url + "/favicon.ico";
          }
          this.options.sites[index2] = _site;
        }
      });
      this.options.sites.forEach((site2) => {
        if (site2.cdn && site2.cdn.length > 0) {
          site2.activeURL = site2.cdn[0];
          site2.cdn = this.arrayUnique(site2.cdn);
        } else {
          site2.activeURL = site2.url;
        }
        if (site2.priority == null) {
          site2.priority = 100;
        }
      });
      this.options.clients && this.options.clients.length && this.options.clients.forEach((item, index2) => {
        let client2 = this.clients.find((c2) => {
          return c2.type === item.type;
        });
        if (client2) {
          this.options.clients[index2] = Object.assign(
            Object.assign({}, client2),
            this.options.clients[index2]
          );
        }
      });
      if (PPF.isExtensionMode) {
        this.getFavicons();
      }
      console.log(this.options);
    }
    /**
     * 数组去重
     * @param source 源数组
     * @see https://www.cnblogs.com/wisewrong/p/9642264.html （性能比较）
     */
    arrayUnique(source2) {
      let result2 = [];
      let obj = {};
      source2.forEach((value) => {
        if (!obj[value]) {
          result2.push(value);
          obj[value] = 1;
        }
      });
      return result2;
    }
    /**
     * 升级网站信息
     */
    upgradeSites() {
      this.sites.forEach((systemSite) => {
        if (!systemSite.host) {
          return;
        }
        let formerHosts = systemSite.formerHosts;
        let newHost = systemSite.host;
        if (formerHosts && formerHosts.length > 0) {
          formerHosts.forEach((host2) => {
            let site2 = this.options.sites.find((site22) => {
              return site22.host === host2;
            });
            if (site2) {
              console.log("upgradeSites.site", site2, newHost);
              site2.host = newHost;
              site2.url = systemSite.url;
              if (!systemSite.icon && !site2.icon)
                site2.icon = site2.url + "/favicon.ico";
              else
                site2.icon = systemSite.icon;
            }
            if (this.options.searchSolutions) {
              this.options.searchSolutions.forEach(
                (soluteion) => {
                  soluteion.range.forEach((range) => {
                    if (range.host == host2) {
                      console.log(
                        "upgradeSites.searchSolutions",
                        range.host,
                        newHost
                      );
                      range.host = newHost;
                    }
                  });
                }
              );
            }
            if (this.options.clients && this.options.clients.length > 0) {
              this.options.clients.forEach((client2) => {
                let paths = client2.paths;
                if (paths) {
                  for (const key2 in paths) {
                    if (key2 == host2 && paths.hasOwnProperty(key2)) {
                      console.log(
                        "upgradeSites.client.paths",
                        client2.name,
                        key2,
                        newHost
                      );
                      const element = paths[key2];
                      paths[newHost] = Object.assign([], element);
                      delete paths[key2];
                    }
                  }
                }
              });
            }
          });
        }
      });
    }
    readUIOptions() {
      return new Promise((resolve2, reject2) => {
        this.localStorage.get(EConfigKey.uiOptions, (result2) => {
          if (result2) {
            let defaultOptions = Object.assign({}, this.uiOptions);
            this.uiOptions = Object.assign(defaultOptions, result2);
          }
          resolve2(this.uiOptions);
        });
      });
    }
    saveUIOptions(options2) {
      return new Promise((resolve2, reject2) => {
        this.localStorage.set(EConfigKey.uiOptions, options2 || this.uiOptions);
        resolve2();
      });
    }
    /**
     * 获取系统配置
     */
    getSystemConfig() {
      this.schemas = [];
      this.sites = [];
      this.clients = [];
      this.publicSites = [];
      this.getContentFromApi(`${API.systemConfig}`).then((result2) => {
        if (result2) {
          this.schemas = result2.schemas;
          this.sites = result2.sites;
          this.clients = result2.clients;
          this.publicSites = result2.publicSites;
        }
      });
    }
    /**
     * 获取支持的网站架构
     */
    getSchemas() {
      this.schemas = [];
      this.getContentFromApi(`${API.schemas}`).then((result2) => {
        if (result2.length) {
          result2.forEach((item) => {
            if (item.type === "dir") {
              this.addSchema(
                API.schemaConfig.replace(/\{\$schema\}/g, item.name)
              );
            }
          });
        }
      });
    }
    addSchema(path2) {
      this.getContentFromApi(path2).then((result2) => {
        if (result2 && result2.name) {
          this.schemas.push(result2);
        }
      });
    }
    getSites() {
      this.sites = [];
      this.getContentFromApi(API.sites).then((result2) => {
        if (result2.length) {
          result2.forEach((item) => {
            if (item.type === "dir") {
              this.addSite(API.siteConfig.replace(/\{\$site\}/g, item.name));
            }
          });
        }
      });
    }
    addSite(path2) {
      this.getContentFromApi(path2).then((result2) => {
        if (result2 && result2.name) {
          this.sites.push(result2);
        }
      });
    }
    getClients() {
      this.clients = [];
      this.getContentFromApi(API.clients).then((result2) => {
        if (result2.length) {
          result2.forEach((item) => {
            if (item.type === "dir") {
              this.addClient(
                API.clientConfig.replace(/\{\$client\}/g, item.name)
              );
            }
          });
        }
      });
    }
    addClient(path2) {
      this.getContentFromApi(path2).then((result2) => {
        if (result2 && result2.name) {
          this.clients.push(result2);
        }
      });
    }
    /**
     * 从远程请求指定的内容
     * @param api
     */
    getContentFromApi(api) {
      PPF.updateBadge(++this.requestCount);
      return new Promise((resolve2, reject2) => {
        let content2 = APP.cache.get(api);
        if (content2) {
          resolve2(content2);
          PPF.updateBadge(--this.requestCount);
          return;
        }
        $.getJSON(api).done((result2) => {
          APP.cache.set(api, result2);
          PPF.updateBadge(--this.requestCount);
          resolve2(result2);
        }).fail((result2) => {
          PPF.updateBadge(--this.requestCount);
          reject2 && reject2(result2);
        });
      });
    }
    /**
     * 将系统参数备份到Google
     */
    backupToGoogle() {
      return new Promise((resolve2, reject2) => {
        if (chrome.storage && chrome.storage.sync) {
          let options2 = this.cleaningOptions(this.options);
          if (options2.system) {
            delete options2.system;
          }
          let clients = Object.assign([], options2.clients);
          let sites = Object.assign([], options2.sites);
          delete options2.clients;
          delete options2.sites;
          this.syncStorage.set(this.name, options2).then(() => {
            this.syncStorage.set(this.name + ".clients", clients).then(() => {
              this.syncStorage.set(this.name + ".sites", sites).then(() => {
                resolve2(this.options);
              }).catch((error) => {
                reject2(APP.createErrorMessage(error));
              });
            }).catch((error) => {
              reject2(APP.createErrorMessage(error));
            });
          }).catch((error) => {
            reject2(APP.createErrorMessage(error));
          });
        } else {
          reject2(APP.createErrorMessage("chrome.storage 不存在"));
        }
      });
    }
    /**
     * 从Google云端恢复系统参数
     */
    restoreFromGoogle() {
      return new Promise((resolve2, reject2) => {
        if (chrome.storage && chrome.storage.sync) {
          this.syncStorage.get(this.name).then((result2) => {
            let system = Object.assign({}, this.options.system);
            let options2 = result2;
            options2.system = system;
            this.syncStorage.get(this.name + ".clients").then((result22) => {
              options2.clients = result22;
              this.syncStorage.get(this.name + ".sites").then((result3) => {
                options2.sites = result3;
                this.resetRunTimeOptions(options2);
                this.save();
                setTimeout(() => {
                  resolve2(this.options);
                }, 300);
              }).catch((error) => {
                reject2(APP.createErrorMessage(error));
              });
            }).catch((error) => {
              reject2(APP.createErrorMessage(error));
            });
          }).catch((error) => {
            reject2(APP.createErrorMessage(error));
          });
        } else {
          reject2(APP.createErrorMessage("chrome.storage 不存在"));
        }
      });
    }
    /**
     * 获取备份原始数据，用于插件背景页和前端传输
     */
    getBackupRawData() {
      return new Promise((resolve2, reject2) => {
        try {
          const rawUserData = this.service.userData.get("", EUserDataRange.all);
          const rawOptions = this.cleaningOptions(this.service.options);
          delete rawOptions.system;
          let rawData = {
            options: rawOptions,
            userData: rawUserData,
            collection: {
              items: this.service.collection.items,
              groups: this.service.collection.groups
            },
            cookies: void 0,
            searchResultSnapshot: this.service.searchResultSnapshot.items,
            keepUploadTask: this.service.keepUploadTask.items,
            downloadHistory: void 0
          };
          const requests2 = [];
          requests2.push(this.service.controller.downloadHistory.load());
          if (this.service.options.allowBackupCookies && PPF.checkOptionalPermission("cookies")) {
            requests2.push(this.getAllSiteCookies());
          }
          Promise.all(requests2).then((results2) => {
            rawData.downloadHistory = results2[0];
            if (results2.length > 1) {
              rawData.cookies = results2[1];
            }
            resolve2(rawData);
          }).catch(() => {
            resolve2(rawData);
          });
        } catch (error) {
          reject2(error);
        }
      });
    }
    /**
     * 创建备份文件
     * @param fileName
     */
    createBackupFile(fileName) {
      return new Promise((resolve2, reject2) => {
        this.getBackupFileBlob().then((blob) => {
          FileSaver.saveAs(blob, fileName || this.getNewBackupFileName());
          resolve2(true);
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取备份数据
     */
    getBackupFileBlob() {
      return new Promise((resolve2, reject2) => {
        try {
          this.getBackupRawData().then((rawData) => {
            this.backupFileParser.createBackupFileBlob(rawData).then((blob) => {
              resolve2(blob);
            });
          }).catch((error) => {
            reject2(error);
          });
        } catch (error) {
          reject2(error);
        }
      });
    }
    /**
     * 获取所有站点Cookies
     */
    getAllSiteCookies() {
      return new Promise((resolve2, reject2) => {
        PPF.checkPermissions(["cookies"]).then(() => {
          const sites = this.options.sites;
          if (sites && sites.length > 0) {
            const requests2 = [];
            sites.forEach((site2) => {
              requests2.push(this.getCookiesFromSite(site2));
            });
            Promise.all(requests2).then((results2) => {
              resolve2(results2);
            }).catch((error) => {
              reject2(error);
            });
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取指定站点Cookies
     * @param site
     */
    getCookiesFromSite(site2) {
      return new Promise((resolve2, reject2) => {
        const url2 = site2.activeURL || site2.url;
        chrome.cookies.getAll(
          {
            url: url2
          },
          (result2) => {
            if (chrome.runtime.lastError) {
              reject2(chrome.runtime.lastError.message);
              return;
            }
            resolve2({
              host: site2.host,
              url: url2,
              cookies: result2
            });
            console.log(result2);
          }
        );
      });
    }
    /**
     * 恢复Cookies
     * @param datas
     */
    restoreCookies(datas) {
      return new Promise((resolve2, reject2) => {
        let requests2 = [];
        const keepFields = [
          "name",
          "value",
          "domain",
          "path",
          "secure",
          "httpOnly",
          "expirationDate"
        ];
        datas.forEach((item) => {
          item.cookies.forEach((cookie) => {
            let options2 = PPF.clone(cookie);
            for (const key2 in options2) {
              if (options2.hasOwnProperty(key2) && !keepFields.includes(key2)) {
                delete options2[key2];
              }
            }
            options2.url = item.url;
            requests2.push(this.setCookies(options2, item.host));
          });
        });
        Promise.all(requests2).then(() => {
          resolve2();
        }).catch(() => {
          resolve2();
        });
      });
    }
    /**
     * 设置站点 Cookies
     * @param cookie
     * @param host
     */
    setCookies(cookie, host2) {
      return new Promise((resolve2, reject2) => {
        let site2 = PPF.getSiteFromHost(host2, this.service.options);
        chrome.cookies.get(
          {
            url: (site2.activeURL || site2.url) + "",
            name: cookie.name + ""
          },
          (_cookie) => {
            let allowSet = false;
            const now = (/* @__PURE__ */ new Date()).getTime() / 1e3;
            if (_cookie === null) {
              allowSet = true;
            } else if (
              // 如果站点存在这个Cookies，但已过期，允许设置
              _cookie.expirationDate && _cookie.expirationDate < now
            ) {
              allowSet = true;
            }
            if (allowSet) {
              if (cookie.expirationDate && cookie.expirationDate < now) {
                cookie.expirationDate = now + 60 * 60 * 24;
              }
              chrome.cookies.set(cookie, (result2) => {
                if (chrome.runtime.lastError) {
                  reject2(chrome.runtime.lastError.message);
                  return;
                }
                resolve2(result2);
                console.log(result2);
              });
            } else {
              console.log("跳过 %s: %s", host2, cookie.name);
              resolve2();
            }
          }
        );
      });
    }
    getNewBackupFileName() {
      return PPF.getNewBackupFileName();
    }
    /**
     * 备份配置到服务器
     * @param server
     */
    backupToServer(server) {
      console.log("backupToServer", server, this.options.backupServers);
      return new Promise((resolve2, reject2) => {
        const time = dayjs().valueOf();
        const fileName = this.getNewBackupFileName();
        let service = null;
        this.getBackupFileBlob().then((blob) => {
          const formData = new FormData();
          formData.append("name", fileName);
          formData.append("data", blob);
          switch (server.type) {
            case EBackupServerType.OWSS:
              service = new OWSS(server);
              break;
            case EBackupServerType.WebDAV:
              service = new WebDAV(server);
              break;
            default:
              reject2("暂不支持");
              break;
          }
          if (service) {
            service.add(formData).then((result2) => {
              resolve2({
                time,
                fileName
              });
            }).catch((error) => {
              reject2(error);
            });
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 从备份服务器中恢复指定的文件
     * @param server
     * @param path
     */
    restoreFromServer(server, path2) {
      return new Promise((resolve2, reject2) => {
        let service = null;
        switch (server.type) {
          case EBackupServerType.OWSS:
            service = new OWSS(server);
            break;
          case EBackupServerType.WebDAV:
            service = new WebDAV(server);
            break;
          default:
            reject2("暂不支持");
            break;
        }
        if (service) {
          service.get(path2).then((data2) => {
            this.backupFileParser.loadZipData(
              data2,
              this.service.i18n.t("settings.backup.enterSecretKey"),
              this.service.options.encryptSecretKey
            ).then((result2) => {
              resolve2(result2);
            }).catch((error) => {
              reject2(error);
            });
          }).catch((error) => {
            reject2(error);
          });
        }
      });
    }
    /**
     * 获取备份文件列表
     * @param server
     * @param options
     */
    getBackupListFromServer(server, options2 = {}) {
      return new Promise((resolve2, reject2) => {
        let service = null;
        switch (server.type) {
          case EBackupServerType.OWSS:
            service = new OWSS(server);
            break;
          case EBackupServerType.WebDAV:
            service = new WebDAV(server);
            break;
          default:
            reject2("暂不支持");
            break;
        }
        if (service) {
          service.list(options2).then((result2) => {
            resolve2(result2);
          }).catch((error) => {
            reject2(error);
          });
        }
      });
    }
    /**
     * 删除指定的文件
     * @param server
     * @param path
     */
    deleteFileFromBackupServer(server, path2) {
      return new Promise((resolve2, reject2) => {
        let service = null;
        switch (server.type) {
          case EBackupServerType.OWSS:
            service = new OWSS(server);
            break;
          case EBackupServerType.WebDAV:
            service = new WebDAV(server);
            break;
          default:
            reject2("暂不支持");
            break;
        }
        if (service) {
          service.delete(path2).then((result2) => {
            resolve2(result2);
          }).catch((error) => {
            reject2(error);
          });
        }
      });
    }
    /**
     * 测试指定的服务器是否可连接
     * @param server
     */
    testBackupServerConnectivity(server) {
      return new Promise((resolve2, reject2) => {
        let service = null;
        switch (server.type) {
          case EBackupServerType.OWSS:
            service = new OWSS(server);
            break;
          case EBackupServerType.WebDAV:
            service = new WebDAV(server);
            break;
          default:
            reject2("暂不支持");
            break;
        }
        if (service) {
          service.ping().then((result2) => {
            resolve2(result2);
          }).catch((error) => {
            reject2(error);
          });
        }
      });
    }
  }
  class ClientController {
    /**
     * 类初始化
     */
    constructor() {
      this.options = {
        sites: [],
        clients: []
      };
      this.clients = {};
    }
    init(options2) {
      this.options = options2;
      this.cleanUpClients();
    }
    /**
     * 清理已缓存的客户端
     */
    cleanUpClients() {
      this.clients = {};
    }
    /**
     * 根据指定客户端配置初始化客户端
     * @param clientOptions 客户端配置
     */
    getClient(clientOptions) {
      return new Promise((resolve, reject) => {
        if (typeof clientOptions === "string") {
          let clientId = clientOptions;
          clientOptions = this.options.clients.find((item) => {
            return item.id === clientId;
          });
          let client2 = this.clients[clientId];
          if (client2) {
            resolve({ client: client2, options: clientOptions });
            return;
          }
        }
        if (window[clientOptions.type] === void 0) {
          APP.execScript({
            type: "file",
            content: `clients/${clientOptions.type}/init.js`
          }).then(() => {
            let client;
            eval(`client = new ${clientOptions.type}()`);
            client.init({
              loginName: clientOptions.loginName,
              loginPwd: clientOptions.loginPwd,
              address: clientOptions.address,
              name: clientOptions.name
            });
            this.clients[clientOptions.id] = client;
            resolve({ client, options: clientOptions });
          }).catch((e2) => {
            console.log(e2);
            reject({
              initFailed: true,
              msg: e2
            });
          });
        } else {
          let client;
          eval(`client = new ${clientOptions.type}()`);
          client.init({
            loginName: clientOptions.loginName,
            loginPwd: clientOptions.loginPwd,
            address: clientOptions.address,
            name: clientOptions.name
          });
          this.clients[clientOptions.id] = client;
          resolve({ client, options: clientOptions });
        }
      });
    }
    /**
     * 测试客户端是否可连接
     * @param options 参数
     */
    testClientConnectivity(options2) {
      return new Promise((resolve2, reject2) => {
        let dataResult = {
          type: EDataResultType.unknown,
          success: false
        };
        this.getClient(options2).then((clientOptions2) => {
          clientOptions2.client.call(EAction.testClientConnectivity, options2).then((result2) => {
            dataResult.success = result2;
            if (result2) {
              dataResult.type = EDataResultType.success;
            }
            resolve2(dataResult);
          }).catch((result2) => {
            dataResult.data = result2;
            dataResult.type = EDataResultType.error;
            reject2(dataResult);
          });
        }).catch((e2) => {
          dataResult.data = e2;
          dataResult.type = EDataResultType.error;
          reject2(dataResult);
        });
      });
    }
  }
  class DownloadHistory {
    constructor() {
      this.items = [];
      this.storage = new localStorage();
      this.load();
    }
    /**
     * 获取下载历史记录
     */
    load() {
      return new Promise((resolve2, reject2) => {
        this.storage.get(EConfigKey.downloadHistory, (result2) => {
          this.items = result2 || [];
          resolve2(this.items);
        });
      });
    }
    /**
     * 保存下载记录
     * @param data 下载链接信息
     * @param host 站点域名
     * @param clientId 下载客户端ID
     */
    add(data2, host2 = "", clientId = "", success = true) {
      let saveData = {
        data: data2,
        clientId,
        host: host2,
        success,
        time: (/* @__PURE__ */ new Date()).getTime()
      };
      if (!this.items) {
        this.load().then(() => {
          this.items.push(saveData);
          this.updateData();
        });
      } else {
        let index2 = this.items.findIndex((item) => {
          return item.data.url === data2.url;
        });
        if (index2 === -1) {
          this.items.push(saveData);
          this.updateData();
        }
      }
    }
    /**
     * 删除下载历史记录
     * @param items 需要删除的列表
     */
    remove(items) {
      return new Promise((resolve2, reject2) => {
        this.load().then(() => {
          for (let index2 = this.items.length - 1; index2 >= 0; index2--) {
            let item = this.items[index2];
            let findIndex = items.findIndex((_data) => {
              return _data.data.url === item.data.url;
            });
            if (findIndex >= 0) {
              this.items.splice(index2, 1);
            }
          }
          this.updateData();
          resolve2(this.items);
        });
      });
    }
    /**
     * 清除下载记录
     */
    clear() {
      return new Promise((resolve2, reject2) => {
        this.items = [];
        this.updateData();
        resolve2(this.items);
      });
    }
    /**
     * 重置
     * @param datas
     */
    reset(datas) {
      return new Promise((resolve2, reject2) => {
        if (!datas) {
          reject2(false);
          return;
        }
        if (!Array.isArray(datas)) {
          reject2(false);
          return;
        }
        this.items = datas;
        this.updateData();
        resolve2(this.items);
      });
    }
    updateData() {
      this.storage.set(EConfigKey.downloadHistory, this.items);
    }
  }
  "use strict";
  var hasOwn = Object.prototype.hasOwnProperty;
  var toStr = Object.prototype.toString;
  var defineProperty = Object.defineProperty;
  var gOPD = Object.getOwnPropertyDescriptor;
  var isArray = function isArray2(arr) {
    if (typeof Array.isArray === "function") {
      return Array.isArray(arr);
    }
    return toStr.call(arr) === "[object Array]";
  };
  var isPlainObject = function isPlainObject2(obj) {
    if (!obj || toStr.call(obj) !== "[object Object]") {
      return false;
    }
    var hasOwnConstructor = hasOwn.call(obj, "constructor");
    var hasIsPrototypeOf = obj.constructor && obj.constructor.prototype && hasOwn.call(obj.constructor.prototype, "isPrototypeOf");
    if (obj.constructor && !hasOwnConstructor && !hasIsPrototypeOf) {
      return false;
    }
    var key2;
    for (key2 in obj) {
    }
    return typeof key2 === "undefined" || hasOwn.call(obj, key2);
  };
  var setProperty = function setProperty2(target, options2) {
    if (defineProperty && options2.name === "__proto__") {
      defineProperty(target, options2.name, {
        enumerable: true,
        configurable: true,
        value: options2.newValue,
        writable: true
      });
    } else {
      target[options2.name] = options2.newValue;
    }
  };
  var getProperty = function getProperty2(obj, name2) {
    if (name2 === "__proto__") {
      if (!hasOwn.call(obj, name2)) {
        return void 0;
      } else if (gOPD) {
        return gOPD(obj, name2).value;
      }
    }
    return obj[name2];
  };
  var extend = function extend2() {
    var options2, name2, src, copy2, copyIsArray, clone;
    var target = arguments[0];
    var i2 = 1;
    var length = arguments.length;
    var deep = false;
    if (typeof target === "boolean") {
      deep = target;
      target = arguments[1] || {};
      i2 = 2;
    }
    if (target == null || typeof target !== "object" && typeof target !== "function") {
      target = {};
    }
    for (; i2 < length; ++i2) {
      options2 = arguments[i2];
      if (options2 != null) {
        for (name2 in options2) {
          src = getProperty(target, name2);
          copy2 = getProperty(options2, name2);
          if (target !== copy2) {
            if (deep && copy2 && (isPlainObject(copy2) || (copyIsArray = isArray(copy2)))) {
              if (copyIsArray) {
                copyIsArray = false;
                clone = src && isArray(src) ? src : [];
              } else {
                clone = src && isPlainObject(src) ? src : {};
              }
              setProperty(target, { name: name2, newValue: extend2(deep, clone, copy2) });
            } else if (typeof copy2 !== "undefined") {
              setProperty(target, { name: name2, newValue: copy2 });
            }
          }
        }
      }
    }
    return target;
  };
  const extend$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(extend);
  class SiteService {
    constructor(options2, systemOptions) {
      this.options = options2;
      this.systemOptions = systemOptions;
      this.isLogin = false;
      this._schema = {};
      this.mergeOptions();
    }
    get schema() {
      if (this._schema.name) {
        return this._schema;
      }
      let schema2 = {};
      if (typeof this.options.schema === "string") {
        schema2 = this.systemOptions.system && this.systemOptions.system.schemas && this.systemOptions.system.schemas.find((item) => {
          return item.name == this.options.schema;
        });
      }
      this._schema = schema2;
      return schema2;
    }
    mergeOptions() {
      let site2 = this.systemOptions.system && this.systemOptions.system.sites && this.systemOptions.system.sites.find((item) => {
        return item.host == this.options.host;
      });
      if (site2) {
        let customSearchEntry = [];
        if (this.options.searchEntry) {
          for (let index2 = this.options.searchEntry.length - 1; index2 >= 0; index2--) {
            const item = this.options.searchEntry[index2];
            if (item.isCustom) {
              customSearchEntry.push(item);
              this.options.searchEntry.splice(index2, 1);
            }
          }
        }
        this.options = extend$1(true, {}, site2, this.options);
        if (this.options.searchEntry && customSearchEntry.length > 0) {
          this.options.searchEntry.push(...customSearchEntry);
        }
      }
      console.log(this.options);
    }
    // public checkLogin(): Promise<any> {
    //   return new Promise<any>((resolve?: any, reject?: any) => {
    //     let site = this.options;
    //     let schema = this.schema;
    //     let checker: any;
    //     if (site.checker && site.checker.isLogin) {
    //       checker = site.checker.isLogin;
    //     } else if (schema.checker && schema.checker.isLogin) {
    //       checker = schema.checker.isLogin;
    //     }
    //     if (checker) {
    //       $.get(`${site.url}/${checker.page}`)
    //         .done((result: string) => {
    //           resolve(new RegExp(result, "").test(checker.contains));
    //         })
    //         .fail(() => {
    //           reject();
    //         });
    //     } else {
    //       resolve(null);
    //     }
    //   });
    // }
  }
  var customParseFormat$2 = { exports: {} };
  var customParseFormat = customParseFormat$2.exports;
  (function(module, exports) {
    !function(e2, t2) {
      true ? module.exports = t2() : false ? (void 0)(t2) : (e2 = "undefined" != typeof globalThis ? globalThis : e2 || self).dayjs_plugin_customParseFormat = t2();
    }(commonjsGlobal, function() {
      "use strict";
      var e2 = { LTS: "h:mm:ss A", LT: "h:mm A", L: "MM/DD/YYYY", LL: "MMMM D, YYYY", LLL: "MMMM D, YYYY h:mm A", LLLL: "dddd, MMMM D, YYYY h:mm A" }, t2 = /(\[[^[]*\])|([-_:/.,()\s]+)|(A|a|YYYY|YY?|MM?M?M?|Do|DD?|hh?|HH?|mm?|ss?|S{1,3}|z|ZZ?)/g, n2 = /\d\d/, r2 = /\d\d?/, i2 = /\d*[^-_:/,()\s\d]+/, o2 = {}, s2 = function(e3) {
        return (e3 = +e3) + (e3 > 68 ? 1900 : 2e3);
      };
      var a2 = function(e3) {
        return function(t3) {
          this[e3] = +t3;
        };
      }, f2 = [/[+-]\d\d:?(\d\d)?|Z/, function(e3) {
        (this.zone || (this.zone = {})).offset = function(e4) {
          if (!e4)
            return 0;
          if ("Z" === e4)
            return 0;
          var t3 = e4.match(/([+-]|\d\d)/g), n3 = 60 * t3[1] + (+t3[2] || 0);
          return 0 === n3 ? 0 : "+" === t3[0] ? -n3 : n3;
        }(e3);
      }], h2 = function(e3) {
        var t3 = o2[e3];
        return t3 && (t3.indexOf ? t3 : t3.s.concat(t3.f));
      }, u2 = function(e3, t3) {
        var n3, r3 = o2.meridiem;
        if (r3) {
          for (var i3 = 1; i3 <= 24; i3 += 1)
            if (e3.indexOf(r3(i3, 0, t3)) > -1) {
              n3 = i3 > 12;
              break;
            }
        } else
          n3 = e3 === (t3 ? "pm" : "PM");
        return n3;
      }, d2 = { A: [i2, function(e3) {
        this.afternoon = u2(e3, false);
      }], a: [i2, function(e3) {
        this.afternoon = u2(e3, true);
      }], S: [/\d/, function(e3) {
        this.milliseconds = 100 * +e3;
      }], SS: [n2, function(e3) {
        this.milliseconds = 10 * +e3;
      }], SSS: [/\d{3}/, function(e3) {
        this.milliseconds = +e3;
      }], s: [r2, a2("seconds")], ss: [r2, a2("seconds")], m: [r2, a2("minutes")], mm: [r2, a2("minutes")], H: [r2, a2("hours")], h: [r2, a2("hours")], HH: [r2, a2("hours")], hh: [r2, a2("hours")], D: [r2, a2("day")], DD: [n2, a2("day")], Do: [i2, function(e3) {
        var t3 = o2.ordinal, n3 = e3.match(/\d+/);
        if (this.day = n3[0], t3)
          for (var r3 = 1; r3 <= 31; r3 += 1)
            t3(r3).replace(/\[|\]/g, "") === e3 && (this.day = r3);
      }], M: [r2, a2("month")], MM: [n2, a2("month")], MMM: [i2, function(e3) {
        var t3 = h2("months"), n3 = (h2("monthsShort") || t3.map(function(e4) {
          return e4.slice(0, 3);
        })).indexOf(e3) + 1;
        if (n3 < 1)
          throw new Error();
        this.month = n3 % 12 || n3;
      }], MMMM: [i2, function(e3) {
        var t3 = h2("months").indexOf(e3) + 1;
        if (t3 < 1)
          throw new Error();
        this.month = t3 % 12 || t3;
      }], Y: [/[+-]?\d+/, a2("year")], YY: [n2, function(e3) {
        this.year = s2(e3);
      }], YYYY: [/\d{4}/, a2("year")], Z: f2, ZZ: f2 };
      function c2(n3) {
        var r3, i3;
        r3 = n3, i3 = o2 && o2.formats;
        for (var s3 = (n3 = r3.replace(/(\[[^\]]+])|(LTS?|l{1,4}|L{1,4})/g, function(t3, n4, r4) {
          var o3 = r4 && r4.toUpperCase();
          return n4 || i3[r4] || e2[r4] || i3[o3].replace(/(\[[^\]]+])|(MMMM|MM|DD|dddd)/g, function(e3, t4, n5) {
            return t4 || n5.slice(1);
          });
        })).match(t2), a3 = s3.length, f3 = 0; f3 < a3; f3 += 1) {
          var h3 = s3[f3], u3 = d2[h3], c3 = u3 && u3[0], l2 = u3 && u3[1];
          s3[f3] = l2 ? { regex: c3, parser: l2 } : h3.replace(/^\[|\]$/g, "");
        }
        return function(e3) {
          for (var t3 = {}, n4 = 0, r4 = 0; n4 < a3; n4 += 1) {
            var i4 = s3[n4];
            if ("string" == typeof i4)
              r4 += i4.length;
            else {
              var o3 = i4.regex, f4 = i4.parser, h4 = e3.slice(r4), u4 = o3.exec(h4)[0];
              f4.call(t3, u4), e3 = e3.replace(u4, "");
            }
          }
          return function(e4) {
            var t4 = e4.afternoon;
            if (void 0 !== t4) {
              var n5 = e4.hours;
              t4 ? n5 < 12 && (e4.hours += 12) : 12 === n5 && (e4.hours = 0), delete e4.afternoon;
            }
          }(t3), t3;
        };
      }
      return function(e3, t3, n3) {
        n3.p.customParseFormat = true, e3 && e3.parseTwoDigitYear && (s2 = e3.parseTwoDigitYear);
        var r3 = t3.prototype, i3 = r3.parse;
        r3.parse = function(e4) {
          var t4 = e4.date, r4 = e4.utc, s3 = e4.args;
          this.$u = r4;
          var a3 = s3[1];
          if ("string" == typeof a3) {
            var f3 = true === s3[2], h3 = true === s3[3], u3 = f3 || h3, d3 = s3[2];
            h3 && (d3 = s3[2]), o2 = this.$locale(), !f3 && d3 && (o2 = n3.Ls[d3]), this.$d = function(e5, t5, n4) {
              try {
                if (["x", "X"].indexOf(t5) > -1)
                  return new Date(("X" === t5 ? 1e3 : 1) * e5);
                var r5 = c2(t5)(e5), i4 = r5.year, o3 = r5.month, s4 = r5.day, a4 = r5.hours, f4 = r5.minutes, h4 = r5.seconds, u4 = r5.milliseconds, d4 = r5.zone, l3 = /* @__PURE__ */ new Date(), m2 = s4 || (i4 || o3 ? 1 : l3.getDate()), M2 = i4 || l3.getFullYear(), Y = 0;
                i4 && !o3 || (Y = o3 > 0 ? o3 - 1 : l3.getMonth());
                var p2 = a4 || 0, v = f4 || 0, D = h4 || 0, g = u4 || 0;
                return d4 ? new Date(Date.UTC(M2, Y, m2, p2, v, D, g + 60 * d4.offset * 1e3)) : n4 ? new Date(Date.UTC(M2, Y, m2, p2, v, D, g)) : new Date(M2, Y, m2, p2, v, D, g);
              } catch (e6) {
                return /* @__PURE__ */ new Date("");
              }
            }(t4, a3, r4), this.init(), d3 && true !== d3 && (this.$L = this.locale(d3).$L), u3 && t4 != this.format(a3) && (this.$d = /* @__PURE__ */ new Date("")), o2 = {};
          } else if (a3 instanceof Array)
            for (var l2 = a3.length, m = 1; m <= l2; m += 1) {
              s3[1] = a3[m - 1];
              var M = n3.apply(this, s3);
              if (M.isValid()) {
                this.$d = M.$d, this.$L = M.$L, this.init();
                break;
              }
              m === l2 && (this.$d = /* @__PURE__ */ new Date(""));
            }
          else
            i3.call(this, e4);
        };
      };
    });
  })(customParseFormat$2, customParseFormat$2.exports);
  var customParseFormatExports = customParseFormat$2.exports;
  const customParseFormat$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(customParseFormatExports);
  var advancedFormat$2 = { exports: {} };
  var advancedFormat = advancedFormat$2.exports;
  (function(module, exports) {
    !function(e2, t2) {
      true ? module.exports = t2() : false ? (void 0)(t2) : (e2 = "undefined" != typeof globalThis ? globalThis : e2 || self).dayjs_plugin_advancedFormat = t2();
    }(commonjsGlobal, function() {
      "use strict";
      return function(e2, t2) {
        var r2 = t2.prototype, n2 = r2.format;
        r2.format = function(e3) {
          var t3 = this, r3 = this.$locale();
          if (!this.isValid())
            return n2.bind(this)(e3);
          var s2 = this.$utils(), a2 = (e3 || "YYYY-MM-DDTHH:mm:ssZ").replace(/\[([^\]]+)]|Q|wo|ww|w|WW|W|zzz|z|gggg|GGGG|Do|X|x|k{1,2}|S/g, function(e4) {
            switch (e4) {
              case "Q":
                return Math.ceil((t3.$M + 1) / 3);
              case "Do":
                return r3.ordinal(t3.$D);
              case "gggg":
                return t3.weekYear();
              case "GGGG":
                return t3.isoWeekYear();
              case "wo":
                return r3.ordinal(t3.week(), "W");
              case "w":
              case "ww":
                return s2.s(t3.week(), "w" === e4 ? 1 : 2, "0");
              case "W":
              case "WW":
                return s2.s(t3.isoWeek(), "W" === e4 ? 1 : 2, "0");
              case "k":
              case "kk":
                return s2.s(String(0 === t3.$H ? 24 : t3.$H), "k" === e4 ? 1 : 2, "0");
              case "X":
                return Math.floor(t3.$d.getTime() / 1e3);
              case "x":
                return t3.$d.getTime();
              case "z":
                return "[" + t3.offsetName() + "]";
              case "zzz":
                return "[" + t3.offsetName("long") + "]";
              default:
                return e4;
            }
          });
          return n2.bind(this)(a2);
        };
      };
    });
  })(advancedFormat$2, advancedFormat$2.exports);
  var advancedFormatExports = advancedFormat$2.exports;
  const advancedFormat$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(advancedFormatExports);
  dayjs.extend(customParseFormat$1);
  dayjs.extend(advancedFormat$1);
  class InfoParser {
    constructor(service) {
      this.service = service;
    }
    /**
     * 根据指定规则和原始获取需要的数据
     * @param content 原始内容
     * @param rule 规则配置
     * @return Dictionary<any>
     */
    getResult(content2, rule2) {
      let results2 = {};
      if (content2) {
        for (const key2 in rule2.fields) {
          if (rule2.fields.hasOwnProperty(key2)) {
            let config2 = rule2.fields[key2];
            let result2 = this.getFieldData(content2, config2, rule2);
            if (result2 != null) {
              results2[key2] = result2;
            }
          }
        }
      }
      return results2;
    }
    debug(...msg) {
      if (this.service) {
        this.service.debug(...msg);
      } else {
        PPF.debug(...msg);
      }
    }
    /**
     * 获取字段信息
     * @param content 原始内容
     * @param config 当前字段定义信息
     * @param rule 选择器规则
     */
    getFieldData(content, config, rule) {
      let query;
      let selectorIndex = 0;
      let selectors = [];
      if (typeof config.selector == "string") {
        selectors.push(config.selector);
      } else if (config.selector && config.selector.length) {
        selectors = config.selector;
      } else {
        return config.value === void 0 ? null : config.value;
      }
      let lastSelector = "";
      selectors.some((selector) => {
        lastSelector = selector;
        try {
          switch (rule.dataType) {
            case ERequestResultType.JSON:
              if (selector == "") {
                query = content;
              } else if (selector.substr(0, 1) == "[") {
                query = eval("content" + selector);
              } else {
                query = eval("content." + selector);
              }
              if (query != null) {
                return true;
              }
              break;
            case ERequestResultType.TEXT:
            case ERequestResultType.HTML:
            default:
              if (selector == "") {
                query = content;
              } else {
                query = content.find(selector);
                if (query.length == 0)
                  query = content.filter(selector);
              }
              if (query.length > 0) {
                return true;
              }
              break;
          }
          selectorIndex++;
        } catch (error) {
          this.debug(
            "InfoParser.getFieldData.Error",
            selector,
            error.message,
            error.stack
          );
          return true;
        }
      });
      console.log(`selector result for ${lastSelector} :`);
      console.log(query);
      let result = null;
      let dateTime = dayjs;
      let _self = this;
      if (query != null) {
        if (config.attribute || config.filters || config.switchFilters) {
          if (config.attribute && rule.dataType != ERequestResultType.JSON) {
            query = query.attr(config.attribute);
          }
          let filters;
          if (config.switchFilters) {
            filters = config.switchFilters[selectorIndex] || null;
          } else {
            filters = config.filters;
          }
          if (filters) {
            filters.every((filter) => {
              try {
                query = eval(filter);
              } catch (error) {
                this.debug(
                  "InfoParser.filter.Error",
                  filter,
                  error.message,
                  error.stack
                );
                query = null;
                return false;
              }
              return true;
            });
          }
          result = query;
          if (Array.isArray(filters)) {
            console.log(`filter result for ${filters.join(" => ")}: ${result}`);
          }
        } else {
          switch (rule.dataType) {
            case ERequestResultType.JSON:
              result = query;
              break;
            default:
              result = query.text().trim();
              break;
          }
        }
      }
      return result;
    }
    /**
     * 获取指定数组的合计尺寸
     * @param datas 表示大小的数组
     */
    getTotalSize(datas) {
      let total = 0;
      datas.forEach((item) => {
        let match = item.match(/^(\d*\.?\d+)(.*[^ZEPTGMK])?([ZEPTGMK](B|iB)?)$/i);
        if (!match) {
          return;
        }
        let size = parseFloat(match[1]);
        let unit = match[3].toLowerCase();
        switch (true) {
          case /ki?b/.test(unit):
            total += size * Math.pow(2, 10);
            break;
          case /mi?b/.test(unit):
            total += size * Math.pow(2, 20);
            break;
          case /gi?b/.test(unit):
            total += size * Math.pow(2, 30);
            break;
          case /ti?b?/.test(unit):
            total += size * Math.pow(2, 40);
            break;
          case /pi?b?/.test(unit):
            total += size * Math.pow(2, 50);
            break;
          case /ei?b?/.test(unit):
            total += size * Math.pow(2, 60);
            break;
          case /zi?b?/.test(unit):
            total += size * Math.pow(2, 70);
            break;
        }
      });
      return total;
    }
    /**
     * 获取指定数组的合计尺寸
     * @param imdbId 表示大小的数组
     */
    formatIMDbId(imdbId) {
      if (Number(imdbId)) {
        if (imdbId.length < 7)
          imdbId = imdbId.padStart(7, "0");
        imdbId = "tt" + imdbId;
      }
      return imdbId;
    }
  }
  class PageParser {
    /**
     * 初始化
     * @param options 解析配置
     * @param site 站点
     * @param timeout
     * @param commonDatas 指定的通用数据
     */
    constructor(options2, site2, timeout = 3e4, commonDatas) {
      this.options = options2;
      this.site = site2;
      this.timeout = timeout;
      this.commonDatas = commonDatas;
      this.infoParserCache = {};
      this.cacheKey = "";
      this.url = "";
      let url2 = site2.url + "";
      if (site2.cdn && site2.cdn.length > 0) {
        url2 = site2.cdn[0];
      }
      if ((url2 + "").substr(-1) != "/") {
        url2 += "/";
      }
      let page2 = this.options.page;
      if ((page2 + "").substr(0, 1) == "/") {
        page2 = (page2 + "").substr(1);
      }
      this.url = (url2 + page2).replace("://", "****").replace(/\/\//g, "/").replace("****", "://");
      this.requestData = this.options.requestData;
      if (this.requestData && this.commonDatas) {
        try {
          for (const key2 in this.requestData) {
            if (this.requestData.hasOwnProperty(key2)) {
              const value = this.requestData[key2];
              for (const commonKey in this.commonDatas) {
                if (this.commonDatas.hasOwnProperty(commonKey)) {
                  this.requestData[key2] = PPF.replaceKeys(
                    value,
                    this.commonDatas[commonKey],
                    commonKey
                  );
                }
              }
            }
          }
        } catch (error) {
          console.log(error);
        }
      }
      this.cacheKey = cryptoJsExports.MD5(this.url + JSON.stringify(this.requestData || {})).toString();
    }
    /**
     * 获取缓存
     */
    getCache() {
      let result2 = window.localStorage.getItem(this.cacheKey);
      if (result2) {
        let json = JSON.parse(result2);
        if (json.data && json.time) {
          let time = (/* @__PURE__ */ new Date()).getTime();
          if (json.time < time) {
            window.localStorage.removeItem(this.cacheKey);
            return null;
          }
          return json.data;
        }
      }
      return null;
    }
    /**
     * 设置缓存
     */
    setCache() {
      if (this.options.dataCacheTime && this.options.dataCacheTime > 0) {
        let cache = {
          data: this.resultData,
          time: (/* @__PURE__ */ new Date()).getTime() + this.options.dataCacheTime * 1e3
        };
        window.localStorage.setItem(this.cacheKey, JSON.stringify(cache));
      }
    }
    /**
     * 获取数据
     */
    getInfos() {
      return new Promise((resolve2, reject2) => {
        let cache = this.getCache();
        if (cache) {
          resolve2(cache);
          return;
        }
        if (this.options.parser && this.site) {
          if (this.runParser(resolve2, reject2)) {
            return;
          }
        }
        let request = $.ajax({
          url: this.url,
          method: this.options.requestMethod || ERequestMethod.GET,
          dataType: "text",
          headers: this.options.headers,
          data: this.requestData,
          timeout: this.timeout
        }).done((result2) => {
          let content2;
          try {
            if (this.options.dataType !== ERequestResultType.JSON) {
              let doc2 = new DOMParser().parseFromString(result2, "text/html");
              let topElement = this.options.topElement || "body";
              content2 = $(doc2).find(topElement);
            } else {
              content2 = JSON.parse(result2);
            }
          } catch (error) {
            reject2(error);
            return;
          }
          if (content2 && this.options) {
            try {
              let results2 = new InfoParser().getResult(content2, this.options);
              this.resultData = results2;
              this.setCache();
              resolve2(results2);
            } catch (error) {
              reject2(error);
            }
          }
        }).fail((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 执行脚本解析器
     * @param rule
     * @param site
     * @param userInfo
     * @param resolve
     * @param reject
     */
    runParser(resolve, reject) {
      if (!this.site || !this.options.parser) {
        return false;
      }
      let siteConfigPath = this.site.schema == "publicSite" ? "publicSites" : "sites";
      if (this.site.path) {
        siteConfigPath += `/${this.site.path}`;
      } else {
        siteConfigPath += `/${this.site.host}`;
      }
      let path = this.options.parser;
      if (path.substr(0, 1) !== "/" && path.substr(0, 4) !== "http") {
        path = `${siteConfigPath}/${path}`;
      }
      let _options = {
        site: this.site,
        rule: this.options,
        commonDatas: this.commonDatas,
        resolve,
        reject
      };
      let _self = this;
      let script = this.infoParserCache[path];
      if (script) {
        eval(script);
      } else {
        APP.getScriptContent(path).done((script) => {
          this.infoParserCache[path] = script;
          eval(script);
        });
      }
      return true;
    }
  }
  var ESearchResultParseStatus = /* @__PURE__ */ ((ESearchResultParseStatus2) => {
    ESearchResultParseStatus2["success"] = "success";
    ESearchResultParseStatus2["needLogin"] = "needLogin";
    ESearchResultParseStatus2["noTorrents"] = "noTorrents";
    ESearchResultParseStatus2["torrentTableIsEmpty"] = "torrentTableIsEmpty";
    ESearchResultParseStatus2["parseError"] = "parseError";
    return ESearchResultParseStatus2;
  })(ESearchResultParseStatus || {});
  Object.assign(window, {
    ESearchResultParseStatus
  });
  class Searcher {
    constructor(service) {
      this.service = service;
      this.searchConfigs = {};
      this.parseScriptCache = {};
      this.options = {
        sites: [],
        clients: []
      };
      this.searchRequestQueue = {};
    }
    /**
     * 搜索种子
     * @param site 需要搜索的站点
     * @param key 需要搜索的关键字
     * @param payload 附加数据
     */
    searchTorrent(site, key = "", payload) {
      this.service.debug("searchTorrent: start", key, payload);
      return new Promise((resolve, reject) => {
        let result = {
          success: false
        };
        let siteService = new SiteService(
          PPF.clone(site),
          PPF.clone(this.options)
        );
        let searchConfig = {};
        let schema = this.getSiteSchema(site);
        let host = site.host;
        let siteSearchPage = "";
        let searchEntryConfig = extend$1(
          true,
          {
            torrentTagSelectors: []
          },
          (schema == null ? void 0 : schema.searchEntryConfig) ?? {},
          siteService.options.searchEntryConfig
        );
        let searchEntryConfigQueryString = "";
        let searchEntryConfigRequestData;
        if (siteService.options.searchEntry) {
          searchConfig.rootPath = `sites/${host}/`;
          searchConfig.entry = siteService.options.searchEntry;
        } else if (schema && schema.searchEntry) {
          searchConfig.rootPath = `schemas/${schema.name}/`;
          searchConfig.entry = schema.searchEntry;
        }
        if (schema && schema.torrentTagSelectors) {
          searchConfig.torrentTagSelectors = schema.torrentTagSelectors;
        }
        if (siteService.options.torrentTagSelectors) {
          if (siteService.options.mergeSchemaTagSelectors) {
            searchConfig.torrentTagSelectors = siteService.options.torrentTagSelectors.concat(
              searchConfig.torrentTagSelectors
            );
          } else {
            searchConfig.torrentTagSelectors = siteService.options.torrentTagSelectors;
          }
        }
        if (!searchConfig.entry) {
          result.msg = this.service.i18n.t(
            "service.searcher.siteSearchConfigEntryIsEmpty",
            {
              site
            }
          );
          result.type = EDataResultType.error;
          reject(result);
          this.service.debug("searchTorrent: tip");
          return;
        }
        let isImdbSearch = false;
        let imdb = key.match(/(tt\d+)/);
        let autoMatched = false;
        if (imdb && imdb.length >= 2) {
          key = imdb[1];
          isImdbSearch = true;
        }
        let skipSearch = false;
        if (searchEntryConfig && searchEntryConfig.page) {
          siteSearchPage = searchEntryConfig.page;
          searchEntryConfigQueryString = searchEntryConfig.queryString + "";
          if (searchEntryConfig.area && !site.disableSearchTransform) {
            searchEntryConfig.area.some((area) => {
              if (area.keyAutoMatch && new RegExp(area.keyAutoMatch, "u").test(key)) {
                if (area.page) {
                  siteSearchPage = area.page;
                }
                autoMatched = true;
                if (area.queryString) {
                  searchEntryConfigQueryString = area.queryString;
                }
                if (area.requestData)
                  searchEntryConfigRequestData = area.requestData;
                if (area.appendQueryString) {
                  searchEntryConfigQueryString += area.appendQueryString;
                }
                if (area.name == "IMDB" && area.replaceKeyByTVDB) {
                  try {
                    $.ajax({
                      url: "https://thetvdb.com/api/GetSeriesByRemoteID.php?imdbid=" + key,
                      cache: true,
                      dataType: "text",
                      contentType: "text/plain",
                      timeout: this.options.connectClientTimeout || 3e4,
                      method: ERequestMethod.GET,
                      async: false
                    }).done((result2) => {
                      let doc2 = new DOMParser().parseFromString(result2, "text/html");
                      for (var replaceKey of area.replaceKeyByTVDB) {
                        switch (replaceKey) {
                          case "year":
                            let year = "";
                            let date = $(doc2).find("FirstAired").text();
                            if (date != "") {
                              year = new Date(date).getFullYear().toString();
                            }
                            searchEntryConfigQueryString = searchEntryConfigQueryString.replace("$year$", year);
                            break;
                          case "name":
                            let seriesName = $(doc2).find("SeriesName").text();
                            if (seriesName != "")
                              searchEntryConfigQueryString = searchEntryConfigQueryString.replace("$name$", seriesName);
                            else {
                              skipSearch = true;
                              return;
                            }
                            break;
                          default:
                            break;
                        }
                      }
                    }).fail((jqXHR, textStatus, errorThrown) => {
                      skipSearch = true;
                      result.type = EDataResultType.unknown;
                      reject(result);
                      return;
                    });
                  } catch {
                    skipSearch = true;
                    result.type = EDataResultType.unknown;
                    reject(result);
                    return;
                  }
                }
                if (area.name == "IMDB" && area.convertToANIDB) {
                  try {
                    $.ajax({
                      url: "https://raw.githubusercontent.com/Anime-Lists/anime-lists/master/anime-list.xml",
                      cache: true,
                      dataType: "text",
                      contentType: "text/plain",
                      timeout: this.options.connectClientTimeout || 3e4,
                      method: ERequestMethod.GET,
                      async: false
                    }).done((result2) => {
                      let doc2 = $.parseHTML(result2);
                      let selector2 = "anime[imdbid*='" + key + "']:first";
                      let anime = $(selector2, doc2);
                      if (anime.length > 0 && key.length >= 9) {
                        let anidbid = anime.attr("anidbid");
                        if (anidbid)
                          searchEntryConfigQueryString = searchEntryConfigQueryString.replace("$anidb$", anidbid);
                      } else {
                        skipSearch = true;
                      }
                    }).fail((jqXHR, textStatus, errorThrown) => {
                      skipSearch = true;
                      result.type = EDataResultType.unknown;
                      reject(result);
                      return;
                    });
                  } catch (error) {
                    skipSearch = true;
                    result.type = EDataResultType.unknown;
                    reject(result);
                    return;
                  }
                }
                if (area.replaceKey) {
                  const old = key;
                  key = key.replace(
                    new RegExp(area.replaceKey[0], "g"),
                    area.replaceKey[1]
                  );
                  console.log(`[${site.name}] "${old}" => "${key}"`);
                }
                if (area.parseScript) {
                  try {
                    key = eval(area.parseScript);
                  } catch (error) {
                  }
                }
                return true;
              }
              return false;
            });
          }
        }
        if (skipSearch) {
          resolve({
            status: "success",
            success: true,
            msg: this.getErrorMessage(
              site,
              "noTorrents",
              ""
            ),
            data: {},
            type: EDataResultType.success
          });
          return;
        }
        this.searchConfigs[host] = searchConfig;
        let results = [];
        let entryCount = 0;
        let doneCount = 0;
        const KEY = "$key$";
        if (!searchEntryConfig.keepOriginKey) {
          key = encodeURIComponent(key);
        }
        searchConfig.entry.forEach((entry2) => {
          if (entry2.skipIMDbId && isImdbSearch) {
            return;
          }
          let searchPage = entry2.entry || siteSearchPage;
          if (autoMatched && searchPage.indexOf(KEY) !== -1 && searchEntryConfigQueryString.indexOf(KEY) !== -1) {
            searchPage = PPF.removeQueryStringFromValue(searchPage, KEY);
          }
          let queryString = entry2.queryString;
          if (searchEntryConfigQueryString) {
            if (!queryString) {
              queryString = searchEntryConfigQueryString;
            } else if (queryString && queryString.indexOf(KEY) === -1) {
              queryString = searchEntryConfigQueryString + "&" + queryString;
            }
          }
          if (entry2.appendQueryString) {
            queryString += entry2.appendQueryString;
          }
          if (searchEntryConfig) {
            entry2.parseScriptFile = searchEntryConfig.parseScriptFile || entry2.parseScriptFile;
            entry2.resultType = searchEntryConfig.resultType || entry2.resultType;
            entry2.requestDataType = searchEntryConfig.requestDataType || entry2.requestDataType;
            entry2.resultSelector = searchEntryConfig.resultSelector || entry2.resultSelector;
            entry2.headers = searchEntryConfig.headers || entry2.headers;
            entry2.asyncParse = searchEntryConfig.asyncParse || entry2.asyncParse;
            entry2.requestData = searchEntryConfigRequestData || searchEntryConfig.requestData || entry2.requestData;
          }
          if (searchPage && entry2.parseScriptFile && entry2.enabled !== false) {
            let rows = this.options.search && this.options.search.rows ? this.options.search.rows : 10;
            if (site.cdn && site.cdn.length > 0) {
              site.url = site.cdn[0];
            }
            if ((site.url + "").substr(-1) != "/") {
              site.url += "/";
            }
            if ((searchPage + "").substr(0, 1) == "/") {
              searchPage = (searchPage + "").substr(1);
            }
            let url2 = "";
            if (site.apiCdn && site.apiCdn.length > 0) {
              if (!site.apiCdn[0].endsWith("/")) {
                site.apiCdn[0] += "/";
              }
              url2 = site.apiCdn[0] + searchPage;
            } else {
              url2 = site.url + searchPage;
            }
            if (queryString) {
              if (searchPage.indexOf("?") !== -1) {
                url2 += "&" + queryString;
              } else {
                url2 += "?" + queryString;
              }
            }
            url2 = PPF.removeDuplicateQueryString(url2);
            let searchKey = key + (entry2.appendToSearchKeyString ? ` ${entry2.appendToSearchKeyString}` : "");
            url2 = this.replaceKeys(url2, {
              key: searchKey,
              rows,
              passkey: site.passkey ? site.passkey : ""
            });
            if (entry2.requestData) {
              try {
                for (const key2 in entry2.requestData) {
                  if (entry2.requestData.hasOwnProperty(key2)) {
                    const value = entry2.requestData[key2];
                    if (typeof value !== "string")
                      continue;
                    entry2.requestData[key2] = PPF.replaceKeys(value, {
                      key: searchKey,
                      passkey: site.passkey ? site.passkey : ""
                    });
                    if (site.user) {
                      entry2.requestData[key2] = PPF.replaceKeys(entry2.requestData[key2], site.user, "user");
                    }
                  }
                }
              } catch (error) {
                this.service.writeErrorLog(error);
                this.service.debug(error);
              }
            }
            if (entry2.headers) {
              for (const key2 in entry2.headers) {
                if (entry2.headers.hasOwnProperty(key2)) {
                  const value = entry2.headers[key2];
                  entry2.headers[key2] = PPF.replaceKeys(value, {
                    key: searchKey,
                    passkey: site.passkey ? site.passkey : ""
                  });
                  if (site.user) {
                    entry2.headers[key2] = PPF.replaceKeys(entry2.headers[key2], site.user, "user");
                  }
                  entry2.headers[key2] = PPF.replaceKeys(entry2.headers[key2], site, "site");
                }
              }
            }
            if (site.user) {
              url2 = this.replaceKeys(url2, site.user, "user");
            }
            entryCount++;
            let scriptPath = entry2.parseScriptFile;
            if (scriptPath.substr(0, 1) !== "/") {
              scriptPath = `${searchConfig.rootPath}${scriptPath}`;
            }
            entry2.parseScript = this.parseScriptCache[scriptPath];
            if (!entry2.parseScript) {
              this.service.debug("searchTorrent: getScriptContent", scriptPath);
              APP.getScriptContent(scriptPath).done((script2) => {
                this.service.debug(
                  "searchTorrent: getScriptContent done",
                  scriptPath
                );
                this.parseScriptCache[scriptPath] = script2;
                entry2.parseScript = script2;
                this.getSearchResult(
                  url2,
                  site,
                  Object.assign(PPF.clone(searchEntryConfig), PPF.clone(entry2)),
                  searchConfig.torrentTagSelectors
                ).then((result2) => {
                  this.service.debug(
                    "searchTorrent: getSearchResult done",
                    url2
                  );
                  if (result2 && result2.length) {
                    results.push(...result2);
                  }
                  doneCount++;
                  if (doneCount === entryCount || results.length >= rows) {
                    resolve(results.slice(0, rows));
                  }
                }).catch((result2) => {
                  this.service.debug(
                    "searchTorrent: getSearchResult catch",
                    url2,
                    result2
                  );
                  doneCount++;
                  if (doneCount === entryCount) {
                    if (results.length > 0) {
                      resolve(results.slice(0, rows));
                    } else {
                      reject(result2);
                    }
                  }
                });
              }).fail((error) => {
                this.service.debug(
                  "searchTorrent: getScriptContent fail",
                  error
                );
              });
            } else {
              this.getSearchResult(
                url2,
                site,
                Object.assign(PPF.clone(searchEntryConfig), PPF.clone(entry2)),
                searchConfig.torrentTagSelectors
              ).then((result2) => {
                if (result2 && result2.length) {
                  results.push(...result2);
                }
                doneCount++;
                if (doneCount === entryCount || results.length >= rows) {
                  resolve(results.slice(0, rows));
                }
              }).catch((result2) => {
                doneCount++;
                if (doneCount === entryCount) {
                  if (results.length > 0) {
                    resolve(results.slice(0, rows));
                  } else {
                    reject(result2);
                  }
                }
              });
            }
          }
        });
        if (entryCount == 0) {
          result.msg = this.service.i18n.t(
            "service.searcher.siteSearchEntryIsEmpty",
            {
              site
            }
          );
          result.type = EDataResultType.error;
          reject(result);
        }
        this.service.debug("searchTorrent: queue done");
      });
    }
    /**
     * 获取搜索结果
     * @param url
     * @param site
     * @param entry
     * @param torrentTagSelectors
     */
    getSearchResult(url2, site2, entry2, torrentTagSelectors2) {
      return new Promise((resolve2, reject2) => {
        if (entry2.beforeSearch) {
          let pageParser = new PageParser(
            entry2.beforeSearch,
            site2,
            this.service.options.connectClientTimeout
          );
          pageParser.getInfos().then((beforeSearchData2) => {
            this.addSearchRequestQueue(
              url2,
              site2,
              entry2,
              torrentTagSelectors2,
              beforeSearchData2
            ).then((result2) => {
              resolve2(result2);
            }).catch((error) => {
              reject2(error);
            });
          }).catch((error) => {
            this.service.writeErrorLog(error);
            this.addSearchRequestQueue(url2, site2, entry2, torrentTagSelectors2).then((result2) => {
              resolve2(result2);
            }).catch((error2) => {
              reject2(error2);
            });
          });
        } else {
          this.addSearchRequestQueue(url2, site2, entry2, torrentTagSelectors2).then((result2) => {
            resolve2(result2);
          }).catch((error) => {
            reject2(error);
          });
        }
      });
    }
    /**
     * 获取搜索结果
     * @param url
     * @param site
     * @param entry
     * @param torrentTagSelectors
     */
    addSearchRequestQueue(url, site, entry, torrentTagSelectors, beforeSearchData) {
      let _entry = PPF.clone(entry);
      if (_entry.parseScript) {
        delete _entry.parseScript;
      }
      if (beforeSearchData) {
        this.service.debug("beforeSearchData", beforeSearchData);
        url = this.replaceKeys(url, beforeSearchData, "beforeSearchData");
        if (entry.requestData) {
          try {
            for (const key2 in entry.requestData) {
              if (entry.requestData.hasOwnProperty(key2)) {
                const value = entry.requestData[key2];
                entry.requestData[key2] = PPF.replaceKeys(
                  value,
                  beforeSearchData,
                  "beforeSearchData"
                );
              }
            }
          } catch (error) {
            this.service.writeErrorLog(error);
            this.service.debug(error);
          }
        }
      }
      this.service.debug("getSearchResult.start", {
        url,
        site: site.host,
        entry: _entry
      });
      let logId = "";
      let contentType = "text/plain";
      let data = entry.requestData;
      switch (entry.requestDataType) {
        case ERequestType.JSON:
          contentType = "application/json";
          if (data)
            data = JSON.stringify(data);
        case ERequestType.TEXT:
        default:
      }
      return new Promise((resolve, reject) => {
        this.searchRequestQueue[url] = $.ajax({
          url,
          cache: true,
          dataType: "text",
          contentType,
          timeout: this.options.connectClientTimeout || 3e4,
          headers: entry.headers,
          method: entry.requestMethod || ERequestMethod.GET,
          data
        }).done((result) => {
          var _a;
          this.service.debug("getSearchResult.done", url);
          delete this.searchRequestQueue[url];
          if (result && typeof result == "string" && result.length > 100 || typeof result == "object" || result && entry.resultType == ERequestResultType.JSON && result.toLowerCase().includes("success")) {
            let page;
            let doc;
            try {
              switch (entry.resultType) {
                case ERequestResultType.JSON:
                  page = JSON.parse(result);
                  break;
                default:
                  doc = new DOMParser().parseFromString(result, "text/html");
                  page = $(doc).find("body");
                  break;
              }
            } catch (error) {
              logId = this.service.logger.add({
                module: EModule.background,
                event: "service.searcher.getSearchResult.siteSearchResultParseFailed",
                msg: error
              });
              reject({
                success: false,
                msg: this.service.i18n.t(
                  "service.searcher.siteSearchResultParseFailed",
                  {
                    site
                  }
                ),
                data: {
                  logId
                },
                type: EDataResultType.error
              });
              return;
            }
            let options = {
              results: [],
              responseText: result,
              site,
              resultSelector: entry.resultSelector,
              page,
              entry,
              torrentTagSelectors,
              errorMsg: "",
              isLogged: false,
              status: "success",
              searcher: this,
              url
            };
            try {
              console.log("entry.parseScript ", (_a = entry.parseScript) == null ? void 0 : _a.length);
              if (entry.parseScript) {
                if (entry.asyncParse) {
                  options = Object.assign(
                    {
                      reject,
                      resolve
                    },
                    options
                  );
                  eval(entry.parseScript);
                  return;
                } else {
                  eval(entry.parseScript);
                }
              }
              if (options.errorMsg || options.status != "success") {
                reject({
                  success: false,
                  msg: this.getErrorMessage(
                    site,
                    options.status,
                    options.errorMsg
                  ),
                  data: {
                    site,
                    isLogged: options.isLogged
                  }
                });
              } else {
                resolve(PPF.clone(options.results));
              }
            } catch (error) {
              console.error(error);
              logId = this.service.logger.add({
                module: EModule.background,
                event: "service.searcher.getSearchResult.siteEvalScriptFailed",
                msg: error
              });
              reject({
                success: false,
                msg: this.service.i18n.t(
                  "service.searcher.siteEvalScriptFailed",
                  {
                    site
                  }
                ),
                data: {
                  logId
                }
              });
            }
          } else {
            logId = this.service.logger.add({
              module: EModule.background,
              event: "service.searcher.getSearchResult.siteSearchResultError",
              msg: result
            });
            reject({
              success: false,
              msg: this.service.i18n.t(
                "service.searcher.siteSearchResultError",
                {
                  site
                }
              ),
              data: {
                logId
              },
              type: EDataResultType.error
            });
          }
        }).fail((jqXHR, textStatus, errorThrown) => {
          delete this.searchRequestQueue[url];
          this.service.debug({
            title: "getSearchResult.fail",
            url,
            entry,
            textStatus,
            errorThrown
          });
          logId = this.service.logger.add({
            module: EModule.background,
            event: "service.searcher.getSearchResult.fail",
            msg: errorThrown,
            data: {
              url,
              entry,
              code: jqXHR.status,
              textStatus,
              errorThrown,
              responseText: jqXHR.responseText
            }
          });
          reject({
            data: {
              logId,
              textStatus
            },
            msg: this.service.i18n.t("service.searcher.siteNetworkFailed", {
              site,
              msg: `${jqXHR.status} ${errorThrown}, ${textStatus}`
            }),
            success: false,
            type: EDataResultType.error
          });
        });
      });
    }
    /**
     * 根据错误代码获取错误信息
     * @param code
     */
    getErrorMessage(site2, status = "success", msg = "") {
      if (status != "success") {
        return this.service.i18n.t(`contentPage.search.${status}`, {
          siteName: site2.name,
          msg
        });
      }
      return msg;
    }
    /**
     * 取消正在执行的搜索请求
     * @param site
     * @param key
     */
    abortSearch(site2, key2 = "") {
      return new Promise((resolve2, reject2) => {
        let host2 = site2.host + "";
        let searchConfig2 = this.searchConfigs[host2];
        if (searchConfig2.entry) {
          this.service.logger.add({
            module: EModule.background,
            event: "searcher.abortSearch",
            msg: this.service.i18n.t("service.searcher.siteAbortSearch", {
              site: site2
            }),
            //`正在取消[${site.host}]的搜索请求`,
            data: {
              site: site2.host,
              key: key2
            }
          });
          searchConfig2.entry.forEach((entry2) => {
            if (entry2.entry && entry2.parseScriptFile && entry2.enabled !== false) {
              if (site2.cdn && site2.cdn.length > 0) {
                site2.url = site2.cdn[0];
              }
              let rows = this.options.search && this.options.search.rows ? this.options.search.rows : 10;
              let url2 = site2.url + entry2.entry;
              url2 = this.replaceKeys(url2, {
                key: key2,
                rows,
                passkey: site2.passkey ? site2.passkey : ""
              });
              let queue2 = this.searchRequestQueue[url2];
              if (queue2) {
                try {
                  queue2.abort();
                  resolve2();
                } catch (error) {
                  this.service.logger.add({
                    module: EModule.background,
                    event: "searcher.abortSearch.error",
                    msg: this.service.i18n.t(
                      "service.searcher.siteAbortSearchError",
                      {
                        site: site2
                      }
                    ),
                    // "取消搜索请求失败",
                    data: {
                      site: site2.host,
                      key: key2,
                      error
                    }
                  });
                  reject2(error);
                }
              } else {
                resolve2();
              }
            } else {
              resolve2();
            }
          });
        }
      });
    }
    /**
     * 根据指定的站点获取站点的架构信息
     * @param site 站点信息
     */
    getSiteSchema(site2) {
      let schema2 = {};
      if (typeof site2.schema === "string") {
        schema2 = this.options.system && this.options.system.schemas && this.options.system.schemas.find((item) => {
          return item.name == site2.schema;
        });
        if (schema2 === void 0) {
          return schema2;
        }
      }
      return PPF.clone(schema2);
    }
    /**
     * 替换指定的字符串列表
     * @param source
     * @param keys
     */
    replaceKeys(source2, keys, prefix = "") {
      let result2 = source2;
      for (const key2 in keys) {
        if (keys.hasOwnProperty(key2)) {
          const value = keys[key2];
          let search = "$" + key2 + "$";
          if (prefix) {
            search = `$${prefix}.${key2}$`;
          }
          result2 = result2.replace(search, value);
        }
      }
      return result2;
    }
    /**
     * 从当前行中获取指定字段的值
     * @param site 当前站点
     * @param row 当前行
     * @param fieldName 字段名称
     * @return null 表示没有获取到内容
     */
    getFieldValue(site2, row, fieldName = "") {
      let selector2;
      if (site2.searchEntryConfig && site2.searchEntryConfig.fieldSelector) {
        selector2 = site2.searchEntryConfig.fieldSelector[fieldName];
        if (!selector2) {
          return null;
        }
      } else {
        return null;
      }
      const parser2 = new InfoParser(this.service);
      return parser2.getFieldData(
        row,
        selector2,
        site2.searchEntryConfig.fieldSelector
      );
    }
    /**
     * 根据指定信息获取分类
     * @param site 站点
     * @param page 当前搜索页面
     * @param id 分类ID
     */
    getCategoryById(site2, page2, id) {
      let result2 = {};
      if (site2.categories) {
        site2.categories.forEach((item) => {
          if (item.category && (item.entry == "*" || page2.indexOf(item.entry))) {
            let category = item.category.find((c2) => {
              return c2.id == id;
            });
            if (category) {
              result2 = category;
            }
          }
        });
      }
      return result2;
    }
    /**
     * cloudflare Email 解码方法，来自 https://usamaejaz.com/cloudflare-email-decoding/
     * @param {*} encodedString
     */
    cfDecodeEmail(encodedString) {
      let email = "", r2 = parseInt(encodedString.substr(0, 2), 16), n2, i2;
      for (n2 = 2; encodedString.length - n2; n2 += 2) {
        i2 = parseInt(encodedString.substr(n2, 2), 16) ^ r2;
        email += String.fromCharCode(i2);
      }
      return email;
    }
    /**
     * 获取指定站点当前行标签列表
     * @param site
     * @param row
     */
    getRowTags(site2, row) {
      let tags = [];
      if (site2 && site2.host) {
        let config2 = this.searchConfigs[site2.host];
        let selectors2 = config2.torrentTagSelectors;
        if (selectors2 && selectors2.length > 0) {
          selectors2.forEach((item) => {
            if (item.selector) {
              let result2 = row.find(item.selector);
              if (result2.length) {
                let color = item.color || BASE_TAG_COLORS[item.name] || "";
                let data2 = {
                  name: item.name,
                  color
                };
                if (item.title && result2.attr(item.title)) {
                  data2.title = result2.attr(item.title);
                }
                tags.push(data2);
              }
            }
          });
        }
      }
      return tags;
    }
  }
  "use strict";
  var requiresPort = function required2(port2, protocol) {
    protocol = protocol.split(":")[0];
    port2 = +port2;
    if (!port2)
      return false;
    switch (protocol) {
      case "http":
      case "ws":
        return port2 !== 80;
      case "https":
      case "wss":
        return port2 !== 443;
      case "ftp":
        return port2 !== 21;
      case "gopher":
        return port2 !== 70;
      case "file":
        return false;
    }
    return port2 !== 0;
  };
  const index$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(requiresPort);
  var querystringify$1 = {};
  "use strict";
  var has = Object.prototype.hasOwnProperty, undef;
  function decode$3(input) {
    try {
      return decodeURIComponent(input.replace(/\+/g, " "));
    } catch (e2) {
      return null;
    }
  }
  function encode$3(input) {
    try {
      return encodeURIComponent(input);
    } catch (e2) {
      return null;
    }
  }
  function querystring(query2) {
    var parser2 = /([^=?#&]+)=?([^&]*)/g, result2 = {}, part;
    while (part = parser2.exec(query2)) {
      var key2 = decode$3(part[1]), value = decode$3(part[2]);
      if (key2 === null || value === null || key2 in result2)
        continue;
      result2[key2] = value;
    }
    return result2;
  }
  function querystringify(obj, prefix) {
    prefix = prefix || "";
    var pairs = [], value, key2;
    if ("string" !== typeof prefix)
      prefix = "?";
    for (key2 in obj) {
      if (has.call(obj, key2)) {
        value = obj[key2];
        if (!value && (value === null || value === undef || isNaN(value))) {
          value = "";
        }
        key2 = encode$3(key2);
        value = encode$3(value);
        if (key2 === null || value === null)
          continue;
        pairs.push(key2 + "=" + value);
      }
    }
    return pairs.length ? prefix + pairs.join("&") : "";
  }
  var stringify = querystringify$1.stringify = querystringify;
  var parse = querystringify$1.parse = querystring;
  "use strict";
  var required = requiresPort, qs = querystringify$1, controlOrWhitespace = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/, CRHTLF = /[\n\r\t]/g, slashes = /^[A-Za-z][A-Za-z0-9+-.]*:\/\//, port = /:\d+$/, protocolre = /^([a-z][a-z0-9.+-]*:)?(\/\/)?([\\/]+)?([\S\s]*)/i, windowsDriveLetter = /^[a-zA-Z]:/;
  function trimLeft(str) {
    return (str ? str : "").toString().replace(controlOrWhitespace, "");
  }
  var rules = [
    ["#", "hash"],
    // Extract from the back.
    ["?", "query"],
    // Extract from the back.
    function sanitize(address, url2) {
      return isSpecial(url2.protocol) ? address.replace(/\\/g, "/") : address;
    },
    ["/", "pathname"],
    // Extract from the back.
    ["@", "auth", 1],
    // Extract from the front.
    [NaN, "host", void 0, 1, 1],
    // Set left over value.
    [/:(\d*)$/, "port", void 0, 1],
    // RegExp the back.
    [NaN, "hostname", void 0, 1, 1]
    // Set left over.
  ];
  var ignore = { hash: 1, query: 1 };
  function lolcation(loc) {
    var globalVar;
    if (typeof window !== "undefined")
      globalVar = window;
    else if (typeof commonjsGlobal !== "undefined")
      globalVar = commonjsGlobal;
    else if (typeof self !== "undefined")
      globalVar = self;
    else
      globalVar = {};
    var location2 = globalVar.location || {};
    loc = loc || location2;
    var finaldestination = {}, type = typeof loc, key2;
    if ("blob:" === loc.protocol) {
      finaldestination = new Url(unescape(loc.pathname), {});
    } else if ("string" === type) {
      finaldestination = new Url(loc, {});
      for (key2 in ignore)
        delete finaldestination[key2];
    } else if ("object" === type) {
      for (key2 in loc) {
        if (key2 in ignore)
          continue;
        finaldestination[key2] = loc[key2];
      }
      if (finaldestination.slashes === void 0) {
        finaldestination.slashes = slashes.test(loc.href);
      }
    }
    return finaldestination;
  }
  function isSpecial(scheme) {
    return scheme === "file:" || scheme === "ftp:" || scheme === "http:" || scheme === "https:" || scheme === "ws:" || scheme === "wss:";
  }
  function extractProtocol(address, location2) {
    address = trimLeft(address);
    address = address.replace(CRHTLF, "");
    location2 = location2 || {};
    var match = protocolre.exec(address);
    var protocol = match[1] ? match[1].toLowerCase() : "";
    var forwardSlashes = !!match[2];
    var otherSlashes = !!match[3];
    var slashesCount = 0;
    var rest;
    if (forwardSlashes) {
      if (otherSlashes) {
        rest = match[2] + match[3] + match[4];
        slashesCount = match[2].length + match[3].length;
      } else {
        rest = match[2] + match[4];
        slashesCount = match[2].length;
      }
    } else {
      if (otherSlashes) {
        rest = match[3] + match[4];
        slashesCount = match[3].length;
      } else {
        rest = match[4];
      }
    }
    if (protocol === "file:") {
      if (slashesCount >= 2) {
        rest = rest.slice(2);
      }
    } else if (isSpecial(protocol)) {
      rest = match[4];
    } else if (protocol) {
      if (forwardSlashes) {
        rest = rest.slice(2);
      }
    } else if (slashesCount >= 2 && isSpecial(location2.protocol)) {
      rest = match[4];
    }
    return {
      protocol,
      slashes: forwardSlashes || isSpecial(protocol),
      slashesCount,
      rest
    };
  }
  function resolve(relative, base) {
    if (relative === "")
      return base;
    var path2 = (base || "/").split("/").slice(0, -1).concat(relative.split("/")), i2 = path2.length, last = path2[i2 - 1], unshift = false, up = 0;
    while (i2--) {
      if (path2[i2] === ".") {
        path2.splice(i2, 1);
      } else if (path2[i2] === "..") {
        path2.splice(i2, 1);
        up++;
      } else if (up) {
        if (i2 === 0)
          unshift = true;
        path2.splice(i2, 1);
        up--;
      }
    }
    if (unshift)
      path2.unshift("");
    if (last === "." || last === "..")
      path2.push("");
    return path2.join("/");
  }
  function Url(address, location2, parser2) {
    address = trimLeft(address);
    address = address.replace(CRHTLF, "");
    if (!(this instanceof Url)) {
      return new Url(address, location2, parser2);
    }
    var relative, extracted, parse2, instruction, index2, key2, instructions = rules.slice(), type = typeof location2, url2 = this, i2 = 0;
    if ("object" !== type && "string" !== type) {
      parser2 = location2;
      location2 = null;
    }
    if (parser2 && "function" !== typeof parser2)
      parser2 = qs.parse;
    location2 = lolcation(location2);
    extracted = extractProtocol(address || "", location2);
    relative = !extracted.protocol && !extracted.slashes;
    url2.slashes = extracted.slashes || relative && location2.slashes;
    url2.protocol = extracted.protocol || location2.protocol || "";
    address = extracted.rest;
    if (extracted.protocol === "file:" && (extracted.slashesCount !== 2 || windowsDriveLetter.test(address)) || !extracted.slashes && (extracted.protocol || extracted.slashesCount < 2 || !isSpecial(url2.protocol))) {
      instructions[3] = [/(.*)/, "pathname"];
    }
    for (; i2 < instructions.length; i2++) {
      instruction = instructions[i2];
      if (typeof instruction === "function") {
        address = instruction(address, url2);
        continue;
      }
      parse2 = instruction[0];
      key2 = instruction[1];
      if (parse2 !== parse2) {
        url2[key2] = address;
      } else if ("string" === typeof parse2) {
        index2 = parse2 === "@" ? address.lastIndexOf(parse2) : address.indexOf(parse2);
        if (~index2) {
          if ("number" === typeof instruction[2]) {
            url2[key2] = address.slice(0, index2);
            address = address.slice(index2 + instruction[2]);
          } else {
            url2[key2] = address.slice(index2);
            address = address.slice(0, index2);
          }
        }
      } else if (index2 = parse2.exec(address)) {
        url2[key2] = index2[1];
        address = address.slice(0, index2.index);
      }
      url2[key2] = url2[key2] || (relative && instruction[3] ? location2[key2] || "" : "");
      if (instruction[4])
        url2[key2] = url2[key2].toLowerCase();
    }
    if (parser2)
      url2.query = parser2(url2.query);
    if (relative && location2.slashes && url2.pathname.charAt(0) !== "/" && (url2.pathname !== "" || location2.pathname !== "")) {
      url2.pathname = resolve(url2.pathname, location2.pathname);
    }
    if (url2.pathname.charAt(0) !== "/" && isSpecial(url2.protocol)) {
      url2.pathname = "/" + url2.pathname;
    }
    if (!required(url2.port, url2.protocol)) {
      url2.host = url2.hostname;
      url2.port = "";
    }
    url2.username = url2.password = "";
    if (url2.auth) {
      index2 = url2.auth.indexOf(":");
      if (~index2) {
        url2.username = url2.auth.slice(0, index2);
        url2.username = encodeURIComponent(decodeURIComponent(url2.username));
        url2.password = url2.auth.slice(index2 + 1);
        url2.password = encodeURIComponent(decodeURIComponent(url2.password));
      } else {
        url2.username = encodeURIComponent(decodeURIComponent(url2.auth));
      }
      url2.auth = url2.password ? url2.username + ":" + url2.password : url2.username;
    }
    url2.origin = url2.protocol !== "file:" && isSpecial(url2.protocol) && url2.host ? url2.protocol + "//" + url2.host : "null";
    url2.href = url2.toString();
  }
  function set(part, value, fn) {
    var url2 = this;
    switch (part) {
      case "query":
        if ("string" === typeof value && value.length) {
          value = (fn || qs.parse)(value);
        }
        url2[part] = value;
        break;
      case "port":
        url2[part] = value;
        if (!required(value, url2.protocol)) {
          url2.host = url2.hostname;
          url2[part] = "";
        } else if (value) {
          url2.host = url2.hostname + ":" + value;
        }
        break;
      case "hostname":
        url2[part] = value;
        if (url2.port)
          value += ":" + url2.port;
        url2.host = value;
        break;
      case "host":
        url2[part] = value;
        if (port.test(value)) {
          value = value.split(":");
          url2.port = value.pop();
          url2.hostname = value.join(":");
        } else {
          url2.hostname = value;
          url2.port = "";
        }
        break;
      case "protocol":
        url2.protocol = value.toLowerCase();
        url2.slashes = !fn;
        break;
      case "pathname":
      case "hash":
        if (value) {
          var char = part === "pathname" ? "/" : "#";
          url2[part] = value.charAt(0) !== char ? char + value : value;
        } else {
          url2[part] = value;
        }
        break;
      case "username":
      case "password":
        url2[part] = encodeURIComponent(value);
        break;
      case "auth":
        var index2 = value.indexOf(":");
        if (~index2) {
          url2.username = value.slice(0, index2);
          url2.username = encodeURIComponent(decodeURIComponent(url2.username));
          url2.password = value.slice(index2 + 1);
          url2.password = encodeURIComponent(decodeURIComponent(url2.password));
        } else {
          url2.username = encodeURIComponent(decodeURIComponent(value));
        }
    }
    for (var i2 = 0; i2 < rules.length; i2++) {
      var ins = rules[i2];
      if (ins[4])
        url2[ins[1]] = url2[ins[1]].toLowerCase();
    }
    url2.auth = url2.password ? url2.username + ":" + url2.password : url2.username;
    url2.origin = url2.protocol !== "file:" && isSpecial(url2.protocol) && url2.host ? url2.protocol + "//" + url2.host : "null";
    url2.href = url2.toString();
    return url2;
  }
  function toString(stringify2) {
    if (!stringify2 || "function" !== typeof stringify2)
      stringify2 = qs.stringify;
    var query2, url2 = this, host2 = url2.host, protocol = url2.protocol;
    if (protocol && protocol.charAt(protocol.length - 1) !== ":")
      protocol += ":";
    var result2 = protocol + (url2.protocol && url2.slashes || isSpecial(url2.protocol) ? "//" : "");
    if (url2.username) {
      result2 += url2.username;
      if (url2.password)
        result2 += ":" + url2.password;
      result2 += "@";
    } else if (url2.password) {
      result2 += ":" + url2.password;
      result2 += "@";
    } else if (url2.protocol !== "file:" && isSpecial(url2.protocol) && !host2 && url2.pathname !== "/") {
      result2 += "@";
    }
    if (host2[host2.length - 1] === ":" || port.test(url2.hostname) && !url2.port) {
      host2 += ":";
    }
    result2 += host2 + url2.pathname;
    query2 = "object" === typeof url2.query ? stringify2(url2.query) : url2.query;
    if (query2)
      result2 += "?" !== query2.charAt(0) ? "?" + query2 : query2;
    if (url2.hash)
      result2 += url2.hash;
    return result2;
  }
  Url.prototype = { set, toString };
  Url.extractProtocol = extractProtocol;
  Url.location = lolcation;
  Url.trimLeft = trimLeft;
  Url.qs = qs;
  var urlParse = Url;
  const URLParse = /* @__PURE__ */ getDefaultExportFromCjs$1(urlParse);
  class User {
    constructor(service) {
      this.service = service;
      this.requestQueue = {};
      this.requestQueueCount = 0;
      this.infoParserCache = {};
      this.InfoParser = InfoParser;
    }
    /**
     * 刷新用户数据
     * @param failedOnly 是否仅刷新最近状态为失败的站点
     */
    refreshUserData(failedOnly = false) {
      return new Promise((resolve2, reject2) => {
        let requests2 = [];
        this.service.options.sites.forEach((site2) => {
          if (!site2.allowGetUserInfo || site2.offline) {
            return false;
          }
          if (!failedOnly) {
            requests2.push(this.getUserInfo(site2, true));
          } else {
            if (site2.user) {
              let enumStatus = [EUserDataRequestStatus.needLogin, EUserDataRequestStatus.unknown];
              let lastUpdateStatus = enumStatus.includes(site2.user.lastUpdateStatus);
              if (site2.user.lastUpdateStatus && lastUpdateStatus || !site2.user.lastUpdateStatus) {
                requests2.push(this.getUserInfo(site2, true));
              }
            }
          }
        });
        Promise.all(requests2).then((results2) => {
          resolve2(results2);
        });
      });
    }
    updateStatus(site2, userInfo2) {
      userInfo2.lastUpdateTime = (/* @__PURE__ */ new Date()).getTime();
      this.service.userData.update(site2, userInfo2);
    }
    getSiteURL(site2) {
      if (site2.apiCdn && site2.apiCdn.length > 0) {
        return site2.apiCdn[0];
      }
      if (site2.cdn && site2.cdn.length > 0) {
        return site2.cdn[0];
      }
      return site2.url;
    }
    /**
     * 获取指定站点的用户信息
     * @param site
     * @param returnResolve 指定为 true 时，失败时也调用 resolve
     */
    getUserInfo(site2, returnResolve = false) {
      this.service.options.autoRefreshUserDataLastTime = (/* @__PURE__ */ new Date()).getTime();
      this.service.saveConfig();
      return new Promise((resolve2, reject2) => {
        let rejectFN = returnResolve ? resolve2 : reject2;
        if (!site2) {
          rejectFN(null);
          return;
        }
        let userInfo2 = this.service.userData.get(site2.host) || {};
        let rule2 = this.service.getSiteSelector(site2, "userBaseInfo");
        if (!rule2) {
          userInfo2.lastUpdateStatus = EUserDataRequestStatus.notSupported;
          this.updateStatus(site2, userInfo2);
          rejectFN(
            APP.createErrorMessage({
              status: EUserDataRequestStatus.notSupported,
              msg: this.service.i18n.t("service.user.notSupported")
              // "暂不支持"
            })
          );
          return;
        }
        let url2 = `${this.getSiteURL(site2)}${rule2.page}`;
        let host2 = site2.host;
        if (this.checkQueue(host2, url2)) {
          resolve2(userInfo2);
          return;
        }
        this.getInfos(host2, url2, rule2, site2).then((result2) => {
          var _a;
          console.log("userBaseInfo", host2, result2);
          userInfo2 = Object.assign({}, result2);
          if ((_a = rule2 == null ? void 0 : rule2.fields) == null ? void 0 : _a.isLogged) {
            if (userInfo2.isLogged && (userInfo2.name || userInfo2.id)) {
              userInfo2.isLogged = true;
            } else {
              userInfo2.isLogged = false;
            }
          } else if (userInfo2.name || userInfo2.id) {
            userInfo2.isLogged = true;
          }
          if (!userInfo2.isLogged) {
            userInfo2.lastUpdateStatus = EUserDataRequestStatus.needLogin;
            rejectFN(
              APP.createErrorMessage({
                msg: this.service.i18n.t("service.user.notLogged"),
                //"未登录",
                status: EUserDataRequestStatus.needLogin
              })
            );
            return;
          }
          rule2 = this.service.getSiteSelector(site2, "userExtendInfo");
          if (!rule2) {
            this.updateStatus(site2, userInfo2);
            userInfo2.lastUpdateStatus = EUserDataRequestStatus.success;
            resolve2(userInfo2);
            return;
          }
          if (userInfo2.name || userInfo2.id) {
            let url3 = `${this.getSiteURL(site2)}${rule2.page.replace("$user.id$", userInfo2.id).replace("$user.name$", userInfo2.name).replace("$user.bonusPage$", userInfo2.bonusPage).replace("$user.unsatisfiedsPage$", userInfo2.unsatisfiedsPage)}`;
            if (this.checkQueue(host2, url3)) {
              resolve2(userInfo2);
              return;
            }
            this.getInfos(host2, url3, rule2, site2, userInfo2).then((result3) => {
              userInfo2 = Object.assign(userInfo2, result3);
              userInfo2.lastUpdateStatus = EUserDataRequestStatus.success;
              this.updateStatus(site2, userInfo2);
              this.getMoreInfos(site2, userInfo2).then(() => {
                resolve2(userInfo2);
              });
            }).catch((error) => {
              userInfo2.lastUpdateStatus = EUserDataRequestStatus.unknown;
              rejectFN(APP.createErrorMessage(error));
            });
          } else {
            userInfo2.lastUpdateStatus = EUserDataRequestStatus.unknown;
            rejectFN(
              APP.createErrorMessage({
                status: EUserDataRequestStatus.unknown,
                msg: this.service.i18n.t("service.user.getUserInfoFailed")
                //"获取用户名和编号失败"
              })
            );
          }
        }).catch((error) => {
          userInfo2.lastUpdateStatus = EUserDataRequestStatus.unknown;
          console.log("getInfos Error :", error);
          rejectFN(APP.createErrorMessage(error));
        });
      });
    }
    /**
     * 获取更多用户信息（如有有定义的话）
     * @param site
     * @param userInfo
     */
    getMoreInfos(site, userInfo) {
      return new Promise((resolve, reject) => {
        let requests = [];
        let selectors = ["userSeedingTorrents", "bonusExtendInfo", "hnrExtendInfo", "levelExtendInfo", "userUploadedTorrents"];
        selectors.forEach((name) => {
          let host = site.host;
          let rule = this.service.getSiteSelector(site, name);
          if (rule && rule.page) {
            let url = `${this.getSiteURL(site)}${rule.page.replace("$user.id$", userInfo.id).replace("$user.name$", userInfo.name).replace("$user.bonusPage$", userInfo.bonusPage).replace("$user.unsatisfiedsPage$", userInfo.unsatisfiedsPage)}`;
            if (this.checkQueue(host, url)) {
              return;
            }
            if (rule.prerequisites) {
              const user = userInfo;
              try {
                let result = eval(rule.prerequisites);
                if (result !== true) {
                  return;
                }
              } catch (error) {
                console.log(error);
                return;
              }
            }
            requests.push(this.getInfos(host, url, rule, site, userInfo));
          }
        });
        if (requests.length) {
          Promise.all(requests).then((results2) => {
            results2.forEach((result2) => {
              userInfo = Object.assign(userInfo, result2);
              console.log(userInfo);
              userInfo.lastUpdateStatus = EUserDataRequestStatus.success;
              this.updateStatus(site, userInfo);
            });
            resolve(userInfo);
          }).catch((result2) => {
            resolve(userInfo);
          });
        } else {
          resolve(userInfo);
        }
      });
    }
    /**
     * getInfos
     */
    getInfos(host2, url2, rule2, site2, userInfo2) {
      return new Promise((resolve2, reject2) => {
        url2 = url2.replace("://", "****").replace(/\/\//g, "/").replace("****", "://");
        let requestData = rule2.requestData;
        if (requestData && userInfo2) {
          try {
            for (const key2 in requestData) {
              if (requestData.hasOwnProperty(key2)) {
                const value = requestData[key2];
                requestData[key2] = PPF.replaceKeys(value, userInfo2, "user");
              }
            }
          } catch (error) {
            console.log(error);
          }
        }
        let headers = rule2.headers;
        if (headers && userInfo2) {
          try {
            for (const key2 in headers) {
              if (headers.hasOwnProperty(key2)) {
                const value = headers[key2];
                headers[key2] = PPF.replaceKeys(value, userInfo2, "user");
              }
            }
          } catch (error) {
            console.log(error);
          }
        }
        if (headers && site2) {
          try {
            for (const key2 in headers) {
              if (headers.hasOwnProperty(key2)) {
                const value = headers[key2];
                headers[key2] = PPF.replaceKeys(value, site2, "site");
              }
            }
          } catch (error) {
            console.log(error);
          }
        }
        if (rule2.parser && site2) {
          this.runParser(rule2, site2, userInfo2, resolve2, reject2);
          return;
        }
        PPF.updateBadge(++this.requestQueueCount);
        let request = $.ajax({
          url: url2,
          method: rule2.requestMethod || ERequestMethod.GET,
          dataType: "text",
          data: rule2.requestContentType == "application/json" ? JSON.stringify(requestData) : requestData,
          contentType: rule2.requestContentType == "application/json" ? "application/json" : "application/x-www-form-urlencoded",
          headers: rule2.headers,
          timeout: this.service.options.connectClientTimeout || 3e4,
          cache: rule2.dataType && rule2.dataType !== ERequestResultType.JSON ? false : true
        }).done((result2) => {
          this.removeQueue(host2, url2);
          PPF.updateBadge(--this.requestQueueCount);
          let content2;
          try {
            if (rule2.dataType !== ERequestResultType.JSON) {
              let doc2 = new DOMParser().parseFromString(result2, "text/html");
              let topElement = rule2.topElement || "body";
              content2 = $(doc2).find(topElement);
            } else {
              content2 = JSON.parse(result2);
            }
          } catch (error) {
            this.service.debug("getInfos.error", host2, url2, error);
            reject2(error);
            return;
          }
          if (content2 && rule2) {
            try {
              let results2 = new InfoParser().getResult(content2, rule2);
              resolve2(results2);
            } catch (error) {
              this.service.debug(error);
              reject2(error);
            }
          }
        }).fail((jqXHR, textStatus, errorThrown) => {
          this.removeQueue(host2, url2);
          PPF.updateBadge(--this.requestQueueCount);
          let msg = this.service.i18n.t("service.searcher.siteNetworkFailed", {
            site: site2,
            msg: `${jqXHR.status} ${errorThrown}, ${textStatus}`
          });
          this.service.debug(msg, host2, url2, jqXHR.responseText);
          reject2(msg);
        });
        this.addQueue(host2, url2, request);
      });
    }
    /**
     * 执行脚本解析器
     * @param rule
     * @param site
     * @param userInfo
     * @param resolve
     * @param reject
     */
    runParser(rule, site, userInfo, resolve, reject) {
      let siteConfigPath = site.schema == "publicSite" ? "publicSites" : "sites";
      if (site.path) {
        siteConfigPath += `/${site.path}`;
      } else {
        siteConfigPath += `/${site.host}`;
      }
      let path = rule.parser;
      if (path.substr(0, 1) !== "/" && path.substr(0, 4) !== "http") {
        path = `${siteConfigPath}/${path}`;
      }
      let _options = {
        site,
        rule,
        userInfo,
        resolve,
        reject
      };
      let _self = this;
      let script = this.infoParserCache[path];
      if (script) {
        eval(script);
      } else {
        APP.getScriptContent(path).done((script) => {
          this.infoParserCache[path] = script;
          eval(script);
        });
      }
    }
    addQueue(host2, url2, request) {
      let queues = this.requestQueue[host2] || {};
      queues[url2] = request;
      this.requestQueue[host2] = queues;
    }
    checkQueue(host2, url2) {
      let queues = this.requestQueue[host2] || {};
      return queues[url2] ? true : false;
    }
    removeQueue(host2, url2) {
      let queues = this.requestQueue[host2] || {};
      if (queues[url2]) {
        delete queues[url2];
      }
      this.requestQueue[host2] = queues;
    }
    /**
     * 取消正在执行的搜索请求
     * @param site
     * @param key
     */
    abortGetUserInfo(site2) {
      return new Promise((resolve2, reject2) => {
        let host2 = site2.host;
        let queues = this.requestQueue[host2];
        let errors = [];
        if (queues) {
          for (const key2 in queues) {
            if (queues.hasOwnProperty(key2)) {
              const request = queues[key2];
              try {
                request.abort();
              } catch (error) {
                this.service.logger.add({
                  module: EModule.background,
                  event: "user.abortGetUserInfo.error",
                  msg: this.service.i18n.t("service.user.abortGetUserInfoFailed"),
                  //"取消获取用户信息请求失败",
                  data: {
                    site: site2.host,
                    error
                  }
                });
                errors.push(error);
              }
            }
          }
          delete this.requestQueue[host2];
        }
        if (errors.length > 0) {
          reject2(errors);
        } else {
          resolve2(true);
        }
      });
    }
    // MAM需要在访问API时传入存于Cookies中的mam_id，构建这个辅助方法以便获取Cookie
    getCookie(site2, needle) {
      return new Promise((resolve2, reject2) => {
        PPF.checkPermissions(["cookies"]).then(() => {
          this.service.config.getCookiesFromSite(site2).then((result2) => {
            for (const cookie of result2.cookies) {
              if (cookie["name"] === needle) {
                resolve2(cookie["value"]);
              }
            }
            resolve2("");
          }).catch((error) => {
            reject2(error);
          });
        }).catch((error) => {
          reject2(error);
        });
      });
    }
  }
  class MovieInfoService {
    constructor() {
      this.doubanApiURL = "https://api.douban.com/v2";
      this.doubanFrodoApi = "https://frodo.douban.com/api/v2";
      this.douban = {
        frodo: {
          apiKeys: [
            "054022eaeae0b00e0fc068c0c0a2102a"
          ],
          entApiKeys: [
            "054022eaeae0b00e0fc068c0c0a2102a"
          ],
          // 豆瓣 frodo 接口相关方法
          methods: {
            movie: {
              search: `${this.doubanFrodoApi}/search?q=$key$&count=$count$&apiKey=$apikey$`,
              /*
                数据示例
                request: https://movie.douban.com/j/subject_suggest?q=tt0120762
                response:
                [{
                  "episode": "",
                  "img": "https://img9.doubanio.com\/view\/photo\/s_ratio_poster\/public\/p2443062814.jpg",
                  "title": "花木兰",
                  "url": "https:\/\/movie.douban.com\/subject\/1294833\/?suggest=tt0120762",
                  "type": "movie",
                  "year": "1998",
                  "sub_title": "Mulan",
                  "id": "1294833"
                }]
              */
              imdb: `https://omit.mkrobot.org/movie/infos/$imdbid$`,
              subject: `https://omit.mkrobot.org/movie/infos/douban$id$`
              // imdb: `https://movie.douban.com/j/subject_suggest?q=$imdbid$`,
              // subject: `${this.doubanFrodoApi}/movie/$id$?apiKey=$apikey$`
            }
          }
        },
        common: {
          apiKeys: [
            "02646d3fb69a52ff072d47bf23cef8fd",
            "0b2bdeda43b5688921839c8ecb20399b",
            "0dad551ec0f84ed02907ff5c42e8ec70",
            "0df993c66c0c636e29ecbb5344252a4a"
          ],
          entApiKeys: [
            "0dad551ec0f84ed02907ff5c42e8ec70",
            "02646d3fb69a52ff072d47bf23cef8fd"
          ],
          methods: {
            movie: {
              search: `${this.doubanApiURL}/movie/search?q=$key$&count=$count$&apikey=$apikey$`,
              imdb: `${this.doubanApiURL}/movie/imdb/$imdbid$?apikey=$apikey$`,
              subject: `${this.doubanApiURL}/movie/subject/$id$?apikey=$apikey$`
            }
          }
        }
      };
      this.omdbApiURL = "https://www.omdbapi.com";
      this.omitApiURL = "https://omit.mkrobot.org";
      this.omdbApiKeys = [
        "e0d3039d",
        "a67d9bce",
        "6be019fc",
        "4ee790e0",
        "d82cb888",
        "d58193b6",
        "15c0aa3f",
        "53acf36d",
        "3a864b75",
        "2892ab46",
        "b507af90",
        "7cf67120",
        "85b2a90c",
        "2896ff0a",
        "aa4b9983",
        "c4e08870",
        "5d5c0049",
        "79a462f2",
        "e4c3fce8",
        "918d70df",
        "e94cb667",
        "eb84d6d7",
        "e192b5a",
        "d62b4cf5",
        "5e6442a3",
        "9b1468c6"
      ];
      this.doubanApiKeys = [
        "02646d3fb69a52ff072d47bf23cef8fd",
        "0b2bdeda43b5688921839c8ecb20399b",
        "0dad551ec0f84ed02907ff5c42e8ec70",
        "0df993c66c0c636e29ecbb5344252a4a"
        // "07c78782db00a121175696889101e363"
      ];
      this.doubanEntApiKeys = [
        "0dad551ec0f84ed02907ff5c42e8ec70",
        "02646d3fb69a52ff072d47bf23cef8fd"
        // "07c78782db00a121175696889101e363"
      ];
      this.omitApiKeys = ["kiqMY6MC"];
      this.cache = {
        base: {},
        ratings: {},
        doubanToIMDb: {},
        search: {}
      };
      this.timeout = 3e3;
      this.doubanApi = this.douban.frodo;
      this.requsetQueue = {};
    }
    getInfos(key2) {
      if (/(douban\d+)/.test(key2)) {
        return this.getInfoFromDoubanId(key2.replace("douban", ""));
      }
      if (/^(tt\d+)$/.test(key2)) {
        return this.getInfoFromIMDb(key2);
      }
      return new Promise((resolve2, reject2) => {
        reject2("暂未实现");
      });
    }
    /**
     * 判断是否为 IMDbId
     * @param IMDbId
     */
    isIMDbId(IMDbId) {
      return /^(tt\d+)$/.test(IMDbId);
    }
    /**
     * 根据指定的 IMDbId 获取电影信息
     * @param IMDbId
     */
    getInfoFromIMDb(IMDbId) {
      return new Promise((resolve2, reject2) => {
        if (this.isIMDbId(IMDbId)) {
          let cache = this.cache.base[IMDbId];
          if (cache) {
            resolve2(cache);
            return;
          }
          let url2 = PPF.replaceKeys(this.doubanApi.methods.movie.imdb, {
            imdbid: IMDbId,
            apikey: this.getDoubanApiKey()
          });
          $.ajax({
            url: url2,
            timeout: this.timeout
          }).done((json) => {
            let result2;
            if (json) {
              result2 = json.data || json;
            }
            this.cache.base[IMDbId] = result2;
            resolve2(result2);
          }).fail((error) => {
            reject2(error);
          });
        } else {
          reject2("error IMDbId");
        }
      });
    }
    /**
     * 根据豆瓣ID获取影片信息
     * @param id
     */
    getInfoFromDoubanId(id) {
      return new Promise((resolve2, reject2) => {
        if (/^(\d+)$/.test(id)) {
          let cache = this.cache.base[id];
          if (cache) {
            resolve2(cache);
            return;
          }
          let url2 = PPF.replaceKeys(this.doubanApi.methods.movie.subject, {
            id,
            apikey: this.getDoubanApiKey()
          });
          $.ajax({
            url: url2,
            timeout: this.timeout
          }).done((json) => {
            let result2;
            if (json) {
              result2 = json.data || json;
            }
            this.cache.base[id] = result2;
            resolve2(result2);
          }).fail((error) => {
            reject2(error);
          });
        } else {
          reject2("error douban id");
        }
      });
    }
    /**
     * 获取评分信息
     * @param IMDbId
     */
    getRatings(IMDbId) {
      return new Promise((resolve2, reject2) => {
        if (this.isIMDbId(IMDbId)) {
          let cache = this.cache.ratings[IMDbId];
          if (cache) {
            resolve2(cache);
            return;
          }
          let requestCount = 0;
          const request = () => {
            let apikey = this.getOmdbApiKey();
            let url2 = `${this.omdbApiURL}/?i=${IMDbId}&apikey=${apikey}&tomatoes=true`;
            $.ajax({
              url: url2,
              timeout: this.timeout
            }).done((json) => {
              if (json && json.Error) {
                requestCount++;
                if (requestCount >= 5) {
                  reject2(json);
                  return;
                }
                this.removeApiKey("omdb", apikey);
                request();
                return;
              }
              this.cache.ratings[IMDbId] = json;
              resolve2(json);
            }).fail((error) => {
              reject2(error);
            });
          };
          request();
        } else {
          reject2("error IMDbId");
        }
      });
    }
    /**
     * 从OMDb apikey列表中随机获取一个key
     */
    getOmdbApiKey() {
      return this.omdbApiKeys[Math.floor(Math.random() * this.omdbApiKeys.length)];
    }
    /**
     * 从豆瓣apikey列表中随机获取一个key
     */
    getDoubanApiKey() {
      return this.doubanApi.apiKeys[Math.floor(Math.random() * this.doubanApi.apiKeys.length)];
    }
    /**
     * 获取用于查询的apikey
     */
    getDoubanEntApiKey() {
      return this.doubanApi.entApiKeys[Math.floor(Math.random() * this.doubanApi.entApiKeys.length)];
    }
    /**
     * 根据指定的 doubanId 获取 IMDbId
     * @param doubanId
     */
    getIMDbIdFromDouban(doubanId) {
      return new Promise((resolve2, reject2) => {
        let cache = this.cache.doubanToIMDb[doubanId];
        if (cache) {
          resolve2(cache);
          return;
        }
        let url2 = `${this.omitApiURL}/movie/${doubanId}/douban/imdb`;
        if (this.requsetQueue[url2]) {
          reject2();
          return;
        }
        this.requsetQueue[url2] = true;
        $.ajax({
          url: url2,
          timeout: this.timeout
        }).done((json) => {
          console.log("getIMDbIdFromDouban", json);
          if (json.data) {
            this.cache.doubanToIMDb[doubanId] = json.data;
            resolve2(json.data);
          } else {
            reject2(json);
          }
        }).fail((error) => {
          reject2(error);
        }).always(() => {
          delete this.requsetQueue[url2];
        });
      });
    }
    /**
     * 查询指定关键的影片信息
     * @param key
     * @param count
     */
    queryMovieInfoFromDouban(key2, count = 5) {
      if (this.isIMDbId(key2)) {
        return this.getInfoFromIMDb(key2);
      }
      return new Promise((resolve2, reject2) => {
        let cache = this.cache.search[key2];
        if (cache) {
          resolve2(cache);
          return;
        }
        let url2 = `${this.omitApiURL}/movie/search/${key2}`;
        if (this.requsetQueue[url2]) {
          reject2();
          return;
        }
        this.requsetQueue[url2] = true;
        $.ajax({
          url: url2,
          timeout: this.timeout
        }).done((json) => {
          console.log("queryMovieInfoFromDouban", json);
          if (json.data) {
            this.cache.search[key2] = json.data;
            resolve2(json.data);
          } else {
            reject2(json);
          }
        }).fail((error) => {
          reject2(error);
        }).always(() => {
          delete this.requsetQueue[url2];
        });
      });
    }
    /**
     * 追加API Key
     * @param type
     * @param keys
     */
    appendApiKey(type = "", keys) {
      let apiKeys;
      switch (type) {
        case "omdb":
          apiKeys = this.omdbApiKeys;
          break;
        case "douban":
          apiKeys = this.doubanApiKeys;
          break;
      }
      keys.forEach((key2) => {
        if (key2 && !apiKeys.includes(key2)) {
          apiKeys.push(key2);
        }
      });
    }
    /**
     * 移除指定的Key
     * @param type
     * @param key
     */
    removeApiKey(type = "", key2) {
      let apiKeys = [];
      switch (type) {
        case "omdb":
          apiKeys = this.omdbApiKeys;
          break;
        case "douban":
          apiKeys = this.doubanApiKeys;
          break;
      }
      let index2 = apiKeys.findIndex((item) => {
        if (item === key2) {
          return true;
        }
      });
      if (index2 !== -1) {
        apiKeys.splice(index2, 1);
      }
    }
    /**
     * 验证 OMDB API Key
     * @param key
     */
    verifyOmdbApiKey(key2) {
      return new Promise((resolve2, reject2) => {
        let url2 = `${this.omdbApiURL}/?i=tt0111161&apikey=${key2}&tomatoes=true`;
        $.ajax({
          url: url2,
          timeout: this.timeout
        }).done((json) => {
          if (json && json.Error) {
            reject2(json.Error);
            return;
          }
          resolve2();
        }).fail((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 验证豆瓣Api Key
     * @param key
     */
    verifyDoubanApiKey(key2) {
      return new Promise((resolve2, reject2) => {
        let url2 = `${this.doubanApiURL}/movie/imdb/tt0111161?apikey=${key2}`;
        $.ajax({
          url: url2,
          timeout: this.timeout
        }).done((json) => {
          if (json && json.title) {
            resolve2();
          } else {
            reject2(json.Error);
          }
        }).fail((error) => {
          reject2(error);
        });
      });
    }
    /**
     * 获取热门搜索
     * @param count 需要获取的数量，最多为100
     */
    getTopSearches(count = 9) {
      return new Promise((resolve2, reject2) => {
        $.ajax({
          url: `${this.omitApiURL}/movie/top/${count}?apikey=${this.omitApiKeys[0]}`,
          timeout: this.timeout
        }).then((result2) => {
          if (result2 == null ? void 0 : result2.data) {
            resolve2(result2.data);
          } else {
            reject2();
          }
        }).catch((error) => {
          reject2(error);
        });
      });
    }
  }
  /* Common package for dealing with hex/string/uint8 conversions (and sha1 hashing)
  *
  * @author   Jimmy Wärting <jimmy@warting.se> (https://jimmy.warting.se/opensource)
  * @license  MIT
  */
  const alphabet = "0123456789abcdef";
  const encodeLookup = [];
  const decodeLookup = [];
  for (let i2 = 0; i2 < 256; i2++) {
    encodeLookup[i2] = alphabet[i2 >> 4 & 15] + alphabet[i2 & 15];
    if (i2 < 16) {
      if (i2 < 10) {
        decodeLookup[48 + i2] = i2;
      } else {
        decodeLookup[97 - 10 + i2] = i2;
      }
    }
  }
  const arr2hex = (data2) => {
    const length = data2.length;
    let string = "";
    let i2 = 0;
    while (i2 < length) {
      string += encodeLookup[data2[i2++]];
    }
    return string;
  };
  const hex2arr = (str) => {
    const sizeof = str.length >> 1;
    const length = sizeof << 1;
    const array = new Uint8Array(sizeof);
    let n2 = 0;
    let i2 = 0;
    while (i2 < length) {
      array[n2++] = decodeLookup[str.charCodeAt(i2++)] << 4 | decodeLookup[str.charCodeAt(i2++)];
    }
    return array;
  };
  const concat = (chunks, size = 0) => {
    const length = chunks.length || 0;
    if (!size) {
      let i3 = length;
      while (i3--)
        size += chunks[i3].length;
    }
    const b = new Uint8Array(size);
    let offset = size;
    let i2 = length;
    while (i2--) {
      offset -= chunks[i2].length;
      b.set(chunks[i2], offset);
    }
    return b;
  };
  const equal = (a2, b) => {
    if (a2.length !== b.length)
      return false;
    for (let i2 = a2.length; i2 > -1; i2 -= 1) {
      if (a2[i2] !== b[i2])
        return false;
    }
    return true;
  };
  var chars$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var lookup = typeof Uint8Array === "undefined" ? [] : new Uint8Array(256);
  for (var i = 0; i < chars$1.length; i++) {
    lookup[chars$1.charCodeAt(i)] = i;
  }
  var encode$2 = function(arraybuffer) {
    var bytes = new Uint8Array(arraybuffer), i2, len2 = bytes.length, base64 = "";
    for (i2 = 0; i2 < len2; i2 += 3) {
      base64 += chars$1[bytes[i2] >> 2];
      base64 += chars$1[(bytes[i2] & 3) << 4 | bytes[i2 + 1] >> 4];
      base64 += chars$1[(bytes[i2 + 1] & 15) << 2 | bytes[i2 + 2] >> 6];
      base64 += chars$1[bytes[i2 + 2] & 63];
    }
    if (len2 % 3 === 2) {
      base64 = base64.substring(0, base64.length - 1) + "=";
    } else if (len2 % 3 === 1) {
      base64 = base64.substring(0, base64.length - 2) + "==";
    }
    return base64;
  };
  var decode$2 = function(base64) {
    var bufferLength = base64.length * 0.75, len2 = base64.length, i2, p2 = 0, encoded1, encoded2, encoded3, encoded4;
    if (base64[base64.length - 1] === "=") {
      bufferLength--;
      if (base64[base64.length - 2] === "=") {
        bufferLength--;
      }
    }
    var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
    for (i2 = 0; i2 < len2; i2 += 4) {
      encoded1 = lookup[base64.charCodeAt(i2)];
      encoded2 = lookup[base64.charCodeAt(i2 + 1)];
      encoded3 = lookup[base64.charCodeAt(i2 + 2)];
      encoded4 = lookup[base64.charCodeAt(i2 + 3)];
      bytes[p2++] = encoded1 << 2 | encoded2 >> 4;
      bytes[p2++] = (encoded2 & 15) << 4 | encoded3 >> 2;
      bytes[p2++] = (encoded3 & 3) << 6 | encoded4 & 63;
    }
    return arraybuffer;
  };
  const decoder = new TextDecoder();
  const arr2text = (data2, enc) => {
    if (!enc)
      return decoder.decode(data2);
    const dec = new TextDecoder(enc);
    return dec.decode(data2);
  };
  const encoder = new TextEncoder();
  const text2arr = (str) => encoder.encode(str);
  const arr2base = (data2) => encode$2(data2);
  const base2arr = (str) => new Uint8Array(decode$2(str));
  const bin2hex = (str) => {
    let res = "";
    let c2;
    let i2 = 0;
    const len2 = str.length;
    while (i2 < len2) {
      c2 = str.charCodeAt(i2++);
      res += alphabet[c2 >> 4] + alphabet[c2 & 15];
    }
    return res;
  };
  const MAX_ARGUMENTS_LENGTH = 65536;
  const hex2bin = (hex) => {
    const points = hex2arr(hex);
    if (points.length <= MAX_ARGUMENTS_LENGTH)
      return String.fromCharCode(...points);
    let res = "";
    let i2 = 0;
    while (i2 < points.length) {
      res += String.fromCharCode(...points.subarray(i2, i2 += MAX_ARGUMENTS_LENGTH));
    }
    return res;
  };
  const scope = typeof window !== "undefined" ? window : self;
  const crypto = scope.crypto || scope.msCrypto || {};
  const subtle = crypto.subtle || crypto.webkitSubtle;
  const formatMap = {
    hex: arr2hex,
    base64: arr2base
  };
  const hash = async (data2, format, algo = "sha-1") => {
    if (!subtle)
      throw new Error("no web crypto support");
    if (typeof data2 === "string")
      data2 = text2arr(data2);
    const out = new Uint8Array(await subtle.digest(algo, data2));
    return format ? formatMap[format](out) : out;
  };
  const randomBytes = (size) => {
    const view = new Uint8Array(size);
    return crypto.getRandomValues(view);
  };
  function digitCount(value) {
    const sign = value < 0 ? 1 : 0;
    value = Math.abs(Number(value || 1));
    return Math.floor(Math.log10(value)) + 1 + sign;
  }
  function getType(value) {
    if (ArrayBuffer.isView(value))
      return "arraybufferview";
    if (Array.isArray(value))
      return "array";
    if (value instanceof Number)
      return "number";
    if (value instanceof Boolean)
      return "boolean";
    if (value instanceof Set)
      return "set";
    if (value instanceof Map)
      return "map";
    if (value instanceof String)
      return "string";
    if (value instanceof ArrayBuffer)
      return "arraybuffer";
    return typeof value;
  }
  function encode$1(data2, buffer2, offset) {
    const buffers = [];
    let result2 = null;
    encode$1._encode(buffers, data2);
    result2 = concat(buffers);
    encode$1.bytes = result2.length;
    if (ArrayBuffer.isView(buffer2)) {
      buffer2.set(result2, offset);
      return buffer2;
    }
    return result2;
  }
  encode$1.bytes = -1;
  encode$1._floatConversionDetected = false;
  encode$1._encode = function(buffers, data2) {
    if (data2 == null) {
      return;
    }
    switch (getType(data2)) {
      case "object":
        encode$1.dict(buffers, data2);
        break;
      case "map":
        encode$1.dictMap(buffers, data2);
        break;
      case "array":
        encode$1.list(buffers, data2);
        break;
      case "set":
        encode$1.listSet(buffers, data2);
        break;
      case "string":
        encode$1.string(buffers, data2);
        break;
      case "number":
        encode$1.number(buffers, data2);
        break;
      case "boolean":
        encode$1.number(buffers, data2);
        break;
      case "arraybufferview":
        encode$1.buffer(buffers, new Uint8Array(data2.buffer, data2.byteOffset, data2.byteLength));
        break;
      case "arraybuffer":
        encode$1.buffer(buffers, new Uint8Array(data2));
        break;
    }
  };
  const buffE = new Uint8Array([101]);
  const buffD = new Uint8Array([100]);
  const buffL = new Uint8Array([108]);
  encode$1.buffer = function(buffers, data2) {
    buffers.push(text2arr(data2.length + ":"), data2);
  };
  encode$1.string = function(buffers, data2) {
    buffers.push(text2arr(text2arr(data2).byteLength + ":" + data2));
  };
  encode$1.number = function(buffers, data2) {
    if (Number.isInteger(data2))
      return buffers.push(text2arr("i" + BigInt(data2) + "e"));
    const maxLo = 2147483648;
    const hi = data2 / maxLo << 0;
    const lo = data2 % maxLo << 0;
    const val2 = hi * maxLo + lo;
    buffers.push(text2arr("i" + val2 + "e"));
    if (val2 !== data2 && !encode$1._floatConversionDetected) {
      encode$1._floatConversionDetected = true;
      console.warn(
        'WARNING: Possible data corruption detected with value "' + data2 + '":',
        'Bencoding only defines support for integers, value was converted to "' + val2 + '"'
      );
      console.trace();
    }
  };
  encode$1.dict = function(buffers, data2) {
    buffers.push(buffD);
    let j = 0;
    let k;
    const keys = Object.keys(data2).sort();
    const kl = keys.length;
    for (; j < kl; j++) {
      k = keys[j];
      if (data2[k] == null)
        continue;
      encode$1.string(buffers, k);
      encode$1._encode(buffers, data2[k]);
    }
    buffers.push(buffE);
  };
  encode$1.dictMap = function(buffers, data2) {
    buffers.push(buffD);
    const keys = Array.from(data2.keys()).sort();
    for (const key2 of keys) {
      if (data2.get(key2) == null)
        continue;
      ArrayBuffer.isView(key2) ? encode$1._encode(buffers, key2) : encode$1.string(buffers, String(key2));
      encode$1._encode(buffers, data2.get(key2));
    }
    buffers.push(buffE);
  };
  encode$1.list = function(buffers, data2) {
    let i2 = 0;
    const c2 = data2.length;
    buffers.push(buffL);
    for (; i2 < c2; i2++) {
      if (data2[i2] == null)
        continue;
      encode$1._encode(buffers, data2[i2]);
    }
    buffers.push(buffE);
  };
  encode$1.listSet = function(buffers, data2) {
    buffers.push(buffL);
    for (const item of data2) {
      if (item == null)
        continue;
      encode$1._encode(buffers, item);
    }
    buffers.push(buffE);
  };
  const INTEGER_START = 105;
  const STRING_DELIM = 58;
  const DICTIONARY_START = 100;
  const LIST_START = 108;
  const END_OF_TYPE = 101;
  function getIntFromBuffer(buffer2, start, end) {
    let sum = 0;
    let sign = 1;
    for (let i2 = start; i2 < end; i2++) {
      const num = buffer2[i2];
      if (num < 58 && num >= 48) {
        sum = sum * 10 + (num - 48);
        continue;
      }
      if (i2 === start && num === 43) {
        continue;
      }
      if (i2 === start && num === 45) {
        sign = -1;
        continue;
      }
      if (num === 46) {
        break;
      }
      throw new Error("not a number: buffer[" + i2 + "] = " + num);
    }
    return sum * sign;
  }
  function decode$1(data2, start, end, encoding) {
    if (data2 == null || data2.length === 0) {
      return null;
    }
    if (typeof start !== "number" && encoding == null) {
      encoding = start;
      start = void 0;
    }
    if (typeof end !== "number" && encoding == null) {
      encoding = end;
      end = void 0;
    }
    decode$1.position = 0;
    decode$1.encoding = encoding || null;
    decode$1.data = !ArrayBuffer.isView(data2) ? text2arr(data2) : new Uint8Array(data2.slice(start, end));
    decode$1.bytes = decode$1.data.length;
    return decode$1.next();
  }
  decode$1.bytes = 0;
  decode$1.position = 0;
  decode$1.data = null;
  decode$1.encoding = null;
  decode$1.next = function() {
    switch (decode$1.data[decode$1.position]) {
      case DICTIONARY_START:
        return decode$1.dictionary();
      case LIST_START:
        return decode$1.list();
      case INTEGER_START:
        return decode$1.integer();
      default:
        return decode$1.buffer();
    }
  };
  decode$1.find = function(chr) {
    let i2 = decode$1.position;
    const c2 = decode$1.data.length;
    const d2 = decode$1.data;
    while (i2 < c2) {
      if (d2[i2] === chr)
        return i2;
      i2++;
    }
    throw new Error(
      'Invalid data: Missing delimiter "' + String.fromCharCode(chr) + '" [0x' + chr.toString(16) + "]"
    );
  };
  decode$1.dictionary = function() {
    decode$1.position++;
    const dict = {};
    while (decode$1.data[decode$1.position] !== END_OF_TYPE) {
      const buffer2 = decode$1.buffer();
      let key2 = arr2text(buffer2);
      if (key2.includes("�"))
        key2 = arr2hex(buffer2);
      dict[key2] = decode$1.next();
    }
    decode$1.position++;
    return dict;
  };
  decode$1.list = function() {
    decode$1.position++;
    const lst = [];
    while (decode$1.data[decode$1.position] !== END_OF_TYPE) {
      lst.push(decode$1.next());
    }
    decode$1.position++;
    return lst;
  };
  decode$1.integer = function() {
    const end = decode$1.find(END_OF_TYPE);
    const number = getIntFromBuffer(decode$1.data, decode$1.position + 1, end);
    decode$1.position += end + 1 - decode$1.position;
    return number;
  };
  decode$1.buffer = function() {
    let sep = decode$1.find(STRING_DELIM);
    const length = getIntFromBuffer(decode$1.data, decode$1.position, sep);
    const end = ++sep + length;
    decode$1.position = end;
    return decode$1.encoding ? arr2text(decode$1.data.slice(sep, end)) : decode$1.data.slice(sep, end);
  };
  function listLength(list) {
    let length = 1 + 1;
    for (const value of list) {
      length += encodingLength$1(value);
    }
    return length;
  }
  function mapLength(map) {
    let length = 1 + 1;
    for (const [key2, value] of map) {
      const keyLength = text2arr(key2).byteLength;
      length += digitCount(keyLength) + 1 + keyLength;
      length += encodingLength$1(value);
    }
    return length;
  }
  function objectLength(value) {
    let length = 1 + 1;
    const keys = Object.keys(value);
    for (let i2 = 0; i2 < keys.length; i2++) {
      const keyLength = text2arr(keys[i2]).byteLength;
      length += digitCount(keyLength) + 1 + keyLength;
      length += encodingLength$1(value[keys[i2]]);
    }
    return length;
  }
  function stringLength(value) {
    const length = text2arr(value).byteLength;
    return digitCount(length) + 1 + length;
  }
  function arrayBufferLength(value) {
    const length = value.byteLength - value.byteOffset;
    return digitCount(length) + 1 + length;
  }
  function encodingLength$1(value) {
    const length = 0;
    if (value == null)
      return length;
    const type = getType(value);
    switch (type) {
      case "arraybufferview":
        return arrayBufferLength(value);
      case "string":
        return stringLength(value);
      case "array":
      case "set":
        return listLength(value);
      case "number":
        return 1 + digitCount(Math.floor(value)) + 1;
      case "bigint":
        return 1 + value.toString().length + 1;
      case "object":
        return objectLength(value);
      case "map":
        return mapLength(value);
      default:
        throw new TypeError(`Unsupported value of type "${type}"`);
    }
  }
  const encodingLength = encodingLength$1;
  const bencode = { encode: encode$1, decode: decode$1, byteLength: encodingLength$1, encodingLength };
  const Blob$1 = self.Blob;
  const File = self.File;
  const FormData$1 = self.FormData;
  const Headers = self.Headers;
  const Request = self.Request;
  const Response = self.Response;
  const AbortController = self.AbortController;
  const AbortSignal$1 = self.AbortSignal;
  const fetch = self.fetch || (() => {
    throw new Error("global fetch is not available!");
  });
  const charTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
  const byteTable = [
    255,
    255,
    26,
    27,
    28,
    29,
    30,
    31,
    255,
    255,
    255,
    255,
    255,
    255,
    255,
    255,
    255,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    255,
    255,
    255,
    255,
    255,
    255,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    255,
    255,
    255,
    255,
    255
  ];
  function quintetCount(buff) {
    const quintets = Math.floor(buff.length / 5);
    return buff.length % 5 === 0 ? quintets : quintets + 1;
  }
  const encode = function(plain) {
    if (!ArrayBuffer.isView(plain) && typeof plain !== "string") {
      throw new TypeError("base32.encode only takes Buffer or string as parameter");
    }
    if (!ArrayBuffer.isView(plain)) {
      plain = text2arr(plain);
    }
    let i2 = 0;
    let j = 0;
    let shiftIndex = 0;
    let digit = 0;
    const encoded = new Uint8Array(quintetCount(plain) * 8);
    while (i2 < plain.length) {
      const current = plain[i2];
      if (shiftIndex > 3) {
        digit = current & 255 >> shiftIndex;
        shiftIndex = (shiftIndex + 5) % 8;
        digit = digit << shiftIndex | (i2 + 1 < plain.length ? plain[i2 + 1] : 0) >> 8 - shiftIndex;
        i2++;
      } else {
        digit = current >> 8 - (shiftIndex + 5) & 31;
        shiftIndex = (shiftIndex + 5) % 8;
        if (shiftIndex === 0) {
          i2++;
        }
      }
      encoded[j] = charTable.charCodeAt(digit);
      j++;
    }
    for (i2 = j; i2 < encoded.length; i2++) {
      encoded[i2] = 61;
    }
    return encoded;
  };
  const decode = function(encoded) {
    if (!ArrayBuffer.isView(encoded) && typeof encoded !== "string") {
      throw new TypeError("base32.decode only takes Buffer or string as parameter");
    }
    let shiftIndex = 0;
    let plainDigit = 0;
    let plainChar;
    let plainPos = 0;
    if (!ArrayBuffer.isView(encoded)) {
      encoded = text2arr(encoded);
    }
    const decoded = new Uint8Array(Math.ceil(encoded.length * 5 / 8));
    for (let i2 = 0; i2 < encoded.length; i2++) {
      if (encoded[i2] === 61) {
        break;
      }
      const encodedByte = encoded[i2] - 48;
      if (encodedByte < byteTable.length) {
        plainDigit = byteTable[encodedByte];
        if (shiftIndex <= 3) {
          shiftIndex = (shiftIndex + 5) % 8;
          if (shiftIndex === 0) {
            plainChar |= plainDigit;
            decoded[plainPos] = plainChar;
            plainPos++;
            plainChar = 0;
          } else {
            plainChar |= 255 & plainDigit << 8 - shiftIndex;
          }
        } else {
          shiftIndex = (shiftIndex + 5) % 8;
          plainChar |= 255 & plainDigit >>> shiftIndex;
          decoded[plainPos] = plainChar;
          plainPos++;
          plainChar = 255 & plainDigit << 8 - shiftIndex;
        }
      } else {
        throw new Error("Invalid input - it is not base32 encoded string");
      }
    }
    return decoded.subarray(0, plainPos);
  };
  const index = { encode, decode };
  function composeRange(range) {
    return range.reduce((acc, cur, idx, arr) => {
      if (idx === 0 || cur !== arr[idx - 1] + 1)
        acc.push([]);
      acc[acc.length - 1].push(cur);
      return acc;
    }, []).map((cur) => {
      return cur.length > 1 ? `${cur[0]}-${cur[cur.length - 1]}` : `${cur[0]}`;
    });
  }
  function parseRange(range) {
    const generateRange = (start, end = start) => Array.from({ length: end - start + 1 }, (cur, idx) => idx + start);
    return range.reduce((acc, cur, idx, arr) => {
      const r2 = cur.split("-").map((cur2) => parseInt(cur2));
      return acc.concat(generateRange(...r2));
    }, []);
  }
  /*! magnet-uri. MIT License. WebTorrent LLC <https://webtorrent.io/opensource> */
  function magnetURIDecode(uri) {
    const result2 = {};
    const data2 = uri.split("magnet:?")[1];
    const params = data2 && data2.length >= 0 ? data2.split("&") : [];
    params.forEach((param) => {
      const keyval = param.split("=");
      if (keyval.length !== 2)
        return;
      const key2 = keyval[0];
      let val2 = keyval[1];
      if (key2 === "dn")
        val2 = decodeURIComponent(val2).replace(/\+/g, " ");
      if (key2 === "tr" || key2 === "xs" || key2 === "as" || key2 === "ws") {
        val2 = decodeURIComponent(val2);
      }
      if (key2 === "kt")
        val2 = decodeURIComponent(val2).split("+");
      if (key2 === "ix")
        val2 = Number(val2);
      if (key2 === "so")
        val2 = parseRange(decodeURIComponent(val2).split(","));
      if (result2[key2]) {
        if (!Array.isArray(result2[key2])) {
          result2[key2] = [result2[key2]];
        }
        result2[key2].push(val2);
      } else {
        result2[key2] = val2;
      }
    });
    let m;
    if (result2.xt) {
      const xts = Array.isArray(result2.xt) ? result2.xt : [result2.xt];
      xts.forEach((xt) => {
        if (m = xt.match(/^urn:btih:(.{40})/)) {
          result2.infoHash = m[1].toLowerCase();
        } else if (m = xt.match(/^urn:btih:(.{32})/)) {
          result2.infoHash = arr2hex(decode(m[1]));
        } else if (m = xt.match(/^urn:btmh:1220(.{64})/)) {
          result2.infoHashV2 = m[1].toLowerCase();
        }
      });
    }
    if (result2.xs) {
      const xss = Array.isArray(result2.xs) ? result2.xs : [result2.xs];
      xss.forEach((xs) => {
        if (m = xs.match(/^urn:btpk:(.{64})/)) {
          result2.publicKey = m[1].toLowerCase();
        }
      });
    }
    if (result2.infoHash)
      result2.infoHashBuffer = hex2arr(result2.infoHash);
    if (result2.infoHashV2)
      result2.infoHashV2Buffer = hex2arr(result2.infoHashV2);
    if (result2.publicKey)
      result2.publicKeyBuffer = hex2arr(result2.publicKey);
    if (result2.dn)
      result2.name = result2.dn;
    if (result2.kt)
      result2.keywords = result2.kt;
    result2.announce = [];
    if (typeof result2.tr === "string" || Array.isArray(result2.tr)) {
      result2.announce = result2.announce.concat(result2.tr);
    }
    result2.urlList = [];
    if (typeof result2.as === "string" || Array.isArray(result2.as)) {
      result2.urlList = result2.urlList.concat(result2.as);
    }
    if (typeof result2.ws === "string" || Array.isArray(result2.ws)) {
      result2.urlList = result2.urlList.concat(result2.ws);
    }
    result2.peerAddresses = [];
    if (typeof result2["x.pe"] === "string" || Array.isArray(result2["x.pe"])) {
      result2.peerAddresses = result2.peerAddresses.concat(result2["x.pe"]);
    }
    result2.announce = Array.from(new Set(result2.announce));
    result2.urlList = Array.from(new Set(result2.urlList));
    result2.peerAddresses = Array.from(new Set(result2.peerAddresses));
    return result2;
  }
  function magnetURIEncode(obj) {
    obj = Object.assign({}, obj);
    let xts = /* @__PURE__ */ new Set();
    if (obj.xt && typeof obj.xt === "string")
      xts.add(obj.xt);
    if (obj.xt && Array.isArray(obj.xt))
      xts = new Set(obj.xt);
    if (obj.infoHashBuffer)
      xts.add(`urn:btih:${arr2hex(obj.infoHashBuffer)}`);
    if (obj.infoHash)
      xts.add(`urn:btih:${obj.infoHash}`);
    if (obj.infoHashV2Buffer)
      xts.add(obj.xt = `urn:btmh:1220${arr2hex(obj.infoHashV2Buffer)}`);
    if (obj.infoHashV2)
      xts.add(`urn:btmh:1220${obj.infoHashV2}`);
    const xtsDeduped = Array.from(xts);
    if (xtsDeduped.length === 1)
      obj.xt = xtsDeduped[0];
    if (xtsDeduped.length > 1)
      obj.xt = xtsDeduped;
    if (obj.publicKeyBuffer)
      obj.xs = `urn:btpk:${arr2hex(obj.publicKeyBuffer)}`;
    if (obj.publicKey)
      obj.xs = `urn:btpk:${obj.publicKey}`;
    if (obj.name)
      obj.dn = obj.name;
    if (obj.keywords)
      obj.kt = obj.keywords;
    if (obj.announce)
      obj.tr = obj.announce;
    if (obj.urlList) {
      obj.ws = obj.urlList;
      delete obj.as;
    }
    if (obj.peerAddresses)
      obj["x.pe"] = obj.peerAddresses;
    let result2 = "magnet:?";
    Object.keys(obj).filter((key2) => key2.length === 2 || key2 === "x.pe").forEach((key2, i2) => {
      const values = Array.isArray(obj[key2]) ? obj[key2] : [obj[key2]];
      values.forEach((val2, j) => {
        if ((i2 > 0 || j > 0) && (key2 !== "kt" && key2 !== "so" || j === 0))
          result2 += "&";
        if (key2 === "dn")
          val2 = encodeURIComponent(val2).replace(/%20/g, "+");
        if (key2 === "tr" || key2 === "as" || key2 === "ws") {
          val2 = encodeURIComponent(val2);
        }
        if (key2 === "xs" && !val2.startsWith("urn:btpk:")) {
          val2 = encodeURIComponent(val2);
        }
        if (key2 === "kt")
          val2 = encodeURIComponent(val2);
        if (key2 === "so")
          return;
        if (key2 === "kt" && j > 0)
          result2 += `+${val2}`;
        else
          result2 += `${key2}=${val2}`;
      });
      if (key2 === "so")
        result2 += `${key2}=${composeRange(values)}`;
    });
    return result2;
  }
  "use strict";
  function assertPath(path2) {
    if (typeof path2 !== "string") {
      throw new TypeError("Path must be a string. Received " + JSON.stringify(path2));
    }
  }
  function normalizeStringPosix(path2, allowAboveRoot) {
    var res = "";
    var lastSegmentLength = 0;
    var lastSlash = -1;
    var dots = 0;
    var code2;
    for (var i2 = 0; i2 <= path2.length; ++i2) {
      if (i2 < path2.length)
        code2 = path2.charCodeAt(i2);
      else if (code2 === 47)
        break;
      else
        code2 = 47;
      if (code2 === 47) {
        if (lastSlash === i2 - 1 || dots === 1) {
        } else if (lastSlash !== i2 - 1 && dots === 2) {
          if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
            if (res.length > 2) {
              var lastSlashIndex = res.lastIndexOf("/");
              if (lastSlashIndex !== res.length - 1) {
                if (lastSlashIndex === -1) {
                  res = "";
                  lastSegmentLength = 0;
                } else {
                  res = res.slice(0, lastSlashIndex);
                  lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
                }
                lastSlash = i2;
                dots = 0;
                continue;
              }
            } else if (res.length === 2 || res.length === 1) {
              res = "";
              lastSegmentLength = 0;
              lastSlash = i2;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            if (res.length > 0)
              res += "/..";
            else
              res = "..";
            lastSegmentLength = 2;
          }
        } else {
          if (res.length > 0)
            res += "/" + path2.slice(lastSlash + 1, i2);
          else
            res = path2.slice(lastSlash + 1, i2);
          lastSegmentLength = i2 - lastSlash - 1;
        }
        lastSlash = i2;
        dots = 0;
      } else if (code2 === 46 && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  function _format(sep, pathObject) {
    var dir = pathObject.dir || pathObject.root;
    var base = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
    if (!dir) {
      return base;
    }
    if (dir === pathObject.root) {
      return dir + base;
    }
    return dir + sep + base;
  }
  var posix = {
    // path.resolve([from ...], to)
    resolve: function resolve2() {
      var resolvedPath = "";
      var resolvedAbsolute = false;
      var cwd;
      for (var i2 = arguments.length - 1; i2 >= -1 && !resolvedAbsolute; i2--) {
        var path2;
        if (i2 >= 0)
          path2 = arguments[i2];
        else {
          if (cwd === void 0)
            cwd = process$1.cwd();
          path2 = cwd;
        }
        assertPath(path2);
        if (path2.length === 0) {
          continue;
        }
        resolvedPath = path2 + "/" + resolvedPath;
        resolvedAbsolute = path2.charCodeAt(0) === 47;
      }
      resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
      if (resolvedAbsolute) {
        if (resolvedPath.length > 0)
          return "/" + resolvedPath;
        else
          return "/";
      } else if (resolvedPath.length > 0) {
        return resolvedPath;
      } else {
        return ".";
      }
    },
    normalize: function normalize(path2) {
      assertPath(path2);
      if (path2.length === 0)
        return ".";
      var isAbsolute = path2.charCodeAt(0) === 47;
      var trailingSeparator = path2.charCodeAt(path2.length - 1) === 47;
      path2 = normalizeStringPosix(path2, !isAbsolute);
      if (path2.length === 0 && !isAbsolute)
        path2 = ".";
      if (path2.length > 0 && trailingSeparator)
        path2 += "/";
      if (isAbsolute)
        return "/" + path2;
      return path2;
    },
    isAbsolute: function isAbsolute(path2) {
      assertPath(path2);
      return path2.length > 0 && path2.charCodeAt(0) === 47;
    },
    join: function join() {
      if (arguments.length === 0)
        return ".";
      var joined;
      for (var i2 = 0; i2 < arguments.length; ++i2) {
        var arg = arguments[i2];
        assertPath(arg);
        if (arg.length > 0) {
          if (joined === void 0)
            joined = arg;
          else
            joined += "/" + arg;
        }
      }
      if (joined === void 0)
        return ".";
      return posix.normalize(joined);
    },
    relative: function relative(from, to) {
      assertPath(from);
      assertPath(to);
      if (from === to)
        return "";
      from = posix.resolve(from);
      to = posix.resolve(to);
      if (from === to)
        return "";
      var fromStart = 1;
      for (; fromStart < from.length; ++fromStart) {
        if (from.charCodeAt(fromStart) !== 47)
          break;
      }
      var fromEnd = from.length;
      var fromLen = fromEnd - fromStart;
      var toStart = 1;
      for (; toStart < to.length; ++toStart) {
        if (to.charCodeAt(toStart) !== 47)
          break;
      }
      var toEnd = to.length;
      var toLen = toEnd - toStart;
      var length = fromLen < toLen ? fromLen : toLen;
      var lastCommonSep = -1;
      var i2 = 0;
      for (; i2 <= length; ++i2) {
        if (i2 === length) {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i2) === 47) {
              return to.slice(toStart + i2 + 1);
            } else if (i2 === 0) {
              return to.slice(toStart + i2);
            }
          } else if (fromLen > length) {
            if (from.charCodeAt(fromStart + i2) === 47) {
              lastCommonSep = i2;
            } else if (i2 === 0) {
              lastCommonSep = 0;
            }
          }
          break;
        }
        var fromCode = from.charCodeAt(fromStart + i2);
        var toCode = to.charCodeAt(toStart + i2);
        if (fromCode !== toCode)
          break;
        else if (fromCode === 47)
          lastCommonSep = i2;
      }
      var out = "";
      for (i2 = fromStart + lastCommonSep + 1; i2 <= fromEnd; ++i2) {
        if (i2 === fromEnd || from.charCodeAt(i2) === 47) {
          if (out.length === 0)
            out += "..";
          else
            out += "/..";
        }
      }
      if (out.length > 0)
        return out + to.slice(toStart + lastCommonSep);
      else {
        toStart += lastCommonSep;
        if (to.charCodeAt(toStart) === 47)
          ++toStart;
        return to.slice(toStart);
      }
    },
    _makeLong: function _makeLong(path2) {
      return path2;
    },
    dirname: function dirname(path2) {
      assertPath(path2);
      if (path2.length === 0)
        return ".";
      var code2 = path2.charCodeAt(0);
      var hasRoot = code2 === 47;
      var end = -1;
      var matchedSlash = true;
      for (var i2 = path2.length - 1; i2 >= 1; --i2) {
        code2 = path2.charCodeAt(i2);
        if (code2 === 47) {
          if (!matchedSlash) {
            end = i2;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1)
        return hasRoot ? "/" : ".";
      if (hasRoot && end === 1)
        return "//";
      return path2.slice(0, end);
    },
    basename: function basename(path2, ext) {
      if (ext !== void 0 && typeof ext !== "string")
        throw new TypeError('"ext" argument must be a string');
      assertPath(path2);
      var start = 0;
      var end = -1;
      var matchedSlash = true;
      var i2;
      if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
        if (ext.length === path2.length && ext === path2)
          return "";
        var extIdx = ext.length - 1;
        var firstNonSlashEnd = -1;
        for (i2 = path2.length - 1; i2 >= 0; --i2) {
          var code2 = path2.charCodeAt(i2);
          if (code2 === 47) {
            if (!matchedSlash) {
              start = i2 + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i2 + 1;
            }
            if (extIdx >= 0) {
              if (code2 === ext.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i2;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start === end)
          end = firstNonSlashEnd;
        else if (end === -1)
          end = path2.length;
        return path2.slice(start, end);
      } else {
        for (i2 = path2.length - 1; i2 >= 0; --i2) {
          if (path2.charCodeAt(i2) === 47) {
            if (!matchedSlash) {
              start = i2 + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i2 + 1;
          }
        }
        if (end === -1)
          return "";
        return path2.slice(start, end);
      }
    },
    extname: function extname(path2) {
      assertPath(path2);
      var startDot = -1;
      var startPart = 0;
      var end = -1;
      var matchedSlash = true;
      var preDotState = 0;
      for (var i2 = path2.length - 1; i2 >= 0; --i2) {
        var code2 = path2.charCodeAt(i2);
        if (code2 === 47) {
          if (!matchedSlash) {
            startPart = i2 + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i2 + 1;
        }
        if (code2 === 46) {
          if (startDot === -1)
            startDot = i2;
          else if (preDotState !== 1)
            preDotState = 1;
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path2.slice(startDot, end);
    },
    format: function format(pathObject) {
      if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
      }
      return _format("/", pathObject);
    },
    parse: function parse2(path2) {
      assertPath(path2);
      var ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path2.length === 0)
        return ret;
      var code2 = path2.charCodeAt(0);
      var isAbsolute = code2 === 47;
      var start;
      if (isAbsolute) {
        ret.root = "/";
        start = 1;
      } else {
        start = 0;
      }
      var startDot = -1;
      var startPart = 0;
      var end = -1;
      var matchedSlash = true;
      var i2 = path2.length - 1;
      var preDotState = 0;
      for (; i2 >= start; --i2) {
        code2 = path2.charCodeAt(i2);
        if (code2 === 47) {
          if (!matchedSlash) {
            startPart = i2 + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i2 + 1;
        }
        if (code2 === 46) {
          if (startDot === -1)
            startDot = i2;
          else if (preDotState !== 1)
            preDotState = 1;
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
          if (startPart === 0 && isAbsolute)
            ret.base = ret.name = path2.slice(1, end);
          else
            ret.base = ret.name = path2.slice(startPart, end);
        }
      } else {
        if (startPart === 0 && isAbsolute) {
          ret.name = path2.slice(1, startDot);
          ret.base = path2.slice(1, end);
        } else {
          ret.name = path2.slice(startPart, startDot);
          ret.base = path2.slice(startPart, end);
        }
        ret.ext = path2.slice(startDot, end);
      }
      if (startPart > 0)
        ret.dir = path2.slice(0, startPart - 1);
      else if (isAbsolute)
        ret.dir = "/";
      return ret;
    },
    sep: "/",
    delimiter: ":",
    win32: null,
    posix: null
  };
  posix.posix = posix;
  var pathBrowserify = posix;
  const path = /* @__PURE__ */ getDefaultExportFromCjs$1(pathBrowserify);
  /*! queue-microtask. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */
  let promise;
  var queueMicrotask_1 = typeof queueMicrotask === "function" ? queueMicrotask.bind(typeof window !== "undefined" ? window : commonjsGlobal) : (cb) => (promise || (promise = Promise.resolve())).then(cb).catch((err) => setTimeout(() => {
    throw err;
  }, 0));
  const queueMicrotask$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(queueMicrotask_1);
  /*! parse-torrent. MIT License. WebTorrent LLC <https://webtorrent.io/opensource> */
  async function parseTorrent(torrentId) {
    if (typeof torrentId === "string" && /^(stream-)?magnet:/.test(torrentId)) {
      const torrentObj = magnetURIDecode(torrentId);
      if (!torrentObj.infoHash) {
        throw new Error("Invalid torrent identifier");
      }
      return torrentObj;
    } else if (typeof torrentId === "string" && (/^[a-f0-9]{40}$/i.test(torrentId) || /^[a-z2-7]{32}$/i.test(torrentId))) {
      return magnetURIDecode(`magnet:?xt=urn:btih:${torrentId}`);
    } else if (ArrayBuffer.isView(torrentId) && torrentId.length === 20) {
      return magnetURIDecode(`magnet:?xt=urn:btih:${arr2hex(torrentId)}`);
    } else if (ArrayBuffer.isView(torrentId)) {
      return await decodeTorrentFile(torrentId);
    } else if (torrentId && torrentId.infoHash) {
      torrentId.infoHash = torrentId.infoHash.toLowerCase();
      if (!torrentId.announce)
        torrentId.announce = [];
      if (typeof torrentId.announce === "string") {
        torrentId.announce = [torrentId.announce];
      }
      if (!torrentId.urlList)
        torrentId.urlList = [];
      return torrentId;
    } else {
      throw new Error("Invalid torrent identifier");
    }
  }
  async function parseTorrentRemote(torrentId, opts, cb) {
    if (typeof opts === "function")
      return parseTorrentRemote(torrentId, {}, opts);
    if (typeof cb !== "function")
      throw new Error("second argument must be a Function");
    let parsedTorrent;
    try {
      parsedTorrent = await parseTorrent(torrentId);
    } catch (err) {
    }
    if (parsedTorrent && parsedTorrent.infoHash) {
      queueMicrotask$1(() => {
        cb(null, parsedTorrent);
      });
    } else if (isBlob(torrentId)) {
      try {
        const torrentBuf = new Uint8Array(await torrentId.arrayBuffer());
        parseOrThrow(torrentBuf);
      } catch (err) {
        return cb(new Error(`Error converting Blob: ${err.message}`));
      }
    } else if (/^https?:/.test(torrentId)) {
      try {
        const res = await fetch(torrentId, {
          headers: { "user-agent": "WebTorrent (https://webtorrent.io)" },
          signal: AbortSignal.timeout(30 * 1e3),
          ...opts
        });
        const torrentBuf = new Uint8Array(await res.arrayBuffer());
        parseOrThrow(torrentBuf);
      } catch (err) {
        return cb(new Error(`Error downloading torrent: ${err.message}`));
      }
    } else if (typeof fs.readFile === "function" && typeof torrentId === "string") {
      fs.readFile(torrentId, (err, torrentBuf) => {
        if (err)
          return cb(new Error("Invalid torrent identifier"));
        parseOrThrow(torrentBuf);
      });
    } else {
      queueMicrotask$1(() => {
        cb(new Error("Invalid torrent identifier"));
      });
    }
    async function parseOrThrow(torrentBuf) {
      try {
        parsedTorrent = await parseTorrent(torrentBuf);
      } catch (err) {
        return cb(err);
      }
      if (parsedTorrent && parsedTorrent.infoHash)
        cb(null, parsedTorrent);
      else
        cb(new Error("Invalid torrent identifier"));
    }
  }
  async function decodeTorrentFile(torrent) {
    if (ArrayBuffer.isView(torrent)) {
      torrent = bencode.decode(torrent);
    }
    ensure(torrent.info, "info");
    ensure(torrent.info["name.utf-8"] || torrent.info.name, "info.name");
    ensure(torrent.info["piece length"], "info['piece length']");
    ensure(torrent.info.pieces, "info.pieces");
    if (torrent.info.files) {
      torrent.info.files.forEach((file) => {
        ensure(typeof file.length === "number", "info.files[0].length");
        ensure(file["path.utf-8"] || file.path, "info.files[0].path");
      });
    } else {
      ensure(typeof torrent.info.length === "number", "info.length");
    }
    const result2 = {
      info: torrent.info,
      infoBuffer: bencode.encode(torrent.info),
      name: arr2text(torrent.info["name.utf-8"] || torrent.info.name),
      announce: []
    };
    result2.infoHashBuffer = await hash(result2.infoBuffer);
    result2.infoHash = arr2hex(result2.infoHashBuffer);
    if (torrent.info.private !== void 0)
      result2.private = !!torrent.info.private;
    if (torrent["creation date"])
      result2.created = new Date(torrent["creation date"] * 1e3);
    if (torrent["created by"])
      result2.createdBy = arr2text(torrent["created by"]);
    if (ArrayBuffer.isView(torrent.comment))
      result2.comment = arr2text(torrent.comment);
    if (Array.isArray(torrent["announce-list"]) && torrent["announce-list"].length > 0) {
      torrent["announce-list"].forEach((urls) => {
        urls.forEach((url2) => {
          result2.announce.push(arr2text(url2));
        });
      });
    } else if (torrent.announce) {
      result2.announce.push(arr2text(torrent.announce));
    }
    if (ArrayBuffer.isView(torrent["url-list"])) {
      torrent["url-list"] = torrent["url-list"].length > 0 ? [torrent["url-list"]] : [];
    }
    result2.urlList = (torrent["url-list"] || []).map((url2) => arr2text(url2));
    result2.announce = Array.from(new Set(result2.announce));
    result2.urlList = Array.from(new Set(result2.urlList));
    const files = torrent.info.files || [torrent.info];
    result2.files = files.map((file, i2) => {
      const parts = [].concat(result2.name, file["path.utf-8"] || file.path || []).map((p2) => ArrayBuffer.isView(p2) ? arr2text(p2) : p2);
      return {
        path: path.join.apply(null, [path.sep].concat(parts)).slice(1),
        name: parts[parts.length - 1],
        length: file.length,
        offset: files.slice(0, i2).reduce(sumLength, 0)
      };
    });
    result2.length = files.reduce(sumLength, 0);
    const lastFile = result2.files[result2.files.length - 1];
    result2.pieceLength = torrent.info["piece length"];
    result2.lastPieceLength = (lastFile.offset + lastFile.length) % result2.pieceLength || result2.pieceLength;
    result2.pieces = splitPieces(torrent.info.pieces);
    return result2;
  }
  function encodeTorrentFile(parsed) {
    const torrent = {
      info: parsed.info
    };
    torrent["announce-list"] = (parsed.announce || []).map((url2) => {
      if (!torrent.announce)
        torrent.announce = url2;
      url2 = text2arr(url2);
      return [url2];
    });
    torrent["url-list"] = parsed.urlList || [];
    if (parsed.private !== void 0) {
      torrent.private = Number(parsed.private);
    }
    if (parsed.created) {
      torrent["creation date"] = parsed.created.getTime() / 1e3 | 0;
    }
    if (parsed.createdBy) {
      torrent["created by"] = parsed.createdBy;
    }
    if (parsed.comment) {
      torrent.comment = parsed.comment;
    }
    return bencode.encode(torrent);
  }
  function isBlob(obj) {
    return typeof Blob !== "undefined" && obj instanceof Blob;
  }
  function sumLength(sum, file) {
    return sum + file.length;
  }
  function splitPieces(buf) {
    const pieces = [];
    for (let i2 = 0; i2 < buf.length; i2 += 20) {
      pieces.push(arr2hex(buf.slice(i2, i2 + 20)));
    }
    return pieces;
  }
  function ensure(bool, fieldName) {
    if (!bool)
      throw new Error(`Torrent is missing required field: ${fieldName}`);
  }
  const toMagnetURI = magnetURIEncode;
  class Controller {
    constructor(service) {
      this.service = service;
      this.options = {
        sites: [],
        clients: []
      };
      this.defaultClientOptions = {};
      this.siteDefaultClients = {};
      this.optionsTabId = 0;
      this.downloadHistory = new DownloadHistory();
      this.clients = {};
      this.searcher = new Searcher(this.service);
      this.userService = new User(this.service);
      this.movieInfoService = new MovieInfoService();
      this.clientController = new ClientController();
      this.isInitialized = false;
      this.contentPages = [];
      this.debuggerTabId = 0;
      this.imageBase64Cache = {};
      this.downloadFailedRetriesCache = {};
      this.torrentInfosCache = {};
    }
    init(options2) {
      this.reset(options2);
      this.isInitialized = true;
    }
    /**
     * 重置并刷新配置
     * @param options
     */
    reset(options2) {
      this.options = options2;
      this.clientController.init(options2);
      this.searcher.options = options2;
      this.initDefaultClient();
      this.siteDefaultClients = {};
      if (options2.connectClientTimeout) {
        this.movieInfoService.timeout = options2.connectClientTimeout;
      }
      if (this.options.apiKey) {
        if (this.options.apiKey.omdb && this.options.apiKey.omdb.length > 0) {
          this.movieInfoService.appendApiKey("omdb", this.options.apiKey.omdb);
        }
        if (this.options.apiKey.douban && this.options.apiKey.douban.length > 0) {
          this.movieInfoService.appendApiKey(
            "douban",
            this.options.apiKey.douban
          );
        }
      }
    }
    /**
     * 获取搜索结果
     * @param options
     */
    getSearchResult(options2) {
      return this.searcher.searchTorrent(
        options2.site,
        options2.key,
        options2.payload
      );
    }
    /**
     * 取消一个正在执行的搜索请求
     * @param options
     */
    abortSearch(options2) {
      return this.searcher.abortSearch(options2.site, options2.key);
    }
    /**
     * 获取下载历史记录
     */
    getDownloadHistory() {
      return this.downloadHistory.load();
    }
    /**
     * 保存下载记录
     * @param data 下载链接信息
     * @param host 站点域名
     * @param clientId 下载客户端ID
     */
    saveDownloadHistory(data2, host2 = "", clientId = "", success = true) {
      if (this.options.saveDownloadHistory) {
        this.downloadHistory.add(data2, host2, clientId, success);
      }
    }
    /**
     * 删除下载历史记录
     * @param items 需要删除的列表
     */
    removeDownloadHistory(items) {
      return this.downloadHistory.remove(items);
    }
    /**
     * 清除下载记录
     */
    clearDownloadHistory() {
      return this.downloadHistory.clear();
    }
    /**
     * 重置下载历史
     */
    resetDownloadHistory(datas) {
      return this.downloadHistory.reset(datas);
    }
    /**
     * 发送下载信息到指定的客户端
     * @param data
     */
    sendTorrentToClient(data2) {
      return new Promise((resolve2, reject2) => {
        if (!data2.url) {
          reject2({
            msg: this.service.i18n.t("service.controller.invalidAddress")
            //"无效的地址"
          });
          return;
        }
        let URL2 = filters.parseURL(data2.url);
        let host2 = URL2.host;
        let clientConfig = this.options.clients.find((item) => {
          return item.id === data2.clientId;
        });
        if (!clientConfig) {
          reject2({
            msg: this.service.i18n.t("service.controller.invalidDownloadServer")
            //"无效的下载服务器"
          });
          return;
        }
        this.getClient(clientConfig).then((result2) => {
          this.doDownload(result2, data2, host2).then((result22) => {
            resolve2(result22);
          }).catch((result22) => {
            reject2(result22);
          });
        });
      });
    }
    /**
     * 发送下载链接地址到默认服务器（客户端）
     * @param downloadOptions 下载选项
     */
    sendTorrentToDefaultClient(downloadOptions) {
      return new Promise((resolve2, reject2) => {
        let URL2 = filters.parseURL(downloadOptions.url);
        let host2 = URL2.host;
        let site2 = this.getSiteFromHost(host2);
        host2 = site2.host + "";
        let siteDefaultPath = this.getSiteDefaultPath(site2);
        let siteClientConfig = this.siteDefaultClients[host2];
        if (!downloadOptions.savePath && siteDefaultPath) {
          downloadOptions.savePath = siteDefaultPath;
        }
        if (!siteClientConfig) {
          this.initSiteDefaultClient(host2).then((siteClientConfig2) => {
            this.siteDefaultClients[host2] = siteClientConfig2;
            this.doDownload(siteClientConfig2, downloadOptions, host2).then((result2) => {
              resolve2(result2);
            }).catch((result2) => {
              reject2(result2);
            });
          });
        } else {
          this.doDownload(siteClientConfig, downloadOptions, host2).then((result2) => {
            resolve2(result2);
          }).catch((result2) => {
            reject2(result2);
          });
        }
      });
    }
    /**
     * 执行下载操作
     * @param clientConfig
     * @param downloadOptions
     * @param host
     */
    doDownload(clientConfig, downloadOptions, host2 = "") {
      let URL2 = filters.parseURL(downloadOptions.url);
      let downloadHost = URL2.host;
      let siteConfig = this.getSiteFromHost(downloadHost);
      console.log("doDownload", clientConfig, downloadOptions, host2, siteConfig);
      return new Promise((resolve2, reject2) => {
        clientConfig.client.call(EAction.addTorrentFromURL, {
          url: downloadOptions.url,
          savePath: downloadOptions.savePath !== void 0 && downloadOptions.savePath.includes(",") ? downloadOptions.savePath.split(",")[0] : downloadOptions.savePath,
          autoStart: downloadOptions.autoStart === void 0 ? false : downloadOptions.autoStart,
          category: downloadOptions.savePath !== void 0 && downloadOptions.savePath.includes(",") ? downloadOptions.savePath.split(",")[1] : null,
          imdbId: downloadOptions.tagIMDb ? downloadOptions.imdbId : null,
          upLoadLimit: siteConfig !== void 0 ? siteConfig.upLoadLimit : null,
          clientOptions: clientConfig.options,
          siteConfig
        }).then((result2) => {
          this.service.logger.add({
            module: EModule.background,
            event: "service.controller.doDownload.finished",
            msg: this.service.i18n.t("service.controller.downloadFinished", {
              name: clientConfig.options.name,
              action: EAction.addTorrentFromURL
            }),
            // `下载服务器${clientConfig.options.name}处理[${ EAction.addTorrentFromURL}]命令完成`,
            data: result2
          });
          if (!downloadOptions.title && this.torrentInfosCache[downloadOptions.url]) {
            downloadOptions.title = this.torrentInfosCache[downloadOptions.url];
          }
          if (result2 && (result2.code === 0 || result2.success === false)) {
            if (this.downloadFailedRetry(
              clientConfig,
              downloadOptions,
              host2,
              result2,
              resolve2,
              reject2
            )) {
              return;
            }
            switch (result2.msg) {
              case "timeout":
                reject2({
                  success: false,
                  msg: this.service.i18n.t(
                    "service.controller.downloadTimeout"
                  ),
                  //"连接下载服务器超时，请检查网络设置或调整服务器超时时间！",
                  status: "error"
                });
                break;
              default:
                reject2({
                  success: false,
                  msg: result2.msg,
                  status: "error"
                });
                break;
            }
            this.saveDownloadHistory(
              downloadOptions,
              host2,
              clientConfig.options.id,
              false
            );
            return;
          }
          this.saveDownloadHistory(
            downloadOptions,
            host2,
            clientConfig.options.id,
            true
          );
          this.formatSendResult(result2, clientConfig.options, downloadOptions).then((result22) => {
            resolve2(result22);
          }).catch((result22) => {
            reject2(result22);
          });
          if (this.downloadFailedRetriesCache[downloadOptions.url]) {
            delete this.downloadFailedRetriesCache[downloadOptions.url];
          }
        }).catch((result2) => {
          if (this.downloadFailedRetry(
            clientConfig,
            downloadOptions,
            host2,
            result2,
            resolve2,
            reject2
          )) {
            return;
          }
          this.service.logger.add({
            module: EModule.background,
            event: "service.controller.doDownload.error",
            msg: this.service.i18n.t("service.controller.downloadError", {
              name: clientConfig.options.name,
              action: EAction.addTorrentFromURL
            }),
            // `下载服务器${clientConfig.options.name}处理[${EAction.addTorrentFromURL}]命令失败`,
            data: result2
          });
          this.saveDownloadHistory(
            downloadOptions,
            host2,
            clientConfig.options.id,
            false
          );
          reject2(result2);
        });
      });
    }
    /**
     * 下载失败重试
     * @param clientConfig
     * @param downloadOptions
     * @param host
     * @param failedMsg
     * @param resolve
     * @param reject
     */
    downloadFailedRetry(clientConfig, downloadOptions, host2 = "", failedMsg, resolve2, reject2) {
      if (this.options.downloadFailedRetry) {
        let maxRetries = this.options.downloadFailedFailedRetryCount;
        if (maxRetries === void 0) {
          maxRetries = 0;
        }
        let retries = this.downloadFailedRetriesCache[downloadOptions.url];
        if (retries === void 0) {
          retries = 0;
        }
        if (retries < maxRetries) {
          retries++;
          this.service.logger.add({
            module: EModule.background,
            event: "service.controller.downloadFailedRetries",
            msg: this.service.i18n.t("service.controller.downloadError", {
              name: clientConfig.options.name,
              action: EAction.addTorrentFromURL
            }) + " (" + retries + ")",
            // `下载服务器${clientConfig.options.name}处理[${EAction.addTorrentFromURL}]命令失败`,
            data: failedMsg
          });
          this.downloadFailedRetriesCache[downloadOptions.url] = retries;
          if (this.options.downloadFailedFailedRetryInterval && this.options.downloadFailedFailedRetryInterval > 0) {
            setTimeout(() => {
              this.doDownload(clientConfig, downloadOptions, host2).then((result2) => {
                resolve2(result2);
              }).catch((result2) => {
                reject2(result2);
              });
            }, this.options.downloadFailedFailedRetryInterval * 1e3);
          } else {
            this.doDownload(clientConfig, downloadOptions, host2).then((result2) => {
              resolve2(result2);
            }).catch((result2) => {
              reject2(result2);
            });
          }
          return true;
        }
        delete this.downloadFailedRetriesCache[downloadOptions.url];
      }
      return false;
    }
    /**
     * 根据指定的域名获取站点配置信息
     * @param host 域名
     */
    getSiteFromHost(host2) {
      return this.options.sites.find((item) => {
        let cdn = [item.url].concat(item.cdn, item.apiCdn);
        return item.host == host2 || cdn.join("").indexOf(host2) > -1;
      });
    }
    /**
     * 获取当前站点的默认下载目录
     * @param string clientId 指定客户端ID，不指定表示使用默认下载客户端
     * @return string 目录信息，如果没有定义，则返回空字符串
     */
    getSiteDefaultPath(site2, clientId = "") {
      if (!clientId) {
        clientId = site2.defaultClientId || this.options.defaultClientId;
      }
      let client2 = this.options.clients.find((item) => {
        return item.id === clientId;
      });
      let path2 = "";
      if (client2 && client2.paths) {
        for (const host2 in client2.paths) {
          if (site2.host === host2) {
            path2 = client2.paths[host2][0];
            break;
          }
        }
      }
      return path2;
    }
    /**
     * 格式化发送结果
     * @param data
     * @param clientOptions
     * @param downloadOptions
     */
    formatSendResult(data2, clientOptions2, downloadOptions) {
      return new Promise((resolve2, reject2) => {
        let result2 = {
          type: EDataResultType.success,
          msg: this.service.i18n.t("service.controller.torrentAdded", {
            title: downloadOptions.title
          }) + (downloadOptions.savePath ? this.service.i18n.t("service.controller.torrentSavePath", {
            path: downloadOptions.savePath,
            interpolation: { escapeValue: false }
          }) : ""),
          //`${downloadOptions.title || ""} 种子已添加完成。` +
          // (downloadOptions.savePath
          //   ? `<br/>保存至 ${downloadOptions.savePath}`
          //   : ""),
          success: true,
          data: data2
        };
        switch (clientOptions2.type) {
          case EDownloadClientType.transmission:
            if (data2.id != void 0) {
              result2.msg = this.service.i18n.t(
                "service.controller.transmissionSuccess",
                {
                  data: data2
                }
              );
              if (downloadOptions.savePath) {
                result2.msg += this.service.i18n.t(
                  "service.controller.torrentSavePath",
                  {
                    path: downloadOptions.savePath,
                    interpolation: { escapeValue: false }
                  }
                );
              }
            } else if (data2.status) {
              switch (data2.status) {
                case "duplicate":
                  result2.type = EDataResultType.error;
                  result2.success = false;
                  result2.msg = this.service.i18n.t(
                    "service.controller.transmissionDuplicate",
                    {
                      name: data2.torrent.name,
                      id: data2.torrent.id
                    }
                  );
                  break;
                case "error":
                  result2.type = EDataResultType.error;
                  result2.success = false;
                  result2.msg = this.service.i18n.t(
                    "service.controller.transmissionError"
                  );
                  break;
                default:
                  result2.msg = data2.msg;
                  break;
              }
            } else {
              result2.msg = data2;
            }
            break;
          default:
            break;
        }
        resolve2(result2);
      });
    }
    /**
     * 根据指定客户端配置初始化客户端
     * @param clientOptions 客户端配置
     */
    getClient(clientOptions2) {
      return this.clientController.getClient(clientOptions2);
    }
    /**
     * 初始化默认客户端
     */
    initDefaultClient() {
      if (!this.options.clients) {
        return;
      }
      let clientOptions2 = this.options.clients.find((item) => {
        return item.id === this.options.defaultClientId;
      });
      if (clientOptions2) {
        this.getClient(clientOptions2).then((result2) => {
          this.defaultClient = result2.client;
          this.defaultClientOptions = result2.options;
        });
      }
    }
    /**
     * 初始化指定站点默认客户端
     * @param hostname 站点host名称
     */
    initSiteDefaultClient(hostname) {
      let site2 = this.options.sites.find((item) => {
        return item.host == hostname;
      });
      let clientOptions2 = this.options.clients.find((item) => {
        return item.id === site2.defaultClientId;
      });
      if (clientOptions2) {
        return this.getClient(clientOptions2);
      }
      return new Promise((resolve2, reject2) => {
        resolve2({
          client: this.defaultClient,
          options: this.defaultClientOptions
        });
      });
    }
    /**
     * 复制指定的内容到剪切板
     * @param text
     */
    copyTextToClipboard(text = "") {
      if (!text) {
        return false;
      }
      var copyFrom = $("<textarea/>");
      copyFrom.text(text);
      $("body").append(copyFrom);
      copyFrom.select();
      document.execCommand("copy");
      copyFrom.remove();
      return true;
    }
    /**
     * 获取指定客户端的可用空间
     * @param data
     */
    getFreeSpace(data2) {
      if (!data2.clientId) {
        return this.getDefaultClientFreeSpace(data2);
      }
      return new Promise((resolve2, reject2) => {
        let clientOptions2 = this.options.clients.find((item) => {
          return item.id === data2.clientId;
        });
        if (clientOptions2) {
          this.getClient(clientOptions2).then((result2) => {
            result2.client.call(EAction.getFreeSpace, data2).then((result22) => {
              resolve2(result22);
            });
          });
        }
      });
    }
    /**
     * 获取默认客户端的可用空间
     * @param data
     */
    getDefaultClientFreeSpace(data2) {
      return new Promise((resolve2, reject2) => {
        this.defaultClient.call(EAction.getFreeSpace, data2).then((result2) => {
          resolve2(result2);
        });
      });
    }
    updateOptionsTabId(id) {
      this.optionsTabId = id;
    }
    /**
     * 打开搜索种子页面
     * @param key 关键字
     * @param host 指定站点，默认搜索所有站
     */
    searchTorrent(key2 = "", host2 = "") {
      let url2 = "";
      if (key2) {
        url2 = `search-torrent/${key2}`;
      }
      if (host2) {
        url2 += `/${host2}`;
      }
      this.openOptions(url2);
    }
    /**
     * 打开配置页
     * @param path 要跳转的路径
     */
    openOptions(path2 = "") {
      let url2 = "/";
      if (path2) {
        url2 += path2;
      }
      if (this.optionsTabId == 0) {
        this.openURL(url2);
      } else {
        chrome.tabs.get(this.optionsTabId, (tab) => {
          if (!chrome.runtime.lastError && tab) {
            chrome.tabs.update(tab.id, {
              active: true,
              url: "index.html#" + url2
            });
          } else {
            this.openURL(url2);
          }
        });
      }
    }
    /**
     * 创建配置页面选项卡
     * @param url
     */
    openURL(url2 = "") {
      if (!url2) {
        return;
      }
      if (url2.substr(0, 1) === "/") {
        url2 = "index.html#" + url2;
      }
      chrome.tabs.create(
        {
          url: url2
        },
        (tab) => {
          this.optionsTabId = tab.id;
        }
      );
    }
    /**
     * 根据指定的站点获取站点的架构信息
     * @param site 站点信息
     */
    getSiteSchema(site2) {
      let schema2 = {};
      if (typeof site2.schema === "string") {
        schema2 = this.options.system && this.options.system.schemas && this.options.system.schemas.find((item) => {
          return item.name == site2.schema;
        });
      } else {
        let site22 = this.options.system && this.options.system.sites && this.options.system.sites.find((item) => {
          return item.host == site22.host;
        });
        if (site22 && site22.schema) {
          schema2 = site22.schema;
          schema2.siteOnly = true;
        }
      }
      return schema2;
    }
    replaceKeys(source2, keys) {
      let result2 = source2;
      for (const key2 in keys) {
        if (keys.hasOwnProperty(key2)) {
          const value = keys[key2];
          result2 = result2.replace("$" + key2 + "$", value);
        }
      }
      return result2;
    }
    /**
     * 接收由前台发回的指令并执行
     * @param action 指令
     * @param callback 回调函数
     */
    call(request, sender) {
      return new Promise((resolve2, reject2) => {
        let service = this;
        console.log("contorller.call", request.action);
        service[request.action](request.data, sender).then((result2) => {
          resolve2(result2);
        }).catch((result2) => {
          reject2(result2);
        });
      });
    }
    addContentPage(data2, sender) {
      return new Promise((resolve2, reject2) => {
        try {
          if (sender.tab) {
            this.contentPages.push(sender.tab.id);
          }
          resolve2();
        } catch (error) {
          reject2(error);
        }
      });
    }
    /**
     * 备份系统参数至Google
     */
    backupToGoogle() {
      return this.service.config.backupToGoogle();
    }
    /**
     * 从Google恢复系统参数
     */
    restoreFromGoogle() {
      return this.service.config.restoreFromGoogle();
    }
    /**
     * 从Google中清除已备份的参数
     */
    clearFromGoogle() {
      return this.service.config.syncStorage.clear();
    }
    /**
     * 重新从网络中加载配置文件
     */
    reloadConfig() {
      return new Promise((resolve2, reject2) => {
        this.service.config.reload();
        resolve2();
      });
    }
    /**
     * 从指定的链接获取种子文件内容
     * @param options
     */
    getTorrentDataFromURL(options2) {
      console.log("getTorrentDataFromURL", options2);
      return new Promise((resolve2, reject2) => {
        let url2 = "";
        if (typeof options2 === "string") {
          url2 = options2;
          options2 = {
            url: url2,
            parseTorrent: false
          };
        } else {
          url2 = options2.url;
        }
        let site2 = this.getSiteOptionsFromURL(url2);
        let requestMethod = ERequestMethod.GET;
        if (site2) {
          requestMethod = site2.downloadMethod || ERequestMethod.GET;
          switch (site2.name) {
            case "M-Team":
              let id = PPF.getIdFromMTURL(url2);
              console.log(`getTorrentDataFromURL.M-Team ${url2} -> ${id}`, options2);
              if (id) {
                if (parseInt(id)) {
                  let torrentURL = PPF.resolveMTDownloadURL(id, site2);
                  console.log(`getTorrentDataFromURL.M-Team1 ${url2} -> ${torrentURL}`, options2);
                  url2 = torrentURL;
                } else {
                  console.log(`getTorrentDataFromURL.M-Team2 ${url2}, id 链接可能已是直链, 不进行转换...`, options2);
                }
              } else {
                reject2(APP.createErrorMessage(
                  this.service.i18n.t("service.controller.invalidTorrent", {
                    link: EWikiLink.faq
                  })
                ));
              }
              break;
            default:
              break;
          }
        }
        let file = new FileDownloader({
          url: url2,
          getDataOnly: true,
          timeout: this.service.options.connectClientTimeout
        });
        file.requestMethod = requestMethod;
        file.onCompleted = () => {
          console.log("getTorrentDataFromURL.completed", url2);
          if (file.content && /octet-stream|x-bittorrent/gi.test(file.content.type)) {
            parseTorrentRemote(file.content, (err, torrent) => {
              if (err) {
                console.log("parse.error", err);
                if (options2.parseTorrent) {
                  reject2(err);
                } else {
                  resolve2(file.content);
                }
              } else {
                if (torrent) {
                  this.torrentInfosCache[url2] = torrent.name;
                }
                if (options2.parseTorrent) {
                  resolve2({
                    url: url2,
                    torrent,
                    content: file.content
                  });
                } else {
                  resolve2(file.content);
                }
              }
            });
          } else {
            reject2(
              APP.createErrorMessage(
                this.service.i18n.t("service.controller.invalidTorrent", {
                  link: EWikiLink.faq
                })
              )
            );
          }
        };
        file.onError = (e2) => {
          reject2(APP.createErrorMessage(e2));
        };
        file.start();
      });
    }
    /**
     * 根据指定URL获取站点配置信息
     * @param url
     */
    getSiteOptionsFromURL(url2) {
      let host2 = new URLParse(url2).host;
      let site2 = this.options.system && this.options.system.sites && this.options.system.sites.find((item) => {
        return item.host == host2;
      });
      return site2;
    }
    getUserInfoForAllSite() {
      return new Promise((resolve2, reject2) => {
        let count = 0;
        let completed = 0;
        let results2 = [];
        this.options.sites.forEach((site2) => {
          if (site2.allowGetUserInfo) {
            count++;
            this.getUserInfo(site2).then((result2) => {
              if (result2) {
                results2.push({
                  site: site2,
                  user: result2
                });
              }
              completed++;
              if (completed >= count) {
                resolve2(results2);
              }
            }).catch(() => {
              completed++;
              if (completed >= count) {
                resolve2(results2);
              }
            });
          }
        });
        if (completed == count && completed == 0) {
          reject2(
            this.service.i18n.t("service.controller.getUserInfoSiteIsEmpty")
          );
        }
      });
    }
    /**
     * 获取指定站点的用户信息
     * @param site
     * @param callback
     */
    getUserInfo(site2) {
      return this.userService.getUserInfo(site2);
    }
    abortGetUserInfo(site2) {
      return this.userService.abortGetUserInfo(site2);
    }
    /**
     * 根据指定的图片地址获取Base64信息
     * @param url 图片地址
     */
    getBase64FromImageUrl(url2) {
      return new Promise((resolve2, reject2) => {
        let data2 = this.imageBase64Cache[url2];
        if (data2) {
          resolve2(data2);
          return;
        }
        let file = new FileDownloader({
          url: url2,
          getDataOnly: true,
          timeout: this.service.options.connectClientTimeout
        });
        file.onCompleted = () => {
          console.log("getBase64FromImageUrl.completed", url2);
          if (file.content && /image/gi.test(file.content.type)) {
            var reader = new FileReader();
            reader.onloadend = () => {
              this.imageBase64Cache[url2] = reader.result;
              resolve2(reader.result);
            };
            reader.readAsDataURL(file.content);
          } else {
            reject2(
              APP.createErrorMessage(
                this.service.i18n.t("service.controller.invalidImage")
              )
            );
          }
        };
        file.onError = (e2) => {
          reject2(APP.createErrorMessage(e2));
        };
        file.start();
      });
    }
    getUserHistoryData(host2) {
      return new Promise((resolve2, reject2) => {
        let data2 = this.service.userData.get(host2, EUserDataRange.all);
        resolve2(data2);
      });
    }
    resetUserDatas(datas) {
      return new Promise((resolve2, reject2) => {
        this.service.userData.reset(datas);
        setTimeout(() => {
          this.service.userData.upgrade().then((r2) => {
            console.log("升级站点数据完成");
          }).catch((e2) => {
            console.error("升级站点数据失败", e2);
          });
        }, 1e3);
        resolve2();
      });
    }
    /**
     * 根据指定的关键字获取电影信息
     * @param key
     */
    getMovieInfos(key2) {
      return this.movieInfoService.getInfos(key2);
    }
    /**
     * 根据指定的 IMDbId 获取评分信息
     * @param IMDbId
     */
    getMovieRatings(IMDbId) {
      return this.movieInfoService.getRatings(IMDbId);
    }
    /**
     * 根据指定的 doubanId 获取 IMDbId
     * @param doubanId
     */
    getIMDbIdFromDouban(doubanId) {
      return this.movieInfoService.getIMDbIdFromDouban(doubanId);
    }
    /**
     * 从豆瓣查询影片信息
     * @param key 需要查询的关键字
     * @param count 要显示的条目数量
     */
    queryMovieInfoFromDouban(options2) {
      return this.movieInfoService.queryMovieInfoFromDouban(
        options2.key,
        options2.count
      );
    }
    /**
     * 添加浏览器原生下载请求
     * @param options
     */
    addBrowserDownloads(options2) {
      return new Promise((resolve2, reject2) => {
        this.service.checkPermissions(["downloads"]).then(() => {
          let items = [];
          if (Array.isArray(options2)) {
            items = options2;
          } else {
            items.push(options2);
          }
          items.forEach((item) => {
            chrome.downloads.download(item, function(downloadId) {
              console.log(downloadId);
            });
          });
          resolve2(items.length);
        }).catch(() => {
          reject2({
            success: false,
            msg: this.service.i18n.t("service.controller.noPermission")
            //"无权限，请前往用户授权"
          });
        });
      });
    }
    /**
     * 获取当前语言资源
     * @param parentKey 指定这个key下的内容
     */
    getCurrentLanguageResource(parentKey) {
      return new Promise((resolve2, reject2) => {
        let locale = this.service.options.locale || "en";
        let resource = this.service.i18n.i18next.getResourceBundle(
          locale,
          "translation"
        );
        if (resource) {
          if (parentKey && resource[parentKey]) {
            resolve2(resource[parentKey]);
          } else {
            resolve2(resource);
          }
        } else {
          reject2();
        }
      });
    }
    addLanguage(resource) {
      return this.service.i18n.add(resource);
    }
    replaceLanguage(resource) {
      return this.service.i18n.replace(resource);
    }
    backupToServer(server) {
      return this.service.config.backupToServer(server);
    }
    getBackupListFromServer(options2 = {}) {
      const server = options2.server;
      delete options2.server;
      return this.service.config.getBackupListFromServer(server, options2);
    }
    restoreFromServer(options2 = {}) {
      return this.service.config.restoreFromServer(options2.server, options2.path);
    }
    deleteFileFromBackupServer(options2 = {}) {
      return this.service.config.deleteFileFromBackupServer(
        options2.server,
        options2.path
      );
    }
    sendTorrentsInBackground(items = []) {
      return new Promise((resolve2, reject2) => {
        this.service.downloadQuene.add(items).run();
        resolve2(
          this.service.i18n.t("service.controller.downloadTaskIsCreated", {
            count: items.length
          })
        );
      });
    }
    createBackupFile(fileName) {
      return this.service.config.createBackupFile(fileName);
    }
    addTorrentToCollection(data2) {
      if (this.options.defaultCollectionGroupId) {
        data2.groups = [this.options.defaultCollectionGroupId];
      }
      return this.service.collection.add(data2);
    }
    getTorrentCollections(groupId) {
      return this.service.collection.load(groupId);
    }
    deleteTorrentFromCollention(data2) {
      if (Array.isArray(data2)) {
        return this.service.collection.remove(data2);
      }
      return this.service.collection.delete(data2);
    }
    clearTorrentCollention() {
      return this.service.collection.clear();
    }
    getTorrentCollention(link) {
      return this.service.collection.get(link);
    }
    getSiteSelectorConfig(options2) {
      return new Promise((resolve2, reject2) => {
        const result2 = this.service.getSiteSelector(options2.host, options2.name);
        if (result2) {
          resolve2(result2);
        } else {
          reject2(false);
        }
      });
    }
    resetTorrentCollections(items) {
      return this.service.collection.reset(items);
    }
    getTorrentCollectionGroups() {
      return this.service.collection.getGroups();
    }
    addTorrentCollectionGroup(data2) {
      return this.service.collection.addGroup(data2);
    }
    addTorrentCollectionToGroup(options2) {
      return this.service.collection.addToGroup(options2.item, options2.groupId);
    }
    updateTorrentCollectionGroup(data2) {
      return this.service.collection.updateGroup(data2);
    }
    removeTorrentCollectionFromGroup(options2) {
      return this.service.collection.removeFromGroup(
        options2.item,
        options2.groupId
      );
    }
    removeTorrentCollectionGroup(data2) {
      return this.service.collection.removeGroup(data2);
    }
    updateTorrentCollention(data2) {
      return this.service.collection.update(data2);
    }
    getAllTorrentCollectionLinks() {
      return new Promise((resolve2, reject2) => {
        const result2 = this.service.collection.getAllLinks();
        if (result2) {
          resolve2(result2);
        } else {
          reject2(false);
        }
      });
    }
    restoreCookies(data2) {
      return this.service.config.restoreCookies(data2);
    }
    resetFavicons() {
      this.service.config.favicon.clear();
      return this.service.config.getFavicons();
    }
    resetFavicon(url2) {
      return this.service.config.getFavicon(url2, true);
    }
    getBackupRawData() {
      return this.service.config.getBackupRawData();
    }
    testBackupServerConnectivity(options2) {
      return this.service.config.testBackupServerConnectivity(options2);
    }
    createSearchResultSnapshot(options2) {
      return this.service.searchResultSnapshot.add(options2);
    }
    getSearchResultSnapshot(id) {
      return this.service.searchResultSnapshot.get(id);
    }
    loadSearchResultSnapshot() {
      return this.service.searchResultSnapshot.load();
    }
    removeSearchResultSnapshot(options2) {
      return this.service.searchResultSnapshot.remove(options2);
    }
    clearSearchResultSnapshot() {
      return this.service.searchResultSnapshot.clear();
    }
    resetSearchResultSnapshot(datas) {
      return this.service.searchResultSnapshot.reset(datas);
    }
    createKeepUploadTask(options2) {
      return this.service.keepUploadTask.add(options2);
    }
    getKeepUploadTask(id) {
      return this.service.keepUploadTask.get(id);
    }
    loadKeepUploadTask() {
      return this.service.keepUploadTask.load();
    }
    removeKeepUploadTask(options2) {
      return this.service.keepUploadTask.remove(options2);
    }
    clearKeepUploadTask() {
      return this.service.keepUploadTask.clear();
    }
    resetKeepUploadTask(datas) {
      return this.service.keepUploadTask.reset(datas);
    }
    updateKeepUploadTask(options2) {
      return this.service.keepUploadTask.update(options2);
    }
    updateDebuggerTabId(id) {
      return new Promise((resolve2, reject2) => {
        this.debuggerTabId = id;
        this.debuggerPort = chrome.tabs.connect(id, {
          name: EModule.debugger
        });
        resolve2();
      });
    }
    pushDebugMsg(msg) {
      return new Promise((resolve2, reject2) => {
        console.log(msg);
        if (this.debuggerTabId) {
          chrome.tabs.get(this.debuggerTabId, (tab) => {
            if (tab && this.debuggerPort) {
              this.debuggerPort.postMessage({
                action: EAction.pushDebugMsg,
                data: msg
              });
            }
            if (chrome.runtime.lastError) {
              console.log(chrome.runtime.lastError.message);
              this.debuggerTabId = 0;
              this.debuggerPort = void 0;
            }
          });
        }
        resolve2();
      });
    }
    getTopSearches(count = 9) {
      return this.movieInfoService.getTopSearches(count);
    }
  }
  let Logger$1 = class Logger {
    constructor() {
      this.maxLength = 1e3;
      this.items = [];
      this.storage = new localStorage();
      this.configKey = EConfigKey.systemLogs;
      this.load();
    }
    /**
     * 获取记录
     */
    load() {
      return new Promise((resolve2, reject2) => {
        this.storage.get(this.configKey, (result2) => {
          this.items = result2 || [];
          resolve2(this.items);
        });
      });
    }
    /**
     * 添加日志
     * @param data 日志信息
     */
    add(data2) {
      let time = (/* @__PURE__ */ new Date()).getTime();
      let saveData = Object.assign(
        {
          module: "",
          time,
          id: PPF.getNewId()
        },
        data2
      );
      if (!this.items) {
        this.load().then(() => {
          this.items.push(saveData);
          this.storage.set(this.configKey, this.items);
        });
      } else {
        if (this.items.length >= this.maxLength) {
          this.items.splice(0, 1);
        }
        this.items.push(saveData);
        this.storage.set(this.configKey, this.items);
      }
      return saveData.id;
    }
    /**
     * 删除历史记录
     * @param items 需要删除的列表
     */
    remove(items) {
      return new Promise((resolve2, reject2) => {
        this.load().then(() => {
          for (let index2 = this.items.length - 1; index2 >= 0; index2--) {
            let item = this.items[index2];
            let findIndex = items.findIndex((data2) => {
              return data2.id === item.id;
            });
            if (findIndex >= 0) {
              this.items.splice(index2, 1);
            }
          }
          this.storage.set(this.configKey, this.items);
          resolve2(this.items);
        });
      });
    }
    /**
     * 清除记录
     */
    clear() {
      return new Promise((resolve2, reject2) => {
        this.items = [];
        this.storage.set(this.configKey, this.items);
        resolve2(this.items);
      });
    }
  };
  class PathHandler {
    constructor() {
    }
    /**
     * 替换路径系统关键字
     * 关键字列表：
     * site.name 站点名称
     * site.host 站点域名
     * YYYY 年份
     * MM 月份
     * DD 日期
     * @param {*} path
     */
    replacePathKey(path2, site2) {
      if (!path2) {
        return path2;
      }
      const now = /* @__PURE__ */ new Date();
      return this.replaceKeys(path2, {
        "site.name": site2.name,
        "site.host": site2.host,
        YYYY: now.getFullYear(),
        MM: ("0" + (now.getMonth() + 1).toString()).substr(-2),
        DD: ("0" + now.getDate().toString()).substr(-2)
      });
    }
    /**
     * 获取保存路径
     * @param {*} sourcePath
     */
    getSavePath(sourcePath, site2) {
      if (!sourcePath) {
        return void 0;
      }
      let path2 = sourcePath;
      let key2 = "<...>";
      if (path2) {
        if (path2.indexOf(key2) >= 0) {
          let tmp = window.prompt(
            `当前为自定义路径：${path2} 
请输入路径中 ${key2} 部分的内容: `
          );
          if (tmp === null) {
            return false;
          }
          path2 = path2.replace(key2, tmp);
        }
      }
      return this.replacePathKey(path2, site2);
    }
    replaceKeys(source2, keys) {
      let result2 = source2;
      for (const key2 in keys) {
        if (keys.hasOwnProperty(key2)) {
          const value = keys[key2];
          result2 = result2.replace("$" + key2 + "$", value);
        }
      }
      return result2;
    }
  }
  class ContextMenus {
    constructor(service) {
      this.service = service;
      this.options = {
        sites: [],
        clients: []
      };
      this.rootId = "PT-Plugin-Plugin-Content-Menu";
      this.currentTabId = 0;
      this.siteMenus = [];
      this.pathHandler = new PathHandler();
      chrome && chrome.tabs && this.initBrowserEvent();
    }
    /**
     * 初始化浏览器事件
     */
    initBrowserEvent() {
      chrome.tabs.onActivated.addListener(
        (actionInfo) => {
          chrome.tabs.get(actionInfo.tabId, (tab) => {
            this.clearSiteMenus();
            if (tab.url) {
              let host2 = new URLParse(tab.url).host;
              this.createSiteMenus(host2);
            }
          });
        }
      );
      chrome.tabs.onUpdated.addListener(
        (tabId, changeInfo, tab) => {
          this.clearSiteMenus();
          if (tab.url) {
            let host2 = new URLParse(tab.url).host;
            this.createSiteMenus(host2);
          }
        }
      );
      chrome.browserAction.onClicked.addListener(() => {
        this.service.controller.openOptions();
      });
    }
    /**
     * 初始化上下文菜单
     * @param options Options 参数
     * @param service 后台服务
     */
    init(options2) {
      this.options = options2;
      this.clear();
      this.createSearchMenus();
      this.createClientMenus();
      this.createPluginIconPopupMenus();
    }
    /**
     * 创建插件图标右键菜单
     */
    createPluginIconPopupMenus() {
      this.add({
        title: this.service.i18n.t("service.contextMenus.history"),
        contexts: ["browser_action"],
        onclick: () => {
          chrome.tabs.create({
            url: "index.html#/history"
          });
        }
      });
      this.add({
        title: this.service.i18n.t("service.contextMenus.systemLog"),
        contexts: ["browser_action"],
        onclick: () => {
          chrome.tabs.create({
            url: "index.html#/system-logs"
          });
        }
      });
      this.add({
        type: "separator",
        contexts: ["browser_action"]
      });
      this.add({
        title: this.service.i18n.t("service.contextMenus.issues"),
        contexts: ["browser_action"],
        onclick: () => {
          chrome.tabs.create({
            url: "https://github.com/pt-plugins/PT-Plugin-Plus/issues/new"
          });
        }
      });
    }
    /**
     * 清除菜单
     */
    clear() {
      chrome && chrome.contextMenus && chrome.contextMenus.removeAll();
    }
    /**
     * 清除站点的上下文菜单
     */
    clearSiteMenus() {
      this.siteMenus.forEach((item) => {
        this.remove(item);
      });
      this.siteMenus = [];
    }
    /**
     * 获取指定站点的URL匹配规则
     * @param site
     */
    getSiteDocumentUrlPatterns(site2) {
      let url2 = site2.url + "";
      if (url2.substr(-1) != "/") {
        url2 += "/";
      }
      let documentUrlPatterns = [`*://${site2.host}/*`, `${url2}`];
      if (site2.cdn && site2.cdn.length > 0) {
        for (let i2 = 0; i2 < site2.cdn.length; i2++) {
          const url3 = site2.cdn[i2];
          documentUrlPatterns.push(`${url3}${url3.substr(-1) != "/" ? "/*" : "*"}`, url3);
        }
      }
      return documentUrlPatterns;
    }
    /**
     * 根据指定的目录信息创建菜单
     * @param paths
     * @param site
     * @param client
     * @param parentId
     */
    createPathMenus(paths, site2, client2, parentId) {
      paths.forEach((path2, index2) => {
        let id = `${client2.id}**${site2.host}**${path2}**${index2}`;
        this.add({
          id,
          title: this.pathHandler.replacePathKey(path2, site2),
          parentId,
          contexts: ["link"],
          documentUrlPatterns: this.getSiteDocumentUrlPatterns(site2),
          targetUrlPatterns: this.getSiteUrlPatterns(site2),
          onclick: (info, tab) => {
            let data2 = info.menuItemId.split("**");
            let options2 = {
              clientId: data2[0],
              url: info.linkUrl,
              savePath: data2[2]
            };
            this.sendTorrentToClient(tab.id, options2);
          }
        });
      });
    }
    /**
     * 创建站点上下文菜单
     */
    createSiteMenus(host2) {
      let site2 = this.options.sites.find((item) => {
        let cdn = [item.url].concat(item.cdn);
        return item.host === host2 || cdn.join("|").indexOf(host2) > -1;
      });
      if (!site2) {
        return;
      }
      if (this.options.allowSelectionTextSearch) {
        let menuId = site2.host;
        this.siteMenus.push(menuId);
        this.add({
          id: menuId,
          title: this.service.i18n.t(
            "service.contextMenus.searchSelectionTextOnThisSite"
          ),
          contexts: ["selection"],
          documentUrlPatterns: this.getSiteDocumentUrlPatterns(site2),
          onclick: (info, tab) => {
            this.service.controller.searchTorrent(info.selectionText, host2);
          }
        });
      }
      this.options.clients.forEach((client2) => {
        if (client2.paths) {
          let parentId = `${client2.id}-path`;
          let count = 0;
          this.add({
            id: parentId,
            title: this.service.i18n.t(
              "service.contextMenus.downloadClientPath",
              {
                clientName: client2.name
              }
            ),
            contexts: ["link"],
            documentUrlPatterns: this.getSiteDocumentUrlPatterns(site2),
            targetUrlPatterns: this.getSiteUrlPatterns(site2)
          });
          for (const host22 in client2.paths) {
            let paths = client2.paths[host22];
            if (host22 !== site2.host) {
              continue;
            }
            count++;
            this.createPathMenus(paths, site2, client2, parentId);
          }
          let publicPaths = client2.paths[ECommonKey.allSite];
          if (publicPaths) {
            count++;
            this.createPathMenus(publicPaths, site2, client2, parentId);
          }
          if (count > 0) {
            this.siteMenus.push(parentId);
          } else {
            this.remove(parentId);
          }
        }
      });
    }
    /**
     * 获取指定站点的配置种子链接规则
     * @param site
     */
    getSiteUrlPatterns(site2) {
      let result2 = [];
      if (site2.patterns && site2.patterns["torrentLinks"]) {
        result2 = site2.patterns["torrentLinks"];
      } else {
        let schema2 = this.getSiteSchema(site2);
        if (schema2 && schema2.patterns && schema2.patterns["torrentLinks"]) {
          result2 = schema2.patterns["torrentLinks"];
        } else {
          result2.push("*://*/*");
        }
      }
      return result2;
    }
    /**
     * 根据指定的站点获取站点的架构信息
     * @param site 站点信息
     */
    getSiteSchema(site2) {
      let schema2 = {};
      if (typeof site2.schema === "string") {
        schema2 = this.options.system && this.options.system.schemas && this.options.system.schemas.find((item) => {
          return item.name == site2.schema;
        });
      }
      return schema2;
    }
    /**
     * 发送种子到指定的服务器
     * @param tabid
     * @param options
     */
    sendTorrentToClient(tabid = 0, options2) {
      console.log("sendTorrentToClient", options2);
      let site2 = this.getSiteFromURL(options2.url);
      if (site2 && options2.savePath) {
        let savePath = this.pathHandler.getSavePath(options2.savePath, site2);
        if (savePath === false) {
          APP.showNotifications({
            message: this.service.i18n.t("service.contextMenus.userCanceled")
          });
          return;
        }
        options2.savePath = savePath;
      }
      let notice;
      try {
        chrome.tabs.sendMessage(
          tabid,
          {
            action: EAction.showMessage,
            data: {
              type: EDataResultType.info,
              msg: this.service.i18n.t("service.contextMenus.sendingLink"),
              timeout: 2,
              indeterminate: true
            }
          },
          (result2) => {
            if (chrome.runtime.lastError) {
              let message = chrome.runtime.lastError.message || "";
              if (message.match(/Could not establish connection/)) {
                APP.showNotifications({
                  message: this.service.i18n.t(
                    "service.contextMenus.pluginStatusIsUnknown"
                  )
                });
              } else {
                APP.showNotifications({
                  message: chrome.runtime.lastError.message
                });
              }
              return;
            }
            notice = result2;
          }
        );
      } catch (error) {
        APP.showNotifications({
          message: error
        });
        return;
      }
      this.service.logger.add({
        module: EModule.background,
        event: "contextMenus.sendTorrentToClient.begin",
        msg: this.service.i18n.t("service.contextMenus.sendingLink"),
        data: options2
      });
      let client2 = this.options.clients.find((item) => {
        return item.id === options2.clientId;
      });
      if (!client2) {
        chrome.tabs.sendMessage(tabid, {
          action: EAction.showMessage,
          data: {
            type: EDataResultType.error,
            msg: this.service.i18n.t(
              "service.contextMenus.downloadClientGetFailed"
            )
          }
        });
        this.service.logger.add({
          module: EModule.background,
          event: "contextMenus.sendTorrentToClient.getClientError",
          msg: this.service.i18n.t(
            "service.contextMenus.downloadClientGetFailed"
          ),
          data: options2
        });
        this.hideNotice(tabid, notice);
        return;
      }
      options2.autoStart = client2.autoStart;
      console.log(options2);
      let url2 = this.getParsedURL(options2.url);
      if (typeof url2 !== "string") {
        chrome.tabs.sendMessage(tabid, {
          action: EAction.showMessage,
          data: url2
        });
        this.hideNotice(tabid, notice);
        return;
      }
      options2.url = url2;
      this.service.controller.sendTorrentToClient(options2).then((result2) => {
        this.service.logger.add({
          module: EModule.background,
          event: "contextMenus.sendTorrentToClient.done",
          msg: this.service.i18n.t(
            "service.contextMenus.sendTorrentToClientDone"
          ),
          // "下载链接发送完成。",
          data: result2
        });
        chrome.tabs.sendMessage(tabid, {
          action: EAction.showMessage,
          data: result2
        });
      }).catch((result2) => {
        this.service.logger.add({
          module: EModule.background,
          event: "contextMenus.sendTorrentToClient.error",
          msg: this.service.i18n.t(
            "service.contextMenus.sendTorrentToClientError"
          ),
          // "下载链接发送失败！",
          data: result2
        });
        chrome.tabs.sendMessage(tabid, {
          action: EAction.showMessage,
          data: result2.status == "" ? this.service.i18n.t("service.contextMenus.sendTorrentToClientError") : result2
        });
      }).finally(() => {
        this.hideNotice(tabid, notice);
      });
    }
    /**
     * 隐藏指定的 notice
     * @param tabid
     * @param notice
     */
    hideNotice(tabid = 0, notice) {
      if (!notice)
        return;
      if (notice.id) {
        chrome.tabs.sendMessage(tabid, {
          action: EAction.hideMessage,
          data: notice.id
        });
      } else if (notice.hide) {
        notice.hide();
      }
    }
    /**
     * 创建关键字搜索菜单，所有页面可用
     */
    createSearchMenus() {
      if (this.options.allowSelectionTextSearch) {
        this.add({
          title: this.service.i18n.t("service.contextMenus.searchSelectionText"),
          // '搜索 "%s" 相关的种子',
          contexts: ["selection"],
          onclick: (info, tab) => {
            this.service.controller.searchTorrent(info.selectionText);
          }
        });
        this.pushMoreSearchMenus();
      }
      let imdbMenuId = "searchWithIMDb";
      this.add({
        id: imdbMenuId,
        title: this.service.i18n.t("service.contextMenus.searchByIMDb"),
        // "搜索当前IMDb相关种子",
        contexts: ["link"],
        targetUrlPatterns: ["*://www.imdb.com/title/tt*"]
      });
      this.add({
        parentId: imdbMenuId,
        title: this.service.i18n.t("service.contextMenus.searchByDefault"),
        // "搜索当前IMDb相关种子",
        contexts: ["link"],
        targetUrlPatterns: ["*://www.imdb.com/title/tt*"],
        onclick: (info, tab) => {
          if (info.linkUrl) {
            let link = info.linkUrl.match(/(tt\d+)/);
            if (link && link.length >= 2) {
              this.service.controller.searchTorrent(link[1]);
            }
          }
        }
      });
      this.pushMoreSearchMenus(
        imdbMenuId,
        ["link"],
        ["*://www.imdb.com/title/tt*"],
        /(tt\d+)/
      );
      let donbanMenuId = "searchWithDouban";
      this.add({
        id: donbanMenuId,
        title: this.service.i18n.t("service.contextMenus.searchByDouban"),
        contexts: ["link"],
        targetUrlPatterns: ["*://movie.douban.com/subject/*"]
      });
      this.add({
        parentId: donbanMenuId,
        title: this.service.i18n.t("service.contextMenus.searchByDefault"),
        contexts: ["link"],
        targetUrlPatterns: ["*://movie.douban.com/subject/*"],
        onclick: (info, tab) => {
          if (info.linkUrl) {
            let link = info.linkUrl.match(/subject\/(\d+)/);
            if (link && link.length >= 2) {
              this.service.controller.searchTorrent("douban" + link[1]);
            }
          }
        }
      });
      this.pushMoreSearchMenus(
        donbanMenuId,
        ["link"],
        ["*://movie.douban.com/subject/*"],
        /subject\/(\d+)/,
        "douban"
      );
    }
    /**
     * 添加更多搜索相关菜单
     * @param _parentId
     * @param contexts
     * @param targetUrlPatterns
     * @param match
     * @param keyPrefix
     */
    pushMoreSearchMenus(_parentId = void 0, contexts = ["selection"], targetUrlPatterns = void 0, match = /(tt\d+)/, keyPrefix = "") {
      const sites = this.options.sites;
      if (sites && sites.length > 0) {
        let parentId = `${_parentId}searchInSite`;
        this.add({
          id: parentId,
          title: this.service.i18n.t("service.contextMenus.searchInSite"),
          contexts,
          parentId: _parentId,
          targetUrlPatterns
        });
        sites.forEach((site2) => {
          let id = `${parentId}**${site2.host}`;
          this.add({
            id,
            title: `${site2.name} - ${site2.host}`,
            parentId,
            contexts,
            targetUrlPatterns,
            onclick: (info, tab) => {
              let data2 = info.menuItemId.split("**");
              this.service.debug(
                this.service.i18n.t("service.contextMenus.searchInSite"),
                info
              );
              if (contexts.includes("link") && info.linkUrl) {
                let link = info.linkUrl.match(match);
                if (link && link.length >= 2) {
                  this.service.controller.searchTorrent(
                    keyPrefix + link[1],
                    data2[1]
                  );
                }
              } else {
                this.service.controller.searchTorrent(
                  info.selectionText,
                  data2[1]
                );
              }
            }
          });
        });
      }
      const solutions = this.options.searchSolutions;
      if (solutions && solutions.length > 0) {
        let parentId = `${_parentId}searchInSolution`;
        this.add({
          id: parentId,
          title: this.service.i18n.t("service.contextMenus.searchInSolution"),
          contexts,
          parentId: _parentId,
          targetUrlPatterns
        });
        solutions.forEach((item) => {
          let id = `${parentId}**${item.id}`;
          this.add({
            id,
            title: `${item.name}`,
            parentId,
            contexts,
            targetUrlPatterns,
            onclick: (info, tab) => {
              this.service.debug(
                this.service.i18n.t("service.contextMenus.searchInSolution"),
                info
              );
              let data2 = info.menuItemId.split("**");
              if (contexts.includes("link") && info.linkUrl) {
                let link = info.linkUrl.match(match);
                if (link && link.length >= 2) {
                  this.service.controller.searchTorrent(
                    keyPrefix + link[1],
                    data2[1]
                  );
                }
              } else {
                this.service.controller.searchTorrent(
                  info.selectionText,
                  data2[1]
                );
              }
            }
          });
        });
      }
      this.add({
        title: this.service.i18n.t("service.contextMenus.searchInAllSite"),
        parentId: _parentId,
        contexts,
        targetUrlPatterns,
        onclick: (info, tab) => {
          if (info.linkUrl) {
            let link = info.linkUrl.match(match);
            if (contexts.includes("link") && link && link.length >= 2) {
              this.service.controller.searchTorrent(keyPrefix + link[1], "all");
            }
          } else {
            this.service.controller.searchTorrent(info.selectionText, "all");
          }
        }
      });
    }
    /**
     * 创建下载客户端上下文菜单，所有页面可用
     */
    createClientMenus() {
      let clients = this.options.clients.filter((c2) => c2.enabled !== false);
      console.log("createClientMenus", this.options.clients);
      console.log("createClientMenus", clients);
      if (this.options.defaultClientId) {
        let client2 = this.options.clients.find((item) => {
          return item.id === this.options.defaultClientId;
        });
        if (client2) {
          this.add({
            id: client2.id,
            title: this.service.i18n.t(
              "service.contextMenus.sendTorrentToDefaultClient",
              {
                client: client2
              }
            ),
            // `发送到默认服务器 ${client.name} -> ${client.address}`,
            contexts: ["link"],
            onclick: (info, tab) => {
              this.sendTorrentToClient(tab.id, {
                clientId: info.menuItemId,
                url: info.linkUrl
              });
            }
          });
        }
      }
      if (clients.length > 1) {
        this.add({
          id: this.rootId,
          title: this.service.i18n.t("service.contextMenus.sendTorrentToClient"),
          // "发送到其他服务器",
          contexts: ["link"]
        });
        clients.forEach((client2) => {
          if (client2.id !== this.options.defaultClientId) {
            this.add({
              id: client2.id,
              title: `${client2.name} -> ${client2.address}`,
              parentId: this.rootId,
              contexts: ["link"],
              onclick: (info, tab) => {
                this.sendTorrentToClient(tab.id, {
                  clientId: info.menuItemId,
                  url: info.linkUrl
                });
              }
            });
          }
        });
      }
    }
    /**
     * 向浏览器添加上下文菜单
     * @param options 菜单选项
     * @param callback 回调
     */
    add(options2, callback) {
      if (!options2.id) {
        options2.id = this.getRandomString();
      }
      chrome && chrome.contextMenus && chrome.contextMenus.create(options2, callback);
    }
    /**
     * 从浏览器中删除指定的菜单
     * @param id 菜单ID
     * @param callback 回调
     */
    remove(id, callback) {
      try {
        chrome.contextMenus.remove(id, callback);
        if (chrome.runtime.lastError) {
          console.log(chrome.runtime.lastError);
        }
      } catch (error) {
        console.log(error);
      }
    }
    /**
     * 获取随机字符串
     * @param  {number} length    [长度，默认为16]
     * @param  {boolean} noSimilar [是否包含容易混淆的字符，默认为包含]
     * @return {string}           [返回的内容]
     */
    getRandomString(length = 16, noSimilar = true) {
      let chars2 = noSimilar ? "abcdefhijkmnprstwxyz2345678ABCDEFGHJKMNPQRSTWXYZ" : "abcdefghijkmnopqrstuvwxyz0123456789ABCDEFGHIJKMNOPQRSTUVWXYZ";
      let maxLength = chars2.length;
      let result2 = [];
      for (let i2 = 0; i2 < length; i2++) {
        result2.push(chars2.charAt(Math.floor(Math.random() * maxLength)));
      }
      return result2.join("");
    }
    /**
     * 获取解析过的地址
     * @param source
     */
    getParsedURL(source) {
      let url = new URLParse(source);
      let site = this.getSiteFromURL(source);
      if (!site) {
        return source;
      }
      let options = {
        url,
        site,
        result: source,
        error: {}
      };
      let parser = this.getSiteParser(site.host, "downloadURL");
      if (parser) {
        try {
          eval(parser);
        } catch (error) {
          console.error(error);
        }
      }
      if (options.error && options.error.msg) {
        return options.error;
      }
      return options.result;
    }
    /**
     * 获取指定解析器
     * @param host
     * @param name
     */
    getSiteParser(host2, name2) {
      let site2 = this.options.system && this.options.system.sites && this.options.system.sites.find((item) => {
        return item.host === host2;
      });
      if (!site2) {
        return "";
      }
      let result2 = site2.parser && site2.parser[name2];
      if (!result2) {
        let schema2 = this.options.system && this.options.system.schemas && this.options.system.schemas.find((item) => {
          return item.name === site2.schema;
        });
        if (schema2 && schema2.parser) {
          result2 = schema2.parser[name2];
        }
      }
      return result2;
    }
    /**
     * 根据指定的URL获取站点信息
     * @param source
     */
    getSiteFromURL(source2) {
      let url2 = new URLParse(source2);
      if (!url2.host) {
        return null;
      }
      let site2 = this.options.sites.find((item) => {
        let cdn = [item.url].concat(item.cdn);
        return item.host == url2.host || cdn.join("").indexOf(url2.host) > -1;
      });
      if (!site2) {
        return null;
      }
      return site2;
    }
  }
  class UserData {
    constructor(service) {
      this.service = service;
      this.items = null;
      this.storage = new localStorage();
      this.configKey = EConfigKey.userDatas;
      this.load();
    }
    /**
     * 获取记录
     */
    load() {
      return new Promise((resolve2, reject2) => {
        this.storage.get(this.configKey, (result2) => {
          console.log("UserData.load", result2);
          this.items = result2 || {};
          resolve2(this.items);
        });
      });
    }
    /**
     * 获取指定站点的数据
     * @param host
     * @param range
     */
    get(host2, range = EUserDataRange.latest) {
      if (!this.items) {
        return null;
      }
      if (!host2) {
        return this.items;
      }
      let datas = this.items[host2];
      if (!datas) {
        return null;
      }
      switch (range) {
        case EUserDataRange.all:
          return datas;
        case EUserDataRange.today:
          return datas[PPF.getToDay()];
      }
      return datas[EUserDataRange.latest];
    }
    /**
     * 更新用户数据
     * @param site 站点信息
     * @param data 用户数据
     */
    update(site2, data2) {
      const host2 = site2.host;
      if (!host2) {
        return;
      }
      const saveData = Object.assign({}, data2);
      if (this.items == null) {
        this.load().then(() => {
          this.update(site2, data2);
        });
      } else {
        let siteData = this.items[host2];
        let key2 = PPF.getToDay();
        if (!siteData) {
          siteData = {};
        }
        siteData[key2] = saveData;
        siteData[EUserDataRange.latest] = saveData;
        this.items[host2] = siteData;
        this.storage.set(this.configKey, this.items).then(() => {
          this.service.saveUserData();
        });
      }
    }
    /**
     * 清除记录
     */
    clear() {
      return new Promise((resolve2, reject2) => {
        this.items = {};
        this.storage.set(this.configKey, th